import { jsx, jsxs } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useMemo } from 'react';
import { t } from '@grafana/i18n';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Button } from '../Button/Button.mjs';
import { Icon } from '../Icon/Icon.mjs';

const Pagination = ({
  currentPage,
  numberOfPages,
  onNavigate,
  hideWhenSinglePage,
  showSmallVersion,
  className
}) => {
  const styles = useStyles2(getStyles);
  const pageLengthToCondense = showSmallVersion ? 1 : 8;
  const pageButtons = useMemo(() => {
    const pages = [...new Array(numberOfPages).keys()];
    const condensePages = numberOfPages > pageLengthToCondense;
    const getListItem = (page, variant) => /* @__PURE__ */ jsx("li", { className: styles.item, children: /* @__PURE__ */ jsx(Button, { size: "sm", variant, onClick: () => onNavigate(page), children: page }) }, page);
    return pages.reduce((pagesToRender, pageIndex) => {
      const page = pageIndex + 1;
      const variant = page === currentPage ? "primary" : "secondary";
      const lowerBoundIndex = pageLengthToCondense;
      const upperBoundIndex = numberOfPages - pageLengthToCondense + 1;
      const differenceOfBounds = upperBoundIndex - lowerBoundIndex;
      const isFirstOrLastPage = page === 1 || page === numberOfPages;
      const currentPageIsBetweenBounds = differenceOfBounds > -1 && currentPage >= lowerBoundIndex && currentPage <= upperBoundIndex;
      const ellipsisOffset = showSmallVersion ? 1 : 3;
      const pageOffset = showSmallVersion ? 0 : 2;
      if (condensePages) {
        if (isFirstOrLastPage || currentPage < lowerBoundIndex && page < lowerBoundIndex || differenceOfBounds >= 0 && currentPage > upperBoundIndex && page > upperBoundIndex || differenceOfBounds < 0 && currentPage >= lowerBoundIndex && page > upperBoundIndex || currentPageIsBetweenBounds && page >= currentPage - pageOffset && page <= currentPage + pageOffset) {
          pagesToRender.push(getListItem(page, variant));
        } else if (page === lowerBoundIndex && currentPage < lowerBoundIndex || page === upperBoundIndex && currentPage > upperBoundIndex || currentPageIsBetweenBounds && (page === currentPage - ellipsisOffset || page === currentPage + ellipsisOffset)) {
          pagesToRender.push(
            /* @__PURE__ */ jsx("li", { className: styles.item, children: /* @__PURE__ */ jsx(Icon, { className: styles.ellipsis, name: "ellipsis-v", "data-testid": "pagination-ellipsis-icon" }) }, page)
          );
        }
      } else {
        pagesToRender.push(getListItem(page, variant));
      }
      return pagesToRender;
    }, []);
  }, [currentPage, numberOfPages, onNavigate, pageLengthToCondense, showSmallVersion, styles.ellipsis, styles.item]);
  if (hideWhenSinglePage && numberOfPages <= 1) {
    return null;
  }
  const previousPageLabel = t("grafana-ui.pagination.previous-page", "previous page");
  const nextPageLabel = t("grafana-ui.pagination.next-page", "next page");
  return /* @__PURE__ */ jsx("div", { className: cx(styles.container, className), role: "navigation", children: /* @__PURE__ */ jsxs("ol", { children: [
    /* @__PURE__ */ jsx("li", { className: styles.item, children: /* @__PURE__ */ jsx(
      Button,
      {
        "aria-label": previousPageLabel,
        size: "sm",
        variant: "secondary",
        onClick: () => onNavigate(currentPage - 1),
        disabled: currentPage === 1,
        children: /* @__PURE__ */ jsx(Icon, { name: "angle-left" })
      }
    ) }),
    pageButtons,
    /* @__PURE__ */ jsx("li", { className: styles.item, children: /* @__PURE__ */ jsx(
      Button,
      {
        "aria-label": nextPageLabel,
        size: "sm",
        variant: "secondary",
        onClick: () => onNavigate(currentPage + 1),
        disabled: currentPage === numberOfPages,
        children: /* @__PURE__ */ jsx(Icon, { name: "angle-right" })
      }
    ) })
  ] }) });
};
const getStyles = () => {
  return {
    container: css({
      float: "right"
    }),
    item: css({
      display: "inline-block",
      paddingLeft: "10px",
      marginBottom: "5px"
    }),
    ellipsis: css({
      transform: "rotate(90deg)"
    })
  };
};

export { Pagination };
//# sourceMappingURL=Pagination.mjs.map
