import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

function MenuDivider() {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: styles.divider });
}
const getStyles = (theme) => {
  return {
    divider: css({
      height: 1,
      backgroundColor: theme.colors.border.weak,
      margin: theme.spacing(0.5, 0)
    })
  };
};

export { MenuDivider };
//# sourceMappingURL=MenuDivider.mjs.map
