import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { t } from '@grafana/i18n';
import { IconButton } from '../../IconButton/IconButton.mjs';

const expanderContainerStyles = css({
  display: "flex",
  alignItems: "center",
  height: "100%"
});
function ExpanderCell({ row, __rowID }) {
  return /* @__PURE__ */ jsx("div", { className: expanderContainerStyles, children: /* @__PURE__ */ jsx(
    IconButton,
    {
      tooltip: t("grafana-ui.interactive-table.expand-row-tooltip", "Toggle row expanded"),
      "aria-controls": __rowID,
      name: row.isExpanded ? "angle-down" : "angle-right",
      "aria-expanded": row.isExpanded,
      ...row.getToggleRowExpandedProps(),
      size: "lg"
    }
  ) });
}
function ExpanderHeader({ isAllRowsExpanded, toggleAllRowsExpanded }) {
  return /* @__PURE__ */ jsx("div", { className: expanderContainerStyles, children: /* @__PURE__ */ jsx(
    IconButton,
    {
      "aria-label": !isAllRowsExpanded ? t("grafana-ui.interactive-table.aria-label-expand-all", "Expand all rows") : t("grafana-ui.interactive-table.aria-label-collapse-all", "Collapse all rows"),
      name: !isAllRowsExpanded ? "table-expand-all" : "table-collapse-all",
      onClick: () => toggleAllRowsExpanded(),
      size: "lg",
      tooltip: !isAllRowsExpanded ? t("grafana-ui.interactive-table.tooltip-expand-all", "Expand all rows") : t("grafana-ui.interactive-table.tooltip-collapse-all", "Collapse all rows"),
      variant: "secondary"
    }
  ) });
}

export { ExpanderCell, ExpanderHeader };
//# sourceMappingURL=index.mjs.map
