import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { PureComponent } from 'react';
import { withTheme2 } from '../../../../themes/ThemeContext.mjs';
import { stylesFactory } from '../../../../themes/stylesFactory.mjs';
import { Icon } from '../../../Icon/Icon.mjs';

const getSelectOptionGroupStyles = stylesFactory((theme) => {
  return {
    header: css({
      display: "flex",
      alignItems: "center",
      justifyContent: "flex-start",
      justifyItems: "center",
      cursor: "pointer",
      padding: "7px 10px",
      width: "100%",
      borderBottom: `1px solid ${theme.colors.background.secondary}`,
      "&:hover": {
        color: theme.colors.text.maxContrast
      }
    }),
    label: css({
      flexGrow: 1
    }),
    icon: css({
      paddingRight: "2px"
    })
  };
});
class UnthemedSelectOptionGroup extends PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      expanded: false
    };
    this.onToggleChildren = () => {
      this.setState((prevState) => ({
        expanded: !prevState.expanded
      }));
    };
  }
  componentDidMount() {
    if (this.props.data.expanded) {
      this.setState({ expanded: true });
    } else if (this.props.selectProps && this.props.selectProps.value) {
      const { value } = this.props.selectProps.value;
      if (value && this.props.options.some((option) => option.value === value)) {
        this.setState({ expanded: true });
      }
    }
  }
  componentDidUpdate(nextProps) {
    if (nextProps.selectProps.inputValue !== "") {
      this.setState({ expanded: true });
    }
  }
  render() {
    const { children, label, theme } = this.props;
    const { expanded } = this.state;
    const styles = getSelectOptionGroupStyles(theme);
    return /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsxs("div", { className: styles.header, onClick: this.onToggleChildren, role: "presentation", children: [
        /* @__PURE__ */ jsx("span", { className: styles.label, children: label }),
        /* @__PURE__ */ jsx(Icon, { className: styles.icon, name: expanded ? "angle-up" : "angle-down" })
      ] }),
      expanded && children
    ] });
  }
}
const SelectOptionGroup = withTheme2(UnthemedSelectOptionGroup);

export { SelectOptionGroup };
//# sourceMappingURL=SelectOptionGroup.mjs.map
