import { jsx } from 'react/jsx-runtime';
import { createContext, useState, useMemo, useContext, useEffect } from 'react';

const TimeRangeContext = createContext(void 0);
function TimeRangeProvider({ children }) {
  const [pickersCount, setPickersCount] = useState(0);
  const [syncedValue, setSyncedValue] = useState();
  const contextVal = useMemo(() => {
    return {
      sync: (value) => setSyncedValue(value),
      unSync: () => setSyncedValue(void 0),
      addPicker: () => setPickersCount((val) => val + 1),
      removePicker: () => {
        setPickersCount((val) => {
          const newVal = val - 1;
          if (newVal < 2) {
            setSyncedValue(void 0);
          }
          return newVal;
        });
      },
      syncPossible: pickersCount > 1,
      synced: Boolean(syncedValue),
      syncedValue
    };
  }, [pickersCount, syncedValue]);
  return /* @__PURE__ */ jsx(TimeRangeContext.Provider, { value: contextVal, children });
}
function useTimeRangeContext(initialSyncValue) {
  const context = useContext(TimeRangeContext);
  useEffect(() => {
    if (context) {
      context.addPicker();
      if (initialSyncValue) {
        context.sync(initialSyncValue);
      }
      return () => {
        context.removePicker();
      };
    }
    return () => {
    };
  }, []);
  return useMemo(() => {
    if (!context) {
      return context;
    }
    return {
      sync: context.sync,
      unSync: context.unSync,
      syncPossible: context.syncPossible,
      synced: context.synced,
      syncedValue: context.syncedValue
    };
  }, [context]);
}

export { TimeRangeProvider, useTimeRangeContext };
//# sourceMappingURL=TimeRangeContext.mjs.map
