import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import * as React from 'react';
import { useRef, useMemo, createElement } from 'react';
import { cx, css } from '@emotion/css';
import { groupBy, capitalize } from 'lodash';
import { useClickAway } from 'react-use';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { List } from '../List/List.mjs';

const getStyles = (theme) => {
  return {
    list: css({
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      "&:last-child": {
        border: "none"
      }
    }),
    wrapper: css({
      background: theme.colors.background.primary,
      width: "250px"
    }),
    item: css({
      background: "none",
      padding: "2px 8px",
      userSelect: "none",
      color: theme.colors.text.primary,
      cursor: "pointer",
      "&:hover": {
        background: theme.colors.action.hover
      }
    }),
    label: css({
      color: theme.colors.text.secondary
    }),
    activeItem: css({
      background: theme.colors.background.secondary,
      "&:hover": {
        background: theme.colors.background.secondary
      }
    }),
    itemValue: css({
      fontFamily: theme.typography.fontFamilyMonospace,
      fontSize: theme.typography.size.sm
    })
  };
};
const DataLinkSuggestions = ({ suggestions, ...otherProps }) => {
  const ref = useRef(null);
  useClickAway(ref, () => {
    if (otherProps.onClose) {
      otherProps.onClose();
    }
  });
  const groupedSuggestions = useMemo(() => {
    return groupBy(suggestions, (s) => s.origin);
  }, [suggestions]);
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { role: "menu", ref, className: styles.wrapper, children: Object.keys(groupedSuggestions).map((key, i) => {
    const indexOffset = i === 0 ? 0 : Object.keys(groupedSuggestions).reduce((acc, current, index) => {
      if (index >= i) {
        return acc;
      }
      return acc + groupedSuggestions[current].length;
    }, 0);
    return /* @__PURE__ */ createElement(
      DataLinkSuggestionsList,
      {
        ...otherProps,
        suggestions: groupedSuggestions[key],
        label: capitalize(key),
        activeIndex: otherProps.activeIndex,
        activeIndexOffset: indexOffset,
        key
      }
    );
  }) });
};
DataLinkSuggestions.displayName = "DataLinkSuggestions";
const DataLinkSuggestionsList = React.memo(
  ({
    activeIndex,
    activeIndexOffset,
    label,
    onClose,
    onSuggestionSelect,
    suggestions,
    activeRef: selectedRef
  }) => {
    const styles = useStyles2(getStyles);
    return /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx(
      List,
      {
        className: styles.list,
        items: suggestions,
        renderItem: (item, index) => {
          const isActive = index + activeIndexOffset === activeIndex;
          return (
            // key events are handled by DataLinkInput
            // eslint-disable-next-line jsx-a11y/click-events-have-key-events
            /* @__PURE__ */ jsx(
              "div",
              {
                role: "menuitem",
                tabIndex: 0,
                className: cx(styles.item, isActive && styles.activeItem),
                ref: isActive ? selectedRef : void 0,
                onClick: () => {
                  onSuggestionSelect(item);
                },
                title: item.documentation,
                children: /* @__PURE__ */ jsxs("span", { className: styles.itemValue, children: [
                  /* @__PURE__ */ jsx("span", { className: styles.label, children: label }),
                  " ",
                  item.label
                ] })
              }
            )
          );
        }
      }
    ) });
  }
);
DataLinkSuggestionsList.displayName = "DataLinkSuggestionsList";

export { DataLinkSuggestions };
//# sourceMappingURL=DataLinkSuggestions.mjs.map
