import { AbstractQuery, AdHocVariableFilter, LanguageProvider, Scope, TimeRange } from '@grafana/data';
import { BackendSrvRequest } from '@grafana/runtime';
import { Label } from './components/monaco-query-field/monaco-completion-provider/situation';
import { PrometheusDatasource } from './datasource';
import { PromMetricsMetadata, PromQuery } from './types';
export interface PrometheusBaseLanguageProvider {
    datasource: PrometheusDatasource;
    /**
     * When no timeRange provided, we will use the default time range (now/now-6h)
     * @param timeRange
     */
    start: (timeRange?: TimeRange) => Promise<any[]>;
    request: (url: string, params?: any, options?: Partial<BackendSrvRequest>) => Promise<any>;
    fetchSuggestions: (timeRange?: TimeRange, queries?: PromQuery[], scopes?: Scope[], adhocFilters?: AdHocVariableFilter[], labelName?: string, limit?: number, requestId?: string) => Promise<string[]>;
}
/**
 * @deprecated This interface is deprecated and will be removed.
 */
export interface PrometheusLegacyLanguageProvider {
    /**
     * @deprecated Use retrieveHistogramMetrics() method instead
     */
    histogramMetrics: string[];
    /**
     * @deprecated Use retrieveMetrics() method instead
     */
    metrics: string[];
    /**
     * @deprecated Use retrieveMetricsMetadata() method instead
     */
    metricsMetadata?: PromMetricsMetadata;
    /**
     * @deprecated Use retrieveLabelKeys() method instead
     */
    labelKeys: string[];
    /**
     * @deprecated Use queryMetricsMetadata() method instead.
     */
    loadMetricsMetadata: () => void;
    /**
     * @deprecated Use retrieveMetricsMetadata() method instead
     */
    getLabelKeys: () => string[];
    /**
     * @deprecated If you need labelKeys or labelValues please use queryLabelKeys() or queryLabelValues() functions
     */
    getSeries: (timeRange: TimeRange, selector: string, withName?: boolean) => Promise<Record<string, string[]>>;
    /**
     * @deprecated Use queryLabelValues() method insteadIt'll determine the right endpoint based on the datasource settings
     */
    fetchLabelValues: (range: TimeRange, key: string, limit?: string | number) => Promise<string[]>;
    /**
     * @deprecated Use queryLabelValues() method insteadIt'll determine the right endpoint based on the datasource settings
     */
    getLabelValues: (range: TimeRange, key: string) => Promise<string[]>;
    /**
     * @deprecated If you need labelKeys or labelValues please use queryLabelKeys() or queryLabelValues() functions
     */
    fetchLabels: (timeRange: TimeRange, queries?: PromQuery[], limit?: string) => Promise<string[]>;
    /**
     * @deprecated Use queryLabelValues() method insteadIt'll determine the right endpoint based on the datasource settings
     */
    getSeriesValues: (timeRange: TimeRange, labelName: string, selector: string) => Promise<string[]>;
    /**
     * @deprecated Use queryLabelValues() method insteadIt'll determine the right endpoint based on the datasource settings
     */
    fetchSeriesValuesWithMatch: (timeRange: TimeRange, name: string, match?: string, requestId?: string, withLimit?: string | number) => Promise<string[]>;
    /**
     * @deprecated Use queryLabelKeys() method instead. It'll determine the right endpoint based on the datasource settings
     */
    getSeriesLabels: (timeRange: TimeRange, selector: string, otherLabels: Label[]) => Promise<string[]>;
    /**
     * @deprecated Use queryLabelKeys() method instead. It'll determine the right endpoint based on the datasource settings
     */
    fetchLabelsWithMatch: (timeRange: TimeRange, name: string, withName?: boolean, withLimit?: string | number) => Promise<Record<string, string[]>>;
    /**
     * @deprecated Use queryLabelKeys() method instead. It'll determine the right endpoint based on the datasource settings
     */
    fetchSeriesLabels: (timeRange: TimeRange, name: string, withName?: boolean, withLimit?: string | number) => Promise<Record<string, string[]>>;
    /**
     * @deprecated Use queryLabelKeys() method instead. It'll determine the right endpoint based on the datasource settings
     */
    fetchSeriesLabelsMatch: (timeRange: TimeRange, name: string, withLimit?: string | number) => Promise<Record<string, string[]>>;
    /**
     * @deprecated If you need labelKeys or labelValues please use queryLabelKeys() or queryLabelValues() functions
     */
    fetchSeries: (timeRange: TimeRange, match: string) => Promise<Array<Record<string, string>>>;
    /**
     * @deprecated If you need labelKeys or labelValues please use queryLabelKeys() or queryLabelValues() functions
     */
    fetchDefaultSeries: (timeRange: TimeRange) => Promise<{}>;
}
/**
 * Old implementation of prometheus language provider.
 * @deprecated Use PrometheusLanguageProviderInterface and PrometheusLanguageProvider class instead.
 */
export default class PromQlLanguageProvider extends LanguageProvider implements PrometheusLegacyLanguageProvider {
    startTask: Promise<any>;
    labelFetchTs: number;
    datasource: PrometheusDatasource;
    histogramMetrics: string[];
    metrics: string[];
    metricsMetadata?: PromMetricsMetadata;
    labelKeys: string[];
    constructor(datasource: PrometheusDatasource, initialValues?: Partial<PromQlLanguageProvider>);
    request: (url: string, params?: {}, options?: Partial<BackendSrvRequest>) => Promise<any>;
    /**
     * Overridden by PrometheusLanguageProvider
     */
    start: (timeRange?: TimeRange) => Promise<any[]>;
    loadMetricsMetadata(): Promise<void>;
    getLabelKeys(): string[];
    getSeries(timeRange: TimeRange, selector: string, withName?: boolean): Promise<Record<string, string[]>>;
    fetchLabelValues: (range: TimeRange, key: string, limit?: string | number) => Promise<string[]>;
    getLabelValues(range: TimeRange, key: string): Promise<string[]>;
    /**
     * Fetches all label keys
     */
    fetchLabels: (timeRange: TimeRange, queries?: PromQuery[], limit?: string) => Promise<string[]>;
    /**
     * Gets series values
     * Function to replace old getSeries calls in a way that will provide faster endpoints
     * for new prometheus instances, while maintaining backward compatability
     */
    getSeriesValues: (timeRange: TimeRange, labelName: string, selector: string) => Promise<string[]>;
    /**
     * Fetches all values for a label, with optional match[]
     */
    fetchSeriesValuesWithMatch: (timeRange: TimeRange, name: string, match?: string, requestId?: string, withLimit?: string | number) => Promise<string[]>;
    /**
     * Gets series labels
     * Function to replace old getSeries calls in a way that will provide faster endpoints for new prometheus instances,
     * while maintaining backward compatability. The old API call got the labels and the values in a single query,
     * but with the new query we need two calls, one to get the labels, and another to get the values.
     */
    getSeriesLabels: (timeRange: TimeRange, selector: string, otherLabels: Label[]) => Promise<string[]>;
    /**
     * Fetch labels using the best endpoint that datasource supports.
     * This is cached by its args but also by the global timeRange currently selected as they can change over requested time.
     */
    fetchLabelsWithMatch: (timeRange: TimeRange, name: string, withName?: boolean, withLimit?: string | number) => Promise<Record<string, string[]>>;
    /**
     * Fetch labels for a series using /series endpoint. This is cached by its args but also by the global timeRange currently selected as
     * they can change over requested time.
     */
    fetchSeriesLabels: (timeRange: TimeRange, name: string, withName?: boolean, withLimit?: string | number) => Promise<Record<string, string[]>>;
    /**
     * Fetch labels for a series using /labels endpoint.  This is cached by its args but also by the global timeRange currently selected as
     * they can change over requested time.
     */
    fetchSeriesLabelsMatch: (timeRange: TimeRange, name: string, withLimit?: string | number) => Promise<Record<string, string[]>>;
    /**
     * Fetch series for a selector. Use this for raw results. Use fetchSeriesLabels() to get labels.
     */
    fetchSeries: (timeRange: TimeRange, match: string) => Promise<Array<Record<string, string>>>;
    /**
     * Fetch this only one as we assume this won't change over time. This is cached differently from fetchSeriesLabels
     * because we can cache more aggressively here and also we do not want to invalidate this cache the same way as in
     * fetchSeriesLabels.
     */
    fetchDefaultSeries: (timeRange: TimeRange) => Promise<{}>;
    /**
     * Fetch labels or values for a label based on the queries, scopes, filters and time range
     */
    fetchSuggestions: (timeRange?: TimeRange, queries?: PromQuery[], scopes?: Scope[], adhocFilters?: AdHocVariableFilter[], labelName?: string, limit?: number, requestId?: string) => Promise<string[]>;
}
export interface PrometheusLanguageProviderInterface extends PrometheusBaseLanguageProvider, PrometheusLegacyLanguageProvider {
    retrieveMetricsMetadata: () => PromMetricsMetadata;
    retrieveHistogramMetrics: () => string[];
    retrieveMetrics: () => string[];
    retrieveLabelKeys: () => string[];
    queryMetricsMetadata: (limit?: number) => Promise<PromMetricsMetadata>;
    queryLabelKeys: (timeRange: TimeRange, match?: string, limit?: number) => Promise<string[]>;
    queryLabelValues: (timeRange: TimeRange, labelKey: string, match?: string, limit?: number) => Promise<string[]>;
}
/**
 * Modern implementation of the Prometheus language provider that abstracts API endpoint selection.
 *
 * Features:
 * - Automatically selects the most efficient API endpoint based on Prometheus version and configuration
 * - Supports both labels and series endpoints for backward compatibility
 * - Handles match[] parameters for filtering time series data
 * - Implements automatic request limiting (default: 40_000 series)
 * - Provides unified interface for both modern and legacy Prometheus versions
 *
 * @see LabelsApiClient For modern Prometheus versions using the labels API
 * @see SeriesApiClient For legacy Prometheus versions using the series API
 */
export declare class PrometheusLanguageProvider extends PromQlLanguageProvider implements PrometheusLanguageProviderInterface {
    private _metricsMetadata?;
    private _resourceClient?;
    constructor(datasource: PrometheusDatasource);
    /**
     * Lazily initializes and returns the appropriate resource client based on Prometheus version.
     *
     * The client selection logic:
     * - For Prometheus v2.6+ with labels API: Uses LabelsApiClient for efficient label-based queries
     * - For older versions: Falls back to SeriesApiClient for backward compatibility
     *
     * The client instance is cached after first initialization to avoid repeated creation.
     *
     * @returns {ResourceApiClient} An instance of either LabelsApiClient or SeriesApiClient
     */
    private get resourceClient();
    /**
     * Same start logic but it uses resource clients. Backward compatibility it calls _backwardCompatibleStart.
     * Some places still relies on deprecated fields. Until we replace them we need _backwardCompatibleStart method
     */
    start: (timeRange?: TimeRange) => Promise<any[]>;
    /**
     * This private method exists to make sure the old class will be functional until we remove it.
     * When we remove old class (PromQlLanguageProvider) we should remove this method too.
     */
    private _backwardCompatibleStart;
    /**
     * Fetches metadata for metrics from Prometheus.
     * Sets cache headers based on the configured metadata cache duration.
     *
     * @returns {Promise<PromMetricsMetadata>} Promise that resolves when metadata has been fetched
     */
    private _queryMetadata;
    /**
     * Retrieves the cached Prometheus metrics metadata.
     * This metadata includes type information (counter, gauge, etc.) and help text for metrics.
     *
     * @returns {PromMetricsMetadata} Cached metadata or empty object if not yet fetched
     */
    retrieveMetricsMetadata: () => PromMetricsMetadata;
    /**
     * Retrieves the list of histogram metrics from the current resource client.
     * Histogram metrics are identified by the '_bucket' suffix and are used for percentile calculations.
     *
     * @returns {string[]} Array of histogram metric names
     */
    retrieveHistogramMetrics: () => string[];
    /**
     * Retrieves the complete list of available metrics from the current resource client.
     * This includes all metric names regardless of their type (counter, gauge, histogram).
     *
     * @returns {string[]} Array of all metric names
     */
    retrieveMetrics: () => string[];
    /**
     * Retrieves the list of available label keys from the current resource client.
     * Label keys are the names of labels that can be used to filter and group metrics.
     *
     * @returns {string[]} Array of label key names
     */
    retrieveLabelKeys: () => string[];
    /**
     * Fetches fresh metrics metadata from Prometheus and updates the cache.
     * This includes querying for metric types, help text, and unit information.
     * If the fetch fails, the cache is set to an empty object to prevent stale data.
     *
     * @returns {Promise<PromMetricsMetadata>} Promise that resolves to the fetched metadata
     */
    queryMetricsMetadata: (limit?: number) => Promise<PromMetricsMetadata>;
    /**
     * Fetches all available label keys that match the specified criteria.
     *
     * This method queries Prometheus for label keys within the specified time range.
     * The results can be filtered using the match parameter and limited in size.
     * Uses either the labels API (Prometheus v2.6+) or series API based on version.
     *
     * @param {TimeRange} timeRange - Time range to search for label keys
     * @param {string} [match] - Optional PromQL selector to filter label keys (e.g., '{job="grafana"}')
     * @param {string} [limit] - Optional maximum number of label keys to return
     * @returns {Promise<string[]>} Array of matching label key names, sorted alphabetically
     */
    queryLabelKeys: (timeRange: TimeRange, match?: string, limit?: number) => Promise<string[]>;
    /**
     * Fetches all values for a specific label key that match the specified criteria.
     *
     * This method queries Prometheus for label values within the specified time range.
     * Results can be filtered using the match parameter to find values in specific contexts.
     * Supports both modern (labels API) and legacy (series API) Prometheus versions.
     *
     * The method automatically handles UTF-8 encoded label keys by properly escaping them
     * before making API requests. This means you can safely pass label keys containing
     * special characters like dots, colons, or Unicode characters (e.g., 'http.status:code',
     * 'μs', 'response.time').
     *
     * @param {TimeRange} timeRange - Time range to search for label values
     * @param {string} labelKey - The label key to fetch values for (e.g., 'job', 'instance', 'http.status:code')
     * @param {string} [match] - Optional PromQL selector to filter values (e.g., '{job="grafana"}')
     * @param {string} [limit] - Optional maximum number of values to return
     * @returns {Promise<string[]>} Array of matching label values, sorted alphabetically
     * @example
     * // Fetch all values for the 'job' label
     * const values = await queryLabelValues(timeRange, 'job');
     * // Fetch 'instance' values only for jobs matching 'grafana'
     * const instances = await queryLabelValues(timeRange, 'instance', '{job="grafana"}');
     * // Fetch values for a label key with special characters
     * const statusCodes = await queryLabelValues(timeRange, 'http.status:code');
     */
    queryLabelValues: (timeRange: TimeRange, labelKey: string, match?: string, limit?: number) => Promise<string[]>;
}
export declare const importFromAbstractQuery: (labelBasedQuery: AbstractQuery) => PromQuery;
export declare const exportToAbstractQuery: (query: PromQuery) => AbstractQuery;
/**
 * Removes quotes from a string if they exist.
 * Used to handle utf8 label keys in Prometheus queries.
 *
 * @param {string} input - Input string that may have surrounding quotes
 * @returns {string} String with surrounding quotes removed if they existed
 */
export declare function removeQuotesIfExist(input: string): string;
/**
 * Extracts metrics from queries and populates match parameters.
 * This is used to filter time series data based on existing queries.
 * Handles UTF8 metrics by properly escaping them.
 *
 * @param {PromQuery[]} queries - Array of Prometheus queries
 * @returns {string[]} Metric names as a regex matcher inside the array for easy handling
 */
export declare const populateMatchParamsFromQueries: (queries?: PromQuery[]) => string[];
