import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { t, Trans } from '@grafana/i18n';
import { DataSourceDescription, ConfigSection, AdvancedHttpSettings } from '@grafana/plugin-ui';
import { config } from '@grafana/runtime';
import { useTheme2, Alert } from '@grafana/ui';
import { AlertingSettingsOverhaul } from './AlertingSettingsOverhaul.mjs';
import { DataSourceHttpSettingsOverhaul } from './DataSourceHttpSettingsOverhaul.mjs';
import { PromSettings } from './PromSettings.mjs';
import { overhaulStyles } from './shared/utils.mjs';

const ConfigEditor = (props) => {
  const { options, onOptionsChange } = props;
  const theme = useTheme2();
  const styles = overhaulStyles(theme);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    options.access === "direct" && /* @__PURE__ */ jsx(Alert, { title: t("grafana-prometheus.configuration.config-editor.title-error", "Error"), severity: "error", children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.config-editor.browser-access-mode-error", children: "Browser access mode in the Prometheus data source is no longer available. Switch to server access mode." }) }),
    /* @__PURE__ */ jsx(
      DataSourceDescription,
      {
        dataSourceName: "Prometheus",
        docsLink: "https://grafana.com/docs/grafana/latest/datasources/prometheus/configure-prometheus-data-source/"
      }
    ),
    /* @__PURE__ */ jsx("hr", { className: `${styles.hrTopSpace} ${styles.hrBottomSpace}` }),
    /* @__PURE__ */ jsx(
      DataSourceHttpSettingsOverhaul,
      {
        options,
        onOptionsChange,
        secureSocksDSProxyEnabled: config.secureSocksDSProxyEnabled
      }
    ),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(
      ConfigSection,
      {
        className: styles.advancedSettings,
        title: t("grafana-prometheus.configuration.config-editor.title-advanced-settings", "Advanced settings"),
        description: t(
          "grafana-prometheus.configuration.config-editor.description-advanced-settings",
          "Additional settings are optional settings that can be configured for more control over your data source."
        ),
        children: [
          /* @__PURE__ */ jsx(
            AdvancedHttpSettings,
            {
              className: styles.advancedHTTPSettingsMargin,
              config: options,
              onChange: onOptionsChange
            }
          ),
          /* @__PURE__ */ jsx(AlertingSettingsOverhaul, { options, onOptionsChange }),
          /* @__PURE__ */ jsx(PromSettings, { options, onOptionsChange })
        ]
      }
    )
  ] });
};

export { ConfigEditor };
//# sourceMappingURL=ConfigEditor.mjs.map
