import { t } from '@grafana/i18n';
import { TooltipDisplayMode, SortOrder } from '@grafana/schema';

({
  tooltip: {
    mode: TooltipDisplayMode.Single,
    sort: SortOrder.None,
    hideZeros: false
  }
});
function addTooltipOptions(builder, singleOnly = false, setProximity = false, defaultOptions) {
  var _a, _b, _c, _d;
  const category = [t("grafana-ui.builder.tooltip.category", "Tooltip")];
  const modeOptions = singleOnly ? [
    { value: TooltipDisplayMode.Single, label: t("grafana-ui.builder.tooltip.modeOptions.label-single", "Single") },
    { value: TooltipDisplayMode.None, label: t("grafana-ui.builder.tooltip.modeOptions.label-hidden", "Hidden") }
  ] : [
    { value: TooltipDisplayMode.Single, label: t("grafana-ui.builder.tooltip.modeOptions.label-single", "Single") },
    { value: TooltipDisplayMode.Multi, label: t("grafana-ui.builder.tooltip.modeOptions.label-all", "All") },
    { value: TooltipDisplayMode.None, label: t("grafana-ui.builder.tooltip.modeOptions.label-hidden", "Hidden") }
  ];
  const sortOptions = [
    { value: SortOrder.None, label: t("grafana-ui.builder.tooltip.sortOptions.label-none", "None") },
    { value: SortOrder.Ascending, label: t("grafana-ui.builder.tooltip.sortOptions.label-ascending", "Ascending") },
    { value: SortOrder.Descending, label: t("grafana-ui.builder.tooltip.sortOptions.label-descending", "Descending") }
  ];
  builder.addRadio({
    path: "tooltip.mode",
    name: t("grafana-ui.builder.tooltip.name-tooltip-mode", "Tooltip mode"),
    category,
    defaultValue: (_b = (_a = defaultOptions == null ? void 0 : defaultOptions.tooltip) == null ? void 0 : _a.mode) != null ? _b : TooltipDisplayMode.Single,
    settings: {
      options: modeOptions
    }
  }).addRadio({
    path: "tooltip.sort",
    name: t("grafana-ui.builder.tooltip.name-values-sort-order", "Values sort order"),
    category,
    defaultValue: (_d = (_c = defaultOptions == null ? void 0 : defaultOptions.tooltip) == null ? void 0 : _c.sort) != null ? _d : SortOrder.None,
    showIf: (options) => {
      var _a2;
      return ((_a2 = options.tooltip) == null ? void 0 : _a2.mode) === TooltipDisplayMode.Multi;
    },
    settings: {
      options: sortOptions
    }
  }).addBooleanSwitch({
    path: "tooltip.hideZeros",
    name: t("grafana-ui.builder.tooltip.name-hide-zeros", "Hide zeros"),
    category,
    defaultValue: false,
    showIf: (options) => {
      var _a2, _b2;
      return ((_a2 = defaultOptions == null ? void 0 : defaultOptions.tooltip) == null ? void 0 : _a2.hideZeros) !== void 0 && ((_b2 = options.tooltip) == null ? void 0 : _b2.mode) === TooltipDisplayMode.Multi;
    }
  });
  if (setProximity) {
    builder.addNumberInput({
      path: "tooltip.hoverProximity",
      name: t("grafana-ui.builder.tooltip.name-hover-proximity", "Hover proximity"),
      description: t(
        "grafana-ui.builder.tooltip.description-hover-proximity",
        "How close the cursor must be to a point to trigger the tooltip, in pixels"
      ),
      category,
      settings: {
        integer: true
      },
      showIf: (options) => {
        var _a2;
        return ((_a2 = options.tooltip) == null ? void 0 : _a2.mode) !== TooltipDisplayMode.None;
      }
    });
  }
  builder.addNumberInput({
    path: "tooltip.maxWidth",
    name: t("grafana-ui.builder.tooltip.name-max-width", "Max width"),
    category,
    settings: {
      integer: true
    },
    showIf: (options) => {
      var _a2;
      return ((_a2 = options.tooltip) == null ? void 0 : _a2.mode) !== TooltipDisplayMode.None;
    }
  }).addNumberInput({
    path: "tooltip.maxHeight",
    name: t("grafana-ui.builder.tooltip.name-max-height", "Max height"),
    category,
    defaultValue: void 0,
    settings: {
      integer: true
    },
    showIf: (options, data, annotations) => {
      var _a2;
      return ((_a2 = options.tooltip) == null ? void 0 : _a2.mode) === TooltipDisplayMode.Multi || (annotations == null ? void 0 : annotations.some((df) => {
        var _a3, _b2;
        return ((_b2 = (_a3 = df.meta) == null ? void 0 : _a3.custom) == null ? void 0 : _b2.resultType) === "exemplar";
      }));
    }
  });
}

export { addTooltipOptions };
//# sourceMappingURL=tooltip.mjs.map
