import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { locale } from '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

const Counter = ({ value, variant = "secondary" }) => {
  const styles = useStyles2(getStyles, variant);
  return /* @__PURE__ */ jsx("span", { className: styles.counter, children: locale(value, 0).text });
};
const getStyles = (theme, variant) => ({
  counter: css({
    label: "counter",
    marginLeft: theme.spacing(1),
    borderRadius: theme.spacing(3),
    backgroundColor: variant === "primary" ? theme.colors.primary.main : theme.colors.action.hover,
    padding: theme.spacing(0.25, 1),
    color: theme.colors.text.secondary,
    fontWeight: theme.typography.fontWeightMedium,
    fontSize: theme.typography.size.sm
  })
});

export { Counter };
//# sourceMappingURL=Counter.mjs.map
