import { jsx } from 'react/jsx-runtime';
import { ThresholdsMode, getFieldConfigWithMinMax, VizOrientation } from '@grafana/data';
import { BarGaugeDisplayMode, TableCellDisplayMode, BarGaugeValueMode } from '@grafana/schema';
import { BarGauge } from '../../../BarGauge/BarGauge.mjs';
import { renderSingleLink } from '../../DataLinksActionsTooltip.mjs';
import { useSingleLink } from '../hooks.mjs';
import { getCellOptions, extractPixelValue, getAlignmentFactor } from '../utils.mjs';

const defaultScale = {
  mode: ThresholdsMode.Absolute,
  steps: [
    {
      color: "blue",
      value: -Infinity
    },
    {
      color: "green",
      value: 20
    }
  ]
};
const BarGaugeCell = ({ value, field, theme, height, width, rowIdx }) => {
  var _a;
  const displayValue = field.display(value);
  const cellOptions = getCellOptions(field);
  const heightOffset = extractPixelValue(theme.spacing(1));
  let config = getFieldConfigWithMinMax(field, false);
  if (!config.thresholds) {
    config = {
      ...config,
      thresholds: defaultScale
    };
  }
  let barGaugeMode = BarGaugeDisplayMode.Gradient;
  let valueDisplayMode = void 0;
  if (cellOptions.type === TableCellDisplayMode.Gauge) {
    barGaugeMode = (_a = cellOptions.mode) != null ? _a : BarGaugeDisplayMode.Gradient;
    valueDisplayMode = cellOptions.valueDisplayMode !== void 0 ? cellOptions.valueDisplayMode : BarGaugeValueMode.Text;
  }
  const alignmentFactors = getAlignmentFactor(field, displayValue, rowIdx);
  const barGaugeComponent = /* @__PURE__ */ jsx(
    BarGauge,
    {
      width,
      height: height - heightOffset,
      field: config,
      display: field.display,
      text: { valueSize: 14 },
      value: displayValue,
      orientation: VizOrientation.Horizontal,
      theme,
      alignmentFactors,
      itemSpacing: 1,
      lcdCellWidth: 8,
      displayMode: barGaugeMode,
      valueDisplayMode
    }
  );
  const link = useSingleLink(field, rowIdx);
  return link == null ? barGaugeComponent : renderSingleLink(link, barGaugeComponent);
};

export { BarGaugeCell };
//# sourceMappingURL=BarGaugeCell.mjs.map
