import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import SVG from 'react-inlinesvg';
import { t } from '@grafana/i18n';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { isIconSize } from '../../types/icon.mjs';
import { spin } from '../../utils/keyframes.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { getIconSubDir, getIconRoot } from '../Icon/utils.mjs';

const Spinner = ({
  className,
  inline = false,
  iconClassName,
  style,
  size = "md"
}) => {
  const styles = useStyles2(getStyles);
  const deprecatedStyles = useStyles2(getDeprecatedStyles, size);
  const prefersReducedMotion = window.matchMedia("(prefers-reduced-motion: reduce)").matches;
  const iconName = prefersReducedMotion ? "hourglass" : "spinner";
  if (typeof size !== "string" || !isIconSize(size)) {
    const iconRoot = getIconRoot();
    const subDir = getIconSubDir(iconName, "default");
    const svgPath = `${iconRoot}${subDir}/${iconName}.svg`;
    return /* @__PURE__ */ jsx(
      "div",
      {
        "data-testid": "Spinner",
        style,
        className: cx(
          {
            [styles.inline]: inline
          },
          deprecatedStyles.wrapper,
          className
        ),
        children: /* @__PURE__ */ jsx(
          SVG,
          {
            src: svgPath,
            width: size,
            height: size,
            className: cx(styles.spin, deprecatedStyles.icon, className),
            style
          }
        )
      }
    );
  }
  return /* @__PURE__ */ jsx(
    "div",
    {
      "data-testid": "Spinner",
      style,
      className: cx(
        {
          [styles.inline]: inline
        },
        className
      ),
      children: /* @__PURE__ */ jsx(
        Icon,
        {
          className: cx(styles.spin, iconClassName),
          name: iconName,
          size,
          "aria-label": t("grafana-ui.spinner.aria-label", "Loading")
        }
      )
    }
  );
};
const getStyles = (theme) => ({
  inline: css({
    display: "inline-block",
    lineHeight: 0
  }),
  spin: css({
    [theme.transitions.handleMotion("no-preference")]: {
      animation: `${spin} 2s infinite linear`
    }
  })
});
const getDeprecatedStyles = (theme, size) => ({
  wrapper: css({
    fontSize: typeof size === "string" ? size : `${size}px`
  }),
  icon: css({
    display: "inline-block",
    fill: "currentColor",
    flexShrink: 0,
    label: "Icon",
    // line-height: 0; is needed for correct icon alignment in Safari
    lineHeight: 0,
    verticalAlign: "middle"
  })
});

export { Spinner };
//# sourceMappingURL=Spinner.mjs.map
