import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { forwardRef } from 'react';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { getFocusStyles, getMouseFocusStyles } from '../../themes/mixins.mjs';
import { Button } from '../Button/Button.mjs';

const TitleItem = forwardRef(
  ({ className, children, href, onClick, target, title, ...rest }, ref) => {
    const styles = useStyles2(getStyles);
    if (href) {
      return /* @__PURE__ */ jsx(
        "a",
        {
          ref,
          href,
          onClick,
          target,
          title,
          className: cx(styles.linkItem, className),
          ...rest,
          children
        }
      );
    } else if (onClick) {
      return /* @__PURE__ */ jsx(Button, { ref, className: cx(styles.item, className), variant: "secondary", fill: "text", onClick, children });
    } else {
      return /* @__PURE__ */ jsx("span", { ref, className: cx(styles.item, className), ...rest, children });
    }
  }
);
TitleItem.displayName = "TitleItem";
const getStyles = (theme) => {
  const item = css({
    color: `${theme.colors.text.secondary}`,
    label: "panel-header-item",
    cursor: "auto",
    border: "none",
    borderRadius: `${theme.shape.radius.default}`,
    padding: `${theme.spacing(0, 1)}`,
    height: `${theme.spacing(theme.components.panel.headerHeight)}`,
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    "&:focus, &:focus-visible": {
      ...getFocusStyles(theme),
      zIndex: 1
    },
    "&: focus:not(:focus-visible)": getMouseFocusStyles(),
    "&:hover ": {
      boxShadow: `${theme.shadows.z1}`,
      background: `${theme.colors.background.secondary}`,
      color: `${theme.colors.text.primary}`
    }
  });
  return {
    item,
    linkItem: cx(item, css({ cursor: "pointer" }))
  };
};

export { TitleItem };
//# sourceMappingURL=TitleItem.mjs.map
