import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import * as React from 'react';
import Skeleton from 'react-loading-skeleton';
import tinycolor from 'tinycolor2';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { attachSkeleton } from '../../utils/skeleton.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { Tooltip } from '../Tooltip/Tooltip.mjs';

const BadgeComponent = React.memo(({ icon, color, text, tooltip, className, ...otherProps }) => {
  const styles = useStyles2(getStyles, color);
  const badge = /* @__PURE__ */ jsxs("div", { className: cx(styles.wrapper, className), ...otherProps, children: [
    icon && /* @__PURE__ */ jsx(Icon, { name: icon, size: "sm" }),
    text
  ] });
  return tooltip ? /* @__PURE__ */ jsx(Tooltip, { content: tooltip, placement: "auto", children: badge }) : badge;
});
BadgeComponent.displayName = "Badge";
const BadgeSkeleton = ({ rootProps }) => {
  const styles = useStyles2(getSkeletonStyles);
  return /* @__PURE__ */ jsx(Skeleton, { width: 60, height: 22, containerClassName: styles.container, ...rootProps });
};
const Badge = attachSkeleton(BadgeComponent, BadgeSkeleton);
const getSkeletonStyles = () => ({
  container: css({
    lineHeight: 1
  })
});
const getStyles = (theme, color) => {
  let sourceColor = theme.visualization.getColorByName(color);
  let borderColor = "";
  let bgColor = "";
  let textColor = "";
  if (theme.isDark) {
    bgColor = tinycolor(sourceColor).setAlpha(0.15).toString();
    borderColor = tinycolor(sourceColor).setAlpha(0.25).toString();
    textColor = tinycolor(sourceColor).lighten(15).toString();
  } else {
    bgColor = tinycolor(sourceColor).setAlpha(0.15).toString();
    borderColor = tinycolor(sourceColor).setAlpha(0.25).toString();
    textColor = tinycolor(sourceColor).darken(20).toString();
  }
  if (color === "brand") {
    bgColor = theme.colors.gradients.brandHorizontal;
    borderColor = "transparent";
    textColor = theme.colors.primary.contrastText;
  }
  return {
    wrapper: css({
      display: "inline-flex",
      padding: "1px 4px",
      borderRadius: theme.shape.radius.default,
      background: bgColor,
      border: `1px solid ${borderColor}`,
      color: textColor,
      fontWeight: theme.typography.fontWeightRegular,
      gap: theme.spacing(0.5),
      fontSize: theme.typography.bodySmall.fontSize,
      lineHeight: theme.typography.bodySmall.lineHeight,
      alignItems: "center"
    })
  };
};

export { Badge };
//# sourceMappingURL=Badge.mjs.map
