import { isValidLegacyName } from '../../../utf8_support.mjs';
import { renderLabels } from './labels.mjs';
import { renderOperations, hasBinaryOp } from './operations.mjs';

function renderBinaryQueries(queryString, binaryQueries) {
  if (binaryQueries) {
    for (const binQuery of binaryQueries) {
      queryString = `${renderBinaryQuery(queryString, binQuery)}`;
    }
  }
  return queryString;
}
function renderBinaryQuery(leftOperand, binaryQuery) {
  let result = leftOperand + ` ${binaryQuery.operator} `;
  if (binaryQuery.vectorMatches) {
    result += `${binaryQuery.vectorMatchesType}(${binaryQuery.vectorMatches}) `;
  }
  return result + renderQuery(binaryQuery.query, true);
}
function renderQuery(query, nested, operationsRegistry) {
  var _a;
  if (!query.metric && query.labels.length === 0 && query.operations.length === 0) {
    return "";
  }
  let queryString = "";
  const labels = renderLabels(query.labels);
  if (query.metric) {
    if (isValidLegacyName(query.metric)) {
      queryString = `${query.metric}${labels}`;
    } else {
      queryString = `{"${query.metric}"${labels.length > 0 ? `, ${labels.substring(1)}` : `}`}`;
    }
  } else if (query.labels.length > 0) {
    queryString = labels;
  } else if (query.operations.length > 0) {
    queryString = "";
  }
  if (query.operations.length > 0) {
    if (operationsRegistry) {
      queryString = renderOperations(queryString, query.operations, operationsRegistry);
    } else {
      for (const operation of query.operations) {
        if (operation.id === "MultiplyBy" && operation.params && operation.params.length > 0) {
          queryString = `${queryString} * ${operation.params[0]}`;
        }
      }
    }
  }
  const hasNesting = Boolean((_a = query.binaryQueries) == null ? void 0 : _a.length);
  const hasBinaryOperation = operationsRegistry ? hasBinaryOp(query, operationsRegistry) : false;
  if (!nested && hasBinaryOperation && hasNesting) {
    queryString = `(${queryString})`;
  }
  if (hasNesting) {
    for (const binQuery of query.binaryQueries) {
      const rightOperand = renderNestedPart(binQuery.query, operationsRegistry);
      let vectorMatchingStr = "";
      if (binQuery.vectorMatches) {
        vectorMatchingStr = `${binQuery.vectorMatchesType}(${binQuery.vectorMatches}) `;
      }
      queryString = `${queryString} ${binQuery.operator} ${vectorMatchingStr}${rightOperand}`;
    }
  }
  if (nested && (hasBinaryOperation || hasNesting)) {
    queryString = `(${queryString})`;
  }
  return queryString;
}
function renderNestedPart(query, operationsRegistry) {
  var _a;
  const renderedQuery = renderQuery(query, false, operationsRegistry);
  const hasOps = query.operations.length > 0;
  const hasNestedBinary = Boolean((_a = query.binaryQueries) == null ? void 0 : _a.length);
  if (hasOps && !hasNestedBinary && !query.metric && (!query.labels || query.labels.length === 0)) {
    return renderedQuery;
  }
  if (hasOps || hasNestedBinary) {
    return `(${renderedQuery})`;
  }
  return renderedQuery;
}

export { renderBinaryQueries, renderBinaryQuery, renderQuery };
//# sourceMappingURL=query.mjs.map
