import { isEmpty, countBy } from 'lodash';

function getContactPointDescription(contactPoint) {
  if (isEmpty(contactPoint.spec.integrations)) {
    return "<empty contact point>";
  }
  const integrationCounts = countBy(contactPoint.spec.integrations, (integration) => integration.type);
  const description = Object.entries(integrationCounts).map(([type, count]) => {
    return count > 1 ? `${type} (${count})` : type;
  }).join(", ");
  return description;
}

export { getContactPointDescription };
//# sourceMappingURL=utils.mjs.map
