import { ScopedVars } from '../types/ScopedVars';
import { Field } from '../types/dataFrame';
import { DataLink, InternalDataLink, LinkModel } from '../types/dataLink';
import { SplitOpen } from '../types/explore';
import { InterpolateFunction } from '../types/panel';
import { TimeRange } from '../types/time';
export declare const DataLinkBuiltInVars: {
    keepTime: string;
    timeRangeFrom: string;
    timeRangeTo: string;
    includeVars: string;
    seriesName: string;
    fieldName: string;
    valueTime: string;
    valueNumeric: string;
    valueText: string;
    valueRaw: string;
    valueCalc: string;
};
export type LinkToExploreOptions = {
    link: DataLink;
    scopedVars: ScopedVars;
    range?: TimeRange;
    field: Field;
    internalLink: InternalDataLink;
    onClickFn?: SplitOpen;
    replaceVariables: InterpolateFunction;
};
export declare function mapInternalLinkToExplore(options: LinkToExploreOptions): LinkModel<Field>;
