import { config } from '../config.mjs';
import { getBackendSrv } from '../services/backendSrv.mjs';
import '@grafana/data';
import '../services/LocationService.mjs';
import '../services/appEvents.mjs';
import 'react/jsx-runtime';
import 'react';
import '../services/ScopesContext.mjs';
import { DataSourceWithBackend } from './DataSourceWithBackend.mjs';

function isMigrationHandler(object) {
  return object instanceof DataSourceWithBackend && "hasBackendMigration" in object && "shouldMigrate" in object;
}
async function postMigrateRequest(queries) {
  var _a, _b;
  if (!(config.featureToggles.grafanaAPIServerWithExperimentalAPIs || config.featureToggles.datasourceAPIServers)) {
    console.warn("migrateQuery is only available with the experimental API server");
    return queries;
  }
  const dsnameURL = (_b = (_a = queries[0].datasource) == null ? void 0 : _a.type) == null ? void 0 : _b.replace(/^(grafana-)?(.*?)(-datasource)?$/, "$2");
  const groupName = `${dsnameURL}.datasource.grafana.app`;
  const apiVersion = "v0alpha1";
  const url = `/apis/${groupName}/${apiVersion}/namespaces/${config.namespace}/queryconvert`;
  const request = {
    queries: queries.map((query) => {
      return {
        ...query,
        JSON: query
        // JSON is not part of the type but it should be what holds the query
      };
    })
  };
  const res = await getBackendSrv().post(url, request);
  return res.queries.map((query) => query.JSON);
}
async function migrateQuery(datasource, query) {
  if (!datasource.hasBackendMigration || !datasource.shouldMigrate(query)) {
    return query;
  }
  const res = await postMigrateRequest([query]);
  return res[0];
}
async function migrateRequest(datasource, request) {
  if (!datasource.hasBackendMigration || !request.targets.some((query) => datasource.shouldMigrate(query))) {
    return request;
  }
  const res = await postMigrateRequest(request.targets);
  return { ...request, targets: res };
}

export { isMigrationHandler, migrateQuery, migrateRequest };
//# sourceMappingURL=migrationHandler.mjs.map
