import { jsx, Fragment } from 'react/jsx-runtime';
import React from 'react';
import { PluginExtensionTypes } from '@grafana/data';

function isPluginExtensionLink(extension) {
  if (!extension) {
    return false;
  }
  return extension.type === PluginExtensionTypes.link && ("path" in extension || "onClick" in extension);
}
function isPluginExtensionComponent(extension) {
  if (!extension) {
    return false;
  }
  return extension.type === PluginExtensionTypes.component && "component" in extension;
}
function getLimitedComponentsToRender({
  props,
  components,
  limit,
  pluginId
}) {
  if (!components.length) {
    return null;
  }
  const renderedComponents = [];
  for (const Component of components) {
    const { meta } = Component;
    if (pluginId && typeof pluginId === "string" && pluginId !== meta.pluginId) {
      continue;
    }
    if (pluginId && Array.isArray(pluginId) && !pluginId.includes(meta.pluginId)) {
      continue;
    }
    if (pluginId instanceof RegExp && !pluginId.test(meta.pluginId)) {
      continue;
    }
    if (limit === void 0) {
      renderedComponents.push(Component);
      continue;
    }
    if (React.createElement(Component, props) !== null) {
      renderedComponents.push(Component);
    }
    if (renderedComponents.length >= limit) {
      break;
    }
  }
  return renderedComponents;
}
function renderLimitedComponents({
  props,
  components,
  limit,
  pluginId
}) {
  const limitedComponents = getLimitedComponentsToRender({ props, components, limit, pluginId });
  if (!(limitedComponents == null ? void 0 : limitedComponents.length)) {
    return null;
  }
  return /* @__PURE__ */ jsx(Fragment, { children: limitedComponents.map((Component) => /* @__PURE__ */ jsx(Component, { ...props }, Component.meta.id)) });
}

export { getLimitedComponentsToRender, isPluginExtensionComponent, isPluginExtensionLink, renderLimitedComponents };
//# sourceMappingURL=utils.mjs.map
