import { marked } from 'marked';
import { mangle } from 'marked-mangle';
import { sanitizeTextPanelContent } from './sanitize.mjs';

let hasInitialized = false;
const markdownOptions = {
  pedantic: false,
  gfm: true,
  breaks: false
};
function renderMarkdown(str, options) {
  if (!hasInitialized) {
    marked.use(mangle());
    marked.setOptions({ ...markdownOptions });
    hasInitialized = true;
  }
  let opts = void 0;
  if (options == null ? void 0 : options.breaks) {
    opts = {
      ...markdownOptions,
      breaks: true
    };
  }
  const html = marked(str || "", opts);
  if (typeof html !== "string") {
    throw new Error("Failed to process markdown synchronously.");
  }
  if (options == null ? void 0 : options.noSanitize) {
    return html;
  }
  return sanitizeTextPanelContent(html);
}
function renderTextPanelMarkdown(str, options) {
  if (!hasInitialized) {
    marked.use(mangle());
    marked.setOptions({ ...markdownOptions });
    hasInitialized = true;
  }
  const html = marked(str || "");
  if (typeof html !== "string") {
    throw new Error("Failed to process markdown synchronously.");
  }
  if (options == null ? void 0 : options.noSanitize) {
    return html;
  }
  return sanitizeTextPanelContent(html);
}

export { renderMarkdown, renderTextPanelMarkdown };
//# sourceMappingURL=markdown.mjs.map
