import { jsx, jsxs } from 'react/jsx-runtime';
import { FixedSizeList } from 'react-window';
import { selectors } from '@grafana/e2e-selectors';
import { Label, Input, BrowserLabel } from '@grafana/ui';
import { LIST_ITEM_SIZE } from './types.mjs';

function MetricSelector({
  metrics,
  metricSearchTerm,
  seriesLimit,
  onChangeMetricSearch,
  onChangeSeriesLimit,
  onClickMetric,
  styles
}) {
  var _a;
  const metricCount = ((_a = metrics == null ? void 0 : metrics.values) == null ? void 0 : _a.length) || 0;
  return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsxs("div", { className: styles.section, children: [
    /* @__PURE__ */ jsx(Label, { description: "Once a metric is selected only possible labels are shown. Labels are limited by the series limit below.", children: "1. Select a metric" }),
    /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(
      Input,
      {
        onChange: onChangeMetricSearch,
        "aria-label": "Filter expression for metric",
        value: metricSearchTerm,
        "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.selectMetric
      }
    ) }),
    /* @__PURE__ */ jsx(Label, { description: "Set to 'none' to remove limit and show all labels for a selected metric. Removing the limit may cause performance issues.", children: "Series limit" }),
    /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(
      Input,
      {
        onChange: onChangeSeriesLimit,
        "aria-label": "Limit results from series endpoint",
        value: seriesLimit,
        "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.seriesLimit
      }
    ) }),
    /* @__PURE__ */ jsx(
      "div",
      {
        role: "list",
        className: styles.valueListWrapper,
        "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.metricList,
        children: /* @__PURE__ */ jsx(
          FixedSizeList,
          {
            height: Math.min(450, metricCount * LIST_ITEM_SIZE),
            itemCount: metricCount,
            itemSize: LIST_ITEM_SIZE,
            itemKey: (i) => metrics.values[i].name,
            width: 300,
            className: styles.valueList,
            children: ({ index, style }) => {
              var _a2;
              const value = (_a2 = metrics == null ? void 0 : metrics.values) == null ? void 0 : _a2[index];
              if (!value) {
                return null;
              }
              return /* @__PURE__ */ jsx("div", { style, children: /* @__PURE__ */ jsx(
                BrowserLabel,
                {
                  name: metrics.name,
                  value: value == null ? void 0 : value.name,
                  title: value.details,
                  active: value == null ? void 0 : value.selected,
                  onClick: onClickMetric,
                  searchTerm: metricSearchTerm
                }
              ) });
            }
          }
        )
      }
    )
  ] }) });
}

export { MetricSelector };
//# sourceMappingURL=MetricSelector.mjs.map
