import { jsx } from 'react/jsx-runtime';
import { memo, useCallback } from 'react';
import { SeriesColorPicker } from '../ColorPicker/ColorPicker.mjs';
import '../PanelChrome/LoadingIndicator.mjs';
import '@emotion/css';
import 'react-use';
import '@grafana/data';
import '@grafana/e2e-selectors';
import 'hoist-non-react-statics';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import '../../utils/dom.mjs';
import '../../utils/colors.mjs';
import 'slate';
import 'lodash';
import '../../utils/logger.mjs';
import '../ElementSelectionContext/ElementSelectionContext.mjs';
import '../Icon/Icon.mjs';
import '../Text/Text.mjs';
import '../Tooltip/Tooltip.mjs';
import '../../utils/i18n.mjs';
import '../Dropdown/Dropdown.mjs';
import '../ToolbarButton/ToolbarButton.mjs';
import '../ToolbarButton/ToolbarButtonRow.mjs';
import '../PanelChrome/TitleItem.mjs';
import { usePanelContext } from '../PanelChrome/PanelContext.mjs';
import { SeriesIcon } from './SeriesIcon.mjs';

const VizLegendSeriesIcon = memo(({ seriesName, color, gradient, readonly, lineStyle }) => {
  const { onSeriesColorChange } = usePanelContext();
  const onChange = useCallback(
    (color2) => {
      return onSeriesColorChange(seriesName, color2);
    },
    [seriesName, onSeriesColorChange]
  );
  if (seriesName && onSeriesColorChange && color && !readonly) {
    return /* @__PURE__ */ jsx(SeriesColorPicker, { color, onChange, enableNamedColors: true, children: ({ ref, showColorPicker, hideColorPicker }) => /* @__PURE__ */ jsx(
      SeriesIcon,
      {
        color,
        className: "pointer",
        ref,
        onClick: showColorPicker,
        onMouseLeave: hideColorPicker,
        lineStyle
      }
    ) });
  }
  return /* @__PURE__ */ jsx(SeriesIcon, { color, gradient, lineStyle });
});
VizLegendSeriesIcon.displayName = "VizLegendSeriesIcon";

export { VizLegendSeriesIcon };
//# sourceMappingURL=VizLegendSeriesIcon.mjs.map
