import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useMeasure } from 'react-use';
import { useTheme2, useStyles2 } from '../../themes/ThemeContext.mjs';
import { getFocusStyles } from '../../themes/mixins.mjs';
import { ScrollContainer } from '../ScrollContainer/ScrollContainer.mjs';

const VizLayout = ({ width, height, legend, children }) => {
  const theme = useTheme2();
  const styles = useStyles2(getVizStyles);
  const containerStyle = {
    display: "flex",
    width: `${width}px`,
    height: `${height}px`
  };
  const [legendRef, legendMeasure] = useMeasure();
  if (!legend) {
    return /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx("div", { style: containerStyle, className: styles.viz, children: children(width, height) }) });
  }
  let { placement, maxHeight = "35%", maxWidth = "60%" } = legend.props;
  if (document.body.clientWidth < theme.breakpoints.values.lg) {
    placement = "bottom";
  }
  let size = null;
  const legendStyle = {};
  switch (placement) {
    case "bottom":
      containerStyle.flexDirection = "column";
      legendStyle.maxHeight = maxHeight;
      if (legendMeasure.height) {
        size = { width, height: height - legendMeasure.height };
      }
      break;
    case "right":
      containerStyle.flexDirection = "row";
      legendStyle.maxWidth = maxWidth;
      if (legendMeasure.width) {
        size = { width: width - legendMeasure.width, height };
      }
      if (legend.props.width) {
        legendStyle.width = legend.props.width;
        size = { width: width - legend.props.width, height };
      }
      break;
  }
  if ((size == null ? void 0 : size.width) === 0) {
    size.width = width;
  }
  if ((size == null ? void 0 : size.height) === 0) {
    size.height = height;
  }
  return /* @__PURE__ */ jsxs("div", { style: containerStyle, children: [
    /* @__PURE__ */ jsx("div", { className: styles.viz, children: size && children(size.width, size.height) }),
    /* @__PURE__ */ jsx("div", { style: legendStyle, ref: legendRef, children: /* @__PURE__ */ jsx(ScrollContainer, { children: legend }) })
  ] });
};
const getVizStyles = (theme) => {
  return {
    viz: css({
      flexGrow: 2,
      borderRadius: theme.shape.radius.default,
      "&:focus-visible": getFocusStyles(theme)
    })
  };
};
const VizLayoutLegend = ({ children }) => {
  return /* @__PURE__ */ jsx(Fragment, { children });
};
VizLayout.Legend = VizLayoutLegend;

export { VizLayout, VizLayoutLegend, getVizStyles };
//# sourceMappingURL=VizLayout.mjs.map
