import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useMemo, useCallback } from 'react';
import { FixedSizeList } from 'react-window';
import { getValueFormat, formattedValueToString } from '@grafana/data';
import 'classnames';
import '../../../Icon/Icon.mjs';
import '../../../Tooltip/Tooltip.mjs';
import '../../../Forms/Legacy/Input/Input.mjs';
import 'react-select';
import '../../../Forms/Legacy/Select/Select.mjs';
import '../../../Forms/Legacy/Switch/Switch.mjs';
import 'lodash';
import { Trans } from '../../../../utils/i18n.mjs';
import '../../../Button/Button.mjs';
import '../../../IconButton/IconButton.mjs';
import { useStyles2, useTheme2 } from '../../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../../utils/skeleton.mjs';
import '../../../Button/ButtonGroup.mjs';
import '@floating-ui/react';
import '../../../Portal/Portal.mjs';
import '../../../Toggletip/Toggletip.mjs';
import 'react-custom-scrollbars-2';
import '../../../Tabs/Tab.mjs';
import '../../../Tabs/TabsBar.mjs';
import '../../../Layout/Box/Box.mjs';
import '../../../ScrollContainer/ScrollContainer.mjs';
import '../../../Cascader/Cascader.mjs';
import '../../../Alert/Alert.mjs';
import 'rc-cascader';
import '../../../Cascader/styles.mjs';
import 'react-inlinesvg';
import '../../../../utils/keyframes.mjs';
import '../../../ColorPicker/ColorPicker.mjs';
import '../../../ColorPicker/ColorPickerInput.mjs';
import '../../../ColorPicker/SeriesColorPickerPopover.mjs';
import { Stack } from '../../../Layout/Stack/Stack.mjs';
import '../../../Text/Text.mjs';
import '../../../StatsPicker/StatsPicker.mjs';
import '../../../RefreshPicker/RefreshPicker.mjs';
import '../../../DateTimePickers/TimeRangePicker.mjs';
import '../../../DateTimePickers/TimeRangeContext.mjs';
import '../../../DateTimePickers/TimeRangePicker/TimeRangeLabel.mjs';
import 'rc-picker';
import 'rc-picker/lib/generate/moment';
import 'rc-picker/lib/locale/en_US';
import 'rc-picker/assets/index.css';
import 'react-select/async';
import 'react-select/async-creatable';
import 'react-select/creatable';
import '../../../Select/IndicatorsContainer.mjs';
import '../../../Select/InputControl.mjs';
import '../../../Select/getSelectStyles.mjs';
import '../../../Input/Input.mjs';
import '../../../Select/SelectMenu.mjs';
import 'react-transition-group';
import '../../../Select/ValueContainer.mjs';
import '@grafana/e2e-selectors';
import '@tanstack/react-virtual';
import 'downshift';
import '../../../Input/AutoSizeInput.mjs';
import { Checkbox } from '../../../Forms/Checkbox.mjs';
import '../../../Combobox/filter.mjs';
import '../../../../utils/dom.mjs';
import '../../../../utils/colors.mjs';
import 'slate';
import '../../../../utils/logger.mjs';
import '../../../DateTimePickers/DatePicker/DatePicker.mjs';
import '../../../DateTimePickers/DateTimePicker/DateTimePicker.mjs';
import '../../../List/AbstractList.mjs';
import 'react-table';
import '../../../InteractiveTable/Expander/index.mjs';
import '../../../Forms/Field.mjs';
import '../../../AutoSaveField/EllipsisAnimated.mjs';
import '../../../Tags/Tag.mjs';
import '../../../Tags/TagList.mjs';
import '../../../Modal/Modal.mjs';
import 'react-hook-form';
import '../../../QueryField/QueryField.mjs';
import '../../../Monaco/CodeEditor.mjs';
import 'react-use';
import '../../../ErrorBoundary/ErrorWithStack.mjs';
import '../../../Modal/ModalsContext.mjs';
import '../../../PageLayout/PageToolbar.mjs';
import 'rxjs';
import 'rxjs/operators';
import '../../TableRT/Table.mjs';
import '@react-aria/dialog';
import '@react-aria/focus';
import '@react-aria/overlays';
import 'rc-drawer';
import 'rc-drawer/assets/index.css';
import '../../../TableInputCSV/TableInputCSV.mjs';
import '../../../Tabs/VerticalTab.mjs';
import '../../../BigValue/BigValue.mjs';
import '../../../Sparkline/Sparkline.mjs';
import '../../../Gauge/Gauge.mjs';
import '../../../BarGauge/BarGauge.mjs';
import '../../../VizTooltip/VizTooltip.mjs';
import '../../../VizTooltip/VizTooltipContainer.mjs';
import '../../../VizLegend/SeriesIcon.mjs';
import '../../../VizRepeater/VizRepeater.mjs';
import '../../../PanelChrome/LoadingIndicator.mjs';
import '../../../ElementSelectionContext/ElementSelectionContext.mjs';
import '../../../Dropdown/Dropdown.mjs';
import '../../../ToolbarButton/ToolbarButton.mjs';
import '../../../ToolbarButton/ToolbarButtonRow.mjs';
import '../../../PanelChrome/TitleItem.mjs';
import '../../../PanelChrome/PanelContext.mjs';
import '../../../VizLayout/VizLayout.mjs';
import '../../../VizLegend/VizLegend.mjs';
import '../../../VizLegend/VizLegendListItem.mjs';
import '../../../ClickOutsideWrapper/ClickOutsideWrapper.mjs';
import '@grafana/schema';
import '../../../ContextMenu/ContextMenu.mjs';
import '../../../Menu/Menu.mjs';
import '../../../Menu/MenuGroup.mjs';
import '../../../Menu/MenuItem.mjs';
import '../../../DataLinks/DataLinkEditor.mjs';
import '@hello-pangea/dnd';
import '../../../Badge/Badge.mjs';
import '../../../DataLinks/DataLinkInput.mjs';
import '../../../InfoBox/InfoBox.mjs';
import '../../../InfoBox/FeatureInfoBox.mjs';
import '../../../JSONFormatter/JSONFormatter.mjs';
import '../../../ErrorBoundary/ErrorBoundary.mjs';
import '../../../Forms/InlineField.mjs';
import '../../../Forms/RadioButtonGroup/RadioButton.mjs';
import '../../../Switch/Switch.mjs';
import '../../../TextArea/TextArea.mjs';
import 'react-use/lib/useClickAway';
import 'rc-slider';
import 'rc-slider/assets/index.css';
import 'rc-tooltip';
import '../../../MatchersUI/fieldMatchersUI.mjs';
import '../../../Link/Link.mjs';
import '../../../Link/TextLink.mjs';
import '../../../Layout/Grid/Grid.mjs';
import { Label } from '../../../Forms/Label.mjs';
import '../../../Combobox/ValuePill.mjs';
import '../../../FilterInput/FilterInput.mjs';
import 'uuid';
import 'react-dropzone';
import '../../../DateTimePickers/TimeRangePicker/TimePickerContent.mjs';
import '../../../DateTimePickers/RelativeTimeRangePicker/RelativeTimeRangePicker.mjs';
import '../../../Card/Card.mjs';
import '../../../FormattedValueDisplay/FormattedValueDisplay.mjs';
import '../../../Dropdown/ButtonSelect.mjs';
import '../../../PluginSignatureBadge/PluginSignatureBadge.mjs';
import '../../../uPlot/config.mjs';
import 'uplot';
import '../../../uPlot/utils.mjs';
import 'uplot/dist/uPlot.min.css';
import '../../../uPlot/PlotLegend.mjs';
import 'react-dom';
import '../../../BrowserLabel/Label.mjs';
import '../../../../graveyard/Graph/Graph.mjs';
import '../../../../graveyard/GraphNG/GraphNG.mjs';
import '../../../../graveyard/TimeSeries/TimeSeries.mjs';
import '../../../../graveyard/GraphNG/hooks.mjs';
import { operatorSelectableValues } from './FilterPopup.mjs';

const ITEM_HEIGHT = 28;
const MIN_HEIGHT = ITEM_HEIGHT * 5;
const REGEX_OPERATOR = operatorSelectableValues["Contains"];
const XPR_OPERATOR = operatorSelectableValues["Expression"];
const comparableValue = (value) => {
  value = value.trim().replace(/\\/g, "");
  if (/^(\d{4}-\d{2}-\d{2}|\d{4}\/\d{2}\/\d{2})/.test(value)) {
    const date = new Date(value);
    if (!isNaN(date.getTime())) {
      const fmt = getValueFormat("dateTimeAsIso");
      return formattedValueToString(fmt(date.getTime()));
    }
  }
  const num = parseFloat(value);
  if (!isNaN(num)) {
    return num;
  }
  const lvalue = value.toLowerCase();
  if (lvalue === "true" || lvalue === "false") {
    return lvalue === "true";
  }
  return value;
};
const FilterList = ({ options, values, caseSensitive, onChange, searchFilter, operator }) => {
  const regex = useMemo(() => new RegExp(searchFilter, caseSensitive ? void 0 : "i"), [searchFilter, caseSensitive]);
  const items = useMemo(
    () => options.filter((option) => {
      if (!searchFilter || operator.value === REGEX_OPERATOR.value) {
        if (option.label === void 0) {
          return false;
        }
        return regex.test(option.label);
      } else if (operator.value === XPR_OPERATOR.value) {
        if (option.value === void 0) {
          return false;
        }
        try {
          const xpr = searchFilter.replace(/\\/g, "");
          const fnc = new Function("$", `'use strict'; return ${xpr};`);
          const val = comparableValue(option.value);
          return fnc(val);
        } catch (_) {
        }
        return false;
      } else {
        if (option.value === void 0) {
          return false;
        }
        const value1 = comparableValue(option.value);
        const value2 = comparableValue(searchFilter);
        switch (operator.value) {
          case "=":
            return value1 === value2;
          case "!=":
            return value1 !== value2;
          case ">":
            return value1 > value2;
          case ">=":
            return value1 >= value2;
          case "<":
            return value1 < value2;
          case "<=":
            return value1 <= value2;
        }
        return false;
      }
    }),
    [options, regex, operator, searchFilter]
  );
  const selectedItems = useMemo(() => items.filter((item) => values.includes(item)), [items, values]);
  const selectCheckValue = useMemo(() => items.length === selectedItems.length, [items, selectedItems]);
  const selectCheckIndeterminate = useMemo(
    () => selectedItems.length > 0 && items.length > selectedItems.length,
    [items, selectedItems]
  );
  const selectCheckLabel = useMemo(
    () => selectedItems.length ? `${selectedItems.length} selected` : `Select all`,
    [selectedItems]
  );
  const selectCheckDescription = useMemo(
    () => items.length !== selectedItems.length ? "Add all displayed values to the filter" : "Remove all displayed values from the filter",
    [items, selectedItems]
  );
  const styles = useStyles2(getStyles);
  const theme = useTheme2();
  const gutter = theme.spacing.gridSize;
  const height = useMemo(() => Math.min(items.length * ITEM_HEIGHT, MIN_HEIGHT) + gutter, [gutter, items.length]);
  const onCheckedChanged = useCallback(
    (option) => (event) => {
      const newValues = event.currentTarget.checked ? values.concat(option) : values.filter((c) => c.value !== option.value);
      onChange(newValues);
    },
    [onChange, values]
  );
  const onSelectChanged = useCallback(() => {
    if (items.length === selectedItems.length) {
      const newValues = values.filter((item) => !items.includes(item));
      onChange(newValues);
    } else {
      const newValues = [.../* @__PURE__ */ new Set([...values, ...items])];
      onChange(newValues);
    }
  }, [onChange, values, items, selectedItems]);
  return /* @__PURE__ */ jsx(Stack, { direction: "column", children: items.length > 0 ? /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      FixedSizeList,
      {
        height,
        itemCount: items.length,
        itemSize: ITEM_HEIGHT,
        itemData: { items, values: selectedItems, onCheckedChanged, className: styles.filterListRow },
        width: "100%",
        className: styles.filterList,
        children: ItemRenderer
      }
    ),
    /* @__PURE__ */ jsx("div", { className: styles.filterListRow, children: /* @__PURE__ */ jsx(
      Checkbox,
      {
        value: selectCheckValue,
        indeterminate: selectCheckIndeterminate,
        label: selectCheckLabel,
        description: selectCheckDescription,
        onChange: onSelectChanged
      }
    ) })
  ] }) : /* @__PURE__ */ jsx(Label, { className: styles.noValuesLabel, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.table.no-values-label", children: "No values" }) }) });
};
function ItemRenderer({ index, style, data: { onCheckedChanged, items, values, className } }) {
  const option = items[index];
  const { value, label } = option;
  const isChecked = values.find((s) => s.value === value) !== void 0;
  return /* @__PURE__ */ jsx("div", { className, style, title: label, children: /* @__PURE__ */ jsx(Checkbox, { value: isChecked, label, onChange: onCheckedChanged(option) }) });
}
const getStyles = (theme) => ({
  filterList: css({
    label: "filterList",
    backgroundColor: theme.components.input.background,
    border: `1px solid ${theme.colors.border.medium}`,
    borderRadius: theme.shape.radius.default
  }),
  filterListRow: css({
    label: "filterListRow",
    cursor: "pointer",
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    padding: theme.spacing(0.5),
    ":hover": {
      backgroundColor: theme.colors.action.hover
    }
  }),
  selectDivider: css({
    label: "selectDivider",
    width: "100%",
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(0.5, 2)
  }),
  noValuesLabel: css({
    paddingTop: theme.spacing(1)
  })
});

export { FilterList, REGEX_OPERATOR };
//# sourceMappingURL=FilterList.mjs.map
