import { jsx, Fragment } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../../utils/skeleton.mjs';
import { clearLinkButtonStyles, Button } from '../../../Button/Button.mjs';
import '../../../Button/ButtonGroup.mjs';
import { DataLinksContextMenu } from '../../../DataLinks/DataLinksContextMenu.mjs';
import { getCellLinks } from '../utils.mjs';

const JSONCell = ({ value, justifyContent, field, rowIdx }) => {
  var _a;
  const styles = useStyles2(getStyles, justifyContent);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  let displayValue = value;
  if (typeof value === "string") {
    try {
      const parsed = JSON.parse(value);
      displayValue = JSON.stringify(parsed, null, " ");
    } catch (e) {
      displayValue = value;
    }
  } else {
    try {
      displayValue = JSON.stringify(value, null, " ");
    } catch (error) {
      displayValue = String(value);
    }
  }
  const hasLinks = Boolean((_a = getCellLinks(field, rowIdx)) == null ? void 0 : _a.length);
  return /* @__PURE__ */ jsx("div", { className: styles.jsonText, children: hasLinks ? /* @__PURE__ */ jsx(DataLinksContextMenu, { links: () => getCellLinks(field, rowIdx) || [], children: (api) => {
    if (api.openMenu) {
      return /* @__PURE__ */ jsx(Button, { className: cx(clearButtonStyle), onClick: api.openMenu, children: displayValue });
    } else {
      return /* @__PURE__ */ jsx(Fragment, { children: displayValue });
    }
  } }) : displayValue });
};
const getStyles = (theme, justifyContent) => ({
  jsonText: css({
    display: "flex",
    cursor: "pointer",
    fontFamily: "monospace",
    justifyContent
  })
});

export { JSONCell };
//# sourceMappingURL=JSONCell.mjs.map
