import { jsx, Fragment } from 'react/jsx-runtime';
import { ThresholdsMode, getFieldConfigWithMinMax, VizOrientation } from '@grafana/data';
import { BarGaugeDisplayMode, TableCellDisplayMode, BarGaugeValueMode } from '@grafana/schema';
import { BarGauge } from '../../../BarGauge/BarGauge.mjs';
import { DataLinksContextMenu } from '../../../DataLinks/DataLinksContextMenu.mjs';
import { getCellOptions, extractPixelValue, getCellLinks, getAlignmentFactor } from '../utils.mjs';

const defaultScale = {
  mode: ThresholdsMode.Absolute,
  steps: [
    {
      color: "blue",
      value: -Infinity
    },
    {
      color: "green",
      value: 20
    }
  ]
};
const BarGaugeCell = ({ value, field, theme, height, width, rowIdx }) => {
  var _a, _b;
  const displayValue = field.display(value);
  const cellOptions = getCellOptions(field);
  const heightOffset = extractPixelValue(theme.spacing(1));
  let config = getFieldConfigWithMinMax(field, false);
  if (!config.thresholds) {
    config = {
      ...config,
      thresholds: defaultScale
    };
  }
  let barGaugeMode = BarGaugeDisplayMode.Gradient;
  let valueDisplayMode = void 0;
  if (cellOptions.type === TableCellDisplayMode.Gauge) {
    barGaugeMode = (_a = cellOptions.mode) != null ? _a : BarGaugeDisplayMode.Gradient;
    valueDisplayMode = cellOptions.valueDisplayMode !== void 0 ? cellOptions.valueDisplayMode : BarGaugeValueMode.Text;
  }
  const hasLinks = Boolean((_b = getCellLinks(field, rowIdx)) == null ? void 0 : _b.length);
  const alignmentFactors = getAlignmentFactor(field, displayValue, rowIdx);
  const renderComponent = (menuProps) => {
    const { openMenu } = menuProps;
    return /* @__PURE__ */ jsx(
      BarGauge,
      {
        width,
        height: height - heightOffset,
        field: config,
        display: field.display,
        text: { valueSize: 14 },
        value: displayValue,
        orientation: VizOrientation.Horizontal,
        theme,
        alignmentFactors,
        onClick: openMenu,
        itemSpacing: 1,
        lcdCellWidth: 8,
        displayMode: barGaugeMode,
        valueDisplayMode
      }
    );
  };
  return /* @__PURE__ */ jsx(Fragment, { children: hasLinks ? /* @__PURE__ */ jsx(
    DataLinksContextMenu,
    {
      links: () => getCellLinks(field, rowIdx) || [],
      style: { display: "flex", width: "100%" },
      children: (api) => renderComponent(api)
    }
  ) : renderComponent({}) });
};

export { BarGaugeCell };
//# sourceMappingURL=BarGaugeCell.mjs.map
