import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useState, useRef, useEffect } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';

const ScrollIndicators = ({ children }) => {
  const [showScrollTopIndicator, setShowTopScrollIndicator] = useState(false);
  const [showScrollBottomIndicator, setShowBottomScrollIndicator] = useState(false);
  const scrollTopMarker = useRef(null);
  const scrollBottomMarker = useRef(null);
  const styles = useStyles2(getStyles);
  useEffect(() => {
    const intersectionObserver = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.target === scrollTopMarker.current) {
          setShowTopScrollIndicator(!entry.isIntersecting);
        } else if (entry.target === scrollBottomMarker.current) {
          setShowBottomScrollIndicator(!entry.isIntersecting);
        }
      });
    });
    [scrollTopMarker, scrollBottomMarker].forEach((ref) => {
      if (ref.current) {
        intersectionObserver.observe(ref.current);
      }
    });
    return () => intersectionObserver.disconnect();
  }, []);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      "div",
      {
        className: cx(styles.scrollIndicator, styles.scrollTopIndicator, {
          [styles.scrollIndicatorVisible]: showScrollTopIndicator
        }),
        role: "presentation"
      }
    ),
    /* @__PURE__ */ jsxs("div", { className: styles.scrollContent, children: [
      /* @__PURE__ */ jsx("div", { ref: scrollTopMarker, className: cx(styles.scrollMarker, styles.scrollTopMarker) }),
      children,
      /* @__PURE__ */ jsx("div", { ref: scrollBottomMarker, className: cx(styles.scrollMarker, styles.scrollBottomMarker) })
    ] }),
    /* @__PURE__ */ jsx(
      "div",
      {
        className: cx(styles.scrollIndicator, styles.scrollBottomIndicator, {
          [styles.scrollIndicatorVisible]: showScrollBottomIndicator
        }),
        role: "presentation"
      }
    )
  ] });
};
const getStyles = (theme) => {
  const scrollGradientColor = `rgba(0, 0, 0, ${theme.isDark ? 0.25 : 0.08})`;
  return {
    scrollContent: css({
      display: "flex",
      flexDirection: "column",
      flexGrow: 1,
      position: "relative"
    }),
    scrollIndicator: css({
      height: `max(5%, ${theme.spacing(3)})`,
      left: 0,
      opacity: 0,
      pointerEvents: "none",
      position: "absolute",
      right: 0,
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: theme.transitions.create("opacity")
      },
      zIndex: 1
    }),
    scrollTopIndicator: css({
      background: `linear-gradient(0deg, transparent, ${scrollGradientColor})`,
      top: 0
    }),
    scrollBottomIndicator: css({
      background: `linear-gradient(180deg, transparent, ${scrollGradientColor})`,
      bottom: 0
    }),
    scrollIndicatorVisible: css({
      opacity: 1
    }),
    scrollMarker: css({
      height: "1px",
      left: 0,
      pointerEvents: "none",
      position: "absolute",
      right: 0
    }),
    scrollTopMarker: css({
      top: 0
    }),
    scrollBottomMarker: css({
      bottom: 0
    })
  };
};

export { ScrollIndicators };
//# sourceMappingURL=ScrollIndicators.mjs.map
