import { jsx } from 'react/jsx-runtime';
import { memo, useCallback } from 'react';
import { FieldMatcherID, fieldMatchers } from '@grafana/data';
import { Input } from '../Input/Input.mjs';
import { MultiSelect } from '../Select/Select.mjs';
import { useFieldDisplayNames, useSelectOptions, frameHasName } from './utils.mjs';

const FieldNamesMatcherEditor = memo((props) => {
  var _a;
  const { data, options, onChange: onChangeFromProps } = props;
  const { readOnly, prefix } = options;
  const names = useFieldDisplayNames(data);
  const selectOptions = useSelectOptions(names, void 0);
  const onChange = useCallback(
    (selections) => {
      if (!Array.isArray(selections)) {
        return;
      }
      return onChangeFromProps({
        ...options,
        names: selections.reduce((all, current) => {
          if (!frameHasName(current.value, names)) {
            return all;
          }
          all.push(current.value);
          return all;
        }, [])
      });
    },
    [names, onChangeFromProps, options]
  );
  if (readOnly) {
    const displayNames = ((_a = options.names) != null ? _a : []).join(", ");
    return /* @__PURE__ */ jsx(Input, { value: displayNames, readOnly: true, disabled: true, prefix });
  }
  return /* @__PURE__ */ jsx(MultiSelect, { value: options.names, options: selectOptions, onChange });
});
FieldNamesMatcherEditor.displayName = "FieldNameMatcherEditor";
const fieldNamesMatcherItem = {
  id: FieldMatcherID.byNames,
  component: FieldNamesMatcherEditor,
  matcher: fieldMatchers.get(FieldMatcherID.byNames),
  name: "Fields with name",
  description: "Set properties for a specific field",
  optionsToLabel: (options) => {
    var _a;
    return ((_a = options.names) != null ? _a : []).join(", ");
  },
  excludeFromPicker: true
};

export { FieldNamesMatcherEditor, fieldNamesMatcherItem };
//# sourceMappingURL=FieldNamesMatcherEditor.mjs.map
