import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@react-aria/dialog';
import '@react-aria/focus';
import '@react-aria/overlays';
import { memo } from 'react';
import { rangeUtil, dateMath } from '@grafana/data';
import '@grafana/e2e-selectors';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import '../../utils/i18n.mjs';
import '../Button/Button.mjs';
import '../Button/ButtonGroup.mjs';
import '../Portal/Portal.mjs';
import '../ToolbarButton/ToolbarButton.mjs';
import '../ToolbarButton/ToolbarButtonRow.mjs';
import '../Tooltip/Tooltip.mjs';
import './TimeRangePicker/TimePickerContent.mjs';
import 'react-use';
import './TimeRangeContext.mjs';

const TimePickerButtonLabel = memo(({ hideText, value, timeZone, quickRanges }) => {
  const styles = useStyles2(getLabelStyles);
  if (hideText) {
    return null;
  }
  return /* @__PURE__ */ jsxs("span", { className: styles.container, "aria-live": "polite", "aria-atomic": "true", children: [
    /* @__PURE__ */ jsx("span", { children: formattedRange(value, timeZone, quickRanges) }),
    /* @__PURE__ */ jsx("span", { className: styles.utc, children: rangeUtil.describeTimeRangeAbbreviation(value, timeZone) })
  ] });
});
TimePickerButtonLabel.displayName = "TimePickerButtonLabel";
const formattedRange = (value, timeZone, quickRanges) => {
  const adjustedTimeRange = {
    to: dateMath.isMathString(value.raw.to) ? value.raw.to : value.to,
    from: dateMath.isMathString(value.raw.from) ? value.raw.from : value.from
  };
  return rangeUtil.describeTimeRange(adjustedTimeRange, timeZone, quickRanges);
};
const getLabelStyles = (theme) => {
  return {
    container: css({
      display: "flex",
      alignItems: "center",
      whiteSpace: "nowrap"
    }),
    utc: css({
      color: theme.v1.palette.orange,
      fontSize: theme.typography.size.sm,
      paddingLeft: "6px",
      lineHeight: "28px",
      verticalAlign: "bottom",
      fontWeight: theme.typography.fontWeightMedium
    })
  };
};

export { TimePickerButtonLabel };
//# sourceMappingURL=TimeRangePicker.mjs.map
