import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { t } from '../../utils/i18n.mjs';
import { InlineField } from '../Forms/InlineField.mjs';
import { Stack } from '../Layout/Stack/Stack.mjs';
import { InlineSwitch } from '../Switch/Switch.mjs';

const LABEL_WIDTH = 26;
const HttpProxySettings = ({
  dataSourceConfig,
  onChange,
  showForwardOAuthIdentityOption = true
}) => {
  const gridLayout = useStyles2(getGridLayout);
  return /* @__PURE__ */ jsxs("div", { className: gridLayout, children: [
    /* @__PURE__ */ jsxs(Stack, { direction: "row", gap: 0.5, children: [
      /* @__PURE__ */ jsx(
        InlineField,
        {
          label: t("grafana-ui.data-source-http-proxy-settings.ts-client-auth-label", "TLS Client Auth"),
          labelWidth: LABEL_WIDTH,
          disabled: dataSourceConfig.readOnly,
          children: /* @__PURE__ */ jsx(
            InlineSwitch,
            {
              id: "http-settings-tls-client-auth",
              value: dataSourceConfig.jsonData.tlsAuth || false,
              onChange: (event) => onChange({ ...dataSourceConfig.jsonData, tlsAuth: event.currentTarget.checked })
            }
          )
        }
      ),
      /* @__PURE__ */ jsx(
        InlineField,
        {
          label: t("grafana-ui.data-source-http-proxy-settings.with-ca-cert-label", "With CA Cert"),
          tooltip: t(
            "grafana-ui.data-source-http-proxy-settings.with-ca-cert-tooltip",
            "Needed for verifying self-signed TLS Certs"
          ),
          labelWidth: LABEL_WIDTH,
          disabled: dataSourceConfig.readOnly,
          children: /* @__PURE__ */ jsx(
            InlineSwitch,
            {
              id: "http-settings-ca-cert",
              value: dataSourceConfig.jsonData.tlsAuthWithCACert || false,
              onChange: (event) => onChange({ ...dataSourceConfig.jsonData, tlsAuthWithCACert: event.currentTarget.checked })
            }
          )
        }
      )
    ] }),
    /* @__PURE__ */ jsx(
      InlineField,
      {
        label: t("grafana-ui.data-source-http-proxy-settings.skip-tls-verify-label", "Skip TLS Verify"),
        labelWidth: LABEL_WIDTH,
        disabled: dataSourceConfig.readOnly,
        children: /* @__PURE__ */ jsx(
          InlineSwitch,
          {
            id: "http-settings-skip-tls-verify",
            value: dataSourceConfig.jsonData.tlsSkipVerify || false,
            onChange: (event) => onChange({ ...dataSourceConfig.jsonData, tlsSkipVerify: event.currentTarget.checked })
          }
        )
      }
    ),
    showForwardOAuthIdentityOption && /* @__PURE__ */ jsx(
      InlineField,
      {
        label: t("grafana-ui.data-source-http-proxy-settings.oauth-identity-label", "Forward OAuth Identity"),
        tooltip: t(
          "grafana-ui.data-source-http-proxy-settings.oauth-identity-tooltip",
          "Forward the user's upstream OAuth identity to the data source (Their access token gets passed along)."
        ),
        labelWidth: LABEL_WIDTH,
        disabled: dataSourceConfig.readOnly,
        children: /* @__PURE__ */ jsx(
          InlineSwitch,
          {
            id: "http-settings-forward-oauth",
            value: dataSourceConfig.jsonData.oauthPassThru || false,
            onChange: (event) => onChange({ ...dataSourceConfig.jsonData, oauthPassThru: event.currentTarget.checked })
          }
        )
      }
    )
  ] });
};
const getGridLayout = (theme) => css({
  display: "grid",
  gridTemplateColumns: "auto",
  gap: 0
  // Inline field has a margin
});

export { HttpProxySettings };
//# sourceMappingURL=HttpProxySettings.mjs.map
