'use strict';

var jsxRuntime = require('react/jsx-runtime');
var css = require('@emotion/css');
require('react-data-grid/lib/styles.css');
var React = require('react');
var DataGrid = require('react-data-grid');
var reactUse = require('react-use');
var data = require('@grafana/data');
var schema = require('@grafana/schema');
var hoistNonReactStatics = require('hoist-non-react-statics');
var memoize = require('micro-memoize');
require('@emotion/react');
var tinycolor = require('tinycolor2');
var i18next = require('i18next');
var reactI18next = require('react-i18next');
var e2eSelectors = require('@grafana/e2e-selectors');
var lodash = require('lodash');
var SVG = require('react-inlinesvg');
var ReactDOM = require('react-dom');
var react = require('@floating-ui/react');
var slate = require('slate');
var ReactDOMServer = require('react-dom/server');
var reactTransitionGroup = require('react-transition-group');
var dialog = require('@react-aria/dialog');
var focus = require('@react-aria/focus');
var overlays = require('@react-aria/overlays');
var RcDrawer = require('rc-drawer');
require('rc-drawer/assets/index.css');
var reactWindow = require('react-window');
var classNames = require('classnames');
var ReactSelect = require('react-select');
var ReactAsyncSelect = require('react-select/async');
var Creatable = require('react-select/creatable');
var Scrollbars = require('react-custom-scrollbars-2');
var RCCascader = require('rc-cascader');
var useMeasure = require('react-use/lib/useMeasure');
var AsyncCreatable = require('react-select/async-creatable');
var reactColorful = require('react-colorful');
var dateFns = require('date-fns');
require('@tanstack/react-virtual');
require('downshift');
var uFuzzy = require('@leeoniya/ufuzzy');
var Calendar = require('react-calendar');
var uuid = require('uuid');
var RcPicker = require('rc-picker');
var generateConfig = require('rc-picker/lib/generate/moment');
var locale = require('rc-picker/lib/locale/en_US');
require('rc-picker/assets/index.css');
var reactTable = require('react-table');
var Skeleton = require('react-loading-skeleton');
var reactHookForm = require('react-hook-form');
var Plain = require('slate-plain-serializer');
var slateReact = require('slate-react');
var isHotkey = require('is-hotkey');
var Prism = require('prismjs');
var immutable = require('immutable');
var calculateSize = require('calculate-size');
var Highlighter = require('react-highlight-words');
var reactRouterDomV5Compat = require('react-router-dom-v5-compat');
var rxjs = require('rxjs');
var operators = require('rxjs/operators');
var WKT = require('ol/format/WKT');
var geom = require('ol/geom');
var uPlot = require('uplot');
require('uplot/dist/uPlot.min.css');
var $ = require('jquery');
var usePrevious = require('react-use/lib/usePrevious');
var useClickAway = require('react-use/lib/useClickAway');
require('@hello-pangea/dnd');
var faroWebSdk = require('@grafana/faro-web-sdk');
require('rc-slider');
require('rc-slider/assets/index.css');
require('rc-tooltip');
require('react-dropzone');
var uwrap = require('uwrap');
var format = require('ol/format');

function _interopDefaultCompat (e) { return e && typeof e === 'object' && 'default' in e ? e : { default: e }; }

function _interopNamespaceCompat(e) {
  if (e && typeof e === 'object' && 'default' in e) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceCompat(React);
var DataGrid__default = /*#__PURE__*/_interopDefaultCompat(DataGrid);
var hoistNonReactStatics__default = /*#__PURE__*/_interopDefaultCompat(hoistNonReactStatics);
var memoize__default = /*#__PURE__*/_interopDefaultCompat(memoize);
var tinycolor__default = /*#__PURE__*/_interopDefaultCompat(tinycolor);
var i18next__default = /*#__PURE__*/_interopDefaultCompat(i18next);
var SVG__default = /*#__PURE__*/_interopDefaultCompat(SVG);
var ReactDOM__default = /*#__PURE__*/_interopDefaultCompat(ReactDOM);
var ReactDOMServer__default = /*#__PURE__*/_interopDefaultCompat(ReactDOMServer);
var RcDrawer__default = /*#__PURE__*/_interopDefaultCompat(RcDrawer);
var classNames__default = /*#__PURE__*/_interopDefaultCompat(classNames);
var ReactSelect__default = /*#__PURE__*/_interopDefaultCompat(ReactSelect);
var ReactAsyncSelect__default = /*#__PURE__*/_interopDefaultCompat(ReactAsyncSelect);
var Creatable__default = /*#__PURE__*/_interopDefaultCompat(Creatable);
var Scrollbars__default = /*#__PURE__*/_interopDefaultCompat(Scrollbars);
var RCCascader__default = /*#__PURE__*/_interopDefaultCompat(RCCascader);
var useMeasure__default = /*#__PURE__*/_interopDefaultCompat(useMeasure);
var AsyncCreatable__default = /*#__PURE__*/_interopDefaultCompat(AsyncCreatable);
var uFuzzy__default = /*#__PURE__*/_interopDefaultCompat(uFuzzy);
var Calendar__default = /*#__PURE__*/_interopDefaultCompat(Calendar);
var RcPicker__default = /*#__PURE__*/_interopDefaultCompat(RcPicker);
var generateConfig__default = /*#__PURE__*/_interopDefaultCompat(generateConfig);
var locale__default = /*#__PURE__*/_interopDefaultCompat(locale);
var Skeleton__default = /*#__PURE__*/_interopDefaultCompat(Skeleton);
var Plain__default = /*#__PURE__*/_interopDefaultCompat(Plain);
var Prism__default = /*#__PURE__*/_interopDefaultCompat(Prism);
var calculateSize__default = /*#__PURE__*/_interopDefaultCompat(calculateSize);
var Highlighter__default = /*#__PURE__*/_interopDefaultCompat(Highlighter);
var WKT__default = /*#__PURE__*/_interopDefaultCompat(WKT);
var uPlot__default = /*#__PURE__*/_interopDefaultCompat(uPlot);
var $__default = /*#__PURE__*/_interopDefaultCompat($);
var usePrevious__default = /*#__PURE__*/_interopDefaultCompat(usePrevious);
var useClickAway__default = /*#__PURE__*/_interopDefaultCompat(useClickAway);

const fadeIn = css.keyframes({
  "0%": {
    opacity: 0
  },
  "100%": {
    opacity: 1
  }
});
const skeletonAnimation = {
  animationName: fadeIn,
  animationDelay: "100ms",
  animationTimingFunction: "ease-in",
  animationDuration: "100ms",
  animationFillMode: "backwards"
};
const attachSkeleton = (Component, Skeleton) => {
  const skeletonWrapper = (props) => {
    return /* @__PURE__ */ jsxRuntime.jsx(
      Skeleton,
      {
        ...props,
        rootProps: {
          style: skeletonAnimation
        }
      }
    );
  };
  return Object.assign(Component, { Skeleton: skeletonWrapper });
};

function stylesFactory(stylesCreator) {
  return memoize__default.default(stylesCreator);
}

const memoizedStyleCreators = /* @__PURE__ */ new WeakMap();
const withTheme2 = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = data.ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ jsxRuntime.jsx(ContextComponent.Consumer, { children: (theme) => /* @__PURE__ */ jsxRuntime.jsx(Component, { ...props, theme }) })
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics__default.default(WithTheme, Component);
  return WithTheme;
};
function useTheme2() {
  return React.useContext(data.ThemeContext);
}
function useStyles2(getStyles, ...additionalArguments) {
  const theme = useTheme2();
  if (!theme.colors.background.elevated) {
    theme.colors.background.elevated = theme.colors.mode === "light" ? theme.colors.background.primary : theme.colors.background.secondary;
  }
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = memoize__default.default(getStyles, { maxSize: 10 });
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme, ...additionalArguments);
}

function hoverColor(color, theme) {
  return theme.isDark ? tinycolor__default.default(color).brighten(2).toString() : tinycolor__default.default(color).darken(2).toString();
}
function mediaUp(breakpoint) {
  return `only screen and (min-width: ${breakpoint})`;
}
function getMouseFocusStyles(theme) {
  return {
    outline: "none",
    boxShadow: `none`
  };
}
function getFocusStyles(theme) {
  return {
    outline: "2px dotted transparent",
    outlineOffset: "2px",
    boxShadow: `0 0 0 2px ${theme.colors.background.canvas}, 0 0 0px 4px ${theme.colors.primary.main}`,
    transitionTimingFunction: `cubic-bezier(0.19, 1, 0.22, 1)`,
    transitionDuration: "0.2s",
    transitionProperty: "outline, outline-offset, box-shadow"
  };
}
const getTooltipContainerStyles = (theme) => ({
  overflow: "hidden",
  background: theme.colors.background.elevated,
  boxShadow: theme.shadows.z2,
  maxWidth: "800px",
  padding: theme.spacing(1),
  borderRadius: theme.shape.radius.default,
  zIndex: theme.zIndex.tooltip
});
const getInternalRadius = (theme, offset, additionalOptions = {}) => {
  const { parentBorderWidth = 1, parentBorderRadius } = additionalOptions;
  const parentBorderRadiusPx = parentBorderRadius !== void 0 ? `${parentBorderRadius}px` : theme.shape.radius.default;
  return `calc(max(0px, ${parentBorderRadiusPx} - ${offset}px - ${parentBorderWidth}px))`;
};

function initI18n() {
  if (typeof i18next__default.default.options.resources !== "object") {
    i18next__default.default.use(reactI18next.initReactI18next).init({
      resources: {},
      returnEmptyString: false,
      lng: "en-US"
      // this should be the locale of the phrases in our source JSX
    });
  }
}
const Trans = (props) => {
  initI18n();
  return /* @__PURE__ */ jsxRuntime.jsx(reactI18next.Trans, { ...props });
};
const tFunc = i18next__default.default.t;
const t = (id, defaultMessage, values) => {
  initI18n();
  return tFunc(id, defaultMessage, values);
};

function breakpointCSS(theme, prop, getCSS, key) {
  const value = prop[key];
  if (value !== void 0 && value !== null) {
    return {
      [theme.breakpoints.up(key)]: getCSS(value)
    };
  }
  return;
}
function getResponsiveStyle(theme, prop, getCSS) {
  if (prop === void 0 || prop === null) {
    return null;
  }
  if (typeof prop !== "object" || !("xs" in prop)) {
    return getCSS(prop);
  }
  return [
    breakpointCSS(theme, prop, getCSS, "xs"),
    breakpointCSS(theme, prop, getCSS, "sm"),
    breakpointCSS(theme, prop, getCSS, "md"),
    breakpointCSS(theme, prop, getCSS, "lg"),
    breakpointCSS(theme, prop, getCSS, "xl"),
    breakpointCSS(theme, prop, getCSS, "xxl")
  ];
}

const getSizeStyles = (theme, width, minWidth, maxWidth, height, minHeight, maxHeight) => {
  return css.css([
    getResponsiveStyle(theme, width, (val) => ({
      width: theme.spacing(val)
    })),
    getResponsiveStyle(theme, minWidth, (val) => ({
      minWidth: theme.spacing(val)
    })),
    getResponsiveStyle(theme, maxWidth, (val) => ({
      maxWidth: theme.spacing(val)
    })),
    getResponsiveStyle(theme, height, (val) => ({
      height: theme.spacing(val)
    })),
    getResponsiveStyle(theme, minHeight, (val) => ({
      minHeight: theme.spacing(val)
    })),
    getResponsiveStyle(theme, maxHeight, (val) => ({
      maxHeight: theme.spacing(val)
    }))
  ]);
};

const Box = React.forwardRef((props, ref) => {
  const {
    children,
    margin,
    marginX,
    marginY,
    marginTop,
    marginBottom,
    marginLeft,
    marginRight,
    padding,
    paddingX,
    paddingY,
    paddingTop,
    paddingBottom,
    paddingLeft,
    paddingRight,
    display,
    backgroundColor,
    grow,
    shrink,
    basis,
    flex,
    borderColor,
    borderStyle,
    borderRadius,
    direction,
    justifyContent,
    alignItems,
    boxShadow,
    element,
    gap,
    width,
    minWidth,
    maxWidth,
    height,
    minHeight,
    maxHeight,
    position,
    ...rest
  } = props;
  const styles = useStyles2(
    getStyles$1x,
    margin,
    marginX,
    marginY,
    marginTop,
    marginBottom,
    marginLeft,
    marginRight,
    padding,
    paddingX,
    paddingY,
    paddingTop,
    paddingBottom,
    paddingLeft,
    paddingRight,
    display,
    backgroundColor,
    grow,
    shrink,
    basis,
    flex,
    borderColor,
    borderStyle,
    borderRadius,
    direction,
    justifyContent,
    alignItems,
    boxShadow,
    gap,
    position
  );
  const sizeStyles = useStyles2(getSizeStyles, width, minWidth, maxWidth, height, minHeight, maxHeight);
  const Element = element != null ? element : "div";
  return /* @__PURE__ */ jsxRuntime.jsx(Element, { ref, className: css.cx(styles.root, sizeStyles), ...rest, children });
});
Box.displayName = "Box";
const customBorderColor = (color, theme) => {
  switch (color) {
    case "error":
    case "success":
    case "info":
    case "warning":
      return theme.colors[color].borderTransparent;
    default:
      return color ? theme.colors.border[color] : void 0;
  }
};
const customBackgroundColor = (color, theme) => {
  switch (color) {
    case "error":
    case "success":
    case "info":
    case "warning":
      return theme.colors[color].transparent;
    default:
      return color ? theme.colors.background[color] : void 0;
  }
};
const getStyles$1x = (theme, margin, marginX, marginY, marginTop, marginBottom, marginLeft, marginRight, padding, paddingX, paddingY, paddingTop, paddingBottom, paddingLeft, paddingRight, display, backgroundColor, grow, shrink, basis, flex, borderColor, borderStyle, borderRadius, direction, justifyContent, alignItems, boxShadow, gap, position) => {
  return {
    root: css.css([
      getResponsiveStyle(theme, margin, (val) => ({
        margin: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginX, (val) => ({
        marginLeft: theme.spacing(val),
        marginRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginY, (val) => ({
        marginTop: theme.spacing(val),
        marginBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginTop, (val) => ({
        marginTop: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginBottom, (val) => ({
        marginBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginLeft, (val) => ({
        marginLeft: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginRight, (val) => ({
        marginRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, padding, (val) => ({
        padding: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingX, (val) => ({
        paddingLeft: theme.spacing(val),
        paddingRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingY, (val) => ({
        paddingTop: theme.spacing(val),
        paddingBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingTop, (val) => ({
        paddingTop: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingBottom, (val) => ({
        paddingBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingLeft, (val) => ({
        paddingLeft: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingRight, (val) => ({
        paddingRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, display, (val) => ({
        display: val
      })),
      getResponsiveStyle(theme, backgroundColor, (val) => ({
        backgroundColor: customBackgroundColor(val, theme)
      })),
      getResponsiveStyle(theme, direction, (val) => ({
        flexDirection: val
      })),
      getResponsiveStyle(theme, grow, (val) => ({
        flexGrow: val
      })),
      getResponsiveStyle(theme, shrink, (val) => ({
        flexShrink: val
      })),
      getResponsiveStyle(theme, basis, (val) => ({
        flexBasis: val
      })),
      getResponsiveStyle(theme, flex, (val) => ({
        flex: val
      })),
      getResponsiveStyle(theme, borderStyle, (val) => ({
        borderStyle: val
      })),
      getResponsiveStyle(theme, borderColor, (val) => ({
        borderColor: customBorderColor(val, theme)
      })),
      (borderStyle || borderColor) && {
        borderWidth: "1px"
      },
      getResponsiveStyle(theme, justifyContent, (val) => ({
        justifyContent: val
      })),
      getResponsiveStyle(theme, alignItems, (val) => ({
        alignItems: val
      })),
      getResponsiveStyle(theme, borderRadius, (val) => ({
        borderRadius: theme.shape.radius[val]
      })),
      getResponsiveStyle(theme, boxShadow, (val) => ({
        boxShadow: theme.shadows[val]
      })),
      getResponsiveStyle(theme, gap, (val) => ({
        gap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, position, (val) => ({
        position: val
      }))
    ])
  };
};

function MenuDivider() {
  const styles = useStyles2(getStyles$1w);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.divider });
}
const getStyles$1w = (theme) => {
  return {
    divider: css.css({
      height: 1,
      backgroundColor: theme.colors.border.weak,
      margin: theme.spacing(0.5, 0)
    })
  };
};

const MenuGroup = ({ label, ariaLabel, children }) => {
  const styles = useStyles2(getStyles$1v);
  const labelID = `group-label-${lodash.uniqueId()}`;
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { role: "group", "aria-labelledby": !ariaLabel && label ? labelID : void 0, "aria-label": ariaLabel, children: [
    label && /* @__PURE__ */ jsxRuntime.jsx("label", { id: labelID, className: styles.groupLabel, "aria-hidden": true, children: label }),
    children
  ] });
};
MenuGroup.displayName = "MenuGroup";
const getStyles$1v = (theme) => {
  return {
    groupLabel: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.size.sm,
      padding: theme.spacing(0.5, 1)
    })
  };
};

const spin = css.keyframes({
  "0%": {
    transform: "rotate(0deg)"
  },
  "100%": {
    transform: "rotate(359deg)"
  }
});

const alwaysMonoIcons = [
  "grafana",
  "favorite",
  "heart-break",
  "heart",
  "panel-add",
  "library-panel",
  "circle-mono"
];
function getIconSubDir(name, type) {
  if (name == null ? void 0 : name.startsWith("gf-")) {
    return "custom";
  } else if (alwaysMonoIcons.includes(name)) {
    return "mono";
  } else if (type === "default") {
    return "unicons";
  } else if (type === "solid") {
    return "solid";
  } else {
    return "mono";
  }
}
function getSvgSize(size) {
  switch (size) {
    case "xs":
      return 12;
    case "sm":
      return 14;
    case "md":
      return 16;
    case "lg":
      return 18;
    case "xl":
      return 24;
    case "xxl":
      return 36;
    case "xxxl":
      return 48;
  }
}
let iconRoot;
function getIconRoot() {
  if (iconRoot) {
    return iconRoot;
  }
  const grafanaPublicPath = typeof window !== "undefined" && window.__grafana_public_path__;
  if (grafanaPublicPath) {
    iconRoot = grafanaPublicPath + "img/icons/";
  } else {
    iconRoot = "public/img/icons/";
  }
  return iconRoot;
}

const getIconStyles = (theme) => {
  return {
    icon: css.css({
      display: "inline-block",
      fill: "currentColor",
      flexShrink: 0,
      label: "Icon",
      // line-height: 0; is needed for correct icon alignment in Safari
      lineHeight: 0,
      verticalAlign: "middle"
    }),
    orange: css.css({
      fill: theme.v1.palette.orange
    }),
    spin: css.css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${spin} 2s infinite linear`
      }
    })
  };
};
const Icon = React__namespace.forwardRef(
  ({ size = "md", type = "default", name, className, style, title = "", ...rest }, ref) => {
    const styles = useStyles2(getIconStyles);
    if (!data.isIconName(name)) {
      console.warn("Icon component passed an invalid icon name", name);
    }
    const iconName = name === "fa fa-spinner" ? "spinner" : name;
    const iconRoot = getIconRoot();
    const svgSize = getSvgSize(size);
    const svgHgt = svgSize;
    const svgWid = name.startsWith("gf-bar-align") ? 16 : name.startsWith("gf-interp") ? 30 : svgSize;
    const subDir = getIconSubDir(iconName, type);
    const svgPath = `${iconRoot}${subDir}/${iconName}.svg`;
    const composedClassName = css.cx(
      styles.icon,
      className,
      type === "mono" ? { [styles.orange]: name === "favorite" } : "",
      {
        [styles.spin]: iconName === "spinner"
      }
    );
    return /* @__PURE__ */ jsxRuntime.jsx(
      SVG__default.default,
      {
        "aria-hidden": rest.tabIndex === void 0 && !title && !rest["aria-label"] && !rest["aria-labelledby"] && !rest["aria-describedby"],
        innerRef: ref,
        src: svgPath,
        width: svgWid,
        height: svgHgt,
        title,
        className: composedClassName,
        style,
        loader: /* @__PURE__ */ jsxRuntime.jsx(
          "div",
          {
            className: css.cx(
              css.css({
                width: svgWid,
                height: svgHgt
              }),
              composedClassName
            )
          }
        ),
        ...rest
      }
    );
  }
);
Icon.displayName = "Icon";

const Stack = React__namespace.forwardRef((props, ref) => {
  const {
    gap = 1,
    rowGap,
    columnGap,
    alignItems,
    justifyContent,
    direction,
    wrap,
    children,
    grow,
    shrink,
    basis,
    flex,
    width,
    minWidth,
    maxWidth,
    height,
    minHeight,
    maxHeight,
    ...rest
  } = props;
  const styles = useStyles2(
    getStyles$1u,
    gap,
    rowGap,
    columnGap,
    alignItems,
    justifyContent,
    direction,
    wrap,
    grow,
    shrink,
    basis,
    flex
  );
  const sizeStyles = useStyles2(getSizeStyles, width, minWidth, maxWidth, height, minHeight, maxHeight);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ref, className: css.cx(styles.flex, sizeStyles), ...rest, children });
});
Stack.displayName = "Stack";
const getStyles$1u = (theme, gap, rowGap, columnGap, alignItems, justifyContent, direction, wrap, grow, shrink, basis, flex) => {
  return {
    flex: css.css([
      {
        display: "flex"
      },
      getResponsiveStyle(theme, direction, (val) => ({
        flexDirection: val
      })),
      getResponsiveStyle(theme, wrap, (val) => ({
        flexWrap: typeof val === "boolean" ? val ? "wrap" : "nowrap" : val
      })),
      getResponsiveStyle(theme, alignItems, (val) => ({
        alignItems: val
      })),
      getResponsiveStyle(theme, justifyContent, (val) => ({
        justifyContent: val
      })),
      getResponsiveStyle(theme, gap, (val) => ({
        gap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, rowGap, (val) => ({
        rowGap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, columnGap, (val) => ({
        columnGap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, grow, (val) => ({
        flexGrow: val
      })),
      getResponsiveStyle(theme, shrink, (val) => ({
        flexShrink: val
      })),
      getResponsiveStyle(theme, basis, (val) => ({
        flexBasis: val
      })),
      getResponsiveStyle(theme, flex, (val) => ({
        flex: val
      }))
    ])
  };
};

const modulo$2 = (a, n) => (a % n + n) % n;
const UNFOCUSED = -1;
const useMenuFocus = ({
  localRef,
  isMenuOpen,
  close,
  onOpen,
  onClose,
  onKeyDown
}) => {
  const [focusedItem, setFocusedItem] = React.useState(UNFOCUSED);
  React.useEffect(() => {
    if (isMenuOpen) {
      setFocusedItem(0);
    }
  }, [isMenuOpen]);
  React.useEffect(() => {
    var _a, _b;
    const menuItems = (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.querySelectorAll(
      '[data-role="menuitem"]:not([data-disabled])'
    );
    (_b = menuItems == null ? void 0 : menuItems[focusedItem]) == null ? void 0 : _b.focus();
    menuItems == null ? void 0 : menuItems.forEach((menuItem, i) => {
      menuItem.tabIndex = i === focusedItem ? 0 : -1;
    });
  }, [localRef, focusedItem]);
  reactUse.useEffectOnce(() => {
    onOpen == null ? void 0 : onOpen(setFocusedItem);
  });
  const handleKeys = (event) => {
    var _a, _b, _c;
    const menuItems = (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.querySelectorAll(
      '[data-role="menuitem"]:not([data-disabled])'
    );
    const menuItemsCount = (_b = menuItems == null ? void 0 : menuItems.length) != null ? _b : 0;
    switch (event.key) {
      case "ArrowUp":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(modulo$2(focusedItem - 1, menuItemsCount));
        break;
      case "ArrowDown":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(modulo$2(focusedItem + 1, menuItemsCount));
        break;
      case "ArrowLeft":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(UNFOCUSED);
        close == null ? void 0 : close();
        break;
      case "Home":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(0);
        break;
      case "End":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(menuItemsCount - 1);
        break;
      case "Enter":
        event.preventDefault();
        event.stopPropagation();
        (_c = menuItems == null ? void 0 : menuItems[focusedItem]) == null ? void 0 : _c.click();
        break;
      case "Escape":
        onClose == null ? void 0 : onClose();
        break;
      case "Tab":
        event.preventDefault();
        onClose == null ? void 0 : onClose();
        break;
    }
    onKeyDown == null ? void 0 : onKeyDown(event);
  };
  return [handleKeys];
};

const isElementOverflowing = (element) => {
  if (!element) {
    return false;
  }
  const wrapperPos = element.parentElement.getBoundingClientRect();
  const pos = element.getBoundingClientRect();
  return pos.width !== 0 && wrapperPos.right + pos.width + 10 > window.innerWidth;
};

const SubMenu = React.memo(({ items, isOpen, close, customStyle }) => {
  const styles = useStyles2(getStyles$1t);
  const localRef = React.useRef(null);
  const [handleKeys] = useMenuFocus({
    localRef,
    isMenuOpen: isOpen,
    close
  });
  const [pushLeft, setPushLeft] = React.useState(false);
  React.useEffect(() => {
    if (isOpen && localRef.current) {
      setPushLeft(isElementOverflowing(localRef.current));
    }
  }, [isOpen]);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.iconWrapper, "aria-hidden": true, "data-testid": e2eSelectors.selectors.components.Menu.SubMenu.icon, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right", className: styles.icon }) }),
    isOpen && /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        ref: localRef,
        className: css.cx(styles.subMenu, { [styles.pushLeft]: pushLeft }),
        "data-testid": e2eSelectors.selectors.components.Menu.SubMenu.container,
        style: customStyle,
        children: /* @__PURE__ */ jsxRuntime.jsx("div", { tabIndex: -1, className: styles.itemsWrapper, role: "menu", onKeyDown: handleKeys, children: items })
      }
    )
  ] });
});
SubMenu.displayName = "SubMenu";
const getStyles$1t = (theme) => {
  return {
    iconWrapper: css.css({
      display: "flex",
      flex: 1,
      justifyContent: "end"
    }),
    icon: css.css({
      opacity: 0.7,
      marginLeft: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    itemsWrapper: css.css({
      background: theme.colors.background.elevated,
      padding: theme.spacing(0.5),
      boxShadow: theme.shadows.z3,
      display: "inline-block",
      borderRadius: theme.shape.radius.default
    }),
    pushLeft: css.css({
      right: "100%",
      left: "unset"
    }),
    subMenu: css.css({
      position: "absolute",
      top: 0,
      left: "100%",
      zIndex: theme.zIndex.dropdown
    })
  };
};

const MenuItem = React__namespace.memo(
  React__namespace.forwardRef((props, ref) => {
    const {
      url,
      icon,
      label,
      description,
      ariaLabel,
      ariaChecked,
      target,
      onClick,
      className,
      active,
      disabled,
      destructive,
      childItems,
      role,
      tabIndex = -1,
      customSubMenuContainerStyles,
      shortcut,
      testId
    } = props;
    const styles = useStyles2(getStyles$1s);
    const [isActive, setIsActive] = React.useState(active);
    const [isSubMenuOpen, setIsSubMenuOpen] = React.useState(false);
    const onMouseEnter = React.useCallback(() => {
      if (disabled) {
        return;
      }
      setIsSubMenuOpen(true);
      setIsActive(true);
    }, [disabled]);
    const onMouseLeave = React.useCallback(() => {
      if (disabled) {
        return;
      }
      setIsSubMenuOpen(false);
      setIsActive(false);
    }, [disabled]);
    const hasSubMenu = childItems && childItems.length > 0;
    const ItemElement = hasSubMenu ? "div" : url === void 0 ? "button" : "a";
    const itemStyle = css.cx(
      {
        [styles.item]: true,
        [styles.active]: isActive,
        [styles.disabled]: disabled,
        [styles.destructive]: destructive && !disabled
      },
      className
    );
    const disabledProps = {
      [ItemElement === "button" ? "disabled" : "aria-disabled"]: disabled,
      ...ItemElement === "a" && disabled && { href: void 0, onClick: void 0 },
      ...disabled && {
        tabIndex: -1,
        ["data-disabled"]: disabled
        // used to identify disabled items in Menu.tsx
      }
    };
    const localRef = React.useRef(null);
    React.useImperativeHandle(ref, () => localRef.current);
    const handleKeys = (event) => {
      switch (event.key) {
        case "ArrowRight":
          event.preventDefault();
          event.stopPropagation();
          if (hasSubMenu) {
            setIsSubMenuOpen(true);
            setIsActive(true);
          }
          break;
      }
    };
    const closeSubMenu = () => {
      var _a;
      setIsSubMenuOpen(false);
      setIsActive(false);
      (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.focus();
    };
    const hasShortcut = Boolean(shortcut && shortcut.length > 0);
    return /* @__PURE__ */ jsxRuntime.jsxs(
      ItemElement,
      {
        target,
        className: itemStyle,
        rel: target === "_blank" ? "noopener noreferrer" : void 0,
        href: url,
        onClick: (event) => {
          if (hasSubMenu && !isSubMenuOpen) {
            event.preventDefault();
            event.stopPropagation();
          }
          onClick == null ? void 0 : onClick(event);
        },
        onMouseEnter,
        onMouseLeave,
        onKeyDown: handleKeys,
        role: !url ? role || "menuitem" : role,
        "data-role": "menuitem",
        ref: localRef,
        "data-testid": testId,
        "aria-label": ariaLabel,
        "aria-checked": ariaChecked,
        tabIndex,
        ...disabledProps,
        children: [
          /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "row", justifyContent: "flex-start", alignItems: "center", children: [
            icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, className: styles.icon, "aria-hidden": true }),
            /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.ellipsis, children: label }),
            /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.rightWrapper, { [styles.withShortcut]: hasShortcut }), children: [
              hasShortcut && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.shortcut, children: [
                /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "keyboard", title: t("grafana-ui.menu-item.keyboard-shortcut-label", "Keyboard shortcut") }),
                shortcut
              ] }),
              hasSubMenu && /* @__PURE__ */ jsxRuntime.jsx(
                SubMenu,
                {
                  items: childItems,
                  isOpen: isSubMenuOpen,
                  close: closeSubMenu,
                  customStyle: customSubMenuContainerStyles
                }
              )
            ] })
          ] }),
          description && /* @__PURE__ */ jsxRuntime.jsx(
            "div",
            {
              className: css.cx(styles.description, styles.ellipsis, {
                [styles.descriptionWithIcon]: icon !== void 0
              }),
              children: description
            }
          ),
          props.component ? /* @__PURE__ */ jsxRuntime.jsx(props.component, {}) : null
        ]
      }
    );
  })
);
MenuItem.displayName = "MenuItem";
const getStyles$1s = (theme) => {
  return {
    item: css.css({
      background: "none",
      cursor: "pointer",
      whiteSpace: "nowrap",
      color: theme.colors.text.primary,
      display: "flex",
      flexDirection: "column",
      alignItems: "stretch",
      justifyContent: "center",
      padding: theme.spacing(0.5, 1.5),
      minHeight: theme.spacing(4),
      borderRadius: theme.shape.radius.default,
      margin: 0,
      border: "none",
      width: "100%",
      position: "relative",
      "&:hover, &:focus-visible": {
        background: theme.colors.action.hover,
        color: theme.colors.text.primary,
        textDecoration: "none"
      },
      "&:focus-visible": getFocusStyles(theme)
    }),
    active: css.css({
      background: theme.colors.action.hover
    }),
    destructive: css.css({
      color: theme.colors.error.text,
      svg: {
        color: theme.colors.error.text
      },
      "&:hover, &:focus, &:focus-visible": {
        background: theme.colors.error.main,
        color: theme.colors.error.contrastText,
        svg: {
          color: theme.colors.error.contrastText
        }
      }
    }),
    disabled: css.css({
      color: theme.colors.action.disabledText,
      label: "menu-item-disabled",
      "&:hover, &:focus, &:focus-visible": {
        cursor: "not-allowed",
        background: "none",
        color: theme.colors.action.disabledText
      }
    }),
    icon: css.css({
      opacity: 0.7,
      color: theme.colors.text.secondary
    }),
    rightWrapper: css.css({
      display: "flex",
      alignItems: "center",
      marginLeft: "auto"
    }),
    withShortcut: css.css({
      minWidth: theme.spacing(10.5)
    }),
    shortcut: css.css({
      display: "flex",
      alignItems: "center",
      gap: theme.spacing(1),
      marginLeft: theme.spacing(2),
      color: theme.colors.text.secondary,
      opacity: 0.7
    }),
    description: css.css({
      ...theme.typography.bodySmall,
      color: theme.colors.text.secondary,
      textAlign: "start"
    }),
    descriptionWithIcon: css.css({
      marginLeft: theme.spacing(3)
    }),
    ellipsis: css.css({
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    })
  };
};

const MenuComp = React__namespace.forwardRef(
  ({ header, children, ariaLabel, onOpen, onClose, onKeyDown, ...otherProps }, forwardedRef) => {
    const styles = useStyles2(getStyles$1r);
    const localRef = React.useRef(null);
    React.useImperativeHandle(forwardedRef, () => localRef.current);
    const [handleKeys] = useMenuFocus({ isMenuOpen: true, localRef, onOpen, onClose, onKeyDown });
    return /* @__PURE__ */ jsxRuntime.jsxs(
      Box,
      {
        ...otherProps,
        "aria-label": ariaLabel,
        backgroundColor: "elevated",
        borderRadius: "default",
        boxShadow: "z3",
        display: "inline-block",
        onKeyDown: handleKeys,
        paddingX: 0.5,
        paddingY: 0.5,
        ref: localRef,
        role: "menu",
        tabIndex: -1,
        children: [
          header && /* @__PURE__ */ jsxRuntime.jsx(
            "div",
            {
              className: css.cx(
                styles.header,
                Boolean(children) && React__namespace.Children.toArray(children).length > 0 && styles.headerBorder
              ),
              children: header
            }
          ),
          children
        ]
      }
    );
  }
);
MenuComp.displayName = "Menu";
const Menu = Object.assign(MenuComp, {
  Item: MenuItem,
  Divider: MenuDivider,
  Group: MenuGroup
});
const getStyles$1r = (theme) => {
  return {
    header: css.css({
      padding: theme.spacing(0.5, 0.5, 1, 0.5)
    }),
    headerBorder: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      marginBottom: theme.spacing(0.5)
    })
  };
};

function Portal$1(props) {
  const { children, className, root, forwardedRef } = props;
  const theme = useTheme2();
  const node = React.useRef(null);
  const portalRoot = root != null ? root : getPortalContainer();
  if (!node.current) {
    node.current = document.createElement("div");
    if (className) {
      node.current.className = className;
    }
    node.current.style.position = "relative";
    node.current.style.zIndex = `${theme.zIndex.portal}`;
  }
  React.useLayoutEffect(() => {
    if (node.current) {
      portalRoot.appendChild(node.current);
    }
    return () => {
      if (node.current) {
        portalRoot.removeChild(node.current);
      }
    };
  }, [portalRoot]);
  return ReactDOM__default.default.createPortal(/* @__PURE__ */ jsxRuntime.jsx("div", { ref: forwardedRef, children }), node.current);
}
function getPortalContainer() {
  var _a;
  return (_a = window.document.getElementById("grafana-portal-container")) != null ? _a : document.body;
}
const RefForwardingPortal = React__namespace.forwardRef((props, ref) => {
  return /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { ...props, forwardedRef: ref });
});
RefForwardingPortal.displayName = "RefForwardingPortal";

const ContextMenu = React__namespace.memo(
  ({ x, y, onClose, focusOnOpen = true, renderMenuItems, renderHeader }) => {
    const menuRef = React.useRef(null);
    const [positionStyles, setPositionStyles] = React.useState({});
    React.useLayoutEffect(() => {
      const menuElement = menuRef.current;
      if (menuElement) {
        const rect = menuElement.getBoundingClientRect();
        const OFFSET = 5;
        const collisions = {
          right: window.innerWidth < x + rect.width,
          bottom: window.innerHeight < y + rect.height + OFFSET
        };
        setPositionStyles({
          position: "fixed",
          left: collisions.right ? x - rect.width - OFFSET : x - OFFSET,
          top: Math.max(0, collisions.bottom ? y - rect.height - OFFSET : y + OFFSET)
        });
      }
    }, [x, y]);
    reactUse.useClickAway(menuRef, () => {
      onClose == null ? void 0 : onClose();
    });
    const header = renderHeader == null ? void 0 : renderHeader();
    const menuItems = renderMenuItems == null ? void 0 : renderMenuItems();
    const onOpen = (setFocusedItem) => {
      if (focusOnOpen) {
        setFocusedItem(0);
      }
    };
    const onKeyDown = (e) => {
      if (e.key === "Escape") {
        e.preventDefault();
        e.stopPropagation();
        onClose == null ? void 0 : onClose();
      }
    };
    return /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsx(
      Menu,
      {
        header,
        ref: menuRef,
        style: positionStyles,
        ariaLabel: e2eSelectors.selectors.components.Menu.MenuComponent("Context"),
        onOpen,
        onClick: onClose,
        onKeyDown,
        children: menuItems
      }
    ) });
  }
);
ContextMenu.displayName = "ContextMenu";

const getFocusStyle = (theme) => css.css({
  "&:focus": getFocusStyles(theme)
});
const sharedInputStyle = (theme, invalid = false) => {
  const borderColor = invalid ? theme.colors.error.border : theme.components.input.borderColor;
  const borderColorHover = invalid ? theme.colors.error.shade : theme.components.input.borderHover;
  const background = theme.components.input.background;
  const textColor = theme.components.input.text;
  const autoFillBorder = theme.isDark ? "#2e2f35" : "#bab4ca";
  return css.cx(
    inputPadding(theme),
    css.css({
      background,
      lineHeight: theme.typography.body.lineHeight,
      fontSize: theme.typography.size.md,
      color: textColor,
      border: `1px solid ${borderColor}`,
      "&:-webkit-autofill, &:-webkit-autofill:hover": {
        /* Welcome to 2005. This is a HACK to get rid od Chromes default autofill styling */
        boxShadow: `inset 0 0 0 1px rgba(255, 255, 255, 0), inset 0 0 0 100px ${background}!important`,
        WebkitTextFillColor: `${textColor} !important`,
        borderColor: autoFillBorder
      },
      "&:-webkit-autofill:focus": {
        /* Welcome to 2005. This is a HACK to get rid od Chromes default autofill styling */
        boxShadow: `0 0 0 2px ${theme.colors.background.primary}, 0 0 0px 4px ${theme.colors.primary.main}, inset 0 0 0 1px rgba(255, 255, 255, 0), inset 0 0 0 100px ${background}!important`,
        WebkitTextFillColor: `${textColor} !important`
      },
      "&:hover": {
        borderColor: borderColorHover
      },
      "&:focus": {
        outline: "none"
      },
      "&:disabled": {
        backgroundColor: theme.colors.action.disabledBackground,
        color: theme.colors.action.disabledText,
        border: `1px solid ${theme.colors.action.disabledBackground}`,
        "&:hover": {
          borderColor
        }
      },
      "&::placeholder": {
        color: theme.colors.text.disabled,
        opacity: 1
      }
    })
  );
};
const inputPadding = (theme) => {
  return css.css({
    padding: theme.spacing(0, 1, 0, 1)
  });
};
const inputSizes = () => {
  return {
    sm: css.css({
      width: inputSizesPixels("sm")
    }),
    md: css.css({
      width: inputSizesPixels("md")
    }),
    lg: css.css({
      width: inputSizesPixels("lg")
    }),
    auto: css.css({
      width: inputSizesPixels("auto")
    })
  };
};
const inputSizesPixels = (size) => {
  switch (size) {
    case "sm":
      return "200px";
    case "md":
      return "320px";
    case "lg":
      return "580px";
    case "auto":
    default:
      return "auto";
  }
};
function getPropertiesForButtonSize(size, theme) {
  switch (size) {
    case "sm":
      return {
        padding: 1,
        fontSize: theme.typography.size.sm,
        height: theme.components.height.sm
      };
    case "lg":
      return {
        padding: 3,
        fontSize: theme.typography.size.lg,
        height: theme.components.height.lg
      };
    case "md":
    default:
      return {
        padding: 2,
        fontSize: theme.typography.size.md,
        height: theme.components.height.md
      };
  }
}

function getPlacement(placement) {
  switch (placement) {
    case "auto":
      return "bottom";
    case "auto-start":
      return "bottom-start";
    case "auto-end":
      return "bottom-end";
    default:
      return placement != null ? placement : "bottom";
  }
}
function buildTooltipTheme(theme, tooltipBg, toggletipBorder, tooltipText, tooltipPadding) {
  return {
    arrow: css.css({
      fill: tooltipBg
    }),
    container: css.css({
      backgroundColor: tooltipBg,
      borderRadius: theme.shape.radius.default,
      border: `1px solid ${toggletipBorder}`,
      boxShadow: theme.shadows.z2,
      color: tooltipText,
      fontSize: theme.typography.bodySmall.fontSize,
      padding: theme.spacing(tooltipPadding.topBottom, tooltipPadding.rightLeft),
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: "opacity 0.3s"
      },
      zIndex: theme.zIndex.tooltip,
      maxWidth: "400px",
      overflowWrap: "break-word",
      "&[data-popper-interactive='false']": {
        pointerEvents: "none"
      }
    }),
    headerClose: css.css({
      color: theme.colors.text.secondary,
      position: "absolute",
      right: theme.spacing(1),
      top: theme.spacing(1.5),
      backgroundColor: "transparent",
      border: 0
    }),
    header: css.css({
      paddingTop: theme.spacing(1),
      paddingBottom: theme.spacing(2)
    }),
    body: css.css({
      paddingTop: theme.spacing(1),
      paddingBottom: theme.spacing(1)
    }),
    footer: css.css({
      paddingTop: theme.spacing(2),
      paddingBottom: theme.spacing(1)
    })
  };
}

const Tooltip = React.forwardRef(
  ({ children, theme, interactive, show, placement, content }, forwardedRef) => {
    const arrowRef = React.useRef(null);
    const [controlledVisible, setControlledVisible] = React.useState(show);
    const isOpen = show != null ? show : controlledVisible;
    const middleware = [
      react.offset(8),
      react.flip({
        fallbackAxisSideDirection: "end",
        // see https://floating-ui.com/docs/flip#combining-with-shift
        crossAxis: false,
        boundary: document.body
      }),
      react.shift(),
      react.arrow({
        element: arrowRef
      })
    ];
    const { context, refs, floatingStyles } = react.useFloating({
      open: isOpen,
      placement: getPlacement(placement),
      onOpenChange: setControlledVisible,
      middleware,
      whileElementsMounted: react.autoUpdate
    });
    const tooltipId = React.useId();
    const hover = react.useHover(context, {
      handleClose: interactive ? react.safePolygon() : void 0,
      move: false
    });
    const focus = react.useFocus(context);
    const dismiss = react.useDismiss(context);
    const { getReferenceProps, getFloatingProps } = react.useInteractions([dismiss, hover, focus]);
    const contentIsFunction = typeof content === "function";
    const styles = useStyles2(getStyles$1q);
    const style = styles[theme != null ? theme : "info"];
    const handleRef = React.useCallback(
      (ref) => {
        refs.setReference(ref);
        if (typeof forwardedRef === "function") {
          forwardedRef(ref);
        } else if (forwardedRef) {
          forwardedRef.current = ref;
        }
      },
      [forwardedRef, refs]
    );
    const childHasMatchingAriaLabel = "aria-label" in children.props && children.props["aria-label"] === content;
    return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      React.cloneElement(children, {
        ref: handleRef,
        tabIndex: 0,
        // tooltip trigger should be keyboard focusable
        "aria-describedby": !childHasMatchingAriaLabel && isOpen ? tooltipId : void 0,
        ...getReferenceProps()
      }),
      isOpen && /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsxs("div", { ref: refs.setFloating, style: floatingStyles, ...getFloatingProps(), children: [
        /* @__PURE__ */ jsxRuntime.jsx(react.FloatingArrow, { className: style.arrow, ref: arrowRef, context }),
        /* @__PURE__ */ jsxRuntime.jsxs(
          "div",
          {
            "data-testid": e2eSelectors.selectors.components.Tooltip.container,
            id: tooltipId,
            role: "tooltip",
            className: style.container,
            children: [
              typeof content === "string" && content,
              React.isValidElement(content) && React.cloneElement(content),
              contentIsFunction && content({})
            ]
          }
        )
      ] }) })
    ] });
  }
);
Tooltip.displayName = "Tooltip";
const getStyles$1q = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.components.tooltip.background,
    theme.components.tooltip.background,
    theme.components.tooltip.text,
    { topBottom: 0.5, rightLeft: 1 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 0.5, rightLeft: 1 }
  );
  return {
    info,
    ["info-alt"]: info,
    error
  };
};

class PopoverController extends React.Component {
  constructor() {
    super(...arguments);
    this.hideTimeout = null;
    this.state = { show: false };
    this.showPopper = () => {
      if (this.hideTimeout) {
        clearTimeout(this.hideTimeout);
      }
      this.setState({ show: true });
    };
    this.hidePopper = () => {
      this.hideTimeout = setTimeout(() => {
        this.setState({ show: false });
      }, this.props.hideAfter);
    };
  }
  render() {
    const { children, content, placement = "auto" } = this.props;
    const { show } = this.state;
    return children(this.showPopper, this.hidePopper, {
      show,
      placement,
      content
    });
  }
}

const Button = React__namespace.forwardRef(
  ({
    variant = "primary",
    size = "md",
    fill = "solid",
    icon,
    fullWidth,
    children,
    className,
    type = "button",
    tooltip,
    disabled,
    tooltipPlacement,
    onClick,
    ...otherProps
  }, ref) => {
    const theme = useTheme2();
    const styles = getButtonStyles({
      theme,
      size,
      variant,
      fill,
      fullWidth,
      iconOnly: !children
    });
    const buttonStyles = css.cx(
      styles.button,
      {
        [styles.disabled]: disabled
      },
      className
    );
    const hasTooltip = Boolean(tooltip);
    const button = /* @__PURE__ */ jsxRuntime.jsxs(
      "button",
      {
        className: buttonStyles,
        type,
        onClick: disabled ? void 0 : onClick,
        ...otherProps,
        "aria-disabled": hasTooltip && disabled,
        disabled: !hasTooltip && disabled,
        ref: tooltip ? void 0 : ref,
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(IconRenderer, { icon, size, className: styles.icon }),
          children && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.content, children })
        ]
      }
    );
    if (tooltip) {
      return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { ref, content: tooltip, placement: tooltipPlacement, children: button });
    }
    return button;
  }
);
Button.displayName = "Button";
const LinkButton = React__namespace.forwardRef(
  ({
    variant = "primary",
    size = "md",
    fill = "solid",
    icon,
    fullWidth,
    children,
    className,
    onBlur,
    onFocus,
    disabled,
    tooltip,
    tooltipPlacement,
    ...otherProps
  }, ref) => {
    const theme = useTheme2();
    const styles = getButtonStyles({
      theme,
      fullWidth,
      size,
      variant,
      fill,
      iconOnly: !children
    });
    const linkButtonStyles = css.cx(
      styles.button,
      {
        [css.css(styles.disabled, {
          pointerEvents: "none"
        })]: disabled
      },
      className
    );
    const button = /* @__PURE__ */ jsxRuntime.jsxs(
      "a",
      {
        className: linkButtonStyles,
        ...otherProps,
        tabIndex: disabled ? -1 : 0,
        "aria-disabled": disabled,
        ref: tooltip ? void 0 : ref,
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(IconRenderer, { icon, size, className: styles.icon }),
          children && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.content, children })
        ]
      }
    );
    if (tooltip) {
      return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { ref, content: tooltip, placement: tooltipPlacement, children: button });
    }
    return button;
  }
);
LinkButton.displayName = "LinkButton";
const IconRenderer = ({ icon, size, className, iconType }) => {
  if (!icon) {
    return null;
  }
  if (React__namespace.isValidElement(icon)) {
    return React__namespace.cloneElement(icon, {
      className,
      size
    });
  }
  return /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, size, className, type: iconType });
};
const getButtonStyles = (props) => {
  const { theme, variant, fill = "solid", size, iconOnly, fullWidth } = props;
  const { height, padding, fontSize } = getPropertiesForButtonSize(size, theme);
  const variantStyles = getPropertiesForVariant(theme, variant, fill);
  const disabledStyles = getPropertiesForDisabled(theme, variant, fill);
  const focusStyle = getFocusStyles(theme);
  const paddingMinusBorder = theme.spacing.gridSize * padding - 1;
  return {
    button: css.css({
      label: "button",
      display: "inline-flex",
      alignItems: "center",
      fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      fontFamily: theme.typography.fontFamily,
      padding: `0 ${paddingMinusBorder}px`,
      height: theme.spacing(height),
      // Deduct border from line-height for perfect vertical centering on windows and linux
      lineHeight: `${theme.spacing.gridSize * height - 2}px`,
      verticalAlign: "middle",
      cursor: "pointer",
      borderRadius: theme.shape.radius.default,
      "&:focus": focusStyle,
      "&:focus-visible": focusStyle,
      "&:focus:not(:focus-visible)": getMouseFocusStyles(),
      ...fullWidth && {
        flexGrow: 1,
        justifyContent: "center"
      },
      ...variantStyles,
      ":disabled": disabledStyles,
      "&[disabled]": disabledStyles
    }),
    disabled: css.css(disabledStyles, {
      "&:hover": css.css(disabledStyles)
    }),
    img: css.css({
      width: "16px",
      height: "16px",
      margin: theme.spacing(0, 1, 0, 0.5)
    }),
    icon: iconOnly ? css.css({
      // Important not to set margin bottom here as it would override internal icon bottom margin
      marginRight: theme.spacing(-padding / 2),
      marginLeft: theme.spacing(-padding / 2)
    }) : css.css({
      marginRight: theme.spacing(padding / 2)
    }),
    content: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "center",
      whiteSpace: "nowrap",
      overflow: "hidden",
      height: "100%"
    })
  };
};
function getButtonVariantStyles(theme, color, fill) {
  let outlineBorderColor = color.border;
  let borderColor = "transparent";
  let hoverBorderColor = "transparent";
  if (color.name === "secondary") {
    borderColor = color.border;
    hoverBorderColor = theme.colors.emphasize(color.border, 0.25);
    outlineBorderColor = theme.colors.border.strong;
  }
  if (fill === "outline") {
    return {
      background: "transparent",
      color: color.text,
      border: `1px solid ${outlineBorderColor}`,
      transition: theme.transitions.create(["background-color", "border-color", "color"], {
        duration: theme.transitions.duration.short
      }),
      "&:hover": {
        background: color.transparent,
        borderColor: theme.colors.emphasize(outlineBorderColor, 0.25),
        color: color.text
      }
    };
  }
  if (fill === "text") {
    return {
      background: "transparent",
      color: color.text,
      border: "1px solid transparent",
      transition: theme.transitions.create(["background-color", "color"], {
        duration: theme.transitions.duration.short
      }),
      "&:focus": {
        outline: "none",
        textDecoration: "none"
      },
      "&:hover": {
        background: color.transparent,
        textDecoration: "none"
      }
    };
  }
  return {
    background: color.main,
    color: color.contrastText,
    border: `1px solid ${borderColor}`,
    transition: theme.transitions.create(["background-color", "box-shadow", "border-color", "color"], {
      duration: theme.transitions.duration.short
    }),
    "&:hover": {
      background: color.shade,
      color: color.contrastText,
      boxShadow: theme.shadows.z1,
      borderColor: hoverBorderColor
    }
  };
}
function getPropertiesForDisabled(theme, variant, fill) {
  const disabledStyles = {
    cursor: "not-allowed",
    boxShadow: "none",
    color: theme.colors.text.disabled,
    transition: "none"
  };
  if (fill === "text") {
    return {
      ...disabledStyles,
      background: "transparent",
      border: `1px solid transparent`
    };
  }
  if (fill === "outline") {
    return {
      ...disabledStyles,
      background: "transparent",
      border: `1px solid ${theme.colors.border.weak}`
    };
  }
  return {
    ...disabledStyles,
    background: theme.colors.action.disabledBackground,
    border: `1px solid transparent`
  };
}
function getPropertiesForVariant(theme, variant, fill) {
  switch (variant) {
    case "secondary":
      return getButtonVariantStyles(theme, theme.colors.secondary, fill);
    case "destructive":
      return getButtonVariantStyles(theme, theme.colors.error, fill);
    case "success":
      return getButtonVariantStyles(theme, theme.colors.success, fill);
    case "primary":
    default:
      return getButtonVariantStyles(theme, theme.colors.primary, fill);
  }
}
const clearButtonStyles = (theme) => {
  return css.css({
    background: "transparent",
    color: theme.colors.text.primary,
    border: "none",
    padding: 0
  });
};
const clearLinkButtonStyles = (theme) => {
  return css.css({
    background: "transparent",
    border: "none",
    padding: 0,
    fontFamily: "inherit",
    color: "inherit",
    height: "100%",
    cursor: "context-menu",
    "&:hover": {
      background: "transparent",
      color: "inherit"
    }
  });
};

const ButtonGroup = React.forwardRef(({ className, children, ...rest }, ref) => {
  const styles = useStyles2(getStyles$1p);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ref, className: css.cx("button-group", styles.wrapper, className), ...rest, children });
});
ButtonGroup.displayName = "ButtonGroup";
const getStyles$1p = (theme) => ({
  wrapper: css.css({
    display: "flex",
    borderRadius: theme.shape.radius.default,
    "> .button-group:not(:first-child) > button, > button:not(:first-child)": {
      borderTopLeftRadius: 0,
      borderBottomLeftRadius: 0,
      borderLeft: `1px solid rgba(255, 255, 255, 0.12)`
    },
    "> .button-group:not(:last-child) > button, > button:not(:last-child)": {
      borderTopRightRadius: 0,
      borderBottomRightRadius: 0,
      borderRight: `1px solid rgba(0, 0, 0, 0.12)`
    }
  })
});

const Pagination = ({
  currentPage,
  numberOfPages,
  onNavigate,
  hideWhenSinglePage,
  showSmallVersion,
  className
}) => {
  const styles = useStyles2(getStyles$1o);
  const pageLengthToCondense = showSmallVersion ? 1 : 8;
  const pageButtons = React.useMemo(() => {
    const pages = [...new Array(numberOfPages).keys()];
    const condensePages = numberOfPages > pageLengthToCondense;
    const getListItem = (page, variant) => /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.item, children: /* @__PURE__ */ jsxRuntime.jsx(Button, { size: "sm", variant, onClick: () => onNavigate(page), children: page }) }, page);
    return pages.reduce((pagesToRender, pageIndex) => {
      const page = pageIndex + 1;
      const variant = page === currentPage ? "primary" : "secondary";
      const lowerBoundIndex = pageLengthToCondense;
      const upperBoundIndex = numberOfPages - pageLengthToCondense + 1;
      const differenceOfBounds = upperBoundIndex - lowerBoundIndex;
      const isFirstOrLastPage = page === 1 || page === numberOfPages;
      const currentPageIsBetweenBounds = differenceOfBounds > -1 && currentPage >= lowerBoundIndex && currentPage <= upperBoundIndex;
      const ellipsisOffset = showSmallVersion ? 1 : 3;
      const pageOffset = showSmallVersion ? 0 : 2;
      if (condensePages) {
        if (isFirstOrLastPage || currentPage < lowerBoundIndex && page < lowerBoundIndex || differenceOfBounds >= 0 && currentPage > upperBoundIndex && page > upperBoundIndex || differenceOfBounds < 0 && currentPage >= lowerBoundIndex && page > upperBoundIndex || currentPageIsBetweenBounds && page >= currentPage - pageOffset && page <= currentPage + pageOffset) {
          pagesToRender.push(getListItem(page, variant));
        } else if (page === lowerBoundIndex && currentPage < lowerBoundIndex || page === upperBoundIndex && currentPage > upperBoundIndex || currentPageIsBetweenBounds && (page === currentPage - ellipsisOffset || page === currentPage + ellipsisOffset)) {
          pagesToRender.push(
            /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.item, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { className: styles.ellipsis, name: "ellipsis-v" }) }, page)
          );
        }
      } else {
        pagesToRender.push(getListItem(page, variant));
      }
      return pagesToRender;
    }, []);
  }, [currentPage, numberOfPages, onNavigate, pageLengthToCondense, showSmallVersion, styles.ellipsis, styles.item]);
  if (hideWhenSinglePage && numberOfPages <= 1) {
    return null;
  }
  const previousPageLabel = t("grafana-ui.pagination.previous-page", "previous page");
  const nextPageLabel = t("grafana-ui.pagination.next-page", "next page");
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.container, className), children: /* @__PURE__ */ jsxRuntime.jsxs("ol", { children: [
    /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.item, children: /* @__PURE__ */ jsxRuntime.jsx(
      Button,
      {
        "aria-label": previousPageLabel,
        size: "sm",
        variant: "secondary",
        onClick: () => onNavigate(currentPage - 1),
        disabled: currentPage === 1,
        children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-left" })
      }
    ) }),
    pageButtons,
    /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.item, children: /* @__PURE__ */ jsxRuntime.jsx(
      Button,
      {
        "aria-label": nextPageLabel,
        size: "sm",
        variant: "secondary",
        onClick: () => onNavigate(currentPage + 1),
        disabled: currentPage === numberOfPages,
        children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right" })
      }
    ) })
  ] }) });
};
const getStyles$1o = () => {
  return {
    container: css.css({
      float: "right"
    }),
    item: css.css({
      display: "inline-block",
      paddingLeft: "10px",
      marginBottom: "5px"
    }),
    ellipsis: css.css({
      transform: "rotate(90deg)"
    })
  };
};

css.keyframes({
  "0%": {
    transform: "rotate(0deg) scaleX(-1)"
    // scaleX flips the `sync` icon so arrows point the correct way
  },
  "100%": {
    transform: "rotate(359deg) scaleX(-1)"
  }
});

if (typeof window !== "undefined" && "Element" in window && !Element.prototype.closest) {
  Element.prototype.closest = function(s) {
    const matches = (this.document || this.ownerDocument).querySelectorAll(s);
    let el = this;
    let i;
    do {
      i = matches.length;
      while (--i >= 0 && matches.item(i) !== el) {
      }
      el = el.parentElement;
    } while (i < 0 && el);
    return el;
  };
}

function getChildId(children) {
  let inputId;
  const child = React__namespace.Children.only(children);
  if ("id" in (child == null ? void 0 : child.props)) {
    inputId = child.props.id;
  } else if ("inputId" in child.props) {
    inputId = child == null ? void 0 : child.props.inputId;
  }
  return typeof inputId === "string" ? inputId : void 0;
}
function renderOrCallToRender(itemToRender, props) {
  if (React__namespace.isValidElement(itemToRender) || typeof itemToRender === "string" || typeof itemToRender === "number") {
    return itemToRender;
  }
  if (typeof itemToRender === "function" && props) {
    return itemToRender(props);
  }
  throw new Error(`${itemToRender} is not a React element nor a function that returns React element`);
}

const PALETTE_ROWS = 4;
const colors = [
  "#7EB26D",
  // 0: pale green
  "#EAB839",
  // 1: mustard
  "#6ED0E0",
  // 2: light blue
  "#EF843C",
  // 3: orange
  "#E24D42",
  // 4: red
  "#1F78C1",
  // 5: ocean
  "#BA43A9",
  // 6: purple
  "#705DA0",
  // 7: violet
  "#508642",
  // 8: dark green
  "#CCA300",
  // 9: dark sand
  "#447EBC",
  "#C15C17",
  "#890F02",
  "#0A437C",
  "#6D1F62",
  "#584477",
  "#B7DBAB",
  "#F4D598",
  "#70DBED",
  "#F9BA8F",
  "#F29191",
  "#82B5D8",
  "#E5A8E2",
  "#AEA2E0",
  "#629E51",
  "#E5AC0E",
  "#64B0C8",
  "#E0752D",
  "#BF1B00",
  "#0A50A1",
  "#962D82",
  "#614D93",
  "#9AC48A",
  "#F2C96D",
  "#65C5DB",
  "#F9934E",
  "#EA6460",
  "#5195CE",
  "#D683CE",
  "#806EB7",
  "#3F6833",
  "#967302",
  "#2F575E",
  "#99440A",
  "#58140C",
  "#052B51",
  "#511749",
  "#3F2B5B",
  "#E0F9D7",
  "#FCEACA",
  "#CFFAFF",
  "#F9E2D2",
  "#FCE2DE",
  "#BADFF4",
  "#F9D9F9",
  "#DEDAF7"
];
function sortColorsByHue(hexColors) {
  const hslColors = lodash.map(hexColors, hexToHsl);
  const sortedHSLColors = lodash.sortBy(hslColors, ["h"]);
  const chunkedHSLColors = lodash.chunk(sortedHSLColors, PALETTE_ROWS);
  const sortedChunkedHSLColors = lodash.map(chunkedHSLColors, (chunk2) => {
    return lodash.sortBy(chunk2, "l");
  });
  const flattenedZippedSortedChunkedHSLColors = lodash.flattenDeep(lodash.zip(...sortedChunkedHSLColors));
  return lodash.map(flattenedZippedSortedChunkedHSLColors, hslToHex);
}
function hexToHsl(color) {
  return tinycolor__default.default(color).toHsl();
}
function hslToHex(color) {
  return tinycolor__default.default(color).toHexString();
}
function getTextColorForAlphaBackground(color, themeIsDark) {
  const tcolor = tinycolor__default.default(color);
  const b = tcolor.getBrightness();
  const a = tcolor.getAlpha();
  if (a < 0.3) {
    return themeIsDark ? "rgb(247, 248, 250)" : "rgb(32, 34, 38)";
  }
  return b > 180 ? "rgb(32, 34, 38)" : "rgb(247, 248, 250)";
}
sortColorsByHue(colors);

var EventsWithValidation = /* @__PURE__ */ ((EventsWithValidation2) => {
  EventsWithValidation2["onBlur"] = "onBlur";
  EventsWithValidation2["onFocus"] = "onFocus";
  EventsWithValidation2["onChange"] = "onChange";
  return EventsWithValidation2;
})(EventsWithValidation || {});
const validate = (value, validationRules) => {
  const errors = validationRules.reduce((acc, currRule) => {
    if (!currRule.rule(value)) {
      return acc.concat(currRule.errorMessage);
    }
    return acc;
  }, []);
  return errors.length > 0 ? errors : null;
};
const hasValidationEvent = (event, validationEvents) => {
  return validationEvents && validationEvents[event];
};

const SCHEMA = {
  document: {
    nodes: [
      {
        match: [{ type: "paragraph" }, { type: "code_block" }, { type: "code_line" }]
      }
    ]
  },
  inlines: {}
};
const makeFragment = (text, syntax) => {
  const lines = text.split("\n").map(
    (line) => slate.Block.create({
      type: "code_line",
      nodes: [slate.Text.create(line)]
    })
  );
  const block = slate.Block.create({
    data: {
      syntax
    },
    type: "code_block",
    nodes: lines
  });
  return slate.Document.create({
    nodes: [block]
  });
};
const makeValue = (text, syntax) => {
  const fragment = makeFragment(text, syntax);
  return slate.Value.create({
    document: fragment
  });
};

const linkModelToContextMenuItems = (links) => {
  return links().map((link) => {
    return {
      label: link.title,
      ariaLabel: link.title,
      // TODO: rename to href
      url: link.href,
      target: link.target,
      icon: `${link.target === "_blank" ? "external-link-alt" : "link"}`,
      onClick: link.onClick
    };
  });
};

const TAG_COLORS = [
  "#D32D20",
  "#1E72B8",
  "#B240A2",
  "#705DA0",
  "#466803",
  "#497A3C",
  "#3D71AA",
  "#B15415",
  "#890F02",
  "#6E6E6E",
  "#0A437C",
  "#6D1F62",
  "#584477",
  "#4C7A3F",
  "#2F4F4F",
  "#BF1B00",
  "#7662B1",
  "#8A2EB8",
  "#517A00",
  "#000000",
  "#3F6833",
  "#2F575E",
  "#99440A",
  "#AE561A",
  "#0E4AB4",
  "#58140C",
  "#052B51",
  "#511749",
  "#3F2B5B"
];
const TAG_BORDER_COLORS = [
  "#FF7368",
  "#459EE7",
  "#E069CF",
  "#9683C6",
  "#6C8E29",
  "#76AC68",
  "#6AA4E2",
  "#E7823D",
  "#AF3528",
  "#9B9B9B",
  "#3069A2",
  "#934588",
  "#7E6A9D",
  "#88C477",
  "#557575",
  "#E54126",
  "#A694DD",
  "#B054DE",
  "#8FC426",
  "#262626",
  "#658E59",
  "#557D84",
  "#BF6A30",
  "#FF9B53",
  "#3470DA",
  "#7E3A32",
  "#2B5177",
  "#773D6F",
  "#655181"
];
function getTagColorIndexFromName(name = "") {
  const hash = djb2(name.toLowerCase());
  return Math.abs(hash % TAG_COLORS.length);
}
function getTagColorsFromName(name = "") {
  const index = getTagColorIndexFromName(name);
  return getTagColor(index);
}
function getTagColor(index) {
  return { color: TAG_COLORS[index], borderColor: TAG_BORDER_COLORS[index] };
}
function djb2(str) {
  let hash = 5381;
  for (let i = 0; i < str.length; i++) {
    hash = (hash << 5) + hash + str.charCodeAt(i);
  }
  return hash;
}

const getCellLinks$1 = (field, row) => {
  let links;
  if (field.getLinks) {
    links = field.getLinks({
      valueRowIndex: row.index
    });
  }
  if (!links) {
    return;
  }
  for (let i = 0; i < (links == null ? void 0 : links.length); i++) {
    if (links[i].onClick) {
      const origOnClick = links[i].onClick;
      links[i].onClick = (event) => {
        if (!(event.ctrlKey || event.metaKey || event.shiftKey)) {
          event.preventDefault();
          origOnClick(event, {
            field,
            rowIndex: row.index
          });
        }
      };
    }
  }
  return links;
};

let _context;
const cache = /* @__PURE__ */ new Map();
const cacheLimit = 500;
let ctxFontStyle = "";
function getCanvasContext() {
  if (!_context) {
    _context = document.createElement("canvas").getContext("2d");
  }
  return _context;
}
function measureText(text, fontSize, fontWeight = 400) {
  const fontStyle = `${fontWeight} ${fontSize}px 'Inter'`;
  const cacheKey = text + fontStyle;
  const fromCache = cache.get(cacheKey);
  if (fromCache) {
    return fromCache;
  }
  const context = getCanvasContext();
  if (ctxFontStyle !== fontStyle) {
    context.font = ctxFontStyle = fontStyle;
  }
  const metrics = context.measureText(text);
  if (cache.size === cacheLimit) {
    cache.clear();
  }
  cache.set(cacheKey, metrics);
  return metrics;
}
function calculateFontSize(text, width, height, lineHeight, maxSize, fontWeight) {
  const textSize = measureText(text, 14, fontWeight);
  const fontSizeBasedOnWidth = width / (textSize.width + 2) * 14;
  const fontSizeBasedOnHeight = height / lineHeight;
  const optimalSize = Math.min(fontSizeBasedOnHeight, fontSizeBasedOnWidth);
  return Math.min(optimalSize, maxSize != null ? maxSize : optimalSize);
}

function fuzzyMatch(stack, needle) {
  let distance = 0, searchIndex = stack.indexOf(needle);
  needle = needle.replace(/\s/g, "");
  const ranges = [];
  if (searchIndex !== -1) {
    return {
      distance: 0,
      found: true,
      ranges: [{ start: searchIndex, end: searchIndex + needle.length - 1 }]
    };
  }
  for (const letter of needle) {
    const letterIndex = stack.indexOf(letter, searchIndex);
    if (letterIndex === -1) {
      return { distance: Infinity, ranges: [], found: false };
    }
    if (searchIndex !== -1) {
      distance += letterIndex - searchIndex;
    }
    searchIndex = letterIndex + 1;
    if (ranges.length === 0) {
      ranges.push({ start: letterIndex, end: letterIndex });
    } else {
      const lastRange = lodash.last(ranges);
      if (letterIndex === lastRange.end + 1) {
        lastRange.end++;
      } else {
        ranges.push({ start: letterIndex, end: letterIndex });
      }
    }
  }
  return {
    distance,
    ranges,
    found: true
  };
}

var SearchFunctionType = /* @__PURE__ */ ((SearchFunctionType2) => {
  SearchFunctionType2["Word"] = "Word";
  SearchFunctionType2["Prefix"] = "Prefix";
  SearchFunctionType2["Fuzzy"] = "Fuzzy";
  return SearchFunctionType2;
})(SearchFunctionType || {});
const wordSearch = (items, text) => {
  return items.filter((c) => (c.filterText || c.label).includes(text));
};
const prefixSearch = (items, text) => {
  return items.filter((c) => (c.filterText || c.label).startsWith(text));
};
const fuzzySearch = (items, text) => {
  text = text.toLowerCase();
  return items.filter((item) => {
    const { distance, ranges, found } = fuzzyMatch(item.label.toLowerCase(), text);
    if (!found) {
      return false;
    }
    item.sortValue = distance;
    item.highlightParts = ranges;
    return true;
  });
};
const SearchFunctionMap = {
  ["Word" /* Word */]: wordSearch,
  ["Prefix" /* Prefix */]: prefixSearch,
  ["Fuzzy" /* Fuzzy */]: fuzzySearch
};

const throttledLog = lodash.throttle((...t) => {
  console.log(...t);
}, 500);
const createLogger = (name) => {
  let loggingEnabled = false;
  if (typeof window !== "undefined") {
    loggingEnabled = window.localStorage.getItem("grafana.debug") === "true";
  }
  return {
    logger: (id, throttle2 = false, ...t) => {
      if (process.env.NODE_ENV === "production" || process.env.NODE_ENV === "test" || !loggingEnabled) {
        return;
      }
      const fn = throttle2 ? throttledLog : console.log;
      fn(`[${name}: ${id}]:`, ...t);
    },
    enable: () => loggingEnabled = true,
    disable: () => loggingEnabled = false,
    isEnabled: () => loggingEnabled
  };
};

function attachDebugger(key, thebugger, logger) {
  var _a;
  if (process.env.NODE_ENV === "production") {
    return;
  }
  let completeDebugger = {};
  if (logger !== void 0) {
    completeDebugger = { ...completeDebugger, enable: () => logger.enable(), disable: () => logger.disable() };
  }
  let debugGlobal = (_a = typeof window !== "undefined" && window["_debug"]) != null ? _a : {};
  debugGlobal[key] = completeDebugger;
  if (typeof window !== "undefined") {
    window["_debug"] = debugGlobal;
  }
}

React.createContext(void 0);

const TruncatedText = React__namespace.forwardRef(({ childElement, children }, ref) => {
  const [isOverflowing, setIsOverflowing] = React.useState(false);
  const internalRef = React.useRef(null);
  React.useImperativeHandle(ref, () => internalRef.current);
  const resizeObserver = React.useMemo(
    () => new ResizeObserver((entries) => {
      for (const entry of entries) {
        if (entry.target.clientWidth && entry.target.scrollWidth) {
          if (entry.target.scrollWidth > entry.target.clientWidth) {
            setIsOverflowing(true);
          }
          if (entry.target.scrollWidth <= entry.target.clientWidth) {
            setIsOverflowing(false);
          }
        }
      }
    }),
    []
  );
  React.useEffect(() => {
    const { current } = internalRef;
    if (current) {
      resizeObserver.observe(current);
    }
    return () => {
      resizeObserver.disconnect();
    };
  }, [setIsOverflowing, resizeObserver]);
  const getTooltipText = (children2) => {
    if (typeof children2 === "string") {
      return children2;
    }
    const html = ReactDOMServer__default.default.renderToStaticMarkup(/* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: children2 }));
    return html.replace(/(<([^>]+)>)/gi, "");
  };
  if (isOverflowing) {
    return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { ref: internalRef, content: getTooltipText(children), children: childElement(void 0) });
  } else {
    return childElement(internalRef);
  }
});
TruncatedText.displayName = "TruncatedText";

const customWeight = (weight, theme) => {
  switch (weight) {
    case "bold":
      return theme.typography.fontWeightBold;
    case "medium":
      return theme.typography.fontWeightMedium;
    case "light":
      return theme.typography.fontWeightLight;
    case "regular":
    case void 0:
      return theme.typography.fontWeightRegular;
  }
};
const customColor = (color, theme) => {
  switch (color) {
    case "error":
      return theme.colors.error.text;
    case "success":
      return theme.colors.success.text;
    case "info":
      return theme.colors.info.text;
    case "warning":
      return theme.colors.warning.text;
    default:
      return color ? theme.colors.text[color] : void 0;
  }
};
const customVariant = (theme, element, variant) => {
  if (variant) {
    return theme.typography[variant];
  }
  switch (element) {
    //Span elements does not have a default variant to be able to take the parents style
    case "span":
      return;
    case "h1":
      return theme.typography.h1;
    case "h2":
      return theme.typography.h2;
    case "h3":
      return theme.typography.h3;
    case "h4":
      return theme.typography.h4;
    case "h5":
      return theme.typography.h5;
    case "h6":
      return theme.typography.h6;
    default:
      return theme.typography.body;
  }
};

const Text = React__namespace.forwardRef(
  ({ element = "span", variant, weight, color, truncate, italic, textAlignment, children, tabular, ...restProps }, ref) => {
    const styles = useStyles2(getTextStyles, element, variant, color, weight, truncate, italic, textAlignment, tabular);
    const childElement = (ref2) => {
      return React.createElement(
        element,
        {
          ...restProps,
          style: void 0,
          // Remove the style prop to avoid overriding the styles
          className: styles,
          // When overflowing, the internalRef is passed to the tooltip, which forwards it to the child element
          ref: ref2
        },
        children
      );
    };
    if (!truncate || element === "span") {
      return childElement(void 0);
    }
    return /* @__PURE__ */ jsxRuntime.jsx(
      TruncatedText,
      {
        childElement,
        children,
        ref
      }
    );
  }
);
Text.displayName = "Text";
const getTextStyles = (theme, element, variant, color, weight, truncate, italic, textAlignment, tabular) => {
  return css.css([
    {
      margin: 0,
      padding: 0,
      ...customVariant(theme, element, variant)
    },
    variant && {
      ...theme.typography[variant]
    },
    color && {
      color: customColor(color, theme)
    },
    weight && {
      fontWeight: customWeight(weight, theme)
    },
    truncate && {
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    },
    italic && {
      fontStyle: "italic"
    },
    textAlignment && {
      textAlign: textAlignment
    },
    tabular && {
      fontFeatureSettings: '"tnum"'
    }
  ]);
};

const Dropdown = React__namespace.memo(({ children, overlay, placement, offset, onVisibleChange }) => {
  var _a, _b;
  const [show, setShow] = React.useState(false);
  const transitionRef = React.useRef(null);
  const handleOpenChange = React.useCallback(
    (newState) => {
      setShow(newState);
      onVisibleChange == null ? void 0 : onVisibleChange(newState);
    },
    [onVisibleChange]
  );
  const middleware = [
    react.offset({
      mainAxis: (_a = offset == null ? void 0 : offset[0]) != null ? _a : 8,
      crossAxis: (_b = offset == null ? void 0 : offset[1]) != null ? _b : 0
    }),
    react.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react.shift()
  ];
  const { context, refs, floatingStyles } = react.useFloating({
    open: show,
    placement: getPlacement(placement),
    onOpenChange: handleOpenChange,
    middleware,
    whileElementsMounted: react.autoUpdate
  });
  const click = react.useClick(context);
  const dismiss = react.useDismiss(context);
  const { getReferenceProps, getFloatingProps } = react.useInteractions([dismiss, click]);
  const animationDuration = 150;
  const animationStyles = useStyles2(getStyles$1n, animationDuration);
  const onOverlayClicked = () => {
    handleOpenChange(false);
  };
  const handleKeys = (event) => {
    if (event.key === "Tab") {
      handleOpenChange(false);
    }
  };
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    React__namespace.cloneElement(children, {
      ref: refs.setReference,
      ...getReferenceProps()
    }),
    show && /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsx(react.FloatingFocusManager, { context, children: /* @__PURE__ */ jsxRuntime.jsx("div", { ref: refs.setFloating, style: floatingStyles, onClick: onOverlayClicked, onKeyDown: handleKeys, children: /* @__PURE__ */ jsxRuntime.jsx(
      reactTransitionGroup.CSSTransition,
      {
        nodeRef: transitionRef,
        appear: true,
        in: true,
        timeout: { appear: animationDuration, exit: 0, enter: 0 },
        classNames: animationStyles,
        children: /* @__PURE__ */ jsxRuntime.jsx("div", { ref: transitionRef, children: renderOrCallToRender(overlay, { ...getFloatingProps() }) })
      }
    ) }) }) })
  ] });
});
Dropdown.displayName = "Dropdown";
const getStyles$1n = (theme, duration) => {
  return {
    appear: css.css({
      opacity: "0",
      position: "relative",
      transformOrigin: "top",
      [theme.transitions.handleMotion("no-preference")]: {
        transform: "scaleY(0.5)"
      }
    }),
    appearActive: css.css({
      opacity: "1",
      [theme.transitions.handleMotion("no-preference")]: {
        transform: "scaleY(1)",
        transition: `transform ${duration}ms cubic-bezier(0.2, 0, 0.2, 1), opacity ${duration}ms cubic-bezier(0.2, 0, 0.2, 1)`
      }
    })
  };
};

const ToolbarButton = React.forwardRef(
  ({
    tooltip,
    icon,
    iconSize,
    className,
    children,
    imgSrc,
    imgAlt,
    fullWidth,
    isOpen,
    narrow,
    variant = "default",
    iconOnly,
    "aria-label": ariaLabel,
    isHighlighted,
    ...rest
  }, ref) => {
    const styles = useStyles2(getStyles$1m);
    const buttonStyles = css.cx(
      {
        [styles.button]: true,
        [styles.buttonFullWidth]: fullWidth,
        [styles.narrow]: narrow
      },
      styles[variant],
      className
    );
    const contentStyles = css.cx({
      [styles.content]: true,
      [styles.contentWithIcon]: !!icon,
      [styles.contentWithRightIcon]: isOpen !== void 0
    });
    const body = /* @__PURE__ */ jsxRuntime.jsxs(
      "button",
      {
        ref,
        className: buttonStyles,
        "aria-label": getButtonAriaLabel(ariaLabel, tooltip),
        "aria-expanded": isOpen,
        type: "button",
        ...rest,
        children: [
          renderIcon(icon, iconSize),
          imgSrc && /* @__PURE__ */ jsxRuntime.jsx("img", { className: styles.img, src: imgSrc, alt: imgAlt != null ? imgAlt : "" }),
          children && !iconOnly && /* @__PURE__ */ jsxRuntime.jsx("div", { className: contentStyles, children }),
          isOpen === false && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-down" }),
          isOpen === true && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-up" }),
          isHighlighted && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.highlight })
        ]
      }
    );
    return tooltip ? /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { ref, content: tooltip, placement: "bottom", children: body }) : body;
  }
);
ToolbarButton.displayName = "ToolbarButton";
function getButtonAriaLabel(ariaLabel, tooltip) {
  return ariaLabel ? ariaLabel : tooltip ? e2eSelectors.selectors.components.PageToolbar.item(tooltip) : void 0;
}
function renderIcon(icon, iconSize) {
  if (!icon) {
    return null;
  }
  if (data.isIconName(icon)) {
    return /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, size: `${iconSize ? iconSize : "lg"}` });
  }
  return icon;
}
const getStyles$1m = (theme) => {
  const primaryVariant = getPropertiesForVariant(theme, "primary", "solid");
  const destructiveVariant = getPropertiesForVariant(theme, "destructive", "solid");
  const defaultOld = css.css({
    color: theme.colors.text.primary,
    background: theme.colors.secondary.main,
    "&:hover": {
      color: theme.colors.text.primary,
      background: theme.colors.secondary.shade,
      border: `1px solid ${theme.colors.border.medium}`
    }
  });
  return {
    button: css.css({
      label: "toolbar-button",
      position: "relative",
      display: "flex",
      alignItems: "center",
      height: theme.spacing(theme.components.height.md),
      padding: theme.spacing(0, 1),
      borderRadius: theme.shape.radius.default,
      lineHeight: `${theme.components.height.md * theme.spacing.gridSize - 2}px`,
      fontWeight: theme.typography.fontWeightMedium,
      border: `1px solid ${theme.colors.secondary.border}`,
      whiteSpace: "nowrap",
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: theme.transitions.create(["background", "box-shadow", "border-color", "color"], {
          duration: theme.transitions.duration.short
        })
      },
      [theme.breakpoints.down("md")]: {
        width: "auto !important"
      },
      "&:focus, &:focus-visible": {
        ...getFocusStyles(theme),
        zIndex: 1
      },
      "&:focus:not(:focus-visible)": getMouseFocusStyles(),
      "&[disabled], &:disabled": {
        cursor: "not-allowed",
        opacity: theme.colors.action.disabledOpacity,
        background: theme.colors.action.disabledBackground,
        boxShadow: "none",
        "&:hover": {
          color: theme.colors.text.disabled,
          background: theme.colors.action.disabledBackground,
          boxShadow: "none"
        }
      }
    }),
    default: css.css({
      color: theme.colors.text.secondary,
      background: "transparent",
      border: `1px solid transparent`,
      "&:hover": {
        color: theme.colors.text.primary,
        background: theme.colors.action.hover
      }
    }),
    canvas: defaultOld,
    active: css.cx(
      defaultOld,
      css.css({
        "&::before": {
          display: "block",
          content: '" "',
          position: "absolute",
          left: 0,
          right: 0,
          height: "2px",
          bottom: 0,
          borderRadius: theme.shape.radius.default,
          backgroundImage: theme.colors.gradients.brandHorizontal
        }
      })
    ),
    primary: css.css(primaryVariant),
    destructive: css.css(destructiveVariant),
    narrow: css.css({
      padding: theme.spacing(0, 0.5)
    }),
    img: css.css({
      width: "16px",
      height: "16px",
      marginRight: theme.spacing(1)
    }),
    buttonFullWidth: css.css({
      flexGrow: 1
    }),
    content: css.css({
      display: "flex",
      flexGrow: 1
    }),
    contentWithIcon: css.css({
      display: "none",
      paddingLeft: theme.spacing(1),
      [`@media ${mediaUp(theme.v1.breakpoints.md)}`]: {
        display: "block"
      }
    }),
    contentWithRightIcon: css.css({
      paddingRight: theme.spacing(0.5)
    }),
    highlight: css.css({
      backgroundColor: theme.colors.success.main,
      borderRadius: theme.shape.radius.circle,
      width: "6px",
      height: "6px",
      position: "absolute",
      top: "-3px",
      right: "-3px",
      zIndex: 1
    })
  };
};

const ToolbarButtonRow = React.forwardRef(
  ({ alignment = "left", className, children, ...rest }, ref) => {
    const childrenWithoutNull = React.Children.toArray(children).filter((child) => child != null);
    const [childVisibility, setChildVisibility] = React.useState(Array(childrenWithoutNull.length).fill(false));
    const containerRef = React.useRef(null);
    const [showOverflowItems, setShowOverflowItems] = React.useState(false);
    const overflowRef = React.useRef(null);
    const overflowItemsRef = React.createRef();
    const { overlayProps } = overlays.useOverlay(
      {
        onClose: () => setShowOverflowItems(false),
        isDismissable: true,
        isOpen: showOverflowItems,
        shouldCloseOnInteractOutside: (element) => {
          var _a;
          const portalContainer = getPortalContainer();
          return !((_a = overflowRef.current) == null ? void 0 : _a.contains(element)) && !portalContainer.contains(element);
        }
      },
      overflowItemsRef
    );
    const { dialogProps } = dialog.useDialog({}, overflowItemsRef);
    const theme = useTheme2();
    const overflowButtonOrder = alignment === "left" ? childVisibility.indexOf(false) - 1 : childVisibility.length;
    const styles = getStyles$1l(theme, overflowButtonOrder, alignment);
    React.useLayoutEffect(() => {
      const intersectionObserver = new IntersectionObserver(
        (entries) => {
          entries.forEach((entry) => {
            if (entry.target instanceof HTMLElement && entry.target.parentNode) {
              const index = Array.prototype.indexOf.call(entry.target.parentNode.children, entry.target);
              setChildVisibility((prev) => {
                const newVisibility = [...prev];
                newVisibility[index] = entry.isIntersecting;
                return newVisibility;
              });
            }
          });
        },
        {
          threshold: 1,
          root: containerRef.current
        }
      );
      if (containerRef.current) {
        Array.from(containerRef.current.children).forEach((item) => {
          if (item instanceof HTMLElement && item !== overflowRef.current) {
            intersectionObserver.observe(item);
          }
        });
      }
      return () => intersectionObserver.disconnect();
    }, [children]);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { ref: containerRef, className: css.cx(styles.container, className), ...rest, children: [
      childrenWithoutNull.map((child, index) => /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          style: { order: index, visibility: childVisibility[index] ? "visible" : "hidden" },
          className: styles.childWrapper,
          children: child
        },
        index
      )),
      childVisibility.includes(false) && /* @__PURE__ */ jsxRuntime.jsxs("div", { ref: overflowRef, className: styles.overflowButton, children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          ToolbarButton,
          {
            variant: showOverflowItems ? "active" : "default",
            tooltip: t("grafana-ui.toolbar-button-row.show-more", "Show more items"),
            onClick: () => setShowOverflowItems(!showOverflowItems),
            icon: "ellipsis-v",
            iconOnly: true,
            narrow: true
          }
        ),
        showOverflowItems && /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, autoFocus: true, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.overflowItems, ref: overflowItemsRef, ...overlayProps, ...dialogProps, children: childrenWithoutNull.map((child, index) => !childVisibility[index] && child) }) })
      ] })
    ] });
  }
);
ToolbarButtonRow.displayName = "ToolbarButtonRow";
const getStyles$1l = (theme, overflowButtonOrder, alignment) => ({
  overflowButton: css.css({
    order: overflowButtonOrder
  }),
  overflowItems: css.css({
    alignItems: "center",
    backgroundColor: theme.colors.background.primary,
    borderRadius: theme.shape.radius.default,
    boxShadow: theme.shadows.z2,
    display: "flex",
    flexWrap: "wrap",
    gap: theme.spacing(1),
    marginTop: theme.spacing(1),
    maxWidth: "80vw",
    padding: theme.spacing(0.5, 1),
    position: "absolute",
    right: 0,
    top: "100%",
    width: "max-content",
    zIndex: theme.zIndex.dropdown
  }),
  container: css.css({
    alignItems: "center",
    display: "flex",
    gap: theme.spacing(1),
    justifyContent: alignment === "left" ? "flex-start" : "flex-end",
    minWidth: 0,
    position: "relative"
  }),
  childWrapper: css.css({
    alignItems: "center",
    display: "flex",
    gap: theme.spacing(1)
  })
});

const TitleItem = React.forwardRef(
  ({ className, children, href, onClick, target, title, ...rest }, ref) => {
    const styles = useStyles2(getStyles$1k);
    if (href) {
      return /* @__PURE__ */ jsxRuntime.jsx(
        "a",
        {
          ref,
          href,
          onClick,
          target,
          title,
          className: css.cx(styles.linkItem, className),
          ...rest,
          children
        }
      );
    } else if (onClick) {
      return /* @__PURE__ */ jsxRuntime.jsx(Button, { ref, className: css.cx(styles.item, className), variant: "secondary", fill: "text", onClick, children });
    } else {
      return /* @__PURE__ */ jsxRuntime.jsx("span", { ref, className: css.cx(styles.item, className), ...rest, children });
    }
  }
);
TitleItem.displayName = "TitleItem";
const getStyles$1k = (theme) => {
  const item = css.css({
    color: `${theme.colors.text.secondary}`,
    label: "panel-header-item",
    cursor: "auto",
    border: "none",
    borderRadius: `${theme.shape.radius.default}`,
    padding: `${theme.spacing(0, 1)}`,
    height: `${theme.spacing(theme.components.panel.headerHeight)}`,
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    "&:focus, &:focus-visible": {
      ...getFocusStyles(theme),
      zIndex: 1
    },
    "&: focus:not(:focus-visible)": getMouseFocusStyles(),
    "&:hover ": {
      boxShadow: `${theme.shadows.z1}`,
      background: `${theme.colors.background.secondary}`,
      color: `${theme.colors.text.primary}`
    }
  });
  return {
    item,
    linkItem: css.cx(item, css.css({ cursor: "pointer" }))
  };
};

const PanelContextRoot = React.createContext({
  eventsScope: "global",
  eventBus: new data.EventBusSrv()
});
PanelContextRoot.Provider;
const usePanelContext = () => React.useContext(PanelContextRoot);

var SeriesVisibilityChangeMode = /* @__PURE__ */ ((SeriesVisibilityChangeMode2) => {
  SeriesVisibilityChangeMode2["ToggleSelection"] = "select";
  SeriesVisibilityChangeMode2["AppendToSelection"] = "append";
  return SeriesVisibilityChangeMode2;
})(SeriesVisibilityChangeMode || {});

function InlineToast({ referenceElement, children, suffixIcon, placement }) {
  const styles = useStyles2(getStyles$1j);
  const theme = useTheme2();
  const middleware = [
    react.offset(8),
    react.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react.shift()
  ];
  const { context, refs, floatingStyles } = react.useFloating({
    open: true,
    placement,
    middleware,
    whileElementsMounted: react.autoUpdate,
    strategy: "fixed"
  });
  React.useLayoutEffect(() => {
    refs.setReference(referenceElement);
  }, [referenceElement, refs]);
  const { styles: placementStyles } = react.useTransitionStyles(context, {
    initial: ({ side }) => {
      return {
        opacity: 0,
        transform: getInitialTransform(side, theme)
      };
    },
    duration: theme.transitions.duration.shortest
  });
  return /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsx("div", { style: { display: "inline-block", ...floatingStyles }, ref: refs.setFloating, "aria-live": "polite", children: /* @__PURE__ */ jsxRuntime.jsxs("span", { className: css.cx(styles.root), style: placementStyles, children: [
    children && /* @__PURE__ */ jsxRuntime.jsx("span", { children }),
    suffixIcon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: suffixIcon })
  ] }) }) });
}
const getStyles$1j = (theme) => {
  return {
    root: css.css({
      ...theme.typography.bodySmall,
      willChange: "transform",
      background: theme.components.tooltip.background,
      color: theme.components.tooltip.text,
      padding: theme.spacing(0.5, 1.5),
      // get's an extra .5 of vertical padding to account for the rounded corners
      borderRadius: theme.shape.radius.pill,
      display: "inline-flex",
      gap: theme.spacing(0.5),
      alignItems: "center"
    })
  };
};
const getInitialTransform = (placement, theme) => {
  const gap = 1;
  switch (placement) {
    case "top":
      return `translateY(${theme.spacing(gap)})`;
    case "bottom":
      return `translateY(-${theme.spacing(gap)})`;
    case "left":
      return `translateX(${theme.spacing(gap)})`;
    case "right":
      return `translateX(-${theme.spacing(gap)})`;
  }
};

const SHOW_SUCCESS_DURATION = 2 * 1e3;
function ClipboardButton({
  onClipboardCopy,
  onClipboardError,
  children,
  getText,
  icon,
  variant,
  ...buttonProps
}) {
  const styles = useStyles2(getStyles$1i);
  const [showCopySuccess, setShowCopySuccess] = React.useState(false);
  React.useEffect(() => {
    let timeoutId;
    if (showCopySuccess) {
      timeoutId = setTimeout(() => {
        setShowCopySuccess(false);
      }, SHOW_SUCCESS_DURATION);
    }
    return () => {
      window.clearTimeout(timeoutId);
    };
  }, [showCopySuccess]);
  const buttonRef = React.useRef(null);
  const copyTextCallback = React.useCallback(async () => {
    const textToCopy = getText();
    try {
      await copyText(textToCopy, buttonRef);
      setShowCopySuccess(true);
      onClipboardCopy == null ? void 0 : onClipboardCopy(textToCopy);
    } catch (e) {
      onClipboardError == null ? void 0 : onClipboardError(textToCopy, e);
    }
  }, [getText, onClipboardCopy, onClipboardError]);
  const copiedText = t("clipboard-button.inline-toast.success", "Copied");
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    showCopySuccess && /* @__PURE__ */ jsxRuntime.jsx(InlineToast, { placement: "top", referenceElement: buttonRef.current, children: copiedText }),
    /* @__PURE__ */ jsxRuntime.jsxs(
      Button,
      {
        onClick: copyTextCallback,
        icon,
        variant: showCopySuccess ? "success" : variant,
        "aria-label": showCopySuccess ? copiedText : void 0,
        ...buttonProps,
        className: css.cx(styles.button, showCopySuccess && styles.successButton, buttonProps.className),
        ref: buttonRef,
        children: [
          children,
          showCopySuccess && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.successOverlay, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "check" }) })
        ]
      }
    )
  ] });
}
const copyText = async (text, buttonRef) => {
  var _a;
  if (navigator.clipboard && window.isSecureContext) {
    return navigator.clipboard.writeText(text);
  } else {
    const textarea = document.createElement("textarea");
    (_a = buttonRef.current) == null ? void 0 : _a.appendChild(textarea);
    textarea.value = text;
    textarea.focus();
    textarea.select();
    document.execCommand("copy");
    textarea.remove();
  }
};
const getStyles$1i = (theme) => {
  return {
    button: css.css({
      position: "relative"
    }),
    successButton: css.css({
      "> *": css.css({
        visibility: "hidden"
      })
    }),
    successOverlay: css.css({
      position: "absolute",
      top: 0,
      bottom: 0,
      right: 0,
      left: 0,
      visibility: "visible"
      // re-visible the overlay
    })
  };
};

const getDragStyles = (theme, handlePosition) => {
  const position = handlePosition || "middle";
  const baseColor = theme.colors.emphasize(theme.colors.background.secondary, 0.15);
  const hoverColor = theme.colors.primary.border;
  const clickTargetSize = theme.spacing(2);
  const handlebarThickness = 4;
  const handlebarWidth = 200;
  let verticalOffset = "50%";
  let horizontalOffset = "50%";
  switch (position) {
    case "start": {
      verticalOffset = "0%";
      horizontalOffset = "0%";
      break;
    }
    case "end": {
      verticalOffset = "100%";
      horizontalOffset = "100%";
      break;
    }
  }
  const dragHandleBase = css.css({
    position: "relative",
    "&:before": {
      content: '""',
      position: "absolute",
      transition: theme.transitions.create("border-color"),
      zIndex: 1
    },
    "&:after": {
      background: baseColor,
      content: '""',
      position: "absolute",
      transition: theme.transitions.create("background"),
      transform: "translate(-50%, -50%)",
      borderRadius: theme.shape.radius.pill,
      zIndex: 1
    },
    "&:hover": {
      "&:before": {
        borderColor: hoverColor
      },
      "&:after": {
        background: hoverColor
      }
    }
  });
  const beforeVertical = {
    borderRight: "1px solid transparent",
    height: "100%",
    left: verticalOffset,
    transform: "translateX(-50%)"
  };
  const beforeHorizontal = {
    borderTop: "1px solid transparent",
    top: horizontalOffset,
    transform: "translateY(-50%)"
  };
  return {
    dragHandleVertical: css.cx(
      dragHandleBase,
      css.css({
        cursor: "col-resize",
        width: clickTargetSize,
        "&:before": beforeVertical,
        "&:after": {
          left: verticalOffset,
          top: "50%",
          height: handlebarWidth,
          width: handlebarThickness
        }
      })
    ),
    dragHandleHorizontal: css.cx(
      dragHandleBase,
      css.css({
        height: clickTargetSize,
        cursor: "row-resize",
        "&:before": beforeHorizontal,
        "&:after": {
          left: "50%",
          top: horizontalOffset,
          height: handlebarThickness,
          width: handlebarWidth
        }
      })
    ),
    dragHandleBaseVertical: css.cx(
      dragHandleBase,
      css.css({
        cursor: "col-resize",
        width: clickTargetSize,
        "&:before": beforeVertical
      })
    ),
    dragHandleBaseHorizontal: css.cx(
      dragHandleBase,
      css.css({
        cursor: "row-resize",
        height: clickTargetSize,
        "&:before": beforeHorizontal
      })
    )
  };
};

const IconButton = React__namespace.forwardRef((props, ref) => {
  const { size = "md", variant = "secondary" } = props;
  let limitedIconSize;
  if (size === "xxl" || size === "xxxl") {
    data.deprecationWarning("IconButton", 'size="xxl" and size="xxxl"', 'size="xl"');
    limitedIconSize = "xl";
  } else {
    limitedIconSize = size;
  }
  const styles = useStyles2(getStyles$1h, limitedIconSize, variant);
  let ariaLabel;
  let buttonRef;
  if ("tooltip" in props) {
    const { tooltip } = props;
    ariaLabel = typeof tooltip === "string" ? tooltip : void 0;
  } else if ("ariaLabel" in props || "aria-label" in props) {
    const { ariaLabel: deprecatedAriaLabel, ["aria-label"]: ariaLabelProp } = props;
    ariaLabel = ariaLabelProp || deprecatedAriaLabel;
    buttonRef = ref;
  }
  if ("tooltip" in props) {
    const { name, iconType, className, tooltip, tooltipPlacement, ...restProps } = props;
    return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { ref, content: tooltip, placement: tooltipPlacement, children: /* @__PURE__ */ jsxRuntime.jsx(
      "button",
      {
        ...restProps,
        ref: buttonRef,
        "aria-label": ariaLabel,
        className: css.cx(styles.button, className),
        type: "button",
        children: /* @__PURE__ */ jsxRuntime.jsx(IconRenderer, { icon: name, size: limitedIconSize, className: styles.icon, iconType })
      }
    ) });
  } else {
    const { name, iconType, className, ...restProps } = props;
    return /* @__PURE__ */ jsxRuntime.jsx(
      "button",
      {
        ...restProps,
        ref: buttonRef,
        "aria-label": ariaLabel,
        className: css.cx(styles.button, className),
        type: "button",
        children: /* @__PURE__ */ jsxRuntime.jsx(IconRenderer, { icon: name, size: limitedIconSize, className: styles.icon, iconType })
      }
    );
  }
});
IconButton.displayName = "IconButton";
const getStyles$1h = (theme, size, variant) => {
  const hoverSize = getSvgSize(size) + theme.spacing.gridSize;
  let iconColor = theme.colors.text.primary;
  if (variant === "primary") {
    iconColor = theme.colors.primary.text;
  } else if (variant === "destructive") {
    iconColor = theme.colors.error.text;
  }
  return {
    button: css.css({
      zIndex: 0,
      position: "relative",
      margin: `0 ${theme.spacing.x0_5} 0 0`,
      boxShadow: "none",
      border: "none",
      display: "inline-flex",
      background: "transparent",
      justifyContent: "center",
      alignItems: "center",
      padding: 0,
      color: iconColor,
      "&[disabled], &:disabled": {
        cursor: "not-allowed",
        color: theme.colors.action.disabledText,
        opacity: 0.65
      },
      "&:before": {
        zIndex: -1,
        position: "absolute",
        opacity: 0,
        width: `${hoverSize}px`,
        height: `${hoverSize}px`,
        borderRadius: theme.shape.radius.default,
        content: '""',
        [theme.transitions.handleMotion("no-preference", "reduce")]: {
          transitionDuration: "0.2s",
          transitionTimingFunction: "cubic-bezier(0.4, 0, 0.2, 1)",
          transitionProperty: "opacity"
        }
      },
      "&:focus, &:focus-visible": getFocusStyles(theme),
      "&:focus:not(:focus-visible)": getMouseFocusStyles(),
      "&:hover": {
        "&:before": {
          backgroundColor: variant === "secondary" ? theme.colors.action.hover : data.colorManipulator.alpha(iconColor, 0.12),
          opacity: 1
        }
      }
    }),
    icon: css.css({
      verticalAlign: "baseline"
    })
  };
};

const ScrollIndicators$1 = ({ children }) => {
  const [showScrollTopIndicator, setShowTopScrollIndicator] = React.useState(false);
  const [showScrollBottomIndicator, setShowBottomScrollIndicator] = React.useState(false);
  const scrollTopMarker = React.useRef(null);
  const scrollBottomMarker = React.useRef(null);
  const styles = useStyles2(getStyles$1g);
  React.useEffect(() => {
    const intersectionObserver = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.target === scrollTopMarker.current) {
          setShowTopScrollIndicator(!entry.isIntersecting);
        } else if (entry.target === scrollBottomMarker.current) {
          setShowBottomScrollIndicator(!entry.isIntersecting);
        }
      });
    });
    [scrollTopMarker, scrollBottomMarker].forEach((ref) => {
      if (ref.current) {
        intersectionObserver.observe(ref.current);
      }
    });
    return () => intersectionObserver.disconnect();
  }, []);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.cx(styles.scrollIndicator, styles.scrollTopIndicator, {
          [styles.scrollIndicatorVisible]: showScrollTopIndicator
        }),
        role: "presentation"
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.scrollContent, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { ref: scrollTopMarker, className: css.cx(styles.scrollMarker, styles.scrollTopMarker) }),
      children,
      /* @__PURE__ */ jsxRuntime.jsx("div", { ref: scrollBottomMarker, className: css.cx(styles.scrollMarker, styles.scrollBottomMarker) })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.cx(styles.scrollIndicator, styles.scrollBottomIndicator, {
          [styles.scrollIndicatorVisible]: showScrollBottomIndicator
        }),
        role: "presentation"
      }
    )
  ] });
};
const getStyles$1g = (theme) => {
  const scrollGradientColor = `rgba(0, 0, 0, ${theme.isDark ? 0.25 : 0.08})`;
  return {
    scrollContent: css.css({
      display: "flex",
      flexDirection: "column",
      flexGrow: 1,
      position: "relative"
    }),
    scrollIndicator: css.css({
      height: `max(5%, ${theme.spacing(3)})`,
      left: 0,
      opacity: 0,
      pointerEvents: "none",
      position: "absolute",
      right: 0,
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: theme.transitions.create("opacity")
      },
      zIndex: 1
    }),
    scrollTopIndicator: css.css({
      background: `linear-gradient(0deg, transparent, ${scrollGradientColor})`,
      top: 0
    }),
    scrollBottomIndicator: css.css({
      background: `linear-gradient(180deg, transparent, ${scrollGradientColor})`,
      bottom: 0
    }),
    scrollIndicatorVisible: css.css({
      opacity: 1
    }),
    scrollMarker: css.css({
      height: "1px",
      left: 0,
      pointerEvents: "none",
      position: "absolute",
      right: 0
    }),
    scrollTopMarker: css.css({
      top: 0
    }),
    scrollBottomMarker: css.css({
      bottom: 0
    })
  };
};

const ScrollContainer = React.forwardRef(
  ({
    children,
    showScrollIndicators = false,
    onScroll,
    overflowX = "auto",
    overflowY = "auto",
    scrollbarWidth = "thin",
    ...rest
  }, ref) => {
    const styles = useStyles2(getStyles$1f, scrollbarWidth, overflowY, overflowX);
    const defaults = {
      maxHeight: "100%",
      minHeight: 0,
      minWidth: 0
    };
    const boxProps = { ...defaults, ...rest };
    return /* @__PURE__ */ jsxRuntime.jsx(Box, { ...boxProps, display: "flex", direction: "column", flex: 1, position: "relative", children: /* @__PURE__ */ jsxRuntime.jsx("div", { onScroll, className: styles.scroller, ref, children: showScrollIndicators ? /* @__PURE__ */ jsxRuntime.jsx(ScrollIndicators$1, { children }) : children }) });
  }
);
ScrollContainer.displayName = "ScrollContainer";
const getStyles$1f = (theme, scrollbarWidth, overflowY, overflowX) => ({
  scroller: css.css({
    display: "flex",
    flex: 1,
    flexDirection: "column",
    overflowX,
    overflowY,
    scrollbarWidth
  })
});

const drawerSizes = {
  sm: { width: "25vw", minWidth: 384 },
  md: { width: "50vw", minWidth: 568 },
  lg: { width: "75vw", minWidth: 744 }
};
function Drawer({
  children,
  onClose,
  closeOnMaskClick = true,
  scrollableContent = true,
  title,
  subtitle,
  width,
  size = "md",
  tabs
}) {
  var _a;
  const [drawerWidth, onMouseDown, onTouchStart] = useResizebleDrawer();
  const styles = useStyles2(getStyles$1e);
  const wrapperStyles = useStyles2(getWrapperStyles, size);
  const dragStyles = useStyles2(getDragStyles);
  const overlayRef = React__namespace.useRef(null);
  const { dialogProps, titleProps } = dialog.useDialog({}, overlayRef);
  const { overlayProps } = overlays.useOverlay(
    {
      isDismissable: false,
      isOpen: true,
      onClose
    },
    overlayRef
  );
  useBodyClassWhileOpen();
  const content = /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.content, children });
  const overrideWidth = (_a = drawerWidth != null ? drawerWidth : width) != null ? _a : drawerSizes[size].width;
  const minWidth = drawerSizes[size].minWidth;
  return /* @__PURE__ */ jsxRuntime.jsx(
    RcDrawer__default.default,
    {
      open: true,
      onClose,
      placement: "right",
      getContainer: ".main-view",
      className: styles.drawerContent,
      rootClassName: styles.drawer,
      classNames: {
        wrapper: wrapperStyles
      },
      styles: {
        wrapper: {
          width: overrideWidth,
          minWidth
        }
      },
      width: "",
      motion: {
        motionAppear: true,
        motionName: styles.drawerMotion
      },
      maskClassName: styles.mask,
      maskClosable: closeOnMaskClick,
      maskMotion: {
        motionAppear: true,
        motionName: styles.maskMotion
      },
      children: /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { restoreFocus: true, contain: true, autoFocus: true, children: /* @__PURE__ */ jsxRuntime.jsxs(
        "div",
        {
          "aria-label": typeof title === "string" ? e2eSelectors.selectors.components.Drawer.General.title(title) : e2eSelectors.selectors.components.Drawer.General.title("no title"),
          className: styles.container,
          ...overlayProps,
          ...dialogProps,
          ref: overlayRef,
          children: [
            /* @__PURE__ */ jsxRuntime.jsx(
              "div",
              {
                className: css.cx(dragStyles.dragHandleVertical, styles.resizer),
                onMouseDown,
                onTouchStart
              }
            ),
            typeof title === "string" && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.header, Boolean(tabs) && styles.headerWithTabs), children: [
              /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.actions, children: /* @__PURE__ */ jsxRuntime.jsx(
                IconButton,
                {
                  name: "times",
                  variant: "secondary",
                  onClick: onClose,
                  "data-testid": e2eSelectors.selectors.components.Drawer.General.close,
                  tooltip: t(`grafana-ui.drawer.close`, "Close")
                }
              ) }),
              /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.titleWrapper, children: [
                /* @__PURE__ */ jsxRuntime.jsx(Text, { element: "h3", ...titleProps, children: title }),
                subtitle && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.subtitle, "data-testid": e2eSelectors.selectors.components.Drawer.General.subtitle, children: subtitle }),
                tabs && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.tabsWrapper, children: tabs })
              ] })
            ] }),
            typeof title !== "string" && title,
            !scrollableContent ? content : /* @__PURE__ */ jsxRuntime.jsx(ScrollContainer, { showScrollIndicators: true, children: content })
          ]
        }
      ) })
    }
  );
}
function useResizebleDrawer() {
  const [drawerWidth, setDrawerWidth] = React.useState(void 0);
  const onMouseMove = React.useCallback((e) => {
    setDrawerWidth(getCustomDrawerWidth(e.clientX));
  }, []);
  const onTouchMove = React.useCallback((e) => {
    const touch = e.touches[0];
    setDrawerWidth(getCustomDrawerWidth(touch.clientX));
  }, []);
  const onMouseUp = React.useCallback(
    (e) => {
      document.removeEventListener("mousemove", onMouseMove);
      document.removeEventListener("mouseup", onMouseUp);
    },
    [onMouseMove]
  );
  const onTouchEnd = React.useCallback(
    (e) => {
      document.removeEventListener("touchmove", onTouchMove);
      document.removeEventListener("touchend", onTouchEnd);
    },
    [onTouchMove]
  );
  function onMouseDown(e) {
    e.stopPropagation();
    e.preventDefault();
    document.addEventListener("mousemove", onMouseMove);
    document.addEventListener("mouseup", onMouseUp);
  }
  function onTouchStart(e) {
    e.stopPropagation();
    e.preventDefault();
    document.addEventListener("touchmove", onTouchMove);
    document.addEventListener("touchend", onTouchEnd);
  }
  return [drawerWidth, onMouseDown, onTouchStart];
}
function getCustomDrawerWidth(clientX) {
  let offsetRight = document.body.offsetWidth - (clientX - document.body.offsetLeft);
  let widthPercent = Math.min(offsetRight / document.body.clientWidth * 100, 98).toFixed(2);
  return `${widthPercent}vw`;
}
function useBodyClassWhileOpen() {
  React.useEffect(() => {
    if (!document.body) {
      return;
    }
    document.body.classList.add("body-drawer-open");
    return () => {
      document.body.classList.remove("body-drawer-open");
    };
  }, []);
}
const getStyles$1e = (theme) => {
  return {
    container: css.css({
      display: "flex",
      flexDirection: "column",
      height: "100%",
      flex: "1 1 0",
      minHeight: "100%",
      position: "relative"
    }),
    drawer: css.css({
      top: 0,
      ".rc-drawer-content-wrapper": {
        boxShadow: theme.shadows.z3
      }
    }),
    drawerContent: css.css({
      backgroundColor: `${theme.colors.background.primary} !important`,
      display: "flex",
      overflow: "unset !important",
      flexDirection: "column"
    }),
    drawerMotion: css.css({
      "&-appear": {
        transform: "translateX(100%)",
        transition: "none !important",
        "&-active": {
          transition: `${theme.transitions.create("transform")} !important`,
          transform: "translateX(0)"
        }
      }
    }),
    // we want the mask itself to span the whole page including the top bar
    // this ensures trying to click something in the top bar will close the drawer correctly
    // but we don't want the backdrop styling to apply over the top bar as it looks weird
    // instead have a child pseudo element to apply the backdrop styling below the top bar
    mask: css.css({
      // The !important here is to override the default .rc-drawer-mask styles
      backgroundColor: "transparent !important",
      // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
      position: "fixed !important",
      "&:before": {
        backgroundColor: `${theme.components.overlay.background} !important`,
        bottom: 0,
        content: '""',
        left: 0,
        position: "fixed",
        right: 0,
        top: 0
      }
    }),
    maskMotion: css.css({
      "&-appear": {
        opacity: 0,
        "&-active": {
          opacity: 1,
          transition: theme.transitions.create("opacity")
        }
      }
    }),
    header: css.css({
      label: "drawer-header",
      flexGrow: 0,
      padding: theme.spacing(2, 2, 3),
      borderBottom: `1px solid ${theme.colors.border.weak}`
    }),
    headerWithTabs: css.css({
      borderBottom: "none"
    }),
    actions: css.css({
      position: "absolute",
      right: theme.spacing(1),
      top: theme.spacing(1)
    }),
    titleWrapper: css.css({
      label: "drawer-title",
      overflowWrap: "break-word"
    }),
    subtitle: css.css({
      label: "drawer-subtitle",
      color: theme.colors.text.secondary,
      paddingTop: theme.spacing(1)
    }),
    content: css.css({
      padding: theme.spacing(2),
      height: "100%",
      flexGrow: 1,
      minHeight: 0
    }),
    tabsWrapper: css.css({
      label: "drawer-tabs",
      paddingLeft: theme.spacing(2),
      margin: theme.spacing(1, -1, -3, -3)
    }),
    resizer: css.css({
      top: 0,
      left: theme.spacing(-1),
      bottom: 0,
      position: "absolute",
      zIndex: theme.zIndex.modal
    })
  };
};
function getWrapperStyles(theme, size) {
  return css.css({
    label: `drawer-content-wrapper-${size}`,
    overflow: "unset !important",
    [theme.breakpoints.down("md")]: {
      width: `calc(100% - ${theme.spacing(2)}) !important`,
      minWidth: "0 !important"
    }
  });
}

const useAsyncDependency = (importStatement) => {
  const state = reactUse.useAsync(async () => {
    return await importStatement;
  });
  return {
    ...state,
    dependency: state.value
  };
};

const ErrorWithStack = ({ error, errorInfo, title }) => {
  const style = useStyles2(getStyles$1d);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: style, children: [
    /* @__PURE__ */ jsxRuntime.jsx("h2", { children: title }),
    /* @__PURE__ */ jsxRuntime.jsxs("details", { style: { whiteSpace: "pre-wrap" }, children: [
      error && error.toString(),
      /* @__PURE__ */ jsxRuntime.jsx("br", {}),
      errorInfo && errorInfo.componentStack
    ] })
  ] });
};
ErrorWithStack.displayName = "ErrorWithStack";
const getStyles$1d = () => {
  return css.css({
    width: "500px",
    margin: "64px auto"
  });
};

var CompletionItemKind = /* @__PURE__ */ ((CompletionItemKind2) => {
  CompletionItemKind2["GroupTitle"] = "GroupTitle";
  return CompletionItemKind2;
})(CompletionItemKind || {});

const isIconSize = (value) => {
  return ["xs", "sm", "md", "lg", "xl", "xxl", "xxxl"].includes(value);
};
function getFieldTypeIcon(field) {
  return getFieldTypeIconName(field == null ? void 0 : field.type);
}
function getFieldTypeIconName(type) {
  if (type) {
    switch (type) {
      case data.FieldType.time:
        return "clock-nine";
      case data.FieldType.string:
        return "font";
      case data.FieldType.number:
        return "calculator-alt";
      case data.FieldType.boolean:
        return "toggle-on";
      case data.FieldType.trace:
        return "info-circle";
      case data.FieldType.enum:
        return "list-ol";
      case data.FieldType.geo:
        return "map-marker";
      case data.FieldType.other:
        return "brackets-curly";
    }
  }
  return "question-circle";
}

const Spinner = ({
  className,
  inline = false,
  iconClassName,
  style,
  size = "md"
}) => {
  const styles = useStyles2(getStyles$1c);
  const deprecatedStyles = useStyles2(getDeprecatedStyles, size);
  const prefersReducedMotion = window.matchMedia("(prefers-reduced-motion: reduce)").matches;
  const iconName = prefersReducedMotion ? "hourglass" : "spinner";
  if (typeof size !== "string" || !isIconSize(size)) {
    const iconRoot = getIconRoot();
    const subDir = getIconSubDir(iconName, "default");
    const svgPath = `${iconRoot}${subDir}/${iconName}.svg`;
    return /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        "data-testid": "Spinner",
        style,
        className: css.cx(
          {
            [styles.inline]: inline
          },
          deprecatedStyles.wrapper,
          className
        ),
        children: /* @__PURE__ */ jsxRuntime.jsx(
          SVG__default.default,
          {
            src: svgPath,
            width: size,
            height: size,
            className: css.cx(styles.spin, deprecatedStyles.icon, className),
            style
          }
        )
      }
    );
  }
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      "data-testid": "Spinner",
      style,
      className: css.cx(
        {
          [styles.inline]: inline
        },
        className
      ),
      children: /* @__PURE__ */ jsxRuntime.jsx(
        Icon,
        {
          className: css.cx(styles.spin, iconClassName),
          name: iconName,
          size,
          "aria-label": t("grafana-ui.spinner.aria-label", "Loading")
        }
      )
    }
  );
};
const getStyles$1c = (theme) => ({
  inline: css.css({
    display: "inline-block"
  }),
  spin: css.css({
    [theme.transitions.handleMotion("no-preference")]: {
      animation: `${spin} 2s infinite linear`
    }
  })
});
const getDeprecatedStyles = (theme, size) => ({
  wrapper: css.css({
    fontSize: typeof size === "string" ? size : `${size}px`
  }),
  icon: css.css({
    display: "inline-block",
    fill: "currentColor",
    flexShrink: 0,
    label: "Icon",
    // line-height: 0; is needed for correct icon alignment in Safari
    lineHeight: 0,
    verticalAlign: "middle"
  })
});

const LoadingPlaceholder = ({ text, className, ...rest }) => {
  const styles = useStyles2(getStyles$1b);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.container, className), ...rest, children: [
    text,
    " ",
    /* @__PURE__ */ jsxRuntime.jsx(Spinner, { inline: true })
  ] });
};
const getStyles$1b = (theme) => {
  return {
    container: css.css({
      marginBottom: theme.spacing(4)
    })
  };
};

const ReactMonacoEditorLazy = (props) => {
  var _a, _b;
  const styles = useStyles2(getStyles$1a);
  const { loading, error, dependency } = useAsyncDependency(
    Promise.resolve().then(function () { return require(
      /* webpackChunkName: "react-monaco-editor" */
      './ReactMonacoEditor-s1PqCgJq.js'
    ); })
  );
  if (loading) {
    return /* @__PURE__ */ jsxRuntime.jsx(
      LoadingPlaceholder,
      {
        text: t("grafana-ui.monaco.loading-placeholder", "Loading editor"),
        className: styles.container
      }
    );
  }
  if (error) {
    return /* @__PURE__ */ jsxRuntime.jsx(
      ErrorWithStack,
      {
        title: t("grafana-ui.monaco.error-label", "React Monaco Editor failed to load"),
        error,
        errorInfo: { componentStack: (_a = error == null ? void 0 : error.stack) != null ? _a : "" }
      }
    );
  }
  const ReactMonacoEditor = dependency.ReactMonacoEditor;
  return /* @__PURE__ */ jsxRuntime.jsx(
    ReactMonacoEditor,
    {
      ...props,
      loading: (_b = props.loading) != null ? _b : null,
      wrapperProps: {
        "data-testid": e2eSelectors.selectors.components.ReactMonacoEditor.editorLazy
      }
    }
  );
};
const getStyles$1a = (theme) => {
  return {
    container: css.css({
      marginBottom: "unset",
      marginLeft: theme.spacing(1)
    })
  };
};

var CodeEditorSuggestionItemKind = /* @__PURE__ */ ((CodeEditorSuggestionItemKind2) => {
  CodeEditorSuggestionItemKind2["Method"] = "method";
  CodeEditorSuggestionItemKind2["Field"] = "field";
  CodeEditorSuggestionItemKind2["Property"] = "property";
  CodeEditorSuggestionItemKind2["Constant"] = "constant";
  CodeEditorSuggestionItemKind2["Text"] = "text";
  return CodeEditorSuggestionItemKind2;
})(CodeEditorSuggestionItemKind || {});

function findInsertIndex(line) {
  for (let i = line.length - 1; i > 0; i--) {
    const ch = line.charAt(i);
    if (ch === "$") {
      return {
        index: i,
        prefix: line.substring(i)
      };
    }
    if (ch === " " || ch === "	" || ch === '"' || ch === "'") {
      return {
        index: i + 1,
        prefix: line.substring(i + 1)
      };
    }
  }
  return {
    index: 0,
    prefix: line
  };
}
function getCompletionItems(monaco, prefix, suggestions, range) {
  var _a;
  const items = [];
  for (const suggestion of suggestions) {
    if (prefix && !suggestion.label.startsWith(prefix)) {
      continue;
    }
    items.push({
      ...suggestion,
      kind: mapKinds(monaco, suggestion.kind),
      range,
      insertText: (_a = suggestion.insertText) != null ? _a : suggestion.label
    });
  }
  return items;
}
function mapKinds(monaco, sug) {
  switch (sug) {
    case CodeEditorSuggestionItemKind.Method:
      return monaco.languages.CompletionItemKind.Method;
    case CodeEditorSuggestionItemKind.Field:
      return monaco.languages.CompletionItemKind.Field;
    case CodeEditorSuggestionItemKind.Property:
      return monaco.languages.CompletionItemKind.Property;
    case CodeEditorSuggestionItemKind.Constant:
      return monaco.languages.CompletionItemKind.Constant;
    case CodeEditorSuggestionItemKind.Text:
      return monaco.languages.CompletionItemKind.Text;
  }
  return monaco.languages.CompletionItemKind.Text;
}
function registerSuggestions(monaco, language, getSuggestions, modelId) {
  if (!language || !getSuggestions) {
    return void 0;
  }
  return monaco.languages.registerCompletionItemProvider(language, {
    triggerCharacters: ["$"],
    provideCompletionItems: (model, position, context) => {
      if (model.id !== modelId) {
        return void 0;
      }
      const range = {
        startLineNumber: position.lineNumber,
        endLineNumber: position.lineNumber,
        startColumn: position.column,
        endColumn: position.column
      };
      if (context.triggerCharacter === "$") {
        range.startColumn = position.column - 1;
        return {
          suggestions: getCompletionItems(monaco, "$", getSuggestions(), range)
        };
      }
      const currentLine = model.getValueInRange({
        startLineNumber: position.lineNumber,
        startColumn: 1,
        endLineNumber: position.lineNumber,
        endColumn: position.column
      });
      const { index, prefix } = findInsertIndex(currentLine);
      range.startColumn = index + 1;
      const suggestions = getCompletionItems(monaco, prefix, getSuggestions(), range);
      if (suggestions.length) {
        return { suggestions };
      }
      return void 0;
    }
  });
}

class UnthemedCodeEditor extends React.PureComponent {
  constructor(props) {
    super(props);
    this.loadCustomLanguage = () => {
      const { language } = this.props;
      const customLanguage = data.monacoLanguageRegistry.getIfExists(language);
      if (customLanguage) {
        return customLanguage.init();
      }
      return Promise.resolve();
    };
    // This is replaced with a real function when the actual editor mounts
    this.getEditorValue = () => "";
    this.onBlur = () => {
      const { onBlur } = this.props;
      if (onBlur) {
        onBlur(this.getEditorValue());
      }
    };
    this.onFocus = () => {
      const { onFocus } = this.props;
      if (onFocus) {
        onFocus(this.getEditorValue());
      }
    };
    this.onSave = () => {
      const { onSave } = this.props;
      if (onSave) {
        onSave(this.getEditorValue());
      }
    };
    this.handleBeforeMount = (monaco) => {
      this.monaco = monaco;
      const { onBeforeEditorMount } = this.props;
      onBeforeEditorMount == null ? void 0 : onBeforeEditorMount(monaco);
    };
    this.handleOnMount = (editor, monaco) => {
      var _a, _b;
      const { getSuggestions, language, onChange, onEditorDidMount } = this.props;
      this.modelId = (_a = editor.getModel()) == null ? void 0 : _a.id;
      this.getEditorValue = () => editor.getValue();
      if (getSuggestions && this.modelId) {
        this.completionCancel = registerSuggestions(monaco, language, getSuggestions, this.modelId);
      }
      editor.onKeyDown((e) => {
        if (e.keyCode === monaco.KeyCode.KeyS && (e.ctrlKey || e.metaKey)) {
          e.preventDefault();
          this.onSave();
        }
      });
      if (onChange) {
        (_b = editor.getModel()) == null ? void 0 : _b.onDidChangeContent(() => onChange(editor.getValue()));
      }
      if (onEditorDidMount) {
        onEditorDidMount(editor, monaco);
      }
    };
  }
  componentWillUnmount() {
    var _a, _b;
    if (this.completionCancel) {
      this.completionCancel.dispose();
    }
    (_b = (_a = this.props).onEditorWillUnmount) == null ? void 0 : _b.call(_a);
  }
  componentDidUpdate(oldProps) {
    const { getSuggestions, language } = this.props;
    const newLanguage = oldProps.language !== language;
    const newGetSuggestions = oldProps.getSuggestions !== getSuggestions;
    if (newGetSuggestions || newLanguage) {
      if (this.completionCancel) {
        this.completionCancel.dispose();
      }
      if (!this.monaco) {
        console.warn("Monaco instance not loaded yet");
        return;
      }
      if (getSuggestions && this.modelId) {
        this.completionCancel = registerSuggestions(this.monaco, language, getSuggestions, this.modelId);
      }
    }
    if (newLanguage) {
      this.loadCustomLanguage();
    }
  }
  render() {
    var _a, _b;
    const { theme, language, width, height, showMiniMap, showLineNumbers, readOnly, wordWrap, monacoOptions } = this.props;
    const { alwaysConsumeMouseWheel, ...restMonacoOptions } = monacoOptions != null ? monacoOptions : {};
    const value = (_a = this.props.value) != null ? _a : "";
    const longText = value.length > 100;
    const containerStyles = (_b = this.props.containerStyles) != null ? _b : getStyles$19(theme).container;
    const options = {
      wordWrap: wordWrap ? "on" : "off",
      tabSize: 2,
      codeLens: false,
      contextmenu: false,
      minimap: {
        enabled: longText && showMiniMap,
        renderCharacters: false
      },
      readOnly,
      lineNumbersMinChars: 4,
      lineDecorationsWidth: 1 * theme.spacing.gridSize,
      overviewRulerBorder: false,
      automaticLayout: true,
      padding: {
        top: 0.5 * theme.spacing.gridSize,
        bottom: 0.5 * theme.spacing.gridSize
      },
      fixedOverflowWidgets: true,
      // Ensures suggestions menu is drawn on top
      scrollbar: {
        alwaysConsumeMouseWheel: alwaysConsumeMouseWheel != null ? alwaysConsumeMouseWheel : false
      }
    };
    if (!showLineNumbers) {
      options.glyphMargin = false;
      options.folding = false;
      options.lineNumbers = "off";
      options.lineNumbersMinChars = 0;
    }
    return /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: containerStyles,
        onFocus: this.onFocus,
        onBlur: this.onBlur,
        "data-testid": e2eSelectors.selectors.components.CodeEditor.container,
        children: /* @__PURE__ */ jsxRuntime.jsx(
          ReactMonacoEditorLazy,
          {
            width,
            height,
            language,
            value,
            options: {
              ...options,
              ...restMonacoOptions != null ? restMonacoOptions : {}
            },
            beforeMount: this.handleBeforeMount,
            onMount: this.handleOnMount,
            keepCurrentModel: true
          }
        )
      }
    );
  }
}
const CodeEditor = withTheme2(UnthemedCodeEditor);
const getStyles$19 = (theme) => {
  return {
    container: css.css({
      borderRadius: theme.shape.radius.default,
      border: `1px solid ${theme.components.input.borderColor}`
    })
  };
};

const Counter = ({ value }) => {
  const styles = useStyles2(getStyles$18);
  return /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.counter, children: data.locale(value, 0).text });
};
const getStyles$18 = (theme) => ({
  counter: css.css({
    label: "counter",
    marginLeft: theme.spacing(1),
    borderRadius: theme.spacing(3),
    backgroundColor: theme.colors.action.hover,
    padding: theme.spacing(0.25, 1),
    color: theme.colors.text.secondary,
    fontWeight: theme.typography.fontWeightMedium,
    fontSize: theme.typography.size.sm
  })
});

const Tab = React__namespace.forwardRef(
  ({ label, active, icon, onChangeTab, counter, suffix: Suffix, className, href, truncate, tooltip, ...otherProps }, ref) => {
    const tabsStyles = useStyles2(getStyles$17);
    const clearStyles = useStyles2(clearButtonStyles);
    const content = () => /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon }),
      label,
      typeof counter === "number" && /* @__PURE__ */ jsxRuntime.jsx(Counter, { value: counter }),
      Suffix && /* @__PURE__ */ jsxRuntime.jsx(Suffix, { className: tabsStyles.suffix })
    ] });
    const linkClass = css.cx(
      clearStyles,
      tabsStyles.link,
      active ? tabsStyles.activeStyle : tabsStyles.notActive,
      truncate && tabsStyles.linkTruncate
    );
    const commonProps = {
      className: linkClass,
      "data-testid": e2eSelectors.selectors.components.Tab.title(label),
      ...otherProps,
      onClick: onChangeTab,
      role: "tab",
      "aria-selected": active,
      title: !!tooltip ? void 0 : otherProps.title
      // If tooltip is provided, don't set the title on the link or button, it looks weird
    };
    let tab = null;
    if (href) {
      tab = /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(tabsStyles.item, truncate && tabsStyles.itemTruncate, className), children: /* @__PURE__ */ jsxRuntime.jsx(
        "a",
        {
          ...commonProps,
          href,
          ref,
          children: content()
        }
      ) });
    } else {
      tab = /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(tabsStyles.item, truncate && tabsStyles.itemTruncate, className), children: /* @__PURE__ */ jsxRuntime.jsx(
        "button",
        {
          ...commonProps,
          type: "button",
          ref,
          children: content()
        }
      ) });
    }
    if (tooltip) {
      return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { content: tooltip, children: tab });
    }
    return tab;
  }
);
Tab.displayName = "Tab";
const getStyles$17 = (theme) => {
  return {
    item: css.css({
      listStyle: "none",
      position: "relative",
      display: "flex",
      whiteSpace: "nowrap",
      padding: theme.spacing(0, 0.5)
    }),
    itemTruncate: css.css({
      maxWidth: theme.spacing(40)
    }),
    link: css.css({
      color: theme.colors.text.secondary,
      padding: theme.spacing(1, 1.5, 1),
      borderRadius: theme.shape.radius.default,
      display: "block",
      height: "100%",
      svg: {
        marginRight: theme.spacing(1)
      },
      "&:focus-visible": getFocusStyles(theme),
      "&::before": {
        display: "block",
        content: '" "',
        position: "absolute",
        left: 0,
        right: 0,
        height: "2px",
        borderRadius: theme.shape.radius.default,
        bottom: 0
      }
    }),
    linkTruncate: css.css({
      textOverflow: "ellipsis",
      whiteSpace: "nowrap",
      wordBreak: "break-word",
      overflow: "hidden"
    }),
    notActive: css.css({
      "a:hover, &:hover, &:focus": {
        color: theme.colors.text.primary,
        "&::before": {
          backgroundColor: theme.colors.action.hover
        }
      }
    }),
    activeStyle: css.css({
      label: "activeTabStyle",
      color: theme.colors.text.primary,
      overflow: "hidden",
      "&::before": {
        backgroundImage: theme.colors.gradients.brandHorizontal
      }
    }),
    suffix: css.css({
      marginLeft: theme.spacing(1)
    })
  };
};

const TabsBar = React.forwardRef(({ children, className, hideBorder = false }, ref) => {
  const styles = useStyles2(getStyles$16);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.tabsWrapper, hideBorder && styles.noBorder, className), ref, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.tabs, role: "tablist", children }) });
});
const getStyles$16 = (theme) => ({
  tabsWrapper: css.css({
    borderBottom: `1px solid ${theme.colors.border.weak}`,
    overflowX: "auto"
  }),
  noBorder: css.css({
    borderBottom: 0
  }),
  tabs: css.css({
    position: "relative",
    display: "flex",
    alignItems: "center"
  })
});
TabsBar.displayName = "TabsBar";

var TableCellInspectorMode = /* @__PURE__ */ ((TableCellInspectorMode2) => {
  TableCellInspectorMode2["code"] = "code";
  TableCellInspectorMode2["text"] = "text";
  return TableCellInspectorMode2;
})(TableCellInspectorMode || {});
function TableCellInspector({ value, onDismiss, mode }) {
  let displayValue = value;
  const [currentMode, setMode] = React.useState(mode);
  if (lodash.isString(value)) {
    const trimmedValue = value.trim();
    if (trimmedValue[0] === "{" || trimmedValue[0] === "[" || mode === "code") {
      try {
        value = JSON.parse(value);
        displayValue = JSON.stringify(value, null, "  ");
      } catch (error) {
        console.log(
          "Failed to parse JSON in Table cell inspector (this will cause JSON to not print nicely): ",
          error.message
        );
      }
    }
  } else {
    displayValue = JSON.stringify(value);
  }
  let text = displayValue;
  const tabs = [
    {
      label: "Plain text",
      value: "text"
    },
    {
      label: "Code editor",
      value: "code"
    }
  ];
  const changeTabs = () => {
    setMode(currentMode === "text" /* text */ ? "code" /* code */ : "text" /* text */);
  };
  const tabBar = /* @__PURE__ */ jsxRuntime.jsx(TabsBar, { children: tabs.map((t2, index) => /* @__PURE__ */ jsxRuntime.jsx(Tab, { label: t2.label, active: t2.value === currentMode, onChangeTab: changeTabs }, `${t2.value}-${index}`)) });
  return /* @__PURE__ */ jsxRuntime.jsx(Drawer, { onClose: onDismiss, title: t("grafana-ui.table.inspect-drawer-title", "Inspect value"), tabs: tabBar, children: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", gap: 2, children: [
    /* @__PURE__ */ jsxRuntime.jsx(ClipboardButton, { icon: "copy", getText: () => text, style: { marginLeft: "auto", width: "200px" }, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.copy", children: "Copy to Clipboard" }) }),
    currentMode === "code" ? /* @__PURE__ */ jsxRuntime.jsx(
      CodeEditor,
      {
        width: "100%",
        height: 500,
        language: "json",
        showLineNumbers: true,
        showMiniMap: (text && text.length) > 100,
        value: text,
        readOnly: true,
        wordWrap: true
      }
    ) : /* @__PURE__ */ jsxRuntime.jsx("pre", { children: text })
  ] }) });
}

function Popover({
  content,
  show,
  placement,
  className,
  wrapperClassName,
  referenceElement,
  renderArrow,
  hidePopper,
  ...rest
}) {
  const theme = useTheme2();
  const arrowRef = React.useRef(null);
  const middleware = [
    react.offset(8),
    react.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react.shift()
  ];
  if (renderArrow) {
    middleware.push(
      react.arrow({
        element: arrowRef
      })
    );
  }
  const { context, refs, floatingStyles } = react.useFloating({
    open: show,
    placement: getPlacement(placement),
    middleware,
    whileElementsMounted: react.autoUpdate,
    strategy: "fixed"
  });
  React.useLayoutEffect(() => {
    refs.setReference(referenceElement);
  }, [referenceElement, refs]);
  const { styles: placementStyles } = react.useTransitionStyles(context, {
    initial: () => ({
      opacity: 0
    }),
    duration: theme.transitions.duration.enteringScreen
  });
  return show ? /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      ref: refs.setFloating,
      style: {
        ...floatingStyles,
        ...placementStyles
      },
      className: wrapperClassName,
      ...rest,
      children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className, children: [
        renderArrow && /* @__PURE__ */ jsxRuntime.jsx(react.FloatingArrow, { fill: theme.colors.border.weak, ref: arrowRef, context }),
        typeof content === "string" && content,
        React__namespace.isValidElement(content) && React__namespace.cloneElement(content),
        typeof content === "function" && content({ hidePopper })
      ] })
    }
  ) }) : void 0;
}

let Input$1 = class Input extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      error: null
    };
    this.validatorAsync = (validationRules) => {
      return (evt) => {
        const errors = validate(evt.target.value, validationRules);
        this.setState((prevState) => {
          return { ...prevState, error: errors ? errors[0] : null };
        });
      };
    };
    this.populateEventPropsWithStatus = (restProps, validationEvents) => {
      const inputElementProps = { ...restProps };
      if (!validationEvents) {
        return inputElementProps;
      }
      Object.keys(EventsWithValidation).forEach((eventName) => {
        if (hasValidationEvent(eventName, validationEvents) || restProps[eventName]) {
          inputElementProps[eventName] = async (evt) => {
            evt.persist();
            if (hasValidationEvent(eventName, validationEvents)) {
              await this.validatorAsync(validationEvents[eventName]).apply(this, [evt]);
            }
            if (restProps[eventName]) {
              restProps[eventName].apply(null, [evt, this.status]);
            }
          };
        }
      });
      return inputElementProps;
    };
  }
  get status() {
    return this.state.error ? "invalid" /* Invalid */ : "valid" /* Valid */;
  }
  get isInvalid() {
    return this.status === "invalid" /* Invalid */;
  }
  render() {
    const { validationEvents, className, hideErrorMessage, inputRef, ...restProps } = this.props;
    const { error } = this.state;
    const inputClassName = classNames__default.default("gf-form-input", { invalid: this.isInvalid }, className);
    const inputElementProps = this.populateEventPropsWithStatus(restProps, validationEvents);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: { flexGrow: 1 }, children: [
      /* @__PURE__ */ jsxRuntime.jsx("input", { ...inputElementProps, ref: inputRef, className: inputClassName }),
      error && !hideErrorMessage && /* @__PURE__ */ jsxRuntime.jsx("span", { children: error })
    ] });
  }
};
Input$1.defaultProps = {
  className: ""
};

const IndicatorsContainer$1 = (props) => {
  const isOpen = props.selectProps.menuIsOpen;
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.IndicatorsContainer, { ...props, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: isOpen ? "angle-up" : "angle-down", style: { marginTop: "7px" } }) });
};

const NoOptionsMessage = (props) => {
  const { children } = props;
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.NoOptionsMessage, { ...props, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-select-box__desc-option", children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-select-box__desc-option__body", children }) }) });
};

function useDelayedSwitch(value, options = {}) {
  const { duration = 250, delay = 250 } = options;
  const [delayedValue, setDelayedValue] = React.useState(value);
  const onStartTime = React.useRef();
  React.useEffect(() => {
    let timeout;
    if (value) {
      timeout = setTimeout(() => {
        onStartTime.current = /* @__PURE__ */ new Date();
        setDelayedValue(value);
      }, delay);
    } else {
      const timeSpent = onStartTime.current ? Date.now() - onStartTime.current.valueOf() : 0;
      const turnOff = () => {
        onStartTime.current = void 0;
        setDelayedValue(value);
      };
      if (timeSpent >= duration) {
        turnOff();
      } else {
        timeout = setTimeout(turnOff, duration - timeSpent);
      }
    }
    return () => {
      if (timeout) {
        clearTimeout(timeout);
        timeout = void 0;
      }
    };
  }, [value, duration, delay]);
  return delayedValue;
}

function FadeTransition(props) {
  const { visible, children, duration = 250 } = props;
  const styles = useStyles2(getStyles$15, duration);
  const transitionRef = React.useRef(null);
  return /* @__PURE__ */ jsxRuntime.jsx(
    reactTransitionGroup.CSSTransition,
    {
      in: visible,
      mountOnEnter: true,
      unmountOnExit: true,
      timeout: duration,
      classNames: styles,
      nodeRef: transitionRef,
      children: React__namespace.cloneElement(children, { ref: transitionRef })
    }
  );
}
const getStyles$15 = (theme, duration) => ({
  enter: css.css({
    label: "enter",
    opacity: 0
  }),
  enterActive: css.css({
    label: "enterActive",
    opacity: 1,
    [theme.transitions.handleMotion("no-preference", "reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  }),
  exit: css.css({
    label: "exit",
    opacity: 1
  }),
  exitActive: css.css({
    label: "exitActive",
    opacity: 0,
    [theme.transitions.handleMotion("no-preference", "reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  })
});

function SlideOutTransition(props) {
  const { visible, children, duration = 250, horizontal, size } = props;
  const styles = useStyles2(getStyles$14, duration, horizontal ? "width" : "height", size);
  const transitionRef = React.useRef(null);
  return /* @__PURE__ */ jsxRuntime.jsx(
    reactTransitionGroup.CSSTransition,
    {
      in: visible,
      mountOnEnter: true,
      unmountOnExit: true,
      timeout: duration,
      classNames: styles,
      nodeRef: transitionRef,
      children: React__namespace.cloneElement(children, { ref: transitionRef })
    }
  );
}
const getStyles$14 = (theme, duration, measurement, size) => ({
  enter: css.css({
    label: "enter",
    [`${measurement}`]: 0,
    opacity: 0
  }),
  enterActive: css.css({
    label: "enterActive",
    [`${measurement}`]: `${size}px`,
    opacity: 1,
    [theme.transitions.handleMotion("no-preference")]: {
      transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
    },
    [theme.transitions.handleMotion("reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  }),
  exit: css.css({
    label: "exit",
    [`${measurement}`]: `${size}px`,
    opacity: 1
  }),
  exitActive: css.css({
    label: "exitActive",
    opacity: 0,
    [`${measurement}`]: 0,
    [theme.transitions.handleMotion("no-preference")]: {
      transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
    },
    [theme.transitions.handleMotion("reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  })
});

const getStyles$13 = (theme) => {
  return {
    singleValue: css.css({
      label: "singleValue",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      boxSizing: "border-box",
      maxWidth: "100%",
      gridArea: "1 / 1 / 2 / 3"
    }),
    spinnerWrapper: css.css({
      width: "16px",
      height: "16px",
      display: "inline-block",
      marginRight: "10px",
      position: "relative",
      verticalAlign: "middle",
      overflow: "hidden"
    }),
    spinnerIcon: css.css({
      width: "100%",
      height: "100%",
      position: "absolute"
    }),
    optionIcon: css.css({
      marginRight: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    disabled: css.css({
      color: theme.colors.text.disabled
    }),
    isOpen: css.css({
      color: theme.colors.text.disabled
    })
  };
};
const SingleValue = (props) => {
  var _a;
  const { children, data: data$1, isDisabled } = props;
  const styles = useStyles2(getStyles$13);
  const loading = useDelayedSwitch(data$1.loading || false, { delay: 250, duration: 750 });
  const icon = data$1.icon ? data.toIconName(data$1.icon) : void 0;
  return /* @__PURE__ */ jsxRuntime.jsxs(
    ReactSelect.components.SingleValue,
    {
      ...props,
      className: css.cx(styles.singleValue, isDisabled && styles.disabled, props.selectProps.menuIsOpen && styles.isOpen),
      children: [
        data$1.imgUrl ? /* @__PURE__ */ jsxRuntime.jsx(FadeWithImage, { loading, imgUrl: data$1.imgUrl, styles, alt: String((_a = data$1.label) != null ? _a : data$1.value) }) : /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          /* @__PURE__ */ jsxRuntime.jsx(SlideOutTransition, { horizontal: true, size: 16, visible: loading, duration: 150, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.spinnerWrapper, children: /* @__PURE__ */ jsxRuntime.jsx(Spinner, { className: styles.spinnerIcon, inline: true }) }) }),
          icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, role: "img", className: styles.optionIcon })
        ] }),
        !data$1.hideText && children
      ]
    }
  );
};
const FadeWithImage = (props) => {
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: props.styles.spinnerWrapper, children: [
    /* @__PURE__ */ jsxRuntime.jsx(FadeTransition, { duration: 150, visible: props.loading, children: /* @__PURE__ */ jsxRuntime.jsx(Spinner, { className: props.styles.spinnerIcon, inline: true }) }),
    /* @__PURE__ */ jsxRuntime.jsx(FadeTransition, { duration: 150, visible: !props.loading, children: /* @__PURE__ */ jsxRuntime.jsx("img", { className: props.styles.spinnerIcon, src: props.imgUrl, alt: props.alt }) })
  ] });
};

function resetSelectStyles(theme) {
  return {
    clearIndicator: () => ({}),
    container: () => ({}),
    control: () => ({}),
    dropdownIndicator: () => ({}),
    group: () => ({}),
    groupHeading: () => ({}),
    indicatorsContainer: () => ({}),
    indicatorSeparator: () => ({}),
    input: function(originalStyles) {
      return {
        ...originalStyles,
        color: "inherit",
        margin: 0,
        padding: 0,
        // Set an explicit z-index here to ensure this element always overlays the singleValue
        zIndex: 1,
        overflow: "hidden"
      };
    },
    loadingIndicator: () => ({}),
    loadingMessage: () => ({}),
    menu: () => ({}),
    menuList: ({ maxHeight }) => ({
      maxHeight
    }),
    multiValue: () => ({}),
    multiValueLabel: () => ({
      overflow: "hidden",
      textOverflow: "ellipsis"
    }),
    multiValueRemove: () => ({}),
    noOptionsMessage: () => ({}),
    option: () => ({}),
    placeholder: (originalStyles) => ({
      ...originalStyles,
      color: theme.colors.text.secondary
    }),
    singleValue: () => ({}),
    valueContainer: () => ({})
  };
}
function useCustomSelectStyles(theme, width) {
  return React.useMemo(() => {
    return {
      ...resetSelectStyles(theme),
      menuPortal: (base) => {
        return {
          ...base,
          zIndex: theme.zIndex.portal
        };
      },
      //These are required for the menu positioning to function
      menu: ({ top, bottom, position }) => {
        return {
          top,
          bottom,
          position,
          minWidth: "100%",
          zIndex: theme.zIndex.dropdown
        };
      },
      container: () => ({
        width: width ? theme.spacing(width) : "100%",
        display: width === "auto" ? "inline-flex" : "flex"
      }),
      option: (provided, state) => ({
        ...provided,
        opacity: state.isDisabled ? 0.5 : 1
      })
    };
  }, [theme, width]);
}

const SelectOption = (props) => {
  const { children, isSelected, data } = props;
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.Option, { ...props, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "gf-form-select-box__desc-option", children: [
    data.imgUrl && /* @__PURE__ */ jsxRuntime.jsx("img", { className: "gf-form-select-box__desc-option__img", src: data.imgUrl, alt: "" }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "gf-form-select-box__desc-option__body", children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { children }),
      data.description && /* @__PURE__ */ jsxRuntime.jsx("div", { className: "gf-form-select-box__desc-option__desc", children: data.description })
    ] }),
    isSelected && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "check", "aria-hidden": "true" })
  ] }) });
};

const getSelectOptionGroupStyles = stylesFactory((theme) => {
  return {
    header: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "flex-start",
      justifyItems: "center",
      cursor: "pointer",
      padding: "7px 10px",
      width: "100%",
      borderBottom: `1px solid ${theme.colors.background.secondary}`,
      "&:hover": {
        color: theme.colors.text.maxContrast
      }
    }),
    label: css.css({
      flexGrow: 1
    }),
    icon: css.css({
      paddingRight: "2px"
    })
  };
});
class UnthemedSelectOptionGroup extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      expanded: false
    };
    this.onToggleChildren = () => {
      this.setState((prevState) => ({
        expanded: !prevState.expanded
      }));
    };
  }
  componentDidMount() {
    if (this.props.data.expanded) {
      this.setState({ expanded: true });
    } else if (this.props.selectProps && this.props.selectProps.value) {
      const { value } = this.props.selectProps.value;
      if (value && this.props.options.some((option) => option.value === value)) {
        this.setState({ expanded: true });
      }
    }
  }
  componentDidUpdate(nextProps) {
    if (nextProps.selectProps.inputValue !== "") {
      this.setState({ expanded: true });
    }
  }
  render() {
    const { children, label, theme } = this.props;
    const { expanded } = this.state;
    const styles = getSelectOptionGroupStyles(theme);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.header, onClick: this.onToggleChildren, role: "presentation", children: [
        /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.label, children: label }),
        /* @__PURE__ */ jsxRuntime.jsx(Icon, { className: styles.icon, name: expanded ? "angle-up" : "angle-down" })
      ] }),
      expanded && children
    ] });
  }
}
const SelectOptionGroup$1 = withTheme2(UnthemedSelectOptionGroup);

const MenuList = (props) => {
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.MenuList, { ...props, children: /* @__PURE__ */ jsxRuntime.jsx(ScrollContainer, { showScrollIndicators: true, overflowX: "hidden", maxHeight: "inherit", children: props.children }) });
};
const _Select = class _Select extends React.PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      options,
      placeholder,
      width,
      value,
      className,
      isDisabled,
      isLoading,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      isMulti,
      autoFocus,
      openMenuOnFocus,
      onBlur,
      maxMenuHeight,
      noOptionsMessage,
      isOpen,
      components: components2,
      tooltipContent,
      tabSelectsValue,
      onCloseMenu,
      onOpenMenu,
      allowCustomValue,
      formatCreateLabel,
      "aria-label": ariaLabel
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    let SelectComponent = ReactSelect__default.default;
    const creatableOptions = {};
    if (allowCustomValue) {
      SelectComponent = Creatable__default.default;
      creatableOptions.formatCreateLabel = formatCreateLabel != null ? formatCreateLabel : (input) => input;
    }
    const selectClassNames = classNames__default.default("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    const selectComponents = { ..._Select.defaultProps.components, ...components2 };
    return /* @__PURE__ */ jsxRuntime.jsx(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen, children: (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ jsxRuntime.jsx(
        SelectComponent,
        {
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: selectComponents,
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          isSearchable,
          onChange,
          options,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          isDisabled,
          isLoading,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          noOptionsMessage,
          isMulti,
          backspaceRemovesValue,
          menuIsOpen: isOpen,
          onMenuOpen: onOpenMenuInternal,
          onMenuClose: onCloseMenuInternal,
          tabSelectsValue,
          "aria-label": ariaLabel,
          ...creatableOptions
        }
      );
    } });
  }
};
_Select.contextType = data.ThemeContext;
_Select.defaultProps = {
  className: "",
  isDisabled: false,
  isSearchable: true,
  isClearable: false,
  isMulti: false,
  openMenuOnFocus: false,
  autoFocus: false,
  isLoading: false,
  backspaceRemovesValue: true,
  maxMenuHeight: 300,
  tabSelectsValue: true,
  allowCustomValue: false,
  components: {
    Option: SelectOption,
    SingleValue,
    IndicatorsContainer: IndicatorsContainer$1,
    MenuList,
    Group: SelectOptionGroup$1
  }
};
class AsyncSelect extends React.PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      placeholder,
      width,
      value,
      className,
      loadOptions,
      defaultOptions,
      isLoading,
      loadingMessage,
      noOptionsMessage,
      isDisabled,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      autoFocus,
      onBlur,
      openMenuOnFocus,
      maxMenuHeight,
      isMulti,
      tooltipContent,
      onCloseMenu,
      onOpenMenu,
      isOpen
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    const selectClassNames = classNames__default.default("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    return /* @__PURE__ */ jsxRuntime.jsx(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen, children: (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ jsxRuntime.jsx(
        ReactAsyncSelect__default.default,
        {
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: {
            Option: SelectOption,
            SingleValue,
            IndicatorsContainer: IndicatorsContainer$1,
            NoOptionsMessage
          },
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          onChange,
          loadOptions,
          isLoading,
          defaultOptions,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          loadingMessage,
          noOptionsMessage,
          isDisabled,
          isSearchable,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          isMulti,
          backspaceRemovesValue
        }
      );
    } });
  }
}
AsyncSelect.contextType = data.ThemeContext;
AsyncSelect.defaultProps = {
  className: "",
  components: {},
  loadingMessage: () => "Loading...",
  isDisabled: false,
  isClearable: false,
  isMulti: false,
  isSearchable: true,
  backspaceRemovesValue: true,
  autoFocus: false,
  openMenuOnFocus: false,
  maxMenuHeight: 300
};
class WrapInTooltip extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      isOpenInternal: false
    };
    this.onOpenMenu = () => {
      const { onOpenMenu } = this.props;
      if (onOpenMenu) {
        onOpenMenu();
      }
      this.setState({ isOpenInternal: true });
    };
    this.onCloseMenu = () => {
      const { onCloseMenu } = this.props;
      if (onCloseMenu) {
        onCloseMenu();
      }
      this.setState({ isOpenInternal: false });
    };
  }
  render() {
    const { children, isOpen, tooltipContent } = this.props;
    const { isOpenInternal } = this.state;
    let showTooltip = void 0;
    if (isOpenInternal || isOpen) {
      showTooltip = false;
    }
    if (tooltipContent) {
      return /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { show: showTooltip, content: tooltipContent, placement: "bottom", children: /* @__PURE__ */ jsxRuntime.jsx("div", { children: children(this.onOpenMenu, this.onCloseMenu) }) });
    } else {
      return /* @__PURE__ */ jsxRuntime.jsx("div", { children: children(this.onOpenMenu, this.onCloseMenu) });
    }
  }
}

class UnthemedSwitch extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      id: lodash.uniqueId()
    };
    this.internalOnChange = (event) => {
      event.stopPropagation();
      this.props.onChange(event);
    };
  }
  render() {
    const {
      labelClass = "",
      switchClass = "",
      label,
      checked,
      disabled,
      transparent,
      className,
      theme,
      tooltip,
      tooltipPlacement
    } = this.props;
    const styles = getStyles$12(theme);
    const labelId = this.state.id;
    const labelClassName = `gf-form-label ${labelClass} ${transparent ? "gf-form-label--transparent" : ""} pointer`;
    const switchClassName = css.cx(styles.switch, switchClass, {
      [styles.switchTransparent]: transparent
    });
    return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.container, children: /* @__PURE__ */ jsxRuntime.jsxs("label", { htmlFor: labelId, className: css.cx("gf-form", styles.labelContainer, className), children: [
      label && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: labelClassName, children: [
        label,
        tooltip && /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { placement: tooltipPlacement ? tooltipPlacement : "auto", content: tooltip, theme: "info", children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "info-circle", size: "sm", style: { marginLeft: "10px" } }) })
      ] }),
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: switchClassName, children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          "input",
          {
            disabled,
            id: labelId,
            type: "checkbox",
            checked,
            onChange: this.internalOnChange
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.slider })
      ] })
    ] }) });
  }
}
withTheme2(UnthemedSwitch);
const getStyles$12 = (theme) => {
  const slider = css.css({
    background: theme.v1.palette.gray1,
    borderRadius: theme.shape.radius.pill,
    height: "16px",
    width: "32px",
    display: "block",
    position: "relative",
    "&::before": {
      position: "absolute",
      content: "''",
      height: "12px",
      width: "12px",
      left: "2px",
      top: "2px",
      background: theme.components.input.background,
      transition: "0.4s",
      borderRadius: theme.shape.radius.circle,
      boxShadow: theme.shadows.z1
    }
  });
  return {
    container: css.css({
      display: "flex",
      flexShrink: 0
    }),
    labelContainer: css.css({
      display: "flex",
      cursor: "pointer",
      marginRight: theme.spacing(0.5)
    }),
    switch: css.css({
      display: "flex",
      position: "relative",
      width: "56px",
      height: theme.spacing(4),
      background: theme.components.input.background,
      border: `1px solid ${theme.components.input.borderColor}`,
      borderRadius: theme.shape.radius.default,
      alignItems: "center",
      justifyContent: "center",
      input: {
        opacity: 0,
        width: 0,
        height: 0
      },
      [`input:checked + .${slider}`]: {
        background: theme.colors.primary.main
      },
      [`input:checked + .${slider}::before`]: {
        transform: "translateX(16px)"
      }
    }),
    switchTransparent: css.css({
      background: "transparent",
      border: 0,
      width: "40px"
    }),
    slider
  };
};

const Toggletip = React.memo(
  ({
    children,
    theme = "info",
    placement = "auto",
    content,
    title,
    closeButton = true,
    onClose,
    footer,
    fitContent = false,
    onOpen,
    show
  }) => {
    const arrowRef = React.useRef(null);
    const grafanaTheme = useTheme2();
    const styles = useStyles2(getStyles$11);
    const style = styles[theme];
    const [controlledVisible, setControlledVisible] = React.useState(show);
    const isOpen = show != null ? show : controlledVisible;
    const middleware = [
      react.offset(8),
      react.flip({
        fallbackAxisSideDirection: "end",
        // see https://floating-ui.com/docs/flip#combining-with-shift
        crossAxis: false,
        boundary: document.body
      }),
      react.shift(),
      react.arrow({
        element: arrowRef
      })
    ];
    const { context, refs, floatingStyles } = react.useFloating({
      open: isOpen,
      placement: getPlacement(placement),
      onOpenChange: (open) => {
        if (show === void 0) {
          setControlledVisible(open);
        }
        if (!open) {
          onClose == null ? void 0 : onClose();
        } else {
          onOpen == null ? void 0 : onOpen();
        }
      },
      middleware,
      whileElementsMounted: react.autoUpdate,
      strategy: "fixed"
    });
    const click = react.useClick(context);
    const dismiss = react.useDismiss(context);
    const { getReferenceProps, getFloatingProps } = react.useInteractions([dismiss, click]);
    return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      React.cloneElement(children, {
        ref: refs.setReference,
        tabIndex: 0,
        "aria-expanded": isOpen,
        ...getReferenceProps()
      }),
      isOpen && /* @__PURE__ */ jsxRuntime.jsx(react.FloatingFocusManager, { context, modal: false, closeOnFocusOut: false, children: /* @__PURE__ */ jsxRuntime.jsxs(
        "div",
        {
          "data-testid": "toggletip-content",
          className: css.cx(style.container, {
            [styles.fitContent]: fitContent
          }),
          ref: refs.setFloating,
          style: floatingStyles,
          ...getFloatingProps(),
          children: [
            /* @__PURE__ */ jsxRuntime.jsx(
              react.FloatingArrow,
              {
                strokeWidth: 0.3,
                stroke: grafanaTheme.colors.border.weak,
                className: style.arrow,
                ref: arrowRef,
                context
              }
            ),
            Boolean(title) && /* @__PURE__ */ jsxRuntime.jsx("div", { className: style.header, children: title }),
            closeButton && /* @__PURE__ */ jsxRuntime.jsx("div", { className: style.headerClose, children: /* @__PURE__ */ jsxRuntime.jsx(
              IconButton,
              {
                "aria-label": t("grafana-ui.toggletip.close", "Close"),
                name: "times",
                "data-testid": "toggletip-header-close",
                onClick: () => {
                  setControlledVisible(false);
                  onClose == null ? void 0 : onClose();
                }
              }
            ) }),
            /* @__PURE__ */ jsxRuntime.jsxs("div", { className: style.body, children: [
              (typeof content === "string" || React.isValidElement(content)) && content,
              typeof content === "function" && content({})
            ] }),
            Boolean(footer) && /* @__PURE__ */ jsxRuntime.jsx("div", { className: style.footer, children: footer })
          ]
        }
      ) })
    ] });
  }
);
Toggletip.displayName = "Toggletip";
const getStyles$11 = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.colors.background.primary,
    theme.colors.border.weak,
    theme.components.tooltip.text,
    { topBottom: 2, rightLeft: 2 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 2, rightLeft: 2 }
  );
  return {
    info,
    error,
    fitContent: css.css({
      maxWidth: "fit-content"
    })
  };
};

const ScrollIndicators = ({ children }) => {
  const [showScrollTopIndicator, setShowTopScrollIndicator] = React.useState(false);
  const [showScrollBottomIndicator, setShowBottomScrollIndicator] = React.useState(false);
  const scrollTopMarker = React.useRef(null);
  const scrollBottomMarker = React.useRef(null);
  const styles = useStyles2(getStyles$10);
  React.useEffect(() => {
    const intersectionObserver = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.target === scrollTopMarker.current) {
          setShowTopScrollIndicator(!entry.isIntersecting);
        } else if (entry.target === scrollBottomMarker.current) {
          setShowBottomScrollIndicator(!entry.isIntersecting);
        }
      });
    });
    [scrollTopMarker, scrollBottomMarker].forEach((ref) => {
      if (ref.current) {
        intersectionObserver.observe(ref.current);
      }
    });
    return () => intersectionObserver.disconnect();
  }, []);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.cx(styles.scrollIndicator, styles.scrollTopIndicator, {
          [styles.scrollIndicatorVisible]: showScrollTopIndicator
        })
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.scrollContent, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { ref: scrollTopMarker }),
      children,
      /* @__PURE__ */ jsxRuntime.jsx("div", { ref: scrollBottomMarker })
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        className: css.cx(styles.scrollIndicator, styles.scrollBottomIndicator, {
          [styles.scrollIndicatorVisible]: showScrollBottomIndicator
        })
      }
    )
  ] });
};
const getStyles$10 = (theme) => {
  return {
    scrollContent: css.css({
      flex: 1,
      position: "relative"
    }),
    scrollIndicator: css.css({
      height: theme.spacing(6),
      left: 0,
      opacity: 0,
      pointerEvents: "none",
      position: "absolute",
      right: 0,
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: theme.transitions.create("opacity")
      },
      zIndex: 1
    }),
    scrollTopIndicator: css.css({
      background: `linear-gradient(0deg, transparent, ${theme.colors.background.canvas})`,
      top: 0
    }),
    scrollBottomIndicator: css.css({
      background: `linear-gradient(180deg, transparent, ${theme.colors.background.canvas})`,
      bottom: 0
    }),
    scrollIndicatorVisible: css.css({
      opacity: 1
    })
  };
};

const CustomScrollbar = ({
  autoHide = false,
  autoHideTimeout = 200,
  setScrollTop,
  className,
  testId,
  autoHeightMin = "0",
  autoHeightMax = "100%",
  hideTracksWhenNotNeeded = false,
  hideHorizontalTrack,
  hideVerticalTrack,
  scrollRefCallback,
  showScrollIndicators = false,
  updateAfterMountMs,
  scrollTop,
  onScroll,
  children,
  divId
}) => {
  const ref = React.useRef(null);
  const styles = useStyles2(getStyles$$);
  React.useEffect(() => {
    if (ref.current && scrollRefCallback) {
      scrollRefCallback(ref.current.view);
    }
  }, [ref, scrollRefCallback]);
  useScrollTop(ref.current, scrollTop);
  React.useEffect(() => {
    if (!updateAfterMountMs) {
      return;
    }
    setTimeout(() => {
      const scrollbar = ref.current;
      if (scrollbar == null ? void 0 : scrollbar.update) {
        scrollbar.update();
      }
    }, updateAfterMountMs);
  }, [updateAfterMountMs]);
  function renderTrack(className2, hideTrack, passedProps) {
    if (passedProps.style && hideTrack) {
      passedProps.style.display = "none";
    }
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ...passedProps, className: className2 });
  }
  const renderTrackHorizontal = React.useCallback(
    (passedProps) => {
      return renderTrack("track-horizontal", hideHorizontalTrack, passedProps);
    },
    [hideHorizontalTrack]
  );
  const renderTrackVertical = React.useCallback(
    (passedProps) => {
      return renderTrack("track-vertical", hideVerticalTrack, passedProps);
    },
    [hideVerticalTrack]
  );
  const renderThumbHorizontal = React.useCallback((passedProps) => {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ...passedProps, className: "thumb-horizontal" });
  }, []);
  const renderThumbVertical = React.useCallback((passedProps) => {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ...passedProps, className: "thumb-vertical" });
  }, []);
  const renderView = React.useCallback(
    (passedProps) => {
      if (passedProps.style && passedProps.style["WebkitOverflowScrolling"] === "touch") {
        passedProps.style["WebkitOverflowScrolling"] = "auto";
      }
      return /* @__PURE__ */ jsxRuntime.jsx("div", { ...passedProps, className: "scrollbar-view", id: divId });
    },
    [divId]
  );
  const onScrollStop = React.useCallback(() => {
    ref.current && setScrollTop && setScrollTop(ref.current.getValues());
  }, [setScrollTop]);
  return /* @__PURE__ */ jsxRuntime.jsx(
    Scrollbars__default.default,
    {
      "data-testid": testId,
      ref,
      className: css.cx(styles.customScrollbar, className, {
        [styles.scrollbarWithScrollIndicators]: showScrollIndicators
      }),
      onScrollStop,
      autoHeight: true,
      autoHide,
      autoHideTimeout,
      hideTracksWhenNotNeeded,
      autoHeightMax,
      autoHeightMin,
      renderTrackHorizontal,
      renderTrackVertical,
      renderThumbHorizontal,
      renderThumbVertical,
      renderView,
      onScroll,
      children: showScrollIndicators ? /* @__PURE__ */ jsxRuntime.jsx(ScrollIndicators, { children }) : children
    }
  );
};
const getStyles$$ = (theme) => {
  return {
    customScrollbar: css.css({
      // Fix for Firefox. For some reason sometimes .view container gets a height of its content, but in order to
      // make scroll working it should fit outer container size (scroll appears only when inner container size is
      // greater than outer one).
      display: "flex",
      flexGrow: 1,
      ".scrollbar-view": {
        display: "flex",
        flexGrow: 1,
        flexDirection: "column"
      },
      ".track-vertical": {
        borderRadius: theme.shape.borderRadius(2),
        width: `${theme.spacing(1)} !important`,
        right: 0,
        bottom: theme.spacing(0.25),
        top: theme.spacing(0.25)
      },
      ".track-horizontal": {
        borderRadius: theme.shape.borderRadius(2),
        height: `${theme.spacing(1)} !important`,
        right: theme.spacing(0.25),
        bottom: theme.spacing(0.25),
        left: theme.spacing(0.25)
      },
      ".thumb-vertical": {
        background: theme.colors.action.focus,
        borderRadius: theme.shape.borderRadius(2),
        opacity: 0
      },
      ".thumb-horizontal": {
        background: theme.colors.action.focus,
        borderRadius: theme.shape.borderRadius(2),
        opacity: 0
      },
      "&:hover": {
        ".thumb-vertical, .thumb-horizontal": {
          opacity: 1,
          transition: "opacity 0.3s ease-in-out"
        }
      }
    }),
    // override the scroll container position so that the scroll indicators
    // are positioned at the top and bottom correctly.
    // react-custom-scrollbars doesn't provide any way for us to hook in nicely,
    // so we have to override with !important. feelsbad.
    scrollbarWithScrollIndicators: css.css({
      ".scrollbar-view": {
        // Need type assertion here due to the use of !important
        // see https://github.com/frenic/csstype/issues/114#issuecomment-697201978
        // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
        position: "static !important"
      }
    })
  };
};
function useScrollTop(scrollBar, scrollTop) {
  React.useEffect(() => {
    if (scrollBar && scrollTop != null) {
      scrollBar.scrollTop(scrollTop);
    }
  }, [scrollTop, scrollBar]);
}

const AutoSizeInputContext = React__namespace.default.createContext(false);
AutoSizeInputContext.displayName = "AutoSizeInputContext";

const Input = React.forwardRef((props, ref) => {
  const {
    className,
    addonAfter,
    addonBefore,
    prefix,
    suffix: suffixProp,
    invalid,
    loading,
    width = 0,
    ...restProps
  } = props;
  const [prefixRef, prefixRect] = useMeasure__default.default();
  const [suffixRef, suffixRect] = useMeasure__default.default();
  const isInAutoSizeInput = React.useContext(AutoSizeInputContext);
  const accessoriesWidth = (prefixRect.width || 0) + (suffixRect.width || 0);
  const autoSizeWidth = isInAutoSizeInput && width ? width + accessoriesWidth / 8 : void 0;
  const theme = useTheme2();
  const styles = getInputStyles({ theme, invalid: !!invalid, width: autoSizeWidth ? void 0 : width });
  const suffix = suffixProp || loading && /* @__PURE__ */ jsxRuntime.jsx(Spinner, { inline: true });
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      className: css.cx(styles.wrapper, className),
      style: autoSizeWidth ? { width: theme.spacing(autoSizeWidth) } : void 0,
      "data-testid": "input-wrapper",
      children: [
        !!addonBefore && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.addon, children: addonBefore }),
        /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.inputWrapper, children: [
          prefix && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.prefix, ref: prefixRef, children: prefix }),
          /* @__PURE__ */ jsxRuntime.jsx(
            "input",
            {
              ref,
              className: styles.input,
              ...restProps,
              style: {
                paddingLeft: prefix ? prefixRect.width + 12 : void 0,
                paddingRight: suffix || loading ? suffixRect.width + 12 : void 0
              }
            }
          ),
          suffix && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.suffix, ref: suffixRef, children: suffix })
        ] }),
        !!addonAfter && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.addon, children: addonAfter })
      ]
    }
  );
});
Input.displayName = "Input";
const getInputStyles = stylesFactory(({ theme, invalid = false, width }) => {
  const prefixSuffixStaticWidth = "28px";
  const prefixSuffix = css.css({
    position: "absolute",
    top: 0,
    zIndex: 1,
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    flexGrow: 0,
    flexShrink: 0,
    fontSize: theme.typography.size.md,
    height: "100%",
    /* Min width specified for prefix/suffix classes used outside React component*/
    minWidth: prefixSuffixStaticWidth,
    color: theme.colors.text.secondary
  });
  return {
    // Wraps inputWrapper and addons
    wrapper: css.cx(
      css.css({
        label: "input-wrapper",
        display: "flex",
        width: width ? theme.spacing(width) : "100%",
        height: theme.spacing(theme.components.height.md),
        borderRadius: theme.shape.radius.default,
        "&:hover": {
          "> .prefix, .suffix, .input": {
            borderColor: invalid ? theme.colors.error.border : theme.colors.primary.border
          },
          // only show number buttons on hover
          "input[type='number']": {
            appearance: "textfield"
          },
          "input[type='number']::-webkit-inner-spin-button, input[type='number']::-webkit-outer-spin-button": {
            // Need type assertion here due to the use of !important
            // see https://github.com/frenic/csstype/issues/114#issuecomment-697201978
            // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
            WebkitAppearance: "inner-spin-button !important",
            opacity: 1
          }
        }
      })
    ),
    // Wraps input and prefix/suffix
    inputWrapper: css.css({
      label: "input-inputWrapper",
      position: "relative",
      flexGrow: 1,
      /* we want input to be above addons, especially for focused state */
      zIndex: 1,
      /* when input rendered with addon before only*/
      "&:not(:first-child):last-child": {
        "> input": {
          borderLeft: "none",
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      /* when input rendered with addon after only*/
      "&:first-child:not(:last-child)": {
        "> input": {
          borderRight: "none",
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0
        }
      },
      /* when rendered with addon before and after */
      "&:not(:first-child):not(:last-child)": {
        "> input": {
          borderRight: "none",
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0,
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      input: {
        /* paddings specified for classes used outside React component */
        "&:not(:first-child)": {
          paddingLeft: prefixSuffixStaticWidth
        },
        "&:not(:last-child)": {
          paddingRight: prefixSuffixStaticWidth
        },
        "&[readonly]": {
          cursor: "default"
        }
      }
    }),
    input: css.cx(
      getFocusStyle(theme),
      sharedInputStyle(theme, invalid),
      css.css({
        label: "input-input",
        position: "relative",
        zIndex: 0,
        flexGrow: 1,
        borderRadius: theme.shape.radius.default,
        height: "100%",
        width: "100%"
      })
    ),
    inputDisabled: css.css({
      backgroundColor: theme.colors.action.disabledBackground,
      color: theme.colors.action.disabledText,
      border: `1px solid ${theme.colors.action.disabledBackground}`,
      "&:focus": {
        boxShadow: "none"
      }
    }),
    addon: css.css({
      label: "input-addon",
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      flexGrow: 0,
      flexShrink: 0,
      position: "relative",
      "&:first-child": {
        borderTopRightRadius: 0,
        borderBottomRightRadius: 0,
        "> :last-child": {
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0
        }
      },
      "&:last-child": {
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0,
        "> :first-child": {
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      "> *:focus": {
        /* we want anything that has focus and is an addon to be above input */
        zIndex: 2
      }
    }),
    prefix: css.cx(
      prefixSuffix,
      css.css({
        label: "input-prefix",
        paddingLeft: theme.spacing(1),
        paddingRight: theme.spacing(0.5),
        borderRight: "none",
        borderTopRightRadius: 0,
        borderBottomRightRadius: 0
      })
    ),
    suffix: css.cx(
      prefixSuffix,
      css.css({
        label: "input-suffix",
        paddingLeft: theme.spacing(1),
        paddingRight: theme.spacing(1),
        marginBottom: "-2px",
        borderLeft: "none",
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0,
        right: 0
      })
    ),
    loadingIndicator: css.css({
      "& + *": {
        marginLeft: theme.spacing(0.5)
      }
    })
  };
});

const CustomInput = (props) => {
  let testId;
  if ("data-testid" in props.selectProps && props.selectProps["data-testid"]) {
    testId = props.selectProps["data-testid"] + "-input";
  }
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.Input, { ...props, "data-testid": testId });
};

function DropdownIndicator({ selectProps }) {
  const isOpen = selectProps.menuIsOpen;
  const icon = isOpen ? "search" : "angle-down";
  const size = isOpen ? "sm" : "md";
  return /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, size });
}

const IndicatorsContainer = React.forwardRef((props, ref) => {
  const { children } = props;
  const theme = useTheme2();
  const styles = getInputStyles({ theme, invalid: false });
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      className: css.cx(
        styles.suffix,
        css.css({
          position: "relative"
        })
      ),
      ref,
      children
    }
  );
});
IndicatorsContainer.displayName = "IndicatorsContainer";

const InputControl = React.forwardRef(
  function InputControl2({ focused, invalid, disabled, children, innerProps, prefix, ...otherProps }, ref) {
    const styles = useStyles2(getInputControlStyles, invalid, !!prefix);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.input, ...innerProps, ref, children: [
      prefix && /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.prefix), children: prefix }),
      children
    ] });
  }
);
const getInputControlStyles = (theme, invalid, withPrefix) => {
  const styles = getInputStyles({ theme, invalid });
  return {
    input: css.cx(
      inputPadding(theme),
      css.css({
        width: "100%",
        maxWidth: "100%",
        display: "flex",
        flexDirection: "row",
        alignItems: "center",
        flexWrap: "wrap",
        justifyContent: "space-between",
        paddingRight: 0,
        position: "relative",
        boxSizing: "border-box"
      }),
      withPrefix && css.css({
        paddingLeft: 0
      })
    ),
    prefix: css.cx(
      styles.prefix,
      css.css({
        position: "relative"
      })
    )
  };
};

const getSelectStyles = stylesFactory((theme) => {
  return {
    menu: css.css({
      label: "grafana-select-menu",
      background: theme.components.dropdown.background,
      borderRadius: theme.shape.radius.default,
      boxShadow: theme.shadows.z3,
      position: "relative",
      minWidth: "100%",
      overflow: "hidden",
      zIndex: 1
    }),
    option: css.css({
      label: "grafana-select-option",
      padding: "8px",
      position: "relative",
      display: "flex",
      alignItems: "center",
      flexDirection: "row",
      flexShrink: 0,
      whiteSpace: "nowrap",
      cursor: "pointer",
      borderLeft: "2px solid transparent",
      borderRadius: theme.shape.radius.default,
      "&:hover": {
        background: theme.colors.action.hover,
        "@media (forced-colors: active), (prefers-contrast: more)": {
          border: `1px solid ${theme.colors.primary.border}`
        }
      }
    }),
    optionIcon: css.css({
      marginRight: theme.spacing(1)
    }),
    optionImage: css.css({
      label: "grafana-select-option-image",
      width: "16px",
      marginRight: "10px"
    }),
    optionDescription: css.css({
      label: "grafana-select-option-description",
      fontWeight: "normal",
      fontSize: theme.typography.size.sm,
      color: theme.colors.text.secondary,
      whiteSpace: "normal",
      lineHeight: theme.typography.body.lineHeight
    }),
    optionBody: css.css({
      label: "grafana-select-option-body",
      display: "flex",
      fontWeight: theme.typography.fontWeightMedium,
      flexDirection: "column",
      flexGrow: 1
    }),
    optionFocused: css.css({
      label: "grafana-select-option-focused",
      background: theme.colors.action.focus,
      "@media (forced-colors: active), (prefers-contrast: more)": {
        border: `1px solid ${theme.colors.primary.border}`
      }
    }),
    optionSelected: css.css({
      background: theme.colors.action.selected,
      "&::before": {
        backgroundImage: theme.colors.gradients.brandVertical,
        borderRadius: theme.shape.radius.default,
        content: '" "',
        display: "block",
        height: "100%",
        position: "absolute",
        transform: "translateX(-50%)",
        width: theme.spacing(0.5),
        left: 0
      }
    }),
    optionDisabled: css.css({
      label: "grafana-select-option-disabled",
      backgroundColor: theme.colors.action.disabledBackground,
      color: theme.colors.action.disabledText,
      cursor: "not-allowed"
    }),
    singleValue: css.css({
      label: "grafana-select-single-value",
      color: theme.components.input.text,
      gridArea: "1 / 1 / 2 / 3",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      boxSizing: "border-box",
      maxWidth: "100%"
    }),
    valueContainer: css.css({
      label: "grafana-select-value-container",
      alignItems: "center",
      display: "grid",
      position: "relative",
      boxSizing: "border-box",
      flex: "1 1 0%",
      outline: "none",
      overflow: "hidden"
    }),
    valueContainerMulti: css.css({
      label: "grafana-select-value-container-multi",
      flexWrap: "wrap",
      display: "flex"
    }),
    valueContainerMultiNoWrap: css.css({
      display: "grid",
      gridAutoFlow: "column"
    }),
    loadingMessage: css.css({
      label: "grafana-select-loading-message",
      padding: theme.spacing(1),
      textAlign: "center",
      width: "100%"
    }),
    multiValueContainer: css.css({
      label: "grafana-select-multi-value-container",
      display: "flex",
      alignItems: "center",
      lineHeight: 1,
      background: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.default,
      margin: theme.spacing(0.25, 1, 0.25, 0),
      padding: theme.spacing(0.25, 0, 0.25, 1),
      color: theme.colors.text.primary,
      fontSize: theme.typography.size.sm,
      overflow: "hidden",
      whiteSpace: "nowrap",
      "&:hover": {
        background: theme.colors.emphasize(theme.colors.background.secondary)
      }
    }),
    multiValueRemove: css.css({
      label: "grafana-select-multi-value-remove",
      margin: theme.spacing(0, 0.5),
      cursor: "pointer",
      svg: {
        marginBottom: 0
      }
    }),
    singleValueRemove: css.css({
      cursor: "pointer",
      "&:hover": {
        color: theme.colors.text.primary
      }
    }),
    groupHeader: css.css({
      padding: theme.spacing(1, 1, 1, 0.75),
      borderLeft: "2px solid transparent"
    }),
    group: css.css({
      "&:not(:first-child)": {
        borderTop: `1px solid ${theme.colors.border.weak}`
      },
      // ensure there's a bottom border if there are options following the group
      ':has(+ [role="option"])': {
        borderBottom: `1px solid ${theme.colors.border.weak}`
      }
    }),
    toggleAllButton: css.css({
      width: "100%",
      border: 0,
      padding: 0,
      textAlign: "left"
    })
  };
});

const MultiValueContainer = ({ innerProps, children }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...innerProps, className: styles.multiValueContainer, children });
};
const MultiValueRemove = ({ children, innerProps }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ jsxRuntime.jsx(
    IconButton,
    {
      ...innerProps,
      name: "times",
      size: "sm",
      className: styles.multiValueRemove,
      tooltip: t("grafana-ui.select.multi-value-remove", "Remove")
    }
  );
};

const SelectContainer = (props) => {
  const {
    isDisabled,
    isFocused,
    children,
    selectProps: { invalid = false }
  } = props;
  const styles = useStyles2(getSelectContainerStyles, isFocused, isDisabled, invalid);
  return /* @__PURE__ */ jsxRuntime.jsx(ReactSelect.components.SelectContainer, { ...props, className: css.cx(styles.wrapper, props.className), children });
};
const getSelectContainerStyles = (theme, focused, disabled, invalid) => {
  const styles = getInputStyles({ theme, invalid });
  return {
    wrapper: css.cx(
      styles.wrapper,
      sharedInputStyle(theme, invalid),
      focused && css.css(getFocusStyles(theme)),
      disabled && styles.inputDisabled,
      css.css({
        position: "relative",
        boxSizing: "border-box",
        /* The display property is set by the styles prop in SelectBase because it's dependant on the width prop  */
        flexDirection: "row",
        flexWrap: "wrap",
        alignItems: "stretch",
        justifyContent: "space-between",
        minHeight: theme.spacing(theme.components.height.md),
        height: "auto",
        maxWidth: "100%",
        /* Input padding is applied to the InputControl so the menu is aligned correctly */
        padding: 0,
        cursor: disabled ? "not-allowed" : "pointer"
      })
    )
  };
};

var ToggleAllState = /* @__PURE__ */ ((ToggleAllState2) => {
  ToggleAllState2["allSelected"] = "allSelected";
  ToggleAllState2["indeterminate"] = "indeterminate";
  ToggleAllState2["noneSelected"] = "noneSelected";
  return ToggleAllState2;
})(ToggleAllState || {});

const SelectMenu = ({
  children,
  maxHeight,
  innerRef,
  innerProps,
  selectProps
}) => {
  var _a;
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const { toggleAllOptions, components } = selectProps;
  const optionsElement = (_a = components == null ? void 0 : components.Option) != null ? _a : SelectMenuOptions;
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      ...innerProps,
      "data-testid": e2eSelectors.selectors.components.Select.menu,
      className: styles.menu,
      style: { maxHeight },
      "aria-label": t("grafana-ui.select.menu-label", "Select options menu"),
      children: /* @__PURE__ */ jsxRuntime.jsxs(ScrollContainer, { ref: innerRef, maxHeight: "inherit", overflowX: "hidden", showScrollIndicators: true, padding: 0.5, children: [
        toggleAllOptions && /* @__PURE__ */ jsxRuntime.jsx(
          ToggleAllOption,
          {
            state: toggleAllOptions.state,
            optionComponent: optionsElement,
            selectedCount: toggleAllOptions.selectedCount,
            onClick: toggleAllOptions.selectAllClicked
          }
        ),
        children
      ] })
    }
  );
};
SelectMenu.displayName = "SelectMenu";
const VIRTUAL_LIST_ITEM_HEIGHT = 37;
const VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER = 8;
const VIRTUAL_LIST_PADDING = 8;
const VIRTUAL_LIST_WIDTH_EXTRA = 58;
const VirtualizedSelectMenu = ({
  children,
  maxHeight,
  innerRef: scrollRef,
  options,
  selectProps,
  focusedOption
}) => {
  var _a, _b;
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const listRef = React.useRef(null);
  const { toggleAllOptions, components } = selectProps;
  const optionComponent = (_a = components == null ? void 0 : components.Option) != null ? _a : SelectMenuOptions;
  const flattenedOptions = React.useMemo(
    () => options.flatMap((option) => option.options ? [option, ...option.options] : [option]),
    [options]
  );
  const focusedIndex = flattenedOptions.findIndex(
    (option) => option.value === (focusedOption == null ? void 0 : focusedOption.value)
  );
  React.useLayoutEffect(() => {
    var _a2;
    (_a2 = listRef.current) == null ? void 0 : _a2.scrollToItem(focusedIndex);
  }, [focusedIndex]);
  if (!Array.isArray(children)) {
    return null;
  }
  const flattenedChildren = children.flatMap((child, index) => {
    if (hasArrayChildren(child)) {
      const childWithoutChildren = React__namespace.cloneElement(child, {
        children: null
      });
      return [
        childWithoutChildren,
        ...child.props.children.slice(0, -1),
        // add a bottom divider to the last item in the category
        React__namespace.cloneElement(child.props.children.at(-1), {
          innerProps: {
            ...child.props.children.at(-1).props.innerProps,
            style: {
              borderBottom: `1px solid ${theme.colors.border.weak}`,
              height: VIRTUAL_LIST_ITEM_HEIGHT
            }
          }
        })
      ];
    }
    return [child];
  });
  if (toggleAllOptions) {
    flattenedChildren.unshift(
      /* @__PURE__ */ jsxRuntime.jsx(
        ToggleAllOption,
        {
          optionComponent,
          state: toggleAllOptions.state,
          selectedCount: toggleAllOptions.selectedCount,
          onClick: toggleAllOptions.selectAllClicked
        }
      )
    );
  }
  let longestOption = (_b = lodash.max(flattenedOptions.map((option) => {
    var _a2;
    return (_a2 = option.label) == null ? void 0 : _a2.length;
  }))) != null ? _b : 0;
  if (toggleAllOptions && longestOption < 12) {
    longestOption = 12;
  }
  const widthEstimate = longestOption * VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER + VIRTUAL_LIST_PADDING * 2 + VIRTUAL_LIST_WIDTH_EXTRA;
  const heightEstimate = Math.min(flattenedChildren.length * VIRTUAL_LIST_ITEM_HEIGHT, maxHeight);
  return /* @__PURE__ */ jsxRuntime.jsx(
    reactWindow.FixedSizeList,
    {
      outerRef: scrollRef,
      ref: listRef,
      className: styles.menu,
      height: heightEstimate,
      width: widthEstimate,
      "aria-label": t("grafana-ui.select.menu-label", "Select options menu"),
      itemCount: flattenedChildren.length,
      itemSize: VIRTUAL_LIST_ITEM_HEIGHT,
      children: ({ index, style }) => /* @__PURE__ */ jsxRuntime.jsx("div", { style: { ...style, overflow: "hidden" }, children: flattenedChildren[index] })
    }
  );
};
const hasArrayChildren = (child) => {
  return React__namespace.isValidElement(child) && Array.isArray(child.props.children);
};
VirtualizedSelectMenu.displayName = "VirtualizedSelectMenu";
const ToggleAllOption = ({
  state,
  onClick,
  selectedCount,
  optionComponent
}) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ jsxRuntime.jsx(
    "button",
    {
      "data-testid": e2eSelectors.selectors.components.Select.toggleAllOptions,
      className: css.css(clearButtonStyles(theme), styles.toggleAllButton, {
        height: VIRTUAL_LIST_ITEM_HEIGHT
      }),
      onClick,
      children: optionComponent({
        isDisabled: false,
        isSelected: state === ToggleAllState.allSelected,
        isFocused: false,
        data: {},
        indeterminate: state === ToggleAllState.indeterminate,
        innerRef: () => {
        },
        innerProps: {},
        children: /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "select.select-menu.selected-count", children: "Selected " }),
          `(${selectedCount != null ? selectedCount : 0})`
        ] })
      })
    }
  );
};
const SelectMenuOptions = ({
  children,
  data: data$1,
  innerProps,
  innerRef,
  isFocused,
  isSelected,
  renderOptionLabel
}) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const icon = data$1.icon ? data.toIconName(data$1.icon) : void 0;
  const { onMouseMove, onMouseOver, ...rest } = innerProps;
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      ref: innerRef,
      className: css.cx(
        styles.option,
        isFocused && styles.optionFocused,
        isSelected && styles.optionSelected,
        data$1.isDisabled && styles.optionDisabled
      ),
      ...rest,
      "data-testid": e2eSelectors.selectors.components.Select.option,
      title: data$1.title,
      children: [
        icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, className: styles.optionIcon }),
        data$1.imgUrl && /* @__PURE__ */ jsxRuntime.jsx("img", { className: styles.optionImage, src: data$1.imgUrl, alt: data$1.label || String(data$1.value) }),
        /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.optionBody, children: [
          /* @__PURE__ */ jsxRuntime.jsx("span", { children: renderOptionLabel ? renderOptionLabel(data$1) : children }),
          data$1.description && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.optionDescription, children: data$1.description }),
          data$1.component && /* @__PURE__ */ jsxRuntime.jsx(data$1.component, {})
        ] })
      ]
    }
  );
};
SelectMenuOptions.displayName = "SelectMenuOptions";

const SelectOptionGroup = ({
  children,
  cx,
  getClassNames,
  getStyles,
  Heading,
  headingProps,
  label,
  selectProps,
  theme
}) => {
  const styles = useStyles2(getSelectStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.group, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      Heading,
      {
        cx,
        getClassNames,
        getStyles,
        selectProps,
        theme,
        ...headingProps,
        children: label
      }
    ),
    children
  ] });
};

const SelectOptionGroupHeader = (props) => {
  var _a;
  const styles = useStyles2(getSelectStyles);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.groupHeader, children: /* @__PURE__ */ jsxRuntime.jsx(Text, { weight: "bold", variant: "bodySmall", color: "secondary", children: (_a = props.children) != null ? _a : "" }) });
};

class UnthemedValueContainer extends React.Component {
  render() {
    const { children } = this.props;
    const { selectProps } = this.props;
    if (selectProps && Array.isArray(children) && Array.isArray(children[0]) && selectProps.maxVisibleValues !== void 0 && !(selectProps.showAllSelectedWhenOpen && selectProps.menuIsOpen)) {
      const [valueChildren, ...otherChildren] = children;
      const truncatedValues = valueChildren.slice(0, selectProps.maxVisibleValues);
      return this.renderContainer([truncatedValues, ...otherChildren]);
    }
    return this.renderContainer(children);
  }
  renderContainer(children) {
    var _a, _b;
    const { isMulti, theme, selectProps } = this.props;
    const noWrap = ((_a = this.props.selectProps) == null ? void 0 : _a.noMultiValueWrap) && !((_b = this.props.selectProps) == null ? void 0 : _b.menuIsOpen);
    const styles = getSelectStyles(theme);
    const dataTestid = selectProps["data-testid"];
    const className = css.cx(styles.valueContainer, {
      [styles.valueContainerMulti]: isMulti && !noWrap,
      [styles.valueContainerMultiNoWrap]: isMulti && noWrap
    });
    return /* @__PURE__ */ jsxRuntime.jsx("div", { "data-testid": dataTestid, className, children });
  }
}
const ValueContainer = withTheme2(UnthemedValueContainer);

const cleanValue = (value, options) => {
  if (Array.isArray(value)) {
    const filtered = value.filter(Boolean);
    return (filtered == null ? void 0 : filtered.length) ? filtered : void 0;
  }
  if (typeof value === "object") {
    return [value];
  }
  if (typeof value === "string" || typeof value === "number") {
    const selectedValue = findSelectedValue(value, options);
    if (selectedValue) {
      return [selectedValue];
    }
  }
  return void 0;
};
const findSelectedValue = (value, options) => {
  for (const option of options) {
    if ("options" in option) {
      let found = findSelectedValue(value, option.options);
      if (found) {
        return found;
      }
    } else if ("value" in option && option.value === value) {
      return option;
    }
  }
  return null;
};
const omitDescriptions = (options) => {
  return options.map(({ description, ...rest }) => rest);
};

const CustomControl = (props) => {
  const {
    children,
    innerProps,
    selectProps: { menuIsOpen, onMenuClose, onMenuOpen },
    isFocused,
    isMulti,
    getValue,
    innerRef
  } = props;
  const selectProps = props.selectProps;
  if (selectProps.renderControl) {
    return React__namespace.createElement(selectProps.renderControl, {
      isOpen: menuIsOpen,
      value: isMulti ? getValue() : getValue()[0],
      ref: innerRef,
      onClick: menuIsOpen ? onMenuClose : onMenuOpen,
      onBlur: onMenuClose,
      disabled: !!selectProps.disabled,
      invalid: !!selectProps.invalid
    });
  }
  return /* @__PURE__ */ jsxRuntime.jsx(
    InputControl,
    {
      ref: innerRef,
      innerProps,
      prefix: selectProps.prefix,
      focused: isFocused,
      invalid: !!selectProps.invalid,
      disabled: !!selectProps.disabled,
      children
    }
  );
};
function determineToggleAllState(selectedValue, options) {
  if (options.length === selectedValue.length) {
    return ToggleAllState.allSelected;
  } else if (selectedValue.length === 0) {
    return ToggleAllState.noneSelected;
  } else {
    return ToggleAllState.indeterminate;
  }
}
function SelectBase({
  allowCustomValue = false,
  allowCreateWhileLoading = false,
  "aria-label": ariaLabel,
  "data-testid": dataTestid,
  autoFocus = false,
  backspaceRemovesValue = true,
  blurInputOnSelect,
  cacheOptions,
  className,
  closeMenuOnSelect = true,
  components,
  createOptionPosition = "last",
  defaultOptions,
  defaultValue,
  disabled = false,
  filterOption,
  formatCreateLabel,
  getOptionLabel,
  getOptionValue,
  inputValue,
  invalid,
  isClearable = false,
  id,
  isLoading = false,
  isMulti = false,
  inputId,
  isOpen,
  isOptionDisabled,
  isSearchable = true,
  loadOptions,
  loadingMessage = "Loading options...",
  maxMenuHeight = 300,
  minMenuHeight,
  maxVisibleValues,
  menuPlacement = "auto",
  menuPosition,
  menuShouldPortal = true,
  noOptionsMessage = t("grafana-ui.select.no-options-label", "No options found"),
  onBlur,
  onChange,
  onCloseMenu,
  onCreateOption,
  onInputChange,
  onKeyDown,
  onMenuScrollToBottom,
  onMenuScrollToTop,
  onOpenMenu,
  onFocus,
  toggleAllOptions,
  openMenuOnFocus = false,
  options = [],
  placeholder = t("grafana-ui.select.placeholder", "Choose"),
  prefix,
  renderControl,
  showAllSelectedWhenOpen = true,
  tabSelectsValue = true,
  value,
  virtualized = false,
  noMultiValueWrap,
  width,
  isValidNewOption,
  formatOptionLabel,
  hideSelectedOptions,
  ...rest
}) {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const reactSelectRef = React.useRef(null);
  const [closeToBottom, setCloseToBottom] = React.useState(false);
  const selectStyles = useCustomSelectStyles(theme, width);
  const [hasInputValue, setHasInputValue] = React.useState(!!inputValue);
  React.useEffect(() => {
    if (loadOptions && isOpen && reactSelectRef.current && reactSelectRef.current.controlRef && menuPlacement === "auto") {
      const distance = window.innerHeight - reactSelectRef.current.controlRef.getBoundingClientRect().bottom;
      setCloseToBottom(distance < maxMenuHeight);
    }
  }, [maxMenuHeight, menuPlacement, loadOptions, isOpen]);
  const onChangeWithEmpty = React.useCallback(
    (value2, action) => {
      if (isMulti && (value2 === void 0 || value2 === null)) {
        return onChange([], action);
      }
      onChange(value2, action);
    },
    [isMulti, onChange]
  );
  let ReactSelectComponent = ReactSelect__default.default;
  const creatableProps = {};
  let asyncSelectProps = {};
  let selectedValue;
  if (isMulti && loadOptions) {
    selectedValue = value;
  } else {
    if (isMulti && value && Array.isArray(value) && !loadOptions) {
      selectedValue = value.map((v) => {
        var _a;
        const selectableValue = findSelectedValue((_a = v.value) != null ? _a : v, options);
        if (selectableValue) {
          return selectableValue;
        }
        return typeof v === "string" ? data.toOption(v) : v;
      });
    } else if (loadOptions) {
      const hasValue = defaultValue || value;
      selectedValue = hasValue ? [hasValue] : [];
    } else {
      selectedValue = cleanValue(value, options);
    }
  }
  const commonSelectProps = {
    "aria-label": ariaLabel,
    "data-testid": dataTestid,
    autoFocus,
    backspaceRemovesValue,
    blurInputOnSelect,
    captureMenuScroll: onMenuScrollToBottom || onMenuScrollToTop,
    closeMenuOnSelect,
    // We don't want to close if we're actually scrolling the menu
    // So only close if none of the parents are the select menu itself
    defaultValue,
    // Also passing disabled, as this is the new Select API, and I want to use this prop instead of react-select's one
    disabled,
    // react-select always tries to filter the options even at first menu open, which is a problem for performance
    // in large lists. So we set it to not try to filter the options if there is no input value.
    filterOption: hasInputValue ? filterOption : null,
    getOptionLabel,
    getOptionValue,
    hideSelectedOptions,
    inputValue,
    invalid,
    isClearable,
    id,
    // Passing isDisabled as react-select accepts this prop
    isDisabled: disabled,
    isLoading,
    isMulti,
    inputId,
    isOptionDisabled,
    isSearchable,
    maxMenuHeight,
    minMenuHeight,
    maxVisibleValues,
    menuIsOpen: isOpen,
    menuPlacement: menuPlacement === "auto" && closeToBottom ? "top" : menuPlacement,
    menuPosition,
    menuShouldBlockScroll: true,
    menuPortalTarget: menuShouldPortal && typeof document !== "undefined" ? document.body : void 0,
    menuShouldScrollIntoView: false,
    onBlur,
    onChange: onChangeWithEmpty,
    onInputChange: (val, actionMeta) => {
      var _a;
      const newValue = (_a = onInputChange == null ? void 0 : onInputChange(val, actionMeta)) != null ? _a : val;
      const newHasValue = !!newValue;
      if (newHasValue !== hasInputValue) {
        setHasInputValue(newHasValue);
      }
      return newValue;
    },
    onKeyDown,
    onMenuClose: onCloseMenu,
    onMenuOpen: onOpenMenu,
    onMenuScrollToBottom,
    onMenuScrollToTop,
    onFocus,
    formatOptionLabel,
    openMenuOnFocus,
    options: virtualized ? omitDescriptions(options) : options,
    placeholder,
    prefix,
    renderControl,
    showAllSelectedWhenOpen,
    tabSelectsValue,
    value: isMulti ? selectedValue : selectedValue == null ? void 0 : selectedValue[0],
    noMultiValueWrap
  };
  if (allowCustomValue) {
    ReactSelectComponent = Creatable__default.default;
    creatableProps.allowCreateWhileLoading = allowCreateWhileLoading;
    creatableProps.formatCreateLabel = formatCreateLabel != null ? formatCreateLabel : defaultFormatCreateLabel;
    creatableProps.onCreateOption = onCreateOption;
    creatableProps.createOptionPosition = createOptionPosition;
    creatableProps.isValidNewOption = isValidNewOption;
  }
  if (loadOptions) {
    ReactSelectComponent = allowCustomValue ? AsyncCreatable__default.default : ReactAsyncSelect__default.default;
    asyncSelectProps = {
      loadOptions,
      cacheOptions,
      defaultOptions
    };
  }
  const SelectMenuComponent = virtualized ? VirtualizedSelectMenu : SelectMenu;
  let toggleAllState = ToggleAllState.noneSelected;
  if ((toggleAllOptions == null ? void 0 : toggleAllOptions.enabled) && lodash.isArray(selectedValue)) {
    if (toggleAllOptions == null ? void 0 : toggleAllOptions.determineToggleAllState) {
      toggleAllState = toggleAllOptions.determineToggleAllState(selectedValue, options);
    } else {
      toggleAllState = determineToggleAllState(selectedValue, options);
    }
  }
  const toggleAll = React.useCallback(() => {
    let toSelect = toggleAllState === ToggleAllState.noneSelected ? options : [];
    if (toggleAllOptions == null ? void 0 : toggleAllOptions.optionsFilter) {
      toSelect = toggleAllState === ToggleAllState.noneSelected ? options.filter(toggleAllOptions.optionsFilter) : options.filter(lodash.negate(toggleAllOptions.optionsFilter));
    }
    onChange(toSelect, {
      action: "select-option",
      option: {}
    });
  }, [options, toggleAllOptions, onChange, toggleAllState]);
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx(
    ReactSelectComponent,
    {
      ref: reactSelectRef,
      components: {
        MenuList: SelectMenuComponent,
        Group: SelectOptionGroup,
        GroupHeading: SelectOptionGroupHeader,
        ValueContainer,
        IndicatorsContainer: CustomIndicatorsContainer,
        IndicatorSeparator,
        Control: CustomControl,
        Option: SelectMenuOptions,
        ClearIndicator(props) {
          const { clearValue } = props;
          return /* @__PURE__ */ jsxRuntime.jsx(
            Icon,
            {
              name: "times",
              role: "button",
              "aria-label": t("grafana-ui.select.clear-value", "Clear value"),
              className: styles.singleValueRemove,
              onMouseDown: (e) => {
                e.preventDefault();
                e.stopPropagation();
                clearValue();
              }
            }
          );
        },
        LoadingIndicator() {
          return /* @__PURE__ */ jsxRuntime.jsx(Spinner, { inline: true });
        },
        LoadingMessage() {
          return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.loadingMessage, children: loadingMessage });
        },
        NoOptionsMessage() {
          return /* @__PURE__ */ jsxRuntime.jsx(
            "div",
            {
              className: styles.loadingMessage,
              "aria-label": t("grafana-ui.select.empty-options", "No options provided"),
              children: noOptionsMessage
            }
          );
        },
        DropdownIndicator,
        SingleValue(props) {
          return /* @__PURE__ */ jsxRuntime.jsx(SingleValue, { ...props, isDisabled: disabled });
        },
        SelectContainer,
        MultiValueContainer,
        MultiValueRemove: !disabled ? MultiValueRemove : () => null,
        Input: CustomInput,
        ...components
      },
      toggleAllOptions: (toggleAllOptions == null ? void 0 : toggleAllOptions.enabled) && {
        state: toggleAllState,
        selectAllClicked: toggleAll,
        selectedCount: lodash.isArray(selectedValue) ? selectedValue.length : void 0
      },
      styles: selectStyles,
      className,
      ...commonSelectProps,
      ...creatableProps,
      ...asyncSelectProps,
      ...rest
    }
  ) });
}
function defaultFormatCreateLabel(input) {
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: { display: "flex", gap: "8px", alignItems: "center" }, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { children: input }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { style: { flexGrow: 1 } }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: "muted small", style: { display: "flex", gap: "8px", alignItems: "center" }, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.select.default-create-label", children: "Hit enter to add" }) })
  ] });
}
function CustomIndicatorsContainer(props) {
  const { showAllSelectedWhenOpen, maxVisibleValues, menuIsOpen } = props.selectProps;
  const value = props.getValue();
  if (maxVisibleValues !== void 0 && Array.isArray(props.children)) {
    const selectedValuesCount = value.length;
    if (selectedValuesCount > maxVisibleValues && !(showAllSelectedWhenOpen && menuIsOpen)) {
      const indicatorChildren = [...props.children];
      indicatorChildren.splice(
        -1,
        0,
        /* @__PURE__ */ jsxRuntime.jsx("span", { id: "excess-values", children: `(+${selectedValuesCount - maxVisibleValues})` }, "excess-values")
      );
      return /* @__PURE__ */ jsxRuntime.jsx(IndicatorsContainer, { ...props, children: indicatorChildren });
    }
  }
  return /* @__PURE__ */ jsxRuntime.jsx(IndicatorsContainer, { ...props });
}
function IndicatorSeparator() {
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, {});
}

function Select(props) {
  return /* @__PURE__ */ jsxRuntime.jsx(SelectBase, { ...props });
}
function MultiSelect(props) {
  return /* @__PURE__ */ jsxRuntime.jsx(SelectBase, { ...props, isMulti: true });
}

const onChangeCascader = (onChanged) => (values, options) => {
  if (onChanged) {
    onChanged(
      values.map((value) => String(value)),
      fromRCOptions(options)
    );
  }
};
const fromRCOptions = (options) => {
  return options.map(fromRCOption);
};
const fromRCOption = (option) => {
  const value = option.value ? String(option.value) : "";
  return {
    value,
    label: typeof option.label === "string" ? option.label : value
  };
};

const slideUpIn = css.keyframes({
  "0%": {
    opacity: 0,
    transformOrigin: "0% 0%",
    transform: "scaleY(0.8)"
  },
  "100%": {
    opacity: 1,
    transformOrigin: "0% 0%",
    transform: "scaleY(1)"
  }
});
const slideUpOut = css.keyframes({
  "0%": {
    opacity: 1,
    transformOrigin: "0% 0%",
    transform: "scaleY(1)"
  },
  "100%": {
    opacity: 0,
    transformOrigin: "0% 0%",
    transform: "scaleY(0.8)"
  }
});
const slideDownIn = css.keyframes({
  "0%": {
    opacity: 0,
    transformOrigin: "0% 100%",
    transform: "scaleY(0.8)"
  },
  "100%": {
    opacity: 1,
    transformOrigin: "0% 100%",
    transform: "scaleY(1)"
  }
});
const slideDownOut = css.keyframes({
  "0%": {
    opacity: 1,
    transformOrigin: "0% 100%",
    transform: "scaleY(1)"
  },
  "100%": {
    opacity: 0,
    transformOrigin: "0% 100%",
    transform: "scaleY(0.8)"
  }
});
const getCascaderStyles = (theme) => ({
  dropdown: css.css({
    "&.rc-cascader-dropdown": {
      position: "absolute",
      // Required, otherwise the portal that the popup is shown in will render under other components
      zIndex: 9999,
      "&-hidden": {
        display: "none"
      }
    },
    ".rc-cascader": {
      "&-menus": {
        overflow: "hidden",
        background: theme.colors.background.elevated,
        border: `none`,
        borderRadius: theme.shape.radius.default,
        boxShadow: theme.shadows.z3,
        whiteSpace: "nowrap",
        "&.slide-up-enter, &.slide-up-appear": {
          animationDuration: "0.3s",
          animationFillMode: "both",
          transformOrigin: "0 0",
          opacity: 0,
          animationTimingFunction: "cubic-bezier(0.08, 0.82, 0.17, 1)",
          animationPlayState: "paused"
        },
        "&.slide-up-enter.slide-up-enter-active.rc-cascader-menus-placement, &.slide-up-appear.slide-up-appear-active.rc-cascader-menus-placement": {
          "&-bottomLeft": {
            animationName: slideUpIn,
            animationPlayState: "running"
          },
          "&-topLeft": {
            animationName: slideDownIn,
            animationPlayState: "running"
          }
        },
        "&.slide-up-leave": {
          animationDuration: "0.3s",
          animationFillMode: "both",
          transformOrigin: "0 0",
          opacity: 1,
          animationTimingFunction: "cubic-bezier(0.6, 0.04, 0.98, 0.34)",
          animationPlayState: "paused",
          "&.slide-up-leave-active.rc-cascader-menus-placement": {
            "&-bottomLeft": {
              animationName: slideUpOut,
              animationPlayState: "running"
            },
            "&-topLeft": {
              animationName: slideDownOut,
              animationPlayState: "running"
            }
          }
        }
      },
      "&-menu": {
        display: "inline-block",
        maxWidth: "50vw",
        height: "192px",
        listStyle: "none",
        margin: 0,
        padding: theme.spacing(0.5),
        borderRight: `1px solid ${theme.colors.border.weak}`,
        overflow: "auto",
        "&:last-child": {
          borderRight: 0
        },
        "&-item": {
          height: theme.spacing(4),
          lineHeight: theme.spacing(4),
          padding: theme.spacing(0, 4, 0, 2),
          borderRadius: theme.shape.radius.default,
          cursor: "pointer",
          whiteSpace: "nowrap",
          overflow: "hidden",
          textOverflow: "ellipsis",
          transition: "all 0.3s ease",
          position: "relative",
          "&:hover": {
            background: theme.colors.action.hover
          },
          "&-disabled": {
            cursor: "not-allowed",
            color: theme.colors.text.disabled,
            "&:hover": {
              background: "transparent"
            },
            "&:after": {
              position: "absolute",
              right: "12px",
              content: "'loading'",
              color: theme.colors.text.disabled,
              fontStyle: "italic"
            }
          },
          "&-active": {
            color: theme.colors.text.maxContrast,
            background: theme.colors.background.secondary,
            "&:hover": {
              background: theme.colors.action.hover
            }
          },
          "&-expand": {
            position: "relative",
            "&:after": {
              background: theme.colors.background.secondary,
              content: "''",
              height: theme.spacing(3),
              mask: "url(../img/icons/unicons/angle-right.svg)",
              maskType: "luminance",
              position: "absolute",
              right: 0,
              top: theme.spacing(0.5),
              width: theme.spacing(3)
            }
          }
        }
      }
    }
  })
});

const disableDivFocus = css.css({
  "&:focus": {
    outline: "none"
  }
});
const DEFAULT_SEPARATOR = " / ";
class UnthemedCascader extends React.PureComponent {
  constructor(props) {
    super(props);
    this.flattenOptions = (options, optionPath = []) => {
      let selectOptions = [];
      for (const option of options) {
        const cpy = [...optionPath];
        cpy.push(option);
        if (!option.items || option.items.length === 0) {
          selectOptions.push({
            singleLabel: cpy[cpy.length - 1].label,
            label: cpy.map((o) => o.label).join(this.props.separator || DEFAULT_SEPARATOR),
            value: cpy.map((o) => o.value)
          });
        } else {
          selectOptions = [...selectOptions, ...this.flattenOptions(option.items, cpy)];
        }
      }
      return selectOptions;
    };
    this.getSearchableOptions = memoize__default.default((options) => this.flattenOptions(options));
    //For rc-cascader
    this.onChange = (value, selectedOptions) => {
      const activeLabel = this.props.hideActiveLevelLabel ? "" : this.props.displayAllSelectedLevels ? selectedOptions.map((option) => option.label).join(this.props.separator || DEFAULT_SEPARATOR) : selectedOptions[selectedOptions.length - 1].label;
      const state = {
        rcValue: { value, label: activeLabel },
        focusCascade: true,
        activeLabel,
        isSearching: false,
        inputValue: activeLabel
      };
      this.setState(state);
      this.props.onSelect(selectedOptions[selectedOptions.length - 1].value);
    };
    //For select
    this.onSelect = (obj) => {
      const valueArray = obj.value || [];
      const activeLabel = this.props.displayAllSelectedLevels ? obj.label : obj.singleLabel || "";
      const state = {
        activeLabel,
        inputValue: activeLabel,
        rcValue: { value: valueArray, label: activeLabel },
        isSearching: false,
        focusCascade: false
      };
      this.setState(state);
      this.props.onSelect(valueArray[valueArray.length - 1]);
    };
    this.onCreateOption = (value) => {
      this.setState({
        activeLabel: value,
        inputValue: value,
        rcValue: [],
        isSearching: false
      });
      this.props.onSelect(value);
    };
    this.onBlur = () => {
      var _a, _b;
      this.setState({
        isSearching: false,
        focusCascade: false
      });
      if (this.state.activeLabel === "") {
        this.setState({
          rcValue: []
        });
      }
      (_b = (_a = this.props).onBlur) == null ? void 0 : _b.call(_a);
    };
    this.onBlurCascade = () => {
      var _a, _b;
      this.setState({
        focusCascade: false
      });
      (_b = (_a = this.props).onBlur) == null ? void 0 : _b.call(_a);
    };
    this.onInputKeyDown = (e) => {
      if (["ArrowDown", "ArrowUp", "Enter", "ArrowLeft", "ArrowRight"].includes(e.key)) {
        return;
      }
      const { activeLabel } = this.state;
      this.setState({
        focusCascade: false,
        isSearching: true,
        inputValue: activeLabel
      });
    };
    this.onSelectInputChange = (value) => {
      this.setState({
        inputValue: value
      });
    };
    const searchableOptions = this.getSearchableOptions(props.options);
    const { rcValue, activeLabel } = this.setInitialValue(searchableOptions, props.initialValue);
    this.state = {
      isSearching: false,
      focusCascade: false,
      rcValue,
      activeLabel,
      inputValue: ""
    };
  }
  setInitialValue(searchableOptions, initValue) {
    if (!initValue) {
      return { rcValue: [], activeLabel: "" };
    }
    for (const option of searchableOptions) {
      const optionPath = option.value || [];
      if (optionPath[optionPath.length - 1] === initValue) {
        return {
          rcValue: optionPath,
          activeLabel: this.props.displayAllSelectedLevels ? option.label : option.singleLabel || ""
        };
      }
    }
    if (this.props.allowCustomValue) {
      return { rcValue: [], activeLabel: initValue };
    }
    return { rcValue: [], activeLabel: "" };
  }
  render() {
    const {
      allowCustomValue,
      formatCreateLabel,
      placeholder,
      width,
      changeOnSelect,
      options,
      disabled,
      id,
      isClearable,
      theme
    } = this.props;
    const { focusCascade, isSearching, rcValue, activeLabel, inputValue } = this.state;
    const searchableOptions = this.getSearchableOptions(options);
    const styles = getCascaderStyles(theme);
    return /* @__PURE__ */ jsxRuntime.jsx("div", { children: isSearching ? /* @__PURE__ */ jsxRuntime.jsx(
      Select,
      {
        allowCustomValue,
        placeholder,
        autoFocus: !focusCascade,
        onChange: this.onSelect,
        onBlur: this.onBlur,
        options: searchableOptions,
        onCreateOption: this.onCreateOption,
        formatCreateLabel,
        width,
        onInputChange: this.onSelectInputChange,
        disabled,
        inputValue,
        inputId: id
      }
    ) : /* @__PURE__ */ jsxRuntime.jsx(
      RCCascader__default.default,
      {
        onChange: onChangeCascader(this.onChange),
        options,
        changeOnSelect,
        value: rcValue.value,
        fieldNames: { label: "label", value: "value", children: "items" },
        expandIcon: null,
        open: this.props.alwaysOpen,
        disabled,
        dropdownClassName: styles.dropdown,
        children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: disableDivFocus, children: /* @__PURE__ */ jsxRuntime.jsx(
          Input,
          {
            autoFocus: this.props.autoFocus,
            width,
            placeholder,
            onBlur: this.onBlurCascade,
            value: activeLabel,
            onKeyDown: this.onInputKeyDown,
            onChange: () => {
            },
            suffix: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { gap: 0.5, children: [
              isClearable && activeLabel !== "" && /* @__PURE__ */ jsxRuntime.jsx(
                IconButton,
                {
                  name: "times",
                  "aria-label": t("grafana-ui.cascader.clear-button", "Clear selection"),
                  onClick: (e) => {
                    e.preventDefault();
                    e.stopPropagation();
                    this.setState({ rcValue: [], activeLabel: "", inputValue: "" });
                    this.props.onSelect("");
                  }
                }
              ),
              /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: focusCascade ? "angle-up" : "angle-down" })
            ] }),
            disabled,
            id
          }
        ) })
      }
    ) });
  }
}
UnthemedCascader.defaultProps = { changeOnSelect: true };
withTheme2(UnthemedCascader);

const Alert = React__namespace.forwardRef(
  ({
    title,
    onRemove,
    children,
    buttonContent,
    elevated,
    bottomSpacing,
    topSpacing,
    className,
    severity = "error",
    ...restProps
  }, ref) => {
    const theme = useTheme2();
    const hasTitle = Boolean(title);
    const styles = getStyles$_(theme, severity, hasTitle, elevated, bottomSpacing, topSpacing);
    const rolesBySeverity = {
      error: "alert",
      warning: "alert",
      info: "status",
      success: "status"
    };
    const role = restProps["role"] || rolesBySeverity[severity];
    const ariaLabel = restProps["aria-label"] || title;
    const closeLabel = t("grafana-ui.alert.close-button", "Close alert");
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ref, className: css.cx(styles.wrapper, className), role, "aria-label": ariaLabel, ...restProps, children: /* @__PURE__ */ jsxRuntime.jsxs(
      Box,
      {
        "data-testid": e2eSelectors.selectors.components.Alert.alertV2(severity),
        display: "flex",
        backgroundColor: severity,
        borderRadius: "default",
        paddingY: 1,
        paddingX: 2,
        borderStyle: "solid",
        borderColor: severity,
        alignItems: "stretch",
        boxShadow: elevated ? "z3" : void 0,
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(Box, { paddingTop: 1, paddingRight: 2, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.icon, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { size: "xl", name: getIconFromSeverity(severity) }) }) }),
          /* @__PURE__ */ jsxRuntime.jsxs(Box, { paddingY: 1, grow: 1, children: [
            /* @__PURE__ */ jsxRuntime.jsx(Text, { color: "primary", weight: "medium", children: title }),
            children && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.content, children })
          ] }),
          onRemove && !buttonContent && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.close, children: /* @__PURE__ */ jsxRuntime.jsx(
            Button,
            {
              "aria-label": closeLabel,
              icon: "times",
              onClick: onRemove,
              type: "button",
              fill: "text",
              variant: "secondary"
            }
          ) }),
          onRemove && buttonContent && /* @__PURE__ */ jsxRuntime.jsx(Box, { marginLeft: 1, display: "flex", alignItems: "center", children: /* @__PURE__ */ jsxRuntime.jsx(Button, { "aria-label": closeLabel, variant: "secondary", onClick: onRemove, type: "button", children: buttonContent }) })
        ]
      }
    ) });
  }
);
Alert.displayName = "Alert";
const getIconFromSeverity = (severity) => {
  switch (severity) {
    case "error":
      return "exclamation-circle";
    case "warning":
      return "exclamation-triangle";
    case "info":
      return "info-circle";
    case "success":
      return "check";
  }
};
const getStyles$_ = (theme, severity, hasTitle, elevated, bottomSpacing, topSpacing) => {
  const color = theme.colors[severity];
  return {
    wrapper: css.css({
      flexGrow: 1,
      marginBottom: theme.spacing(bottomSpacing != null ? bottomSpacing : 2),
      marginTop: theme.spacing(topSpacing != null ? topSpacing : 0),
      position: "relative",
      "&:before": {
        content: '""',
        position: "absolute",
        top: 0,
        left: 0,
        bottom: 0,
        right: 0,
        background: theme.colors.background.primary,
        zIndex: -1
      }
    }),
    icon: css.css({
      color: color.text,
      position: "relative",
      top: "-1px"
    }),
    content: css.css({
      color: theme.colors.text.primary,
      paddingTop: hasTitle ? theme.spacing(0.5) : 0,
      maxHeight: "50vh",
      overflowY: "auto"
    }),
    close: css.css({
      position: "relative",
      color: theme.colors.text.secondary,
      background: "none",
      display: "flex",
      top: "-6px",
      right: "-14px"
    })
  };
};

const closePopover = (event, hidePopper) => {
  if (event.key === "Tab" || event.altKey || event.ctrlKey || event.metaKey) {
    return;
  }
  event.stopPropagation();
  if (event.key === "Escape") {
    hidePopper();
  }
  return;
};

var ColorSwatchVariant = /* @__PURE__ */ ((ColorSwatchVariant2) => {
  ColorSwatchVariant2["Small"] = "small";
  ColorSwatchVariant2["Large"] = "large";
  return ColorSwatchVariant2;
})(ColorSwatchVariant || {});
const ColorSwatch = React__namespace.forwardRef(
  ({ color, label, variant = "small" /* Small */, isSelected, "aria-label": ariaLabel, ...otherProps }, ref) => {
    const theme = useTheme2();
    const { isFocusVisible, focusProps } = focus.useFocusRing();
    const styles = getStyles$Z(theme, variant, color, isFocusVisible, isSelected);
    const hasLabel = !!label;
    const colorLabel = ariaLabel || label;
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { ref, className: styles.wrapper, "data-testid": e2eSelectors.selectors.components.ColorSwatch.name, ...otherProps, children: [
      hasLabel && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.label, children: label }),
      /* @__PURE__ */ jsxRuntime.jsx(
        "button",
        {
          className: styles.swatch,
          ...focusProps,
          "aria-label": colorLabel ? `${colorLabel} color` : "Pick a color",
          type: "button"
        }
      )
    ] });
  }
);
const getStyles$Z = (theme, variant, color, isFocusVisible, isSelected) => {
  const tc = tinycolor__default.default(color);
  const isSmall = variant === "small" /* Small */;
  const swatchSize = isSmall ? "16px" : "32px";
  let border = "none";
  if (tc.getAlpha() < 0.1) {
    border = `2px solid ${theme.colors.border.medium}`;
  }
  return {
    wrapper: css.css({
      display: "flex",
      alignItems: "center",
      cursor: "pointer"
    }),
    label: css.css({
      marginRight: theme.spacing(1)
    }),
    swatch: css.css({
      width: swatchSize,
      height: swatchSize,
      background: `${color}`,
      border,
      borderRadius: theme.shape.radius.circle,
      outlineOffset: "1px",
      outline: isFocusVisible ? `2px solid  ${theme.colors.primary.main}` : "none",
      boxShadow: isSelected ? `inset 0 0 0 2px ${color}, inset 0 0 0 4px ${theme.colors.getContrastText(color)}` : "none",
      [theme.transitions.handleMotion("no-preference")]: {
        transition: theme.transitions.create(["transform"], {
          duration: theme.transitions.duration.short
        })
      },
      "&:hover": {
        transform: "scale(1.1)"
      },
      "@media (forced-colors: active)": {
        forcedColorAdjust: "none"
      }
    })
  };
};
ColorSwatch.displayName = "ColorSwatch";

function reverseMap(arr, callbackfn) {
  const reversedAndMapped = new Array(arr.length);
  for (let i = 0; i < arr.length; i++) {
    const reverseIndex = arr.length - 1 - i;
    reversedAndMapped[i] = callbackfn(arr[reverseIndex], reverseIndex, arr);
  }
  return reversedAndMapped;
}

const NamedColorsGroup = ({ hue, selectedColor, onColorSelect, ...otherProps }) => {
  const label = lodash.upperFirst(hue.name);
  const styles = useStyles2(getStyles$Y);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.colorRow, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.colorLabel, children: label }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { ...otherProps, className: styles.swatchRow, children: reverseMap(hue.shades, (shade) => /* @__PURE__ */ jsxRuntime.jsx(
      ColorSwatch,
      {
        "aria-label": shade.name,
        variant: shade.primary ? ColorSwatchVariant.Large : ColorSwatchVariant.Small,
        isSelected: shade.name === selectedColor,
        color: shade.color,
        onClick: () => onColorSelect(shade.name)
      },
      shade.name
    )) })
  ] });
};
const getStyles$Y = (theme) => {
  return {
    colorRow: css.css({
      display: "grid",
      gridTemplateColumns: "25% 1fr",
      gridColumnGap: theme.spacing(2),
      padding: theme.spacing(0.5, 0),
      "&:hover": {
        background: theme.colors.background.secondary
      }
    }),
    colorLabel: css.css({
      paddingLeft: theme.spacing(1),
      display: "flex",
      alignItems: "center"
    }),
    swatchRow: css.css({
      display: "flex",
      gap: theme.spacing(1),
      alignItems: "center",
      justifyContent: "space-around",
      flexDirection: "row"
    })
  };
};

const NamedColorsPalette = ({ color, onChange }) => {
  const theme = useTheme2();
  const styles = useStyles2(getStyles$X);
  const swatches = [];
  for (const hue of theme.visualization.hues) {
    swatches.push(/* @__PURE__ */ jsxRuntime.jsx(NamedColorsGroup, { selectedColor: color, hue, onColorSelect: onChange }, hue.name));
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.swatches, children: swatches }),
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.extraColors, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ColorSwatch,
        {
          isSelected: color === "transparent",
          color: "rgba(0,0,0,0)",
          label: t("grafana-ui.named-colors-palette.transparent-swatch", "Transparent"),
          onClick: () => onChange("transparent")
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        ColorSwatch,
        {
          isSelected: color === "text",
          color: theme.colors.text.primary,
          label: t("grafana-ui.named-colors-palette.text-color-swatch", "Text color"),
          onClick: () => onChange("text")
        }
      )
    ] })
  ] });
};
const getStyles$X = (theme) => {
  return {
    container: css.css({
      display: "flex",
      flexDirection: "column"
    }),
    extraColors: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "space-around",
      gap: theme.spacing(1),
      padding: theme.spacing(1, 0)
    }),
    swatches: css.css({
      display: "grid",
      flexGrow: 1
    })
  };
};

const ColorInput = React.forwardRef(
  ({ color, onChange, isClearable = false, onClick, onBlur, disabled, buttonAriaLabel, ...inputProps }, ref) => {
    const [value, setValue] = React.useState(color);
    const [previousColor, setPreviousColor] = React.useState(color);
    const updateColor = React.useMemo(() => lodash.debounce(onChange, 100), []);
    React.useEffect(() => {
      const newColor = tinycolor__default.default(color);
      if (newColor.isValid() && color !== previousColor) {
        setValue(newColor.toString());
        setPreviousColor(color);
      }
    }, [color, previousColor]);
    const onChangeColor = (event) => {
      const { value: colorValue } = event.currentTarget;
      setValue(colorValue);
      if (colorValue === "" && isClearable) {
        updateColor(colorValue);
        return;
      }
      const newColor = tinycolor__default.default(colorValue);
      if (newColor.isValid()) {
        updateColor(newColor.toString());
      }
    };
    const onBlurInput = (event) => {
      const newColor = tinycolor__default.default(value);
      if (!newColor.isValid()) {
        setValue(color);
      }
      onBlur == null ? void 0 : onBlur(event);
    };
    return /* @__PURE__ */ jsxRuntime.jsx(
      Input,
      {
        ...inputProps,
        value,
        onChange: onChangeColor,
        disabled,
        onClick,
        onBlur: onBlurInput,
        addonBefore: /* @__PURE__ */ jsxRuntime.jsx(ColorPreview, { onClick, ariaLabel: buttonAriaLabel, disabled, color }),
        ref
      }
    );
  }
);
ColorInput.displayName = "ColorInput";
const ColorPreview = ({ color, onClick, disabled, ariaLabel }) => {
  const styles = useStyles2(getColorPreviewStyles);
  return /* @__PURE__ */ jsxRuntime.jsx(
    "button",
    {
      type: "button",
      onClick,
      "aria-label": ariaLabel,
      disabled: disabled || !onClick,
      className: css.cx(
        styles,
        css.css({
          backgroundColor: color
        })
      )
    }
  );
};
const getColorPreviewStyles = (theme) => css.css({
  height: "100%",
  width: `${theme.spacing.gridSize * 4}px`,
  borderRadius: `${theme.shape.radius.default} 0 0 ${theme.shape.radius.default}`,
  border: `1px solid ${theme.colors.border.medium}`
});

const SpectrumPalette = ({ color, onChange }) => {
  const [currentColor, setColor] = React.useState(color);
  reactUse.useThrottleFn(
    (c) => {
      onChange(data.colorManipulator.asHexString(theme.visualization.getColorByName(c)));
    },
    500,
    [currentColor]
  );
  const theme = useTheme2();
  const styles = useStyles2(getStyles$W);
  const rgbaString = React.useMemo(() => {
    return currentColor.startsWith("rgba") ? currentColor : tinycolor__default.default(theme.visualization.getColorByName(color)).toRgbString();
  }, [currentColor, theme, color]);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.wrapper, children: [
    /* @__PURE__ */ jsxRuntime.jsx(reactColorful.RgbaStringColorPicker, { className: styles.root, color: rgbaString, onChange: setColor }),
    /* @__PURE__ */ jsxRuntime.jsx(ColorInput, { theme, color: rgbaString, onChange: setColor, className: styles.colorInput })
  ] });
};
const getStyles$W = (theme) => ({
  wrapper: css.css({
    flexGrow: 1
  }),
  root: css.css({
    "&.react-colorful": {
      width: "auto"
    },
    ".react-colorful": {
      "&__saturation": {
        borderRadius: `${theme.shape.radius.default} ${theme.shape.radius.default} 0 0`
      },
      "&__alpha": {
        borderRadius: `0 0 ${theme.shape.radius.default} ${theme.shape.radius.default}`
      },
      "&__alpha, &__hue": {
        height: theme.spacing(2),
        position: "relative"
      },
      "&__pointer": {
        height: theme.spacing(2),
        width: theme.spacing(2)
      }
    }
  }),
  colorInput: css.css({
    marginTop: theme.spacing(2)
  })
});

class UnThemedColorPickerPopover extends React.Component {
  constructor(props) {
    super(props);
    this.handleChange = (color) => {
      const { onChange, enableNamedColors, theme } = this.props;
      if (enableNamedColors) {
        return onChange(color);
      }
      onChange(data.colorManipulator.asHexString(theme.visualization.getColorByName(color)));
    };
    this.onTabChange = (tab) => {
      return () => this.setState({ activePicker: tab });
    };
    this.renderPicker = () => {
      const { activePicker } = this.state;
      const { color } = this.props;
      switch (activePicker) {
        case "spectrum":
          return /* @__PURE__ */ jsxRuntime.jsx(SpectrumPalette, { color, onChange: this.handleChange });
        case "palette":
          return /* @__PURE__ */ jsxRuntime.jsx(NamedColorsPalette, { color, onChange: this.handleChange });
        default:
          return this.renderCustomPicker(activePicker);
      }
    };
    this.renderCustomPicker = (tabKey) => {
      const { customPickers, color, theme } = this.props;
      if (!customPickers) {
        return null;
      }
      return React__namespace.createElement(customPickers[tabKey].tabComponent, {
        color,
        theme,
        onChange: this.handleChange
      });
    };
    this.renderCustomPickerTabs = () => {
      const { customPickers } = this.props;
      if (!customPickers) {
        return null;
      }
      return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: Object.keys(customPickers).map((key) => {
        return /* @__PURE__ */ jsxRuntime.jsx(Tab, { label: customPickers[key].name, onChangeTab: this.onTabChange(key) }, key);
      }) });
    };
    this.state = {
      activePicker: "palette"
    };
  }
  render() {
    const { theme } = this.props;
    const { activePicker } = this.state;
    const styles = getStyles$V(theme);
    return /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, restoreFocus: true, autoFocus: true, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { tabIndex: -1, className: styles.colorPickerPopover, children: [
      /* @__PURE__ */ jsxRuntime.jsxs(TabsBar, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          Tab,
          {
            label: t("grafana-ui.color-picker-popover.palette-tab", "Colors"),
            onChangeTab: this.onTabChange("palette"),
            active: activePicker === "palette"
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx(
          Tab,
          {
            label: t("grafana-ui.color-picker-popover.spectrum-tab", "Custom"),
            onChangeTab: this.onTabChange("spectrum"),
            active: activePicker === "spectrum"
          }
        ),
        this.renderCustomPickerTabs()
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.colorPickerPopoverContent, children: this.renderPicker() })
    ] }) });
  }
}
const ColorPickerPopover = withTheme2(UnThemedColorPickerPopover);
ColorPickerPopover.displayName = "ColorPickerPopover";
const getStyles$V = stylesFactory((theme) => {
  return {
    colorPickerPopover: css.css({
      borderRadius: theme.shape.radius.default,
      boxShadow: theme.shadows.z3,
      background: theme.colors.background.elevated,
      padding: theme.spacing(0.5),
      border: `1px solid ${theme.colors.border.weak}`
    }),
    colorPickerPopoverContent: css.css({
      width: "246px",
      fontSize: theme.typography.bodySmall.fontSize,
      minHeight: "184px",
      height: "290px",
      padding: theme.spacing(1),
      display: "flex",
      flexDirection: "column"
    }),
    colorPickerPopoverTabs: css.css({
      display: "flex",
      width: "100%",
      borderRadius: `${theme.shape.radius.default} ${theme.shape.radius.default} 0 0`
    })
  };
});

const FieldValidationMessage = ({
  children,
  horizontal,
  className
}) => {
  const styles = useStyles2(getFieldValidationMessageStyles);
  const cssName = css.cx(horizontal ? styles.horizontal : styles.vertical, className);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { role: "alert", className: cssName, children: [
    /* @__PURE__ */ jsxRuntime.jsx(Icon, { className: styles.fieldValidationMessageIcon, name: "exclamation-triangle" }),
    children
  ] });
};
const getFieldValidationMessageStyles = (theme) => {
  const baseStyle = `
      font-size: ${theme.typography.size.sm};
      font-weight: ${theme.typography.fontWeightMedium};
      padding: ${theme.spacing(0.5, 1)};
      color: ${theme.colors.error.contrastText};
      background: ${theme.colors.error.main};
      border-radius: ${theme.shape.radius.default};
      position: relative;
      display: inline-block;
      align-self: flex-start;

      a {
        color: ${theme.colors.error.contrastText};
        text-decoration: underline;
      }

      a:hover {
        text-decoration: none;
      }
    `;
  return {
    vertical: css.css(baseStyle, {
      margin: theme.spacing(0.5, 0, 0, 0),
      "&:before": {
        content: '""',
        position: "absolute",
        left: "9px",
        top: "-5px",
        width: 0,
        height: 0,
        borderWidth: "0 4px 5px 4px",
        borderColor: `transparent transparent ${theme.colors.error.main} transparent`,
        borderStyle: "solid"
      }
    }),
    horizontal: css.css(baseStyle, {
      marginLeft: "10px",
      "&:before": {
        content: '""',
        position: "absolute",
        left: "-5px",
        top: "9px",
        width: 0,
        height: 0,
        borderWidth: "4px 5px 4px 0",
        borderColor: "transparent #e02f44 transparent transparent",
        borderStyle: "solid"
      }
    }),
    fieldValidationMessageIcon: css.css({
      marginRight: theme.spacing()
    })
  };
};

const InlineLabel = ({
  children,
  className,
  tooltip,
  width,
  transparent,
  interactive,
  as: Component = "label",
  ...rest
}) => {
  const styles = useStyles2(getInlineLabelStyles, transparent, width);
  return /* @__PURE__ */ jsxRuntime.jsxs(Component, { className: css.cx(styles.label, className), ...rest, children: [
    children,
    tooltip && /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { interactive, placement: "top", content: tooltip, theme: "info", children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { tabIndex: 0, name: "info-circle", size: "sm", className: styles.icon }) })
  ] });
};
const getInlineLabelStyles = (theme, transparent = false, width) => {
  return {
    label: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "space-between",
      flexShrink: 0,
      padding: theme.spacing(0, 1),
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.size.sm,
      backgroundColor: transparent ? "transparent" : theme.colors.background.secondary,
      height: theme.spacing(theme.components.height.md),
      lineHeight: theme.spacing(theme.components.height.md),
      marginRight: theme.spacing(0.5),
      borderRadius: theme.shape.radius.default,
      border: "none",
      width: width ? width !== "auto" ? `${8 * width}px` : width : "100%",
      color: theme.colors.text.primary
    }),
    icon: css.css({
      color: theme.colors.text.secondary,
      marginLeft: "10px",
      ":hover": {
        color: theme.colors.text.primary
      }
    })
  };
};

const InlineField = ({
  children,
  label,
  tooltip,
  labelWidth = "auto",
  invalid,
  loading,
  disabled,
  required,
  className,
  htmlFor,
  grow,
  shrink,
  error,
  transparent,
  interactive,
  validationMessageHorizontalOverflow,
  ...htmlProps
}) => {
  const theme = useTheme2();
  const styles = getStyles$U(theme, grow, shrink);
  const inputId = htmlFor != null ? htmlFor : getChildId(children);
  const labelElement = typeof label === "string" ? /* @__PURE__ */ jsxRuntime.jsx(
    InlineLabel,
    {
      interactive,
      width: labelWidth,
      tooltip,
      htmlFor: inputId,
      transparent,
      children: `${label}${required ? " *" : ""}`
    }
  ) : label;
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.container, className), ...htmlProps, children: [
    labelElement,
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.childContainer, children: [
      React.cloneElement(children, { invalid, disabled, loading }),
      invalid && error && /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          className: css.cx(styles.fieldValidationWrapper, {
            [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
          }),
          children: /* @__PURE__ */ jsxRuntime.jsx(FieldValidationMessage, { children: error })
        }
      )
    ] })
  ] });
};
InlineField.displayName = "InlineField";
const getStyles$U = (theme, grow, shrink) => {
  return {
    container: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "flex-start",
      textAlign: "left",
      position: "relative",
      flex: `${grow ? 1 : 0} ${shrink ? 1 : 0} auto`,
      margin: `0 ${theme.spacing(0.5)} ${theme.spacing(0.5)} 0`
    }),
    childContainer: css.css({
      flex: `${grow ? 1 : 0} ${shrink ? 1 : 0} auto`
    }),
    fieldValidationWrapper: css.css({
      marginTop: theme.spacing(0.5)
    }),
    validationMessageHorizontalOverflow: css.css({
      width: 0,
      overflowX: "visible",
      "& > *": {
        whiteSpace: "nowrap"
      }
    })
  };
};

const Switch = React.forwardRef(
  ({ value, checked, onChange, id, label, disabled, invalid = false, ...inputProps }, ref) => {
    if (checked) {
      data.deprecationWarning("Switch", "checked prop", "value");
    }
    const styles = useStyles2(getSwitchStyles);
    const switchIdRef = React.useRef(id ? id : lodash.uniqueId("switch-"));
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.switch, invalid && styles.invalid), children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        "input",
        {
          type: "checkbox",
          role: "switch",
          disabled,
          checked: value,
          onChange: (event) => {
            !disabled && (onChange == null ? void 0 : onChange(event));
          },
          id: switchIdRef.current,
          ...inputProps,
          ref
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("label", { htmlFor: switchIdRef.current, "aria-label": label, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "check", size: "xs" }) })
    ] });
  }
);
Switch.displayName = "Switch";
const InlineSwitch = React.forwardRef(
  ({ transparent, className, showLabel, label, value, id, invalid, ...props }, ref) => {
    const styles = useStyles2(getSwitchStyles, transparent);
    return /* @__PURE__ */ jsxRuntime.jsxs(
      "div",
      {
        className: css.cx(styles.inlineContainer, className, props.disabled && styles.disabled, invalid && styles.invalid),
        children: [
          showLabel && /* @__PURE__ */ jsxRuntime.jsx(
            "label",
            {
              htmlFor: id,
              className: css.cx(styles.inlineLabel, value && styles.inlineLabelEnabled, "inline-switch-label"),
              children: label
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsx(Switch, { ...props, id, label, ref, value })
        ]
      }
    );
  }
);
InlineSwitch.displayName = "Switch";
const getSwitchStyles = (theme, transparent) => ({
  switch: css.css({
    width: theme.spacing(4),
    height: theme.spacing(2),
    position: "relative",
    lineHeight: 1,
    input: {
      height: "100%",
      width: "100% !important",
      opacity: 0,
      zIndex: -1e3,
      position: "absolute",
      "&:checked + label": {
        background: theme.colors.primary.main,
        borderColor: theme.colors.primary.main,
        "&:hover": {
          background: theme.colors.primary.shade
        },
        svg: {
          transform: `translate3d(${theme.spacing(2.25)}, -50%, 0)`,
          background: theme.colors.primary.contrastText,
          color: theme.colors.primary.main
        }
      },
      "&:disabled + label": {
        background: theme.colors.action.disabledBackground,
        borderColor: theme.colors.border.weak,
        cursor: "not-allowed",
        svg: {
          background: theme.colors.text.disabled
        }
      },
      "&:disabled:checked + label": {
        background: theme.colors.primary.transparent,
        svg: {
          color: theme.colors.primary.contrastText
        }
      },
      "&:focus + label, &:focus-visible + label": getFocusStyles(theme),
      "&:focus:not(:focus-visible) + label": getMouseFocusStyles()
    },
    label: {
      width: "100%",
      height: "100%",
      cursor: "pointer",
      borderRadius: theme.shape.radius.pill,
      background: theme.components.input.background,
      border: `1px solid ${theme.components.input.borderColor}`,
      transition: "all 0.3s ease",
      "&:hover": {
        borderColor: theme.components.input.borderHover
      },
      svg: {
        position: "absolute",
        display: "block",
        color: "transparent",
        width: theme.spacing(1.5),
        height: theme.spacing(1.5),
        borderRadius: theme.shape.radius.circle,
        background: theme.colors.text.secondary,
        boxShadow: theme.shadows.z1,
        left: 0,
        top: "50%",
        transform: `translate3d(${theme.spacing(0.25)}, -50%, 0)`,
        transition: "transform 0.2s cubic-bezier(0.19, 1, 0.22, 1)",
        "@media (forced-colors: active)": {
          border: `1px solid ${theme.colors.primary.contrastText}`
        }
      }
    }
  }),
  inlineContainer: css.css({
    padding: theme.spacing(0, 1),
    height: theme.spacing(theme.components.height.md),
    display: "inline-flex",
    alignItems: "center",
    background: transparent ? "transparent" : theme.components.input.background,
    border: `1px solid ${transparent ? "transparent" : theme.components.input.borderColor}`,
    borderRadius: theme.shape.radius.default,
    "&:hover": {
      border: `1px solid ${transparent ? "transparent" : theme.components.input.borderHover}`,
      ".inline-switch-label": {
        color: theme.colors.text.primary
      }
    }
  }),
  disabled: css.css({
    backgroundColor: "rgba(204, 204, 220, 0.04)",
    color: "rgba(204, 204, 220, 0.6)",
    border: "1px solid rgba(204, 204, 220, 0.04)"
  }),
  inlineLabel: css.css({
    cursor: "pointer",
    paddingRight: theme.spacing(1),
    color: theme.colors.text.secondary,
    whiteSpace: "nowrap"
  }),
  inlineLabelEnabled: css.css({
    color: theme.colors.text.primary
  }),
  invalid: css.css({
    "input + label, input:checked + label, input:hover + label": {
      border: `1px solid ${theme.colors.error.border}`
    }
  })
});

const SeriesColorPickerPopover = (props) => {
  const { yaxis, onToggleAxis, color, ...colorPickerProps } = props;
  const yAxisLabel = t("grafana-ui.series-color-picker-popover.y-axis-usage", "Use right y-axis");
  const customPickers = onToggleAxis ? {
    yaxis: {
      name: "Y-Axis",
      tabComponent() {
        return /* @__PURE__ */ jsxRuntime.jsx(InlineField, { labelWidth: 20, label: yAxisLabel, children: /* @__PURE__ */ jsxRuntime.jsx(InlineSwitch, { value: yaxis === 2, label: yAxisLabel, onChange: onToggleAxis }) });
      }
    }
  } : void 0;
  return /* @__PURE__ */ jsxRuntime.jsx(ColorPickerPopover, { ...colorPickerProps, color: color || "#000000", customPickers });
};
withTheme2(SeriesColorPickerPopover);

const colorPickerFactory = (popover, displayName = "ColorPicker") => {
  var _a;
  return _a = class extends React.Component {
    constructor() {
      super(...arguments);
      this.pickerTriggerRef = React.createRef();
    }
    render() {
      const { theme, children, onChange, color } = this.props;
      const styles = getStyles$T(theme);
      const popoverElement = React__namespace.createElement(popover, {
        ...{ ...this.props, children: null },
        onChange
      });
      return /* @__PURE__ */ jsxRuntime.jsx(PopoverController, { content: popoverElement, hideAfter: 300, children: (showPopper, hidePopper, popperProps) => {
        return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
          this.pickerTriggerRef.current && /* @__PURE__ */ jsxRuntime.jsx(
            Popover,
            {
              ...popperProps,
              referenceElement: this.pickerTriggerRef.current,
              wrapperClassName: styles.colorPicker,
              onMouseLeave: hidePopper,
              onMouseEnter: showPopper,
              onKeyDown: (event) => closePopover(event, hidePopper)
            }
          ),
          children ? children({
            ref: this.pickerTriggerRef,
            showColorPicker: showPopper,
            hideColorPicker: hidePopper
          }) : /* @__PURE__ */ jsxRuntime.jsx(
            ColorSwatch,
            {
              ref: this.pickerTriggerRef,
              onClick: showPopper,
              onMouseLeave: hidePopper,
              color: theme.visualization.getColorByName(color || "#000000"),
              "aria-label": color
            }
          )
        ] });
      } });
    }
  }, _a.displayName = displayName, _a;
};
withTheme2(colorPickerFactory(ColorPickerPopover, "ColorPicker"));
const SeriesColorPicker = withTheme2(colorPickerFactory(SeriesColorPickerPopover, "SeriesColorPicker"));
const getStyles$T = stylesFactory((theme) => {
  return {
    colorPicker: css.css({
      position: "absolute",
      zIndex: theme.zIndex.tooltip,
      color: theme.colors.text.primary,
      maxWidth: "400px",
      fontSize: theme.typography.size.sm
    })
  };
});

class ClickOutsideWrapper extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.myRef = React.createRef();
    this.state = {
      hasEventListener: false
    };
    this.onOutsideClick = (event) => {
      const domNode = this.myRef.current;
      if (!domNode || event.target instanceof Node && !domNode.contains(event.target)) {
        this.props.onClick();
      }
    };
  }
  componentDidMount() {
    this.props.parent.addEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.addEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  componentWillUnmount() {
    this.props.parent.removeEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.removeEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  render() {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ref: this.myRef, children: this.props.children });
  }
}
ClickOutsideWrapper.defaultProps = {
  includeButtonPress: true,
  parent: typeof window !== "undefined" ? window : void 0,
  useCapture: false
};

const ColorPickerInput = React.forwardRef(
  ({ value = "", onChange, returnColorAs = "rgb", ...inputProps }, ref) => {
    const [currentColor, setColor] = React.useState(value);
    const [isOpen, setIsOpen] = React.useState(false);
    const theme = useTheme2();
    const styles = useStyles2(getStyles$S);
    const paletteStyles = useStyles2(getStyles$W);
    reactUse.useThrottleFn(
      (c) => {
        if (c === value) {
          return;
        }
        if (!c) {
          onChange("");
          return;
        }
        const color = theme.visualization.getColorByName(c);
        if (returnColorAs === "rgb") {
          onChange(data.colorManipulator.asRgbString(color));
        } else {
          onChange(data.colorManipulator.asHexString(color));
        }
      },
      500,
      [currentColor]
    );
    const handleBlur = (evt) => {
      var _a;
      const isClickInPopover = (_a = document.querySelector('[data-testid="color-popover"]')) == null ? void 0 : _a.contains(evt.relatedTarget);
      if (!isClickInPopover) {
        setIsOpen(false);
      }
    };
    return /* @__PURE__ */ jsxRuntime.jsx(ClickOutsideWrapper, { onClick: () => setIsOpen(false), children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.wrapper, children: [
      isOpen && !inputProps.disabled && /* @__PURE__ */ jsxRuntime.jsx(
        reactColorful.RgbaStringColorPicker,
        {
          "data-testid": "color-popover",
          color: currentColor,
          onChange: setColor,
          className: css.cx(paletteStyles.root, styles.picker)
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        ColorInput,
        {
          ...inputProps,
          theme,
          color: currentColor,
          onChange: setColor,
          buttonAriaLabel: "Open color picker",
          onClick: () => setIsOpen(true),
          onBlur: (e) => handleBlur(e),
          ref,
          isClearable: true
        }
      )
    ] }) });
  }
);
ColorPickerInput.displayName = "ColorPickerInput";
const getStyles$S = (theme) => {
  return {
    wrapper: css.css({
      position: "relative"
    }),
    picker: css.css({
      "&.react-colorful": {
        position: "absolute",
        width: "100%",
        zIndex: 11,
        bottom: "36px"
      }
    }),
    inner: css.css({
      position: "absolute"
    })
  };
};

class StatsPicker extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.checkInput = () => {
      const { stats, allowMultiple, defaultStat, onChange } = this.props;
      const current = data.fieldReducers.list(stats);
      if (current.length !== stats.length) {
        const found = current.map((v) => v.id);
        const notFound = lodash.difference(stats, found);
        console.warn("Unknown stats", notFound, stats);
        onChange(current.map((stat) => stat.id));
      }
      if (!allowMultiple && stats.length > 1) {
        console.warn("Removing extra stat", stats);
        onChange([stats[0]]);
      }
      if (defaultStat && stats.length < 1) {
        onChange([defaultStat]);
      }
    };
    this.onSelectionChange = (item) => {
      const { onChange } = this.props;
      if (Array.isArray(item)) {
        onChange(item.map((v) => v.value));
      } else {
        onChange(item && item.value ? [item.value] : []);
      }
    };
  }
  componentDidMount() {
    this.checkInput();
  }
  componentDidUpdate(prevProps) {
    this.checkInput();
  }
  render() {
    const { stats, allowMultiple, defaultStat, placeholder, className, menuPlacement, width, inputId, filterOptions } = this.props;
    const select = data.fieldReducers.selectOptions(stats, filterOptions);
    return /* @__PURE__ */ jsxRuntime.jsx(
      Select,
      {
        value: select.current,
        className,
        isClearable: !defaultStat,
        isMulti: allowMultiple,
        width,
        isSearchable: true,
        options: select.options,
        placeholder,
        onChange: this.onSelectionChange,
        menuPlacement,
        inputId
      }
    );
  }
}
StatsPicker.defaultProps = {
  allowMultiple: false
};

const ButtonSelectComponent = (props) => {
  const { className, options, value, onChange, narrow, variant, ...restProps } = props;
  const styles = useStyles2(getStyles$R);
  const [isOpen, setIsOpen] = React.useState(false);
  const middleware = [
    react.offset(0),
    react.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react.shift()
  ];
  const { context, refs, floatingStyles } = react.useFloating({
    open: isOpen,
    placement: "bottom-end",
    onOpenChange: setIsOpen,
    middleware,
    whileElementsMounted: react.autoUpdate
  });
  const click = react.useClick(context);
  const dismiss = react.useDismiss(context);
  const { getReferenceProps, getFloatingProps } = react.useInteractions([dismiss, click]);
  const onChangeInternal = (item) => {
    onChange(item);
    setIsOpen(false);
  };
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.wrapper, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      ToolbarButton,
      {
        className,
        isOpen,
        narrow,
        variant,
        ref: refs.setReference,
        ...getReferenceProps(),
        ...restProps,
        children: (value == null ? void 0 : value.label) || ((value == null ? void 0 : value.value) != null ? String(value == null ? void 0 : value.value) : null)
      }
    ),
    isOpen && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.menuWrapper, ref: refs.setFloating, ...getFloatingProps(), style: floatingStyles, children: /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true, children: /* @__PURE__ */ jsxRuntime.jsx(Menu, { tabIndex: -1, onClose: () => setIsOpen(false), children: options.map((item) => {
      var _a;
      return /* @__PURE__ */ jsxRuntime.jsx(
        MenuItem,
        {
          label: (_a = item.label) != null ? _a : String(item.value),
          onClick: () => onChangeInternal(item),
          active: item.value === (value == null ? void 0 : value.value),
          ariaChecked: item.value === (value == null ? void 0 : value.value),
          ariaLabel: item.ariaLabel || item.label,
          disabled: item.isDisabled,
          component: item.component,
          role: "menuitemradio"
        },
        `${item.value}`
      );
    }) }) }) })
  ] });
};
ButtonSelectComponent.displayName = "ButtonSelect";
const ButtonSelect = React.memo(ButtonSelectComponent);
const getStyles$R = (theme) => {
  return {
    wrapper: css.css({
      position: "relative",
      display: "inline-flex"
    }),
    menuWrapper: css.css({
      zIndex: theme.zIndex.dropdown
    })
  };
};

const defaultIntervals = ["5s", "10s", "30s", "1m", "5m", "15m", "30m", "1h", "2h", "1d"];
const _RefreshPicker = class _RefreshPicker extends React.PureComponent {
  constructor(props) {
    super(props);
    this.onChangeSelect = (item) => {
      const { onIntervalChanged } = this.props;
      if (onIntervalChanged && item.value != null) {
        onIntervalChanged(item.value);
      }
    };
  }
  getVariant() {
    if (this.props.isLive) {
      return "primary";
    }
    if (this.props.primary) {
      return "primary";
    }
    return this.props.isOnCanvas ? "canvas" : "default";
  }
  render() {
    const { onRefresh, intervals, tooltip, value, text, isLoading, noIntervalPicker, width, showAutoInterval } = this.props;
    const currentValue = value || "";
    const variant = this.getVariant();
    const options = intervalsToOptions({ intervals, showAutoInterval });
    const option = options.find(({ value: value2 }) => value2 === currentValue);
    const translatedOffOption = translateOption(_RefreshPicker.offOption.value);
    let selectedValue = option || translatedOffOption;
    if (selectedValue.label === translatedOffOption.label) {
      selectedValue = { value: "" };
    }
    const durationAriaLabel = selectedValue.ariaLabel;
    const ariaLabelDurationSelectedMessage = t(
      "refresh-picker.aria-label.duration-selected",
      "Choose refresh time interval with current interval {{durationAriaLabel}} selected",
      { durationAriaLabel }
    );
    const ariaLabelChooseIntervalMessage = t(
      "refresh-picker.aria-label.choose-interval",
      "Auto refresh turned off. Choose refresh time interval"
    );
    const ariaLabel = selectedValue.value === "" ? ariaLabelChooseIntervalMessage : ariaLabelDurationSelectedMessage;
    const tooltipIntervalSelected = t("refresh-picker.tooltip.interval-selected", "Set auto refresh interval");
    const tooltipAutoRefreshOff = t("refresh-picker.tooltip.turned-off", "Auto refresh off");
    const tooltipAutoRefresh = selectedValue.value === "" ? tooltipAutoRefreshOff : tooltipIntervalSelected;
    return /* @__PURE__ */ jsxRuntime.jsxs(ButtonGroup, { className: "refresh-picker", children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ToolbarButton,
        {
          "aria-label": text,
          tooltip,
          onClick: onRefresh,
          variant,
          icon: isLoading ? "spinner" : "sync",
          style: width ? { width } : void 0,
          "data-testid": e2eSelectors.selectors.components.RefreshPicker.runButtonV2,
          children: text
        }
      ),
      !noIntervalPicker && /* @__PURE__ */ jsxRuntime.jsx(
        ButtonSelect,
        {
          className: css.css({
            borderTopLeftRadius: 0,
            borderBottomLeftRadius: 0
          }),
          value: selectedValue,
          options,
          onChange: this.onChangeSelect,
          variant,
          "data-testid": e2eSelectors.selectors.components.RefreshPicker.intervalButtonV2,
          "aria-label": ariaLabel,
          tooltip: tooltipAutoRefresh
        }
      )
    ] });
  }
};
_RefreshPicker.offOption = {
  label: "Off",
  value: "",
  ariaLabel: "Turn off auto refresh"
};
_RefreshPicker.liveOption = {
  label: "Live",
  value: "LIVE",
  ariaLabel: "Turn on live streaming"
};
_RefreshPicker.autoOption = {
  label: "Auto",
  value: "auto",
  ariaLabel: "Select refresh from the query range"
};
_RefreshPicker.isLive = (refreshInterval) => refreshInterval === _RefreshPicker.liveOption.value;
let RefreshPicker = _RefreshPicker;
function translateOption(option) {
  switch (option) {
    case RefreshPicker.liveOption.value:
      return {
        label: t("refresh-picker.live-option.label", "Live"),
        value: option,
        ariaLabel: t("refresh-picker.live-option.aria-label", "Turn on live streaming")
      };
    case RefreshPicker.offOption.value:
      return {
        label: t("refresh-picker.off-option.label", "Off"),
        value: option,
        ariaLabel: t("refresh-picker.off-option.aria-label", "Turn off auto refresh")
      };
    case RefreshPicker.autoOption.value:
      return {
        label: t("refresh-picker.auto-option.label", RefreshPicker.autoOption.label),
        value: option,
        ariaLabel: t("refresh-picker.auto-option.aria-label", RefreshPicker.autoOption.ariaLabel)
      };
  }
  return {
    label: option,
    value: option
  };
}
function intervalsToOptions({
  intervals = defaultIntervals,
  showAutoInterval = false
} = {}) {
  const options = intervals.map((interval) => {
    const duration = data.parseDuration(interval);
    const ariaLabel = dateFns.formatDuration(duration);
    return {
      label: interval,
      value: interval,
      ariaLabel
    };
  });
  if (showAutoInterval) {
    options.unshift(translateOption(RefreshPicker.autoOption.value));
  }
  options.unshift(translateOption(RefreshPicker.offOption.value));
  return options;
}

const getModalStyles = (theme) => {
  const borderRadius = theme.shape.radius.default;
  return {
    modal: css.css({
      position: "fixed",
      zIndex: theme.zIndex.modal,
      background: theme.colors.background.primary,
      boxShadow: theme.shadows.z3,
      borderRadius,
      border: `1px solid ${theme.colors.border.weak}`,
      backgroundClip: "padding-box",
      outline: "none",
      width: "750px",
      maxWidth: "100%",
      left: 0,
      right: 0,
      marginLeft: "auto",
      marginRight: "auto",
      top: "10%",
      maxHeight: "80%",
      display: "flex",
      flexDirection: "column"
    }),
    modalBackdrop: css.css({
      position: "fixed",
      zIndex: theme.zIndex.modalBackdrop,
      top: 0,
      right: 0,
      bottom: 0,
      left: 0,
      backgroundColor: theme.components.overlay.background
    }),
    modalHeader: css.css({
      label: "modalHeader",
      display: "flex",
      alignItems: "center",
      minHeight: "42px",
      margin: theme.spacing(1, 2, 0, 2)
    }),
    modalHeaderWithTabs: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`
    }),
    modalHeaderTitle: css.css({
      fontSize: theme.typography.size.lg,
      margin: theme.spacing(0, 4, 0, 1),
      display: "flex",
      alignItems: "center",
      position: "relative",
      top: "2px"
    }),
    modalHeaderIcon: css.css({
      marginRight: theme.spacing(2),
      fontSize: "inherit",
      "&:before": {
        verticalAlign: "baseline"
      }
    }),
    modalHeaderClose: css.css({
      height: "100%",
      display: "flex",
      alignItems: "center",
      color: theme.colors.text.secondary,
      flexGrow: 1,
      justifyContent: "flex-end"
    }),
    modalContent: css.css({
      overflow: "auto",
      padding: theme.spacing(3),
      width: "100%"
    }),
    modalButtonRow: css.css({
      paddingTop: theme.spacing(3)
    })
  };
};

function useCombinedRefs(...refs) {
  const targetRef = React__namespace.useRef(null);
  React__namespace.useEffect(() => {
    refs.forEach((ref) => {
      if (!ref) {
        return;
      }
      if (typeof ref === "function") {
        ref(targetRef.current);
      } else {
        ref.current = targetRef.current;
      }
    });
  }, [refs]);
  return targetRef;
}

const FilterInput = React.forwardRef(
  ({ value, width, onChange, escapeRegex = true, ...restProps }, ref) => {
    const innerRef = React.useRef(null);
    const combinedRef = useCombinedRefs(ref, innerRef);
    const suffix = value !== "" ? /* @__PURE__ */ jsxRuntime.jsx(
      Button,
      {
        icon: "times",
        fill: "text",
        size: "sm",
        onClick: (e) => {
          var _a;
          (_a = innerRef.current) == null ? void 0 : _a.focus();
          onChange("");
          e.stopPropagation();
        },
        children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.filter-input.clear", children: "Clear" })
      }
    ) : null;
    return /* @__PURE__ */ jsxRuntime.jsx(
      Input,
      {
        prefix: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "search" }),
        suffix,
        width,
        type: "text",
        value: escapeRegex ? data.unEscapeStringFromRegex(value != null ? value : "") : value,
        onChange: (event) => onChange(escapeRegex ? data.escapeStringForRegex(event.currentTarget.value) : event.currentTarget.value),
        ...restProps,
        ref: combinedRef
      }
    );
  }
);
FilterInput.displayName = "FilterInput";

const AutoSizeInput = React__namespace.forwardRef((props, ref) => {
  const {
    defaultValue = "",
    minWidth = 10,
    maxWidth,
    onCommitChange,
    onChange,
    onKeyDown,
    onBlur,
    value: controlledValue,
    placeholder,
    ...restProps
  } = props;
  const [inputState, setInputValue] = useControlledState(controlledValue, onChange);
  const inputValue = inputState != null ? inputState : defaultValue;
  const inputWidth = React.useMemo(() => {
    const displayValue = inputValue || placeholder || "";
    const valueString = typeof displayValue === "string" ? displayValue : displayValue.toString();
    return getWidthFor(valueString, minWidth, maxWidth);
  }, [placeholder, inputValue, minWidth, maxWidth]);
  return /* @__PURE__ */ jsxRuntime.jsx(AutoSizeInputContext.Provider, { value: true, children: /* @__PURE__ */ jsxRuntime.jsx(
    Input,
    {
      "data-testid": "autosize-input",
      ...restProps,
      placeholder,
      ref,
      value: inputValue.toString(),
      onChange: (event) => {
        if (onChange) {
          onChange(event);
        }
        setInputValue(event.currentTarget.value);
      },
      width: inputWidth,
      onBlur: (event) => {
        if (onBlur) {
          onBlur(event);
        } else if (onCommitChange) {
          onCommitChange(event);
        }
      },
      onKeyDown: (event) => {
        if (onKeyDown) {
          onKeyDown(event);
        } else if (event.key === "Enter" && onCommitChange) {
          onCommitChange(event);
        }
      }
    }
  ) });
});
function getWidthFor(value, minWidth, maxWidth) {
  if (!value) {
    return minWidth;
  }
  const extraSpace = 3;
  const realWidth = measureText(value.toString(), 14).width / 8 + extraSpace;
  if (minWidth && realWidth < minWidth) {
    return minWidth;
  }
  if (maxWidth && realWidth > maxWidth) {
    return maxWidth;
  }
  return realWidth;
}
AutoSizeInput.displayName = "AutoSizeInput";
function useControlledState(controlledValue, onChange) {
  const isControlledNow = controlledValue !== void 0 && onChange !== void 0;
  const isControlledRef = React.useRef(isControlledNow);
  const hasLoggedControlledWarning = React.useRef(false);
  if (isControlledNow !== isControlledRef.current && !hasLoggedControlledWarning.current) {
    console.warn(
      "An AutoSizeInput is changing from an uncontrolled to a controlled input. If you want to control the input, the empty value should be an empty string."
    );
    hasLoggedControlledWarning.current = true;
  }
  const [internalValue, setInternalValue] = React__namespace.useState(controlledValue);
  React.useEffect(() => {
    if (!isControlledRef.current) {
      setInternalValue(controlledValue);
    }
  }, [controlledValue]);
  const handleChange = React.useCallback((newValue) => {
    if (!isControlledRef.current) {
      setInternalValue(newValue);
    }
  }, []);
  const value = isControlledRef.current ? controlledValue : internalValue;
  return [value, handleChange];
}

const Label$1 = ({ children, description, className, category, ...labelProps }) => {
  const styles = useStyles2(getLabelStyles$3);
  const categories = category == null ? void 0 : category.map((c, i) => {
    return /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.categories, children: [
      /* @__PURE__ */ jsxRuntime.jsx("span", { children: c }),
      /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right", className: styles.chevron })
    ] }, `${c}/${i}`);
  });
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.label, className), children: /* @__PURE__ */ jsxRuntime.jsxs("label", { ...labelProps, children: [
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.labelContent, children: [
      categories,
      children
    ] }),
    description && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.description, children: description })
  ] }) });
};
const getLabelStyles$3 = (theme) => ({
  label: css.css({
    label: "Label",
    fontSize: theme.typography.size.sm,
    fontWeight: theme.typography.fontWeightMedium,
    lineHeight: 1.25,
    marginBottom: theme.spacing(0.5),
    color: theme.colors.text.primary,
    maxWidth: "480px"
  }),
  labelContent: css.css({
    display: "flex",
    alignItems: "center"
  }),
  description: css.css({
    label: "Label-description",
    color: theme.colors.text.secondary,
    fontSize: theme.typography.size.sm,
    fontWeight: theme.typography.fontWeightRegular,
    marginTop: theme.spacing(0.25),
    display: "block"
  }),
  categories: css.css({
    label: "Label-categories",
    display: "inline-flex",
    alignItems: "center"
  }),
  chevron: css.css({
    margin: theme.spacing(0, 0.25)
  })
});

const Checkbox = React__namespace.forwardRef(
  ({ label, description, value, htmlValue, onChange, disabled, className, indeterminate, invalid, ...inputProps }, ref) => {
    const handleOnChange = React.useCallback(
      (e) => {
        if (onChange) {
          onChange(e);
        }
      },
      [onChange]
    );
    const styles = useStyles2(getCheckboxStyles, invalid);
    const ariaChecked = indeterminate ? "mixed" : void 0;
    return /* @__PURE__ */ jsxRuntime.jsxs("label", { className: css.cx(styles.wrapper, className), children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.checkboxWrapper, children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          "input",
          {
            type: "checkbox",
            className: css.cx(styles.input, indeterminate && styles.inputIndeterminate),
            checked: value,
            disabled,
            onChange: handleOnChange,
            value: htmlValue,
            "aria-checked": ariaChecked,
            ...inputProps,
            ref
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.checkmark })
      ] }),
      label && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.label, children: label }),
      description && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.description, children: description })
    ] });
  }
);
const getCheckboxStyles = (theme, invalid = false) => {
  const labelStyles = getLabelStyles$3(theme);
  const checkboxSize = 2;
  const labelPadding = 1;
  const getBorderColor = (color) => {
    return invalid ? theme.colors.error.border : color;
  };
  return {
    wrapper: css.css({
      display: "inline-grid",
      alignItems: "center",
      columnGap: theme.spacing(labelPadding),
      // gridAutoRows is needed to prevent https://github.com/grafana/grafana/issues/68570 in safari
      gridAutoRows: "max-content",
      position: "relative",
      verticalAlign: "middle"
    }),
    input: css.css({
      position: "absolute",
      zIndex: 1,
      top: 0,
      left: 0,
      width: "100% !important",
      // global styles unset this
      height: "100%",
      opacity: 0,
      "&:focus + span, &:focus-visible + span": getFocusStyles(theme),
      "&:focus:not(:focus-visible) + span": getMouseFocusStyles(),
      /**
       * Using adjacent sibling selector to style checked state.
       * Primarily to limit the classes necessary to use when these classes will be used
       * for angular components styling
       * */
      "&:checked + span": {
        background: theme.colors.primary.main,
        border: `1px solid ${getBorderColor(theme.colors.primary.main)}`,
        "&:hover": {
          background: theme.colors.primary.shade
        },
        "&:after": {
          content: '""',
          position: "absolute",
          zIndex: 2,
          left: theme.spacing(0.5),
          top: 0,
          width: theme.spacing(0.75),
          height: theme.spacing(1.5),
          border: `solid ${theme.colors.primary.contrastText}`,
          borderWidth: "0 3px 3px 0",
          transform: "rotate(45deg)"
        }
      },
      "&:disabled + span": {
        backgroundColor: theme.colors.action.disabledBackground,
        cursor: "not-allowed",
        border: `1px solid ${getBorderColor(theme.colors.action.disabledBackground)}`,
        "&:hover": {
          backgroundColor: theme.colors.action.disabledBackground
        },
        "&:after": {
          borderColor: theme.colors.action.disabledText
        }
      }
    }),
    inputIndeterminate: css.css({
      "&[aria-checked='mixed'] + span": {
        border: `1px solid ${getBorderColor(theme.colors.primary.main)}`,
        background: theme.colors.primary.main,
        "&:hover": {
          background: theme.colors.primary.shade
        },
        "&:after": {
          content: '""',
          position: "absolute",
          zIndex: 2,
          left: "2px",
          right: "2px",
          top: "calc(50% - 1.5px)",
          height: "3px",
          border: `1.5px solid ${theme.colors.primary.contrastText}`,
          backgroundColor: theme.colors.primary.contrastText,
          width: "auto",
          transform: "none"
        }
      },
      "&:disabled[aria-checked='mixed'] + span": {
        backgroundColor: theme.colors.action.disabledBackground,
        border: `1px solid ${getBorderColor(theme.colors.error.transparent)}`,
        "&:after": {
          borderColor: theme.colors.action.disabledText
        }
      }
    }),
    checkboxWrapper: css.css({
      display: "flex",
      alignItems: "center",
      gridColumnStart: 1,
      gridRowStart: 1
    }),
    checkmark: css.css({
      position: "relative",
      zIndex: 2,
      display: "inline-block",
      width: theme.spacing(checkboxSize),
      height: theme.spacing(checkboxSize),
      borderRadius: theme.shape.radius.default,
      background: theme.components.input.background,
      border: `1px solid ${getBorderColor(theme.components.input.borderColor)}`,
      "&:hover": {
        cursor: "pointer",
        borderColor: getBorderColor(theme.components.input.borderHover)
      }
    }),
    label: css.cx(
      labelStyles.label,
      css.css({
        gridColumnStart: 2,
        gridRowStart: 1,
        position: "relative",
        zIndex: 2,
        cursor: "pointer",
        maxWidth: "fit-content",
        lineHeight: theme.typography.bodySmall.lineHeight,
        marginBottom: 0
      })
    ),
    description: css.cx(
      labelStyles.description,
      css.css({
        gridColumnStart: 2,
        gridRowStart: 2,
        lineHeight: theme.typography.bodySmall.lineHeight,
        marginTop: 0,
        // Enable interacting with description when checkbox is disabled
        zIndex: 1
      })
    )
  };
};
Checkbox.displayName = "Checkbox";

new uFuzzy__default.default({ intraMode: 1 });

const Field = React__namespace.forwardRef(
  ({
    label,
    description,
    horizontal,
    invalid,
    loading,
    disabled,
    required,
    error,
    children,
    className,
    validationMessageHorizontalOverflow,
    htmlFor,
    ...otherProps
  }, ref) => {
    const styles = useStyles2(getFieldStyles);
    const inputId = htmlFor != null ? htmlFor : getChildId(children);
    const labelElement = typeof label === "string" ? /* @__PURE__ */ jsxRuntime.jsx(Label$1, { htmlFor: inputId, description, children: `${label}${required ? " *" : ""}` }) : label;
    const childProps = deleteUndefinedProps({ invalid, disabled, loading });
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.field, horizontal && styles.fieldHorizontal, className), ...otherProps, children: [
      labelElement,
      /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntime.jsx("div", { ref, children: React__namespace.cloneElement(children, childProps) }),
        invalid && error && !horizontal && /* @__PURE__ */ jsxRuntime.jsx(
          "div",
          {
            className: css.cx(styles.fieldValidationWrapper, {
              [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
            }),
            children: /* @__PURE__ */ jsxRuntime.jsx(FieldValidationMessage, { children: error })
          }
        )
      ] }),
      invalid && error && horizontal && /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          className: css.cx(styles.fieldValidationWrapper, styles.fieldValidationWrapperHorizontal, {
            [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
          }),
          children: /* @__PURE__ */ jsxRuntime.jsx(FieldValidationMessage, { children: error })
        }
      )
    ] });
  }
);
Field.displayName = "Field";
function deleteUndefinedProps(obj) {
  for (const key in obj) {
    if (obj[key] === void 0) {
      delete obj[key];
    }
  }
  return obj;
}
const getFieldStyles = (theme) => ({
  field: css.css({
    display: "flex",
    flexDirection: "column",
    marginBottom: theme.spacing(2)
  }),
  fieldHorizontal: css.css({
    flexDirection: "row",
    justifyContent: "space-between",
    flexWrap: "wrap"
  }),
  fieldValidationWrapper: css.css({
    marginTop: theme.spacing(0.5)
  }),
  fieldValidationWrapperHorizontal: css.css({
    flex: "1 1 100%"
  }),
  validationMessageHorizontalOverflow: css.css({
    width: 0,
    overflowX: "visible",
    "& > *": {
      whiteSpace: "nowrap"
    }
  })
});

const quickOptions = [
  { from: "now-5m", to: "now", display: "Last 5 minutes" },
  { from: "now-15m", to: "now", display: "Last 15 minutes" },
  { from: "now-30m", to: "now", display: "Last 30 minutes" },
  { from: "now-1h", to: "now", display: "Last 1 hour" },
  { from: "now-3h", to: "now", display: "Last 3 hours" },
  { from: "now-6h", to: "now", display: "Last 6 hours" },
  { from: "now-12h", to: "now", display: "Last 12 hours" },
  { from: "now-24h", to: "now", display: "Last 24 hours" },
  { from: "now-2d", to: "now", display: "Last 2 days" },
  { from: "now-7d", to: "now", display: "Last 7 days" },
  { from: "now-30d", to: "now", display: "Last 30 days" },
  { from: "now-90d", to: "now", display: "Last 90 days" },
  { from: "now-6M", to: "now", display: "Last 6 months" },
  { from: "now-1y", to: "now", display: "Last 1 year" },
  { from: "now-2y", to: "now", display: "Last 2 years" },
  { from: "now-5y", to: "now", display: "Last 5 years" },
  { from: "now-1d/d", to: "now-1d/d", display: "Yesterday" },
  { from: "now-2d/d", to: "now-2d/d", display: "Day before yesterday" },
  { from: "now-7d/d", to: "now-7d/d", display: "This day last week" },
  { from: "now-1w/w", to: "now-1w/w", display: "Previous week" },
  { from: "now-1M/M", to: "now-1M/M", display: "Previous month" },
  { from: "now-1Q/fQ", to: "now-1Q/fQ", display: "Previous fiscal quarter" },
  { from: "now-1y/y", to: "now-1y/y", display: "Previous year" },
  { from: "now-1y/fy", to: "now-1y/fy", display: "Previous fiscal year" },
  { from: "now/d", to: "now/d", display: "Today" },
  { from: "now/d", to: "now", display: "Today so far" },
  { from: "now/w", to: "now/w", display: "This week" },
  { from: "now/w", to: "now", display: "This week so far" },
  { from: "now/M", to: "now/M", display: "This month" },
  { from: "now/M", to: "now", display: "This month so far" },
  { from: "now/y", to: "now/y", display: "This year" },
  { from: "now/y", to: "now", display: "This year so far" },
  { from: "now/fQ", to: "now", display: "This fiscal quarter so far" },
  { from: "now/fQ", to: "now/fQ", display: "This fiscal quarter" },
  { from: "now/fy", to: "now", display: "This fiscal year so far" },
  { from: "now/fy", to: "now/fy", display: "This fiscal year" }
];

const getStyles$Q = (theme) => {
  return {
    text: css.css({
      fontSize: theme.typography.size.md,
      fontWeight: theme.typography.fontWeightMedium,
      color: theme.colors.text.primary,
      margin: 0,
      display: "flex"
    })
  };
};
const TimePickerTitle = React.memo(({ children }) => {
  const styles = useStyles2(getStyles$Q);
  return /* @__PURE__ */ jsxRuntime.jsx("h3", { className: styles.text, children });
});
TimePickerTitle.displayName = "TimePickerTitle";

function isValid(value, roundUp, timeZone) {
  if (data.isDateTime(value)) {
    return value.isValid();
  }
  if (data.dateMath.isMathString(value)) {
    return data.dateMath.isValid(value);
  }
  const parsed = data.dateTimeParse(value, { roundUp, timeZone });
  return parsed.isValid();
}
function isValidTimeRange(range) {
  return data.dateMath.isValid(range.from) && data.dateMath.isValid(range.to);
}

function isWeekStart(value) {
  return ["saturday", "sunday", "monday"].includes(value);
}
function getWeekStart(override) {
  var _a, _b;
  if (override && isWeekStart(override)) {
    return override;
  }
  const preference = (_b = (_a = window == null ? void 0 : window.grafanaBootData) == null ? void 0 : _a.user) == null ? void 0 : _b.weekStart;
  if (preference && isWeekStart(preference)) {
    return preference;
  }
  return "monday";
}

function adjustDateForReactCalendar(date, timeZone) {
  const zone = data.getZone(timeZone);
  if (!zone) {
    return date;
  }
  const timezonePrefOffset = zone.utcOffset(date.getTime());
  const localOffset = date.getTimezoneOffset();
  const diff = timezonePrefOffset - localOffset;
  const newDate = new Date(date.getTime() - diff * 1e3 * 60);
  return newDate;
}

const weekStartMap = {
  saturday: "islamic",
  sunday: "gregory",
  monday: "iso8601"
};
function Body$1({ onChange, from, to, timeZone, weekStart }) {
  const value = inputToValue(from, to, /* @__PURE__ */ new Date(), timeZone);
  const onCalendarChange = useOnCalendarChange(onChange, timeZone);
  const styles = useStyles2(getBodyStyles);
  const weekStartValue = getWeekStart(weekStart);
  return /* @__PURE__ */ jsxRuntime.jsx(
    Calendar__default.default,
    {
      selectRange: true,
      next2Label: null,
      prev2Label: null,
      className: styles.body,
      tileClassName: styles.title,
      value,
      nextLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right" }),
      nextAriaLabel: t("time-picker.calendar.next-month", "Next month"),
      prevLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-left" }),
      prevAriaLabel: t("time-picker.calendar.previous-month", "Previous month"),
      onChange: onCalendarChange,
      locale: "en",
      calendarType: weekStartMap[weekStartValue]
    }
  );
}
Body$1.displayName = "Body";
function inputToValue(from, to, invalidDateDefault = /* @__PURE__ */ new Date(), timezone) {
  let fromAsDate = from.isValid() ? from.toDate() : invalidDateDefault;
  let toAsDate = to.isValid() ? to.toDate() : invalidDateDefault;
  if (timezone) {
    fromAsDate = adjustDateForReactCalendar(fromAsDate, timezone);
    toAsDate = adjustDateForReactCalendar(toAsDate, timezone);
  }
  if (fromAsDate > toAsDate) {
    return [toAsDate, fromAsDate];
  }
  return [fromAsDate, toAsDate];
}
function useOnCalendarChange(onChange, timeZone) {
  return React.useCallback(
    (value) => {
      if (!Array.isArray(value)) {
        return console.error("onCalendarChange: should be run in selectRange={true}");
      }
      if (value[0] && value[1]) {
        const from = data.dateTimeParse(dateInfo(value[0]), { timeZone });
        const to = data.dateTimeParse(dateInfo(value[1]), { timeZone });
        onChange(from, to);
      }
    },
    [onChange, timeZone]
  );
}
function dateInfo(date) {
  return [date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds()];
}
const getBodyStyles = (theme) => {
  const hasActiveSelector = `.react-calendar__tile--hasActive:not(.react-calendar__tile--range)`;
  return {
    title: css.css({
      color: theme.colors.text.primary,
      backgroundColor: theme.colors.background.primary,
      fontSize: theme.typography.size.md,
      border: "1px solid transparent",
      "&:hover, &:focus": {
        position: "relative"
      },
      "&:disabled": {
        color: theme.colors.action.disabledText
      }
    }),
    body: css.css({
      zIndex: theme.zIndex.modal,
      backgroundColor: theme.colors.background.primary,
      width: "268px",
      ".react-calendar__navigation": {
        display: "flex"
      },
      ".react-calendar__navigation__label, .react-calendar__navigation__arrow, .react-calendar__navigation": {
        paddingTop: "4px",
        backgroundColor: "inherit",
        color: theme.colors.text.primary,
        border: 0,
        fontWeight: theme.typography.fontWeightMedium
      },
      ".react-calendar__month-view__weekdays": {
        backgroundColor: "inherit",
        textAlign: "center",
        color: theme.colors.primary.text,
        abbr: {
          border: 0,
          textDecoration: "none",
          cursor: "default",
          display: "block",
          padding: "4px 0 4px 0"
        }
      },
      ".react-calendar__month-view__days": {
        backgroundColor: "inherit"
      },
      ".react-calendar__tile, .react-calendar__tile--now": {
        marginBottom: "4px",
        backgroundColor: "inherit",
        height: "26px"
      },
      ".react-calendar__navigation__label, .react-calendar__navigation > button:focus, .time-picker-calendar-tile:focus": {
        outline: 0
      },
      [`${hasActiveSelector}, .react-calendar__tile--active, .react-calendar__tile--active:hover`]: {
        color: theme.colors.primary.contrastText,
        fontWeight: theme.typography.fontWeightMedium,
        background: theme.colors.primary.main,
        border: "0px"
      },
      ".react-calendar__tile--rangeEnd, .react-calendar__tile--rangeStart": {
        padding: 0,
        border: "0px",
        color: theme.colors.primary.contrastText,
        fontWeight: theme.typography.fontWeightMedium,
        background: theme.colors.primary.main,
        abbr: {
          backgroundColor: theme.colors.primary.main,
          borderRadius: "100px",
          display: "block",
          paddingTop: "2px",
          height: "26px"
        }
      },
      [`${hasActiveSelector}, .react-calendar__tile--rangeStart`]: {
        borderTopLeftRadius: "20px",
        borderBottomLeftRadius: "20px"
      },
      [`${hasActiveSelector}, .react-calendar__tile--rangeEnd`]: {
        borderTopRightRadius: "20px",
        borderBottomRightRadius: "20px"
      }
    })
  };
};

function Footer({ onClose, onApply }) {
  return /* @__PURE__ */ jsxRuntime.jsxs(Stack, { gap: 2, justifyContent: "space-between", children: [
    /* @__PURE__ */ jsxRuntime.jsx(Button, { variant: "secondary", onClick: onClose, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.calendar.cancel-button", children: "Cancel" }) }),
    /* @__PURE__ */ jsxRuntime.jsx(Button, { onClick: onApply, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.calendar.apply-button", children: "Apply time range" }) })
  ] });
}
Footer.displayName = "Footer";

function Header({ onClose }) {
  return /* @__PURE__ */ jsxRuntime.jsxs(Stack, { justifyContent: "space-between", children: [
    /* @__PURE__ */ jsxRuntime.jsx(TimePickerTitle, { children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.calendar.select-time", children: "Select a time range" }) }),
    /* @__PURE__ */ jsxRuntime.jsx(
      IconButton,
      {
        "data-testid": e2eSelectors.selectors.components.TimePicker.calendar.closeButton,
        tooltip: t(`time-picker.calendar.close`, "Close calendar"),
        name: "times",
        variant: "secondary",
        onClick: onClose
      }
    )
  ] });
}
Header.displayName = "Header";

const getStyles$P = (theme, isReversed = false) => {
  return {
    container: css.css({
      top: 0,
      position: "absolute",
      [`${isReversed ? "left" : "right"}`]: "546px"
      // lmao
    }),
    modalContainer: css.css({
      label: "modalContainer",
      margin: "0 auto"
    }),
    calendar: css.css({
      display: "flex",
      flexDirection: "column",
      gap: theme.spacing(1),
      padding: theme.spacing(1),
      label: "calendar",
      boxShadow: theme.shadows.z3,
      backgroundColor: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      borderRadius: theme.shape.radius.default
    }),
    modal: css.css({
      label: "modal",
      boxShadow: theme.shadows.z3,
      left: "50%",
      position: "fixed",
      top: "50%",
      transform: "translate(-50%, -50%)",
      zIndex: theme.zIndex.modal
    })
  };
};
function TimePickerCalendar(props) {
  const theme = useTheme2();
  const { modalBackdrop } = useStyles2(getModalStyles);
  const styles = getStyles$P(theme, props.isReversed);
  const { isOpen, isFullscreen: isFullscreenProp, onClose } = props;
  const ref = React.createRef();
  const { dialogProps } = dialog.useDialog(
    {
      "aria-label": e2eSelectors.selectors.components.TimePicker.calendar.label
    },
    ref
  );
  const { overlayProps } = overlays.useOverlay(
    {
      isDismissable: true,
      isOpen,
      onClose
    },
    ref
  );
  const showInModal = !isFullscreenProp;
  if (!isOpen) {
    return null;
  }
  const calendar = /* @__PURE__ */ jsxRuntime.jsxs(
    "section",
    {
      className: styles.calendar,
      ref,
      ...overlayProps,
      ...dialogProps,
      "data-testid": e2eSelectors.selectors.components.TimePicker.calendar.label,
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(Header, { ...props }),
        /* @__PURE__ */ jsxRuntime.jsx(Body$1, { ...props }),
        showInModal && /* @__PURE__ */ jsxRuntime.jsx(Footer, { ...props })
      ]
    }
  );
  if (!showInModal) {
    return /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, restoreFocus: true, autoFocus: true, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.container, children: calendar }) });
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(overlays.OverlayContainer, { children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: modalBackdrop }),
    /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modal, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modalContainer, children: calendar }) }) })
  ] });
}
React.memo(TimePickerCalendar);
TimePickerCalendar.displayName = "TimePickerCalendar";

const getStyles$O = (theme) => {
  return {
    container: css.css({
      display: "flex",
      alignItems: "center",
      flexDirection: "row-reverse",
      justifyContent: "space-between",
      position: "relative"
    }),
    radio: css.css({
      opacity: 0,
      width: "0 !important",
      "&:focus-visible + label": getFocusStyles(theme)
    }),
    label: css.css({
      cursor: "pointer",
      flex: 1,
      padding: theme.spacing(1),
      borderRadius: theme.shape.radius.default,
      "&:hover": {
        background: theme.colors.action.hover,
        cursor: "pointer"
      }
    }),
    labelSelected: css.css({
      background: theme.colors.action.selected,
      "&::before": {
        backgroundImage: theme.colors.gradients.brandVertical,
        borderRadius: theme.shape.radius.default,
        content: '" "',
        display: "block",
        height: "100%",
        position: "absolute",
        width: theme.spacing(0.5),
        left: 0,
        top: 0
      }
    })
  };
};
const TimeRangeOption = React.memo(({ value, onSelect, selected = false, name }) => {
  const styles = useStyles2(getStyles$O);
  const id = uuid.v4();
  return /* @__PURE__ */ jsxRuntime.jsxs("li", { className: styles.container, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      "input",
      {
        className: styles.radio,
        checked: selected,
        name,
        type: "checkbox",
        "data-role": "item",
        tabIndex: -1,
        id,
        onChange: () => onSelect(value)
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("label", { className: css.cx(styles.label, selected && styles.labelSelected), htmlFor: id, children: value.display })
  ] });
});
TimeRangeOption.displayName = "TimeRangeOption";

const EmptyRecentList = React.memo(() => {
  const styles = useStyles2(getEmptyListStyles);
  const emptyRecentListText = t(
    "time-picker.content.empty-recent-list-info",
    "It looks like you haven't used this time picker before. As soon as you enter some time intervals, recently used intervals will appear here."
  );
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.container, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx("span", { children: emptyRecentListText }) }),
    /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "time-picker.content.empty-recent-list-docs", children: /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        "a",
        {
          className: styles.link,
          href: "https://grafana.com/docs/grafana/latest/dashboards/time-range-controls",
          target: "_new",
          children: "Read the documentation"
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("span", { children: " to find out more about how to enter custom time ranges." })
    ] }) })
  ] });
});
EmptyRecentList.displayName = "EmptyRecentList";
const getEmptyListStyles = (theme) => ({
  container: css.css({
    padding: "12px",
    margin: "12px",
    "a, span": {
      fontSize: "13px"
    }
  }),
  link: css.css({
    color: theme.colors.text.link
  })
});

React.createContext(void 0);

const TimePickerButtonLabel = React.memo(({ hideText, value, timeZone, quickRanges }) => {
  const styles = useStyles2(getLabelStyles$2);
  if (hideText) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.container, "aria-live": "polite", "aria-atomic": "true", children: [
    /* @__PURE__ */ jsxRuntime.jsx("span", { children: formattedRange(value, timeZone, quickRanges) }),
    /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.utc, children: data.rangeUtil.describeTimeRangeAbbreviation(value, timeZone) })
  ] });
});
TimePickerButtonLabel.displayName = "TimePickerButtonLabel";
const formattedRange = (value, timeZone, quickRanges) => {
  const adjustedTimeRange = {
    to: data.dateMath.isMathString(value.raw.to) ? value.raw.to : value.to,
    from: data.dateMath.isMathString(value.raw.from) ? value.raw.from : value.from
  };
  return data.rangeUtil.describeTimeRange(adjustedTimeRange, timeZone, quickRanges);
};
const getLabelStyles$2 = (theme) => {
  return {
    container: css.css({
      display: "flex",
      alignItems: "center",
      whiteSpace: "nowrap"
    }),
    utc: css.css({
      color: theme.v1.palette.orange,
      fontSize: theme.typography.size.sm,
      paddingLeft: "6px",
      lineHeight: "28px",
      verticalAlign: "bottom",
      fontWeight: theme.typography.fontWeightMedium
    })
  };
};

React.memo(function TimePickerLabel({
  hideText,
  value,
  timeZone = "browser",
  placeholder = "No time range selected",
  className
}) {
  const styles = useStyles2(getLabelStyles$1);
  if (hideText) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx("span", { className, children: isValidTimeRange(value) ? /* @__PURE__ */ jsxRuntime.jsx(TimePickerButtonLabel, { value, timeZone }) : /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.placeholder, children: placeholder }) });
});
const getLabelStyles$1 = (theme) => {
  return {
    placeholder: css.css({
      color: theme.colors.text.disabled,
      opacity: 1
    })
  };
};

const POPUP_CLASS_NAME = "time-of-day-picker-panel";
const TimeOfDayPicker = ({
  minuteStep = 1,
  showHour = true,
  showSeconds = false,
  value,
  size = "auto",
  disabled,
  disabledHours,
  disabledMinutes,
  disabledSeconds,
  placeholder,
  // note: we can't destructure allowEmpty/onChange here
  // in order to discriminate the types properly later in the onChange handler
  ...restProps
}) => {
  var _a;
  const styles = useStyles2(getStyles$N);
  const allowClear = (_a = restProps.allowEmpty) != null ? _a : false;
  return /* @__PURE__ */ jsxRuntime.jsx(
    RcPicker__default.default,
    {
      generateConfig: generateConfig__default.default,
      locale: locale__default.default,
      allowClear: allowClear && {
        clearIcon: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "times", className: styles.clearIcon })
      },
      className: css.cx(inputSizes()[size], styles.input),
      classNames: {
        popup: css.cx(styles.picker, POPUP_CLASS_NAME)
      },
      defaultValue: restProps.allowEmpty ? void 0 : data.dateTimeAsMoment(),
      disabled,
      disabledTime: () => ({
        disabledHours,
        disabledMinutes,
        disabledSeconds
      }),
      format: generateFormat(showHour, showSeconds),
      minuteStep,
      onChange: (value2) => {
        if (data.isDateTimeInput(value2)) {
          if (restProps.allowEmpty) {
            return restProps.onChange(value2 ? data.dateTime(value2) : void 0);
          } else {
            return restProps.onChange(data.dateTime(value2));
          }
        }
      },
      picker: "time",
      placeholder,
      showNow: false,
      needConfirm: false,
      suffixIcon: /* @__PURE__ */ jsxRuntime.jsx(Caret, { wrapperStyle: styles.caretWrapper }),
      value: value ? data.dateTimeAsMoment(value) : value
    }
  );
};
function generateFormat(showHour = true, showSeconds = false) {
  const maybeHour = showHour ? "HH:" : "";
  const maybeSecond = showSeconds ? ":ss" : "";
  return maybeHour + "mm" + maybeSecond;
}
const Caret = ({ wrapperStyle = "" }) => {
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: wrapperStyle, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-down" }) });
};
const getStyles$N = (theme) => {
  const bgColor = theme.components.input.background;
  const optionBgHover = theme.colors.action.hover;
  const borderRadius = theme.shape.radius.default;
  const borderColor = theme.components.input.borderColor;
  return {
    caretWrapper: css.css({
      position: "relative",
      top: "50%",
      transform: "translateY(-50%)",
      display: "inline-block",
      color: theme.colors.text.secondary
    }),
    clearIcon: css.css({
      color: theme.colors.text.secondary,
      "&:hover": {
        color: theme.colors.text.maxContrast
      }
    }),
    picker: css.css({
      "&.rc-picker-dropdown": {
        boxShadow: "none",
        zIndex: theme.zIndex.portal
      },
      ".rc-picker-time-panel-column": {
        fontSize: theme.typography.htmlFontSize,
        backgroundColor: bgColor,
        color: theme.colors.text.secondary,
        padding: "unset",
        overflowY: "auto",
        scrollbarWidth: "thin",
        width: theme.spacing(8),
        li: {
          paddingRight: theme.spacing(2),
          width: "auto",
          "&.rc-picker-time-panel-cell-selected": {
            backgroundColor: "inherit",
            border: `1px solid ${theme.colors.action.selectedBorder}`,
            borderRadius,
            color: theme.colors.text.primary
          },
          "&:hover": {
            background: optionBgHover,
            color: theme.colors.text.primary
          },
          "&.rc-picker-time-panel-cell-disabled": {
            color: theme.colors.action.disabledText
          }
        },
        ".rc-picker-time-panel-cell-inner": {
          color: "inherit"
        },
        "&:not(:last-of-type)": {
          borderRight: `1px solid ${borderColor}`
        }
      },
      ".rc-picker-panel": {
        boxShadow: theme.shadows.z3,
        backgroundColor: bgColor,
        borderColor,
        borderRadius,
        overflow: "hidden"
      }
    }),
    input: css.css({
      "&.rc-picker-focused": {
        border: "none",
        ".rc-picker-input": getFocusStyles(theme)
      },
      "&.rc-picker-disabled": {
        ".rc-picker-input": {
          backgroundColor: theme.colors.action.disabledBackground,
          color: theme.colors.action.disabledText,
          border: `1px solid ${theme.colors.action.disabledBackground}`,
          "&:focus": {
            boxShadow: "none"
          }
        }
      },
      ".rc-picker-input": {
        backgroundColor: bgColor,
        borderRadius,
        borderColor,
        borderStyle: "solid",
        borderWidth: "1px",
        color: theme.colors.text.primary,
        height: theme.spacing(4),
        padding: theme.spacing(0, 1),
        input: {
          color: "unset",
          backgroundColor: "unset",
          "&:focus": {
            outline: "none"
          },
          "&::placeholder": {
            color: theme.colors.text.disabled
          }
        }
      },
      ".rc-picker-clear": {
        alignItems: "center",
        display: "flex",
        insetInlineEnd: "unset",
        position: "relative"
      }
    })
  };
};

const DatePicker = React.memo((props) => {
  const styles = useStyles2(getStyles$M);
  const { isOpen, onClose } = props;
  if (!isOpen) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx(ClickOutsideWrapper, { useCapture: true, includeButtonPress: false, onClick: onClose, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modal, "data-testid": "date-picker", children: /* @__PURE__ */ jsxRuntime.jsx(Body, { ...props }) }) });
});
DatePicker.displayName = "DatePicker";
const Body = React.memo(({ value, minDate, maxDate, onChange }) => {
  const styles = useStyles2(getBodyStyles);
  return /* @__PURE__ */ jsxRuntime.jsx(
    Calendar__default.default,
    {
      className: styles.body,
      tileClassName: styles.title,
      value: value || /* @__PURE__ */ new Date(),
      minDate,
      maxDate,
      nextLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right" }),
      prevLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-left" }),
      onChange: (ev) => {
        if (ev && !Array.isArray(ev)) {
          onChange(ev);
        }
      },
      locale: "en"
    }
  );
});
Body.displayName = "Body";
const getStyles$M = (theme) => {
  return {
    modal: css.css({
      zIndex: theme.zIndex.modal,
      boxShadow: theme.shadows.z3,
      backgroundColor: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      borderTopLeftRadius: theme.shape.radius.default,
      borderBottomLeftRadius: theme.shape.radius.default,
      "button:disabled": {
        color: theme.colors.text.disabled
      }
    })
  };
};

const DateTimeInput = React__namespace.forwardRef(
  ({ date, label, onChange, onOpen, timeZone, showSeconds = true, clearable = false }, ref) => {
    const styles = useStyles2(getStyles$L);
    const format = showSeconds ? "YYYY-MM-DD HH:mm:ss" : "YYYY-MM-DD HH:mm";
    const [internalDate, setInternalDate] = React.useState(() => {
      return {
        value: date ? data.dateTimeFormat(date, { timeZone }) : !clearable ? data.dateTimeFormat(data.dateTime(), { timeZone }) : "",
        invalid: false
      };
    });
    React.useEffect(() => {
      if (date) {
        const formattedDate = data.dateTimeFormat(date, { format, timeZone });
        setInternalDate({
          invalid: !isValid(formattedDate),
          value: data.isDateTime(date) ? formattedDate : date
        });
      }
    }, [date, format, timeZone]);
    const onChangeDate = React.useCallback((event) => {
      const isInvalid = !isValid(event.currentTarget.value);
      setInternalDate({
        value: event.currentTarget.value,
        invalid: isInvalid
      });
    }, []);
    const onBlur = React.useCallback(() => {
      if (!internalDate.invalid && internalDate.value) {
        const date2 = data.dateTimeForTimeZone(data.getTimeZone({ timeZone }), internalDate.value);
        onChange(date2);
      }
    }, [internalDate, onChange, timeZone]);
    const clearInternalDate = React.useCallback(() => {
      setInternalDate({ value: "", invalid: false });
      onChange();
    }, [onChange]);
    const icon = /* @__PURE__ */ jsxRuntime.jsx(
      Button,
      {
        "aria-label": t("grafana-ui.date-time-picker.calendar-icon-label", "Time picker"),
        icon: "calendar-alt",
        variant: "secondary",
        onClick: onOpen
      }
    );
    return /* @__PURE__ */ jsxRuntime.jsx(InlineField, { label, invalid: !!(internalDate.value && internalDate.invalid), className: styles.field, children: /* @__PURE__ */ jsxRuntime.jsx(
      Input,
      {
        onChange: onChangeDate,
        addonAfter: icon,
        value: internalDate.value,
        onBlur,
        "data-testid": e2eSelectors.Components.DateTimePicker.input,
        placeholder: t("grafana-ui.date-time-picker.select-placeholder", "Select date/time"),
        ref,
        suffix: clearable && internalDate.value && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "times", className: styles.clearIcon, onClick: clearInternalDate })
      }
    ) });
  }
);
DateTimeInput.displayName = "DateTimeInput";
const DateTimeCalendar = React__namespace.forwardRef(
  ({
    date,
    onClose,
    onChange,
    isFullscreen,
    maxDate,
    minDate,
    style,
    showSeconds = true,
    disabledHours,
    disabledMinutes,
    disabledSeconds,
    timeZone
  }, ref) => {
    const calendarStyles = useStyles2(getBodyStyles);
    const styles = useStyles2(getStyles$L);
    const [timeOfDayDateTime, setTimeOfDayDateTime] = React.useState(() => {
      if (date && date.isValid()) {
        return data.dateTimeForTimeZone(data.getTimeZone({ timeZone }), date);
      }
      return data.dateTimeForTimeZone(data.getTimeZone({ timeZone }), /* @__PURE__ */ new Date());
    });
    const [reactCalendarDate, setReactCalendarDate] = React.useState(() => {
      if (date && date.isValid()) {
        return adjustDateForReactCalendar(date.toDate(), data.getTimeZone({ timeZone }));
      }
      return adjustDateForReactCalendar(/* @__PURE__ */ new Date(), data.getTimeZone({ timeZone }));
    });
    const onChangeDate = React.useCallback((date2) => {
      if (date2 && !Array.isArray(date2)) {
        setReactCalendarDate(date2);
      }
    }, []);
    const onChangeTime = React.useCallback((date2) => {
      setTimeOfDayDateTime(date2);
    }, []);
    const handleApply = () => {
      const newDate = data.dateTime(timeOfDayDateTime);
      newDate.set("date", reactCalendarDate.getDate());
      newDate.set("month", reactCalendarDate.getMonth());
      newDate.set("year", reactCalendarDate.getFullYear());
      onChange(newDate);
    };
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.container, { [styles.fullScreen]: isFullscreen }), style, ref, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        Calendar__default.default,
        {
          next2Label: null,
          prev2Label: null,
          value: reactCalendarDate,
          nextLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-right" }),
          nextAriaLabel: t("grafana-ui.date-time-picker.next-label", "Next month"),
          prevLabel: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "angle-left" }),
          prevAriaLabel: t("grafana-ui.date-time-picker.previous-label", "Previous month"),
          onChange: onChangeDate,
          locale: "en",
          className: calendarStyles.body,
          tileClassName: calendarStyles.title,
          maxDate,
          minDate
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.time, children: /* @__PURE__ */ jsxRuntime.jsx(
        TimeOfDayPicker,
        {
          showSeconds,
          onChange: onChangeTime,
          value: timeOfDayDateTime,
          disabledHours,
          disabledMinutes,
          disabledSeconds
        }
      ) }),
      /* @__PURE__ */ jsxRuntime.jsxs(Stack, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(Button, { type: "button", onClick: handleApply, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.date-time-picker.apply", children: "Apply" }) }),
        /* @__PURE__ */ jsxRuntime.jsx(Button, { variant: "secondary", type: "button", onClick: onClose, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.date-time-picker.cancel", children: "Cancel" }) })
      ] })
    ] });
  }
);
DateTimeCalendar.displayName = "DateTimeCalendar";
const getStyles$L = (theme) => ({
  container: css.css({
    padding: theme.spacing(1),
    border: `1px ${theme.colors.border.weak} solid`,
    borderRadius: theme.shape.radius.default,
    backgroundColor: theme.colors.background.primary,
    zIndex: theme.zIndex.modal
  }),
  fullScreen: css.css({
    position: "absolute"
  }),
  time: css.css({
    marginBottom: theme.spacing(2)
  }),
  modal: css.css({
    position: "fixed",
    top: "50%",
    left: "50%",
    transform: "translate(-50%, -50%)",
    zIndex: theme.zIndex.modal,
    maxWidth: "280px"
  }),
  clearIcon: css.css({
    cursor: "pointer"
  }),
  field: css.css({
    marginBottom: 0,
    width: "100%"
  })
});

const getStyles$K = stylesFactory((inlineList = false) => ({
  list: css.css({
    listStyleType: "none",
    margin: 0,
    padding: 0
  }),
  item: css.css({
    display: inlineList && "inline-block" || "block"
  })
}));
class AbstractList extends React.PureComponent {
  constructor(props) {
    super(props);
  }
  render() {
    const { items, renderItem, getItemKey, className, inline } = this.props;
    const styles = getStyles$K(inline);
    return /* @__PURE__ */ jsxRuntime.jsx("ul", { className: css.cx(styles.list, className), children: items.map((item, i) => {
      return /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.item, children: renderItem(item, i) }, getItemKey ? getItemKey(item) : i);
    }) });
  }
}

class List extends React.PureComponent {
  render() {
    return /* @__PURE__ */ jsxRuntime.jsx(AbstractList, { ...this.props });
  }
}

css.css({
  display: "flex",
  alignItems: "center",
  height: "100%"
});

const EllipsisAnimated = React.memo(() => {
  const styles = useStyles2(getStyles$J);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.ellipsis, children: [
    /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.firstDot, children: "." }),
    /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.secondDot, children: "." }),
    /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.thirdDot, children: "." })
  ] });
});
EllipsisAnimated.displayName = "EllipsisAnimated";
const getStyles$J = (theme) => {
  return {
    ellipsis: css.css({
      display: "inline"
    }),
    firstDot: css.css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${firstDot} 2s linear infinite`
      }
    }),
    secondDot: css.css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${secondDot} 2s linear infinite`
      }
    }),
    thirdDot: css.css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${thirdDot} 2s linear infinite`
      }
    })
  };
};
const firstDot = css.keyframes`
  0% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;
const secondDot = css.keyframes`
  0% {
    opacity: 0;
  }
  21% {
    opacity: 0.5;
  }
  22% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;
const thirdDot = css.keyframes`
  0% {
    opacity: 0;
  }
  43% {
    opacity: 0.5;
  }
  44% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;

const TagComponent = React.forwardRef(({ name, onClick, icon, className, colorIndex, ...rest }, ref) => {
  const theme = useTheme2();
  const styles = getTagStyles$1(theme, name, colorIndex);
  const onTagClick = (event) => {
    event.preventDefault();
    event.stopPropagation();
    onClick == null ? void 0 : onClick(name, event);
  };
  const classes = css.cx(styles.wrapper, className, { [styles.hover]: onClick !== void 0 });
  return onClick ? /* @__PURE__ */ jsxRuntime.jsxs("button", { ...rest, className: classes, onClick: onTagClick, ref, children: [
    icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon }),
    name
  ] }) : /* @__PURE__ */ jsxRuntime.jsxs("span", { ...rest, className: classes, ref, children: [
    icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon }),
    name
  ] });
});
TagComponent.displayName = "Tag";
const TagSkeleton = ({ rootProps }) => {
  const styles = useStyles2(getSkeletonStyles$2);
  return /* @__PURE__ */ jsxRuntime.jsx(Skeleton__default.default, { width: 60, height: 22, containerClassName: styles.container, ...rootProps });
};
const Tag = attachSkeleton(TagComponent, TagSkeleton);
const getSkeletonStyles$2 = () => ({
  container: css.css({
    lineHeight: 1
  })
});
const getTagStyles$1 = (theme, name, colorIndex) => {
  let colors;
  if (colorIndex === void 0) {
    colors = getTagColorsFromName(name);
  } else {
    colors = getTagColor(colorIndex);
  }
  return {
    wrapper: css.css({
      appearance: "none",
      borderStyle: "none",
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.size.sm,
      lineHeight: theme.typography.bodySmall.lineHeight,
      verticalAlign: "baseline",
      backgroundColor: colors.color,
      color: theme.v1.palette.gray98,
      whiteSpace: "pre",
      textShadow: "none",
      padding: "3px 6px",
      borderRadius: theme.shape.radius.default
    }),
    hover: css.css({
      "&:hover": {
        opacity: 0.85,
        cursor: "pointer"
      }
    })
  };
};

const TagListComponent = React.memo(
  React.forwardRef(
    ({ displayMax, tags, icon, onClick, className, getAriaLabel, getColorIndex }, ref) => {
      const theme = useTheme2();
      const styles = getStyles$I(theme, Boolean(displayMax && displayMax > 0));
      const numTags = tags.length;
      const tagsToDisplay = displayMax ? tags.slice(0, displayMax) : tags;
      return /* @__PURE__ */ jsxRuntime.jsxs("ul", { className: css.cx(styles.wrapper, className), "aria-label": t("grafana-ui.tags.list-label", "Tags"), ref, children: [
        tagsToDisplay.map((tag, i) => /* @__PURE__ */ jsxRuntime.jsx("li", { className: styles.li, children: /* @__PURE__ */ jsxRuntime.jsx(
          Tag,
          {
            name: tag,
            icon,
            onClick,
            "aria-label": getAriaLabel == null ? void 0 : getAriaLabel(tag, i),
            "data-tag-id": i,
            colorIndex: getColorIndex == null ? void 0 : getColorIndex(tag, i)
          }
        ) }, tag)),
        displayMax && displayMax > 0 && numTags - displayMax > 0 && /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.moreTagsLabel, children: [
          "+ ",
          numTags - displayMax
        ] })
      ] });
    }
  )
);
TagListComponent.displayName = "TagList";
const TagListSkeleton = ({ rootProps }) => {
  const styles = useStyles2(getSkeletonStyles$1);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.container, ...rootProps, children: [
    /* @__PURE__ */ jsxRuntime.jsx(Tag.Skeleton, {}),
    /* @__PURE__ */ jsxRuntime.jsx(Tag.Skeleton, {})
  ] });
};
attachSkeleton(TagListComponent, TagListSkeleton);
const getSkeletonStyles$1 = (theme) => ({
  container: css.css({
    display: "flex",
    gap: theme.spacing(1)
  })
});
const getStyles$I = (theme, isTruncated) => {
  return {
    wrapper: css.css({
      position: "relative",
      alignItems: isTruncated ? "center" : "unset",
      display: "flex",
      flex: "1 1 auto",
      flexWrap: "wrap",
      flexShrink: isTruncated ? 0 : 1,
      justifyContent: "flex-end",
      gap: "6px"
    }),
    moreTagsLabel: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.size.sm
    }),
    li: css.css({
      listStyle: "none"
    })
  };
};

const ModalHeader = ({ icon, iconTooltip, title, children, id }) => {
  const styles = useStyles2(getModalStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx("h2", { className: styles.modalHeaderTitle, id, children: title }),
    children
  ] });
};

function Modal(props) {
  const {
    title,
    children,
    isOpen = false,
    closeOnEscape = true,
    closeOnBackdropClick = true,
    className,
    contentClassName,
    onDismiss,
    onClickBackdrop,
    trapFocus = true
  } = props;
  const styles = useStyles2(getModalStyles);
  const ref = React.useRef(null);
  const { overlayProps, underlayProps } = overlays.useOverlay(
    { isKeyboardDismissDisabled: !closeOnEscape, isOpen, onClose: onDismiss },
    ref
  );
  const { dialogProps, titleProps } = dialog.useDialog({}, ref);
  if (!isOpen) {
    return null;
  }
  const headerClass = css.cx(styles.modalHeader, typeof title !== "string" && styles.modalHeaderWithTabs);
  return /* @__PURE__ */ jsxRuntime.jsxs(overlays.OverlayContainer, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        role: "presentation",
        className: styles.modalBackdrop,
        onClick: onClickBackdrop || (closeOnBackdropClick ? onDismiss : void 0),
        ...underlayProps
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx(focus.FocusScope, { contain: trapFocus, autoFocus: true, restoreFocus: true, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.modal, className), ref, ...overlayProps, ...dialogProps, children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: headerClass, children: [
        typeof title === "string" && /* @__PURE__ */ jsxRuntime.jsx(DefaultModalHeader, { ...props, title, id: titleProps.id }),
        // FIXME: custom title components won't get an accessible title.
        // Do we really want to support them or shall we just limit this ModalTabsHeader?
        typeof title !== "string" && title,
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modalHeaderClose, children: /* @__PURE__ */ jsxRuntime.jsx(
          IconButton,
          {
            name: "times",
            size: "xl",
            onClick: onDismiss,
            "aria-label": t("grafana-ui.modal.close-tooltip", "Close")
          }
        ) })
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.modalContent, contentClassName), children })
    ] }) })
  ] });
}
function ModalButtonRow({ leftItems, children }) {
  const styles = useStyles2(getModalStyles);
  if (leftItems) {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modalButtonRow, children: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { justifyContent: "space-between", children: [
      /* @__PURE__ */ jsxRuntime.jsx(Stack, { justifyContent: "flex-start", gap: 2, children: leftItems }),
      /* @__PURE__ */ jsxRuntime.jsx(Stack, { justifyContent: "flex-end", gap: 2, children })
    ] }) });
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.modalButtonRow, children: /* @__PURE__ */ jsxRuntime.jsx(Stack, { justifyContent: "flex-end", gap: 2, wrap: "wrap", children }) });
}
Modal.ButtonRow = ModalButtonRow;
function DefaultModalHeader({ icon, iconTooltip, title, id }) {
  return /* @__PURE__ */ jsxRuntime.jsx(ModalHeader, { icon, iconTooltip, title, id });
}

const ConfirmContent = ({
  body,
  confirmPromptText,
  confirmButtonLabel,
  confirmButtonVariant,
  dismissButtonVariant,
  dismissButtonLabel,
  onConfirm,
  onDismiss,
  onAlternative,
  alternativeButtonLabel,
  description,
  justifyButtons = "flex-end",
  disabled
}) => {
  const [isDisabled, setIsDisabled] = React.useState(disabled);
  const styles = useStyles2(getStyles$H);
  const buttonRef = React.useRef(null);
  const onConfirmationTextChange = (event) => {
    setIsDisabled((confirmPromptText == null ? void 0 : confirmPromptText.toLowerCase().localeCompare(event.currentTarget.value.toLowerCase())) !== 0);
  };
  React.useEffect(() => {
    var _a;
    (_a = buttonRef.current) == null ? void 0 : _a.focus();
  }, []);
  React.useEffect(() => {
    setIsDisabled(disabled ? true : Boolean(confirmPromptText));
  }, [confirmPromptText, disabled]);
  const onConfirmClick = async () => {
    if (disabled === void 0) {
      setIsDisabled(true);
    }
    try {
      await onConfirm();
    } finally {
      if (disabled === void 0) {
        setIsDisabled(false);
      }
    }
  };
  const { handleSubmit } = reactHookForm.useForm();
  const placeholder = t("grafana-ui.confirm-content.placeholder", 'Type "{{confirmPromptText}}" to confirm', {
    confirmPromptText
  });
  return /* @__PURE__ */ jsxRuntime.jsxs("form", { onSubmit: handleSubmit(onConfirmClick), children: [
    /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.text, children: [
      body,
      description ? /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.description, children: description }) : null,
      confirmPromptText ? /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.confirmationInput, children: /* @__PURE__ */ jsxRuntime.jsx(Stack, { alignItems: "flex-start", children: /* @__PURE__ */ jsxRuntime.jsx(Field, { disabled, children: /* @__PURE__ */ jsxRuntime.jsx(Input, { placeholder, onChange: onConfirmationTextChange }) }) }) }) : null
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.buttonsContainer, children: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { justifyContent: justifyButtons, gap: 2, wrap: "wrap", children: [
      /* @__PURE__ */ jsxRuntime.jsx(Button, { variant: dismissButtonVariant, onClick: onDismiss, fill: "outline", children: dismissButtonLabel }),
      /* @__PURE__ */ jsxRuntime.jsx(
        Button,
        {
          type: "submit",
          variant: confirmButtonVariant,
          disabled: isDisabled,
          ref: buttonRef,
          "data-testid": e2eSelectors.selectors.pages.ConfirmModal.delete,
          children: confirmButtonLabel
        }
      ),
      onAlternative ? /* @__PURE__ */ jsxRuntime.jsx(Button, { variant: "primary", onClick: onAlternative, children: alternativeButtonLabel }) : null
    ] }) })
  ] });
};
const getStyles$H = (theme) => ({
  text: css.css({
    fontSize: theme.typography.h5.fontSize,
    color: theme.colors.text.primary
  }),
  description: css.css({
    fontSize: theme.typography.body.fontSize
  }),
  confirmationInput: css.css({
    paddingTop: theme.spacing(1)
  }),
  buttonsContainer: css.css({
    paddingTop: theme.spacing(3)
  })
});

const ConfirmModal = ({
  isOpen,
  title,
  body,
  description,
  confirmText,
  confirmVariant = "destructive",
  confirmationText,
  dismissText = "Cancel",
  dismissVariant = "secondary",
  alternativeText,
  modalClass,
  icon = "exclamation-triangle",
  onConfirm,
  onDismiss,
  onAlternative,
  confirmButtonVariant = "destructive",
  disabled
}) => {
  const styles = useStyles2(getStyles$G);
  return /* @__PURE__ */ jsxRuntime.jsx(Modal, { className: css.cx(styles.modal, modalClass), title, icon, isOpen, onDismiss, children: /* @__PURE__ */ jsxRuntime.jsx(
    ConfirmContent,
    {
      body,
      description,
      confirmButtonLabel: confirmText,
      dismissButtonLabel: dismissText,
      dismissButtonVariant: dismissVariant,
      confirmPromptText: confirmationText,
      alternativeButtonLabel: alternativeText,
      confirmButtonVariant,
      onConfirm,
      onDismiss,
      onAlternative,
      disabled
    }
  ) });
};
const getStyles$G = () => ({
  modal: css.css({
    width: "500px"
  })
});

function ClearPlugin() {
  return {
    onKeyDown(event, editor, next) {
      const value = editor.value;
      if (value.selection.isExpanded) {
        return next();
      }
      if (event.key === "k" && event.ctrlKey) {
        event.preventDefault();
        const text = value.anchorText.text;
        const offset = value.selection.anchor.offset;
        const length = text.length;
        const forward = length - offset;
        editor.deleteForward(forward);
        return true;
      }
      return next();
    }
  };
}

const getCopiedText = (textBlocks, startOffset, endOffset) => {
  if (!textBlocks.length) {
    return void 0;
  }
  const excludingLastLineLength = textBlocks.slice(0, -1).join("").length + textBlocks.length - 1;
  return textBlocks.join("\n").slice(startOffset, excludingLastLineLength + endOffset);
};
const removeBom = (str) => {
  return str == null ? void 0 : str.replace(/[\uFEFF]/g, "");
};
function ClipboardPlugin() {
  const clipboardPlugin = {
    onCopy(event, editor, next) {
      event.preventDefault();
      const { document, selection } = editor.value;
      const {
        start: { offset: startOffset },
        end: { offset: endOffset }
      } = selection;
      const selectedBlocks = document.getLeafBlocksAtRange(selection).toArray().map((block) => block.text);
      const copiedText = removeBom(getCopiedText(selectedBlocks, startOffset, endOffset));
      if (copiedText && event.clipboardData) {
        event.clipboardData.setData("Text", copiedText);
      }
      return true;
    },
    onPaste(event, editor, next) {
      event.preventDefault();
      if (event.clipboardData) {
        const pastedValue = removeBom(event.clipboardData.getData("Text"));
        const lines = pastedValue == null ? void 0 : pastedValue.split("\n");
        if (lines && lines.length) {
          editor.insertText(lines[0]);
          for (const line of lines.slice(1)) {
            editor.splitBlock().insertText(line);
          }
        }
      }
      return true;
    }
  };
  return {
    ...clipboardPlugin,
    onCut(event, editor, next) {
      clipboardPlugin.onCopy(event, editor, next);
      editor.deleteAtRange(editor.value.selection);
      return true;
    }
  };
}

const isIndentLeftHotkey = isHotkey.isKeyHotkey("mod+[");
const isShiftTabHotkey = isHotkey.isKeyHotkey("shift+tab");
const isIndentRightHotkey = isHotkey.isKeyHotkey("mod+]");
const SLATE_TAB = "  ";
const handleTabKey = (event, editor, next) => {
  const {
    startBlock,
    endBlock,
    selection: {
      start: { offset: startOffset, key: startKey },
      end: { offset: endOffset, key: endKey }
    }
  } = editor.value;
  if (Plain__default.default.serialize(editor.value) === "") {
    return;
  }
  event.preventDefault();
  const first = startBlock.getFirstText();
  const startBlockIsSelected = first && startOffset === 0 && startKey === first.key && endOffset === first.text.length && endKey === first.key;
  if (startBlockIsSelected || !startBlock.equals(endBlock)) {
    handleIndent(editor, "right");
  } else {
    editor.insertText(SLATE_TAB);
  }
};
const handleIndent = (editor, indentDirection) => {
  const curSelection = editor.value.selection;
  const selectedBlocks = editor.value.document.getLeafBlocksAtRange(curSelection).toArray();
  if (indentDirection === "left") {
    for (const block of selectedBlocks) {
      const blockWhitespace = block.text.length - block.text.trimLeft().length;
      const textKey = block.getFirstText().key;
      const rangeProperties = {
        anchor: {
          key: textKey,
          offset: blockWhitespace,
          path: []
        },
        focus: {
          key: textKey,
          offset: blockWhitespace,
          path: []
        }
      };
      editor.deleteBackwardAtRange(slate.Range.create(rangeProperties), Math.min(SLATE_TAB.length, blockWhitespace));
    }
  } else {
    const { startText } = editor.value;
    const textBeforeCaret = startText.text.slice(0, curSelection.start.offset);
    const isWhiteSpace = /^\s*$/.test(textBeforeCaret);
    for (const block of selectedBlocks) {
      editor.insertTextByKey(block.getFirstText().key, 0, SLATE_TAB);
    }
    if (isWhiteSpace) {
      editor.moveStartBackward(SLATE_TAB.length);
    }
  }
};
function IndentationPlugin() {
  return {
    onKeyDown(event, editor, next) {
      if (isIndentLeftHotkey(event) || isShiftTabHotkey(event)) {
        event.preventDefault();
        handleIndent(editor, "left");
      } else if (isIndentRightHotkey(event)) {
        event.preventDefault();
        handleIndent(editor, "right");
      } else if (event.key === "Tab") {
        handleTabKey(event, editor);
      } else {
        return next();
      }
      return true;
    }
  };
}

function getIndent(text) {
  let offset = text.length - text.trimLeft().length;
  if (offset) {
    let indent = text[0];
    while (--offset) {
      indent += text[0];
    }
    return indent;
  }
  return "";
}
function NewlinePlugin() {
  return {
    onKeyDown(event, editor, next) {
      const value = editor.value;
      if (value.selection.isExpanded) {
        return next();
      }
      if (event.key === "Enter") {
        event.preventDefault();
        const { startBlock } = value;
        const currentLineText = startBlock.text;
        const indent = getIndent(currentLineText);
        return editor.splitBlock().insertText(indent).focus();
      }
      return next();
    }
  };
}

function RunnerPlugin({ handler }) {
  return {
    onKeyDown(event, editor, next) {
      if (handler && event.key === "Enter" && (event.shiftKey || event.ctrlKey)) {
        event.preventDefault();
        handler(event);
        return editor;
      }
      return next();
    }
  };
}

const isSelectLineHotkey = isHotkey.isKeyHotkey("mod+l");
function SelectionShortcutsPlugin() {
  return {
    onKeyDown(event, editor, next) {
      if (isSelectLineHotkey(event)) {
        event.preventDefault();
        const { focusBlock, document } = editor.value;
        editor.moveAnchorToStartOfBlock();
        const nextBlock = document.getNextBlock(focusBlock.key);
        if (nextBlock) {
          editor.moveFocusToStartOfNextBlock();
        } else {
          editor.moveFocusToEndOfText();
        }
      } else {
        return next();
      }
      return true;
    }
  };
}

const TOKEN_MARK = "prism-token";

function defaultOnlyIn(node) {
  return node.object === "block" && node.type === "code_block";
}
function defaultGetSyntax(node) {
  return "javascript";
}
function defaultRenderDecoration(props, editor, next) {
  const { decoration } = props;
  if (decoration.type !== TOKEN_MARK) {
    return next();
  }
  const className = decoration.data.get("className");
  return /* @__PURE__ */ jsxRuntime.jsx("span", { className, children: props.children });
}
class Options extends immutable.Record({
  onlyIn: defaultOnlyIn,
  getSyntax: defaultGetSyntax,
  renderDecoration: defaultRenderDecoration
}) {
  constructor(props) {
    super(props);
  }
}

function SlatePrism(optsParam = {}, prismLanguages = Prism__default.default.languages) {
  const opts = new Options(optsParam);
  return {
    decorateNode: (node, editor, next) => {
      if (!opts.onlyIn(node)) {
        return next();
      }
      const block = slate.Block.create(node);
      const grammarName = opts.getSyntax(block);
      const grammar = prismLanguages[grammarName];
      if (!grammar) {
        return [];
      }
      const texts = block.getTexts();
      const blockText = texts.map((text) => text && text.getText()).join("\n");
      const tokens = Prism__default.default.tokenize(blockText, grammar);
      const flattened = flattenTokens(tokens);
      const newData = editor.value.data.set("tokens", flattened);
      editor.setData(newData);
      return decorateNode(opts, tokens, block);
    },
    renderDecoration: (props, editor, next) => opts.renderDecoration(
      {
        children: props.children,
        decoration: props.decoration
      },
      editor,
      next
    )
  };
}
function decorateNode(opts, tokens, block) {
  const texts = block.getTexts();
  const decorations = [];
  let textStart = 0;
  let textEnd = 0;
  texts.forEach((text) => {
    textEnd = textStart + text.getText().length;
    let offset = 0;
    function processToken(token, accu) {
      if (typeof token === "string") {
        if (accu) {
          const decoration = createDecoration({
            text,
            textStart,
            textEnd,
            start: offset,
            end: offset + token.length,
            className: `prism-token token ${accu}`,
            block
          });
          if (decoration) {
            decorations.push(decoration);
          }
        }
        offset += token.length;
      } else {
        accu = `${accu} ${token.type}`;
        if (token.alias) {
          accu += " " + token.alias;
        }
        if (typeof token.content === "string") {
          const decoration = createDecoration({
            text,
            textStart,
            textEnd,
            start: offset,
            end: offset + token.content.length,
            className: `prism-token token ${accu}`,
            block
          });
          if (decoration) {
            decorations.push(decoration);
          }
          offset += token.content.length;
        } else {
          for (let i = 0; i < token.content.length; i += 1) {
            processToken(token.content[i], accu);
          }
        }
      }
    }
    tokens.forEach(processToken);
    textStart = textEnd + 1;
  });
  return decorations;
}
function createDecoration({
  text,
  textStart,
  textEnd,
  start,
  end,
  className,
  block
}) {
  if (start >= textEnd || end <= textStart) {
    return null;
  }
  start = Math.max(start, textStart);
  end = Math.min(end, textEnd);
  start -= textStart;
  end -= textStart;
  const myDec = block.createDecoration({
    object: "decoration",
    anchor: {
      key: text.key,
      offset: start,
      object: "point"
    },
    focus: {
      key: text.key,
      offset: end,
      object: "point"
    },
    type: TOKEN_MARK,
    data: { className }
  });
  return myDec;
}
function flattenToken(token) {
  if (typeof token === "string") {
    return [
      {
        content: token,
        types: [],
        aliases: []
      }
    ];
  } else if (Array.isArray(token)) {
    return token.flatMap((t) => flattenToken(t));
  } else if (token instanceof Prism__default.default.Token) {
    return flattenToken(token.content).flatMap((t) => {
      var _a;
      let aliases = [];
      if (typeof token.alias === "string") {
        aliases = [token.alias];
      } else {
        aliases = (_a = token.alias) != null ? _a : [];
      }
      return {
        content: t.content,
        types: [token.type, ...t.types],
        aliases: [...aliases, ...t.aliases]
      };
    });
  }
  return [];
}
function flattenTokens(token) {
  const tokens = flattenToken(token);
  if (!tokens.length) {
    return [];
  }
  const firstToken = tokens[0];
  firstToken.prev = null;
  firstToken.next = tokens.length >= 2 ? tokens[1] : null;
  firstToken.offsets = {
    start: 0,
    end: firstToken.content.length
  };
  for (let i = 1; i < tokens.length - 1; i++) {
    tokens[i].prev = tokens[i - 1];
    tokens[i].next = tokens[i + 1];
    tokens[i].offsets = {
      start: tokens[i - 1].offsets.end,
      end: tokens[i - 1].offsets.end + tokens[i].content.length
    };
  }
  const lastToken = tokens[tokens.length - 1];
  lastToken.prev = tokens.length >= 2 ? tokens[tokens.length - 2] : null;
  lastToken.next = null;
  lastToken.offsets = {
    start: tokens.length >= 2 ? tokens[tokens.length - 2].offsets.end : 0,
    end: tokens.length >= 2 ? tokens[tokens.length - 2].offsets.end + lastToken.content.length : lastToken.content.length
  };
  return tokens;
}

const flattenGroupItems = (groupedItems) => {
  return groupedItems.reduce((all, { items, label }) => {
    all.push({
      label,
      kind: CompletionItemKind.GroupTitle
    });
    return items.reduce((all2, item) => {
      all2.push(item);
      return all2;
    }, all);
  }, []);
};
const calculateLongestLabel = (allItems) => {
  return allItems.reduce((longest, current) => {
    return longest.length < current.label.length ? current.label : longest;
  }, "");
};
const calculateListSizes = (theme, allItems, longestLabel) => {
  const size = calculateSize__default.default(longestLabel, {
    font: theme.typography.fontFamilyMonospace,
    fontSize: theme.typography.bodySmall.fontSize,
    fontWeight: "normal"
  });
  const listWidth = calculateListWidth(size.width, theme);
  const itemHeight = calculateItemHeight(size.height, theme);
  const listHeight = calculateListHeight(itemHeight, allItems);
  return {
    listWidth,
    listHeight,
    itemHeight
  };
};
const calculateItemHeight = (longestLabelHeight, theme) => {
  const horizontalPadding = theme.spacing.gridSize * 2;
  const itemHeight = longestLabelHeight + horizontalPadding;
  return itemHeight;
};
const calculateListWidth = (longestLabelWidth, theme) => {
  const verticalPadding = theme.spacing.gridSize * 3;
  const maxWidth = 800;
  const listWidth = Math.min(Math.max(longestLabelWidth + verticalPadding, 200), maxWidth);
  return listWidth;
};
const calculateListHeight = (itemHeight, allItems) => {
  const numberOfItemsToShow = Math.min(allItems.length, 10);
  const minHeight = 100;
  const totalHeight = numberOfItemsToShow * itemHeight;
  const listHeight = Math.max(totalHeight, minHeight);
  return listHeight;
};

const getStyles$F = (theme, height, visible) => {
  return {
    typeaheadItem: css.css({
      label: "type-ahead-item",
      zIndex: 11,
      padding: theme.spacing(1, 1, 1, 2),
      border: theme.colors.border.medium,
      overflowY: "scroll",
      overflowX: "hidden",
      outline: "none",
      background: theme.colors.background.secondary,
      color: theme.colors.text.secondary,
      boxShadow: `0 0 20px ${theme.v1.colors.dropdownShadow}`,
      visibility: visible === true ? "visible" : "hidden",
      width: "250px",
      minHeight: `${height + parseInt(theme.spacing(0.25), 10)}px`,
      position: "relative",
      wordBreak: "break-word"
    })
  };
};
const TypeaheadInfo = ({ item, height }) => {
  const visible = item && !!item.documentation;
  const label = item ? item.label : "";
  const documentation = data.renderMarkdown(item == null ? void 0 : item.documentation);
  const theme = useTheme2();
  const styles = getStyles$F(theme, height, visible);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx([styles.typeaheadItem]), children: [
    /* @__PURE__ */ jsxRuntime.jsx("b", { children: label }),
    /* @__PURE__ */ jsxRuntime.jsx("hr", {}),
    /* @__PURE__ */ jsxRuntime.jsx("div", { dangerouslySetInnerHTML: { __html: documentation } })
  ] });
};

function getStartIndices(parts, length) {
  const indices = [];
  parts.forEach((part) => {
    indices.push(part.start, part.end + 1);
  });
  if (indices[0] !== 0) {
    indices.unshift(0);
  }
  if (indices[indices.length - 1] !== length) {
    indices.push(length);
  }
  return indices;
}
const PartialHighlighter = (props) => {
  let { highlightParts, text, highlightClassName } = props;
  if (!(highlightParts == null ? void 0 : highlightParts.length)) {
    return null;
  }
  let children = [];
  let indices = getStartIndices(highlightParts, text.length);
  let highlighted = highlightParts[0].start === 0;
  for (let i = 1; i < indices.length; i++) {
    let start = indices[i - 1];
    let end = indices[i];
    children.push(
      React.createElement(
        highlighted ? "mark" : "span",
        {
          key: i - 1,
          className: highlighted ? highlightClassName : void 0
        },
        text.substring(start, end)
      )
    );
    highlighted = !highlighted;
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { children });
};

const getStyles$E = (theme) => ({
  typeaheadItem: css.css({
    border: "none",
    background: "none",
    textAlign: "left",
    label: "type-ahead-item",
    height: "auto",
    fontFamily: theme.typography.fontFamilyMonospace,
    padding: theme.spacing(1, 1, 1, 2),
    fontSize: theme.typography.bodySmall.fontSize,
    textOverflow: "ellipsis",
    overflow: "hidden",
    zIndex: 11,
    display: "block",
    whiteSpace: "nowrap",
    cursor: "pointer",
    [theme.transitions.handleMotion("no-preference", "reduce")]: {
      transition: "color 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), border-color 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), background 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), padding 0.15s cubic-bezier(0.645, 0.045, 0.355, 1)"
    }
  }),
  typeaheadItemSelected: css.css({
    label: "type-ahead-item-selected",
    backgroundColor: theme.colors.background.secondary
  }),
  typeaheadItemMatch: css.css({
    label: "type-ahead-item-match",
    color: theme.v1.palette.yellow,
    borderBottom: `1px solid ${theme.v1.palette.yellow}`,
    padding: "inherit",
    background: "inherit"
  }),
  typeaheadItemGroupTitle: css.css({
    label: "type-ahead-item-group-title",
    color: theme.colors.text.secondary,
    fontSize: theme.typography.bodySmall.fontSize,
    lineHeight: theme.typography.body.lineHeight,
    padding: theme.spacing(1)
  })
});
const TypeaheadItem = (props) => {
  const styles = useStyles2(getStyles$E);
  const { isSelected, item, prefix, style, onMouseEnter, onMouseLeave, onClickItem } = props;
  const className = isSelected ? css.cx([styles.typeaheadItem, styles.typeaheadItemSelected]) : css.cx([styles.typeaheadItem]);
  const highlightClassName = css.cx([styles.typeaheadItemMatch]);
  const itemGroupTitleClassName = css.cx([styles.typeaheadItemGroupTitle]);
  const label = item.label || "";
  if (item.kind === CompletionItemKind.GroupTitle) {
    return /* @__PURE__ */ jsxRuntime.jsx("li", { className: itemGroupTitleClassName, style, children: /* @__PURE__ */ jsxRuntime.jsx("span", { children: label }) });
  }
  return /* @__PURE__ */ jsxRuntime.jsx("li", { role: "none", children: /* @__PURE__ */ jsxRuntime.jsx(
    "button",
    {
      role: "menuitem",
      className,
      style,
      onMouseDown: onClickItem,
      onMouseEnter,
      onMouseLeave,
      type: "button",
      children: item.highlightParts !== void 0 ? /* @__PURE__ */ jsxRuntime.jsx(
        PartialHighlighter,
        {
          text: label,
          highlightClassName,
          highlightParts: item.highlightParts
        }
      ) : /* @__PURE__ */ jsxRuntime.jsx(
        Highlighter__default.default,
        {
          textToHighlight: label,
          searchWords: [prefix != null ? prefix : ""],
          autoEscape: true,
          highlightClassName
        }
      )
    }
  ) });
};

const modulo$1 = (a, n) => a - n * Math.floor(a / n);
class Typeahead extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.listRef = React.createRef();
    this.state = {
      hoveredItem: null,
      typeaheadIndex: null,
      allItems: [],
      listWidth: -1,
      listHeight: -1,
      itemHeight: -1
    };
    this.componentDidMount = () => {
      if (this.props.menuRef) {
        this.props.menuRef(this);
      }
      document.addEventListener("selectionchange", this.handleSelectionChange);
      const allItems = flattenGroupItems(this.props.groupedItems);
      const longestLabel = calculateLongestLabel(allItems);
      const { listWidth, listHeight, itemHeight } = calculateListSizes(this.context, allItems, longestLabel);
      this.setState({
        listWidth,
        listHeight,
        itemHeight,
        allItems
      });
    };
    this.componentWillUnmount = () => {
      document.removeEventListener("selectionchange", this.handleSelectionChange);
    };
    this.handleSelectionChange = () => {
      this.forceUpdate();
    };
    this.componentDidUpdate = (prevProps, prevState) => {
      if (this.state.typeaheadIndex !== null && prevState.typeaheadIndex !== this.state.typeaheadIndex && this.listRef && this.listRef.current) {
        if (this.state.typeaheadIndex === 1) {
          this.listRef.current.scrollToItem(0);
          return;
        }
        this.listRef.current.scrollToItem(this.state.typeaheadIndex);
      }
      if (lodash.isEqual(prevProps.groupedItems, this.props.groupedItems) === false) {
        const allItems = flattenGroupItems(this.props.groupedItems);
        const longestLabel = calculateLongestLabel(allItems);
        const { listWidth, listHeight, itemHeight } = calculateListSizes(this.context, allItems, longestLabel);
        this.setState({ listWidth, listHeight, itemHeight, allItems, typeaheadIndex: null });
      }
    };
    this.onMouseEnter = (index) => {
      this.setState({
        hoveredItem: index
      });
    };
    this.onMouseLeave = () => {
      this.setState({
        hoveredItem: null
      });
    };
    this.moveMenuIndex = (moveAmount) => {
      const itemCount = this.state.allItems.length;
      if (itemCount) {
        const typeaheadIndex = this.state.typeaheadIndex || 0;
        let newTypeaheadIndex = modulo$1(typeaheadIndex + moveAmount, itemCount);
        if (this.state.allItems[newTypeaheadIndex].kind === CompletionItemKind.GroupTitle) {
          newTypeaheadIndex = modulo$1(newTypeaheadIndex + moveAmount, itemCount);
        }
        this.setState({
          typeaheadIndex: newTypeaheadIndex
        });
        return;
      }
    };
    this.insertSuggestion = () => {
      if (this.props.onSelectSuggestion && this.state.typeaheadIndex !== null) {
        this.props.onSelectSuggestion(this.state.allItems[this.state.typeaheadIndex]);
      }
    };
  }
  get menuPosition() {
    if (!window.getSelection) {
      return "";
    }
    const selection = window.getSelection();
    const node = selection && selection.anchorNode;
    if (node && node.parentElement) {
      const rect = node.parentElement.getBoundingClientRect();
      const scrollX = window.scrollX;
      const scrollY = window.scrollY;
      return `position: absolute; display: flex; top: ${rect.top + scrollY + rect.height + 6}px; left: ${rect.left + scrollX - 2}px`;
    }
    return "";
  }
  render() {
    const { prefix, isOpen = false, origin } = this.props;
    const { allItems, listWidth, listHeight, itemHeight, hoveredItem, typeaheadIndex } = this.state;
    const styles = getStyles$D(this.context);
    const showDocumentation = hoveredItem || typeaheadIndex;
    const documentationItem = allItems[hoveredItem ? hoveredItem : typeaheadIndex || 0];
    return /* @__PURE__ */ jsxRuntime.jsxs(Portal, { origin, isOpen, style: this.menuPosition, children: [
      /* @__PURE__ */ jsxRuntime.jsx("ul", { role: "menu", className: styles.typeahead, "data-testid": "typeahead", children: /* @__PURE__ */ jsxRuntime.jsx(
        reactWindow.FixedSizeList,
        {
          ref: this.listRef,
          itemCount: allItems.length,
          itemSize: itemHeight,
          itemKey: (index) => {
            const item = allItems && allItems[index];
            const key = item ? `${index}-${item.label}` : `${index}`;
            return key;
          },
          width: listWidth,
          height: listHeight,
          children: ({ index, style }) => {
            const item = allItems && allItems[index];
            if (!item) {
              return null;
            }
            return /* @__PURE__ */ jsxRuntime.jsx(
              TypeaheadItem,
              {
                onClickItem: () => this.props.onSelectSuggestion ? this.props.onSelectSuggestion(item) : {},
                isSelected: typeaheadIndex === null ? false : allItems[typeaheadIndex] === item,
                item,
                prefix,
                style,
                onMouseEnter: () => this.onMouseEnter(index),
                onMouseLeave: this.onMouseLeave
              }
            );
          }
        }
      ) }),
      showDocumentation && /* @__PURE__ */ jsxRuntime.jsx(TypeaheadInfo, { height: listHeight, item: documentationItem })
    ] });
  }
}
Typeahead.contextType = data.ThemeContext;
class Portal extends React.PureComponent {
  constructor(props) {
    super(props);
    const { index = 0, origin = "query", style } = props;
    this.node = document.createElement("div");
    this.node.setAttribute("style", style);
    this.node.classList.add(`slate-typeahead-${origin}-${index}`);
    document.body.appendChild(this.node);
  }
  componentWillUnmount() {
    document.body.removeChild(this.node);
  }
  render() {
    if (this.props.isOpen) {
      this.node.setAttribute("style", this.props.style);
      this.node.classList.add(`slate-typeahead--open`);
      return ReactDOM__default.default.createPortal(this.props.children, this.node);
    } else {
      this.node.classList.remove(`slate-typeahead--open`);
    }
    return null;
  }
}
const getStyles$D = (theme) => ({
  typeahead: css.css({
    position: "relative",
    zIndex: theme.zIndex.typeahead,
    borderRadius: theme.shape.radius.default,
    border: `1px solid ${theme.components.panel.borderColor}`,
    maxHeight: "66vh",
    overflowY: "scroll",
    overflowX: "hidden",
    outline: "none",
    listStyle: "none",
    background: theme.components.panel.background,
    color: theme.colors.text.primary,
    boxShadow: theme.shadows.z2,
    strong: {
      color: theme.v1.palette.yellow
    }
  })
});

const TYPEAHEAD_DEBOUNCE = 250;
function SuggestionsPlugin({
  onTypeahead,
  cleanText,
  onWillApplySuggestion,
  portalOrigin
}) {
  let typeaheadRef;
  let state = {
    groupedItems: [],
    typeaheadPrefix: "",
    typeaheadContext: "",
    typeaheadText: ""
  };
  const handleTypeaheadDebounced = lodash.debounce(handleTypeahead, TYPEAHEAD_DEBOUNCE);
  const setState = (update) => {
    state = {
      ...state,
      ...update
    };
  };
  return {
    onBlur: (event, editor, next) => {
      state = {
        ...state,
        groupedItems: []
      };
      return next();
    },
    onClick: (event, editor, next) => {
      state = {
        ...state,
        groupedItems: []
      };
      return next();
    },
    onKeyDown: (event, editor, next) => {
      const currentSuggestions = state.groupedItems;
      const hasSuggestions = currentSuggestions.length;
      switch (event.key) {
        case "Escape": {
          if (hasSuggestions) {
            event.preventDefault();
            state = {
              ...state,
              groupedItems: []
            };
            return editor.insertText("");
          }
          break;
        }
        case "ArrowDown":
        case "ArrowUp":
          if (hasSuggestions) {
            event.preventDefault();
            typeaheadRef.moveMenuIndex(event.key === "ArrowDown" ? 1 : -1);
            return;
          }
          break;
        case "Enter": {
          if (!(event.shiftKey || event.ctrlKey) && hasSuggestions) {
            event.preventDefault();
            return typeaheadRef.insertSuggestion();
          }
          break;
        }
        case "Tab": {
          if (hasSuggestions) {
            event.preventDefault();
            return typeaheadRef.insertSuggestion();
          }
          break;
        }
        default: {
          if (event.key.length === 1) {
            handleTypeaheadDebounced(editor, setState, onTypeahead, cleanText);
          }
          break;
        }
      }
      return next();
    },
    commands: {
      selectSuggestion: (editor, suggestion) => {
        const suggestions = state.groupedItems;
        if (!suggestions || !suggestions.length) {
          return editor;
        }
        const ed = editor.applyTypeahead(suggestion);
        handleTypeaheadDebounced(editor, setState, onTypeahead, cleanText);
        return ed;
      },
      applyTypeahead: (editor, suggestion) => {
        let suggestionText = suggestion.insertText || suggestion.label;
        const preserveSuffix = suggestion.kind === "function";
        const move = suggestion.move || 0;
        const moveForward = move > 0 ? move : 0;
        const moveBackward = move < 0 ? -move : 0;
        const { typeaheadPrefix, typeaheadText, typeaheadContext } = state;
        if (onWillApplySuggestion) {
          suggestionText = onWillApplySuggestion(suggestionText, {
            groupedItems: state.groupedItems,
            typeaheadContext,
            typeaheadPrefix,
            typeaheadText
          });
        }
        const { forward, backward } = getNumCharsToDelete(
          suggestionText,
          typeaheadPrefix,
          typeaheadText,
          preserveSuffix,
          suggestion.deleteBackwards,
          cleanText
        );
        if (suggestionText.match(/\n/)) {
          const fragment = makeFragment(suggestionText);
          editor.deleteBackward(backward).deleteForward(forward).insertFragment(fragment).focus();
          return editor;
        }
        state = {
          ...state,
          groupedItems: []
        };
        editor.snapshotSelection().deleteBackward(backward).deleteForward(forward).insertText(suggestionText).moveForward(moveForward).moveBackward(moveBackward).focus();
        return editor;
      }
    },
    renderEditor(props, editor, next) {
      if (editor.value.selection.isExpanded) {
        return next();
      }
      const children = next();
      return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        children,
        /* @__PURE__ */ jsxRuntime.jsx(
          Typeahead,
          {
            menuRef: (menu) => typeaheadRef = menu,
            origin: portalOrigin,
            prefix: state.typeaheadPrefix,
            isOpen: !!state.groupedItems.length,
            groupedItems: state.groupedItems,
            onSelectSuggestion: editor.selectSuggestion
          }
        )
      ] });
    }
  };
}
const handleTypeahead = async (editor, onStateChange, onTypeahead, cleanText) => {
  if (!onTypeahead) {
    return;
  }
  const { value } = editor;
  const { selection } = value;
  const parentBlock = value.document.getClosestBlock(value.focusBlock.key);
  const selectionStartOffset = value.selection.start.offset - 1;
  const decorations = parentBlock && parentBlock.getDecorations(editor);
  const filteredDecorations = decorations ? decorations.filter(
    (decoration) => decoration.start.offset <= selectionStartOffset && decoration.end.offset > selectionStartOffset && decoration.type === TOKEN_MARK
  ).toArray() : [];
  const labelKeyDec = decorations && decorations.filter(
    (decoration) => decoration.end.offset <= selectionStartOffset && decoration.type === TOKEN_MARK && decoration.data.get("className").includes("label-key")
  ).last();
  const labelKey = labelKeyDec && value.focusText.text.slice(labelKeyDec.start.offset, labelKeyDec.end.offset);
  const wrapperClasses = filteredDecorations.map((decoration) => decoration.data.get("className")).join(" ").split(" ").filter((className) => className.length);
  let text = value.focusText.text;
  let prefix = text.slice(0, selection.focus.offset);
  if (filteredDecorations.length) {
    text = value.focusText.text.slice(filteredDecorations[0].start.offset, filteredDecorations[0].end.offset);
    prefix = value.focusText.text.slice(filteredDecorations[0].start.offset, selection.focus.offset);
  }
  const labelValueMatch = prefix.match(/(?:!?=~?"?|")(.*)/);
  if (labelValueMatch) {
    prefix = labelValueMatch[1];
  } else if (cleanText) {
    prefix = cleanText(prefix);
  }
  const { suggestions, context } = await onTypeahead({
    prefix,
    text,
    value,
    wrapperClasses,
    labelKey: labelKey || void 0,
    editor
  });
  const filteredSuggestions = suggestions.map((group) => {
    if (!group.items) {
      return group;
    }
    const searchFunctionType = group.searchFunctionType || (group.prefixMatch ? SearchFunctionType.Prefix : SearchFunctionType.Word);
    const searchFunction = SearchFunctionMap[searchFunctionType];
    let newGroup = { ...group };
    if (prefix) {
      if (!group.skipFilter) {
        newGroup.items = newGroup.items.filter((c) => (c.filterText || c.label).length >= prefix.length);
        newGroup.items = searchFunction(newGroup.items, prefix);
      }
      newGroup.items = newGroup.items.filter(
        (c) => {
          var _a;
          return !(c.insertText === prefix || ((_a = c.filterText) != null ? _a : c.label) === prefix);
        }
      );
    }
    if (!group.skipSort) {
      newGroup.items = lodash.sortBy(newGroup.items, (item) => {
        if (item.sortText === void 0) {
          return item.sortValue !== void 0 ? item.sortValue : item.label;
        } else {
          return item.sortText || item.label;
        }
      });
    }
    return newGroup;
  }).filter((gr) => gr.items && gr.items.length);
  onStateChange({
    groupedItems: filteredSuggestions,
    typeaheadPrefix: prefix,
    typeaheadContext: context,
    typeaheadText: text
  });
  editor.blur().focus();
};
function getNumCharsToDelete(suggestionText, typeaheadPrefix, typeaheadText, preserveSuffix, deleteBackwards, cleanText) {
  const backward = deleteBackwards || typeaheadPrefix.length;
  const text = cleanText ? cleanText(typeaheadText) : typeaheadText;
  const offset = typeaheadText.indexOf(typeaheadPrefix);
  const suffixLength = offset > -1 ? text.length - offset - typeaheadPrefix.length : text.length - typeaheadPrefix.length;
  const midWord = Boolean(typeaheadPrefix && suffixLength > 0 || suggestionText === typeaheadText);
  const forward = midWord && !preserveSuffix ? suffixLength + offset : 0;
  return {
    forward,
    backward
  };
}

class UnThemedQueryField extends React.PureComponent {
  constructor(props) {
    super(props);
    this.lastExecutedValue = null;
    this.mounted = false;
    this.editor = null;
    /**
     * Update local state, propagate change upstream and optionally run the query afterwards.
     */
    this.onChange = (value, runQuery) => {
      const documentChanged = value.document !== this.state.value.document;
      const prevValue = this.state.value;
      if (this.props.onRichValueChange) {
        this.props.onRichValueChange(value);
      }
      this.setState({ value }, () => {
        if (documentChanged) {
          const textChanged = Plain__default.default.serialize(prevValue) !== Plain__default.default.serialize(value);
          if (textChanged && runQuery) {
            this.runOnChangeAndRunQuery();
          }
          if (textChanged && !runQuery) {
            this.runOnChangeDebounced();
          }
        }
      });
    };
    this.runOnChange = () => {
      const { onChange } = this.props;
      const value = Plain__default.default.serialize(this.state.value);
      if (onChange) {
        onChange(this.cleanText(value));
      }
    };
    this.runOnRunQuery = () => {
      const { onRunQuery } = this.props;
      if (onRunQuery) {
        onRunQuery();
        this.lastExecutedValue = this.state.value;
      }
    };
    this.runOnChangeAndRunQuery = () => {
      this.runOnChange();
      this.runOnRunQuery();
    };
    /**
     * We need to handle blur events here mainly because of dashboard panels which expect to have query executed on blur.
     */
    this.handleBlur = (_, editor, next) => {
      const { onBlur } = this.props;
      if (onBlur) {
        onBlur();
      } else {
        const previousValue = this.lastExecutedValue ? Plain__default.default.serialize(this.lastExecutedValue) : "";
        const currentValue = Plain__default.default.serialize(editor.value);
        if (previousValue !== currentValue) {
          this.runOnChangeAndRunQuery();
        }
      }
      return next();
    };
    this.runOnChangeDebounced = lodash.debounce(this.runOnChange, 500);
    const { onTypeahead, cleanText, portalOrigin, onWillApplySuggestion } = props;
    this.plugins = [
      // SuggestionsPlugin and RunnerPlugin need to be before NewlinePlugin
      // because they override Enter behavior
      SuggestionsPlugin({ onTypeahead, cleanText, portalOrigin, onWillApplySuggestion }),
      RunnerPlugin({ handler: this.runOnChangeAndRunQuery }),
      NewlinePlugin(),
      ClearPlugin(),
      SelectionShortcutsPlugin(),
      IndentationPlugin(),
      ClipboardPlugin(),
      ...props.additionalPlugins || []
    ].filter((p) => p);
    this.state = {
      suggestions: [],
      typeaheadContext: null,
      typeaheadPrefix: "",
      typeaheadText: "",
      value: makeValue(props.query || "", props.syntax)
    };
  }
  componentDidMount() {
    this.mounted = true;
  }
  componentWillUnmount() {
    this.mounted = false;
  }
  componentDidUpdate(prevProps, prevState) {
    const { query, syntax, syntaxLoaded } = this.props;
    if (!prevProps.syntaxLoaded && syntaxLoaded && this.editor) {
      const editor = this.editor.insertText(" ").deleteBackward(1);
      this.onChange(editor.value, true);
    }
    const { value } = this.state;
    if (query !== prevProps.query) {
      if (query !== Plain__default.default.serialize(value)) {
        this.setState({ value: makeValue(query || "", syntax) });
      }
    }
  }
  cleanText(text) {
    const newText = text.replace(/[\r]/g, "");
    return newText;
  }
  render() {
    const { disabled, theme } = this.props;
    const wrapperClassName = classNames__default.default("slate-query-field__wrapper", {
      "slate-query-field__wrapper--disabled": disabled
    });
    const styles = getStyles$C(theme);
    return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(wrapperClassName, styles.wrapper), children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "slate-query-field", "data-testid": e2eSelectors.selectors.components.QueryField.container, children: /* @__PURE__ */ jsxRuntime.jsx(
      slateReact.Editor,
      {
        ref: (editor) => this.editor = editor,
        schema: SCHEMA,
        autoCorrect: false,
        readOnly: this.props.disabled,
        onBlur: this.handleBlur,
        onClick: this.props.onClick,
        onChange: (change) => {
          this.onChange(change.value, false);
        },
        placeholder: this.props.placeholder,
        plugins: this.plugins,
        spellCheck: false,
        value: this.state.value
      }
    ) }) });
  }
}
// By default QueryField calls onChange if onBlur is not defined, this will trigger a rerender
// And slate will claim the focus, making it impossible to leave the field.
UnThemedQueryField.defaultProps = {
  onBlur: () => {
  }
};
withTheme2(UnThemedQueryField);
const getStyles$C = (theme) => {
  const focusStyles = getFocusStyles(theme);
  return {
    wrapper: css.css({
      "&:focus-within": focusStyles
    })
  };
};

const ModalsContext = React__namespace.createContext({
  component: null,
  props: {},
  showModal: () => {
  },
  hideModal: () => {
  }
});
ModalsContext.Consumer;

const Link = React.forwardRef(({ href, children, ...rest }, ref) => {
  const validUrl = data.locationUtil.stripBaseFromUrl(data.textUtil.sanitizeUrl(href != null ? href : ""));
  return /* @__PURE__ */ jsxRuntime.jsx(reactRouterDomV5Compat.Link, { ref, to: validUrl, ...rest, children });
});
Link.displayName = "Link";

const PageToolbar = React.memo(
  ({
    title,
    section,
    parent,
    pageIcon,
    onGoBack,
    children,
    titleHref,
    parentHref,
    leftItems,
    isFullscreen,
    className,
    /** main nav-container aria-label **/
    "aria-label": ariaLabel,
    buttonOverflowAlignment = "right",
    forceShowLeftItems = false
  }) => {
    const styles = useStyles2(getStyles$B);
    const mainStyle = css.cx(
      "page-toolbar",
      styles.toolbar,
      {
        ["page-toolbar--fullscreen"]: isFullscreen,
        [styles.noPageIcon]: !pageIcon
      },
      className
    );
    const titleEl = /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.truncateText, children: title }),
      section && /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.pre, children: [
        " / ",
        section
      ] })
    ] });
    const goBackLabel = t("grafana-ui.page-toolbar.go-back", "Go back (Esc)");
    const searchParentFolderLabel = t(
      "grafana-ui.page-toolbar.search-parent-folder",
      "Search dashboard in the {{parent}} folder",
      { parent }
    );
    const searchDashboardNameLabel = t("grafana-ui.page-toolbar.search-dashboard-name", "Search dashboard by name");
    const searchLinksLabel = t("grafana-ui.page-toolbar.search-links", "Search links");
    return /* @__PURE__ */ jsxRuntime.jsxs("nav", { className: mainStyle, "aria-label": ariaLabel, children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.leftWrapper, children: [
        pageIcon && !onGoBack && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.pageIcon, children: /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: pageIcon, size: "lg", "aria-hidden": true }) }),
        onGoBack && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.pageIcon, children: /* @__PURE__ */ jsxRuntime.jsx(
          IconButton,
          {
            name: "arrow-left",
            tooltip: goBackLabel,
            tooltipPlacement: "bottom",
            size: "xxl",
            "data-testid": e2eSelectors.selectors.components.BackButton.backArrow,
            onClick: onGoBack
          }
        ) }),
        /* @__PURE__ */ jsxRuntime.jsxs("nav", { "aria-label": searchLinksLabel, className: styles.navElement, children: [
          parent && parentHref && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
            /* @__PURE__ */ jsxRuntime.jsxs(
              Link,
              {
                "aria-label": searchParentFolderLabel,
                className: css.cx(styles.titleText, styles.parentLink, styles.titleLink, styles.truncateText),
                href: parentHref,
                children: [
                  parent,
                  " ",
                  /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.parentIcon })
                ]
              }
            ),
            titleHref && /* @__PURE__ */ jsxRuntime.jsx("span", { className: css.cx(styles.titleText, styles.titleDivider), "aria-hidden": true, children: "/" })
          ] }),
          (title || Boolean(leftItems == null ? void 0 : leftItems.length)) && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.titleWrapper, children: [
            title && /* @__PURE__ */ jsxRuntime.jsx("h1", { className: styles.h1Styles, children: titleHref ? /* @__PURE__ */ jsxRuntime.jsx(
              Link,
              {
                "aria-label": searchDashboardNameLabel,
                className: css.cx(styles.titleText, styles.titleLink),
                href: titleHref,
                children: titleEl
              }
            ) : /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.titleText, children: titleEl }) }),
            leftItems == null ? void 0 : leftItems.map((child, index) => /* @__PURE__ */ jsxRuntime.jsx(
              "div",
              {
                className: css.cx(styles.leftActionItem, { [styles.forceShowLeftActionItems]: forceShowLeftItems }),
                children: child
              },
              index
            ))
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx(ToolbarButtonRow, { alignment: buttonOverflowAlignment, children: React.Children.toArray(children).filter(Boolean) })
    ] });
  }
);
PageToolbar.displayName = "PageToolbar";
const getStyles$B = (theme) => {
  const { spacing, typography } = theme;
  const focusStyle = getFocusStyles(theme);
  return {
    pre: css.css({
      whiteSpace: "pre"
    }),
    toolbar: css.css({
      alignItems: "center",
      background: theme.colors.background.canvas,
      display: "flex",
      gap: theme.spacing(2),
      justifyContent: "space-between",
      padding: theme.spacing(1.5, 2),
      [theme.breakpoints.down("md")]: {
        paddingLeft: "53px"
      }
    }),
    noPageIcon: css.css({
      [theme.breakpoints.down("md")]: {
        paddingLeft: theme.spacing(2)
      }
    }),
    leftWrapper: css.css({
      display: "flex",
      flexWrap: "nowrap",
      maxWidth: "70%"
    }),
    pageIcon: css.css({
      display: "none",
      [theme.breakpoints.up("sm")]: {
        display: "flex",
        paddingRight: theme.spacing(1),
        alignItems: "center"
      }
    }),
    truncateText: css.css({
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    }),
    titleWrapper: css.css({
      display: "flex",
      margin: 0,
      minWidth: 0
    }),
    navElement: css.css({
      display: "flex",
      alignItems: "center",
      minWidth: 0
    }),
    h1Styles: css.css({
      margin: spacing(0, 1, 0, 0),
      lineHeight: "inherit",
      flexGrow: 1,
      minWidth: 0
    }),
    parentIcon: css.css({
      marginLeft: theme.spacing(0.5)
    }),
    titleText: css.css({
      display: "flex",
      fontSize: typography.size.lg,
      margin: 0,
      borderRadius: theme.shape.radius.default
    }),
    titleLink: css.css({
      "&:focus-visible": focusStyle
    }),
    titleDivider: css.css({
      padding: spacing(0, 0.5, 0, 0.5),
      display: "none",
      [theme.breakpoints.up("md")]: {
        display: "unset"
      }
    }),
    parentLink: css.css({
      display: "none",
      [theme.breakpoints.up("md")]: {
        display: "unset",
        flex: 1
      }
    }),
    leftActionItem: css.css({
      display: "none",
      alignItems: "center",
      paddingRight: spacing(0.5),
      [theme.breakpoints.up("md")]: {
        display: "flex"
      }
    }),
    forceShowLeftActionItems: css.css({
      display: "flex"
    })
  };
};

function useFixScrollbarContainer(variableSizeListScrollbarRef, tableDivRef) {
  React.useEffect(() => {
    var _a;
    if (variableSizeListScrollbarRef.current && tableDivRef.current) {
      const listVerticalScrollbarHTML = variableSizeListScrollbarRef.current.querySelector(".track-vertical");
      const tableScrollbarView = tableDivRef.current.firstChild;
      if (tableScrollbarView && listVerticalScrollbarHTML) {
        listVerticalScrollbarHTML.remove();
        if (tableScrollbarView instanceof HTMLElement) {
          (_a = tableScrollbarView.querySelector(":scope > .track-vertical")) == null ? void 0 : _a.remove();
          tableScrollbarView.append(listVerticalScrollbarHTML);
        }
      }
    }
  });
}
function useResetVariableListSizeCache(extendedState, listRef, data, hasUniqueId) {
  const expandedRowsRepr = JSON.stringify(Object.keys(extendedState.expanded));
  React.useEffect(() => {
    var _a;
    let resetIndex = 0;
    if (!hasUniqueId) {
      if (Number.isFinite(extendedState.lastExpandedOrCollapsedIndex)) {
        resetIndex = extendedState.lastExpandedOrCollapsedIndex;
      }
      resetIndex = extendedState.pageIndex === 0 ? resetIndex - 1 : resetIndex - extendedState.pageIndex - extendedState.pageIndex * extendedState.pageSize;
    }
    (_a = listRef.current) == null ? void 0 : _a.resetAfterIndex(Math.max(resetIndex, 0));
    return;
  }, [
    extendedState.lastExpandedOrCollapsedIndex,
    extendedState.pageSize,
    extendedState.pageIndex,
    listRef,
    data,
    expandedRowsRepr,
    hasUniqueId
  ]);
}

function useTableStateReducer({ onColumnResize, onSortByChange, data: data$1 }) {
  return React.useCallback(
    (newState, action) => {
      var _a, _b, _c, _d;
      switch (action.type) {
        case "columnDoneResizing":
          if (onColumnResize) {
            const info = (_b = (_a = newState.columnResizing) == null ? void 0 : _a.headerIdWidths) == null ? void 0 : _b[0];
            const columnIdString = info == null ? void 0 : info[0];
            const fieldIndex = parseInt(columnIdString, 10);
            const width = Math.round((_c = newState.columnResizing.columnWidths) == null ? void 0 : _c[columnIdString]);
            const field = (_d = data$1.fields) == null ? void 0 : _d[fieldIndex];
            if (!field) {
              return newState;
            }
            const fieldDisplayName = data.getFieldDisplayName(field, data$1);
            onColumnResize(fieldDisplayName, width);
          }
        case "toggleSortBy":
          if (onSortByChange) {
            const sortByFields = [];
            for (const sortItem of newState.sortBy) {
              const field = data$1.fields[parseInt(sortItem.id, 10)];
              if (!field) {
                continue;
              }
              sortByFields.push({
                displayName: data.getFieldDisplayName(field, data$1),
                desc: sortItem.desc
              });
            }
            onSortByChange(sortByFields);
          }
        case "toggleRowExpanded": {
          if (action.id) {
            return {
              ...newState,
              lastExpandedOrCollapsedIndex: parseInt(action.id, 10)
            };
          }
        }
      }
      return newState;
    },
    [data$1, onColumnResize, onSortByChange]
  );
}
function getInitialState(initialSortBy, columns) {
  const state = {};
  if (initialSortBy) {
    state.sortBy = [];
    for (const sortBy of initialSortBy) {
      for (const col of columns) {
        if (col.Header === sortBy.displayName) {
          state.sortBy.push({ id: col.id, desc: sortBy.desc });
        }
      }
    }
  }
  return state;
}

function ActionButton({ action, ...buttonProps }) {
  const [showConfirm, setShowConfirm] = React.useState(false);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      Button,
      {
        variant: "primary",
        size: "sm",
        onClick: () => setShowConfirm(true),
        ...buttonProps,
        style: { width: "fit-content" },
        children: action.title
      }
    ),
    showConfirm && /* @__PURE__ */ jsxRuntime.jsx(
      ConfirmModal,
      {
        isOpen: true,
        title: t("grafana-ui.action-editor.button.confirm-action", "Confirm action"),
        body: action.confirmation,
        confirmText: t("grafana-ui.action-editor.button.confirm", "Confirm"),
        confirmButtonVariant: "primary",
        onConfirm: () => {
          setShowConfirm(false);
          action.onClick(new MouseEvent("click"));
        },
        onDismiss: () => {
          setShowConfirm(false);
        }
      }
    )
  ] });
}

const ActionsCell$1 = (props) => {
  const { cellProps, tableStyles, actions } = props;
  const styles = useStyles2(getStyles$A);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: css.cx(tableStyles.cellContainerText, styles.buttonsGap), children: actions && actions.map((action, i) => /* @__PURE__ */ jsxRuntime.jsx(ActionButton, { action, variant: "secondary" }, i)) });
};
const getStyles$A = (theme) => ({
  buttonsGap: css.css({
    gap: 6
  })
});

function fontSizeReductionFactor(fontSize) {
  if (fontSize < 20) {
    return 0.9;
  }
  if (fontSize < 26) {
    return 0.8;
  }
  return 0.6;
}
const FormattedValueDisplay = ({ value, className, style, ...htmlProps }) => {
  var _a, _b;
  const hasPrefix = ((_a = value.prefix) != null ? _a : "").length > 0;
  const hasSuffix = ((_b = value.suffix) != null ? _b : "").length > 0;
  let suffixStyle;
  if (style && typeof style.fontSize === "number" && !Number.isNaN(style.fontSize)) {
    const fontSize = style.fontSize;
    const reductionFactor = fontSizeReductionFactor(fontSize);
    suffixStyle = { fontSize: fontSize * reductionFactor };
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className, style, ...htmlProps, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
    hasPrefix && /* @__PURE__ */ jsxRuntime.jsx("span", { children: value.prefix }),
    /* @__PURE__ */ jsxRuntime.jsx("span", { children: value.text }),
    hasSuffix && /* @__PURE__ */ jsxRuntime.jsx("span", { style: suffixStyle, children: value.suffix })
  ] }) });
};
FormattedValueDisplay.displayName = "FormattedDisplayValue";

const MIN_VALUE_HEIGHT = 18;
const MAX_VALUE_HEIGHT = 50;
const MAX_VALUE_WIDTH = 150;
const TITLE_LINE_HEIGHT = 1.5;
const VALUE_LINE_HEIGHT = 1;
const VALUE_LEFT_PADDING = 10;
const VALUE_RIGHT_OVERFLOW_PADDING = 15;
class BarGauge extends React.PureComponent {
  render() {
    const { onClick, className, theme } = this.props;
    const { title } = this.props.value;
    const styles = getTitleStyles(this.props);
    if (onClick) {
      return /* @__PURE__ */ jsxRuntime.jsxs(
        "button",
        {
          type: "button",
          style: styles.wrapper,
          onClick,
          className: css.cx(clearButtonStyles(theme), className),
          children: [
            /* @__PURE__ */ jsxRuntime.jsx("div", { style: styles.title, children: title }),
            this.renderBarAndValue()
          ]
        }
      );
    }
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: styles.wrapper, className, children: [
      title && /* @__PURE__ */ jsxRuntime.jsx("div", { style: styles.title, children: title }),
      this.renderBarAndValue()
    ] });
  }
  renderBarAndValue() {
    switch (this.props.displayMode) {
      case "lcd":
        return this.renderRetroBars();
      case "basic":
      case "gradient":
      default:
        return this.renderBasicAndGradientBars();
    }
  }
  renderBasicAndGradientBars() {
    const { value, showUnfilled, valueDisplayMode } = this.props;
    const styles = getBasicAndGradientStyles(this.props);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: styles.wrapper, children: [
      valueDisplayMode !== schema.BarGaugeValueMode.Hidden && /* @__PURE__ */ jsxRuntime.jsx(
        FormattedValueDisplay,
        {
          "data-testid": e2eSelectors.selectors.components.Panels.Visualization.BarGauge.valueV2,
          value,
          style: styles.value
        }
      ),
      showUnfilled && /* @__PURE__ */ jsxRuntime.jsx("div", { style: styles.emptyBar }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { style: styles.bar })
    ] });
  }
  renderRetroBars() {
    var _a, _b;
    const {
      display,
      field,
      value,
      itemSpacing,
      alignmentFactors,
      orientation,
      lcdCellWidth,
      text,
      valueDisplayMode,
      theme,
      isOverflow
    } = this.props;
    const { valueHeight, valueWidth, maxBarHeight, maxBarWidth, wrapperWidth, wrapperHeight } = calculateBarAndValueDimensions(this.props);
    const minValue = (_a = field.min) != null ? _a : data.GAUGE_DEFAULT_MINIMUM;
    const maxValue = (_b = field.max) != null ? _b : data.GAUGE_DEFAULT_MAXIMUM;
    const isVert = isVertical(orientation);
    const valueRange = maxValue - minValue;
    const maxSize = isVert ? maxBarHeight : maxBarWidth;
    const cellSpacing = itemSpacing;
    const cellCount = Math.floor(maxSize / lcdCellWidth);
    const cellSize = Math.floor((maxSize - cellSpacing * cellCount) / cellCount);
    const valueColor = getTextValueColor(this.props);
    const valueToBaseSizeOn = alignmentFactors ? alignmentFactors : value;
    const valueStyles = getValueStyles(
      valueToBaseSizeOn,
      valueColor,
      valueWidth,
      valueHeight,
      orientation,
      isOverflow,
      text
    );
    const containerStyles = {
      width: `${wrapperWidth}px`,
      height: `${wrapperHeight}px`,
      display: "flex"
    };
    if (isVert) {
      containerStyles.flexDirection = "column-reverse";
      containerStyles.alignItems = "center";
    } else {
      containerStyles.flexDirection = "row";
      containerStyles.alignItems = "center";
      valueStyles.justifyContent = "flex-end";
    }
    const cells = [];
    for (let i = 0; i < cellCount; i++) {
      const currentValue = minValue + valueRange / cellCount * i;
      const cellColor = getCellColor(currentValue, value, display);
      const cellStyles = {
        borderRadius: theme.shape.radius.default
      };
      if (cellColor.isLit) {
        cellStyles.backgroundImage = `radial-gradient(${cellColor.background} 10%, ${cellColor.backgroundShade})`;
      } else {
        cellStyles.backgroundColor = cellColor.background;
      }
      if (isVert) {
        cellStyles.height = `${cellSize}px`;
        cellStyles.width = `${maxBarWidth}px`;
        cellStyles.marginTop = `${cellSpacing}px`;
      } else {
        cellStyles.width = `${cellSize}px`;
        cellStyles.height = `${maxBarHeight}px`;
        cellStyles.marginRight = `${cellSpacing}px`;
      }
      cells.push(/* @__PURE__ */ jsxRuntime.jsx("div", { style: cellStyles }, i.toString()));
    }
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: containerStyles, children: [
      cells,
      valueDisplayMode !== schema.BarGaugeValueMode.Hidden && /* @__PURE__ */ jsxRuntime.jsx(
        FormattedValueDisplay,
        {
          "data-testid": e2eSelectors.selectors.components.Panels.Visualization.BarGauge.valueV2,
          value,
          style: valueStyles
        }
      )
    ] });
  }
}
BarGauge.defaultProps = {
  lcdCellWidth: 12,
  value: {
    text: "100",
    numeric: 100
  },
  displayMode: schema.BarGaugeDisplayMode.Gradient,
  orientation: data.VizOrientation.Horizontal,
  field: {
    min: 0,
    max: 100,
    thresholds: {
      mode: data.ThresholdsMode.Absolute,
      steps: []
    }
  },
  itemSpacing: 8,
  showUnfilled: true,
  isOverflow: false
};
function isVertical(orientation) {
  return orientation === data.VizOrientation.Vertical;
}
function calculateTitleDimensions(props) {
  var _a, _b;
  const { height, width, alignmentFactors, orientation, text, namePlacement } = props;
  const title = alignmentFactors ? alignmentFactors.title : props.value.title;
  if (!title) {
    return { fontSize: 0, width: 0, height: 0, placement: "above" };
  }
  if (namePlacement === schema.BarGaugeNamePlacement.Hidden) {
    return {
      fontSize: 0,
      width: 0,
      height: 0,
      placement: schema.BarGaugeNamePlacement.Hidden
    };
  }
  if (isVertical(orientation)) {
    const fontSize = (_a = text == null ? void 0 : text.titleSize) != null ? _a : 14;
    return {
      fontSize,
      width,
      height: fontSize * TITLE_LINE_HEIGHT,
      placement: "below"
    };
  }
  const shouldDisplayValueAbove = height > 40 && namePlacement === schema.BarGaugeNamePlacement.Auto || namePlacement === schema.BarGaugeNamePlacement.Top;
  if (shouldDisplayValueAbove) {
    if (text == null ? void 0 : text.titleSize) {
      return {
        fontSize: text == null ? void 0 : text.titleSize,
        width: 0,
        height: text.titleSize * TITLE_LINE_HEIGHT,
        placement: "above"
      };
    }
    const maxTitleHeightRatio2 = 0.45;
    const titleHeight2 = Math.max(Math.min(height * maxTitleHeightRatio2, MAX_VALUE_HEIGHT), 17);
    return {
      fontSize: titleHeight2 / TITLE_LINE_HEIGHT,
      width: 0,
      height: titleHeight2,
      placement: "above"
    };
  }
  const maxTitleHeightRatio = 0.6;
  const titleHeight = Math.max(height * maxTitleHeightRatio, MIN_VALUE_HEIGHT);
  const titleFontSize = titleHeight / TITLE_LINE_HEIGHT;
  const textSize = measureText(title, titleFontSize);
  const textWidth = Math.min(textSize.width + 15, width * 0.4);
  return {
    fontSize: (_b = text == null ? void 0 : text.titleSize) != null ? _b : titleFontSize,
    height: 0,
    width: textWidth,
    placement: "left"
  };
}
function getTitleStyles(props) {
  const wrapperStyles = {
    display: "flex",
    overflow: "hidden",
    width: "100%"
  };
  const titleDim = calculateTitleDimensions(props);
  const titleStyles = {
    fontSize: `${titleDim.fontSize}px`,
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    width: "100%",
    alignItems: "center",
    alignSelf: "center"
  };
  if (titleDim.placement === "hidden") {
    titleStyles.display = "none";
  } else {
    if (isVertical(props.orientation)) {
      wrapperStyles.flexDirection = "column-reverse";
      titleStyles.textAlign = "center";
    } else {
      if (titleDim.placement === "above") {
        wrapperStyles.flexDirection = "column";
      } else {
        wrapperStyles.flexDirection = "row";
        titleStyles.width = `${titleDim.width}px`;
        titleStyles.textAlign = "right";
        titleStyles.paddingRight = "10px";
      }
    }
  }
  return {
    wrapper: wrapperStyles,
    title: titleStyles
  };
}
function calculateBarAndValueDimensions(props) {
  var _a;
  const { height, width, orientation, text, alignmentFactors, valueDisplayMode } = props;
  const titleDim = calculateTitleDimensions(props);
  const value = alignmentFactors != null ? alignmentFactors : props.value;
  const valueString = data.formattedValueToString(value);
  let maxBarHeight = 0;
  let maxBarWidth = 0;
  let valueHeight = 0;
  let valueWidth = 0;
  let wrapperWidth = 0;
  let wrapperHeight = 0;
  const fontSizeToMeasureWith = (_a = text == null ? void 0 : text.valueSize) != null ? _a : Math.max(titleDim.fontSize, 12);
  const realTextSize = measureText(valueString, fontSizeToMeasureWith);
  const realValueWidth = realTextSize.width + VALUE_LEFT_PADDING * 2;
  if (isVertical(orientation)) {
    if (text == null ? void 0 : text.valueSize) {
      valueHeight = text.valueSize * VALUE_LINE_HEIGHT;
    } else {
      valueHeight = Math.min(Math.max(height * 0.1, MIN_VALUE_HEIGHT), MAX_VALUE_HEIGHT);
    }
    valueWidth = width;
    if (valueDisplayMode === schema.BarGaugeValueMode.Hidden) {
      valueHeight = 0;
      valueWidth = 0;
    }
    maxBarHeight = height - (titleDim.height + valueHeight);
    maxBarWidth = width;
    wrapperWidth = width;
    wrapperHeight = height - titleDim.height;
  } else {
    if (valueDisplayMode === schema.BarGaugeValueMode.Hidden) {
      valueHeight = 0;
      valueWidth = 0;
    } else {
      valueHeight = height - titleDim.height;
      valueWidth = Math.max(Math.min(width * 0.2, MAX_VALUE_WIDTH), realValueWidth);
    }
    maxBarHeight = height - titleDim.height;
    maxBarWidth = width - valueWidth - titleDim.width;
    if (titleDim.placement === "above") {
      wrapperWidth = width;
      wrapperHeight = height - titleDim.height;
    } else {
      wrapperWidth = width - titleDim.width;
      wrapperHeight = height;
    }
  }
  return {
    valueWidth,
    valueHeight,
    maxBarWidth,
    maxBarHeight,
    wrapperHeight,
    wrapperWidth
  };
}
function getCellColor(positionValue, value, display) {
  if (positionValue === null) {
    return {
      background: data.FALLBACK_COLOR,
      border: data.FALLBACK_COLOR
    };
  }
  const color = display ? display(positionValue).color : null;
  if (color) {
    if (value === null || isNaN(value.numeric) || positionValue !== null && positionValue > value.numeric) {
      return {
        background: tinycolor__default.default(color).setAlpha(0.18).toRgbString(),
        border: "transparent",
        isLit: false
      };
    } else {
      return {
        background: tinycolor__default.default(color).setAlpha(0.95).toRgbString(),
        backgroundShade: tinycolor__default.default(color).setAlpha(0.55).toRgbString(),
        border: tinycolor__default.default(color).setAlpha(0.9).toRgbString(),
        isLit: true
      };
    }
  }
  return {
    background: data.FALLBACK_COLOR,
    border: data.FALLBACK_COLOR
  };
}
function getValuePercent(value, minValue, maxValue) {
  const valueRatio = Math.min((value - minValue) / (maxValue - minValue), 1);
  return isNaN(valueRatio) ? 0 : valueRatio;
}
function getBasicAndGradientStyles(props) {
  var _a, _b, _c;
  const { displayMode, field, value, alignmentFactors, orientation, theme, text, isOverflow } = props;
  const { valueWidth, valueHeight, maxBarHeight, maxBarWidth } = calculateBarAndValueDimensions(props);
  const minValue = (_a = field.min) != null ? _a : data.GAUGE_DEFAULT_MINIMUM;
  const maxValue = (_b = field.max) != null ? _b : data.GAUGE_DEFAULT_MAXIMUM;
  const valuePercent = getValuePercent(value.numeric, minValue, maxValue);
  const textColor = getTextValueColor(props);
  const barColor = (_c = value.color) != null ? _c : data.FALLBACK_COLOR;
  const valueToBaseSizeOn = alignmentFactors ? alignmentFactors : value;
  const valueStyles = getValueStyles(
    valueToBaseSizeOn,
    textColor,
    valueWidth,
    valueHeight,
    orientation,
    isOverflow,
    text
  );
  const isBasic = displayMode === "basic";
  const wrapperStyles = {
    display: "flex",
    flexGrow: 1
  };
  const barStyles = {
    borderRadius: theme.shape.radius.default,
    position: "relative"
  };
  const emptyBar = {
    background: theme.colors.background.secondary,
    flexGrow: 1,
    display: "flex",
    borderRadius: theme.shape.radius.default,
    position: "relative"
  };
  if (isVertical(orientation)) {
    const barHeight = Math.max(valuePercent * maxBarHeight, 1);
    wrapperStyles.flexDirection = "column";
    wrapperStyles.justifyContent = "flex-end";
    barStyles.transition = "height 1s";
    barStyles.height = `${barHeight}px`;
    barStyles.width = `${maxBarWidth}px`;
    emptyBar.bottom = "-3px";
    emptyBar.width = `${valueWidth}px`;
    if (isBasic) {
      barStyles.background = `${tinycolor__default.default(barColor).setAlpha(0.35).toRgbString()}`;
      barStyles.borderTop = `2px solid ${barColor}`;
    } else {
      barStyles.background = getBarGradient(props, maxBarHeight);
    }
  } else {
    const barWidth = Math.max(valuePercent * maxBarWidth, 1);
    wrapperStyles.flexDirection = "row-reverse";
    wrapperStyles.justifyContent = "flex-end";
    wrapperStyles.alignItems = "stretch";
    barStyles.transition = "width 1s";
    barStyles.height = `${maxBarHeight}px`;
    barStyles.width = `${barWidth}px`;
    emptyBar.left = "-3px";
    emptyBar.height = `${valueHeight}px`;
    if (isBasic) {
      barStyles.background = `${tinycolor__default.default(barColor).setAlpha(0.35).toRgbString()}`;
      barStyles.borderRight = `2px solid ${barColor}`;
    } else {
      barStyles.background = getBarGradient(props, maxBarWidth);
    }
  }
  return {
    wrapper: wrapperStyles,
    bar: barStyles,
    value: valueStyles,
    emptyBar
  };
}
function getBarGradient(props, maxSize) {
  var _a, _b;
  const { field, value, orientation, theme } = props;
  const cssDirection = isVertical(orientation) ? "0deg" : "90deg";
  const minValue = field.min;
  const maxValue = field.max;
  let gradient = "";
  let lastpos = 0;
  let mode = data.getFieldColorMode((_a = field.color) == null ? void 0 : _a.mode);
  if (mode.id === data.FieldColorModeId.Thresholds) {
    const thresholds = field.thresholds;
    for (let i = 0; i < thresholds.steps.length; i++) {
      const threshold = thresholds.steps[i];
      const color = props.theme.visualization.getColorByName(threshold.color);
      const valuePercent = thresholds.mode === data.ThresholdsMode.Percentage ? threshold.value / 100 : getValuePercent(threshold.value, minValue, maxValue);
      const pos = valuePercent * maxSize;
      const offset = Math.round(pos - (pos - lastpos) / 2);
      const thresholdValue = thresholds.mode === data.ThresholdsMode.Percentage ? minValue + (maxValue - minValue) * valuePercent : threshold.value;
      if (gradient === "") {
        gradient = `linear-gradient(${cssDirection}, ${color}, ${color}`;
      } else if (value.numeric < thresholdValue) {
        break;
      } else {
        lastpos = pos;
        gradient += ` ${offset}px, ${color}`;
      }
    }
    return gradient + ")";
  }
  if (mode.isContinuous && mode.getColors) {
    const scheme = mode.getColors(theme);
    for (let i = 0; i < scheme.length; i++) {
      const color = scheme[i];
      if (gradient === "") {
        gradient = `linear-gradient(${cssDirection}, ${color} 0px`;
      } else {
        const valuePercent = i / (scheme.length - 1);
        const pos = valuePercent * maxSize;
        gradient += `, ${color} ${pos}px`;
      }
    }
    return gradient + ")";
  }
  return (_b = value.color) != null ? _b : data.FALLBACK_COLOR;
}
function getTextValueColor(props) {
  if (props.valueDisplayMode === "text") {
    return props.theme.colors.text.primary;
  }
  const { value } = props;
  if (value.color) {
    return value.color;
  }
  return data.FALLBACK_COLOR;
}
function getValueStyles(value, color, width, height, orientation, isOverflow, text) {
  var _a, _b;
  const styles = {
    color,
    height: `${height}px`,
    width: `${width}px`,
    display: "flex",
    alignItems: "center",
    textWrap: "nowrap",
    lineHeight: VALUE_LINE_HEIGHT
  };
  let textWidth = width;
  const formattedValueString = data.formattedValueToString(value);
  if (isVertical(orientation)) {
    styles.fontSize = (_a = text == null ? void 0 : text.valueSize) != null ? _a : calculateFontSize(formattedValueString, textWidth, height, VALUE_LINE_HEIGHT);
    styles.justifyContent = `center`;
  } else {
    styles.fontSize = (_b = text == null ? void 0 : text.valueSize) != null ? _b : calculateFontSize(formattedValueString, textWidth - VALUE_LEFT_PADDING * 2, height, VALUE_LINE_HEIGHT);
    styles.justifyContent = `flex-end`;
    styles.paddingLeft = `${VALUE_LEFT_PADDING}px`;
    styles.paddingRight = `${VALUE_LEFT_PADDING + (isOverflow ? VALUE_RIGHT_OVERFLOW_PADDING : 0)}px`;
    textWidth -= VALUE_LEFT_PADDING;
  }
  return styles;
}

const WithContextMenu = ({ children, renderMenuItems, focusOnOpen = true }) => {
  const [isMenuOpen, setIsMenuOpen] = React.useState(false);
  const [menuPosition, setMenuPosition] = React.useState({ x: 0, y: 0 });
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    children({
      openMenu: (e) => {
        setIsMenuOpen(true);
        setMenuPosition({
          x: e.pageX,
          y: e.pageY - window.scrollY
        });
      }
    }),
    isMenuOpen && /* @__PURE__ */ jsxRuntime.jsx(
      ContextMenu,
      {
        onClose: () => setIsMenuOpen(false),
        x: menuPosition.x,
        y: menuPosition.y,
        renderMenuItems,
        focusOnOpen
      }
    )
  ] });
};

const DataLinksContextMenu = ({ children, links, style }) => {
  const styles = useStyles2(getStyles$z);
  const itemsGroup = [
    { items: linkModelToContextMenuItems(links), label: Boolean(links().length) ? "Data links" : "" }
  ];
  const linksCounter = itemsGroup[0].items.length;
  const renderMenuGroupItems = () => {
    return itemsGroup.map((group, groupIdx) => /* @__PURE__ */ jsxRuntime.jsx(MenuGroup, { label: group.label, children: (group.items || []).map((item, itemIdx) => /* @__PURE__ */ jsxRuntime.jsx(
      MenuItem,
      {
        url: item.url,
        label: item.label,
        target: item.target,
        icon: item.icon,
        active: item.active,
        onClick: item.onClick,
        className: styles.itemWrapper
      },
      `${group.label}-${groupIdx}-${itemIdx}}`
    )) }, `${group.label}${groupIdx}`));
  };
  const targetClassName = css.css({
    cursor: "context-menu"
  });
  if (linksCounter > 1) {
    return /* @__PURE__ */ jsxRuntime.jsx(WithContextMenu, { renderMenuItems: renderMenuGroupItems, children: ({ openMenu }) => {
      return children({ openMenu, targetClassName });
    } });
  } else {
    const linkModel = links()[0];
    return /* @__PURE__ */ jsxRuntime.jsx(
      "a",
      {
        href: linkModel.href,
        onClick: linkModel.onClick,
        target: linkModel.target,
        title: linkModel.title,
        style: { ...style, overflow: "hidden", display: "flex" },
        "data-testid": e2eSelectors.selectors.components.DataLinksContextMenu.singleLink,
        children: children({})
      }
    );
  }
};
const getStyles$z = (theme) => ({
  itemWrapper: css.css({
    fontSize: 12
  })
});

const defaultScale$1 = {
  mode: data.ThresholdsMode.Absolute,
  steps: [
    {
      color: "blue",
      value: -Infinity
    },
    {
      color: "green",
      value: 20
    }
  ]
};
const BarGaugeCell$1 = (props) => {
  var _a;
  const { field, innerWidth, tableStyles, cell, cellProps, row } = props;
  const displayValue = field.display(cell.value);
  const cellOptions = getCellOptions$1(field);
  let config = data.getFieldConfigWithMinMax(field, false);
  if (!config.thresholds) {
    config = {
      ...config,
      thresholds: defaultScale$1
    };
  }
  let barGaugeMode = schema.BarGaugeDisplayMode.Gradient;
  let valueDisplayMode = void 0;
  if (cellOptions.type === schema.TableCellDisplayMode.Gauge) {
    barGaugeMode = (_a = cellOptions.mode) != null ? _a : schema.BarGaugeDisplayMode.Gradient;
    valueDisplayMode = cellOptions.valueDisplayMode !== void 0 ? cellOptions.valueDisplayMode : schema.BarGaugeValueMode.Text;
  }
  const getLinks = () => {
    if (!lodash.isFunction(field.getLinks)) {
      return [];
    }
    return field.getLinks({ valueRowIndex: row.index });
  };
  const hasLinks = Boolean(getLinks().length);
  const alignmentFactors = getAlignmentFactor$1(field, displayValue, cell.row.index);
  const renderComponent = (menuProps) => {
    const { openMenu, targetClassName } = menuProps;
    return /* @__PURE__ */ jsxRuntime.jsx(
      BarGauge,
      {
        width: innerWidth,
        height: tableStyles.cellHeightInner,
        field: config,
        display: field.display,
        text: { valueSize: 14 },
        value: displayValue,
        orientation: data.VizOrientation.Horizontal,
        theme: tableStyles.theme,
        alignmentFactors,
        onClick: openMenu,
        className: targetClassName,
        itemSpacing: 1,
        lcdCellWidth: 8,
        displayMode: barGaugeMode,
        valueDisplayMode
      }
    );
  };
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: tableStyles.cellContainer, children: hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(DataLinksContextMenu, { links: getLinks, style: { display: "flex", width: "100%" }, children: (api) => renderComponent(api) }) : renderComponent({}) });
};

const DataLinksCell$1 = (props) => {
  const { field, row, cellProps, tableStyles } = props;
  const links = getCellLinks$1(field, row);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: tableStyles.cellContainerText, children: links && links.map((link, idx) => {
    return (
      // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
      /* @__PURE__ */ jsxRuntime.jsx("span", { className: tableStyles.cellLink, onClick: link.onClick, children: /* @__PURE__ */ jsxRuntime.jsx("a", { href: link.href, target: link.target, children: link.title }) }, idx)
    );
  }) });
};

const FILTER_FOR_OPERATOR$1 = "=";
const FILTER_OUT_OPERATOR$1 = "!=";

function CellActions({
  field,
  cell,
  previewMode,
  showFilters,
  onCellFilterAdded,
  setInspectCell
}) {
  var _a;
  const isRightAligned = getTextAlign$1(field) === "flex-end";
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const commonButtonProps = {
    size: "sm",
    tooltipPlacement: "top"
  };
  const onFilterFor = React.useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_FOR_OPERATOR$1, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  const onFilterOut = React.useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_OUT_OPERATOR$1, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: `cellActions${isRightAligned ? " cellActionsLeft" : ""}`, children: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { gap: 0.5, children: [
    inspectEnabled && /* @__PURE__ */ jsxRuntime.jsx(
      IconButton,
      {
        name: "eye",
        tooltip: t("grafana-ui.table.cell-inspect", "Inspect value"),
        onClick: () => {
          if (setInspectCell) {
            setInspectCell({ value: cell.value, mode: previewMode });
          }
        },
        ...commonButtonProps
      }
    ),
    showFilters && /* @__PURE__ */ jsxRuntime.jsx(
      IconButton,
      {
        name: "search-plus",
        onClick: onFilterFor,
        tooltip: t("grafana-ui.table.cell-filter-on", "Filter for value"),
        ...commonButtonProps
      }
    ),
    showFilters && /* @__PURE__ */ jsxRuntime.jsx(
      IconButton,
      {
        name: "search-minus",
        onClick: onFilterOut,
        tooltip: t("grafana-ui.table.cell-filter-out", "Filter out value"),
        ...commonButtonProps
      }
    )
  ] }) });
}

const DefaultCell = (props) => {
  var _a, _b, _c;
  const { field, cell, tableStyles, row, cellProps, frame, rowStyled, rowExpanded, textWrapped, height } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const displayValue = field.display(cell.value);
  const showFilters = props.onCellFilterAdded && field.config.filterable;
  const showActions = showFilters && cell.value !== void 0 || inspectEnabled;
  const cellOptions = getCellOptions$1(field);
  const hasLinks = Boolean((_b = getCellLinks$1(field, row)) == null ? void 0 : _b.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  let value;
  const OG_TWEET_LENGTH = 140;
  if (cellOptions.type === schema.TableCellDisplayMode.Custom) {
    const CustomCellComponent = cellOptions.cellComponent;
    value = /* @__PURE__ */ jsxRuntime.jsx(CustomCellComponent, { field, value: cell.value, rowIndex: row.index, frame });
  } else {
    if (React__namespace.isValidElement(cell.value)) {
      value = cell.value;
    } else {
      value = data.formattedValueToString(displayValue);
    }
  }
  const isStringValue = typeof value === "string";
  const textShouldWrap = displayValue.text.length <= OG_TWEET_LENGTH && /\s/.test(displayValue.text);
  const cellStyle = getCellStyle(
    tableStyles,
    cellOptions,
    displayValue,
    inspectEnabled,
    isStringValue,
    textShouldWrap,
    textWrapped,
    rowStyled,
    rowExpanded
  );
  if (isStringValue) {
    let justifyContent = (_c = cellProps.style) == null ? void 0 : _c.justifyContent;
    if (justifyContent === "flex-end") {
      cellProps.style = { ...cellProps.style, textAlign: "right" };
    } else if (justifyContent === "center") {
      cellProps.style = { ...cellProps.style, textAlign: "center" };
    }
  }
  if (height) {
    cellProps.style = { ...cellProps.style, height };
  }
  if (textWrapped) {
    cellProps.style = { ...cellProps.style, textWrap: "wrap" };
  }
  const { key, ...rest } = cellProps;
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { ...rest, className: cellStyle, children: [
    hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(DataLinksContextMenu, { links: () => getCellLinks$1(field, row) || [], children: (api) => {
      if (api.openMenu) {
        return /* @__PURE__ */ jsxRuntime.jsx(
          "button",
          {
            className: css.cx(clearButtonStyle, getLinkStyle$1(tableStyles, cellOptions, api.targetClassName)),
            onClick: api.openMenu,
            children: value
          }
        );
      } else {
        return /* @__PURE__ */ jsxRuntime.jsx("div", { className: getLinkStyle$1(tableStyles, cellOptions, api.targetClassName), children: value });
      }
    } }) : isStringValue ? `${value}` : /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.cellText, children: value }),
    showActions && /* @__PURE__ */ jsxRuntime.jsx(CellActions, { ...props, previewMode: TableCellInspectorMode.text, showFilters })
  ] }, key);
};
function getCellStyle(tableStyles, cellOptions, displayValue, disableOverflowOnHover = false, isStringValue = false, shouldWrapText = false, textWrapped = false, rowStyled = false, rowExpanded = false) {
  let textColor = void 0;
  let bgColor = void 0;
  let bgHoverColor = void 0;
  const colors = getCellColors$1(tableStyles.theme, cellOptions, displayValue);
  textColor = colors.textColor;
  bgColor = colors.bgColor;
  bgHoverColor = colors.bgHoverColor;
  return tableStyles.buildCellContainerStyle(
    textColor,
    bgColor,
    bgHoverColor,
    !disableOverflowOnHover,
    isStringValue,
    shouldWrapText,
    textWrapped,
    rowStyled,
    rowExpanded
  );
}
function getLinkStyle$1(tableStyles, cellOptions, targetClassName) {
  if (cellOptions.type === schema.TableCellDisplayMode.Auto) {
    return css.cx(tableStyles.cellLink, targetClassName);
  }
  return css.cx(tableStyles.cellLinkForColoredCell, targetClassName);
}

function GeoCell$1(props) {
  const { cell, tableStyles, cellProps } = props;
  let disp = "";
  if (cell.value instanceof geom.Geometry) {
    disp = new WKT__default.default().writeGeometry(cell.value, {
      featureProjection: "EPSG:3857",
      dataProjection: "EPSG:4326"
    });
  } else if (cell.value != null) {
    disp = `${cell.value}`;
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: tableStyles.cellContainer, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.cellText, style: { fontFamily: "monospace" }, children: disp }) });
}

const DATALINKS_HEIGHT_OFFSET$1 = 10;
const ImageCell$1 = (props) => {
  var _a;
  const { field, cell, tableStyles, row, cellProps } = props;
  const cellOptions = getCellOptions$1(field);
  const { title, alt } = cellOptions.type === schema.TableCellDisplayMode.Image ? cellOptions : { title: void 0, alt: void 0 };
  const displayValue = field.display(cell.value);
  const hasLinks = Boolean((_a = getCellLinks$1(field, row)) == null ? void 0 : _a.length);
  const img = /* @__PURE__ */ jsxRuntime.jsx(
    "img",
    {
      style: { height: tableStyles.cellHeight - DATALINKS_HEIGHT_OFFSET$1, width: "auto" },
      src: displayValue.text,
      className: tableStyles.imageCell,
      alt,
      title
    }
  );
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: tableStyles.cellContainer, children: hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(
    DataLinksContextMenu,
    {
      style: { height: tableStyles.cellHeight - DATALINKS_HEIGHT_OFFSET$1, width: "auto" },
      links: () => getCellLinks$1(field, row) || [],
      children: (api) => {
        if (api.openMenu) {
          return /* @__PURE__ */ jsxRuntime.jsx(
            "div",
            {
              onClick: api.openMenu,
              role: "button",
              tabIndex: 0,
              onKeyDown: (e) => {
                if (e.key === "Enter" && api.openMenu) {
                  api.openMenu(e);
                }
              },
              children: img
            }
          );
        } else {
          return img;
        }
      }
    }
  ) : img });
};

function JSONViewCell(props) {
  var _a, _b;
  const { cell, tableStyles, cellProps, field, row } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const txt = css.css({
    cursor: "pointer",
    fontFamily: "monospace"
  });
  let value = cell.value;
  let displayValue = value;
  if (lodash.isString(value)) {
    try {
      value = JSON.parse(value);
    } catch (e) {
    }
  } else {
    displayValue = JSON.stringify(value, null, " ");
  }
  const hasLinks = Boolean((_b = getCellLinks$1(field, row)) == null ? void 0 : _b.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { ...cellProps, className: inspectEnabled ? tableStyles.cellContainerNoOverflow : tableStyles.cellContainer, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(tableStyles.cellText, txt), children: hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(DataLinksContextMenu, { links: () => getCellLinks$1(field, row) || [], children: (api) => {
      if (api.openMenu) {
        return /* @__PURE__ */ jsxRuntime.jsx(Button, { className: css.cx(clearButtonStyle), onClick: api.openMenu, children: displayValue });
      } else {
        return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: displayValue });
      }
    } }) : /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.cellText, children: displayValue }) }),
    inspectEnabled && /* @__PURE__ */ jsxRuntime.jsx(CellActions, { ...props, previewMode: TableCellInspectorMode.code })
  ] });
}

const FIXED_UNIT = "__fixed";
class PlotConfigBuilder {
  constructor(props) {
    this.props = props;
  }
}

function buildScaleKey$1(config, fieldType) {
  var _a, _b, _c, _d, _e, _f, _g;
  const defaultPart = "na";
  const scaleRange = `${config.min !== void 0 ? config.min : defaultPart}-${config.max !== void 0 ? config.max : defaultPart}`;
  const scaleSoftRange = `${((_a = config.custom) == null ? void 0 : _a.axisSoftMin) !== void 0 ? config.custom.axisSoftMin : defaultPart}-${((_b = config.custom) == null ? void 0 : _b.axisSoftMax) !== void 0 ? config.custom.axisSoftMax : defaultPart}`;
  const scalePlacement = `${((_c = config.custom) == null ? void 0 : _c.axisPlacement) !== void 0 ? (_d = config.custom) == null ? void 0 : _d.axisPlacement : schema.AxisPlacement.Auto}`;
  const scaleUnit = (_e = config.unit) != null ? _e : FIXED_UNIT;
  const scaleDistribution = ((_f = config.custom) == null ? void 0 : _f.scaleDistribution) ? getScaleDistributionPart$1(config.custom.scaleDistribution) : schema.ScaleDistribution.Linear;
  const scaleLabel = Boolean((_g = config.custom) == null ? void 0 : _g.axisLabel) ? config.custom.axisLabel : defaultPart;
  return `${scaleUnit}/${scaleRange}/${scaleSoftRange}/${scalePlacement}/${scaleDistribution}/${scaleLabel}/${fieldType}`;
}
function getScaleDistributionPart$1(config) {
  if (config.type === schema.ScaleDistribution.Log) {
    return `${config.type}${config.log}`;
  }
  return config.type;
}

const paddingSide = (u, side, sidesWithAxes) => {
  let hasCrossAxis = side % 2 ? sidesWithAxes[0] || sidesWithAxes[2] : sidesWithAxes[1] || sidesWithAxes[3];
  return sidesWithAxes[side] || !hasCrossAxis ? 0 : 8;
};
const DEFAULT_PLOT_CONFIG = {
  ms: 1,
  focus: {
    alpha: 1
  },
  cursor: {
    focus: {
      prox: 30
    }
  },
  legend: {
    show: false
  },
  padding: [paddingSide, paddingSide, paddingSide, paddingSide],
  series: [],
  hooks: {}
};
function getStackingBands(group) {
  let bands = [];
  let { series, dir } = group;
  let lastIdx = series.length - 1;
  let rSeries = series.slice().reverse();
  rSeries.forEach((si, i) => {
    if (i !== lastIdx) {
      let nextIdx = rSeries[i + 1];
      bands.push({
        series: [si, nextIdx],
        // fill direction is inverted from stack direction
        dir: -1 * dir
      });
    }
  });
  return bands;
}
function getStackingGroups(frame) {
  let groups = /* @__PURE__ */ new Map();
  frame.fields.forEach(({ config, values, type }, i) => {
    var _a;
    if (i === 0) {
      return;
    }
    let { custom } = config;
    if (custom == null) {
      return;
    }
    if ((_a = custom.hideFrom) == null ? void 0 : _a.viz) {
      return;
    }
    let { stacking } = custom;
    if (stacking == null) {
      return;
    }
    let { mode: stackingMode, group: stackingGroup } = stacking;
    if (stackingMode === schema.StackingMode.None) {
      return;
    }
    let transform = custom.transform;
    let stackDir = getStackDirection(transform, values);
    let drawStyle = custom.drawStyle;
    let drawStyle2 = drawStyle === schema.GraphDrawStyle.Bars ? custom.barAlignment : drawStyle === schema.GraphDrawStyle.Line ? custom.lineInterpolation : null;
    let stackKey = `${stackDir}|${stackingMode}|${stackingGroup}|${buildScaleKey$1(
      config,
      type
    )}|${drawStyle}|${drawStyle2}`;
    let group = groups.get(stackKey);
    if (group == null) {
      group = {
        series: [],
        dir: stackDir
      };
      groups.set(stackKey, group);
    }
    group.series.push(i);
  });
  return [...groups.values()];
}
function preparePlotData2(frame, stackingGroups, onStackMeta) {
  let data$1 = Array(frame.fields.length);
  let stacksQty = stackingGroups.length;
  let dataLen = frame.length;
  let zeroArr = stacksQty > 0 ? Array(dataLen).fill(0) : [];
  let falseArr = stacksQty > 0 ? Array(dataLen).fill(false) : [];
  let accums = Array.from({ length: stacksQty }, () => zeroArr.slice());
  let anyValsAtX = Array.from({ length: stacksQty }, () => falseArr.slice());
  stackingGroups.forEach((group, groupIdx) => {
    let groupValsAtX = anyValsAtX[groupIdx];
    group.series.forEach((seriesIdx) => {
      var _a, _b;
      let field = frame.fields[seriesIdx];
      if ((_b = (_a = field.config.custom) == null ? void 0 : _a.hideFrom) == null ? void 0 : _b.viz) {
        return;
      }
      let vals = field.values;
      for (let i = 0; i < dataLen; i++) {
        if (vals[i] != null) {
          groupValsAtX[i] = true;
        }
      }
    });
  });
  frame.fields.forEach((field, i) => {
    var _a, _b;
    let vals = field.values;
    if (i === 0) {
      if (field.type === data.FieldType.time) {
        data$1[0] = data.ensureTimeField(field).values;
      } else {
        data$1[0] = vals;
      }
      return;
    }
    let { custom } = field.config;
    if (!custom || ((_a = custom.hideFrom) == null ? void 0 : _a.viz)) {
      data$1[i] = vals;
      return;
    }
    if (custom.transform === schema.GraphTransform.Constant) {
      let firstValIdx = vals.findIndex((v) => v != null);
      let firstVal = vals[firstValIdx];
      vals = Array(vals.length).fill(void 0);
      vals[firstValIdx] = firstVal;
    } else {
      vals = vals.slice();
      if (custom.transform === schema.GraphTransform.NegativeY) {
        for (let i2 = 0; i2 < vals.length; i2++) {
          if (vals[i2] != null) {
            vals[i2] *= -1;
          }
        }
      }
    }
    let stackingMode = (_b = custom.stacking) == null ? void 0 : _b.mode;
    if (!stackingMode || stackingMode === schema.StackingMode.None) {
      data$1[i] = vals;
    } else {
      let stackIdx = stackingGroups.findIndex((group) => group.series.indexOf(i) > -1);
      let accum = accums[stackIdx];
      let groupValsAtX = anyValsAtX[stackIdx];
      let stacked = data$1[i] = Array(dataLen);
      for (let i2 = 0; i2 < dataLen; i2++) {
        let v = vals[i2];
        if (v != null) {
          stacked[i2] = accum[i2] += v;
        } else {
          stacked[i2] = groupValsAtX[i2] ? accum[i2] : v;
        }
      }
    }
  });
  frame.fields.forEach((field, i) => {
    var _a, _b, _c, _d;
    if (i === 0 || ((_b = (_a = field.config.custom) == null ? void 0 : _a.hideFrom) == null ? void 0 : _b.viz)) {
      return;
    }
    let stackingMode = (_d = (_c = field.config.custom) == null ? void 0 : _c.stacking) == null ? void 0 : _d.mode;
    if (stackingMode === schema.StackingMode.Percent) {
      let stackIdx = stackingGroups.findIndex((group2) => group2.series.indexOf(i) > -1);
      let accum = accums[stackIdx];
      let group = stackingGroups[stackIdx];
      let stacked = data$1[i];
      for (let i2 = 0; i2 < dataLen; i2++) {
        let v = stacked[i2];
        if (v != null) {
          stacked[i2] = accum[i2] === 0 ? 0 : group.dir * (v / accum[i2]);
        }
      }
    }
  });
  return data$1;
}
function findMidPointYPosition(u, idx) {
  let y;
  let sMaxIdx = 1;
  let sMinIdx = 1;
  let max = u.data[1][idx];
  let min = u.data[1][idx];
  for (let i = 1; i < u.data.length; i++) {
    const sData = u.data[i];
    const sVal = sData[idx];
    if (sVal != null) {
      if (max == null) {
        max = sVal;
      } else {
        if (sVal > max) {
          max = u.data[i][idx];
          sMaxIdx = i;
        }
      }
      if (min == null) {
        min = sVal;
      } else {
        if (sVal < min) {
          min = u.data[i][idx];
          sMinIdx = i;
        }
      }
    }
  }
  if (min == null && max == null) {
    y = void 0;
  } else if (min != null && max != null) {
    y = (u.valToPos(min, u.series[sMinIdx].scale) + u.valToPos(max, u.series[sMaxIdx].scale)) / 2;
  } else {
    y = u.valToPos(min || max, u.series[sMaxIdx || sMinIdx].scale);
  }
  if (y !== void 0 && y < 0) {
    y = u.bbox.height / devicePixelRatio;
  }
  return y;
}
function getStackDirection(transform, data) {
  const hasNegSamp = hasNegSample(data);
  if (transform === schema.GraphTransform.NegativeY) {
    return hasNegSamp ? 1 /* Pos */ : -1 /* Neg */;
  }
  return hasNegSamp ? -1 /* Neg */ : 1 /* Pos */;
}
function hasNegSample(data, samples = 100) {
  const len = data.length;
  if (len === 0) {
    return false;
  }
  let firstIdx = 0;
  let lastIdx = len - 1;
  while (firstIdx <= lastIdx && data[firstIdx] == null) {
    firstIdx++;
  }
  while (lastIdx >= firstIdx && data[lastIdx] == null) {
    lastIdx--;
  }
  let negCount = 0;
  let posCount = 0;
  if (lastIdx >= firstIdx) {
    const stride = Math.max(1, Math.floor((lastIdx - firstIdx + 1) / samples));
    for (let i = firstIdx; i <= lastIdx; i += stride) {
      const v = data[i];
      if (v != null && typeof v === "number") {
        if (v < 0 || Object.is(v, -0)) {
          negCount++;
        } else if (v > 0) {
          posCount++;
        }
      }
    }
    if (negCount > posCount) {
      return true;
    }
  }
  return false;
}
const getDisplayValuesForCalcs = (calcs, field, theme) => {
  var _a;
  if (!(calcs == null ? void 0 : calcs.length)) {
    return [];
  }
  const defaultFormatter = (v) => v == null ? "-" : v.toFixed(1);
  const fmt = (_a = field.display) != null ? _a : defaultFormatter;
  let countFormatter = null;
  const fieldCalcs = data.reduceField({
    field,
    reducers: calcs
  });
  return calcs.map((reducerId) => {
    const fieldReducer = data.fieldReducers.get(reducerId);
    let formatter = fmt;
    if (fieldReducer.id === data.ReducerID.diffperc) {
      formatter = data.getDisplayProcessor({
        field: {
          ...field,
          config: {
            ...field.config,
            unit: "percent"
          }
        },
        theme
      });
    }
    if (fieldReducer.id === data.ReducerID.count || fieldReducer.id === data.ReducerID.changeCount || fieldReducer.id === data.ReducerID.distinctCount) {
      if (!countFormatter) {
        countFormatter = data.getDisplayProcessor({
          field: {
            ...field,
            config: {
              ...field.config,
              unit: "none"
            }
          },
          theme
        });
      }
      formatter = countFormatter;
    }
    return {
      ...formatter(fieldCalcs[reducerId]),
      title: fieldReducer.name,
      description: fieldReducer.description
    };
  });
};
const pluginLogger = createLogger("uPlot");
const pluginLog = pluginLogger.logger;
attachDebugger("graphng", void 0, pluginLogger);

function sameDims(prevProps, nextProps) {
  return nextProps.width === prevProps.width && nextProps.height === prevProps.height;
}
function sameData(prevProps, nextProps) {
  return nextProps.data === prevProps.data;
}
function sameConfig(prevProps, nextProps) {
  return nextProps.config === prevProps.config;
}
class UPlotChart extends React.Component {
  constructor(props) {
    super(props);
    this.plotContainer = React.createRef();
    this.plotCanvasBBox = React.createRef();
    this.plotInstance = null;
  }
  reinitPlot() {
    var _a;
    let { width, height, plotRef } = this.props;
    (_a = this.plotInstance) == null ? void 0 : _a.destroy();
    if (width === 0 && height === 0) {
      return;
    }
    this.props.config.addHook("setSize", (u) => {
      const canvas = u.over;
      if (!canvas) {
        return;
      }
    });
    const config = {
      width: Math.floor(this.props.width),
      height: Math.floor(this.props.height),
      ...this.props.config.getConfig()
    };
    pluginLog("UPlot", false, "Reinitializing plot", config);
    const plot = new uPlot__default.default(config, this.props.data, this.plotContainer.current);
    if (plotRef) {
      plotRef(plot);
    }
    this.plotInstance = plot;
  }
  componentDidMount() {
    this.reinitPlot();
  }
  componentWillUnmount() {
    var _a;
    (_a = this.plotInstance) == null ? void 0 : _a.destroy();
  }
  componentDidUpdate(prevProps) {
    var _a, _b;
    if (!sameDims(prevProps, this.props)) {
      (_a = this.plotInstance) == null ? void 0 : _a.setSize({
        width: Math.floor(this.props.width),
        height: Math.floor(this.props.height)
      });
    } else if (!sameConfig(prevProps, this.props)) {
      this.reinitPlot();
    } else if (!sameData(prevProps, this.props)) {
      (_b = this.plotInstance) == null ? void 0 : _b.setData(this.props.data);
    }
  }
  render() {
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: { position: "relative" }, children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { ref: this.plotContainer, "data-testid": "uplot-main-div" }),
      this.props.children
    ] });
  }
}

class UPlotScaleBuilder extends PlotConfigBuilder {
  merge(props) {
    this.props.min = optMinMax("min", this.props.min, props.min);
    this.props.max = optMinMax("max", this.props.max, props.max);
  }
  getConfig() {
    var _a, _b;
    let {
      isTime,
      scaleKey,
      min: hardMin,
      max: hardMax,
      softMin,
      softMax,
      range,
      direction,
      orientation,
      centeredZero,
      decimals,
      stackingMode
    } = this.props;
    if (stackingMode === schema.StackingMode.Percent) {
      if (hardMin == null && softMin == null) {
        softMin = 0;
      }
      if (hardMax == null && softMax == null) {
        softMax = 1;
      }
    }
    const distr = this.props.distribution;
    const distribution = !isTime ? {
      distr: distr === schema.ScaleDistribution.Symlog ? 4 : distr === schema.ScaleDistribution.Log ? 3 : distr === schema.ScaleDistribution.Ordinal ? 2 : 1,
      log: distr === schema.ScaleDistribution.Log || distr === schema.ScaleDistribution.Symlog ? (_a = this.props.log) != null ? _a : 2 : void 0,
      asinh: distr === schema.ScaleDistribution.Symlog ? (_b = this.props.linearThreshold) != null ? _b : 1 : void 0
    } : {};
    if (distr === schema.ScaleDistribution.Log) {
      let logBase = this.props.log;
      let logFn = logBase === 2 ? Math.log2 : Math.log10;
      if (hardMin != null) {
        if (hardMin <= 0) {
          hardMin = null;
        } else {
          hardMin = logBase ** Math.floor(logFn(hardMin));
        }
      }
      if (hardMax != null) {
        if (hardMax <= 0) {
          hardMax = null;
        } else {
          hardMax = logBase ** Math.ceil(logFn(hardMax));
        }
      }
      if (softMin != null) {
        if (softMin <= 0) {
          softMin = null;
        } else {
          softMin = logBase ** Math.floor(logFn(softMin));
        }
      }
      if (softMax != null) {
        if (softMax <= 0) {
          softMax = null;
        } else {
          softMax = logBase ** Math.ceil(logFn(softMax));
        }
      }
    }
    let softMinMode = softMin == null ? 3 : 1;
    let softMaxMode = softMax == null ? 3 : 1;
    const rangeConfig = {
      min: {
        pad: 0.1,
        hard: hardMin != null ? hardMin : -Infinity,
        soft: softMin || 0,
        mode: softMinMode
      },
      max: {
        pad: 0.1,
        hard: hardMax != null ? hardMax : Infinity,
        soft: softMax || 0,
        mode: softMaxMode
      }
    };
    let hardMinOnly = softMin == null && hardMin != null;
    let hardMaxOnly = softMax == null && hardMax != null;
    let hasFixedRange = hardMinOnly && hardMaxOnly;
    const rangeFn = (u, dataMin, dataMax, scaleKey2) => {
      var _a2;
      const scale = u.scales[scaleKey2];
      let minMax = [dataMin, dataMax];
      if (!hasFixedRange && dataMin == null && dataMax == null) {
        return minMax;
      }
      let logBase = (_a2 = scale.log) != null ? _a2 : 10;
      if (scale.distr === 1 || scale.distr === 2 || scale.distr === 4) {
        if (centeredZero) {
          let absMin = Math.abs(dataMin);
          let absMax = Math.abs(dataMax);
          let max = Math.max(absMin, absMax);
          if (max === 0) {
            max = 80;
          }
          dataMin = -max;
          dataMax = max;
        }
        if (scale.distr === 4) {
          minMax = uPlot__default.default.rangeAsinh(dataMin, dataMax, logBase, true);
        } else {
          minMax = uPlot__default.default.rangeNum(hardMinOnly ? hardMin : dataMin, hardMaxOnly ? hardMax : dataMax, rangeConfig);
        }
      } else if (scale.distr === 3) {
        minMax = uPlot__default.default.rangeLog(hardMin != null ? hardMin : dataMin, hardMax != null ? hardMax : dataMax, logBase, true);
      }
      if (decimals === 0) {
        if (scale.distr === 1 || scale.distr === 2) {
          minMax[0] = data.incrRoundDn(minMax[0], 1);
          minMax[1] = data.incrRoundUp(minMax[1], 1);
        } else if (scale.distr === 3) {
          let logFn = scale.log === 2 ? Math.log2 : Math.log10;
          if (minMax[0] <= 1) {
            minMax[0] = 1;
          } else {
            let minExp = Math.floor(logFn(minMax[0]));
            minMax[0] = logBase ** minExp;
          }
          let maxExp = Math.ceil(logFn(minMax[1]));
          minMax[1] = logBase ** maxExp;
          if (minMax[0] === minMax[1]) {
            minMax[1] *= logBase;
          }
        } else if (scale.distr === 4) {
          minMax[0] = data.incrRoundDn(minMax[0], 1);
          minMax[1] = data.incrRoundUp(minMax[1], 1);
        }
      }
      if (scale.distr === 1 || scale.distr === 4) {
        if (hardMinOnly) {
          minMax[0] = hardMin;
        }
        if (hardMaxOnly) {
          minMax[1] = hardMax;
        }
      }
      if (minMax[0] >= minMax[1]) {
        minMax[0] = scale.distr === 3 ? 1 : 0;
        minMax[1] = 100;
      }
      return minMax;
    };
    let auto = !isTime && !hasFixedRange;
    if (data.isBooleanUnit(scaleKey)) {
      auto = false;
      range = [0, 1];
    }
    return {
      [scaleKey]: {
        time: isTime,
        auto,
        range: range != null ? range : rangeFn,
        dir: direction,
        ori: orientation,
        ...distribution
      }
    };
  }
}
function optMinMax(minmax, a, b) {
  const hasA = !(a === void 0 || a === null);
  const hasB = !(b === void 0 || b === null);
  if (hasA) {
    if (!hasB) {
      return a;
    }
    if (minmax === "min") {
      return a < b ? a : b;
    }
    return a > b ? a : b;
  }
  return b;
}

const UPLOT_AXIS_FONT_SIZE = 12;
const Y_TICK_SPACING_PANEL_HEIGHT = 150;
const Y_TICK_SPACING_NORMAL = 30;
const Y_TICK_SPACING_SMALL = 15;
const X_TICK_SPACING_NORMAL = 40;
const X_TICK_VALUE_GAP = 18;
const labelPad = 8;
class UPlotAxisBuilder extends PlotConfigBuilder {
  merge(props) {
    this.props.size = optMinMax("max", this.props.size, props.size);
    if (!this.props.label) {
      this.props.label = props.label;
    }
    if (this.props.placement === schema.AxisPlacement.Auto) {
      this.props.placement = props.placement;
    }
  }
  getConfig() {
    let {
      scaleKey,
      label,
      show = true,
      placement = schema.AxisPlacement.Auto,
      grid = { show: true },
      ticks,
      space,
      filter,
      gap = 5,
      formatValue,
      splits,
      values,
      incrs,
      isTime,
      timeZone,
      theme,
      tickLabelRotation,
      size,
      color,
      border,
      decimals,
      distr = schema.ScaleDistribution.Linear
    } = this.props;
    const font = `${UPLOT_AXIS_FONT_SIZE}px ${theme.typography.fontFamily}`;
    const gridColor = theme.isDark ? "rgba(240, 250, 255, 0.09)" : "rgba(0, 10, 23, 0.09)";
    if (data.isBooleanUnit(scaleKey)) {
      splits = [0, 1];
    }
    if (decimals === 0 && distr === schema.ScaleDistribution.Linear) {
      filter = (u, splits2) => splits2.map((v) => Number.isInteger(v) ? v : null);
    }
    let config = {
      scale: scaleKey,
      show,
      stroke: color != null ? color : theme.colors.text.primary,
      side: getUPlotSideFromAxis(placement),
      font,
      size: size != null ? size : (self, values2, axisIdx) => {
        return calculateAxisSize(self, values2, axisIdx);
      },
      rotate: tickLabelRotation,
      gap,
      labelGap: 0,
      grid: {
        show: grid.show,
        stroke: gridColor,
        width: 1 / devicePixelRatio
      },
      ticks: Object.assign(
        {
          show: true,
          stroke: (border == null ? void 0 : border.show) ? color != null ? color : theme.colors.text.primary : gridColor,
          width: 1 / devicePixelRatio,
          size: 4
        },
        ticks
      ),
      splits,
      values,
      space: space != null ? space : (self, axisIdx, scaleMin, scaleMax, plotDim) => {
        return calculateSpace(self, axisIdx, scaleMin, scaleMax, plotDim, formatValue);
      },
      filter,
      incrs
    };
    if (border == null ? void 0 : border.show) {
      config.border = {
        stroke: color != null ? color : theme.colors.text.primary,
        width: 1 / devicePixelRatio,
        ...border
      };
    }
    if (label != null && label.length > 0) {
      config.label = label;
      config.labelSize = UPLOT_AXIS_FONT_SIZE + labelPad;
      config.labelFont = font;
      config.labelGap = labelPad;
    }
    if (values) {
      config.values = values;
    } else if (isTime) {
      config.values = formatTime;
    } else if (formatValue) {
      config.values = (u, splits2, axisIdx, tickSpace, tickIncr) => {
        let decimals2 = data.guessDecimals(data.roundDecimals(tickIncr, 6));
        return splits2.map((v) => {
          if (v == null) {
            return null;
          } else {
            return formatValue(v, decimals2 > 0 ? decimals2 : void 0);
          }
        });
      };
    }
    config.timeZone = timeZone;
    return config;
  }
}
const timeUnitSize = {
  second: 1e3,
  minute: 60 * 1e3,
  hour: 60 * 60 * 1e3,
  day: 24 * 60 * 60 * 1e3,
  month: 28 * 24 * 60 * 60 * 1e3,
  year: 365 * 24 * 60 * 60 * 1e3
};
function formatTime(self, splits, axisIdx, foundSpace, foundIncr) {
  var _a, _b;
  const axis = self.axes[axisIdx];
  const timeZone = "timeZone" in axis && typeof axis.timeZone === "string" ? axis.timeZone : void 0;
  const scale = self.scales.x;
  const range = ((_a = scale == null ? void 0 : scale.max) != null ? _a : 0) - ((_b = scale == null ? void 0 : scale.min) != null ? _b : 0);
  const yearRoundedToDay = Math.round(timeUnitSize.year / timeUnitSize.day) * timeUnitSize.day;
  const incrementRoundedToDay = Math.round(foundIncr / timeUnitSize.day) * timeUnitSize.day;
  let format = data.systemDateFormats.interval.year;
  if (foundIncr < timeUnitSize.second) {
    format = data.systemDateFormats.interval.millisecond;
  } else if (foundIncr <= timeUnitSize.minute) {
    format = data.systemDateFormats.interval.second;
  } else if (range <= timeUnitSize.day) {
    format = data.systemDateFormats.interval.minute;
  } else if (foundIncr <= timeUnitSize.day) {
    format = data.systemDateFormats.interval.hour;
  } else if (range < timeUnitSize.year) {
    format = data.systemDateFormats.interval.day;
  } else if (incrementRoundedToDay === yearRoundedToDay) {
    format = data.systemDateFormats.interval.year;
  } else if (foundIncr <= timeUnitSize.year) {
    format = data.systemDateFormats.interval.month;
  }
  return splits.map((v) => v == null ? "" : data.dateTimeFormat(v, { format, timeZone }));
}
function calculateSpace(self, axisIdx, scaleMin, scaleMax, plotDim, formatValue) {
  const axis = self.axes[axisIdx];
  const scale = self.scales[axis.scale];
  if (axis.side !== 2 || !scale) {
    return plotDim <= Y_TICK_SPACING_PANEL_HEIGHT ? Y_TICK_SPACING_SMALL : Y_TICK_SPACING_NORMAL;
  }
  const maxTicks = plotDim / X_TICK_SPACING_NORMAL;
  const increment = (scaleMax - scaleMin) / maxTicks;
  const bigValue = Math.max(Math.abs(scaleMin), Math.abs(scaleMax));
  let sample = "";
  if (scale.time) {
    sample = formatTime(self, [bigValue], axisIdx, X_TICK_SPACING_NORMAL, increment)[0];
  } else if (formatValue != null) {
    sample = formatValue(bigValue);
  } else {
    return X_TICK_SPACING_NORMAL;
  }
  const valueWidth = measureText(sample, UPLOT_AXIS_FONT_SIZE).width;
  return valueWidth + X_TICK_VALUE_GAP;
}
function calculateAxisSize(self, values, axisIdx) {
  const axis = self.axes[axisIdx];
  let axisSize = axis.ticks.size;
  if (axis.side === 2) {
    axisSize += axis.gap + UPLOT_AXIS_FONT_SIZE;
  } else if (values == null ? void 0 : values.length) {
    let maxTextWidth = values.reduce((acc, value) => Math.max(acc, measureText(value, UPLOT_AXIS_FONT_SIZE).width), 0);
    const textWidthWithLimit = Math.min(self.width * 0.4, maxTextWidth);
    axisSize += axis.gap + axis.labelGap + textWidthWithLimit;
  }
  return Math.ceil(axisSize);
}
function getUPlotSideFromAxis(axis) {
  switch (axis) {
    case schema.AxisPlacement.Top:
      return 0;
    case schema.AxisPlacement.Right:
      return 1;
    case schema.AxisPlacement.Bottom:
      return 2;
    case schema.AxisPlacement.Left:
  }
  return 3;
}

function makeDirectionalGradient(direction, bbox, ctx) {
  let x0 = 0, y0 = 0, x1 = 0, y1 = 0;
  if (direction === 3 /* Down */) {
    y0 = bbox.top;
    y1 = bbox.top + bbox.height;
  } else if (direction === 2 /* Left */) {
    x0 = bbox.left + bbox.width;
    x1 = bbox.left;
  } else if (direction === 1 /* Up */) {
    y0 = bbox.top + bbox.height;
    y1 = bbox.top;
  } else if (direction === 0 /* Right */) {
    x0 = bbox.left;
    x1 = bbox.left + bbox.width;
  }
  return ctx.createLinearGradient(x0, y0, x1, y1);
}
function getOpacityGradientFn(color, opacity) {
  return (plot, seriesIdx) => {
    const ctx = getCanvasContext();
    const gradient = makeDirectionalGradient(
      plot.scales.x.ori === schema.ScaleOrientation.Horizontal ? 3 /* Down */ : 2 /* Left */,
      plot.bbox,
      ctx
    );
    gradient.addColorStop(0, data.colorManipulator.alpha(color, opacity));
    gradient.addColorStop(1, data.colorManipulator.alpha(color, 0));
    return gradient;
  };
}
function getHueGradientFn(color, opacity, theme) {
  return (plot, seriesIdx) => {
    const ctx = getCanvasContext();
    const gradient = makeDirectionalGradient(
      plot.scales.x.ori === schema.ScaleOrientation.Horizontal ? 3 /* Down */ : 2 /* Left */,
      plot.bbox,
      ctx
    );
    const color1 = tinycolor__default.default(color).spin(-25).darken(5);
    const color2 = tinycolor__default.default(color).saturate(20).spin(20).brighten(10);
    if (theme.isDark) {
      gradient.addColorStop(0, color2.lighten(10).setAlpha(opacity).toString());
      gradient.addColorStop(1, color1.darken(10).setAlpha(opacity).toString());
    } else {
      gradient.addColorStop(0, color2.lighten(10).setAlpha(opacity).toString());
      gradient.addColorStop(1, color1.setAlpha(opacity).toString());
    }
    return gradient;
  };
}
function scaleGradient(u, scaleKey, scaleStops, discrete = false) {
  let scale = u.scales[scaleKey];
  let minStopIdx = null;
  let maxStopIdx = null;
  for (let i = 0; i < scaleStops.length; i++) {
    let stopVal = scaleStops[i][0];
    if (stopVal <= scale.min || minStopIdx == null) {
      minStopIdx = i;
    }
    maxStopIdx = i;
    if (stopVal >= scale.max) {
      break;
    }
  }
  if (minStopIdx === maxStopIdx) {
    return scaleStops[minStopIdx][1];
  }
  let minStopVal = scaleStops[minStopIdx][0];
  let maxStopVal = scaleStops[maxStopIdx][0];
  if (minStopVal === -Infinity) {
    minStopVal = scale.min;
  }
  if (maxStopVal === Infinity) {
    maxStopVal = scale.max;
  }
  let minStopPos = Math.round(u.valToPos(minStopVal, scaleKey, true));
  let maxStopPos = Math.round(u.valToPos(maxStopVal, scaleKey, true));
  let range = minStopPos - maxStopPos;
  if (range === 0) {
    return scaleStops[maxStopIdx][1];
  }
  let x0, y0, x1, y1;
  if (u.scales.x.ori === schema.ScaleOrientation.Horizontal) {
    x0 = x1 = 0;
    y0 = minStopPos;
    y1 = maxStopPos;
  } else {
    y0 = y1 = 0;
    x0 = minStopPos;
    x1 = maxStopPos;
  }
  let ctx = getCanvasContext();
  let grd = ctx.createLinearGradient(x0, y0, x1, y1);
  let prevColor;
  for (let i = minStopIdx; i <= maxStopIdx; i++) {
    let s = scaleStops[i];
    let stopPos = i === minStopIdx ? minStopPos : i === maxStopIdx ? maxStopPos : Math.round(u.valToPos(s[0], scaleKey, true));
    let pct = (minStopPos - stopPos) / range;
    if (discrete && i > minStopIdx) {
      grd.addColorStop(pct, prevColor);
    }
    grd.addColorStop(pct, prevColor = s[1]);
  }
  return grd;
}
function getDataRange(plot, scaleKey) {
  let sc = plot.scales[scaleKey];
  let min = Infinity;
  let max = -Infinity;
  plot.series.forEach((ser, seriesIdx) => {
    if (ser.show && ser.scale === scaleKey) {
      if (ser.min == null) {
        let data = plot.data[seriesIdx];
        for (let i = 0; i < data.length; i++) {
          if (data[i] != null) {
            min = Math.min(min, data[i]);
            max = Math.max(max, data[i]);
          }
        }
      } else {
        min = Math.min(min, ser.min);
        max = Math.max(max, ser.max);
      }
    }
  });
  if (max === min) {
    min = sc.min;
    max = sc.max;
  }
  return [min, max];
}
function getGradientRange(u, scaleKey, hardMin, hardMax, softMin, softMax) {
  var _a, _b, _c, _d;
  let min = (_a = hardMin != null ? hardMin : softMin) != null ? _a : null;
  let max = (_b = hardMax != null ? hardMax : softMax) != null ? _b : null;
  if (min == null || max == null) {
    let [dataMin, dataMax] = getDataRange(u, scaleKey);
    min = (_c = min != null ? min : dataMin) != null ? _c : 0;
    max = (_d = max != null ? max : dataMax) != null ? _d : 100;
  }
  return [min, max];
}
function isStepTransparent(color) {
  return color === "transparent" || color[0] === "#" && color.slice(-2) === "00";
}
function getScaleGradientFn(opacity, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax) {
  if (!colorMode) {
    throw Error("Missing colorMode required for color scheme gradients");
  }
  if (!thresholds) {
    throw Error("Missing thresholds required for color scheme gradients");
  }
  return (plot, seriesIdx) => {
    let scaleKey = plot.series[seriesIdx].scale;
    let gradient = "";
    if (colorMode.id === data.FieldColorModeId.Thresholds) {
      if (thresholds.mode === data.ThresholdsMode.Absolute) {
        const valueStops = thresholds.steps.map((step) => [
          step.value,
          isStepTransparent(step.color) ? "#0000" : data.colorManipulator.alpha(theme.visualization.getColorByName(step.color), opacity)
        ]);
        gradient = scaleGradient(plot, scaleKey, valueStops, true);
      } else {
        const [min, max] = getGradientRange(plot, scaleKey, hardMin, hardMax, softMin, softMax);
        const range = max - min;
        const valueStops = thresholds.steps.map((step) => [
          min + range * (step.value / 100),
          data.colorManipulator.alpha(theme.visualization.getColorByName(step.color), opacity)
        ]);
        gradient = scaleGradient(plot, scaleKey, valueStops, true);
      }
    } else if (colorMode.getColors) {
      const colors = colorMode.getColors(theme);
      const [min, max] = getGradientRange(plot, scaleKey, hardMin, hardMax, softMin, softMax);
      const range = max - min;
      const valueStops = colors.map((color, i) => [
        min + range * (i / (colors.length - 1)),
        data.colorManipulator.alpha(theme.visualization.getColorByName(color), opacity)
      ]);
      gradient = scaleGradient(plot, scaleKey, valueStops, false);
    }
    return gradient;
  };
}

class UPlotSeriesBuilder extends PlotConfigBuilder {
  getConfig() {
    var _a;
    const {
      facets,
      drawStyle,
      pathBuilder,
      pointsBuilder,
      pointsFilter,
      lineInterpolation,
      lineWidth,
      lineStyle,
      barAlignment,
      barWidthFactor,
      barMaxWidth,
      showPoints,
      pointSize,
      scaleKey,
      pxAlign,
      spanNulls,
      show = true
    } = this.props;
    let lineConfig = {};
    let lineColor = this.getLineColor();
    lineConfig.stroke = lineColor;
    lineConfig.width = lineWidth;
    if (lineStyle && lineStyle.fill !== "solid") {
      if (lineStyle.fill === "dot") {
        lineConfig.cap = "round";
      }
      lineConfig.dash = (_a = lineStyle.dash) != null ? _a : [10, 10];
    }
    if (pathBuilder != null) {
      lineConfig.paths = pathBuilder;
    } else if (drawStyle === schema.GraphDrawStyle.Points) {
      lineConfig.paths = () => null;
    } else if (drawStyle != null) {
      lineConfig.paths = (self, seriesIdx, idx0, idx1) => {
        let pathsBuilder = mapDrawStyleToPathBuilder(
          drawStyle,
          lineInterpolation,
          barAlignment,
          barWidthFactor,
          barMaxWidth
        );
        return pathsBuilder(self, seriesIdx, idx0, idx1);
      };
    }
    const useColor = (
      // @ts-ignore
      typeof lineColor === "string" ? lineColor : (u, seriesIdx) => u.series[seriesIdx]._stroke
    );
    const pointsConfig = {
      points: {
        stroke: useColor,
        fill: useColor,
        size: !pointSize || pointSize < lineWidth ? void 0 : pointSize,
        filter: pointsFilter
      }
    };
    if (pointsBuilder != null) {
      pointsConfig.points.show = pointsBuilder;
    } else {
      if (drawStyle === schema.GraphDrawStyle.Points) {
        pointsConfig.points.show = true;
      } else {
        if (showPoints === schema.VisibilityMode.Auto) {
          if (drawStyle === schema.GraphDrawStyle.Bars) {
            pointsConfig.points.show = false;
          }
        } else if (showPoints === schema.VisibilityMode.Never) {
          pointsConfig.points.show = false;
        } else if (showPoints === schema.VisibilityMode.Always) {
          pointsConfig.points.show = true;
        }
      }
    }
    return {
      scale: scaleKey,
      facets,
      spanGaps: typeof spanNulls === "number" ? false : spanNulls,
      value: () => "",
      pxAlign,
      show,
      fill: this.getFill(),
      ...lineConfig,
      ...pointsConfig
    };
  }
  getLineColor() {
    const {
      lineColor,
      gradientMode,
      colorMode,
      thresholds,
      theme,
      hardMin,
      hardMax,
      softMin,
      softMax,
      dynamicSeriesColor
    } = this.props;
    if (gradientMode === schema.GraphGradientMode.None && dynamicSeriesColor) {
      return (plot, seriesIdx) => {
        var _a, _b;
        return (_b = (_a = dynamicSeriesColor(seriesIdx)) != null ? _a : lineColor) != null ? _b : data.FALLBACK_COLOR;
      };
    }
    if (gradientMode === schema.GraphGradientMode.Scheme && (colorMode == null ? void 0 : colorMode.id) !== data.FieldColorModeId.Fixed) {
      return getScaleGradientFn(1, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax);
    }
    if (gradientMode === schema.GraphGradientMode.Hue) {
      return getHueGradientFn(lineColor != null ? lineColor : data.FALLBACK_COLOR, 1, theme);
    }
    return lineColor != null ? lineColor : data.FALLBACK_COLOR;
  }
  getFill() {
    const {
      lineColor,
      fillColor,
      gradientMode,
      fillOpacity,
      colorMode,
      thresholds,
      theme,
      hardMin,
      hardMax,
      softMin,
      softMax,
      dynamicSeriesColor
    } = this.props;
    if (fillColor) {
      return fillColor;
    }
    const mode = gradientMode != null ? gradientMode : schema.GraphGradientMode.None;
    const opacityPercent = (fillOpacity != null ? fillOpacity : 0) / 100;
    if (mode === schema.GraphGradientMode.None && dynamicSeriesColor && opacityPercent > 0) {
      return (u, seriesIdx) => {
        let lineColor2 = u.series[seriesIdx]._stroke;
        return data.colorManipulator.alpha(lineColor2 != null ? lineColor2 : "", opacityPercent);
      };
    }
    switch (mode) {
      case schema.GraphGradientMode.Opacity:
        return getOpacityGradientFn(fillColor != null ? fillColor : lineColor, opacityPercent);
      case schema.GraphGradientMode.Hue:
        return getHueGradientFn(fillColor != null ? fillColor : lineColor, opacityPercent, theme);
      case schema.GraphGradientMode.Scheme:
        if ((colorMode == null ? void 0 : colorMode.id) !== data.FieldColorModeId.Fixed) {
          return getScaleGradientFn(opacityPercent, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax);
        }
      // intentional fall-through to handle Scheme with Fixed color
      default:
        if (opacityPercent > 0) {
          return data.colorManipulator.alpha(lineColor != null ? lineColor : "", opacityPercent);
        }
    }
    return void 0;
  }
}
let builders = void 0;
function mapDrawStyleToPathBuilder(style, lineInterpolation, barAlignment = schema.BarAlignment.Center, barWidthFactor = 0.6, barMaxWidth = 200) {
  const pathBuilders = uPlot__default.default.paths;
  if (!builders) {
    builders = {
      linear: pathBuilders.linear(),
      smooth: pathBuilders.spline(),
      stepBefore: pathBuilders.stepped({ align: -1 }),
      stepAfter: pathBuilders.stepped({ align: 1 })
    };
  }
  if (style === schema.GraphDrawStyle.Bars) {
    let barsCfgKey = `bars|${barAlignment}|${barWidthFactor}|${barMaxWidth}`;
    if (!builders[barsCfgKey]) {
      builders[barsCfgKey] = pathBuilders.bars({
        size: [barWidthFactor, barMaxWidth],
        align: barAlignment
      });
    }
    return builders[barsCfgKey];
  } else if (style === schema.GraphDrawStyle.Line) {
    if (lineInterpolation === schema.LineInterpolation.StepBefore) {
      return builders.stepBefore;
    }
    if (lineInterpolation === schema.LineInterpolation.StepAfter) {
      return builders.stepAfter;
    }
    if (lineInterpolation === schema.LineInterpolation.Smooth) {
      return builders.smooth;
    }
  }
  return builders.linear;
}

function getThresholdsDrawHook(options) {
  const dashSegments = options.config.mode === schema.GraphThresholdsStyleMode.Dashed || options.config.mode === schema.GraphThresholdsStyleMode.DashedAndArea ? [10, 10] : [];
  function addLines(u, yScaleKey, steps, theme2) {
    let ctx = u.ctx;
    let transparentIndex = 0;
    for (let idx = 0; idx < steps.length; idx++) {
      const step = steps[idx];
      if (step.color === "transparent") {
        transparentIndex = idx;
        break;
      }
    }
    ctx.lineWidth = 2;
    ctx.setLineDash(dashSegments);
    for (let idx = 1; idx < steps.length; idx++) {
      const step = steps[idx];
      let color;
      if (transparentIndex >= idx && idx > 0) {
        color = tinycolor__default.default(theme2.visualization.getColorByName(steps[idx - 1].color));
      } else {
        color = tinycolor__default.default(theme2.visualization.getColorByName(step.color));
      }
      if (color.getAlpha() === 1) {
        color.setAlpha(0.7);
      }
      const isHorizontal = u.scales.x.ori === schema.ScaleOrientation.Horizontal;
      const scaleVal = u.valToPos(step.value, yScaleKey, true);
      let x0 = Math.round(isHorizontal ? u.bbox.left : scaleVal);
      let y0 = Math.round(isHorizontal ? scaleVal : u.bbox.top);
      let x1 = Math.round(isHorizontal ? u.bbox.left + u.bbox.width : scaleVal);
      let y1 = Math.round(isHorizontal ? scaleVal : u.bbox.top + u.bbox.height);
      ctx.beginPath();
      ctx.moveTo(x0, y0);
      ctx.lineTo(x1, y1);
      ctx.strokeStyle = color.toString();
      ctx.stroke();
    }
  }
  function addAreas(u, yScaleKey, steps, theme2) {
    let ctx = u.ctx;
    let grd = scaleGradient(
      u,
      yScaleKey,
      steps.map((step) => {
        let color = tinycolor__default.default(theme2.visualization.getColorByName(step.color));
        if (color.getAlpha() === 1) {
          color.setAlpha(0.15);
        }
        return [step.value, color.toString()];
      }),
      true
    );
    ctx.fillStyle = grd;
    ctx.fillRect(u.bbox.left, u.bbox.top, u.bbox.width, u.bbox.height);
  }
  const { scaleKey, thresholds, theme, config, hardMin, hardMax, softMin, softMax } = options;
  return (u) => {
    const ctx = u.ctx;
    const { min: xMin, max: xMax } = u.scales.x;
    const { min: yMin, max: yMax } = u.scales[scaleKey];
    if (xMin == null || xMax == null || yMin == null || yMax == null) {
      return;
    }
    let { steps, mode } = thresholds;
    if (mode === data.ThresholdsMode.Percentage) {
      let [min, max] = getGradientRange(u, scaleKey, hardMin, hardMax, softMin, softMax);
      let range = max - min;
      steps = steps.map((step) => ({
        ...step,
        value: min + range * (step.value / 100)
      }));
    }
    ctx.save();
    switch (config.mode) {
      case schema.GraphThresholdsStyleMode.Line:
      case schema.GraphThresholdsStyleMode.Dashed:
        addLines(u, scaleKey, steps, theme);
        break;
      case schema.GraphThresholdsStyleMode.Area:
        addAreas(u, scaleKey, steps, theme);
        break;
      case schema.GraphThresholdsStyleMode.LineAndArea:
      case schema.GraphThresholdsStyleMode.DashedAndArea:
        addAreas(u, scaleKey, steps, theme);
        addLines(u, scaleKey, steps, theme);
    }
    ctx.restore();
  };
}

const cursorDefaults = {
  // prevent client-side zoom from triggering at the end of a selection
  drag: { setScale: false },
  points: {
    /*@ts-ignore*/
    size: (u, seriesIdx) => u.series[seriesIdx].points.size * 2,
    /*@ts-ignore*/
    width: (u, seriesIdx, size) => size / 4
  },
  focus: {
    prox: 30
  }
};
class UPlotConfigBuilder {
  constructor(timeZone = data.DefaultTimeZone) {
    this.uid = Math.random().toString(36).slice(2);
    this.series = [];
    this.axes = {};
    this.scales = [];
    this.bands = [];
    this.stackingGroups = [];
    this.hasLeftAxis = false;
    this.hooks = {};
    this.tz = void 0;
    this.mode = 1;
    this.frames = void 0;
    // to prevent more than one threshold per scale
    this.thresholds = {};
    this.padding = void 0;
    this.prepData = void 0;
    // Exposed to let the container know the primary scale keys
    this.scaleKeys = ["", ""];
    this.tzDate = (ts) => {
      let date = new Date(ts);
      return this.tz ? uPlot__default.default.tzDate(date, this.tz) : date;
    };
    var _a;
    this.tz = (_a = data.getTimeZoneInfo(timeZone, Date.now())) == null ? void 0 : _a.ianaName;
  }
  addHook(type, hook) {
    pluginLog("UPlotConfigBuilder", false, "addHook", type);
    if (!this.hooks[type]) {
      this.hooks[type] = [];
    }
    this.hooks[type].push(hook);
  }
  addThresholds(options) {
    if (!this.thresholds[options.scaleKey]) {
      this.thresholds[options.scaleKey] = options;
      this.addHook("drawClear", getThresholdsDrawHook(options));
    }
  }
  addAxis(props) {
    var _a, _b, _c;
    props.placement = (_a = props.placement) != null ? _a : schema.AxisPlacement.Auto;
    props.grid = (_b = props.grid) != null ? _b : {};
    let scaleKey = props.scaleKey;
    if (scaleKey === "x") {
      scaleKey += (_c = props.timeZone) != null ? _c : "";
    }
    if (this.axes[scaleKey]) {
      this.axes[scaleKey].merge(props);
      return;
    }
    if (props.placement === schema.AxisPlacement.Auto) {
      props.placement = this.hasLeftAxis ? schema.AxisPlacement.Right : schema.AxisPlacement.Left;
    }
    if (props.placement === schema.AxisPlacement.Left) {
      this.hasLeftAxis = true;
    }
    if (props.placement === schema.AxisPlacement.Hidden) {
      props.grid.show = false;
      props.size = 0;
    }
    this.axes[scaleKey] = new UPlotAxisBuilder(props);
  }
  getAxisPlacement(scaleKey) {
    var _a;
    const axis = this.axes[scaleKey];
    return (_a = axis == null ? void 0 : axis.props.placement) != null ? _a : schema.AxisPlacement.Left;
  }
  setCursor(cursor) {
    this.cursor = lodash.merge({}, this.cursor, cursor);
  }
  setMode(mode) {
    this.mode = mode;
  }
  setSelect(select) {
    this.select = select;
  }
  addSeries(props) {
    this.series.push(new UPlotSeriesBuilder(props));
  }
  getSeries() {
    return this.series;
  }
  /** Add or update the scale with the scale key */
  addScale(props) {
    const current = this.scales.find((v) => v.props.scaleKey === props.scaleKey);
    if (current) {
      current.merge(props);
      return;
    }
    this.scales.push(new UPlotScaleBuilder(props));
  }
  addBand(band) {
    this.bands.push(band);
  }
  setStackingGroups(groups) {
    this.stackingGroups = groups;
  }
  getStackingGroups() {
    return this.stackingGroups;
  }
  setPrepData(prepData) {
    this.prepData = (frames) => {
      this.frames = frames;
      return prepData(frames, this.getStackingGroups());
    };
  }
  setPadding(padding) {
    this.padding = padding;
  }
  getConfig() {
    if (this.cachedConfig) {
      return this.cachedConfig;
    }
    const config = {
      ...DEFAULT_PLOT_CONFIG,
      mode: this.mode,
      series: [
        this.mode === 2 ? null : {
          value: () => ""
        }
      ]
    };
    config.axes = this.ensureNonOverlappingAxes(Object.values(this.axes)).map((a) => a.getConfig());
    config.series = [...config.series, ...this.series.map((s) => s.getConfig())];
    config.scales = this.scales.reduce((acc, s) => {
      return { ...acc, ...s.getConfig() };
    }, {});
    config.hooks = this.hooks;
    config.select = this.select;
    const pointColorFn = (alphaHex = "") => (u, seriesIdx) => {
      let s = u.series[seriesIdx].points._stroke;
      if (typeof s !== "string") {
        let field = this.frames[0].fields[seriesIdx];
        s = field.display(field.values[u.cursor.idxs[seriesIdx]]).color;
      }
      return s + alphaHex;
    };
    config.cursor = lodash.merge(
      {},
      cursorDefaults,
      {
        points: {
          stroke: pointColorFn("80"),
          fill: pointColorFn()
        }
      },
      this.cursor
    );
    config.tzDate = this.tzDate;
    if (Array.isArray(this.padding)) {
      config.padding = this.padding;
    }
    this.stackingGroups.forEach((group) => {
      getStackingBands(group).forEach((band) => {
        this.addBand(band);
      });
    });
    if (this.bands.length) {
      config.bands = this.bands;
    }
    this.cachedConfig = config;
    return config;
  }
  ensureNonOverlappingAxes(axes) {
    const xAxis = axes.find((a) => a.props.scaleKey === "x");
    const axesWithoutGridSet = axes.filter((a) => {
      var _a;
      return ((_a = a.props.grid) == null ? void 0 : _a.show) === void 0;
    });
    const firstValueAxisIdx = axesWithoutGridSet.findIndex(
      (a) => a.props.placement === schema.AxisPlacement.Left || a.props.placement === schema.AxisPlacement.Right || a.props.placement === schema.AxisPlacement.Bottom && a !== xAxis
    );
    for (let i = 0; i < axesWithoutGridSet.length; i++) {
      if (axesWithoutGridSet[i] === xAxis || i === firstValueAxisIdx) {
        axesWithoutGridSet[i].props.grid.show = true;
      } else {
        axesWithoutGridSet[i].props.grid.show = false;
      }
    }
    return axes;
  }
}

function preparePlotFrame$1(sparkline, config) {
  var _a, _b, _c;
  const length = sparkline.y.values.length;
  const yFieldConfig = {
    ...sparkline.y.config,
    ...config
  };
  const xField = (_a = sparkline.x) != null ? _a : {
    name: "",
    values: [...Array(length).keys()],
    type: data.FieldType.number,
    config: {}
  };
  let frame = {
    refId: "sparkline",
    fields: [
      xField,
      {
        ...sparkline.y,
        config: yFieldConfig
      }
    ],
    length
  };
  if (!data.isLikelyAscendingVector(xField.values)) {
    frame = data.sortDataFrame(frame, 0);
  }
  return data.applyNullInsertThreshold({
    frame,
    refFieldPseudoMin: (_b = sparkline.timeRange) == null ? void 0 : _b.from.valueOf(),
    refFieldPseudoMax: (_c = sparkline.timeRange) == null ? void 0 : _c.to.valueOf()
  });
}

const defaultConfig$1 = {
  drawStyle: schema.GraphDrawStyle.Line,
  showPoints: schema.VisibilityMode.Auto,
  axisPlacement: schema.AxisPlacement.Hidden,
  pointSize: 2
};
class Sparkline extends React.PureComponent {
  constructor(props) {
    super(props);
    const alignedDataFrame = preparePlotFrame$1(props.sparkline, props.config);
    this.state = {
      data: preparePlotData2(alignedDataFrame, getStackingGroups(alignedDataFrame)),
      alignedDataFrame,
      configBuilder: this.prepareConfig(alignedDataFrame)
    };
  }
  static getDerivedStateFromProps(props, state) {
    const _frame = preparePlotFrame$1(props.sparkline, props.config);
    const frame = data.nullToValue(_frame);
    if (!frame) {
      return { ...state };
    }
    return {
      ...state,
      data: preparePlotData2(frame, getStackingGroups(frame)),
      alignedDataFrame: frame
    };
  }
  componentDidUpdate(prevProps, prevState) {
    var _a, _b;
    const { alignedDataFrame } = this.state;
    if (!alignedDataFrame) {
      return;
    }
    let rebuildConfig = false;
    if (prevProps.sparkline !== this.props.sparkline) {
      const isStructureChanged = !data.compareDataFrameStructures(this.state.alignedDataFrame, prevState.alignedDataFrame);
      const isRangeChanged = !lodash.isEqual(
        (_a = alignedDataFrame.fields[1].state) == null ? void 0 : _a.range,
        (_b = prevState.alignedDataFrame.fields[1].state) == null ? void 0 : _b.range
      );
      rebuildConfig = isStructureChanged || isRangeChanged;
    } else {
      rebuildConfig = !lodash.isEqual(prevProps.config, this.props.config);
    }
    if (rebuildConfig) {
      this.setState({ configBuilder: this.prepareConfig(alignedDataFrame) });
    }
  }
  getYRange(field) {
    var _a, _b, _c, _d;
    let { min, max } = (_a = this.state.alignedDataFrame.fields[1].state) == null ? void 0 : _a.range;
    const noValue = +((_b = this.state.alignedDataFrame.fields[1].config) == null ? void 0 : _b.noValue);
    if (!Number.isNaN(noValue)) {
      min = Math.min(min, +noValue);
      max = Math.max(max, +noValue);
    }
    if (min === max) {
      if (min === 0) {
        max = 100;
      } else {
        min = 0;
        max *= 2;
      }
      return [min, max];
    }
    return [Math.max(min, (_c = field.config.min) != null ? _c : -Infinity), Math.min(max, (_d = field.config.max) != null ? _d : Infinity)];
  }
  prepareConfig(data$1) {
    var _a;
    const { theme } = this.props;
    const builder = new UPlotConfigBuilder();
    builder.setCursor({
      show: false,
      x: false,
      // no crosshairs
      y: false
    });
    const xField = data$1.fields[0];
    builder.addScale({
      scaleKey: "x",
      orientation: schema.ScaleOrientation.Horizontal,
      direction: schema.ScaleDirection.Right,
      isTime: false,
      //xField.type === FieldType.time,
      range: () => {
        const { sparkline } = this.props;
        if (sparkline.x) {
          if (sparkline.timeRange && sparkline.x.type === data.FieldType.time) {
            return [sparkline.timeRange.from.valueOf(), sparkline.timeRange.to.valueOf()];
          }
          const vals = sparkline.x.values;
          return [vals[0], vals[vals.length - 1]];
        }
        return [0, sparkline.y.values.length - 1];
      }
    });
    builder.addAxis({
      scaleKey: "x",
      theme,
      placement: schema.AxisPlacement.Hidden
    });
    for (let i = 0; i < data$1.fields.length; i++) {
      const field = data$1.fields[i];
      const config = field.config;
      const customConfig = {
        ...defaultConfig$1,
        ...config.custom
      };
      if (field === xField || field.type !== data.FieldType.number) {
        continue;
      }
      const scaleKey = config.unit || "__fixed";
      builder.addScale({
        scaleKey,
        orientation: schema.ScaleOrientation.Vertical,
        direction: schema.ScaleDirection.Up,
        range: () => this.getYRange(field)
      });
      builder.addAxis({
        scaleKey,
        theme,
        placement: schema.AxisPlacement.Hidden
      });
      const colorMode = data.getFieldColorModeForField(field);
      const seriesColor = colorMode.getCalculator(field, theme)(0, 0);
      const pointsMode = customConfig.drawStyle === schema.GraphDrawStyle.Points ? schema.VisibilityMode.Always : customConfig.showPoints;
      builder.addSeries({
        pxAlign: false,
        scaleKey,
        theme,
        colorMode,
        thresholds: config.thresholds,
        drawStyle: customConfig.drawStyle,
        lineColor: (_a = customConfig.lineColor) != null ? _a : seriesColor,
        lineWidth: customConfig.lineWidth,
        lineInterpolation: customConfig.lineInterpolation,
        showPoints: pointsMode,
        pointSize: customConfig.pointSize,
        fillOpacity: customConfig.fillOpacity,
        fillColor: customConfig.fillColor,
        lineStyle: customConfig.lineStyle,
        gradientMode: customConfig.gradientMode,
        spanNulls: customConfig.spanNulls
      });
    }
    return builder;
  }
  render() {
    const { data, configBuilder } = this.state;
    const { width, height } = this.props;
    return /* @__PURE__ */ jsxRuntime.jsx(UPlotChart, { data, config: configBuilder, width, height });
  }
}

const defaultSparklineCellConfig$1 = {
  type: schema.TableCellDisplayMode.Sparkline,
  drawStyle: schema.GraphDrawStyle.Line,
  lineInterpolation: schema.LineInterpolation.Smooth,
  lineWidth: 1,
  fillOpacity: 17,
  gradientMode: schema.GraphGradientMode.Hue,
  pointSize: 2,
  barAlignment: schema.BarAlignment.Center,
  showPoints: schema.VisibilityMode.Never,
  hideValue: false
};
const SparklineCell$1 = (props) => {
  var _a, _b;
  const { field, innerWidth, tableStyles, cell, cellProps, timeRange } = props;
  const sparkline = getSparkline$1(cell.value);
  const theme = useTheme2();
  if (!sparkline) {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { ...cellProps, className: tableStyles.cellContainer, children: field.config.noValue || "no data" });
  }
  if (sparkline.x && !sparkline.x.config.interval && sparkline.x.values.length > 1) {
    sparkline.x.config.interval = sparkline.x.values[1] - sparkline.x.values[0];
  }
  sparkline.y.values = sparkline.y.values.map((v) => {
    if (!Number.isFinite(v)) {
      return null;
    } else {
      return v;
    }
  });
  const range = data.getMinMaxAndDelta(sparkline.y);
  sparkline.y.config.min = range.min;
  sparkline.y.config.max = range.max;
  sparkline.y.state = { range };
  sparkline.timeRange = timeRange;
  const cellOptions = getTableSparklineCellOptions$1(field);
  const config = {
    color: field.config.color,
    custom: {
      ...defaultSparklineCellConfig$1,
      ...cellOptions
    }
  };
  const hideValue = (_b = (_a = field.config.custom) == null ? void 0 : _a.cellOptions) == null ? void 0 : _b.hideValue;
  let valueWidth = 0;
  let valueElement = null;
  if (!hideValue) {
    const value = data.isDataFrameWithValue(cell.value) ? cell.value.value : null;
    const displayValue = field.display(value);
    const alignmentFactor = getAlignmentFactor$1(field, displayValue, cell.row.index);
    valueWidth = measureText(data.formattedValueToString(alignmentFactor), 16).width + theme.spacing.gridSize;
    valueElement = /* @__PURE__ */ jsxRuntime.jsx(
      FormattedValueDisplay,
      {
        style: {
          width: `${valueWidth - theme.spacing.gridSize}px`,
          textAlign: "right",
          marginRight: theme.spacing(1)
        },
        value: displayValue
      }
    );
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { ...cellProps, className: tableStyles.cellContainer, children: [
    valueElement,
    /* @__PURE__ */ jsxRuntime.jsx("div", { children: /* @__PURE__ */ jsxRuntime.jsx(
      Sparkline,
      {
        width: innerWidth - valueWidth,
        height: tableStyles.cellHeightInner,
        sparkline,
        config,
        theme: tableStyles.theme
      }
    ) })
  ] });
};
function getSparkline$1(value) {
  if (Array.isArray(value)) {
    return {
      y: {
        name: "test",
        type: data.FieldType.number,
        values: value,
        config: {}
      }
    };
  }
  if (data.isDataFrame(value)) {
    const timeField = value.fields.find((x) => x.type === data.FieldType.time);
    const numberField = value.fields.find((x) => x.type === data.FieldType.number);
    if (timeField && numberField) {
      return { x: timeField, y: numberField };
    }
  }
  return;
}
function getTableSparklineCellOptions$1(field) {
  let options = getCellOptions$1(field);
  if (options.type === schema.TableCellDisplayMode.Auto) {
    options = { ...options, type: schema.TableCellDisplayMode.Sparkline };
  }
  if (options.type === schema.TableCellDisplayMode.Sparkline) {
    return options;
  }
  throw new Error(`Expected options type ${schema.TableCellDisplayMode.Sparkline} but got ${options.type}`);
}

const FooterCell = (props) => {
  const cell = css.css({
    width: "100%",
    listStyle: "none"
  });
  const list = css.css({
    width: "100%",
    display: "flex",
    flexDirection: "row",
    justifyContent: "space-between"
  });
  if (props.value && !Array.isArray(props.value)) {
    return /* @__PURE__ */ jsxRuntime.jsx("span", { children: props.value });
  }
  if (props.value && Array.isArray(props.value) && props.value.length > 0) {
    return /* @__PURE__ */ jsxRuntime.jsx("ul", { className: cell, children: props.value.map((v, i) => {
      const key = Object.keys(v)[0];
      return /* @__PURE__ */ jsxRuntime.jsxs("li", { className: list, children: [
        /* @__PURE__ */ jsxRuntime.jsx("span", { children: key }),
        /* @__PURE__ */ jsxRuntime.jsx("span", { children: v[key] })
      ] }, i);
    }) });
  }
  return EmptyCell;
};
const EmptyCell = () => {
  return /* @__PURE__ */ jsxRuntime.jsx("span", { children: "\xA0" });
};

function FooterRow(props) {
  const { totalColumnsWidth, footerGroups, isPaginationVisible, tableStyles } = props;
  const e2eSelectorsTable = e2eSelectors.selectors.components.Panels.Visualization.Table;
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      style: {
        position: isPaginationVisible ? "relative" : "absolute",
        width: totalColumnsWidth ? `${totalColumnsWidth}px` : "100%",
        bottom: "0px"
      },
      children: footerGroups.map((footerGroup) => {
        const { key, ...footerGroupProps } = footerGroup.getFooterGroupProps();
        return /* @__PURE__ */ React.createElement("div", { className: tableStyles.tfoot, ...footerGroupProps, key, "data-testid": e2eSelectorsTable.footer }, footerGroup.headers.map((column) => renderFooterCell(column, tableStyles)));
      })
    }
  );
}
function renderFooterCell(column, tableStyles) {
  var _a;
  const { key, ...footerProps } = column.getHeaderProps();
  if (!footerProps) {
    return null;
  }
  footerProps.style = (_a = footerProps.style) != null ? _a : {};
  footerProps.style.position = "absolute";
  footerProps.style.justifyContent = column.justifyContent;
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.headerCell, ...footerProps, children: column.render("Footer") }, key);
}
function getFooterValue(index, footerValues, isCountRowsSet) {
  if (footerValues === void 0) {
    return EmptyCell;
  }
  if (isCountRowsSet) {
    if (footerValues[index] === void 0) {
      return EmptyCell;
    }
    const key = data.fieldReducers.get(data.ReducerID.count).name;
    return FooterCell({ value: [{ [key]: String(footerValues[index]) }] });
  }
  return FooterCell({ value: footerValues[index] });
}

function RowExpander$1({ row, tableStyles }) {
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.expanderCell, ...row.getToggleRowExpandedProps(), children: /* @__PURE__ */ jsxRuntime.jsx(
    Icon,
    {
      "aria-label": row.isExpanded ? "Collapse row" : "Expand row",
      name: row.isExpanded ? "angle-down" : "angle-right",
      size: "lg"
    }
  ) });
}

const EXPANDER_WIDTH = 50;
function getTextAlign$1(field) {
  if (!field) {
    return "flex-start";
  }
  if (field.config.custom) {
    const custom = field.config.custom;
    switch (custom.align) {
      case "right":
        return "flex-end";
      case "left":
        return "flex-start";
      case "center":
        return "center";
    }
  }
  if (field.type === data.FieldType.number) {
    return "flex-end";
  }
  return "flex-start";
}
function getColumns(data$1, availableWidth, columnMinWidth, expander, footerValues, isCountRowsSet) {
  var _a, _b;
  const columns = [];
  let fieldCountWithoutWidth = 0;
  if (expander) {
    columns.push({
      // Make an expander cell
      Header: () => null,
      // No header
      id: "expander",
      // It needs an ID
      // @ts-expect-error
      // TODO fix type error here
      Cell: RowExpander$1,
      width: EXPANDER_WIDTH,
      minWidth: EXPANDER_WIDTH,
      filter: (_rows, _id, _filterValues) => {
        return [];
      },
      justifyContent: "left",
      field: data$1.fields[0],
      sortType: "basic"
    });
    availableWidth -= EXPANDER_WIDTH;
  }
  for (const [fieldIndex, field] of data$1.fields.entries()) {
    const fieldTableOptions = field.config.custom || {};
    if (fieldTableOptions.hidden || field.type === data.FieldType.nestedFrames) {
      continue;
    }
    if (fieldTableOptions.width) {
      availableWidth -= fieldTableOptions.width;
    } else {
      fieldCountWithoutWidth++;
    }
    const selectSortType = (type) => {
      switch (type) {
        case data.FieldType.number:
        case data.FieldType.frame:
          return "number";
        case data.FieldType.time:
          return "basic";
        default:
          return "alphanumeric-insensitive";
      }
    };
    const Cell = getCellComponent((_a = fieldTableOptions.cellOptions) == null ? void 0 : _a.type, field);
    columns.push({
      // @ts-expect-error
      // TODO fix type error here
      Cell,
      id: fieldIndex.toString(),
      field,
      Header: fieldTableOptions.hideHeader ? "" : data.getFieldDisplayName(field, data$1),
      accessor: (_row, i) => field.values[i],
      sortType: selectSortType(field.type),
      width: fieldTableOptions.width,
      minWidth: (_b = fieldTableOptions.minWidth) != null ? _b : columnMinWidth,
      filter: memoize__default.default(filterByValue(field)),
      justifyContent: getTextAlign$1(field),
      Footer: getFooterValue(fieldIndex, footerValues, isCountRowsSet)
    });
  }
  let sharedWidth = availableWidth / fieldCountWithoutWidth;
  for (let i = fieldCountWithoutWidth; i > 0; i--) {
    for (const column of columns) {
      if (!column.width && column.minWidth > sharedWidth) {
        column.width = column.minWidth;
        availableWidth -= column.width;
        fieldCountWithoutWidth -= 1;
        sharedWidth = availableWidth / fieldCountWithoutWidth;
      }
    }
  }
  for (const column of columns) {
    if (!column.width) {
      column.width = sharedWidth;
    }
    column.minWidth = 50;
  }
  return columns;
}
function getCellComponent(displayMode, field) {
  switch (displayMode) {
    case schema.TableCellDisplayMode.Custom:
    case schema.TableCellDisplayMode.ColorText:
    case schema.TableCellDisplayMode.ColorBackground:
      return DefaultCell;
    case schema.TableCellDisplayMode.Image:
      return ImageCell$1;
    case schema.TableCellDisplayMode.Gauge:
      return BarGaugeCell$1;
    case schema.TableCellDisplayMode.Sparkline:
      return SparklineCell$1;
    case schema.TableCellDisplayMode.JSONView:
      return JSONViewCell;
    case schema.TableCellDisplayMode.DataLinks:
      return DataLinksCell$1;
    case schema.TableCellDisplayMode.Actions:
      return ActionsCell$1;
  }
  if (field.type === data.FieldType.geo) {
    return GeoCell$1;
  }
  if (field.type === data.FieldType.frame) {
    const firstValue = field.values[0];
    if (data.isDataFrame(firstValue) && data.isTimeSeriesFrame(firstValue)) {
      return SparklineCell$1;
    }
    return JSONViewCell;
  }
  if (field.type === data.FieldType.other) {
    return JSONViewCell;
  }
  return DefaultCell;
}
function filterByValue(field) {
  return function(rows, id, filterValues) {
    if (rows.length === 0) {
      return rows;
    }
    if (!filterValues) {
      return rows;
    }
    if (!field) {
      return rows;
    }
    return rows.filter((row) => {
      if (!row.values.hasOwnProperty(id)) {
        return false;
      }
      const value = rowToFieldValue(row, field);
      return filterValues.find((filter) => filter.value === value) !== void 0;
    });
  };
}
function calculateUniqueFieldValues$1(rows, field) {
  if (!field || rows.length === 0) {
    return {};
  }
  const set = {};
  for (let index = 0; index < rows.length; index++) {
    const value = rowToFieldValue(rows[index], field);
    set[value || "(Blanks)"] = value;
  }
  return set;
}
function rowToFieldValue(row, field) {
  if (!field || !row) {
    return "";
  }
  const fieldValue = field.values[row.index];
  const displayValue = field.display ? field.display(fieldValue) : fieldValue;
  const value = field.display ? data.formattedValueToString(displayValue) : displayValue;
  return value;
}
function valuesToOptions$1(unique) {
  return Object.keys(unique).reduce((all, key) => all.concat({ value: unique[key], label: key }), []).sort(sortOptions$1);
}
function sortOptions$1(a, b) {
  if (a.label === void 0 && b.label === void 0) {
    return 0;
  }
  if (a.label === void 0 && b.label !== void 0) {
    return -1;
  }
  if (a.label !== void 0 && b.label === void 0) {
    return 1;
  }
  if (a.label < b.label) {
    return -1;
  }
  if (a.label > b.label) {
    return 1;
  }
  return 0;
}
function getFilteredOptions$1(options, filterValues) {
  if (!filterValues) {
    return [];
  }
  return options.filter((option) => filterValues.some((filtered) => filtered.value === option.value));
}
function sortCaseInsensitive(a, b, id) {
  return String(a.values[id]).localeCompare(String(b.values[id]), void 0, { sensitivity: "base" });
}
function sortNumber(rowA, rowB, id) {
  const a = toNumber(rowA.values[id]);
  const b = toNumber(rowB.values[id]);
  return a === b ? 0 : a > b ? 1 : -1;
}
function toNumber(value) {
  var _a;
  if (data.isDataFrameWithValue(value)) {
    return (_a = value.value) != null ? _a : Number.NEGATIVE_INFINITY;
  }
  if (value === null || value === void 0 || value === "" || isNaN(value)) {
    return Number.NEGATIVE_INFINITY;
  }
  if (typeof value === "number") {
    return value;
  }
  return Number(value);
}
function getFooterItems(filterFields, values, options, theme2) {
  addMissingColumnIndex(filterFields);
  return filterFields.map((data$1, i) => {
    var _a;
    if (((_a = data$1 == null ? void 0 : data$1.field) == null ? void 0 : _a.type) !== data.FieldType.number) {
      if (i === 0 && options.reducer && options.reducer.length > 0) {
        const reducer = data.fieldReducers.get(options.reducer[0]);
        return reducer.name;
      }
      return void 0;
    }
    let newField = lodash.clone(data$1.field);
    newField.values = values[data$1.id];
    newField.state = void 0;
    data$1.field = newField;
    if (options.fields && options.fields.length > 0) {
      const f = options.fields.find((f2) => {
        var _a2;
        return f2 === ((_a2 = data$1 == null ? void 0 : data$1.field) == null ? void 0 : _a2.name);
      });
      if (f) {
        return getFormattedValue(data$1.field, options.reducer, theme2);
      }
      return void 0;
    }
    return getFormattedValue(data$1.field, options.reducer || [], theme2);
  });
}
function getFormattedValue(field, reducer, theme) {
  var _a;
  const calc = reducer[0];
  if (calc === void 0) {
    return "";
  }
  const format = (_a = field.display) != null ? _a : data.getDisplayProcessor({ field, theme });
  const fieldCalcValue = data.reduceField({ field, reducers: reducer })[calc];
  const reducerInfo = data.fieldReducers.get(calc);
  if (reducerInfo.preservesUnits) {
    return data.formattedValueToString(format(fieldCalcValue));
  }
  return data.formattedValueToString({ text: fieldCalcValue });
}
function createFooterCalculationValues(rows) {
  const values = [];
  for (const key in rows) {
    for (const [valKey, val] of Object.entries(rows[key].values)) {
      if (values[valKey] === void 0) {
        values[valKey] = [];
      }
      values[valKey].push(val);
    }
  }
  return values;
}
const defaultCellOptions$1 = { type: schema.TableCellDisplayMode.Auto };
function getCellOptions$1(field) {
  var _a, _b, _c;
  if ((_a = field.config.custom) == null ? void 0 : _a.displayMode) {
    return migrateTableDisplayModeToCellOptions$1((_b = field.config.custom) == null ? void 0 : _b.displayMode);
  }
  if (!((_c = field.config.custom) == null ? void 0 : _c.cellOptions)) {
    return defaultCellOptions$1;
  }
  return field.config.custom.cellOptions;
}
function migrateTableDisplayModeToCellOptions$1(displayMode) {
  switch (displayMode) {
    // In the case of the gauge we move to a different option
    case "basic":
    case "gradient-gauge":
    case "lcd-gauge":
      let gaugeMode = schema.BarGaugeDisplayMode.Basic;
      if (displayMode === "gradient-gauge") {
        gaugeMode = schema.BarGaugeDisplayMode.Gradient;
      } else if (displayMode === "lcd-gauge") {
        gaugeMode = schema.BarGaugeDisplayMode.Lcd;
      }
      return {
        type: schema.TableCellDisplayMode.Gauge,
        mode: gaugeMode
      };
    // Also true in the case of the color background
    case "color-background":
    case "color-background-solid":
      let mode = schema.TableCellBackgroundDisplayMode.Basic;
      if (displayMode === "color-background") {
        mode = schema.TableCellBackgroundDisplayMode.Gradient;
      }
      return {
        type: schema.TableCellDisplayMode.ColorBackground,
        mode
      };
    default:
      return {
        // @ts-ignore
        type: displayMode
      };
  }
}
function addMissingColumnIndex(columns) {
  var _a;
  const missingIndex = columns.findIndex((field, index) => (field == null ? void 0 : field.id) !== String(index));
  if (missingIndex === -1 || ((_a = columns[missingIndex]) == null ? void 0 : _a.id) === "expander") {
    return;
  }
  columns.splice(missingIndex, 0, { id: String(missingIndex) });
  addMissingColumnIndex(columns);
}
function getAlignmentFactor$1(field, displayValue, rowIndex) {
  var _a;
  let alignmentFactor = (_a = field.state) == null ? void 0 : _a.alignmentFactors;
  if (alignmentFactor) {
    if (data.formattedValueToString(alignmentFactor).length < data.formattedValueToString(displayValue).length) {
      alignmentFactor = { ...displayValue };
      field.state.alignmentFactors = alignmentFactor;
    }
    return alignmentFactor;
  } else {
    alignmentFactor = { ...displayValue };
    const maxIndex = Math.min(field.values.length, rowIndex + 1e3);
    for (let i = rowIndex + 1; i < maxIndex; i++) {
      const nextDisplayValue = field.display(field.values[i]);
      if (data.formattedValueToString(alignmentFactor).length > data.formattedValueToString(nextDisplayValue).length) {
        alignmentFactor.text = displayValue.text;
      }
    }
    if (field.state) {
      field.state.alignmentFactors = alignmentFactor;
    } else {
      field.state = { alignmentFactors: alignmentFactor };
    }
    return alignmentFactor;
  }
}
function isPointTimeValAroundTableTimeVal(pointTime, rowTime, threshold) {
  return Math.abs(Math.floor(pointTime) - rowTime) < threshold;
}
function calculateAroundPointThreshold(timeField) {
  let max = -Number.MAX_VALUE;
  let min = Number.MAX_VALUE;
  if (timeField.values.length < 2) {
    return 0;
  }
  for (let i = 0; i < timeField.values.length; i++) {
    const value = timeField.values[i];
    if (value > max) {
      max = value;
    }
    if (value < min) {
      min = value;
    }
  }
  return (max - min) / timeField.values.length;
}
function getCellColors$1(theme, cellOptions, displayValue) {
  var _a;
  const darkeningFactor = theme.isDark ? 1 : -0.7;
  let textColor = void 0;
  let bgColor = void 0;
  let bgHoverColor = void 0;
  if (cellOptions.type === schema.TableCellDisplayMode.ColorText) {
    textColor = displayValue.color;
  } else if (cellOptions.type === schema.TableCellDisplayMode.ColorBackground) {
    const mode = (_a = cellOptions.mode) != null ? _a : schema.TableCellBackgroundDisplayMode.Gradient;
    if (mode === schema.TableCellBackgroundDisplayMode.Basic) {
      textColor = getTextColorForAlphaBackground(displayValue.color, theme.isDark);
      bgColor = tinycolor__default.default(displayValue.color).toRgbString();
      bgHoverColor = tinycolor__default.default(displayValue.color).setAlpha(1).toRgbString();
    } else if (mode === schema.TableCellBackgroundDisplayMode.Gradient) {
      const hoverColor = tinycolor__default.default(displayValue.color).setAlpha(1).toRgbString();
      const bgColor2 = tinycolor__default.default(displayValue.color).darken(10 * darkeningFactor).spin(5);
      textColor = getTextColorForAlphaBackground(displayValue.color, theme.isDark);
      bgColor = `linear-gradient(120deg, ${bgColor2.toRgbString()}, ${displayValue.color})`;
      bgHoverColor = `linear-gradient(120deg, ${bgColor2.setAlpha(1).toRgbString()}, ${hoverColor})`;
    }
  }
  return { textColor, bgColor, bgHoverColor };
}
function guessTextBoundingBox(text, headerGroup, osContext, lineHeight, defaultRowHeight, padding = 0) {
  var _a;
  const width = Number((_a = headerGroup == null ? void 0 : headerGroup.width) != null ? _a : 300);
  const LINE_SCALE_FACTOR = 1.17;
  const LOW_LINE_PAD = 42;
  const PADDING = padding * 2;
  if (osContext !== null && typeof text === "string") {
    const words = text.split(/\s/);
    const lines = [];
    let currentLine = "";
    let extraLines = 0;
    for (let i = 0; i < words.length; i++) {
      const currentWord = words[i];
      let lineWidth = osContext.measureText(currentLine + " " + currentWord).width;
      if (lineWidth < width - PADDING) {
        currentLine += " " + currentWord;
      } else {
        lines.push({
          width: lineWidth,
          line: currentLine
        });
        currentLine = currentWord;
      }
    }
    for (let i = 0; i < lines.length; i++) {
      if (lines[i].width > width) {
        let extra = Math.floor(lines[i].width / width) - 1;
        extraLines += extra;
      }
    }
    let lineNumber = lines.length + extraLines;
    let height = 38;
    if (lineNumber > 5) {
      height = lineNumber * lineHeight * LINE_SCALE_FACTOR;
    } else {
      height = lineNumber * lineHeight + LOW_LINE_PAD;
    }
    height += PADDING;
    return { width, height };
  }
  return { width, height: defaultRowHeight };
}
function guessLongestField(fieldConfig, data$1) {
  var _a, _b, _c, _d, _e;
  let longestField = void 0;
  const SAMPLE_SIZE = 3;
  if ((_b = (_a = fieldConfig.defaults.custom) == null ? void 0 : _a.cellOptions) == null ? void 0 : _b.wrapText) {
    const stringFields = data$1.fields.filter((field) => field.type === data.FieldType.string);
    if (stringFields.length >= 1 && stringFields[0].values.length > 0) {
      const numValues = stringFields[0].values.length;
      let longestLength = 0;
      if (numValues <= 30) {
        for (const field of stringFields) {
          const fieldLength = field.values[0].length;
          if (fieldLength > longestLength) {
            longestLength = fieldLength;
            longestField = field;
          }
        }
      } else {
        for (const field of stringFields) {
          const vals = lodash.sampleSize(field.values, SAMPLE_SIZE);
          const meanLength = (((_c = vals[0]) == null ? void 0 : _c.length) + ((_d = vals[1]) == null ? void 0 : _d.length) + ((_e = vals[2]) == null ? void 0 : _e.length)) / 3;
          if (meanLength > longestLength) {
            longestLength = meanLength;
            longestField = field;
          }
        }
      }
    }
  }
  return longestField;
}

const ITEM_HEIGHT$1 = 28;
const MIN_HEIGHT$1 = ITEM_HEIGHT$1 * 5;
const operatorSelectableValues$1 = {
  Contains: { label: "Contains", value: "Contains", description: "Contains" },
  "=": { label: "=", value: "=", description: "Equals" },
  "!=": { label: "!=", value: "!=", description: "Not equals" },
  ">": { label: ">", value: ">", description: "Greater" },
  ">=": { label: ">=", value: ">=", description: "Greater or Equal" },
  "<": { label: "<", value: "<", description: "Less" },
  "<=": { label: "<=", value: "<=", description: "Less or Equal" },
  Expression: {
    label: "Expression",
    value: "Expression",
    description: 'Bool Expression (Char $ represents the column value in the expression, e.g. "$ >= 10 && $ <= 12")'
  }
};
const OPERATORS$1 = Object.values(operatorSelectableValues$1);
const REGEX_OPERATOR$1 = operatorSelectableValues$1["Contains"];
const XPR_OPERATOR$1 = operatorSelectableValues$1["Expression"];
const comparableValue$1 = (value) => {
  value = value.trim().replace(/\\/g, "");
  if (/^(\d{4}-\d{2}-\d{2}|\d{4}\/\d{2}\/\d{2})/.test(value)) {
    const date = new Date(value);
    if (!isNaN(date.getTime())) {
      const fmt = data.getValueFormat("dateTimeAsIso");
      return data.formattedValueToString(fmt(date.getTime()));
    }
  }
  const num = parseFloat(value);
  if (!isNaN(num)) {
    return num;
  }
  const lvalue = value.toLowerCase();
  if (lvalue === "true" || lvalue === "false") {
    return lvalue === "true";
  }
  return value;
};
const FilterList$1 = ({
  options,
  values,
  caseSensitive,
  showOperators,
  onChange,
  searchFilter,
  setSearchFilter,
  operator,
  setOperator
}) => {
  const regex = React.useMemo(() => new RegExp(searchFilter, caseSensitive ? void 0 : "i"), [searchFilter, caseSensitive]);
  const items = React.useMemo(
    () => options.filter((option) => {
      if (!showOperators || !searchFilter || operator.value === REGEX_OPERATOR$1.value) {
        if (option.label === void 0) {
          return false;
        }
        return regex.test(option.label);
      } else if (operator.value === XPR_OPERATOR$1.value) {
        if (option.value === void 0) {
          return false;
        }
        try {
          const xpr = searchFilter.replace(/\\/g, "");
          const fnc = new Function("$", `'use strict'; return ${xpr};`);
          const val = comparableValue$1(option.value);
          return fnc(val);
        } catch (_) {
        }
        return false;
      } else {
        if (option.value === void 0) {
          return false;
        }
        const value1 = comparableValue$1(option.value);
        const value2 = comparableValue$1(searchFilter);
        switch (operator.value) {
          case "=":
            return value1 === value2;
          case "!=":
            return value1 !== value2;
          case ">":
            return value1 > value2;
          case ">=":
            return value1 >= value2;
          case "<":
            return value1 < value2;
          case "<=":
            return value1 <= value2;
        }
        return false;
      }
    }),
    [options, regex, showOperators, operator, searchFilter]
  );
  const selectedItems = React.useMemo(() => items.filter((item) => values.includes(item)), [items, values]);
  const selectCheckValue = React.useMemo(() => items.length === selectedItems.length, [items, selectedItems]);
  const selectCheckIndeterminate = React.useMemo(
    () => selectedItems.length > 0 && items.length > selectedItems.length,
    [items, selectedItems]
  );
  const selectCheckLabel = React.useMemo(
    () => selectedItems.length ? `${selectedItems.length} selected` : `Select all`,
    [selectedItems]
  );
  const selectCheckDescription = React.useMemo(
    () => items.length !== selectedItems.length ? "Add all displayed values to the filter" : "Remove all displayed values from the filter",
    [items, selectedItems]
  );
  const styles = useStyles2(getStyles$y);
  const theme = useTheme2();
  const gutter = theme.spacing.gridSize;
  const height = React.useMemo(() => Math.min(items.length * ITEM_HEIGHT$1, MIN_HEIGHT$1) + gutter, [gutter, items.length]);
  const onCheckedChanged = React.useCallback(
    (option) => (event) => {
      const newValues = event.currentTarget.checked ? values.concat(option) : values.filter((c) => c.value !== option.value);
      onChange(newValues);
    },
    [onChange, values]
  );
  const onSelectChanged = React.useCallback(() => {
    if (items.length === selectedItems.length) {
      const newValues = values.filter((item) => !items.includes(item));
      onChange(newValues);
    } else {
      const newValues = [.../* @__PURE__ */ new Set([...values, ...items])];
      onChange(newValues);
    }
  }, [onChange, values, items, selectedItems]);
  return /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", gap: 0.25, children: [
    !showOperators && /* @__PURE__ */ jsxRuntime.jsx(
      FilterInput,
      {
        placeholder: t("grafana-ui.table.filter-placeholder", "Filter values"),
        onChange: setSearchFilter,
        value: searchFilter
      }
    ),
    showOperators && /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "row", gap: 0, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        ButtonSelect,
        {
          variant: "canvas",
          options: OPERATORS$1,
          onChange: setOperator,
          value: operator,
          tooltip: operator.description
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        FilterInput,
        {
          placeholder: t("grafana-ui.table.filter-placeholder", "Filter values"),
          onChange: setSearchFilter,
          value: searchFilter
        }
      )
    ] }),
    items.length > 0 ? /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        reactWindow.FixedSizeList,
        {
          height,
          itemCount: items.length,
          itemSize: ITEM_HEIGHT$1,
          itemData: { items, values: selectedItems, onCheckedChanged, className: styles.filterListRow },
          width: "100%",
          className: styles.filterList,
          children: ItemRenderer$1
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", gap: 0.25, children: [
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.selectDivider) }),
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.filterListRow), children: /* @__PURE__ */ jsxRuntime.jsx(
          Checkbox,
          {
            value: selectCheckValue,
            indeterminate: selectCheckIndeterminate,
            label: selectCheckLabel,
            description: selectCheckDescription,
            onChange: onSelectChanged
          }
        ) })
      ] })
    ] }) : /* @__PURE__ */ jsxRuntime.jsx(Label$1, { className: styles.noValuesLabel, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.no-values-label", children: "No values" }) })
  ] });
};
function ItemRenderer$1({ index, style, data: { onCheckedChanged, items, values, className } }) {
  const option = items[index];
  const { value, label } = option;
  const isChecked = values.find((s) => s.value === value) !== void 0;
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className, style, title: label, children: /* @__PURE__ */ jsxRuntime.jsx(Checkbox, { value: isChecked, label, onChange: onCheckedChanged(option) }) });
}
const getStyles$y = (theme) => ({
  filterList: css.css({
    label: "filterList"
  }),
  filterListRow: css.css({
    label: "filterListRow",
    cursor: "pointer",
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    padding: theme.spacing(0.5),
    ":hover": {
      backgroundColor: theme.colors.action.hover
    }
  }),
  selectDivider: css.css({
    label: "selectDivider",
    width: "100%",
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(0.5, 2)
  }),
  noValuesLabel: css.css({
    paddingTop: theme.spacing(1)
  })
});

const FilterPopup$1 = ({
  column: { preFilteredRows, filterValue, setFilter },
  onClose,
  field,
  searchFilter,
  setSearchFilter,
  operator,
  setOperator
}) => {
  const theme = useTheme2();
  const uniqueValues = React.useMemo(() => calculateUniqueFieldValues$1(preFilteredRows, field), [preFilteredRows, field]);
  const options = React.useMemo(() => valuesToOptions$1(uniqueValues), [uniqueValues]);
  const filteredOptions = React.useMemo(() => getFilteredOptions$1(options, filterValue), [options, filterValue]);
  const [values, setValues] = React.useState(filteredOptions);
  const [matchCase, setMatchCase] = React.useState(false);
  const onCancel = React.useCallback((event) => onClose(), [onClose]);
  const onFilter = React.useCallback(
    (event) => {
      const filtered = values.length ? values : void 0;
      setFilter(filtered);
      onClose();
    },
    [setFilter, values, onClose]
  );
  const onClearFilter = React.useCallback(
    (event) => {
      setFilter(void 0);
      onClose();
    },
    [setFilter, onClose]
  );
  const clearFilterVisible = React.useMemo(() => filterValue !== void 0, [filterValue]);
  const styles = useStyles2(getStyles$x);
  return /* @__PURE__ */ jsxRuntime.jsx(ClickOutsideWrapper, { onClick: onCancel, useCapture: true, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.filterContainer), onClick: stopPropagation$1, children: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", gap: 3, children: [
    /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", gap: 0.5, children: [
      /* @__PURE__ */ jsxRuntime.jsxs(Stack, { justifyContent: "space-between", alignItems: "center", children: [
        /* @__PURE__ */ jsxRuntime.jsx(Label$1, { className: styles.label, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-heading", children: "Filter by values:" }) }),
        /* @__PURE__ */ jsxRuntime.jsx(
          IconButton,
          {
            name: "text-fields",
            tooltip: t("grafana-ui.table.filter-popup-match-case", "Match case"),
            style: { color: matchCase ? theme.colors.text.link : theme.colors.text.disabled },
            onClick: () => {
              setMatchCase((s) => !s);
            }
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.listDivider) }),
      /* @__PURE__ */ jsxRuntime.jsx(
        FilterList$1,
        {
          onChange: setValues,
          values,
          options,
          caseSensitive: matchCase,
          showOperators: true,
          searchFilter,
          setSearchFilter,
          operator,
          setOperator
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntime.jsxs(Stack, { gap: 3, children: [
      /* @__PURE__ */ jsxRuntime.jsxs(Stack, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(Button, { size: "sm", onClick: onFilter, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-apply", children: "Ok" }) }),
        /* @__PURE__ */ jsxRuntime.jsx(Button, { size: "sm", variant: "secondary", onClick: onCancel, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-cancel", children: "Cancel" }) })
      ] }),
      clearFilterVisible && /* @__PURE__ */ jsxRuntime.jsx(Stack, { children: /* @__PURE__ */ jsxRuntime.jsx(Button, { fill: "text", size: "sm", onClick: onClearFilter, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-clear", children: "Clear filter" }) }) })
    ] })
  ] }) }) });
};
const getStyles$x = (theme) => ({
  filterContainer: css.css({
    label: "filterContainer",
    width: "100%",
    minWidth: "250px",
    height: "100%",
    maxHeight: "400px",
    backgroundColor: theme.colors.background.primary,
    border: `1px solid ${theme.colors.border.weak}`,
    padding: theme.spacing(2),
    boxShadow: theme.shadows.z3,
    borderRadius: theme.shape.radius.default
  }),
  listDivider: css.css({
    label: "listDivider",
    width: "100%",
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(0.5, 2)
  }),
  label: css.css({
    marginBottom: 0
  })
});
const stopPropagation$1 = (event) => {
  event.stopPropagation();
};

const Filter$1 = ({ column, field, tableStyles }) => {
  var _a;
  const ref = React.useRef(null);
  const [isPopoverVisible, setPopoverVisible] = React.useState(false);
  const styles = useStyles2(getStyles$w);
  const filterEnabled = React.useMemo(() => Boolean(column.filterValue), [column.filterValue]);
  const onShowPopover = React.useCallback(() => setPopoverVisible(true), [setPopoverVisible]);
  const onClosePopover = React.useCallback(() => setPopoverVisible(false), [setPopoverVisible]);
  const [searchFilter, setSearchFilter] = React.useState("");
  const [operator, setOperator] = React.useState(REGEX_OPERATOR$1);
  if (!field || !((_a = field.config.custom) == null ? void 0 : _a.filterable)) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "button",
    {
      className: css.cx(tableStyles.headerFilter, filterEnabled ? styles.filterIconEnabled : styles.filterIconDisabled),
      ref,
      type: "button",
      onClick: onShowPopover,
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "filter" }),
        isPopoverVisible && ref.current && /* @__PURE__ */ jsxRuntime.jsx(
          Popover,
          {
            content: /* @__PURE__ */ jsxRuntime.jsx(
              FilterPopup$1,
              {
                column,
                tableStyles,
                field,
                onClose: onClosePopover,
                searchFilter,
                setSearchFilter,
                operator,
                setOperator
              }
            ),
            placement: "bottom-start",
            referenceElement: ref.current,
            show: true
          }
        )
      ]
    }
  );
};
const getStyles$w = (theme) => ({
  filterIconEnabled: css.css({
    label: "filterIconEnabled",
    color: theme.colors.primary.text
  }),
  filterIconDisabled: css.css({
    label: "filterIconDisabled",
    color: theme.colors.text.disabled
  })
});

const HeaderRow = (props) => {
  const { headerGroups, showTypeIcons, tableStyles } = props;
  const e2eSelectorsTable = e2eSelectors.selectors.components.Panels.Visualization.Table;
  return /* @__PURE__ */ jsxRuntime.jsx("div", { role: "rowgroup", className: tableStyles.headerRow, children: headerGroups.map((headerGroup) => {
    const { key, ...headerGroupProps } = headerGroup.getHeaderGroupProps();
    return /* @__PURE__ */ React.createElement(
      "div",
      {
        className: tableStyles.thead,
        ...headerGroupProps,
        key,
        "aria-label": e2eSelectorsTable.header,
        role: "row"
      },
      headerGroup.headers.map(
        (column, index) => renderHeaderCell(column, tableStyles, showTypeIcons)
      )
    );
  }) });
};
function renderHeaderCell(column, tableStyles, showTypeIcons) {
  var _a;
  const { key, ...headerProps } = column.getHeaderProps();
  const field = (_a = column.field) != null ? _a : null;
  const tableFieldOptions = field == null ? void 0 : field.config.custom;
  if (column.canResize) {
    headerProps.style.userSelect = column.isResizing ? "none" : "auto";
  }
  headerProps.style.position = "absolute";
  headerProps.style.justifyContent = column.justifyContent;
  headerProps.style.left = column.totalLeft;
  let headerContent = column.render("Header");
  let sortHeaderContent = column.canSort && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsxs("button", { ...column.getSortByToggleProps(), className: tableStyles.headerCellLabel, children: [
      showTypeIcons && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: getFieldTypeIcon(field), title: field == null ? void 0 : field.type, size: "sm", className: tableStyles.typeIcon }),
      /* @__PURE__ */ jsxRuntime.jsx("div", { children: headerContent }),
      column.isSorted && (column.isSortedDesc ? /* @__PURE__ */ jsxRuntime.jsx(Icon, { size: "lg", name: "arrow-down", className: tableStyles.sortIcon }) : /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "arrow-up", size: "lg", className: tableStyles.sortIcon }))
    ] }),
    column.canFilter && /* @__PURE__ */ jsxRuntime.jsx(Filter$1, { column, tableStyles, field })
  ] });
  if (sortHeaderContent && (tableFieldOptions == null ? void 0 : tableFieldOptions.headerComponent)) {
    sortHeaderContent = /* @__PURE__ */ jsxRuntime.jsx(tableFieldOptions.headerComponent, { field, defaultContent: sortHeaderContent });
  } else if (tableFieldOptions == null ? void 0 : tableFieldOptions.headerComponent) {
    headerContent = /* @__PURE__ */ jsxRuntime.jsx(tableFieldOptions.headerComponent, { field, defaultContent: headerContent });
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: tableStyles.headerCell, ...headerProps, role: "columnheader", children: [
    column.canSort && sortHeaderContent,
    !column.canSort && headerContent,
    !column.canSort && column.canFilter && /* @__PURE__ */ jsxRuntime.jsx(Filter$1, { column, tableStyles, field }),
    column.canResize && /* @__PURE__ */ jsxRuntime.jsx("div", { ...column.getResizerProps(), className: tableStyles.resizeHandle })
  ] }, key);
}

const TableCell = ({
  cell,
  tableStyles,
  onCellFilterAdded,
  timeRange,
  userProps,
  frame,
  rowStyled,
  rowExpanded,
  textWrapped,
  height,
  getActions,
  replaceVariables,
  setInspectCell
}) => {
  const cellProps = cell.getCellProps();
  const field = cell.column.field;
  if (!(field == null ? void 0 : field.display)) {
    return null;
  }
  if (cellProps.style) {
    cellProps.style.wordBreak = "break-word";
    cellProps.style.minWidth = cellProps.style.width;
    const justifyContent = cell.column.justifyContent;
    if (justifyContent === "flex-end" && !field.config.unit) {
      cellProps.style.textAlign = "right";
      cellProps.style.direction = "rtl";
      cellProps.style.unicodeBidi = "plaintext";
    } else {
      cellProps.style.justifyContent = justifyContent;
    }
  }
  let innerWidth = (typeof cell.column.width === "number" ? cell.column.width : 24) - tableStyles.cellPadding * 2;
  const actions = getActions ? getActions(frame, field, cell.row.index, replaceVariables) : [];
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: cell.render("Cell", {
    field,
    tableStyles,
    onCellFilterAdded,
    cellProps,
    innerWidth,
    timeRange,
    userProps,
    frame,
    rowStyled,
    rowExpanded,
    textWrapped,
    height,
    actions,
    setInspectCell
  }) });
};

function ExpandedRow({ tableStyles, nestedData, rowIndex, width, cellHeight }) {
  const frames = nestedData.values;
  const subTables = [];
  const theme = useTheme2();
  const styles = useStyles2(getStyles$v);
  let top = tableStyles.rowHeight + theme.spacing.gridSize;
  frames[rowIndex].forEach((nf, nfIndex) => {
    var _a, _b;
    const noHeader = !!((_b = (_a = nf.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.noHeader);
    const height = tableStyles.rowHeight * (nf.length + (noHeader ? 0 : 1));
    const subTable = {
      height,
      paddingLeft: EXPANDER_WIDTH,
      position: "absolute",
      top,
      backgroundColor: theme.colors.background.primary,
      color: theme.colors.text.primary
    };
    top += height + theme.spacing.gridSize;
    subTables.push(
      /* @__PURE__ */ jsxRuntime.jsx("div", { style: subTable, children: /* @__PURE__ */ jsxRuntime.jsx(
        Table,
        {
          data: nf,
          width: width - EXPANDER_WIDTH,
          height: tableStyles.rowHeight * (nf.length + 1),
          noHeader,
          cellHeight
        }
      ) }, `subTable_${rowIndex}_${nfIndex}`)
    );
  });
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.subTables, children: subTables });
}
const getStyles$v = (theme) => {
  return {
    subTables: css.css({
      "&:before": {
        content: '""',
        position: "absolute",
        width: "1px",
        top: theme.spacing(5),
        left: theme.spacing(1),
        bottom: theme.spacing(2),
        background: theme.colors.border.medium
      }
    })
  };
};
function getExpandedRowHeight(nestedData, rowIndex, tableStyles) {
  const frames = nestedData.values;
  const height = frames[rowIndex].reduce((acc, frame) => {
    var _a, _b;
    if (frame.length) {
      const noHeader = !!((_b = (_a = frame.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.noHeader);
      return acc + tableStyles.rowHeight * (frame.length + (noHeader ? 0 : 1)) + 8;
    }
    return acc;
  }, tableStyles.rowHeight);
  return height != null ? height : tableStyles.rowHeight;
}

const RowsList = (props) => {
  const {
    data: data$1,
    rows,
    headerHeight,
    footerPaginationEnabled,
    rowHeight,
    itemCount,
    pageIndex,
    tableState,
    prepareRow,
    onCellFilterAdded,
    width,
    cellHeight = schema.TableCellHeight.Sm,
    timeRange,
    tableStyles,
    nestedDataField,
    listHeight,
    listRef,
    enableSharedCrosshair = false,
    initialRowIndex = void 0,
    headerGroups,
    longestField,
    textWrapField,
    getActions,
    replaceVariables,
    setInspectCell
  } = props;
  const [rowHighlightIndex, setRowHighlightIndex] = React.useState(initialRowIndex);
  if (initialRowIndex === void 0 && rowHighlightIndex !== void 0) {
    setRowHighlightIndex(void 0);
  }
  const theme = useTheme2();
  const panelContext = usePanelContext();
  let osContext = null;
  if (window.OffscreenCanvas !== void 0) {
    osContext = new OffscreenCanvas(256, 1024).getContext("2d");
  }
  if (osContext !== void 0 && osContext !== null) {
    osContext.font = `${theme.typography.fontSize}px ${theme.typography.body.fontFamily}`;
  }
  const threshold = React.useMemo(() => {
    const timeField = data$1.fields.find((f) => f.type === data.FieldType.time);
    if (!timeField) {
      return 0;
    }
    return calculateAroundPointThreshold(timeField);
  }, [data$1]);
  const onRowHover = React.useCallback(
    (idx, frame) => {
      if (!panelContext || !enableSharedCrosshair) {
        return;
      }
      const timeField = frame.fields.find((f) => f.type === data.FieldType.time);
      if (!timeField) {
        return;
      }
      panelContext.eventBus.publish(
        new data.DataHoverEvent({
          point: {
            time: timeField.values[idx]
          }
        })
      );
    },
    [enableSharedCrosshair, panelContext]
  );
  const onRowLeave = React.useCallback(() => {
    if (!panelContext || !enableSharedCrosshair) {
      return;
    }
    panelContext.eventBus.publish(new data.DataHoverClearEvent());
  }, [enableSharedCrosshair, panelContext]);
  const onDataHoverEvent = React.useCallback(
    (evt) => {
      var _a;
      if (((_a = evt.payload.point) == null ? void 0 : _a.time) && evt.payload.rowIndex !== void 0) {
        const timeField = data$1.fields.find((f) => f.type === data.FieldType.time);
        const time = timeField.values[evt.payload.rowIndex];
        const pointTime = evt.payload.point.time;
        if (isPointTimeValAroundTableTimeVal(pointTime, time, threshold)) {
          setRowHighlightIndex(evt.payload.rowIndex);
          return;
        }
        const matchedRowIndex = timeField.values.findIndex(
          (t) => isPointTimeValAroundTableTimeVal(pointTime, t, threshold)
        );
        if (matchedRowIndex !== -1) {
          setRowHighlightIndex(matchedRowIndex);
          return;
        }
        setRowHighlightIndex(void 0);
      }
    },
    [data$1.fields, threshold]
  );
  React.useEffect(() => {
    if (!panelContext || !enableSharedCrosshair || !data.hasTimeField(data$1) || footerPaginationEnabled) {
      return;
    }
    const subs = new rxjs.Subscription();
    subs.add(
      panelContext.eventBus.getStream(data.DataHoverEvent).pipe(rxjs.debounceTime(250)).subscribe({
        next: (evt) => {
          if (panelContext.eventBus === evt.origin) {
            return;
          }
          onDataHoverEvent(evt);
        }
      })
    );
    subs.add(
      panelContext.eventBus.getStream(data.DataHoverClearEvent).pipe(rxjs.debounceTime(250)).subscribe({
        next: (evt) => {
          if (panelContext.eventBus === evt.origin) {
            return;
          }
          setRowHighlightIndex(void 0);
        }
      })
    );
    return () => {
      subs.unsubscribe();
    };
  }, [data$1, enableSharedCrosshair, footerPaginationEnabled, onDataHoverEvent, panelContext]);
  let scrollTop = void 0;
  if (rowHighlightIndex !== void 0) {
    const firstMatchedRowIndex = rows.findIndex((row) => row.index === rowHighlightIndex);
    if (firstMatchedRowIndex !== -1) {
      scrollTop = headerHeight + (firstMatchedRowIndex - 1) * rowHeight;
    }
  }
  const rowIndexForPagination = React.useCallback(
    (index) => {
      return tableState.pageIndex * tableState.pageSize + index;
    },
    [tableState.pageIndex, tableState.pageSize]
  );
  let rowBg = void 0;
  let textWrapFinal;
  for (const field of data$1.fields) {
    const fieldOptions = field.config.custom;
    const cellOptionsExist = fieldOptions !== void 0 && fieldOptions.cellOptions !== void 0;
    if (cellOptionsExist && fieldOptions.cellOptions.type === schema.TableCellDisplayMode.ColorBackground && fieldOptions.cellOptions.applyToRow) {
      rowBg = (rowIndex) => {
        const display = field.display(field.values.get(rowIndex));
        const colors = getCellColors$1(tableStyles.theme, fieldOptions.cellOptions, display);
        return colors;
      };
    }
    if (textWrapField !== void 0) {
      textWrapFinal = textWrapField;
    } else if (longestField !== void 0) {
      textWrapFinal = longestField;
    }
  }
  const RenderRow = React.useCallback(
    ({ index, style, rowHighlightIndex: rowHighlightIndex2 }) => {
      const indexForPagination = rowIndexForPagination(index);
      const row = rows[indexForPagination];
      let additionalProps = {};
      prepareRow(row);
      const expandedRowStyle = tableState.expanded[row.id] ? css.css({ "&:hover": { background: "inherit" } }) : {};
      const rowExpanded = nestedDataField && tableState.expanded[row.id];
      if (rowHighlightIndex2 !== void 0 && row.index === rowHighlightIndex2) {
        style = { ...style, backgroundColor: theme.components.table.rowSelected };
        additionalProps = {
          "aria-selected": "true"
        };
      }
      if (rowBg) {
        const { bgColor, textColor } = rowBg(row.index);
        style.background = bgColor;
        style.color = textColor;
        style.borderLeft = `2px solid ${bgColor}`;
      }
      if (textWrapFinal) {
        const visibleFields = data$1.fields.filter((field) => {
          var _a;
          return !Boolean((_a = field.config.custom) == null ? void 0 : _a.hidden);
        });
        const seriesIndex = visibleFields.findIndex((field) => field.name === textWrapFinal.name);
        const pxLineHeight = theme.typography.body.lineHeight * theme.typography.fontSize;
        const bbox = guessTextBoundingBox(
          textWrapFinal.values[row.index],
          headerGroups[0].headers[seriesIndex],
          osContext,
          pxLineHeight,
          tableStyles.rowHeight,
          tableStyles.cellPadding
        );
        style.height = bbox.height;
      }
      const { key, ...rowProps } = row.getRowProps({ style, ...additionalProps });
      return /* @__PURE__ */ jsxRuntime.jsxs(
        "div",
        {
          ...rowProps,
          className: css.cx(tableStyles.row, expandedRowStyle),
          onMouseEnter: () => onRowHover(row.index, data$1),
          onMouseLeave: onRowLeave,
          children: [
            rowExpanded && /* @__PURE__ */ jsxRuntime.jsx(
              ExpandedRow,
              {
                nestedData: nestedDataField,
                tableStyles,
                rowIndex: row.index,
                width,
                cellHeight
              }
            ),
            row.cells.map((cell, index2) => /* @__PURE__ */ jsxRuntime.jsx(
              TableCell,
              {
                tableStyles,
                cell,
                onCellFilterAdded,
                columnIndex: index2,
                columnCount: row.cells.length,
                timeRange,
                frame: data$1,
                rowStyled: rowBg !== void 0,
                rowExpanded,
                textWrapped: textWrapFinal !== void 0,
                height: Number(style.height) - 1,
                getActions,
                replaceVariables,
                setInspectCell
              },
              index2
            ))
          ]
        },
        key
      );
    },
    [
      rowIndexForPagination,
      rows,
      prepareRow,
      tableState.expanded,
      nestedDataField,
      rowBg,
      textWrapFinal,
      tableStyles,
      onRowLeave,
      width,
      cellHeight,
      theme.components.table.rowSelected,
      theme.typography.body.lineHeight,
      theme.typography.fontSize,
      data$1,
      headerGroups,
      osContext,
      onRowHover,
      onCellFilterAdded,
      timeRange,
      getActions,
      replaceVariables,
      setInspectCell
    ]
  );
  const getItemSize = (index) => {
    const indexForPagination = rowIndexForPagination(index);
    const row = rows[indexForPagination];
    if (tableState.expanded[row.id] && nestedDataField) {
      return getExpandedRowHeight(nestedDataField, row.index, tableStyles);
    }
    if (textWrapFinal) {
      const visibleFields = data$1.fields.filter((field) => {
        var _a;
        return !Boolean((_a = field.config.custom) == null ? void 0 : _a.hidden);
      });
      const seriesIndex = visibleFields.findIndex((field) => field.name === textWrapFinal.name);
      const pxLineHeight = theme.typography.fontSize * theme.typography.body.lineHeight;
      return guessTextBoundingBox(
        textWrapFinal.values[row.index],
        headerGroups[0].headers[seriesIndex],
        osContext,
        pxLineHeight,
        tableStyles.rowHeight,
        tableStyles.cellPadding
      ).height;
    }
    return tableStyles.rowHeight;
  };
  const handleScroll = (event) => {
    const { scrollTop: scrollTop2 } = event.currentTarget;
    if (listRef.current !== null) {
      listRef.current.scrollTo(scrollTop2);
    }
  };
  const expandedKey = Object.keys(tableState.expanded).join("|");
  React.useEffect(() => {
    if (listRef.current) {
      listRef.current.resetAfterIndex(0);
    }
  }, [rows, listRef]);
  return /* @__PURE__ */ jsxRuntime.jsx(CustomScrollbar, { onScroll: handleScroll, hideHorizontalTrack: true, scrollTop, children: /* @__PURE__ */ jsxRuntime.jsx(
    reactWindow.VariableSizeList,
    {
      height: listHeight,
      itemCount,
      itemSize: getItemSize,
      width: "100%",
      ref: listRef,
      style: { overflow: void 0 },
      children: ({ index, style }) => RenderRow({ index, style, rowHighlightIndex })
    },
    `${rowHeight}${pageIndex}${expandedKey}`
  ) });
};

function useTableStyles(theme, cellHeightOption) {
  const borderColor = theme.colors.border.weak;
  const resizerColor = theme.colors.primary.border;
  const cellPadding = 6;
  const cellHeight = getCellHeight(theme, cellHeightOption, cellPadding);
  const rowHeight = cellHeight + 2;
  const headerHeight = 28;
  const buildCellContainerStyle = (color, background, backgroundHover, overflowOnHover, asCellText, textShouldWrap, textWrapped, rowStyled, rowExpanded) => {
    return css.css({
      label: overflowOnHover ? "cellContainerOverflow" : "cellContainerNoOverflow",
      padding: `${cellPadding}px`,
      width: "100%",
      // Cell height need to account for row border
      height: rowExpanded ? "auto !important" : `${rowHeight - 1}px`,
      wordBreak: textWrapped ? "break-all" : "inherit",
      display: "flex",
      ...asCellText ? {
        overflow: "hidden",
        textOverflow: "ellipsis",
        userSelect: "text",
        whiteSpace: "nowrap"
      } : {},
      alignItems: "center",
      borderRight: `1px solid ${borderColor}`,
      color: rowStyled ? "inherit" : color != null ? color : void 0,
      background: rowStyled ? void 0 : background != null ? background : void 0,
      backgroundClip: "padding-box",
      "&:last-child:not(:only-child)": {
        borderRight: "none"
      },
      "&:hover": {
        overflow: overflowOnHover && !textWrapped ? "visible" : void 0,
        width: textShouldWrap || !overflowOnHover ? "auto" : "auto !important",
        height: (textShouldWrap || overflowOnHover) && !textWrapped ? "auto !important" : `${rowHeight - 1}px`,
        minHeight: `${rowHeight - 1}px`,
        wordBreak: textShouldWrap ? "break-word" : void 0,
        whiteSpace: textShouldWrap && overflowOnHover ? "normal" : "nowrap",
        boxShadow: overflowOnHover ? `0 0 2px ${theme.colors.primary.main}` : void 0,
        background: rowStyled ? "inherit" : backgroundHover != null ? backgroundHover : theme.colors.background.primary,
        zIndex: 1,
        ".cellActions": {
          background: theme.components.tooltip.background,
          color: theme.components.tooltip.text,
          visibility: "visible",
          opacity: 1,
          width: "auto",
          borderRadius: theme.shape.radius.default
        }
      },
      a: {
        color: "inherit"
      },
      ".cellActions": {
        display: "flex",
        position: overflowOnHover ? void 0 : "absolute",
        top: overflowOnHover ? void 0 : "1px",
        right: overflowOnHover ? void 0 : 0,
        margin: overflowOnHover ? theme.spacing(0, 0, 0, 1) : "auto",
        visibility: "hidden",
        opacity: 0,
        width: 0,
        alignItems: "center",
        height: "100%",
        padding: theme.spacing(0.5, 0, 0.5, 0.5),
        background: theme.components.tooltip.background,
        color: theme.components.tooltip.text
      },
      ".cellActionsLeft": {
        right: "auto !important",
        left: 0
      }
    });
  };
  return {
    theme,
    cellHeight,
    buildCellContainerStyle,
    cellPadding,
    cellHeightInner: cellHeight - cellPadding * 2,
    rowHeight,
    table: css.css({
      height: "100%",
      width: "100%",
      overflow: "auto",
      display: "flex",
      flexDirection: "column"
    }),
    thead: css.css({
      label: "thead",
      height: `${headerHeight}px`,
      overflowY: "auto",
      overflowX: "hidden",
      position: "relative"
    }),
    tfoot: css.css({
      label: "tfoot",
      height: `${headerHeight}px`,
      borderTop: `1px solid ${borderColor}`,
      overflowY: "auto",
      overflowX: "hidden",
      position: "relative"
    }),
    headerRow: css.css({
      label: "row",
      borderBottom: `1px solid ${borderColor}`
    }),
    headerCell: css.css({
      height: "100%",
      padding: `0 ${cellPadding}px`,
      overflow: "hidden",
      whiteSpace: "nowrap",
      display: "flex",
      alignItems: "center",
      fontWeight: theme.typography.fontWeightMedium,
      "&:last-child": {
        borderRight: "none"
      }
    }),
    headerCellLabel: css.css({
      border: "none",
      padding: 0,
      background: "inherit",
      cursor: "pointer",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      fontWeight: theme.typography.fontWeightMedium,
      display: "flex",
      alignItems: "center",
      marginRight: theme.spacing(0.5),
      "&:hover": {
        textDecoration: "underline",
        color: theme.colors.text.link
      }
    }),
    cellContainerText: buildCellContainerStyle(void 0, void 0, void 0, true, true),
    cellContainerTextNoOverflow: buildCellContainerStyle(void 0, void 0, void 0, false, true),
    cellContainer: buildCellContainerStyle(void 0, void 0, void 0, true, false),
    cellContainerNoOverflow: buildCellContainerStyle(void 0, void 0, void 0, false, false),
    cellText: css.css({
      overflow: "hidden",
      textOverflow: "ellipsis",
      userSelect: "text",
      whiteSpace: "nowrap",
      cursor: "text"
    }),
    sortIcon: css.css({
      marginLeft: theme.spacing(0.5)
    }),
    cellLink: css.css({
      cursor: "pointer",
      overflow: "hidden",
      textOverflow: "ellipsis",
      userSelect: "text",
      whiteSpace: "nowrap",
      color: theme.colors.text.link,
      fontWeight: theme.typography.fontWeightMedium,
      paddingRight: theme.spacing(1.5),
      "&:hover": {
        textDecoration: "underline",
        color: theme.colors.text.link
      }
    }),
    cellLinkForColoredCell: css.css({
      cursor: "pointer",
      overflow: "hidden",
      textOverflow: "ellipsis",
      userSelect: "text",
      whiteSpace: "nowrap",
      fontWeight: theme.typography.fontWeightMedium,
      textDecoration: "underline"
    }),
    imageCellLink: css.css({
      cursor: "pointer",
      overflow: "hidden",
      height: "100%"
    }),
    headerFilter: css.css({
      background: "transparent",
      border: "none",
      label: "headerFilter",
      padding: 0
    }),
    paginationWrapper: css.css({
      display: "flex",
      height: `${cellHeight}px`,
      justifyContent: "center",
      alignItems: "center",
      width: "100%",
      li: {
        marginBottom: 0
      }
    }),
    paginationSummary: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.bodySmall.fontSize,
      display: "flex",
      justifyContent: "flex-end",
      padding: theme.spacing(0, 1, 0, 2)
    }),
    tableContentWrapper: (totalColumnsWidth) => {
      const width = totalColumnsWidth !== void 0 ? `${totalColumnsWidth}px` : "100%";
      return css.css({
        label: "tableContentWrapper",
        width,
        display: "flex",
        flexDirection: "column"
      });
    },
    row: css.css({
      label: "row",
      borderBottom: `1px solid ${borderColor}`,
      "&:hover": {
        backgroundColor: theme.components.table.rowHoverBackground
      },
      "&:last-child": {
        borderBottom: 0
      }
    }),
    imageCell: css.css({
      height: "100%"
    }),
    resizeHandle: css.css({
      label: "resizeHandle",
      cursor: "col-resize !important",
      display: "inline-block",
      background: resizerColor,
      opacity: 0,
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: "opacity 0.2s ease-in-out"
      },
      width: "8px",
      height: "100%",
      position: "absolute",
      right: "-4px",
      borderRadius: theme.shape.radius.default,
      top: 0,
      touchAction: "none",
      "&:hover": {
        opacity: 1
      }
    }),
    typeIcon: css.css({
      marginRight: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    noData: css.css({
      alignItems: "center",
      display: "flex",
      height: "100%",
      justifyContent: "center",
      width: "100%"
    }),
    expanderCell: css.css({
      display: "flex",
      flexDirection: "column",
      justifyContent: "center",
      height: `${rowHeight}px`,
      cursor: "pointer"
    })
  };
}
function getCellHeight(theme, cellHeightOption, cellPadding) {
  const bodyFontSize = theme.typography.fontSize;
  const lineHeight = theme.typography.body.lineHeight;
  switch (cellHeightOption) {
    case "md":
      return 42;
    case "lg":
      return 48;
    case "sm":
    default:
      return cellPadding * 2 + bodyFontSize * lineHeight;
  }
}

const COLUMN_MIN_WIDTH = 150;
const FOOTER_ROW_HEIGHT = 36;
const NO_DATA_TEXT = "No data";
const Table = React.memo((props) => {
  var _a, _b, _c, _d;
  const {
    ariaLabel,
    data: data$1,
    height,
    onCellFilterAdded,
    onColumnResize,
    width,
    columnMinWidth = COLUMN_MIN_WIDTH,
    noHeader,
    resizable = true,
    initialSortBy,
    footerOptions,
    showTypeIcons,
    footerValues,
    enablePagination,
    cellHeight = schema.TableCellHeight.Sm,
    timeRange,
    enableSharedCrosshair = false,
    initialRowIndex = void 0,
    fieldConfig,
    getActions,
    replaceVariables
  } = props;
  const listRef = React.useRef(null);
  const tableDivRef = React.useRef(null);
  const variableSizeListScrollbarRef = React.useRef(null);
  const theme = useTheme2();
  const tableStyles = useTableStyles(theme, cellHeight);
  const headerHeight = noHeader ? 0 : tableStyles.rowHeight;
  const [footerItems, setFooterItems] = React.useState(footerValues);
  const noValuesDisplayText = (_b = (_a = fieldConfig == null ? void 0 : fieldConfig.defaults) == null ? void 0 : _a.noValue) != null ? _b : NO_DATA_TEXT;
  const [inspectCell, setInspectCell] = React.useState(null);
  const footerHeight = React.useMemo(() => {
    const EXTENDED_ROW_HEIGHT = FOOTER_ROW_HEIGHT;
    let length = 0;
    if (!footerItems) {
      return 0;
    }
    for (const fv of footerItems) {
      if (Array.isArray(fv) && fv.length > length) {
        length = fv.length;
      }
    }
    if (length > 1) {
      return EXTENDED_ROW_HEIGHT * length;
    }
    return EXTENDED_ROW_HEIGHT;
  }, [footerItems]);
  const memoizedData = React.useMemo(() => {
    if (!data$1.fields.length) {
      return [];
    }
    return Array(data$1.length).fill(0);
  }, [data$1]);
  const isCountRowsSet = Boolean(
    (footerOptions == null ? void 0 : footerOptions.countRows) && footerOptions.reducer && footerOptions.reducer.length && footerOptions.reducer[0] === data.ReducerID.count
  );
  const nestedDataField = data$1.fields.find((f) => f.type === data.FieldType.nestedFrames);
  const hasNestedData = nestedDataField !== void 0;
  const memoizedColumns = React.useMemo(
    () => getColumns(data$1, width, columnMinWidth, hasNestedData, footerItems, isCountRowsSet),
    [data$1, width, columnMinWidth, hasNestedData, footerItems, isCountRowsSet]
  );
  const toggleAllRowsExpandedRef = React.useRef();
  const stateReducer = useTableStateReducer({
    onColumnResize,
    onSortByChange: (state2) => {
      toggleAllRowsExpandedRef.current(false);
      if (props.onSortByChange) {
        props.onSortByChange(state2);
      }
    },
    data: data$1
  });
  const hasUniqueId = !!((_d = (_c = data$1.meta) == null ? void 0 : _c.uniqueRowIdFields) == null ? void 0 : _d.length);
  const options = React.useMemo(() => {
    const options2 = {
      columns: memoizedColumns,
      data: memoizedData,
      disableResizing: !resizable,
      stateReducer,
      autoResetPage: false,
      initialState: getInitialState(initialSortBy, memoizedColumns),
      autoResetFilters: false,
      sortTypes: {
        // the builtin number type on react-table does not handle NaN values
        number: sortNumber,
        // should be replaced with the builtin string when react-table is upgraded,
        // see https://github.com/tannerlinsley/react-table/pull/3235
        "alphanumeric-insensitive": sortCaseInsensitive
      }
    };
    if (hasUniqueId) {
      options2.getRowId = (row, relativeIndex) => data.getRowUniqueId(data$1, relativeIndex);
      options2.autoResetExpanded = false;
    }
    return options2;
  }, [initialSortBy, memoizedColumns, memoizedData, resizable, stateReducer, hasUniqueId, data$1]);
  const {
    getTableProps,
    headerGroups,
    footerGroups,
    rows,
    prepareRow,
    totalColumnsWidth,
    page,
    state,
    gotoPage,
    setPageSize,
    pageOptions,
    toggleAllRowsExpanded
  } = reactTable.useTable(options, reactTable.useFilters, reactTable.useSortBy, reactTable.useAbsoluteLayout, reactTable.useResizeColumns, reactTable.useExpanded, reactTable.usePagination);
  const extendedState = state;
  toggleAllRowsExpandedRef.current = toggleAllRowsExpanded;
  React.useEffect(() => {
    if (!footerOptions) {
      setFooterItems(footerValues);
    }
  }, [footerValues, footerOptions]);
  React.useEffect(() => {
    var _a2;
    if (!footerOptions) {
      return;
    }
    if (!footerOptions.show) {
      setFooterItems(void 0);
      return;
    }
    if (isCountRowsSet) {
      const footerItemsCountRows = [];
      footerItemsCountRows[0] = (_a2 = rows.length.toString()) != null ? _a2 : data$1.length.toString();
      setFooterItems(footerItemsCountRows);
      return;
    }
    const footerItems2 = getFooterItems(
      headerGroups[0].headers,
      createFooterCalculationValues(rows),
      footerOptions,
      theme
    );
    setFooterItems(footerItems2);
  }, [footerOptions, theme, state.filters, data$1]);
  let listHeight = height - (headerHeight + footerHeight);
  if (enablePagination) {
    listHeight -= tableStyles.cellHeight;
  }
  const pageSize = Math.round(listHeight / tableStyles.rowHeight) - 1;
  React.useEffect(() => {
    if (pageSize <= 0) {
      return;
    }
    setPageSize(pageSize);
  }, [pageSize, setPageSize]);
  React.useEffect(() => {
    if (data$1.length / pageSize < state.pageIndex) {
      gotoPage(0);
    }
  }, [data$1]);
  useResetVariableListSizeCache(extendedState, listRef, data$1, hasUniqueId);
  useFixScrollbarContainer(variableSizeListScrollbarRef, tableDivRef);
  const onNavigate = React.useCallback(
    (toPage) => {
      gotoPage(toPage - 1);
    },
    [gotoPage]
  );
  const itemCount = enablePagination ? page.length : rows.length;
  let paginationEl = null;
  if (enablePagination) {
    const itemsRangeStart = state.pageIndex * state.pageSize + 1;
    let itemsRangeEnd = itemsRangeStart + state.pageSize - 1;
    const isSmall = width < 550;
    if (itemsRangeEnd > data$1.length) {
      itemsRangeEnd = data$1.length;
    }
    const numRows = rows.length;
    const displayedEnd = itemsRangeEnd < rows.length ? itemsRangeEnd : rows.length;
    paginationEl = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: tableStyles.paginationWrapper, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        Pagination,
        {
          currentPage: state.pageIndex + 1,
          numberOfPages: pageOptions.length,
          showSmallVersion: isSmall,
          onNavigate
        }
      ),
      isSmall ? null : /* @__PURE__ */ jsxRuntime.jsx("div", { className: tableStyles.paginationSummary, children: /* @__PURE__ */ jsxRuntime.jsxs(Trans, { i18nKey: "grafana-ui.table.pagination-summary", children: [
        { itemsRangeStart },
        " - ",
        { displayedEnd },
        " of ",
        { numRows },
        " rows"
      ] }) })
    ] });
  }
  const longestField = fieldConfig ? guessLongestField(fieldConfig, data$1) : void 0;
  let textWrapField = void 0;
  if (fieldConfig !== void 0) {
    data$1.fields.forEach((field) => {
      fieldConfig.overrides.forEach((override) => {
        const matcher = data.getFieldMatcher(override.matcher);
        if (matcher(field, data$1, [data$1])) {
          for (const property of override.properties) {
            if (property.id === "custom.cellOptions" && property.value.wrapText) {
              textWrapField = field;
            }
          }
        }
      });
    });
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsxs(
      "div",
      {
        ...getTableProps(),
        className: tableStyles.table,
        "aria-label": ariaLabel,
        role: "table",
        ref: tableDivRef,
        style: { width, height },
        children: [
          /* @__PURE__ */ jsxRuntime.jsx(CustomScrollbar, { hideVerticalTrack: true, children: /* @__PURE__ */ jsxRuntime.jsxs("div", { className: tableStyles.tableContentWrapper(totalColumnsWidth), children: [
            !noHeader && /* @__PURE__ */ jsxRuntime.jsx(HeaderRow, { headerGroups, showTypeIcons, tableStyles }),
            itemCount > 0 ? /* @__PURE__ */ jsxRuntime.jsx(
              "div",
              {
                "data-testid": e2eSelectors.selectors.components.Panels.Visualization.Table.body,
                ref: variableSizeListScrollbarRef,
                children: /* @__PURE__ */ jsxRuntime.jsx(
                  RowsList,
                  {
                    headerGroups,
                    data: data$1,
                    rows,
                    width,
                    cellHeight,
                    headerHeight,
                    rowHeight: tableStyles.rowHeight,
                    itemCount,
                    pageIndex: state.pageIndex,
                    listHeight,
                    listRef,
                    tableState: state,
                    prepareRow,
                    timeRange,
                    onCellFilterAdded,
                    nestedDataField,
                    tableStyles,
                    footerPaginationEnabled: Boolean(enablePagination),
                    enableSharedCrosshair,
                    initialRowIndex,
                    longestField,
                    textWrapField,
                    getActions,
                    replaceVariables,
                    setInspectCell
                  }
                )
              }
            ) : /* @__PURE__ */ jsxRuntime.jsx("div", { style: { height: height - headerHeight, width }, className: tableStyles.noData, children: noValuesDisplayText }),
            footerItems && /* @__PURE__ */ jsxRuntime.jsx(
              FooterRow,
              {
                isPaginationVisible: Boolean(enablePagination),
                footerValues: footerItems,
                footerGroups,
                totalColumnsWidth,
                tableStyles
              }
            )
          ] }) }),
          paginationEl
        ]
      }
    ),
    inspectCell !== null && /* @__PURE__ */ jsxRuntime.jsx(
      TableCellInspector,
      {
        mode: inspectCell.mode,
        value: inspectCell.value,
        onDismiss: () => {
          setInspectCell(null);
        }
      }
    )
  ] });
});
Table.displayName = "Table";

const TextArea = React.forwardRef(({ invalid, className, ...props }, ref) => {
  const styles = useStyles2(getTextAreaStyle, invalid);
  return /* @__PURE__ */ jsxRuntime.jsx("textarea", { ...props, className: css.cx(styles.textarea, className), ref });
});
const getTextAreaStyle = (theme, invalid = false) => ({
  textarea: css.cx(
    sharedInputStyle(theme),
    getFocusStyle(theme),
    css.css({
      display: "block",
      borderRadius: theme.shape.radius.default,
      padding: `${theme.spacing.gridSize / 4}px ${theme.spacing.gridSize}px`,
      width: "100%",
      borderColor: invalid ? theme.colors.error.border : theme.components.input.borderColor
    })
  )
});
TextArea.displayName = "TextArea";

class UnThemedTableInputCSV extends React.PureComponent {
  constructor(props) {
    super(props);
    this.readCSV = lodash.debounce(() => {
      const { config } = this.props;
      const { text } = this.state;
      this.setState({ data: data.readCSV(text, { config }) });
    }, 150);
    this.onTextChange = (event) => {
      this.setState({ text: event.target.value });
    };
    const { text, config } = props;
    this.state = {
      text,
      data: data.readCSV(text, { config })
    };
  }
  componentDidUpdate(prevProps, prevState) {
    const { text } = this.state;
    if (text !== prevState.text || this.props.config !== prevProps.config) {
      this.readCSV();
    }
    if (this.props.text !== prevProps.text && this.props.text !== text) {
      this.setState({ text: this.props.text });
    }
    if (this.state.data !== prevState.data) {
      this.props.onSeriesParsed(this.state.data, this.state.text);
    }
  }
  render() {
    const { width, height, theme } = this.props;
    const { data } = this.state;
    const styles = getStyles$u(theme);
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.tableInputCsv, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        TextArea,
        {
          style: { width, height },
          placeholder: t("grafana-ui.table.csv-placeholder", "Enter CSV here..."),
          value: this.state.text,
          onChange: this.onTextChange,
          className: styles.textarea
        }
      ),
      data && /* @__PURE__ */ jsxRuntime.jsx("footer", { className: styles.footer, children: data.map((frame, index) => {
        const rows = frame.length;
        const columns = frame.fields.length;
        return /* @__PURE__ */ jsxRuntime.jsx("span", { children: /* @__PURE__ */ jsxRuntime.jsxs(Trans, { i18nKey: "grafana-ui.table.csv-counts", children: [
          "Rows:",
          { rows },
          ", Columns:",
          { columns },
          " \xA0",
          /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "check-circle" })
        ] }) }, index);
      }) })
    ] });
  }
}
const TableInputCSV = withTheme2(UnThemedTableInputCSV);
TableInputCSV.displayName = "TableInputCSV";
const getStyles$u = stylesFactory((theme) => {
  return {
    tableInputCsv: css.css({
      position: "relative"
    }),
    textarea: css.css({
      height: "100%",
      width: "100%"
    }),
    footer: css.css({
      position: "absolute",
      bottom: "15px",
      right: "15px",
      border: "1px solid #222",
      background: theme.colors.success.main,
      padding: `1px ${theme.spacing(0.5)}`,
      fontSize: "80%"
    })
  };
});

const VerticalTab = React.forwardRef(
  ({ label, active, icon, counter, className, suffix: Suffix, onChangeTab, href, ...otherProps }, ref) => {
    const tabsStyles = useStyles2(getTabStyles);
    const content = () => /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon }),
      label,
      typeof counter === "number" && /* @__PURE__ */ jsxRuntime.jsx(Counter, { value: counter }),
      Suffix && /* @__PURE__ */ jsxRuntime.jsx(Suffix, { className: tabsStyles.suffix })
    ] });
    const linkClass = css.cx(tabsStyles.link, active && tabsStyles.activeStyle);
    return /* @__PURE__ */ jsxRuntime.jsx(
      "a",
      {
        href,
        className: linkClass,
        ...otherProps,
        onClick: onChangeTab,
        "aria-label": otherProps["aria-label"] || e2eSelectors.selectors.components.Tab.title(label),
        role: "tab",
        "aria-selected": active,
        ref,
        children: content()
      }
    );
  }
);
VerticalTab.displayName = "Tab";
const getTabStyles = (theme) => {
  return {
    link: css.css({
      padding: "6px 12px",
      display: "block",
      height: "100%",
      cursor: "pointer",
      position: "relative",
      color: theme.colors.text.primary,
      svg: {
        marginRight: theme.spacing(1)
      },
      "&:hover, &:focus": {
        textDecoration: "underline"
      }
    }),
    activeStyle: css.css({
      label: "activeTabStyle",
      color: theme.colors.text.maxContrast,
      overflow: "hidden",
      "&::before": {
        display: "block",
        content: '" "',
        position: "absolute",
        left: 0,
        width: "4px",
        bottom: "2px",
        top: "2px",
        borderRadius: theme.shape.radius.default,
        backgroundImage: "linear-gradient(0deg, #f05a28 30%, #fbca0a 99%)"
      }
    }),
    suffix: css.css({
      marginLeft: theme.spacing(1)
    })
  };
};

const PercentChange = ({ percentChange, styles }) => {
  let percentChangeIcon = void 0;
  if (percentChange > 0) {
    percentChangeIcon = "arrow-up";
  } else if (percentChange < 0) {
    percentChangeIcon = "arrow-down";
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: styles.containerStyles, children: [
    percentChangeIcon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: percentChangeIcon, height: styles.iconSize, width: styles.iconSize, viewBox: "6 6 12 12" }),
    percentChangeString(percentChange)
  ] });
};
const percentChangeString = (percentChange) => {
  return (percentChange / 100).toLocaleString(void 0, { style: "percent", maximumSignificantDigits: 3 });
};

const LINE_HEIGHT = 1.2;
const MAX_TITLE_SIZE = 30;
const VALUE_FONT_WEIGHT = 500;
class BigValueLayout {
  constructor(props) {
    this.props = props;
    var _a;
    const { width, height, value, text } = props;
    this.valueColor = (_a = value.color) != null ? _a : "gray";
    this.panelPadding = height > 100 ? 12 : 8;
    this.textValues = getTextValues(props);
    this.justifyCenter = shouldJustifyCenter(props.justifyMode, this.textValues.title);
    this.valueToAlignTo = this.textValues.valueToAlignTo;
    this.titleToAlignTo = this.textValues.titleToAlignTo;
    this.titleFontSize = 0;
    this.valueFontSize = 0;
    this.percentFontSize = 0;
    this.chartHeight = 0;
    this.chartWidth = 0;
    this.maxTextWidth = width - this.panelPadding * 2;
    this.maxTextHeight = height - this.panelPadding * 2;
    if (text) {
      if (text.titleSize) {
        this.titleFontSize = text.titleSize;
        this.titleToAlignTo = void 0;
      }
      if (text.valueSize) {
        this.valueFontSize = text.valueSize;
        this.valueToAlignTo = "";
      }
      if (text.percentSize) {
        this.percentFontSize = text.percentSize;
      }
    }
  }
  getTitleStyles() {
    const styles = {
      fontSize: `${this.titleFontSize}px`,
      lineHeight: LINE_HEIGHT
    };
    if (this.props.colorMode === BigValueColorMode.Background || this.props.colorMode === BigValueColorMode.BackgroundSolid) {
      styles.color = getTextColorForAlphaBackground(this.valueColor, this.props.theme.isDark);
    }
    return styles;
  }
  getValueStyles() {
    const styles = {
      fontSize: this.valueFontSize,
      fontWeight: VALUE_FONT_WEIGHT,
      lineHeight: LINE_HEIGHT,
      position: "relative",
      zIndex: 1
    };
    if (this.justifyCenter) {
      styles.textAlign = "center";
    }
    switch (this.props.colorMode) {
      case BigValueColorMode.Value:
        styles.color = this.valueColor;
        break;
      case BigValueColorMode.Background:
      case BigValueColorMode.BackgroundSolid:
        styles.color = getTextColorForAlphaBackground(this.valueColor, this.props.theme.isDark);
        break;
      case BigValueColorMode.None:
        styles.color = this.props.theme.colors.text.primary;
        break;
    }
    return styles;
  }
  getPercentChangeStyles(percentChange, percentChangeColorMode, valueStyles) {
    const VALUE_TO_PERCENT_CHANGE_RATIO = 2.5;
    const valueContainerStyles = this.getValueAndTitleContainerStyles();
    const percentFontSize = this.percentFontSize || Math.max(this.valueFontSize / VALUE_TO_PERCENT_CHANGE_RATIO, 12);
    let iconSize = this.percentFontSize ? this.percentFontSize - 3 : Math.max(this.valueFontSize / 3, 10);
    const themeVisualizationColors = this.props.theme.visualization;
    const color = getPercentChangeColor(percentChange, percentChangeColorMode, valueStyles, themeVisualizationColors);
    const containerStyles = {
      fontSize: percentFontSize,
      fontWeight: VALUE_FONT_WEIGHT,
      lineHeight: LINE_HEIGHT,
      position: "relative",
      display: "flex",
      alignItems: "center",
      gap: Math.max(percentFontSize / 3, 4),
      zIndex: 1,
      color
    };
    if (this.justifyCenter) {
      containerStyles.textAlign = "center";
    }
    if (valueContainerStyles.flexDirection === "column" && percentFontSize > 12) {
      containerStyles.marginTop = -(percentFontSize / 4);
    }
    if (valueContainerStyles.flexDirection === "row") {
      containerStyles.alignItems = "baseline";
      containerStyles.lineHeight = LINE_HEIGHT * VALUE_TO_PERCENT_CHANGE_RATIO;
    }
    switch (this.props.colorMode) {
      case BigValueColorMode.Background:
      case BigValueColorMode.BackgroundSolid:
        containerStyles.color = getTextColorForAlphaBackground(this.valueColor, this.props.theme.isDark);
        break;
    }
    if (this.props.textMode === BigValueTextMode.None) {
      containerStyles.fontSize = calculateFontSize(
        percentChangeString(percentChange),
        this.maxTextWidth * 0.8,
        this.maxTextHeight * 0.8,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
      iconSize = containerStyles.fontSize * 0.8;
    }
    return {
      containerStyles,
      iconSize
    };
  }
  getValueAndTitleContainerStyles() {
    const styles = {
      display: "flex",
      flexWrap: "wrap"
    };
    if (this.justifyCenter) {
      styles.alignItems = "center";
      styles.justifyContent = "center";
      styles.flexGrow = 1;
      styles.gap = "0.75ch";
    }
    return styles;
  }
  getPanelStyles() {
    const { width, height, theme, colorMode, textMode } = this.props;
    const panelStyles = {
      width: `${width}px`,
      height: `${height}px`,
      padding: `${textMode === BigValueTextMode.None ? 2 : this.panelPadding}px`,
      borderRadius: theme.shape.radius.default,
      position: "relative",
      display: "flex"
    };
    const themeFactor = theme.isDark ? 1 : -0.7;
    switch (colorMode) {
      case BigValueColorMode.Background:
        const bgColor2 = tinycolor__default.default(this.valueColor).darken(15 * themeFactor).spin(8).toRgbString();
        const bgColor3 = tinycolor__default.default(this.valueColor).darken(5 * themeFactor).spin(-8).toRgbString();
        panelStyles.background = `linear-gradient(120deg, ${bgColor2}, ${bgColor3})`;
        break;
      case BigValueColorMode.BackgroundSolid:
        panelStyles.background = tinycolor__default.default(this.valueColor).toString();
        break;
      case BigValueColorMode.Value:
        panelStyles.background = `transparent`;
        break;
    }
    if (this.justifyCenter) {
      panelStyles.alignItems = "center";
      panelStyles.flexDirection = "row";
    }
    return panelStyles;
  }
  renderChart() {
    var _a;
    const { sparkline, colorMode } = this.props;
    if (!sparkline || ((_a = sparkline.y) == null ? void 0 : _a.type) !== data.FieldType.number) {
      return null;
    }
    let fillColor;
    let lineColor;
    switch (colorMode) {
      case BigValueColorMode.Background:
      case BigValueColorMode.BackgroundSolid:
        fillColor = "rgba(255,255,255,0.4)";
        lineColor = tinycolor__default.default(this.valueColor).brighten(40).toRgbString();
        break;
      case BigValueColorMode.None:
      case BigValueColorMode.Value:
      default:
        lineColor = this.valueColor;
        fillColor = tinycolor__default.default(this.valueColor).setAlpha(0.2).toRgbString();
        break;
    }
    const config = {
      custom: {
        drawStyle: schema.GraphDrawStyle.Line,
        lineWidth: 1,
        fillColor,
        lineColor
      }
    };
    return /* @__PURE__ */ jsxRuntime.jsx("div", { style: this.getChartStyles(), children: /* @__PURE__ */ jsxRuntime.jsx(
      Sparkline,
      {
        height: this.chartHeight,
        width: this.chartWidth,
        sparkline,
        config,
        theme: this.props.theme
      }
    ) });
  }
  getChartStyles() {
    return {
      position: "absolute",
      right: 0,
      bottom: 0
    };
  }
}
class WideNoChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const valueWidthPercent = ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) ? 0.3 : 1;
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth * valueWidthPercent,
        this.maxTextHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth * 0.6,
        this.maxTextHeight,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "row";
    styles.alignItems = "center";
    styles.flexGrow = 1;
    if (!this.justifyCenter) {
      styles.justifyContent = "space-between";
    }
    return styles;
  }
  renderChart() {
    return null;
  }
  getPanelStyles() {
    const panelStyles = super.getPanelStyles();
    panelStyles.alignItems = "center";
    return panelStyles;
  }
}
class WideWithChartLayout extends BigValueLayout {
  constructor(props) {
    var _a;
    super(props);
    const { width, height } = props;
    const chartHeightPercent = 0.5;
    const titleWidthPercent = 0.6;
    const valueWidthPercent = 1 - titleWidthPercent;
    const textHeightPercent = 0.4;
    this.chartWidth = width;
    this.chartHeight = height * chartHeightPercent;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth * titleWidthPercent,
        this.maxTextHeight * textHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth * valueWidthPercent,
        this.maxTextHeight * chartHeightPercent,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "row";
    styles.flexGrow = 1;
    if (!this.justifyCenter) {
      styles.justifyContent = "space-between";
    }
    return styles;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.flexDirection = "row";
    styles.justifyContent = "space-between";
    return styles;
  }
}
class StackedWithChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const { width, height } = props;
    const titleHeightPercent = 0.15;
    const chartHeightPercent = 0.25;
    let titleHeight = 0;
    this.chartHeight = height * chartHeightPercent;
    this.chartWidth = width;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth,
        height * titleHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      titleHeight = this.titleFontSize * LINE_HEIGHT;
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth,
        this.maxTextHeight - this.chartHeight - titleHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
    this.chartHeight = height - this.titleFontSize * LINE_HEIGHT - this.valueFontSize * LINE_HEIGHT;
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "column";
    styles.justifyContent = "center";
    return styles;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.flexDirection = "column";
    return styles;
  }
}
class StackedWithNoChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const { height } = props;
    const titleHeightPercent = 0.15;
    let titleHeight = 0;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth,
        height * titleHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      titleHeight = this.titleFontSize * LINE_HEIGHT;
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth,
        this.maxTextHeight - titleHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "column";
    styles.flexGrow = 1;
    return styles;
  }
  renderChart() {
    return null;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.alignItems = "center";
    return styles;
  }
}
function buildLayout(props) {
  const { width, height, sparkline } = props;
  const useWideLayout = width / height > 2.5 && !props.disableWideLayout;
  if (useWideLayout) {
    if (height > 50 && !!sparkline && sparkline.y.values.length > 1) {
      return new WideWithChartLayout(props);
    } else {
      return new WideNoChartLayout(props);
    }
  }
  if (height > 100 && sparkline && sparkline.y.values.length > 1) {
    return new StackedWithChartLayout(props);
  } else {
    return new StackedWithNoChartLayout(props);
  }
}
function shouldJustifyCenter(justifyMode, title) {
  if (justifyMode === BigValueJustifyMode.Center) {
    return true;
  }
  return (title != null ? title : "").length === 0;
}
function getTextValues(props) {
  const { value, alignmentFactors, count } = props;
  let { textMode } = props;
  const titleToAlignTo = alignmentFactors ? alignmentFactors.title : value.title;
  const valueToAlignTo = data.formattedValueToString(alignmentFactors ? alignmentFactors : value);
  if (textMode === BigValueTextMode.Auto && (count != null ? count : 1) === 1) {
    textMode = BigValueTextMode.Value;
  }
  switch (textMode) {
    case BigValueTextMode.Name:
      return {
        ...value,
        title: void 0,
        prefix: void 0,
        suffix: void 0,
        text: value.title || "",
        titleToAlignTo: void 0,
        valueToAlignTo: titleToAlignTo != null ? titleToAlignTo : "",
        tooltip: data.formattedValueToString(value)
      };
    case BigValueTextMode.Value:
      return {
        ...value,
        title: void 0,
        titleToAlignTo: void 0,
        valueToAlignTo,
        tooltip: value.title
      };
    case BigValueTextMode.None:
      return {
        numeric: value.numeric,
        color: value.color,
        title: void 0,
        text: "",
        titleToAlignTo: void 0,
        valueToAlignTo: "1",
        tooltip: `Name: ${value.title}
Value: ${data.formattedValueToString(value)}`
      };
    case BigValueTextMode.ValueAndName:
    default:
      return {
        ...value,
        titleToAlignTo,
        valueToAlignTo
      };
  }
}
function getPercentChangeColor(percentChange, percentChangeColorMode, valueStyles, themeVisualizationColors) {
  if (percentChangeColorMode === schema.PercentChangeColorMode.SameAsValue) {
    return valueStyles.color;
  } else {
    return percentChange * (percentChangeColorMode === schema.PercentChangeColorMode.Inverted ? -1 : 1) > 0 ? themeVisualizationColors.getColorByName("green") : themeVisualizationColors.getColorByName("red");
  }
}

var BigValueColorMode = /* @__PURE__ */ ((BigValueColorMode2) => {
  BigValueColorMode2["Background"] = "background";
  BigValueColorMode2["BackgroundSolid"] = "background_solid";
  BigValueColorMode2["None"] = "none";
  BigValueColorMode2["Value"] = "value";
  return BigValueColorMode2;
})(BigValueColorMode || {});
var BigValueJustifyMode = /* @__PURE__ */ ((BigValueJustifyMode2) => {
  BigValueJustifyMode2["Auto"] = "auto";
  BigValueJustifyMode2["Center"] = "center";
  return BigValueJustifyMode2;
})(BigValueJustifyMode || {});
var BigValueTextMode = /* @__PURE__ */ ((BigValueTextMode2) => {
  BigValueTextMode2["Auto"] = "auto";
  BigValueTextMode2["Value"] = "value";
  BigValueTextMode2["ValueAndName"] = "value_and_name";
  BigValueTextMode2["Name"] = "name";
  BigValueTextMode2["None"] = "none";
  return BigValueTextMode2;
})(BigValueTextMode || {});
class BigValue extends React.PureComponent {
  render() {
    const { onClick, className, hasLinks, theme } = this.props;
    const layout = buildLayout(this.props);
    const panelStyles = layout.getPanelStyles();
    const valueAndTitleContainerStyles = layout.getValueAndTitleContainerStyles();
    const valueStyles = layout.getValueStyles();
    const titleStyles = layout.getTitleStyles();
    const textValues = layout.textValues;
    const percentChange = this.props.value.percentChange;
    const percentChangeColorMode = this.props.percentChangeColorMode;
    const showPercentChange = percentChange != null && !Number.isNaN(percentChange);
    const tooltip = hasLinks ? void 0 : textValues.tooltip;
    if (!onClick) {
      return /* @__PURE__ */ jsxRuntime.jsxs("div", { className, style: panelStyles, title: tooltip, children: [
        /* @__PURE__ */ jsxRuntime.jsxs("div", { style: valueAndTitleContainerStyles, children: [
          textValues.title && /* @__PURE__ */ jsxRuntime.jsx("div", { style: titleStyles, children: textValues.title }),
          /* @__PURE__ */ jsxRuntime.jsx(FormattedValueDisplay, { value: textValues, style: valueStyles }),
          showPercentChange && /* @__PURE__ */ jsxRuntime.jsx(
            PercentChange,
            {
              percentChange,
              styles: layout.getPercentChangeStyles(percentChange, percentChangeColorMode, valueStyles)
            }
          )
        ] }),
        layout.renderChart()
      ] });
    }
    return /* @__PURE__ */ jsxRuntime.jsxs(
      "button",
      {
        type: "button",
        className: css.cx(clearButtonStyles(theme), className),
        style: panelStyles,
        onClick,
        title: tooltip,
        children: [
          /* @__PURE__ */ jsxRuntime.jsxs("div", { style: valueAndTitleContainerStyles, children: [
            textValues.title && /* @__PURE__ */ jsxRuntime.jsx("div", { style: titleStyles, children: textValues.title }),
            /* @__PURE__ */ jsxRuntime.jsx(FormattedValueDisplay, { value: textValues, style: valueStyles })
          ] }),
          layout.renderChart()
        ]
      }
    );
  }
}
BigValue.defaultProps = {
  justifyMode: "auto" /* Auto */
};

const DEFAULT_THRESHOLDS = {
  mode: data.ThresholdsMode.Absolute,
  steps: [
    { value: -Infinity, color: "green" },
    { value: 80, color: "red" }
  ]
};
function calculateGaugeAutoProps(width, height, title, orientation) {
  const showLabel = title !== null && title !== void 0;
  const titleFontSizeDimension = orientation === schema.VizOrientation.Vertical ? height : width;
  const titleFontSize = Math.min(titleFontSizeDimension * 0.15 / 1.5, 20);
  const titleHeight = titleFontSize * 1.5;
  const availableHeight = showLabel ? height - titleHeight : height;
  const gaugeHeight = Math.min(availableHeight, width);
  return {
    showLabel,
    gaugeHeight,
    titleFontSize
  };
}
function getFormattedThresholds(decimals, field, value, theme) {
  var _a, _b, _c, _d, _e, _f;
  if (((_a = field.color) == null ? void 0 : _a.mode) !== data.FieldColorModeId.Thresholds) {
    return [{ value: (_b = field.min) != null ? _b : data.GAUGE_DEFAULT_MINIMUM, color: (_c = value.color) != null ? _c : data.FALLBACK_COLOR }];
  }
  const thresholds = (_d = field.thresholds) != null ? _d : DEFAULT_THRESHOLDS;
  const isPercent = thresholds.mode === data.ThresholdsMode.Percentage;
  const steps = thresholds.steps;
  let min = (_e = field.min) != null ? _e : data.GAUGE_DEFAULT_MINIMUM;
  let max = (_f = field.max) != null ? _f : data.GAUGE_DEFAULT_MAXIMUM;
  if (isPercent) {
    min = 0;
    max = 100;
  }
  const first = data.getActiveThreshold(min, steps);
  const last = data.getActiveThreshold(max, steps);
  const formatted = [
    { value: +min.toFixed(decimals), color: theme.visualization.getColorByName(first.color) }
  ];
  let skip = true;
  for (let i = 0; i < steps.length; i++) {
    const step = steps[i];
    if (skip) {
      if (first === step) {
        skip = false;
      }
      continue;
    }
    const prev = steps[i - 1];
    formatted.push({ value: step.value, color: theme.visualization.getColorByName(prev.color) });
    if (step === last) {
      break;
    }
  }
  formatted.push({ value: +max.toFixed(decimals), color: theme.visualization.getColorByName(last.color) });
  return formatted;
}

class Gauge extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.canvasElement = null;
    this.renderVisualization = () => {
      var _a;
      const { width, value, height, onClick, text, theme, orientation } = this.props;
      const autoProps = calculateGaugeAutoProps(width, height, value.title, orientation);
      const gaugeWidth = orientation === schema.VizOrientation.Vertical ? `${autoProps.gaugeHeight}px` : "100%";
      const gaugeElement = /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          style: { height: `${autoProps.gaugeHeight}px`, width: gaugeWidth },
          ref: (element) => this.canvasElement = element
        }
      );
      return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        onClick ? /* @__PURE__ */ jsxRuntime.jsx("button", { className: clearButtonStyles(theme), type: "button", onClick, children: gaugeElement }) : gaugeElement,
        autoProps.showLabel && /* @__PURE__ */ jsxRuntime.jsx(
          "div",
          {
            style: {
              textAlign: "center",
              fontSize: (_a = text == null ? void 0 : text.titleSize) != null ? _a : autoProps.titleFontSize,
              overflow: "hidden",
              textOverflow: "ellipsis",
              whiteSpace: "nowrap",
              position: "relative",
              width: gaugeWidth,
              top: "-4px",
              cursor: "default"
            },
            children: value.title
          }
        )
      ] });
    };
  }
  componentDidMount() {
    this.draw();
  }
  componentDidUpdate() {
    this.draw();
  }
  draw() {
    var _a, _b, _c, _d, _e, _f;
    const { field, showThresholdLabels, showThresholdMarkers, width, height, theme, value, orientation } = this.props;
    const autoProps = calculateGaugeAutoProps(width, height, value.title);
    const calculatedGaugeWidth = orientation === schema.VizOrientation.Vertical ? autoProps.gaugeHeight : width;
    const dimension = Math.min(calculatedGaugeWidth, autoProps.gaugeHeight);
    const backgroundColor = theme.colors.background.secondary;
    const gaugeWidthReduceRatio = showThresholdLabels ? 1.5 : 1;
    const gaugeWidth = Math.min(dimension / 5.5, 40) / gaugeWidthReduceRatio;
    const thresholdMarkersWidth = gaugeWidth / 5;
    const text = data.formattedValueToString(value);
    const valueWidthBase = Math.min(calculatedGaugeWidth, dimension * 1.3) * 0.9;
    const valueWidth = valueWidthBase - ((gaugeWidth + (showThresholdMarkers ? thresholdMarkersWidth : 0) + (showThresholdLabels ? 10 : 0)) * 2 + 10);
    const fontSize = (_b = (_a = this.props.text) == null ? void 0 : _a.valueSize) != null ? _b : calculateFontSize(text, valueWidth, dimension, 1, gaugeWidth * 1.7);
    const thresholdLabelFontSize = Math.max(fontSize / 2.5, 12);
    let min = (_c = field.min) != null ? _c : data.GAUGE_DEFAULT_MINIMUM;
    let max = (_d = field.max) != null ? _d : data.GAUGE_DEFAULT_MAXIMUM;
    let numeric = value.numeric;
    if (((_e = field.thresholds) == null ? void 0 : _e.mode) === data.ThresholdsMode.Percentage) {
      min = 0;
      max = 100;
      if (value.percent === void 0) {
        numeric = (numeric - min) / (max - min) * 100;
      } else {
        numeric = value.percent * 100;
      }
    }
    const decimals = field.decimals === void 0 ? 2 : field.decimals;
    if (showThresholdMarkers) {
      min = +min.toFixed(decimals);
      max = +max.toFixed(decimals);
    }
    const options = {
      series: {
        gauges: {
          gauge: {
            min,
            max,
            neutralValue: (_f = field.custom) == null ? void 0 : _f.neutral,
            background: { color: backgroundColor },
            border: { color: null },
            shadow: { show: false },
            width: gaugeWidth
          },
          frame: { show: false },
          label: { show: false },
          layout: { margin: 0, thresholdWidth: 0, vMargin: 0 },
          cell: { border: { width: 0 } },
          threshold: {
            values: getFormattedThresholds(decimals, field, value, theme),
            label: {
              show: showThresholdLabels,
              margin: thresholdMarkersWidth + 1,
              font: { size: thresholdLabelFontSize }
            },
            show: showThresholdMarkers,
            width: thresholdMarkersWidth
          },
          value: {
            color: value.color,
            formatter: () => {
              return text;
            },
            font: { size: fontSize, family: theme.typography.fontFamily }
          },
          show: true
        }
      }
    };
    const plotSeries = {
      data: [[0, numeric]],
      label: value.title
    };
    try {
      if (this.canvasElement) {
        $__default.default.plot(this.canvasElement, [plotSeries], options);
      }
    } catch (err) {
      console.error("Gauge rendering error", err, options, value);
    }
  }
  render() {
    return /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        style: {
          width: "100%",
          height: "100%",
          display: "flex",
          flexDirection: "column",
          justifyContent: "center",
          overflow: "hidden"
        },
        className: this.props.className,
        children: this.renderVisualization()
      }
    );
  }
}
Gauge.defaultProps = {
  showThresholdMarkers: true,
  showThresholdLabels: false,
  field: {
    min: 0,
    max: 100,
    thresholds: DEFAULT_THRESHOLDS
  }
};

const calculateTooltipPosition = (xPos = 0, yPos = 0, tooltipWidth = 0, tooltipHeight = 0, xOffset = 0, yOffset = 0, windowWidth = 0, windowHeight = 0) => {
  let x = xPos;
  let y = yPos;
  const overflowRight = Math.max(xPos + xOffset + tooltipWidth - (windowWidth - xOffset), 0);
  const overflowLeft = Math.abs(Math.min(xPos - xOffset - tooltipWidth - xOffset, 0));
  const wouldOverflowRight = overflowRight > 0;
  const wouldOverflowLeft = overflowLeft > 0;
  const overflowBelow = Math.max(yPos + yOffset + tooltipHeight - (windowHeight - yOffset), 0);
  const overflowAbove = Math.abs(Math.min(yPos - yOffset - tooltipHeight - yOffset, 0));
  const wouldOverflowBelow = overflowBelow > 0;
  const wouldOverflowAbove = overflowAbove > 0;
  if (wouldOverflowRight && wouldOverflowLeft) {
    x = overflowRight > overflowLeft ? xOffset : windowWidth - xOffset - tooltipWidth;
  } else if (wouldOverflowRight) {
    x = xPos - xOffset - tooltipWidth;
  } else {
    x = xPos + xOffset;
  }
  if (wouldOverflowBelow && wouldOverflowAbove) {
    y = overflowBelow > overflowAbove ? yOffset : windowHeight - yOffset - tooltipHeight;
  } else if (wouldOverflowBelow) {
    y = yPos - yOffset - tooltipHeight;
  } else {
    y = yPos + yOffset;
  }
  return { x, y };
};

const VizTooltipContainer = ({
  position: { x: positionX, y: positionY },
  offset: { x: offsetX, y: offsetY },
  children,
  allowPointerEvents = false,
  className,
  ...otherProps
}) => {
  const tooltipRef = React.useRef(null);
  const [tooltipMeasurement, setTooltipMeasurement] = React.useState({ width: 0, height: 0 });
  const { width, height } = reactUse.useWindowSize();
  const [placement, setPlacement] = React.useState({
    x: positionX + offsetX,
    y: positionY + offsetY
  });
  const resizeObserver = React.useMemo(
    () => (
      // TS has hard time playing games with @types/resize-observer-browser, hence the ignore
      // @ts-ignore
      new ResizeObserver((entries) => {
        for (let entry of entries) {
          const tW = Math.floor(entry.contentRect.width + 2 * 8);
          const tH = Math.floor(entry.contentRect.height + 2 * 8);
          if (tooltipMeasurement.width !== tW || tooltipMeasurement.height !== tH) {
            setTooltipMeasurement({
              width: Math.min(tW, width),
              height: Math.min(tH, height)
            });
          }
        }
      })
    ),
    [tooltipMeasurement, width, height]
  );
  React.useLayoutEffect(() => {
    if (tooltipRef.current) {
      resizeObserver.observe(tooltipRef.current);
    }
    return () => {
      resizeObserver.disconnect();
    };
  }, [resizeObserver]);
  React.useLayoutEffect(() => {
    if (tooltipRef && tooltipRef.current) {
      const { x, y } = calculateTooltipPosition(
        positionX,
        positionY,
        tooltipMeasurement.width,
        tooltipMeasurement.height,
        offsetX,
        offsetY,
        width,
        height
      );
      setPlacement({ x, y });
    }
  }, [width, height, positionX, offsetX, positionY, offsetY, tooltipMeasurement]);
  const styles = useStyles2(getStyles$t);
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      ref: tooltipRef,
      style: {
        position: "fixed",
        left: 0,
        // disabling pointer-events is to prevent the tooltip from flickering when moving left to right
        // see e.g. https://github.com/grafana/grafana/pull/33609
        pointerEvents: allowPointerEvents ? "auto" : "none",
        top: 0,
        transform: `translate(${placement.x}px, ${placement.y}px)`,
        transition: "transform ease-out 0.1s"
      },
      "aria-live": "polite",
      "aria-atomic": "true",
      ...otherProps,
      className: css.cx(styles.wrapper, className),
      children
    }
  );
};
VizTooltipContainer.displayName = "VizTooltipContainer";
const getStyles$t = (theme) => ({
  wrapper: css.css(getTooltipContainerStyles(theme))
});

const VizTooltip = ({ content, position, offset }) => {
  const styles = useStyles2(getStyles$s);
  if (position) {
    return /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { className: styles.portal, children: /* @__PURE__ */ jsxRuntime.jsx(VizTooltipContainer, { position, offset: offset || { x: 0, y: 0 }, children: content }) });
  }
  return null;
};
VizTooltip.displayName = "VizTooltip";
const getStyles$s = () => {
  return {
    portal: css.css({
      position: "absolute",
      top: 0,
      left: 0,
      pointerEvents: "none",
      width: "100%",
      height: "100%"
    })
  };
};

const SeriesIcon = React__namespace.memo(
  React__namespace.forwardRef(({ color, className, gradient, lineStyle, ...restProps }, ref) => {
    var _a, _b;
    const theme = useTheme2();
    const styles = useStyles2(getStyles$r);
    let cssColor;
    if (gradient) {
      const colors = (_b = (_a = data.fieldColorModeRegistry.get(gradient)).getColors) == null ? void 0 : _b.call(_a, theme);
      if (colors == null ? void 0 : colors.length) {
        cssColor = `linear-gradient(90deg, ${colors.join(", ")})`;
      } else {
        cssColor = theme.visualization.getColorByName("");
      }
    } else {
      cssColor = color;
    }
    let customStyle;
    if ((lineStyle == null ? void 0 : lineStyle.fill) === "dot" && !gradient) {
      customStyle = {
        backgroundImage: `radial-gradient(circle at 2px 2px, ${color} 2px, transparent 0)`,
        backgroundSize: "4px 4px",
        backgroundRepeat: "space"
      };
    } else if ((lineStyle == null ? void 0 : lineStyle.fill) === "dash" && !gradient) {
      customStyle = {
        backgroundImage: `linear-gradient(to right, ${color} 100%, transparent 0%)`,
        backgroundSize: "6px 4px",
        backgroundRepeat: "space"
      };
    } else {
      customStyle = {
        background: cssColor,
        borderRadius: theme.shape.radius.pill
      };
    }
    return /* @__PURE__ */ jsxRuntime.jsx(
      "div",
      {
        "data-testid": "series-icon",
        ref,
        className: css.cx(className, styles.forcedColors, styles.container),
        style: customStyle,
        ...restProps
      }
    );
  })
);
const getStyles$r = (theme) => ({
  container: css.css({
    marginRight: "8px",
    display: "inline-block",
    width: "14px",
    height: "4px"
  }),
  forcedColors: css.css({
    "@media (forced-colors: active)": {
      forcedColorAdjust: "none"
    }
  })
});
SeriesIcon.displayName = "SeriesIcon";

const getSeriesTableRowStyles = (theme) => {
  return {
    icon: css.css({
      marginRight: theme.spacing(1),
      verticalAlign: "middle"
    }),
    seriesTable: css.css({
      display: "table"
    }),
    seriesTableRow: css.css({
      display: "table-row",
      fontSize: theme.typography.bodySmall.fontSize
    }),
    seriesTableCell: css.css({
      display: "table-cell"
    }),
    label: css.css({
      wordBreak: "break-all"
    }),
    value: css.css({
      paddingLeft: theme.spacing(2),
      textAlign: "right"
    }),
    activeSeries: css.css({
      fontWeight: theme.typography.fontWeightBold,
      color: theme.colors.text.maxContrast
    }),
    timestamp: css.css({
      fontWeight: theme.typography.fontWeightBold,
      fontSize: theme.typography.bodySmall.fontSize
    })
  };
};
const SeriesTableRow = ({ color, label, value, isActive }) => {
  const styles = useStyles2(getSeriesTableRowStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { "data-testid": "SeriesTableRow", className: css.cx(styles.seriesTableRow, isActive && styles.activeSeries), children: [
    color && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.seriesTableCell, children: /* @__PURE__ */ jsxRuntime.jsx(SeriesIcon, { color, className: styles.icon }) }),
    label && /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.seriesTableCell, styles.label), children: label }),
    value && /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.seriesTableCell, styles.value), children: value })
  ] });
};
const SeriesTable = ({ timestamp, series }) => {
  const styles = useStyles2(getSeriesTableRowStyles);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    timestamp && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.timestamp, "aria-label": t("grafana-ui.viz-tooltip.timestamp", "Timestamp"), children: timestamp }),
    series.map((s, i) => {
      return /* @__PURE__ */ jsxRuntime.jsx(
        SeriesTableRow,
        {
          isActive: s.isActive,
          label: s.label,
          color: s.color,
          value: s.value
        },
        `${s.label}-${i}`
      );
    })
  ] });
};

const calculateGridDimensions = (parentWidth, parentHeight, itemSpacing, numberOfChildren) => {
  const vertical = calculateSizeOfChild(parentWidth, parentHeight, numberOfChildren);
  const horizontal = calculateSizeOfChild(parentHeight, parentWidth, numberOfChildren);
  const square = Math.max(vertical, horizontal);
  let xCount = Math.floor(parentWidth / square);
  let yCount = Math.ceil(numberOfChildren / xCount);
  xCount = Math.ceil(numberOfChildren / yCount);
  const itemsOnLastRow = xCount - (xCount * yCount - numberOfChildren);
  const widthOnLastRow = parentWidth / itemsOnLastRow - itemSpacing + itemSpacing / itemsOnLastRow;
  return {
    width: parentWidth / xCount - itemSpacing + itemSpacing / xCount,
    height: parentHeight / yCount - itemSpacing + itemSpacing / yCount,
    widthOnLastRow,
    xCount,
    yCount
  };
};
function calculateSizeOfChild(parentWidth, parentHeight, numberOfChildren) {
  const parts = Math.ceil(Math.sqrt(numberOfChildren * parentWidth / parentHeight));
  if (Math.floor(parts * parentHeight / parentWidth) * parts < numberOfChildren) {
    return parentHeight / Math.ceil(parts * parentHeight / parentWidth);
  }
  return parentWidth / parts;
}

class VizRepeater extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      values: props.getValues()
    };
  }
  componentDidUpdate(prevProps) {
    const { renderCounter, source } = this.props;
    if (renderCounter !== prevProps.renderCounter || source !== prevProps.source) {
      this.setState({ values: this.props.getValues() });
    }
  }
  getOrientation() {
    const { orientation, width, height } = this.props;
    if (orientation === data.VizOrientation.Auto) {
      if (width > height) {
        return data.VizOrientation.Vertical;
      } else {
        return data.VizOrientation.Horizontal;
      }
    }
    return orientation;
  }
  renderGrid() {
    const { renderValue, height, width, itemSpacing, getAlignmentFactors, orientation } = this.props;
    const { values } = this.state;
    const grid = calculateGridDimensions(width, height, itemSpacing, values.length);
    const alignmentFactors = getAlignmentFactors ? getAlignmentFactors(values, grid.width, grid.height) : {};
    let xGrid = 0;
    let yGrid = 0;
    let items = [];
    for (let i = 0; i < values.length; i++) {
      const value = values[i];
      const isLastRow = yGrid === grid.yCount - 1;
      const itemWidth = isLastRow ? grid.widthOnLastRow : grid.width;
      const itemHeight = grid.height;
      const xPos = xGrid * itemWidth + itemSpacing * xGrid;
      const yPos = yGrid * itemHeight + itemSpacing * yGrid;
      const itemStyles = {
        position: "absolute",
        left: xPos,
        top: yPos,
        width: `${itemWidth}px`,
        height: `${itemHeight}px`
      };
      items.push(
        /* @__PURE__ */ jsxRuntime.jsx("div", { style: itemStyles, children: renderValue({
          value,
          width: itemWidth,
          height: itemHeight,
          alignmentFactors,
          orientation,
          count: values.length
        }) }, i)
      );
      xGrid++;
      if (xGrid === grid.xCount) {
        xGrid = 0;
        yGrid++;
      }
    }
    return /* @__PURE__ */ jsxRuntime.jsx("div", { style: { position: "relative" }, children: items });
  }
  render() {
    const {
      renderValue,
      height,
      width,
      itemSpacing,
      getAlignmentFactors,
      autoGrid,
      orientation,
      maxVizHeight,
      minVizWidth,
      minVizHeight
    } = this.props;
    const { values } = this.state;
    if (autoGrid && orientation === data.VizOrientation.Auto) {
      return this.renderGrid();
    }
    const itemStyles = {
      display: "flex"
    };
    const repeaterStyle = {
      display: "flex",
      overflow: `${minVizWidth ? "auto" : "hidden"} ${minVizHeight ? "auto" : "hidden"}`
    };
    let vizHeight = height;
    let vizWidth = width;
    const resolvedOrientation = this.getOrientation();
    switch (resolvedOrientation) {
      case data.VizOrientation.Horizontal:
        const defaultVizHeight = (height + itemSpacing) / values.length - itemSpacing;
        repeaterStyle.flexDirection = "column";
        repeaterStyle.height = `${height}px`;
        repeaterStyle.overflowX = "hidden";
        repeaterStyle.scrollbarWidth = "thin";
        itemStyles.marginBottom = `${itemSpacing}px`;
        vizWidth = width;
        vizHeight = lodash.clamp(defaultVizHeight, minVizHeight != null ? minVizHeight : 0, maxVizHeight != null ? maxVizHeight : defaultVizHeight);
        break;
      case data.VizOrientation.Vertical:
        repeaterStyle.flexDirection = "row";
        repeaterStyle.justifyContent = "space-between";
        repeaterStyle.overflowY = "hidden";
        itemStyles.marginRight = `${itemSpacing}px`;
        vizHeight = height;
        vizWidth = Math.max(width / values.length - itemSpacing + itemSpacing / values.length, minVizWidth != null ? minVizWidth : 0);
    }
    itemStyles.width = `${vizWidth}px`;
    itemStyles.height = `${vizHeight}px`;
    const alignmentFactors = getAlignmentFactors ? getAlignmentFactors(values, vizWidth, vizHeight) : {};
    return /* @__PURE__ */ jsxRuntime.jsx("div", { style: repeaterStyle, children: values.map((value, index) => {
      return /* @__PURE__ */ jsxRuntime.jsx("div", { style: getItemStylesForIndex(itemStyles, index, values.length), children: renderValue({
        value,
        width: vizWidth,
        height: vizHeight,
        alignmentFactors,
        orientation: resolvedOrientation,
        count: values.length
      }) }, index);
    }) });
  }
}
VizRepeater.defaultProps = {
  itemSpacing: 8
};
function getItemStylesForIndex(itemStyles, index, length) {
  if (index === length - 1) {
    return {
      ...itemStyles,
      marginRight: 0,
      marginBottom: 0
    };
  }
  return itemStyles;
}

const VizLayout = ({ width, height, legend, children }) => {
  const theme = useTheme2();
  const styles = useStyles2(getVizStyles);
  const containerStyle = {
    display: "flex",
    width: `${width}px`,
    height: `${height}px`
  };
  const [legendRef, legendMeasure] = reactUse.useMeasure();
  if (!legend) {
    return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx("div", { style: containerStyle, className: styles.viz, children: children(width, height) }) });
  }
  let { placement, maxHeight = "35%", maxWidth = "60%" } = legend.props;
  if (document.body.clientWidth < theme.breakpoints.values.lg) {
    placement = "bottom";
  }
  let size = null;
  const legendStyle = {};
  switch (placement) {
    case "bottom":
      containerStyle.flexDirection = "column";
      legendStyle.maxHeight = maxHeight;
      if (legendMeasure.height) {
        size = { width, height: height - legendMeasure.height };
      }
      break;
    case "right":
      containerStyle.flexDirection = "row";
      legendStyle.maxWidth = maxWidth;
      if (legendMeasure.width) {
        size = { width: width - legendMeasure.width, height };
      }
      if (legend.props.width) {
        legendStyle.width = legend.props.width;
        size = { width: width - legend.props.width, height };
      }
      break;
  }
  if ((size == null ? void 0 : size.width) === 0) {
    size.width = width;
  }
  if ((size == null ? void 0 : size.height) === 0) {
    size.height = height;
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: containerStyle, children: [
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.viz, children: size && children(size.width, size.height) }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { style: legendStyle, ref: legendRef, children: /* @__PURE__ */ jsxRuntime.jsx(ScrollContainer, { children: legend }) })
  ] });
};
const getVizStyles = (theme) => {
  return {
    viz: css.css({
      flexGrow: 2,
      borderRadius: theme.shape.radius.default,
      "&:focus-visible": getFocusStyles(theme)
    })
  };
};
const VizLayoutLegend = ({ children }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children });
};
VizLayout.Legend = VizLayoutLegend;

var SeriesVisibilityChangeBehavior = /* @__PURE__ */ ((SeriesVisibilityChangeBehavior2) => {
  SeriesVisibilityChangeBehavior2[SeriesVisibilityChangeBehavior2["Isolate"] = 0] = "Isolate";
  SeriesVisibilityChangeBehavior2[SeriesVisibilityChangeBehavior2["Hide"] = 1] = "Hide";
  return SeriesVisibilityChangeBehavior2;
})(SeriesVisibilityChangeBehavior || {});

class InlineList extends React.PureComponent {
  render() {
    return /* @__PURE__ */ jsxRuntime.jsx(AbstractList, { inline: true, ...this.props });
  }
}

const VizLegendSeriesIcon = React.memo(({ seriesName, color, gradient, readonly, lineStyle }) => {
  const { onSeriesColorChange } = usePanelContext();
  const onChange = React.useCallback(
    (color2) => {
      return onSeriesColorChange(seriesName, color2);
    },
    [seriesName, onSeriesColorChange]
  );
  if (seriesName && onSeriesColorChange && color && !readonly) {
    return /* @__PURE__ */ jsxRuntime.jsx(SeriesColorPicker, { color, onChange, enableNamedColors: true, children: ({ ref, showColorPicker, hideColorPicker }) => /* @__PURE__ */ jsxRuntime.jsx(
      SeriesIcon,
      {
        color,
        className: "pointer",
        ref,
        onClick: showColorPicker,
        onMouseLeave: hideColorPicker,
        lineStyle
      }
    ) });
  }
  return /* @__PURE__ */ jsxRuntime.jsx(SeriesIcon, { color, gradient, lineStyle });
});
VizLegendSeriesIcon.displayName = "VizLegendSeriesIcon";

const VizLegendStatsList = ({ stats }) => {
  const styles = useStyles2(getStyles$q);
  if (stats.length === 0) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsx(
    InlineList,
    {
      className: styles.list,
      items: stats,
      renderItem: (stat) => /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.item, title: stat.description, children: [
        stat.title && `${lodash.capitalize(stat.title)}:`,
        " ",
        data.formattedValueToString(stat)
      ] })
    }
  );
};
const getStyles$q = () => ({
  list: css.css({
    flexGrow: 1,
    textAlign: "right"
  }),
  item: css.css({
    marginLeft: "8px"
  })
});
VizLegendStatsList.displayName = "VizLegendStatsList";

const VizLegendListItem = ({
  item,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  className,
  readonly
}) => {
  var _a;
  const styles = useStyles2(getStyles$p);
  const onMouseOver = React.useCallback(
    (event) => {
      if (onLabelMouseOver) {
        onLabelMouseOver(item, event);
      }
    },
    [item, onLabelMouseOver]
  );
  const onMouseOut = React.useCallback(
    (event) => {
      if (onLabelMouseOut) {
        onLabelMouseOut(item, event);
      }
    },
    [item, onLabelMouseOut]
  );
  const onClick = React.useCallback(
    (event) => {
      if (onLabelClick) {
        onLabelClick(item, event);
      }
    },
    [item, onLabelClick]
  );
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      className: css.cx(styles.itemWrapper, item.disabled && styles.itemDisabled, className),
      "data-testid": e2eSelectors.selectors.components.VizLegend.seriesName(item.label),
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          VizLegendSeriesIcon,
          {
            seriesName: (_a = item.fieldName) != null ? _a : item.label,
            color: item.color,
            gradient: item.gradient,
            readonly,
            lineStyle: item.lineStyle
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx(
          "button",
          {
            disabled: readonly,
            type: "button",
            onBlur: onMouseOut,
            onFocus: onMouseOver,
            onMouseOver,
            onMouseOut,
            onClick,
            className: styles.label,
            children: item.label
          }
        ),
        item.getDisplayValues && /* @__PURE__ */ jsxRuntime.jsx(VizLegendStatsList, { stats: item.getDisplayValues() })
      ]
    }
  );
};
VizLegendListItem.displayName = "VizLegendListItem";
const getStyles$p = (theme) => ({
  label: css.css({
    label: "LegendLabel",
    whiteSpace: "nowrap",
    background: "none",
    border: "none",
    fontSize: "inherit",
    padding: 0,
    userSelect: "text"
  }),
  itemDisabled: css.css({
    label: "LegendLabelDisabled",
    color: theme.colors.text.disabled
  }),
  itemWrapper: css.css({
    label: "LegendItemWrapper",
    display: "flex",
    whiteSpace: "nowrap",
    alignItems: "center",
    flexGrow: 1
  }),
  value: css.css({
    textAlign: "right"
  }),
  yAxisLabel: css.css({
    color: theme.v1.palette.gray2
  })
});

const VizLegendList = ({
  items,
  itemRenderer,
  onLabelMouseOver,
  onLabelMouseOut,
  onLabelClick,
  placement,
  className,
  readonly
}) => {
  const styles = useStyles2(getStyles$o);
  if (!itemRenderer) {
    itemRenderer = (item) => /* @__PURE__ */ jsxRuntime.jsx(
      VizLegendListItem,
      {
        item,
        onLabelClick,
        onLabelMouseOver,
        onLabelMouseOut,
        readonly
      }
    );
  }
  const getItemKey = (item) => `${item.getItemKey ? item.getItemKey() : item.label}`;
  switch (placement) {
    case "right": {
      const renderItem = (item, index) => {
        return /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.itemRight, children: itemRenderer(item, index) });
      };
      return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.rightWrapper, className), children: /* @__PURE__ */ jsxRuntime.jsx(List, { items, renderItem, getItemKey }) });
    }
    case "bottom":
    default: {
      const leftItems = items.filter((item) => item.yAxis === 1);
      const rightItems = items.filter((item) => item.yAxis !== 1);
      const renderItem = (item, index) => {
        return /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.itemBottom, children: itemRenderer(item, index) });
      };
      return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.bottomWrapper, className), children: [
        leftItems.length > 0 && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.section, children: /* @__PURE__ */ jsxRuntime.jsx(InlineList, { items: leftItems, renderItem, getItemKey }) }),
        rightItems.length > 0 && /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.section, styles.sectionRight), children: /* @__PURE__ */ jsxRuntime.jsx(InlineList, { items: rightItems, renderItem, getItemKey }) })
      ] });
    }
  }
};
VizLegendList.displayName = "VizLegendList";
const getStyles$o = (theme) => {
  const itemStyles = css.css({
    paddingRight: "10px",
    display: "flex",
    fontSize: theme.typography.bodySmall.fontSize,
    whiteSpace: "nowrap"
  });
  return {
    itemBottom: itemStyles,
    itemRight: css.cx(
      itemStyles,
      css.css({
        marginBottom: theme.spacing(0.5)
      })
    ),
    rightWrapper: css.css({
      padding: theme.spacing(0.5)
    }),
    bottomWrapper: css.css({
      display: "flex",
      flexWrap: "wrap",
      justifyContent: "space-between",
      width: "100%",
      padding: theme.spacing(0.5),
      gap: "15px 25px"
    }),
    section: css.css({
      display: "flex"
    }),
    sectionRight: css.css({
      justifyContent: "flex-end",
      flexGrow: 1,
      flexBasis: "50%"
    })
  };
};

const LegendTableItem = ({
  item,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  className,
  readonly
}) => {
  var _a;
  const styles = useStyles2(getStyles$n);
  const onMouseOver = React.useCallback(
    (event) => {
      if (onLabelMouseOver) {
        onLabelMouseOver(item, event);
      }
    },
    [item, onLabelMouseOver]
  );
  const onMouseOut = React.useCallback(
    (event) => {
      if (onLabelMouseOut) {
        onLabelMouseOut(item, event);
      }
    },
    [item, onLabelMouseOut]
  );
  const onClick = React.useCallback(
    (event) => {
      if (onLabelClick) {
        onLabelClick(item, event);
      }
    },
    [item, onLabelClick]
  );
  return /* @__PURE__ */ jsxRuntime.jsxs("tr", { className: css.cx(styles.row, className), children: [
    /* @__PURE__ */ jsxRuntime.jsx("td", { children: /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.itemWrapper, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        VizLegendSeriesIcon,
        {
          color: item.color,
          seriesName: (_a = item.fieldName) != null ? _a : item.label,
          readonly,
          lineStyle: item.lineStyle
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsxs(
        "button",
        {
          disabled: readonly,
          type: "button",
          title: item.label,
          onBlur: onMouseOut,
          onFocus: onMouseOver,
          onMouseOver,
          onMouseOut,
          onClick: !readonly ? onClick : void 0,
          className: css.cx(styles.label, item.disabled && styles.labelDisabled),
          children: [
            item.label,
            " ",
            item.yAxis === 2 && /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.yAxisLabel, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.viz-legend.right-axis-indicator", children: "(right y-axis)" }) })
          ]
        }
      )
    ] }) }),
    item.getDisplayValues && item.getDisplayValues().map((stat, index) => {
      return /* @__PURE__ */ jsxRuntime.jsx("td", { className: styles.value, children: data.formattedValueToString(stat) }, `${stat.title}-${index}`);
    })
  ] });
};
LegendTableItem.displayName = "LegendTableItem";
const getStyles$n = (theme) => {
  const rowHoverBg = hoverColor(theme.colors.background.primary, theme);
  return {
    row: css.css({
      label: "LegendRow",
      fontSize: theme.v1.typography.size.sm,
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      td: {
        padding: theme.spacing(0.25, 1),
        whiteSpace: "nowrap"
      },
      "&:hover": {
        background: rowHoverBg
      }
    }),
    label: css.css({
      label: "LegendLabel",
      whiteSpace: "nowrap",
      background: "none",
      border: "none",
      fontSize: "inherit",
      padding: 0,
      maxWidth: "600px",
      textOverflow: "ellipsis",
      overflow: "hidden",
      userSelect: "text"
    }),
    labelDisabled: css.css({
      label: "LegendLabelDisabled",
      color: theme.colors.text.disabled
    }),
    itemWrapper: css.css({
      display: "flex",
      whiteSpace: "nowrap",
      alignItems: "center"
    }),
    value: css.css({
      textAlign: "right"
    }),
    yAxisLabel: css.css({
      color: theme.colors.text.secondary
    })
  };
};

const nameSortKey = "Name";
const naturalCompare = new Intl.Collator(void 0, { numeric: true, sensitivity: "base" }).compare;
const VizLegendTable = ({
  items,
  sortBy: sortKey,
  sortDesc,
  itemRenderer,
  className,
  onToggleSort,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  readonly,
  isSortable
}) => {
  var _a, _b;
  const styles = useStyles2(getStyles$m);
  const header = {};
  if (isSortable) {
    header[nameSortKey] = "";
  }
  for (const item of items) {
    if (item.getDisplayValues) {
      for (const displayValue of item.getDisplayValues()) {
        header[(_a = displayValue.title) != null ? _a : "?"] = (_b = displayValue.description) != null ? _b : "";
      }
    }
  }
  if (sortKey != null) {
    let itemVals = /* @__PURE__ */ new Map();
    items.forEach((item) => {
      if (sortKey !== nameSortKey && item.getDisplayValues) {
        const stat = item.getDisplayValues().find((stat2) => stat2.title === sortKey);
        const val = stat == null || Number.isNaN(stat.numeric) ? -Infinity : stat.numeric;
        itemVals.set(item, val);
      }
    });
    let sortMult = sortDesc ? -1 : 1;
    if (sortKey === nameSortKey) {
      items.sort((a, b) => {
        return sortMult * naturalCompare(a.label, b.label);
      });
    } else {
      items.sort((a, b) => {
        var _a2, _b2;
        const aVal = (_a2 = itemVals.get(a)) != null ? _a2 : 0;
        const bVal = (_b2 = itemVals.get(b)) != null ? _b2 : 0;
        return sortMult * (aVal - bVal);
      });
    }
  }
  if (!itemRenderer) {
    itemRenderer = (item, index) => /* @__PURE__ */ jsxRuntime.jsx(
      LegendTableItem,
      {
        item,
        onLabelClick,
        onLabelMouseOver,
        onLabelMouseOut,
        readonly
      },
      `${item.label}-${index}`
    );
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("table", { className: css.cx(styles.table, className), children: [
    /* @__PURE__ */ jsxRuntime.jsx("thead", { children: /* @__PURE__ */ jsxRuntime.jsxs("tr", { children: [
      !isSortable && /* @__PURE__ */ jsxRuntime.jsx("th", {}),
      Object.keys(header).map((columnTitle) => /* @__PURE__ */ jsxRuntime.jsxs(
        "th",
        {
          title: header[columnTitle],
          className: css.cx(styles.header, onToggleSort && styles.headerSortable, isSortable && styles.nameHeader, {
            [styles.withIcon]: sortKey === columnTitle
          }),
          onClick: () => {
            if (onToggleSort) {
              onToggleSort(columnTitle);
            }
          },
          children: [
            columnTitle,
            sortKey === columnTitle && /* @__PURE__ */ jsxRuntime.jsx(Icon, { size: "xs", name: sortDesc ? "angle-down" : "angle-up" })
          ]
        },
        columnTitle
      ))
    ] }) }),
    /* @__PURE__ */ jsxRuntime.jsx("tbody", { children: items.map(itemRenderer) })
  ] });
};
const getStyles$m = (theme) => ({
  table: css.css({
    width: "100%",
    "th:first-child": {
      width: "100%",
      borderBottom: `1px solid ${theme.colors.border.weak}`
    }
  }),
  header: css.css({
    color: theme.colors.primary.text,
    fontWeight: theme.typography.fontWeightMedium,
    borderBottom: `1px solid ${theme.colors.border.weak}`,
    padding: theme.spacing(0.25, 1, 0.25, 1),
    fontSize: theme.typography.bodySmall.fontSize,
    textAlign: "right",
    whiteSpace: "nowrap"
  }),
  nameHeader: css.css({
    textAlign: "left",
    paddingLeft: "30px"
  }),
  // This needs to be padding-right - icon size(xs==12) to avoid jumping
  withIcon: css.css({
    paddingRight: "4px"
  }),
  headerSortable: css.css({
    cursor: "pointer"
  })
});

function mapMouseEventToMode(event) {
  if (event.ctrlKey || event.metaKey || event.shiftKey) {
    return SeriesVisibilityChangeMode.AppendToSelection;
  }
  return SeriesVisibilityChangeMode.ToggleSelection;
}

function VizLegend({
  items,
  thresholdItems,
  mappingItems,
  displayMode,
  sortBy: sortKey,
  seriesVisibilityChangeBehavior = SeriesVisibilityChangeBehavior.Isolate,
  sortDesc,
  onLabelClick,
  onToggleSort,
  placement,
  className,
  itemRenderer,
  readonly,
  isSortable
}) {
  const { eventBus, onToggleSeriesVisibility, onToggleLegendSort } = usePanelContext();
  const onMouseOver = React.useCallback(
    (item, event) => {
      eventBus == null ? void 0 : eventBus.publish({
        type: data.DataHoverEvent.type,
        payload: {
          raw: event,
          x: 0,
          y: 0,
          dataId: item.label
        }
      });
    },
    [eventBus]
  );
  const onMouseOut = React.useCallback(
    (item, event) => {
      eventBus == null ? void 0 : eventBus.publish({
        type: data.DataHoverClearEvent.type,
        payload: {
          raw: event,
          x: 0,
          y: 0,
          dataId: item.label
        }
      });
    },
    [eventBus]
  );
  const onLegendLabelClick = React.useCallback(
    (item, event) => {
      var _a;
      if (onLabelClick) {
        onLabelClick(item, event);
      }
      if (onToggleSeriesVisibility) {
        onToggleSeriesVisibility(
          (_a = item.fieldName) != null ? _a : item.label,
          seriesVisibilityChangeBehavior === SeriesVisibilityChangeBehavior.Hide ? SeriesVisibilityChangeMode.AppendToSelection : mapMouseEventToMode(event)
        );
      }
    },
    [onToggleSeriesVisibility, onLabelClick, seriesVisibilityChangeBehavior]
  );
  const makeVizLegendList = React.useCallback(
    (items2) => {
      return /* @__PURE__ */ jsxRuntime.jsx(
        VizLegendList,
        {
          className,
          placement,
          onLabelMouseOver: onMouseOver,
          onLabelMouseOut: onMouseOut,
          onLabelClick: onLegendLabelClick,
          itemRenderer,
          readonly,
          items: items2
        }
      );
    },
    [className, placement, onMouseOver, onMouseOut, onLegendLabelClick, itemRenderer, readonly]
  );
  switch (displayMode) {
    case schema.LegendDisplayMode.Table:
      return /* @__PURE__ */ jsxRuntime.jsx(
        VizLegendTable,
        {
          className,
          items,
          placement,
          sortBy: sortKey,
          sortDesc,
          onLabelClick: onLegendLabelClick,
          onToggleSort: onToggleSort || onToggleLegendSort,
          onLabelMouseOver: onMouseOver,
          onLabelMouseOut: onMouseOut,
          itemRenderer,
          readonly,
          isSortable
        }
      );
    case schema.LegendDisplayMode.List:
      const isThresholdsEnabled = thresholdItems && thresholdItems.length > 1;
      const isValueMappingEnabled = mappingItems && mappingItems.length > 0;
      return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        !isThresholdsEnabled && (!isValueMappingEnabled || items.length > 1) && makeVizLegendList(items),
        isThresholdsEnabled && makeVizLegendList(thresholdItems),
        isValueMappingEnabled && makeVizLegendList(mappingItems)
      ] });
    default:
      return null;
  }
}
VizLegend.displayName = "VizLegend";

const getStyles$l = (theme) => {
  return {
    list: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      "&:last-child": {
        border: "none"
      }
    }),
    wrapper: css.css({
      background: theme.colors.background.primary,
      width: "250px"
    }),
    item: css.css({
      background: "none",
      padding: "2px 8px",
      userSelect: "none",
      color: theme.colors.text.primary,
      cursor: "pointer",
      "&:hover": {
        background: theme.colors.action.hover
      }
    }),
    label: css.css({
      color: theme.colors.text.secondary
    }),
    activeItem: css.css({
      background: theme.colors.background.secondary,
      "&:hover": {
        background: theme.colors.background.secondary
      }
    }),
    itemValue: css.css({
      fontFamily: theme.typography.fontFamilyMonospace,
      fontSize: theme.typography.size.sm
    })
  };
};
const DataLinkSuggestions = ({ suggestions, ...otherProps }) => {
  const ref = React.useRef(null);
  useClickAway__default.default(ref, () => {
    if (otherProps.onClose) {
      otherProps.onClose();
    }
  });
  const groupedSuggestions = React.useMemo(() => {
    return lodash.groupBy(suggestions, (s) => s.origin);
  }, [suggestions]);
  const styles = useStyles2(getStyles$l);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { role: "menu", ref, className: styles.wrapper, children: Object.keys(groupedSuggestions).map((key, i) => {
    const indexOffset = i === 0 ? 0 : Object.keys(groupedSuggestions).reduce((acc, current, index) => {
      if (index >= i) {
        return acc;
      }
      return acc + groupedSuggestions[current].length;
    }, 0);
    return /* @__PURE__ */ React.createElement(
      DataLinkSuggestionsList,
      {
        ...otherProps,
        suggestions: groupedSuggestions[key],
        label: lodash.capitalize(key),
        activeIndex: otherProps.activeIndex,
        activeIndexOffset: indexOffset,
        key
      }
    );
  }) });
};
DataLinkSuggestions.displayName = "DataLinkSuggestions";
const DataLinkSuggestionsList = React__namespace.memo(
  ({
    activeIndex,
    activeIndexOffset,
    label,
    onClose,
    onSuggestionSelect,
    suggestions,
    activeRef: selectedRef
  }) => {
    const styles = useStyles2(getStyles$l);
    return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx(
      List,
      {
        className: styles.list,
        items: suggestions,
        renderItem: (item, index) => {
          const isActive = index + activeIndexOffset === activeIndex;
          return (
            // key events are handled by DataLinkInput
            // eslint-disable-next-line jsx-a11y/click-events-have-key-events
            /* @__PURE__ */ jsxRuntime.jsx(
              "div",
              {
                role: "menuitem",
                tabIndex: 0,
                className: css.cx(styles.item, isActive && styles.activeItem),
                ref: isActive ? selectedRef : void 0,
                onClick: () => {
                  onSuggestionSelect(item);
                },
                title: item.documentation,
                children: /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.itemValue, children: [
                  /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.label, children: label }),
                  " ",
                  item.label
                ] })
              }
            )
          );
        }
      }
    ) });
  }
);
DataLinkSuggestionsList.displayName = "DataLinkSuggestionsList";

class SelectionReference {
  getBoundingClientRect() {
    const selection = window.getSelection();
    const node = selection && selection.anchorNode;
    if (node && node.parentElement) {
      const rect = node.parentElement.getBoundingClientRect();
      return rect;
    }
    const fallbackDOMRect = {
      top: 0,
      left: 0,
      bottom: 0,
      right: 0,
      width: 0,
      height: 0,
      x: 0,
      y: 0,
      toJSON: () => {
      }
    };
    return fallbackDOMRect;
  }
  get clientWidth() {
    return this.getBoundingClientRect().width;
  }
  get clientHeight() {
    return this.getBoundingClientRect().height;
  }
}

const modulo = (a, n) => a - n * Math.floor(a / n);
const datalinksSyntax = {
  builtInVariable: {
    pattern: /(\${\S+?})/
  }
};
const plugins = [
  SlatePrism(
    {
      onlyIn: (node) => "type" in node && node.type === "code_block",
      getSyntax: () => "links"
    },
    { ...Prism__default.default.languages, links: datalinksSyntax }
  )
];
const getStyles$k = (theme) => ({
  input: getInputStyles({ theme, invalid: false }).input,
  editor: css.css({
    ".token.builtInVariable": {
      color: theme.colors.success.text
    },
    ".token.variable": {
      color: theme.colors.primary.text
    }
  }),
  suggestionsWrapper: css.css({
    boxShadow: theme.shadows.z2
  }),
  // Wrapper with child selector needed.
  // When classnames are applied to the same element as the wrapper, it causes the suggestions to stop working
  wrapperOverrides: css.css({
    width: "100%",
    "> .slate-query-field__wrapper": {
      padding: 0,
      backgroundColor: "transparent",
      border: "none"
    }
  })
});
const DataLinkInput = React.memo(
  ({
    value,
    onChange,
    suggestions,
    placeholder = "http://your-grafana.com/d/000000010/annotations"
  }) => {
    const editorRef = React.useRef(null);
    const styles = useStyles2(getStyles$k);
    const [showingSuggestions, setShowingSuggestions] = React.useState(false);
    const [suggestionsIndex, setSuggestionsIndex] = React.useState(0);
    const [linkUrl, setLinkUrl] = React.useState(makeValue(value));
    const prevLinkUrl = usePrevious__default.default(linkUrl);
    const [scrollTop, setScrollTop] = React.useState(0);
    const scrollRef = React.useRef(null);
    React.useEffect(() => {
      var _a;
      (_a = scrollRef.current) == null ? void 0 : _a.scrollTo(0, scrollTop);
    }, [scrollTop]);
    const middleware = [
      react.offset(({ rects }) => ({
        alignmentAxis: rects.reference.width
      })),
      react.flip({
        fallbackAxisSideDirection: "start",
        // see https://floating-ui.com/docs/flip#combining-with-shift
        crossAxis: false,
        boundary: document.body
      }),
      react.shift()
    ];
    const { refs, floatingStyles } = react.useFloating({
      open: showingSuggestions,
      placement: "bottom-start",
      onOpenChange: setShowingSuggestions,
      middleware,
      whileElementsMounted: react.autoUpdate,
      strategy: "fixed"
    });
    const stateRef = React.useRef({ showingSuggestions, suggestions, suggestionsIndex, linkUrl, onChange });
    stateRef.current = { showingSuggestions, suggestions, suggestionsIndex, linkUrl, onChange };
    const activeRef = React.useRef(null);
    React.useEffect(() => {
      setScrollTop(getElementPosition(activeRef.current, suggestionsIndex));
    }, [suggestionsIndex]);
    const onKeyDown = React__namespace.useCallback((event, next) => {
      if (!stateRef.current.showingSuggestions) {
        if (event.key === "=" || event.key === "$" || event.keyCode === 32 && event.ctrlKey) {
          const selectionRef = new SelectionReference();
          refs.setReference(selectionRef);
          return setShowingSuggestions(true);
        }
        return next();
      }
      switch (event.key) {
        case "Backspace":
          if (stateRef.current.linkUrl.focusText.getText().length === 1) {
            next();
          }
        case "Escape":
          setShowingSuggestions(false);
          return setSuggestionsIndex(0);
        case "Enter":
          event.preventDefault();
          return onVariableSelect(stateRef.current.suggestions[stateRef.current.suggestionsIndex]);
        case "ArrowDown":
        case "ArrowUp":
          event.preventDefault();
          const direction = event.key === "ArrowDown" ? 1 : -1;
          return setSuggestionsIndex((index) => modulo(index + direction, stateRef.current.suggestions.length));
        default:
          return next();
      }
    }, []);
    React.useEffect(() => {
      if (prevLinkUrl && prevLinkUrl.selection.isFocused && !linkUrl.selection.isFocused) {
        stateRef.current.onChange(Plain__default.default.serialize(linkUrl));
      }
    }, [linkUrl, prevLinkUrl]);
    const onUrlChange = React__namespace.useCallback(({ value: value2 }) => {
      setLinkUrl(value2);
    }, []);
    const onVariableSelect = (item, editor = editorRef.current) => {
      const precedingChar = getCharactersAroundCaret();
      const precedingDollar = precedingChar === "$";
      if (item.origin !== data.VariableOrigin.Template || item.value === data.DataLinkBuiltInVars.includeVars) {
        editor.insertText(`${precedingDollar ? "" : "$"}{${item.value}}`);
      } else {
        editor.insertText(`${precedingDollar ? "" : "$"}{${item.value}:queryparam}`);
      }
      setLinkUrl(editor.value);
      setShowingSuggestions(false);
      setSuggestionsIndex(0);
      stateRef.current.onChange(Plain__default.default.serialize(editor.value));
    };
    const getCharactersAroundCaret = () => {
      const input = document.getElementById("data-link-input");
      let precedingChar = "", sel, range;
      if (window.getSelection) {
        sel = window.getSelection();
        if (sel && sel.rangeCount > 0) {
          range = sel.getRangeAt(0).cloneRange();
          range.collapse(true);
          range.setStart(input, 0);
          precedingChar = range.toString().slice(-1);
        }
      }
      return precedingChar;
    };
    return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.wrapperOverrides, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: "slate-query-field__wrapper", children: /* @__PURE__ */ jsxRuntime.jsxs("div", { id: "data-link-input", className: "slate-query-field", children: [
      showingSuggestions && /* @__PURE__ */ jsxRuntime.jsx(Portal$1, { children: /* @__PURE__ */ jsxRuntime.jsx("div", { ref: refs.setFloating, style: floatingStyles, children: /* @__PURE__ */ jsxRuntime.jsx(
        ScrollContainer,
        {
          maxHeight: "300px",
          ref: scrollRef,
          onScroll: (event) => setScrollTop(event.currentTarget.scrollTop),
          children: /* @__PURE__ */ jsxRuntime.jsx(
            DataLinkSuggestions,
            {
              activeRef,
              suggestions: stateRef.current.suggestions,
              onSuggestionSelect: onVariableSelect,
              onClose: () => setShowingSuggestions(false),
              activeIndex: suggestionsIndex
            }
          )
        }
      ) }) }),
      /* @__PURE__ */ jsxRuntime.jsx(
        slateReact.Editor,
        {
          schema: SCHEMA,
          ref: editorRef,
          placeholder,
          value: stateRef.current.linkUrl,
          onChange: onUrlChange,
          onKeyDown: (event, _editor, next) => onKeyDown(event, next),
          plugins,
          className: css.cx(
            styles.editor,
            styles.input,
            css.css({
              padding: "3px 8px"
            })
          )
        }
      )
    ] }) }) });
  }
);
DataLinkInput.displayName = "DataLinkInput";
function getElementPosition(suggestionElement, activeIndex) {
  var _a;
  return ((_a = suggestionElement == null ? void 0 : suggestionElement.clientHeight) != null ? _a : 0) * activeIndex;
}

const getStyles$j = (theme) => ({
  listItem: css.css({
    marginBottom: theme.spacing()
  }),
  infoText: css.css({
    paddingBottom: theme.spacing(2),
    marginLeft: "66px",
    color: theme.colors.text.secondary
  })
});
const DataLinkEditor = React.memo(
  ({ index, value, onChange, suggestions, isLast, showOneClick = false }) => {
    const styles = useStyles2(getStyles$j);
    const onUrlChange = (url, callback) => {
      onChange(index, { ...value, url }, callback);
    };
    const onTitleChange = (event) => {
      onChange(index, { ...value, title: event.target.value });
    };
    const onOpenInNewTabChanged = () => {
      onChange(index, { ...value, targetBlank: !value.targetBlank });
    };
    const onOneClickChanged = () => {
      onChange(index, { ...value, oneClick: !value.oneClick });
    };
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.listItem, children: [
      /* @__PURE__ */ jsxRuntime.jsx(Field, { label: t("grafana-ui.data-link-editor.title-label", "Title"), children: /* @__PURE__ */ jsxRuntime.jsx(
        Input,
        {
          value: value.title,
          onChange: onTitleChange,
          placeholder: t("grafana-ui.data-link-editor.title-placeholder", "Show details")
        }
      ) }),
      /* @__PURE__ */ jsxRuntime.jsx(Field, { label: t("grafana-ui.data-link-editor.url-label", "URL"), children: /* @__PURE__ */ jsxRuntime.jsx(DataLinkInput, { value: value.url, onChange: onUrlChange, suggestions }) }),
      /* @__PURE__ */ jsxRuntime.jsx(Field, { label: t("grafana-ui.data-link-editor.new-tab-label", "Open in new tab"), children: /* @__PURE__ */ jsxRuntime.jsx(Switch, { value: value.targetBlank || false, onChange: onOpenInNewTabChanged }) }),
      showOneClick && /* @__PURE__ */ jsxRuntime.jsx(
        Field,
        {
          label: t("grafana-ui.data-link-inline-editor.one-click", "One click"),
          description: t(
            "grafana-ui.data-link-editor-modal.one-click-description",
            "Only one link can have one click enabled at a time"
          ),
          children: /* @__PURE__ */ jsxRuntime.jsx(Switch, { value: value.oneClick || false, onChange: onOneClickChanged })
        }
      ),
      isLast && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.infoText, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.data-link-editor.info", children: "With data links you can reference data variables like series name, labels and values. Type CMD+Space, CTRL+Space, or $ to open variable suggestions." }) })
    ] });
  }
);
DataLinkEditor.displayName = "DataLinkEditor";

const BadgeComponent = React__namespace.memo(({ icon, color, text, tooltip, className, ...otherProps }) => {
  const styles = useStyles2(getStyles$i, color);
  const badge = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: css.cx(styles.wrapper, className), ...otherProps, children: [
    icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, size: "sm" }),
    text
  ] });
  return tooltip ? /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { content: tooltip, placement: "auto", children: badge }) : badge;
});
BadgeComponent.displayName = "Badge";
const BadgeSkeleton = ({ rootProps }) => {
  const styles = useStyles2(getSkeletonStyles);
  return /* @__PURE__ */ jsxRuntime.jsx(Skeleton__default.default, { width: 60, height: 22, containerClassName: styles.container, ...rootProps });
};
const Badge = attachSkeleton(BadgeComponent, BadgeSkeleton);
const getSkeletonStyles = () => ({
  container: css.css({
    lineHeight: 1
  })
});
const getStyles$i = (theme, color) => {
  let sourceColor = theme.visualization.getColorByName(color);
  let borderColor = "";
  let bgColor = "";
  let textColor = "";
  if (theme.isDark) {
    bgColor = tinycolor__default.default(sourceColor).setAlpha(0.15).toString();
    borderColor = tinycolor__default.default(sourceColor).setAlpha(0.25).toString();
    textColor = tinycolor__default.default(sourceColor).lighten(15).toString();
  } else {
    bgColor = tinycolor__default.default(sourceColor).setAlpha(0.15).toString();
    borderColor = tinycolor__default.default(sourceColor).setAlpha(0.25).toString();
    textColor = tinycolor__default.default(sourceColor).darken(20).toString();
  }
  return {
    wrapper: css.css({
      display: "inline-flex",
      padding: "1px 4px",
      borderRadius: theme.shape.radius.default,
      background: bgColor,
      border: `1px solid ${borderColor}`,
      color: textColor,
      fontWeight: theme.typography.fontWeightRegular,
      gap: theme.spacing(0.5),
      fontSize: theme.typography.bodySmall.fontSize,
      lineHeight: theme.typography.bodySmall.lineHeight,
      alignItems: "center"
    })
  };
};

const InfoBox = React__namespace.memo(
  React__namespace.forwardRef(
    ({ title, className, children, branded, url, urlTitle, onDismiss, severity = "info", ...otherProps }, ref) => {
      const styles = useStyles2(getStyles$h);
      return (
        // component is deprecated so no point fixing this
        // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
        /* @__PURE__ */ jsxRuntime.jsxs(Alert, { severity, className, ...otherProps, ref, title, children: [
          /* @__PURE__ */ jsxRuntime.jsx("div", { children }),
          url && /* @__PURE__ */ jsxRuntime.jsxs("a", { href: url, className: css.cx("external-link", styles.docsLink), target: "_blank", rel: "noreferrer", children: [
            /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "book" }),
            " ",
            urlTitle || "Read more"
          ] })
        ] })
      );
    }
  )
);
InfoBox.displayName = "InfoBox";
const getStyles$h = (theme) => ({
  docsLink: css.css({
    display: "inline-block",
    marginTop: theme.spacing(2)
  })
});

const FeatureBadge = ({ featureState, tooltip }) => {
  const display = getPanelStateBadgeDisplayModel(featureState);
  return /* @__PURE__ */ jsxRuntime.jsx(Badge, { text: display.text, color: display.color, icon: display.icon, tooltip });
};
function getPanelStateBadgeDisplayModel(featureState) {
  switch (featureState) {
    case data.FeatureState.alpha:
      return {
        text: "Alpha",
        icon: "exclamation-triangle",
        color: "orange"
      };
    case data.FeatureState.beta:
      return {
        text: "Beta",
        icon: "rocket",
        color: "blue"
      };
    case data.FeatureState.experimental:
      return {
        text: t("grafana-ui.feature-badge.experimental", "Experimental"),
        icon: "exclamation-triangle",
        color: "orange"
      };
    case data.FeatureState.preview:
      return {
        text: t("grafana-ui.feature-badge.preview", "Preview"),
        icon: "rocket",
        color: "blue"
      };
    case data.FeatureState.privatePreview:
      return {
        text: t("grafana-ui.feature-badge.private-preview", "Private preview"),
        icon: "rocket",
        color: "blue"
      };
    case data.FeatureState.new:
      return {
        text: t("grafana-ui.feature-badge.new", "New!"),
        icon: "rocket",
        color: "blue"
      };
  }
}

const FeatureInfoBox = React.memo(
  React.forwardRef(({ title, featureState, ...otherProps }, ref) => {
    const styles = useStyles2(getFeatureInfoBoxStyles);
    const titleEl = featureState ? /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.badge, children: /* @__PURE__ */ jsxRuntime.jsx(FeatureBadge, { featureState }) }),
      /* @__PURE__ */ jsxRuntime.jsx("h3", { children: title })
    ] }) : /* @__PURE__ */ jsxRuntime.jsx("h3", { children: title });
    return /* @__PURE__ */ jsxRuntime.jsx(InfoBox, { branded: true, title: titleEl, urlTitle: "Read documentation", ref, ...otherProps });
  })
);
FeatureInfoBox.displayName = "FeatureInfoBox";
const getFeatureInfoBoxStyles = (theme) => {
  return {
    badge: css.css({
      marginBottom: theme.spacing(1)
    })
  };
};

function formatString(str) {
  return str.replace(/\\/g, "\\\\").replace(/"/g, '\\"');
}
function isObject(value2) {
  const type = typeof value2;
  return !!value2 && type === "object";
}
function getObjectName(object) {
  if (object === void 0) {
    return "";
  }
  if (object === null) {
    return "Object";
  }
  if (typeof object === "object" && !object.constructor) {
    return "Object";
  }
  const funcNameRegex = /function ([^(]*)/;
  const results = funcNameRegex.exec(object.constructor.toString());
  if (results && results.length > 1) {
    return results[1];
  } else {
    return "";
  }
}
function getType(object) {
  if (object === null) {
    return "null";
  }
  return typeof object;
}
function getValuePreview(object, value2) {
  const type = getType(object);
  if (type === "null" || type === "undefined") {
    return type;
  }
  if (type === "string") {
    value2 = '"' + formatString(value2) + '"';
  }
  if (type === "function") {
    return object.toString().replace(/[\r\n]/g, "").replace(/\{.*\}/, "") + "{\u2026}";
  }
  return value2;
}
function cssClass(className) {
  return `json-formatter-${className}`;
}
function createElement(type, className, content) {
  const el = document.createElement(type);
  if (className) {
    el.classList.add(cssClass(className));
  }
  if (content !== void 0) {
    if (content instanceof Node) {
      el.appendChild(content);
    } else {
      el.appendChild(document.createTextNode(String(content)));
    }
  }
  return el;
}

const DATE_STRING_REGEX = /(^\d{1,4}[\.|\\/|-]\d{1,2}[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;
const PARTIAL_DATE_REGEX = /\d{2}:\d{2}:\d{2} GMT-\d{4}/;
const JSON_DATE_REGEX = /\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/;
const MAX_ANIMATED_TOGGLE_ITEMS = 10;
const requestAnimationFrame = typeof window !== "undefined" && window.requestAnimationFrame || ((cb) => {
  cb();
  return 0;
});
const _defaultConfig = {
  animateOpen: true,
  animateClose: true
};
class JsonExplorer {
  /**
   * @param {object} json The JSON object you want to render. It has to be an
   * object or array. Do NOT pass raw JSON string.
   *
   * @param {number} [open=1] his number indicates up to how many levels the
   * rendered tree should expand. Set it to `0` to make the whole tree collapsed
   * or set it to `Infinity` to expand the tree deeply
   *
   * @param {object} [config=defaultConfig] -
   *  defaultConfig = {
   *   hoverPreviewEnabled: false,
   *   hoverPreviewArrayCount: 100,
   *   hoverPreviewFieldCount: 5
   * }
   *
   * Available configurations:
   *  #####Hover Preview
   * * `hoverPreviewEnabled`:  enable preview on hover
   * * `hoverPreviewArrayCount`: number of array items to show in preview Any
   *    array larger than this number will be shown as `Array[XXX]` where `XXX`
   *    is length of the array.
   * * `hoverPreviewFieldCount`: number of object properties to show for object
   *   preview. Any object with more properties that thin number will be
   *   truncated.
   *
   * @param {string} [key=undefined] The key that this object in its parent
   * context
   */
  constructor(json, open = 1, config = _defaultConfig, key) {
    this.json = json;
    this.open = open;
    this.config = config;
    this.key = key;
    // Hold the open state after the toggler is used
    this._isOpen = null;
    // A reference to the element that we render to
    this.element = null;
    this.skipChildren = false;
  }
  /*
   * is formatter open?
   */
  get isOpen() {
    if (this._isOpen !== null) {
      return this._isOpen;
    } else {
      return this.open > 0;
    }
  }
  /*
   * set open state (from toggler)
   */
  set isOpen(value) {
    this._isOpen = value;
  }
  /*
   * is this a date string?
   */
  get isDate() {
    return this.type === "string" && (DATE_STRING_REGEX.test(this.json) || JSON_DATE_REGEX.test(this.json) || PARTIAL_DATE_REGEX.test(this.json));
  }
  /*
   * is this a URL string?
   */
  get isUrl() {
    return this.type === "string" && this.json.indexOf("http") === 0;
  }
  /*
   * is this an array?
   */
  get isArray() {
    return Array.isArray(this.json);
  }
  /*
   * is this an object?
   * Note: In this context arrays are object as well
   */
  get isObject() {
    return isObject(this.json);
  }
  /*
   * is this an empty object with no properties?
   */
  get isEmptyObject() {
    return !this.keys.length && !this.isArray;
  }
  /*
   * is this an empty object or array?
   */
  get isEmpty() {
    return this.isEmptyObject || this.keys && !this.keys.length && this.isArray;
  }
  /*
   * did we receive a key argument?
   * This means that the formatter was called as a sub formatter of a parent formatter
   */
  get hasKey() {
    return typeof this.key !== "undefined";
  }
  /*
   * if this is an object, get constructor function name
   */
  get constructorName() {
    return getObjectName(this.json);
  }
  /*
   * get type of this value
   * Possible values: all JavaScript primitive types plus "array" and "null"
   */
  get type() {
    return getType(this.json);
  }
  /*
   * get object keys
   * If there is an empty key we pad it wit quotes to make it visible
   */
  get keys() {
    if (this.isObject) {
      return Object.keys(this.json).map((key) => key ? key : '""');
    } else {
      return [];
    }
  }
  /**
   * Toggles `isOpen` state
   *
   */
  toggleOpen() {
    this.isOpen = !this.isOpen;
    if (this.element) {
      if (this.isOpen) {
        this.appendChildren(this.config.animateOpen);
      } else {
        this.removeChildren(this.config.animateClose);
      }
      this.element.classList.toggle(cssClass("open"));
    }
  }
  /**
   * Open all children up to a certain depth.
   * Allows actions such as expand all/collapse all
   *
   */
  openAtDepth(depth = 1) {
    if (depth < 0) {
      return;
    }
    this.open = depth;
    this.isOpen = depth !== 0;
    if (this.element) {
      this.removeChildren(false);
      if (depth === 0) {
        this.element.classList.remove(cssClass("open"));
      } else {
        this.appendChildren(this.config.animateOpen);
        this.element.classList.add(cssClass("open"));
      }
    }
  }
  isNumberArray() {
    return this.json.length > 0 && this.json.length < 4 && (lodash.isNumber(this.json[0]) || lodash.isNumber(this.json[1]));
  }
  renderArray() {
    const arrayWrapperSpan = createElement("span");
    arrayWrapperSpan.appendChild(createElement("span", "bracket", "["));
    if (this.isNumberArray()) {
      this.json.forEach((val, index) => {
        if (index > 0) {
          arrayWrapperSpan.appendChild(createElement("span", "array-comma", ","));
        }
        arrayWrapperSpan.appendChild(createElement("span", "number", val));
      });
      this.skipChildren = true;
    } else {
      arrayWrapperSpan.appendChild(createElement("span", "number", this.json.length));
    }
    arrayWrapperSpan.appendChild(createElement("span", "bracket", "]"));
    return arrayWrapperSpan;
  }
  /**
   * Renders an HTML element and installs event listeners
   *
   * @returns {HTMLDivElement}
   */
  render(skipRoot = false) {
    this.element = createElement("div", "row");
    const togglerLink = createElement("a", "toggler-link");
    const togglerIcon = createElement("span", "toggler");
    if (this.isObject) {
      togglerLink.appendChild(togglerIcon);
    }
    if (this.hasKey) {
      togglerLink.appendChild(createElement("span", "key", `${this.key}:`));
    }
    if (this.isObject) {
      const value = createElement("span", "value");
      const objectWrapperSpan = createElement("span");
      const constructorName = createElement("span", "constructor-name", this.constructorName);
      objectWrapperSpan.appendChild(constructorName);
      if (this.isArray) {
        const arrayWrapperSpan = this.renderArray();
        objectWrapperSpan.appendChild(arrayWrapperSpan);
      }
      value.appendChild(objectWrapperSpan);
      togglerLink.appendChild(value);
    } else {
      const value = this.isUrl ? createElement("a") : createElement("span");
      value.classList.add(cssClass(this.type));
      if (this.isDate) {
        value.classList.add(cssClass("date"));
      }
      if (this.isUrl) {
        value.classList.add(cssClass("url"));
        value.setAttribute("href", this.json);
      }
      const valuePreview = getValuePreview(this.json, this.json);
      value.appendChild(document.createTextNode(valuePreview));
      togglerLink.appendChild(value);
    }
    const children = createElement("div", "children");
    if (this.isObject) {
      children.classList.add(cssClass("object"));
    }
    if (this.isArray) {
      children.classList.add(cssClass("array"));
    }
    if (this.isEmpty) {
      children.classList.add(cssClass("empty"));
    }
    if (this.config && this.config.theme) {
      this.element.classList.add(cssClass(this.config.theme));
    }
    if (this.isOpen) {
      this.element.classList.add(cssClass("open"));
    }
    if (!skipRoot) {
      this.element.appendChild(togglerLink);
    }
    if (!this.skipChildren) {
      this.element.appendChild(children);
    } else {
      togglerLink.removeChild(togglerIcon);
    }
    if (this.isObject && this.isOpen) {
      this.appendChildren();
    }
    if (this.isObject) {
      togglerLink.addEventListener("click", this.toggleOpen.bind(this));
    }
    return this.element;
  }
  /**
   * Appends all the children to children element
   * Animated option is used when user triggers this via a click
   */
  appendChildren(animated = false) {
    const children = this.element && this.element.querySelector(`div.${cssClass("children")}`);
    if (!children || this.isEmpty) {
      return;
    }
    if (animated) {
      let index = 0;
      const addAChild = () => {
        const key = this.keys[index];
        const formatter = new JsonExplorer(this.json[key], this.open - 1, this.config, key);
        children.appendChild(formatter.render());
        index += 1;
        if (index < this.keys.length) {
          if (index > MAX_ANIMATED_TOGGLE_ITEMS) {
            addAChild();
          } else {
            requestAnimationFrame(addAChild);
          }
        }
      };
      requestAnimationFrame(addAChild);
    } else {
      this.keys.forEach((key) => {
        const formatter = new JsonExplorer(this.json[key], this.open - 1, this.config, key);
        children.appendChild(formatter.render());
      });
    }
  }
  /**
   * Removes all the children from children element
   * Animated option is used when user triggers this via a click
   */
  removeChildren(animated = false) {
    const childrenElement = this.element && this.element.querySelector(`div.${cssClass("children")}`);
    if (animated) {
      let childrenRemoved = 0;
      const removeAChild = () => {
        if (childrenElement && childrenElement.children.length) {
          childrenElement.removeChild(childrenElement.children[0]);
          childrenRemoved += 1;
          if (childrenRemoved > MAX_ANIMATED_TOGGLE_ITEMS) {
            removeAChild();
          } else {
            requestAnimationFrame(removeAChild);
          }
        }
      };
      requestAnimationFrame(removeAChild);
    } else {
      if (childrenElement) {
        childrenElement.innerHTML = "";
      }
    }
  }
}

class JSONFormatter extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.wrapperRef = React.createRef();
    this.renderJson = () => {
      const { json, config, open, onDidRender } = this.props;
      const wrapperEl = this.wrapperRef.current;
      const formatter = new JsonExplorer(json, open, config);
      const hasChildren = wrapperEl.hasChildNodes();
      if (hasChildren) {
        wrapperEl.replaceChild(formatter.render(), wrapperEl.lastChild);
      } else {
        wrapperEl.appendChild(formatter.render());
      }
      if (onDidRender) {
        onDidRender(formatter.json);
      }
    };
  }
  componentDidMount() {
    this.renderJson();
  }
  componentDidUpdate() {
    this.renderJson();
  }
  render() {
    const { className } = this.props;
    return /* @__PURE__ */ jsxRuntime.jsx("div", { className, ref: this.wrapperRef });
  }
}
JSONFormatter.defaultProps = {
  open: 3,
  config: {
    animateOpen: true
  }
};

class ErrorBoundary extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      error: null,
      errorInfo: null
    };
  }
  componentDidCatch(error, errorInfo) {
    var _a, _b, _c;
    const logger = (_c = this.props.errorLogger) != null ? _c : (_b = (_a = faroWebSdk.faro) == null ? void 0 : _a.api) == null ? void 0 : _b.pushError;
    if (logger) {
      logger(error);
    }
    this.setState({ error, errorInfo });
    if (this.props.onError) {
      this.props.onError(error);
    }
  }
  componentDidUpdate(prevProps) {
    const { dependencies, onRecover } = this.props;
    if (this.state.error) {
      if (dependencies && prevProps.dependencies) {
        for (let i = 0; i < dependencies.length; i++) {
          if (dependencies[i] !== prevProps.dependencies[i]) {
            this.setState({ error: null, errorInfo: null });
            if (onRecover) {
              onRecover();
            }
            break;
          }
        }
      }
    }
  }
  render() {
    const { children } = this.props;
    const { error, errorInfo } = this.state;
    return children({
      error,
      errorInfo
    });
  }
}
class ErrorBoundaryAlert extends React.PureComponent {
  render() {
    const { title, children, style, dependencies, errorLogger } = this.props;
    return /* @__PURE__ */ jsxRuntime.jsx(ErrorBoundary, { dependencies, errorLogger, children: ({ error, errorInfo }) => {
      if (!errorInfo) {
        return children;
      }
      if (style === "alertbox") {
        return /* @__PURE__ */ jsxRuntime.jsx(Alert, { title: title || "", children: /* @__PURE__ */ jsxRuntime.jsxs("details", { style: { whiteSpace: "pre-wrap" }, children: [
          error && error.toString(),
          /* @__PURE__ */ jsxRuntime.jsx("br", {}),
          errorInfo.componentStack
        ] }) });
      }
      return /* @__PURE__ */ jsxRuntime.jsx(ErrorWithStack, { title: title || "", error, errorInfo });
    } });
  }
}
ErrorBoundaryAlert.defaultProps = {
  title: "An unexpected error happened",
  style: "alertbox"
};

const RADIO_GROUP_PADDING = 2;
const RadioButton = React__namespace.forwardRef(
  ({
    children,
    active = false,
    disabled = false,
    size = "md",
    onChange,
    onClick,
    id,
    name = void 0,
    description,
    fullWidth,
    "aria-label": ariaLabel
  }, ref) => {
    const styles = useStyles2(getRadioButtonStyles, size, fullWidth);
    const inputRadioButton = /* @__PURE__ */ jsxRuntime.jsx(
      "input",
      {
        type: "radio",
        className: styles.radio,
        onChange,
        onClick,
        disabled,
        id,
        checked: active,
        name,
        "aria-label": ariaLabel,
        ref
      }
    );
    return description ? /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.radioOption, "data-testid": e2eSelectors.selectors.components.RadioButton.container, children: [
      /* @__PURE__ */ jsxRuntime.jsx(Tooltip, { content: description, placement: "bottom", children: inputRadioButton }),
      /* @__PURE__ */ jsxRuntime.jsx("label", { className: styles.radioLabel, htmlFor: id, title: description || ariaLabel, children })
    ] }) : /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.radioOption, "data-testid": e2eSelectors.selectors.components.RadioButton.container, children: [
      inputRadioButton,
      /* @__PURE__ */ jsxRuntime.jsx("label", { className: styles.radioLabel, htmlFor: id, title: description || ariaLabel, children })
    ] });
  }
);
RadioButton.displayName = "RadioButton";
const getRadioButtonStyles = (theme, size, fullWidth) => {
  const { fontSize, height, padding } = getPropertiesForButtonSize(size, theme);
  const textColor = theme.colors.text.secondary;
  const textColorHover = theme.colors.text.primary;
  const labelHeight = height * theme.spacing.gridSize - 4 - 2;
  return {
    radioOption: css.css({
      display: "flex",
      justifyContent: "space-between",
      position: "relative",
      flex: fullWidth ? `1 0 0` : "none",
      textAlign: "center"
    }),
    radio: css.css({
      position: "absolute",
      opacity: 0,
      zIndex: 2,
      width: "100% !important",
      height: "100%",
      cursor: "pointer",
      "&:checked + label": {
        color: theme.colors.text.primary,
        fontWeight: theme.typography.fontWeightMedium,
        background: theme.colors.action.selected,
        zIndex: 1
      },
      "&:focus + label, &:focus-visible + label": getFocusStyles(theme),
      "&:focus:not(:focus-visible) + label": getMouseFocusStyles(),
      "&:disabled + label": {
        color: theme.colors.text.disabled,
        cursor: "not-allowed"
      }
    }),
    radioLabel: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      fontSize,
      height: `${labelHeight}px`,
      // Deduct border from line-height for perfect vertical centering on windows and linux
      lineHeight: `${labelHeight}px`,
      color: textColor,
      padding: theme.spacing(0, padding),
      borderRadius: getInternalRadius(theme, RADIO_GROUP_PADDING),
      background: theme.colors.background.primary,
      cursor: "pointer",
      userSelect: "none",
      whiteSpace: "nowrap",
      flexGrow: 1,
      "&:hover": {
        color: textColorHover
      }
    })
  };
};

const FieldNameByRegexMatcherEditor = React.memo((props) => {
  const { options, onChange } = props;
  const onBlur = React.useCallback(
    (e) => {
      return onChange(e.target.value);
    },
    [onChange]
  );
  return /* @__PURE__ */ jsxRuntime.jsx(
    Input,
    {
      placeholder: t("grafana-ui.field-name-by-regex-matcher.input-placeholder", "Enter regular expression"),
      defaultValue: options,
      onBlur
    }
  );
});
FieldNameByRegexMatcherEditor.displayName = "FieldNameByRegexMatcherEditor";
const fieldNameByRegexMatcherItem = {
  id: data.FieldMatcherID.byRegexp,
  component: FieldNameByRegexMatcherEditor,
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byRegexp),
  name: "Fields with name matching regex",
  description: "Set properties for fields with names matching a regex",
  optionsToLabel: (options) => options
};

function frameHasName(name, names) {
  if (!name) {
    return false;
  }
  return names.display.has(name) || names.raw.has(name);
}
function getFrameFieldsDisplayNames(data$1, filter) {
  const names = {
    display: /* @__PURE__ */ new Set(),
    raw: /* @__PURE__ */ new Set(),
    fields: /* @__PURE__ */ new Map()
  };
  for (const frame of data$1) {
    for (const field of frame.fields) {
      const disp = data.getFieldDisplayName(field, frame, data$1);
      names.display.add(disp);
      names.fields.set(disp, field);
      if (field.name && disp !== field.name) {
        names.raw.add(field.name);
        names.fields.set(field.name, field);
      }
    }
  }
  return names;
}
function useFieldDisplayNames(data, filter) {
  return React.useMemo(() => {
    return getFrameFieldsDisplayNames(data);
  }, [data, filter]);
}
function useSelectOptions$1(displayNames, currentName, firstItem, fieldType, baseNameMode) {
  return React.useMemo(() => {
    let found = false;
    const options = [];
    if (baseNameMode === data.FieldNamePickerBaseNameMode.OnlyBaseNames) {
      for (const name of displayNames.raw) {
        if (!found && name === currentName) {
          found = true;
        }
        options.push({
          value: name,
          label: `${name} (base field name)`
        });
      }
    } else {
      for (const name of displayNames.display) {
        if (!found && name === currentName) {
          found = true;
        }
        const field = displayNames.fields.get(name);
        {
          options.push({
            value: name,
            label: name,
            icon: field ? getFieldTypeIcon(field) : void 0
          });
        }
      }
      if (baseNameMode !== data.FieldNamePickerBaseNameMode.ExcludeBaseNames) {
        for (const name of displayNames.raw) {
          if (!displayNames.display.has(name)) {
            if (!found && name === currentName) {
              found = true;
            }
            options.push({
              value: name,
              label: `${name} (base field name)`
            });
          }
        }
      }
    }
    if (currentName && !found) {
      options.push({
        value: currentName,
        label: `${currentName} (not found)`
      });
    }
    return options;
  }, [displayNames, currentName, firstItem, fieldType, baseNameMode]);
}

const FieldNameMatcherEditor = React.memo((props) => {
  const { data, options, onChange: onChangeFromProps, id } = props;
  const names = useFieldDisplayNames(data);
  const selectOptions = useSelectOptions$1(names, options);
  const onChange = React.useCallback(
    (selection) => {
      if (!frameHasName(selection.value, names)) {
        return;
      }
      return onChangeFromProps(selection.value);
    },
    [names, onChangeFromProps]
  );
  const selectedOption = selectOptions.find((v) => v.value === options);
  return /* @__PURE__ */ jsxRuntime.jsx(Select, { value: selectedOption, options: selectOptions, onChange, inputId: id });
});
FieldNameMatcherEditor.displayName = "FieldNameMatcherEditor";
const fieldNameMatcherItem = {
  id: data.FieldMatcherID.byName,
  component: FieldNameMatcherEditor,
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byName),
  name: "Fields with name",
  description: "Set properties for a specific field",
  optionsToLabel: (options) => options
};

const FieldNamesMatcherEditor = React.memo((props) => {
  var _a;
  const { data, options, onChange: onChangeFromProps } = props;
  const { readOnly, prefix } = options;
  const names = useFieldDisplayNames(data);
  const selectOptions = useSelectOptions$1(names, void 0);
  const onChange = React.useCallback(
    (selections) => {
      if (!Array.isArray(selections)) {
        return;
      }
      return onChangeFromProps({
        ...options,
        names: selections.reduce((all, current) => {
          if (!frameHasName(current.value, names)) {
            return all;
          }
          all.push(current.value);
          return all;
        }, [])
      });
    },
    [names, onChangeFromProps, options]
  );
  if (readOnly) {
    const displayNames = ((_a = options.names) != null ? _a : []).join(", ");
    return /* @__PURE__ */ jsxRuntime.jsx(Input, { value: displayNames, readOnly: true, disabled: true, prefix });
  }
  return /* @__PURE__ */ jsxRuntime.jsx(MultiSelect, { value: options.names, options: selectOptions, onChange });
});
FieldNamesMatcherEditor.displayName = "FieldNameMatcherEditor";
const fieldNamesMatcherItem = {
  id: data.FieldMatcherID.byNames,
  component: FieldNamesMatcherEditor,
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byNames),
  name: "Fields with name",
  description: "Set properties for a specific field",
  optionsToLabel: (options) => {
    var _a;
    return ((_a = options.names) != null ? _a : []).join(", ");
  },
  excludeFromPicker: true
};

const FieldTypeMatcherEditor = React.memo((props) => {
  const { data, options, onChange: onChangeFromProps, id } = props;
  const counts = useFieldCounts(data);
  const selectOptions = useSelectOptions(counts, options);
  const onChange = React.useCallback(
    (selection) => {
      return onChangeFromProps(selection.value);
    },
    [onChangeFromProps]
  );
  const selectedOption = selectOptions.find((v) => v.value === options);
  return /* @__PURE__ */ jsxRuntime.jsx(Select, { inputId: id, value: selectedOption, options: selectOptions, onChange });
});
FieldTypeMatcherEditor.displayName = "FieldTypeMatcherEditor";
const allFieldTypeIconOptions = [
  { value: data.FieldType.number, label: "Number", icon: getFieldTypeIconName(data.FieldType.number) },
  { value: data.FieldType.string, label: "String", icon: getFieldTypeIconName(data.FieldType.string) },
  { value: data.FieldType.time, label: "Time", icon: getFieldTypeIconName(data.FieldType.time) },
  { value: data.FieldType.boolean, label: "Boolean", icon: getFieldTypeIconName(data.FieldType.boolean) },
  { value: data.FieldType.trace, label: "Traces", icon: getFieldTypeIconName(data.FieldType.trace) },
  { value: data.FieldType.enum, label: "Enum", icon: getFieldTypeIconName(data.FieldType.enum) },
  { value: data.FieldType.other, label: "Other", icon: getFieldTypeIconName(data.FieldType.other) }
];
const useFieldCounts = (data$1) => {
  return React.useMemo(() => {
    const counts = /* @__PURE__ */ new Map();
    for (const t of allFieldTypeIconOptions) {
      counts.set(t.value, 0);
    }
    for (const frame of data$1) {
      for (const field of frame.fields) {
        const key = field.type || data.FieldType.other;
        let v = counts.get(key);
        if (!v) {
          v = 0;
        }
        counts.set(key, v + 1);
      }
    }
    return counts;
  }, [data$1]);
};
const useSelectOptions = (counts, opt) => {
  return React.useMemo(() => {
    let found = false;
    const options = [];
    for (const t of allFieldTypeIconOptions) {
      const count = counts.get(t.value);
      const match = opt === t.value;
      if (count || match) {
        options.push({
          ...t,
          label: `${t.label} (${counts.get(t.value)})`
        });
      }
      if (match) {
        found = true;
      }
    }
    if (opt && !found) {
      options.push({
        value: opt,
        label: `${opt} (No matches)`
      });
    }
    return options;
  }, [counts, opt]);
};
const fieldTypeMatcherItem = {
  id: data.FieldMatcherID.byType,
  component: FieldTypeMatcherEditor,
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byType),
  name: "Fields with type",
  description: "Set properties for fields of a specific type (number, string, boolean)",
  optionsToLabel: (options) => options
};

const comparisonOperationOptions = [
  { label: "==", value: schema.ComparisonOperation.EQ },
  { label: "!=", value: schema.ComparisonOperation.NEQ },
  { label: ">", value: schema.ComparisonOperation.GT },
  { label: ">=", value: schema.ComparisonOperation.GTE },
  { label: "<", value: schema.ComparisonOperation.LT },
  { label: "<=", value: schema.ComparisonOperation.LTE }
];
function isBooleanReducer(r) {
  return r === data.ReducerID.allIsNull || r === data.ReducerID.allIsZero;
}
const FieldValueMatcherEditor = ({ options, onChange }) => {
  const styles = useStyles2(getStyles$g);
  const reducer = React.useMemo(() => data.fieldReducers.selectOptions([options == null ? void 0 : options.reducer]), [options == null ? void 0 : options.reducer]);
  const onSetReducer = React.useCallback(
    (selection) => {
      return onChange({ ...options, reducer: selection.value });
    },
    [options, onChange]
  );
  const onChangeOp = React.useCallback(
    (v) => {
      return onChange({ ...options, op: v.value });
    },
    [options, onChange]
  );
  const onChangeValue = React.useCallback(
    (e) => {
      const value = e.currentTarget.valueAsNumber;
      return onChange({ ...options, value });
    },
    [options, onChange]
  );
  const opts = options != null ? options : {};
  const isBool = isBooleanReducer(opts.reducer);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.spot, children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      Select,
      {
        value: reducer.current,
        options: reducer.options,
        onChange: onSetReducer,
        placeholder: t("grafana-ui.field-value-matcher.select-field-placeholder", "Select field reducer")
      }
    ),
    opts.reducer && !isBool && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        Select,
        {
          value: comparisonOperationOptions.find((v) => v.value === opts.op),
          options: comparisonOperationOptions,
          onChange: onChangeOp,
          "aria-label": t("grafana-ui.field-value-matcher.operator-label", "Comparison operator"),
          width: 19
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(Input, { type: "number", value: opts.value, onChange: onChangeValue })
    ] })
  ] });
};
const getStyles$g = (theme) => {
  return {
    spot: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "center",
      alignContent: "flex-end",
      gap: "4px"
    })
  };
};
const fieldValueMatcherItem = {
  id: data.FieldMatcherID.byValue,
  component: FieldValueMatcherEditor,
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byValue),
  name: "Fields with values",
  description: "Set properties for fields with reducer condition",
  optionsToLabel: (options) => `${options == null ? void 0 : options.reducer} ${options == null ? void 0 : options.op} ${options == null ? void 0 : options.value}`
};

const recoverRefIdMissing = (newRefIds, oldRefIds, previousValue) => {
  if (!previousValue) {
    return;
  }
  let changedTo = newRefIds.find((refId) => {
    return !oldRefIds.some((refId2) => {
      return refId === refId2;
    });
  });
  if (changedTo) {
    return changedTo;
  }
  return;
};
function RefIDPicker({ value, data, onChange, placeholder }) {
  const listOfRefIds = React.useMemo(() => getListOfQueryRefIds(data), [data]);
  const [priorSelectionState, updatePriorSelectionState] = React.useState({
    refIds: [],
    value: void 0
  });
  const currentValue = React.useMemo(() => {
    var _a;
    return (_a = listOfRefIds.find((refId) => refId.value === value)) != null ? _a : recoverRefIdMissing(listOfRefIds, priorSelectionState.refIds, priorSelectionState.value);
  }, [value, listOfRefIds, priorSelectionState]);
  const onFilterChange = React.useCallback(
    (v) => {
      onChange(v == null ? void 0 : v.value);
    },
    [onChange]
  );
  if (listOfRefIds !== priorSelectionState.refIds || (currentValue == null ? void 0 : currentValue.value) !== priorSelectionState.value) {
    updatePriorSelectionState({
      refIds: listOfRefIds,
      value: currentValue == null ? void 0 : currentValue.value
    });
  }
  return /* @__PURE__ */ jsxRuntime.jsx(
    Select,
    {
      options: listOfRefIds,
      onChange: onFilterChange,
      isClearable: true,
      placeholder: placeholder != null ? placeholder : "Select query refId",
      value: currentValue
    }
  );
}
function getListOfQueryRefIds(data) {
  var _a, _b;
  const queries = /* @__PURE__ */ new Map();
  for (const frame of data) {
    const refId = (_a = frame.refId) != null ? _a : "";
    const frames = (_b = queries.get(refId)) != null ? _b : [];
    if (frames.length === 0) {
      queries.set(refId, frames);
    }
    frames.push(frame);
  }
  const values = [];
  for (const [refId, frames] of queries.entries()) {
    values.push({
      value: refId,
      label: `Query: ${refId != null ? refId : "(missing refId)"}`,
      description: getFramesDescription(frames)
    });
  }
  return values;
}
function getFramesDescription(frames) {
  return `Frames (${frames.length}):
    ${frames.slice(0, Math.min(3, frames.length)).map((x) => data.getFrameDisplayName(x)).join(", ")} ${frames.length > 3 ? "..." : ""}`;
}
const fieldsByFrameRefIdItem = {
  id: data.FieldMatcherID.byFrameRefID,
  component: (props) => {
    return /* @__PURE__ */ jsxRuntime.jsx(RefIDPicker, { value: props.options, data: props.data, onChange: props.onChange });
  },
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byFrameRefID),
  name: "Fields returned by query",
  description: "Set properties for fields from a specific query",
  optionsToLabel: (options) => options
};

new data.Registry(() => [
  fieldNameMatcherItem,
  fieldNameByRegexMatcherItem,
  fieldTypeMatcherItem,
  fieldsByFrameRefIdItem,
  fieldNamesMatcherItem,
  fieldValueMatcherItem
]);

const svgSizes = {
  h1: "xl",
  h2: "xl",
  h3: "lg",
  h4: "lg",
  h5: "md",
  h6: "md",
  body: "md",
  bodySmall: "xs"
};
const TextLink = React.forwardRef(
  ({ href, color = "link", external = false, inline = true, variant = "body", weight, icon, children, ...rest }, ref) => {
    const validUrl = data.textUtil.sanitizeUrl(href != null ? href : "");
    const theme = useTheme2();
    const styles = getLinkStyles(theme, inline, variant, weight, color);
    const externalIcon = icon || "external-link-alt";
    if (external) {
      return /* @__PURE__ */ jsxRuntime.jsxs("a", { href: validUrl, ref, ...rest, target: "_blank", rel: "noreferrer", className: styles, children: [
        children,
        /* @__PURE__ */ jsxRuntime.jsx(Icon, { size: svgSizes[variant] || "md", name: externalIcon })
      ] });
    }
    const strippedUrl = data.locationUtil.stripBaseFromUrl(validUrl);
    return /* @__PURE__ */ jsxRuntime.jsxs(Link, { ref, href: strippedUrl, ...rest, className: styles, children: [
      children,
      icon && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: icon, size: svgSizes[variant] || "md" })
    ] });
  }
);
TextLink.displayName = "TextLink";
const getLinkStyles = (theme, inline, variant, weight, color) => {
  return css.css([
    variant && {
      ...theme.typography[variant]
    },
    weight && {
      fontWeight: customWeight(weight, theme)
    },
    color && {
      color: theme.colors.text[color]
    },
    {
      alignItems: "center",
      gap: "0.25em",
      display: "inline-flex",
      textDecoration: "none",
      "&:hover": {
        textDecoration: "underline",
        color: theme.colors.text.link
      }
    },
    inline && {
      textDecoration: "underline",
      "&:hover": {
        textDecoration: "none"
      }
    }
  ]);
};

const Grid = React.forwardRef((props, ref) => {
  const { alignItems, children, gap, rowGap, columnGap, columns, minColumnWidth, ...rest } = props;
  const styles = useStyles2(getGridStyles, gap, rowGap, columnGap, columns, minColumnWidth, alignItems);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { ref, ...rest, className: styles.grid, children });
});
Grid.displayName = "Grid";
const getGridStyles = (theme, gap, rowGap, columnGap, columns, minColumnWidth, alignItems) => {
  return {
    grid: css.css([
      { display: "grid" },
      getResponsiveStyle(theme, gap, (val) => ({
        gap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, rowGap, (val) => ({
        rowGap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, columnGap, (val) => ({
        columnGap: theme.spacing(val)
      })),
      minColumnWidth && getResponsiveStyle(theme, minColumnWidth, (val) => ({
        gridTemplateColumns: `repeat(auto-fill, minmax(${theme.spacing(val)}, 1fr))`
      })),
      columns && getResponsiveStyle(theme, columns, (val) => ({
        gridTemplateColumns: `repeat(${val}, 1fr)`
      })),
      getResponsiveStyle(theme, alignItems, (val) => ({
        alignItems: val
      }))
    ])
  };
};

React.forwardRef(
  ({ children, onRemove, disabled, ...rest }, ref) => {
    const styles = useStyles2(getValuePillStyles, disabled);
    const removeButtonLabel = t("grafana-ui.value-pill.remove-button", "Remove {{children}}", { children });
    return /* @__PURE__ */ jsxRuntime.jsxs("span", { className: styles.wrapper, ...rest, ref, children: [
      /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.text, children }),
      !disabled && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.separator }),
        /* @__PURE__ */ jsxRuntime.jsx(
          IconButton,
          {
            name: "times",
            size: "md",
            "aria-label": removeButtonLabel,
            onClick: (e) => {
              e.stopPropagation();
              onRemove();
            }
          }
        )
      ] })
    ] });
  }
);
const getValuePillStyles = (theme, disabled) => ({
  wrapper: css.css({
    display: "inline-flex",
    borderRadius: theme.shape.radius.default,
    color: theme.colors.text.primary,
    background: theme.colors.background.secondary,
    padding: theme.spacing(0.25),
    border: disabled ? `1px solid ${theme.colors.border.weak}` : "none",
    fontSize: theme.typography.bodySmall.fontSize,
    flexShrink: 0,
    minWidth: "50px",
    alignItems: "center",
    "&:first-child:has(+ div)": {
      flexShrink: 1
    }
  }),
  text: css.css({
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    padding: theme.spacing(0, 1, 0, 0.75)
  }),
  separator: css.css({
    background: theme.colors.border.weak,
    width: "2px",
    height: "100%",
    marginRight: theme.spacing(0.5)
  })
});

const Layout = ({
  children,
  orientation = 0 /* Horizontal */,
  spacing = "sm",
  justify = "flex-start",
  align = "normal",
  wrap = false,
  width = "100%",
  height = "100%",
  ...rest
}) => {
  const styles = useStyles2(getStyles$f, orientation, spacing, justify, align, wrap);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.layout, style: { width, height }, ...rest, children: React__namespace.Children.toArray(children).filter(Boolean).map((child, index) => {
    return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.childWrapper, children: child }, index);
  }) });
};
const HorizontalGroup = ({
  children,
  spacing,
  justify,
  align = "center",
  wrap,
  width,
  height
}) => /* @__PURE__ */ jsxRuntime.jsx(
  Layout,
  {
    spacing,
    justify,
    orientation: 0 /* Horizontal */,
    align,
    width,
    height,
    wrap,
    children
  }
);
const getStyles$f = (theme, orientation, spacing, justify, align, wrap) => {
  const finalSpacing = spacing !== "none" ? theme.spacing(spacingToNumber[spacing]) : 0;
  const marginCompensation = orientation === 0 /* Horizontal */ && !wrap || orientation === 1 /* Vertical */ ? 0 : `-${finalSpacing}`;
  const label = orientation === 1 /* Vertical */ ? "vertical-group" : "horizontal-group";
  return {
    layout: css.css({
      label,
      display: "flex",
      flexDirection: orientation === 1 /* Vertical */ ? "column" : "row",
      flexWrap: wrap ? "wrap" : "nowrap",
      justifyContent: justify,
      alignItems: align,
      height: "100%",
      maxWidth: "100%",
      // compensate for last row margin when wrapped, horizontal layout
      marginBottom: marginCompensation
    }),
    childWrapper: css.css({
      label: "layoutChildrenWrapper",
      marginBottom: orientation === 0 /* Horizontal */ && !wrap ? 0 : finalSpacing,
      marginRight: orientation === 0 /* Horizontal */ ? finalSpacing : 0,
      display: "flex",
      alignItems: align,
      "&:last-child": {
        marginBottom: orientation === 1 /* Vertical */ ? 0 : void 0,
        marginRight: orientation === 0 /* Horizontal */ ? 0 : void 0
      }
    })
  };
};
const spacingToNumber = {
  none: 0,
  xs: 0.5,
  sm: 1,
  md: 2,
  lg: 3
};

const regex = /^now$|^now(\-|\+)(\d{1,10})([wdhms])$/;
const isRelativeFormat = (format) => {
  return regex.test(format);
};

quickOptions.filter((o) => isRelativeFormat(o.from));

const CardContext = React__namespace.createContext(null);
const Heading = ({ children, className, "aria-label": ariaLabel }) => {
  const context = React.useContext(CardContext);
  const styles = useStyles2(getHeadingStyles);
  const { href, onClick, isSelected } = context != null ? context : {
    href: void 0,
    onClick: void 0,
    isSelected: void 0
  };
  const optionLabel = t("grafana-ui.card.option", "option");
  return /* @__PURE__ */ jsxRuntime.jsxs("h2", { className: css.cx(styles.heading, className), children: [
    href ? /* @__PURE__ */ jsxRuntime.jsx("a", { href, className: styles.linkHack, "aria-label": ariaLabel, onClick, children }) : onClick ? /* @__PURE__ */ jsxRuntime.jsx("button", { onClick, className: styles.linkHack, "aria-label": ariaLabel, type: "button", children }) : /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children }),
    isSelected !== void 0 && /* @__PURE__ */ jsxRuntime.jsx("input", { "aria-label": optionLabel, type: "radio", checked: isSelected, readOnly: true })
  ] });
};
Heading.displayName = "Heading";
const getHeadingStyles = (theme) => ({
  heading: css.css({
    gridArea: "Heading",
    justifySelf: "start",
    display: "flex",
    justifyContent: "space-between",
    alignItems: "center",
    width: "100%",
    marginBottom: 0,
    fontSize: theme.typography.size.md,
    letterSpacing: "inherit",
    lineHeight: theme.typography.body.lineHeight,
    color: theme.colors.text.primary,
    fontWeight: theme.typography.fontWeightMedium,
    "& input[readonly]": {
      cursor: "inherit"
    }
  }),
  linkHack: css.css({
    all: "unset",
    "&::after": {
      position: "absolute",
      content: '""',
      top: 0,
      bottom: 0,
      left: 0,
      right: 0,
      borderRadius: theme.shape.radius.default
    },
    "&:focus-visible": {
      outline: "none",
      outlineOffset: 0,
      boxShadow: "none",
      "&::after": {
        ...getFocusStyles(theme),
        zIndex: 1
      }
    }
  })
});
const Tags = ({ children, className }) => {
  const styles = useStyles2(getTagStyles);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.tagList, className), children });
};
Tags.displayName = "Tags";
const getTagStyles = (theme) => ({
  tagList: css.css({
    position: "relative",
    gridArea: "Tags",
    alignSelf: "center"
  })
});
const Description = ({ children, className }) => {
  const styles = useStyles2(getDescriptionStyles);
  const Element = typeof children === "string" ? "p" : "div";
  return /* @__PURE__ */ jsxRuntime.jsx(Element, { className: css.cx(styles.description, className), children });
};
Description.displayName = "Description";
const getDescriptionStyles = (theme) => ({
  description: css.css({
    width: "100%",
    gridArea: "Description",
    margin: theme.spacing(1, 0, 0),
    color: theme.colors.text.secondary,
    lineHeight: theme.typography.body.lineHeight
  })
});
const Figure = ({ children, align = "start", className }) => {
  const styles = useStyles2(getFigureStyles);
  return /* @__PURE__ */ jsxRuntime.jsx(
    "div",
    {
      className: css.cx(
        styles.media,
        className,
        css.css({
          alignSelf: align
        })
      ),
      children
    }
  );
};
Figure.displayName = "Figure";
const getFigureStyles = (theme) => ({
  media: css.css({
    position: "relative",
    gridArea: "Figure",
    marginRight: theme.spacing(2),
    width: "40px",
    "> img": {
      width: "100%"
    },
    "&:empty": {
      display: "none"
    }
  })
});
const Meta = React.memo(({ children, className, separator = "|" }) => {
  const styles = useStyles2(getMetaStyles);
  let meta = children;
  const filtered = React__namespace.Children.toArray(children).filter(Boolean);
  if (!filtered.length) {
    return null;
  }
  meta = filtered.map((element, i) => /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.metadataItem, children: element }, `element_${i}`));
  if (filtered.length > 1 && separator) {
    meta = filtered.reduce((prev, curr, i) => [
      prev,
      /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.separator, children: separator }, `separator_${i}`),
      curr
    ]);
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(styles.metadata, className), children: meta });
});
Meta.displayName = "Meta";
const getMetaStyles = (theme) => ({
  metadata: css.css({
    gridArea: "Meta",
    display: "flex",
    alignItems: "center",
    width: "100%",
    fontSize: theme.typography.size.sm,
    color: theme.colors.text.secondary,
    margin: theme.spacing(0.5, 0, 0),
    lineHeight: theme.typography.bodySmall.lineHeight,
    overflowWrap: "anywhere"
  }),
  metadataItem: css.css({
    // Needed to allow for clickable children in metadata
    zIndex: 0
  }),
  separator: css.css({
    margin: `0 ${theme.spacing(1)}`
  })
});
const BaseActions = ({ children, disabled, variant, className }) => {
  const styles = useStyles2(getActionStyles);
  const context = React.useContext(CardContext);
  const isDisabled = (context == null ? void 0 : context.disabled) || disabled;
  const css2 = variant === "primary" ? styles.actions : styles.secondaryActions;
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: css.cx(css2, className), children: React__namespace.Children.map(children, (child) => {
    return React__namespace.isValidElement(child) ? React.cloneElement(child, { disabled: isDisabled, ...child.props }) : null;
  }) });
};
const getActionStyles = (theme) => ({
  actions: css.css({
    display: "flex",
    flexDirection: "row",
    flexWrap: "wrap",
    gap: theme.spacing(1),
    gridArea: "Actions",
    marginTop: theme.spacing(2)
  }),
  secondaryActions: css.css({
    alignSelf: "center",
    color: theme.colors.text.secondary,
    display: "flex",
    flexDirection: "row",
    flexWrap: "wrap",
    gap: theme.spacing(1),
    gridArea: "Secondary",
    marginTop: theme.spacing(2)
  })
});
const Actions = ({ children, disabled, className }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(BaseActions, { variant: "primary", disabled, className, children });
};
Actions.displayName = "Actions";
const SecondaryActions = ({ children, disabled, className }) => {
  return /* @__PURE__ */ jsxRuntime.jsx(BaseActions, { variant: "secondary", disabled, className, children });
};
SecondaryActions.displayName = "SecondaryActions";

({
  [data.PluginSignatureType.grafana]: "grafana",
  [data.PluginSignatureType.commercial]: "shield",
  [data.PluginSignatureType.community]: "shield",
  DEFAULT: "shield-exclamation"
});

({
  drawStyle: [
    { label: "Lines", value: schema.GraphDrawStyle.Line },
    { label: "Bars", value: schema.GraphDrawStyle.Bars },
    { label: "Points", value: schema.GraphDrawStyle.Points }
  ],
  lineInterpolation: [
    { description: "Linear", value: schema.LineInterpolation.Linear, icon: "gf-interpolation-linear" },
    { description: "Smooth", value: schema.LineInterpolation.Smooth, icon: "gf-interpolation-smooth" },
    { description: "Step before", value: schema.LineInterpolation.StepBefore, icon: "gf-interpolation-step-before" },
    { description: "Step after", value: schema.LineInterpolation.StepAfter, icon: "gf-interpolation-step-after" }
  ],
  barAlignment: [
    { description: "Before", value: schema.BarAlignment.Before, icon: "gf-bar-alignment-before" },
    { description: "Center", value: schema.BarAlignment.Center, icon: "gf-bar-alignment-center" },
    { description: "After", value: schema.BarAlignment.After, icon: "gf-bar-alignment-after" }
  ],
  showPoints: [
    { label: "Auto", value: schema.VisibilityMode.Auto, description: "Show points when the density is low" },
    { label: "Always", value: schema.VisibilityMode.Always },
    { label: "Never", value: schema.VisibilityMode.Never }
  ],
  axisPlacement: [
    { label: "Auto", value: schema.AxisPlacement.Auto, description: "First field on the left, everything else on the right" },
    { label: "Left", value: schema.AxisPlacement.Left },
    { label: "Right", value: schema.AxisPlacement.Right },
    { label: "Hidden", value: schema.AxisPlacement.Hidden }
  ],
  fillGradient: [
    { label: "None", value: schema.GraphGradientMode.None },
    { label: "Opacity", value: schema.GraphGradientMode.Opacity, description: "Enable fill opacity gradient" },
    { label: "Hue", value: schema.GraphGradientMode.Hue, description: "Small color hue gradient" },
    {
      label: "Scheme",
      value: schema.GraphGradientMode.Scheme,
      description: "Use color scheme to define gradient"
    }
  ],
  stacking: [
    { label: "Off", value: schema.StackingMode.None },
    { label: "Normal", value: schema.StackingMode.Normal },
    { label: "100%", value: schema.StackingMode.Percent }
  ],
  thresholdsDisplayModes: [
    { label: "Off", value: schema.GraphThresholdsStyleMode.Off },
    { label: "As lines", value: schema.GraphThresholdsStyleMode.Line },
    { label: "As lines (dashed)", value: schema.GraphThresholdsStyleMode.Dashed },
    { label: "As filled regions", value: schema.GraphThresholdsStyleMode.Area },
    { label: "As filled regions and lines", value: schema.GraphThresholdsStyleMode.LineAndArea },
    { label: "As filled regions and lines (dashed)", value: schema.GraphThresholdsStyleMode.DashedAndArea }
  ]
});

function hasVisibleLegendSeries(config, data) {
  return config.getSeries().some((s) => {
    var _a, _b, _c;
    const fieldIndex = s.props.dataFrameFieldIndex;
    if (!fieldIndex) {
      return false;
    }
    const field = (_a = data[fieldIndex.frameIndex]) == null ? void 0 : _a.fields[fieldIndex.fieldIndex];
    if (!field || ((_c = (_b = field.config.custom) == null ? void 0 : _b.hideFrom) == null ? void 0 : _c.legend)) {
      return false;
    }
    return true;
  });
}
const PlotLegend = React.memo(
  ({ data: data$1, config, placement, calcs, displayMode, ...vizLayoutLegendProps }) => {
    const theme = useTheme2();
    const legendItems = config.getSeries().map((s) => {
      var _a, _b, _c, _d;
      const seriesConfig = s.props;
      const fieldIndex = seriesConfig.dataFrameFieldIndex;
      const axisPlacement = config.getAxisPlacement(s.props.scaleKey);
      if (!fieldIndex) {
        return void 0;
      }
      const field = (_a = data$1[fieldIndex.frameIndex]) == null ? void 0 : _a.fields[fieldIndex.fieldIndex];
      if (!field || ((_c = (_b = field.config.custom) == null ? void 0 : _b.hideFrom) == null ? void 0 : _c.legend)) {
        return void 0;
      }
      const label = data.getFieldDisplayName(field, data$1[fieldIndex.frameIndex], data$1);
      const scaleColor = data.getFieldSeriesColor(field, theme);
      const seriesColor = scaleColor.color;
      return {
        disabled: !((_d = seriesConfig.show) != null ? _d : true),
        fieldIndex,
        color: seriesColor,
        label,
        yAxis: axisPlacement === schema.AxisPlacement.Left || axisPlacement === schema.AxisPlacement.Bottom ? 1 : 2,
        getDisplayValues: () => getDisplayValuesForCalcs(calcs, field, theme),
        getItemKey: () => `${label}-${fieldIndex.frameIndex}-${fieldIndex.fieldIndex}`,
        lineStyle: seriesConfig.lineStyle
      };
    }).filter((i) => i !== void 0);
    return /* @__PURE__ */ jsxRuntime.jsx(VizLayout.Legend, { placement, ...vizLayoutLegendProps, children: /* @__PURE__ */ jsxRuntime.jsx(
      VizLegend,
      {
        placement,
        items: legendItems,
        displayMode,
        sortBy: vizLayoutLegendProps.sortBy,
        sortDesc: vizLayoutLegendProps.sortDesc,
        isSortable: true
      }
    ) });
  }
);
PlotLegend.displayName = "PlotLegend";

const Label = React.forwardRef(
  ({
    name,
    value,
    hidden,
    facets,
    onClick,
    className,
    loading,
    searchTerm,
    active,
    style,
    title,
    highlightParts,
    ...rest
  }, ref) => {
    const theme = useTheme2();
    const styles = getLabelStyles(theme);
    const searchWords = searchTerm ? [searchTerm] : [];
    const onLabelClick = React.useCallback(
      (event) => {
        if (onClick && !hidden) {
          onClick(name, value, event);
        }
      },
      [onClick, name, hidden, value]
    );
    let text = value || name;
    if (facets) {
      text = `${text} (${facets})`;
    }
    return /* @__PURE__ */ jsxRuntime.jsx(
      "button",
      {
        ref,
        onClick: onLabelClick,
        style,
        title: title || text,
        type: "button",
        role: "option",
        "aria-selected": !!active,
        className: css.cx(
          styles.base,
          active && styles.active,
          loading && styles.loading,
          hidden && styles.hidden,
          className,
          onClick && !hidden && styles.hover
        ),
        ...rest,
        children: highlightParts !== void 0 ? /* @__PURE__ */ jsxRuntime.jsx(PartialHighlighter, { text, highlightClassName: styles.matchHighLight, highlightParts }) : /* @__PURE__ */ jsxRuntime.jsx(
          Highlighter__default.default,
          {
            textToHighlight: text,
            searchWords,
            autoEscape: true,
            highlightClassName: styles.matchHighLight
          }
        )
      },
      text
    );
  }
);
Label.displayName = "Label";
const getLabelStyles = (theme) => ({
  base: css.css({
    display: "inline-block",
    cursor: "pointer",
    fontSize: theme.typography.size.sm,
    lineHeight: theme.typography.bodySmall.lineHeight,
    backgroundColor: theme.colors.background.secondary,
    color: theme.colors.text.primary,
    whiteSpace: "nowrap",
    textShadow: "none",
    padding: theme.spacing(0.5),
    borderRadius: theme.shape.radius.default,
    border: "none",
    marginRight: theme.spacing(1),
    marginBottom: theme.spacing(0.5)
  }),
  loading: css.css({
    fontWeight: theme.typography.fontWeightMedium,
    backgroundColor: theme.colors.primary.shade,
    color: theme.colors.text.primary,
    [theme.transitions.handleMotion("no-preference", "reduce")]: {
      animation: "pulse 3s ease-out 0s infinite normal forwards"
    },
    "@keyframes pulse": {
      "0%": {
        color: theme.colors.text.primary
      },
      "50%": {
        color: theme.colors.text.secondary
      },
      "100%": {
        color: theme.colors.text.disabled
      }
    }
  }),
  active: css.css({
    fontWeight: theme.typography.fontWeightMedium,
    backgroundColor: theme.colors.primary.main,
    color: theme.colors.primary.contrastText
  }),
  matchHighLight: css.css({
    background: "inherit",
    color: theme.components.textHighlight.text,
    backgroundColor: theme.components.textHighlight.background
  }),
  hidden: css.css({
    opacity: 0.6,
    cursor: "default",
    border: "1px solid transparent"
  }),
  hover: css.css({
    ["&:hover"]: {
      opacity: 0.85,
      cursor: "pointer"
    }
  })
});

const GraphContextMenu = ({
  getContextMenuSource,
  timeZone,
  itemsGroup,
  dimensions,
  contextDimensions,
  ...otherProps
}) => {
  const source = getContextMenuSource();
  const itemsToRender = itemsGroup ? itemsGroup.map((group) => {
    var _a;
    return {
      ...group,
      items: (_a = group.items) == null ? void 0 : _a.filter((item) => item.label)
    };
  }) : [];
  const renderHeader = () => {
    var _a;
    if (!source) {
      return null;
    }
    let value;
    if ((dimensions == null ? void 0 : dimensions.yAxis) && ((_a = contextDimensions == null ? void 0 : contextDimensions.yAxis) == null ? void 0 : _a[1])) {
      const valueFromDimensions = data.getValueFromDimension(
        dimensions.yAxis,
        contextDimensions.yAxis[0],
        contextDimensions.yAxis[1]
      );
      const display = source.series.valueField.display;
      value = display(valueFromDimensions);
    }
    const formattedValue = data.dateTimeFormat(source.datapoint[0], {
      defaultWithMS: source.series.hasMsResolution,
      timeZone
    });
    return /* @__PURE__ */ jsxRuntime.jsx(
      GraphContextMenuHeader,
      {
        timestamp: formattedValue,
        seriesColor: source.series.color,
        displayName: source.series.alias || source.series.label,
        displayValue: value
      }
    );
  };
  const renderMenuGroupItems = () => {
    return itemsToRender == null ? void 0 : itemsToRender.map((group, index) => /* @__PURE__ */ jsxRuntime.jsx(MenuGroup, { label: group.label, children: (group.items || []).map((item) => /* @__PURE__ */ jsxRuntime.jsx(
      MenuItem,
      {
        url: item.url,
        label: item.label,
        target: item.target,
        icon: item.icon,
        active: item.active,
        onClick: item.onClick
      },
      `${item.label}`
    )) }, `${group.label}${index}`));
  };
  return /* @__PURE__ */ jsxRuntime.jsx(ContextMenu, { ...otherProps, renderMenuItems: renderMenuGroupItems, renderHeader });
};
const GraphContextMenuHeader = ({
  timestamp,
  seriesColor,
  displayName,
  displayValue
}) => {
  const styles = useStyles2(getStyles$e);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.wrapper, children: [
    /* @__PURE__ */ jsxRuntime.jsx("strong", { children: timestamp }),
    /* @__PURE__ */ jsxRuntime.jsxs(HorizontalGroup, { children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntime.jsx(SeriesIcon, { color: seriesColor }),
        /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.displayName, children: displayName })
      ] }),
      displayValue && /* @__PURE__ */ jsxRuntime.jsx(FormattedValueDisplay, { value: displayValue })
    ] })
  ] });
};
function getStyles$e(theme) {
  return {
    wrapper: css.css({
      padding: theme.spacing(0.5, 1),
      fontSize: theme.typography.size.sm,
      zIndex: theme.zIndex.tooltip
    }),
    displayName: css.css({
      whiteSpace: "nowrap",
      paddingLeft: theme.spacing(0.5)
    })
  };
}

const findHoverIndexFromData = (xAxisDimension, xPos) => {
  let lower = 0;
  let upper = xAxisDimension.values.length - 1;
  let middle;
  while (true) {
    if (lower > upper) {
      return Math.max(upper, 0);
    }
    middle = Math.floor((lower + upper) / 2);
    const xPosition = xAxisDimension.values[middle];
    if (xPosition === xPos) {
      return middle;
    } else if (xPosition && xPosition < xPos) {
      lower = middle + 1;
    } else {
      upper = middle - 1;
    }
  }
};
const getMultiSeriesGraphHoverInfo = (yAxisDimensions, xAxisDimensions, xAxisPosition, timeZone) => {
  let i, field, hoverIndex, hoverDistance, pointTime;
  const results = [];
  let minDistance, minTime;
  for (i = 0; i < yAxisDimensions.length; i++) {
    field = yAxisDimensions[i];
    const time = xAxisDimensions[i];
    hoverIndex = findHoverIndexFromData(time, xAxisPosition);
    hoverDistance = xAxisPosition - time.values[hoverIndex];
    pointTime = time.values[hoverIndex];
    if (minDistance === void 0 || hoverDistance >= 0 && (hoverDistance < minDistance || minDistance < 0) || hoverDistance < 0 && hoverDistance > minDistance) {
      minDistance = hoverDistance;
      minTime = time.display ? data.formattedValueToString(time.display(pointTime)) : pointTime;
    }
    const disp = field.display(field.values[hoverIndex]);
    results.push({
      value: data.formattedValueToString(disp),
      datapointIndex: hoverIndex,
      seriesIndex: i,
      color: disp.color,
      label: data.getFieldDisplayName(field),
      time: time.display ? data.formattedValueToString(time.display(pointTime)) : pointTime
    });
  }
  return {
    results,
    time: minTime
  };
};
const graphTickFormatter = (epoch, axis) => {
  var _a, _b;
  return data.dateTimeFormat(epoch, {
    format: (_a = axis == null ? void 0 : axis.options) == null ? void 0 : _a.timeformat,
    timeZone: (_b = axis == null ? void 0 : axis.options) == null ? void 0 : _b.timezone
  });
};
const graphTimeFormat = (ticks, min, max) => {
  if (min && max && ticks) {
    const range = max - min;
    const secPerTick = range / ticks / 1e3;
    const oneDay = 86400010;
    const oneYear = 31536e6;
    if (secPerTick <= 10) {
      return data.systemDateFormats.interval.millisecond;
    }
    if (secPerTick <= 45) {
      return data.systemDateFormats.interval.second;
    }
    if (range <= oneDay) {
      return data.systemDateFormats.interval.minute;
    }
    if (secPerTick <= 8e4) {
      return data.systemDateFormats.interval.hour;
    }
    if (range <= oneYear) {
      return data.systemDateFormats.interval.day;
    }
    if (secPerTick <= 31536e3) {
      return data.systemDateFormats.interval.month;
    }
    return data.systemDateFormats.interval.year;
  }
  return data.systemDateFormats.interval.minute;
};

const MultiModeGraphTooltip = ({ dimensions, activeDimensions, pos, timeZone }) => {
  let activeSeriesIndex = null;
  if (activeDimensions.xAxis === null) {
    return null;
  }
  if (activeDimensions.yAxis) {
    activeSeriesIndex = activeDimensions.yAxis[0];
  }
  const time = activeDimensions.xAxis[1] ? data.getValueFromDimension(dimensions.xAxis, activeDimensions.xAxis[0], activeDimensions.xAxis[1]) : pos.x;
  const hoverInfo = getMultiSeriesGraphHoverInfo(dimensions.yAxis.columns, dimensions.xAxis.columns, time);
  const timestamp = hoverInfo.time;
  const series = hoverInfo.results.map((s, i) => {
    return {
      color: s.color,
      label: s.label,
      value: s.value,
      isActive: activeSeriesIndex === i
    };
  });
  return /* @__PURE__ */ jsxRuntime.jsx(SeriesTable, { series, timestamp });
};
MultiModeGraphTooltip.displayName = "MultiModeGraphTooltip";

const SingleModeGraphTooltip = ({ dimensions, activeDimensions, timeZone }) => {
  if (activeDimensions.yAxis === null || activeDimensions.yAxis[1] === void 0 || activeDimensions.xAxis === null || activeDimensions.xAxis[1] === void 0) {
    return null;
  }
  const time = data.getValueFromDimension(dimensions.xAxis, activeDimensions.xAxis[0], activeDimensions.xAxis[1]);
  const timeField = data.getColumnFromDimension(dimensions.xAxis, activeDimensions.xAxis[0]);
  const processedTime = timeField.display ? data.formattedValueToString(timeField.display(time)) : time;
  const valueField = data.getColumnFromDimension(dimensions.yAxis, activeDimensions.yAxis[0]);
  const value = data.getValueFromDimension(dimensions.yAxis, activeDimensions.yAxis[0], activeDimensions.yAxis[1]);
  const display = valueField.display;
  const disp = display(value);
  return /* @__PURE__ */ jsxRuntime.jsx(
    SeriesTable,
    {
      series: [
        {
          color: disp.color,
          label: data.getFieldDisplayName(valueField),
          value: data.formattedValueToString(disp)
        }
      ],
      timestamp: processedTime
    }
  );
};
SingleModeGraphTooltip.displayName = "SingleModeGraphTooltip";

const GraphTooltip = ({
  mode = schema.TooltipDisplayMode.Single,
  dimensions,
  activeDimensions,
  pos,
  timeZone
}) => {
  if (!activeDimensions || !activeDimensions.xAxis) {
    return null;
  }
  if (mode === "single") {
    return /* @__PURE__ */ jsxRuntime.jsx(SingleModeGraphTooltip, { dimensions, activeDimensions, timeZone });
  } else {
    return /* @__PURE__ */ jsxRuntime.jsx(
      MultiModeGraphTooltip,
      {
        dimensions,
        activeDimensions,
        pos,
        timeZone
      }
    );
  }
};
GraphTooltip.displayName = "GraphTooltip";

class Graph extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      isTooltipVisible: false,
      isContextVisible: false
    };
    this.element = null;
    this.$element = null;
    this.onPlotSelected = (event, ranges) => {
      const { onHorizontalRegionSelected } = this.props;
      if (onHorizontalRegionSelected) {
        onHorizontalRegionSelected(ranges.xaxis.from, ranges.xaxis.to);
      }
    };
    this.onPlotHover = (event, pos, item) => {
      this.setState({
        isTooltipVisible: true,
        activeItem: item,
        pos
      });
    };
    this.onPlotClick = (event, contextPos, item) => {
      this.setState({
        isContextVisible: true,
        isTooltipVisible: false,
        contextItem: item,
        contextPos
      });
    };
    this.renderTooltip = () => {
      const { children, series, timeZone } = this.props;
      const { pos, activeItem, isTooltipVisible } = this.state;
      let tooltipElement;
      if (!isTooltipVisible || !pos || series.length === 0) {
        return null;
      }
      React__namespace.Children.forEach(children, (c) => {
        if (tooltipElement) {
          return;
        }
        const childType = c && c.type && (c.type.displayName || c.type.name);
        if (childType === VizTooltip.displayName) {
          tooltipElement = c;
        }
      });
      if (!tooltipElement) {
        return null;
      }
      const tooltipElementProps = tooltipElement.props;
      const tooltipMode = tooltipElementProps.mode || "single";
      if (!activeItem && tooltipMode === "single") {
        return null;
      }
      const tooltipContentRenderer = tooltipElementProps.tooltipComponent || GraphTooltip;
      const seriesIndex = activeItem ? activeItem.series.seriesIndex : 0;
      const rowIndex = activeItem ? activeItem.dataIndex : void 0;
      const activeDimensions = {
        // Described x-axis active item
        // When hovering over an item - let's take it's dataIndex, otherwise undefined
        // Tooltip itself needs to figure out correct datapoint display information based on pos passed to it
        xAxis: [seriesIndex, rowIndex],
        // Describes y-axis active item
        yAxis: activeItem ? [activeItem.series.seriesIndex, activeItem.dataIndex] : null
      };
      const tooltipContentProps = {
        dimensions: {
          // time/value dimension columns are index-aligned - see getGraphSeriesModel
          xAxis: data.createDimension(
            "xAxis",
            series.map((s) => s.timeField)
          ),
          yAxis: data.createDimension(
            "yAxis",
            series.map((s) => s.valueField)
          )
        },
        activeDimensions,
        pos,
        mode: tooltipElementProps.mode || schema.TooltipDisplayMode.Single,
        timeZone
      };
      const tooltipContent = React__namespace.createElement(tooltipContentRenderer, { ...tooltipContentProps });
      return React__namespace.cloneElement(tooltipElement, {
        content: tooltipContent,
        position: { x: pos.pageX, y: pos.pageY },
        offset: { x: 10, y: 10 }
      });
    };
    this.renderContextMenu = () => {
      const { series } = this.props;
      const { contextPos, contextItem, isContextVisible } = this.state;
      if (!isContextVisible || !contextPos || !contextItem || series.length === 0) {
        return null;
      }
      const seriesIndex = contextItem ? contextItem.series.seriesIndex : 0;
      const rowIndex = contextItem ? contextItem.dataIndex : void 0;
      const contextDimensions = {
        // Described x-axis context item
        xAxis: [seriesIndex, rowIndex],
        // Describes y-axis context item
        yAxis: contextItem ? [contextItem.series.seriesIndex, contextItem.dataIndex] : null
      };
      const dimensions = {
        // time/value dimension columns are index-aligned - see getGraphSeriesModel
        xAxis: data.createDimension(
          "xAxis",
          series.map((s) => s.timeField)
        ),
        yAxis: data.createDimension(
          "yAxis",
          series.map((s) => s.valueField)
        )
      };
      const closeContext = () => this.setState({ isContextVisible: false });
      const getContextMenuSource = () => {
        return {
          datapoint: contextItem.datapoint,
          dataIndex: contextItem.dataIndex,
          series: contextItem.series,
          seriesIndex: contextItem.series.seriesIndex,
          pageX: contextPos.pageX,
          pageY: contextPos.pageY
        };
      };
      const contextContentProps = {
        x: contextPos.pageX,
        y: contextPos.pageY,
        onClose: closeContext,
        getContextMenuSource,
        timeZone: this.props.timeZone,
        dimensions,
        contextDimensions
      };
      return /* @__PURE__ */ jsxRuntime.jsx(GraphContextMenu, { ...contextContentProps });
    };
    this.getBarWidth = () => {
      const { series } = this.props;
      return Math.min(...series.map((s) => s.timeStep));
    };
  }
  componentDidUpdate(prevProps, prevState) {
    if (prevProps !== this.props) {
      this.draw();
    }
  }
  componentDidMount() {
    this.draw();
    if (this.element) {
      this.$element = $__default.default(this.element);
      this.$element.bind("plotselected", this.onPlotSelected);
      this.$element.bind("plothover", this.onPlotHover);
      this.$element.bind("plotclick", this.onPlotClick);
    }
  }
  componentWillUnmount() {
    if (this.$element) {
      this.$element.unbind("plotselected", this.onPlotSelected);
    }
  }
  getYAxes(series) {
    if (series.length === 0) {
      return [{ show: true, min: -1, max: 1 }];
    }
    return lodash.uniqBy(
      series.map((s) => {
        const index = s.yAxis ? s.yAxis.index : 1;
        const min = s.yAxis && s.yAxis.min && !isNaN(s.yAxis.min) ? s.yAxis.min : null;
        const tickDecimals = s.yAxis && s.yAxis.tickDecimals && !isNaN(s.yAxis.tickDecimals) ? s.yAxis.tickDecimals : null;
        return {
          show: true,
          index,
          position: index === 1 ? "left" : "right",
          min,
          tickDecimals
        };
      }),
      (yAxisConfig) => yAxisConfig.index
    );
  }
  draw() {
    if (this.element === null) {
      return;
    }
    const {
      width,
      series,
      timeRange,
      showLines,
      showBars,
      showPoints,
      isStacked,
      lineWidth,
      timeZone,
      onHorizontalRegionSelected
    } = this.props;
    if (!width) {
      return;
    }
    const ticks = width / 100;
    const min = timeRange.from.valueOf();
    const max = timeRange.to.valueOf();
    const yaxes = this.getYAxes(series);
    const flotOptions = {
      legend: {
        show: false
      },
      series: {
        stack: isStacked,
        lines: {
          show: showLines,
          lineWidth,
          zero: false
        },
        points: {
          show: showPoints,
          fill: 1,
          fillColor: false,
          radius: 2
        },
        bars: {
          show: showBars,
          fill: 1,
          // Dividig the width by 1.5 to make the bars not touch each other
          barWidth: showBars ? this.getBarWidth() / 1.5 : 1,
          zero: false,
          lineWidth
        },
        shadowSize: 0
      },
      xaxis: {
        timezone: timeZone,
        show: true,
        mode: "time",
        min,
        max,
        label: "Datetime",
        ticks,
        timeformat: graphTimeFormat(ticks, min, max),
        tickFormatter: graphTickFormatter
      },
      yaxes,
      grid: {
        minBorderMargin: 0,
        markings: [],
        backgroundColor: null,
        borderWidth: 0,
        hoverable: true,
        clickable: true,
        color: "#a1a1a1",
        margin: { left: 0, right: 0 },
        labelMarginX: 0,
        mouseActiveRadius: 30
      },
      selection: {
        mode: onHorizontalRegionSelected ? "x" : null,
        color: "#666"
      },
      crosshair: {
        mode: "x"
      }
    };
    try {
      $__default.default.plot(
        this.element,
        series.filter((s) => s.isVisible),
        flotOptions
      );
    } catch (err) {
      console.error("Graph rendering error", err, flotOptions, series);
      throw new Error("Error rendering panel");
    }
  }
  render() {
    const { ariaLabel, height, width, series } = this.props;
    const noDataToBeDisplayed = series.length === 0;
    const tooltip = this.renderTooltip();
    const context = this.renderContextMenu();
    return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graph-panel", "aria-label": ariaLabel, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          className: "graph-panel__chart",
          ref: (e) => this.element = e,
          style: { height, width },
          onMouseLeave: () => {
            this.setState({ isTooltipVisible: false });
          }
        }
      ),
      noDataToBeDisplayed && /* @__PURE__ */ jsxRuntime.jsx("div", { className: "datapoints-warning", children: "No data" }),
      tooltip,
      context
    ] });
  }
}
Graph.defaultProps = {
  showLines: true,
  showPoints: false,
  showBars: false,
  isStacked: false,
  lineWidth: 1
};

const INSERT_MODES = {
  threshold: (prev, next, threshold) => prev + threshold,
  midpoint: (prev, next, threshold) => (prev + next) / 2,
  // previous time + 1ms to prevent StateTimeline from forward-interpolating prior state
  plusone: (prev, next, threshold) => prev + 1
};
function applyNullInsertThreshold(opts) {
  if (opts.frame.length === 0) {
    return opts.frame;
  }
  let { frame, refFieldName, refFieldPseudoMax, refFieldPseudoMin, insertMode } = opts;
  if (!insertMode) {
    insertMode = INSERT_MODES.threshold;
  }
  const refField = getRefField(frame, refFieldName);
  if (refField == null) {
    return frame;
  }
  refField.state = {
    ...refField.state,
    nullThresholdApplied: true
  };
  const thresholds = frame.fields.map((field) => {
    var _a;
    return ((_a = field.config.custom) == null ? void 0 : _a.insertNulls) || refField.config.interval || null;
  });
  const uniqueThresholds = new Set(thresholds);
  uniqueThresholds.delete(null);
  if (uniqueThresholds.size === 0) {
    return frame;
  }
  if (uniqueThresholds.size === 1) {
    const threshold = uniqueThresholds.values().next().value;
    if (!threshold || threshold <= 0) {
      return frame;
    }
    const refValues = refField.values;
    const frameValues = frame.fields.map((field) => field.values);
    const filledFieldValues = nullInsertThreshold(
      refValues,
      frameValues,
      threshold,
      refFieldPseudoMin,
      refFieldPseudoMax,
      insertMode);
    if (filledFieldValues === frameValues) {
      return frame;
    }
    return {
      ...frame,
      length: filledFieldValues[0].length,
      fields: frame.fields.map((field, i) => ({
        ...field,
        values: filledFieldValues[i]
      }))
    };
  }
  return frame;
}
function nullInsertThreshold(refValues, frameValues, threshold, refFieldPseudoMin = null, refFieldPseudoMax = null, getInsertValue, thorough) {
  const len = refValues.length;
  const refValuesNew = [];
  if (refFieldPseudoMin != null && refFieldPseudoMin < refValues[0]) {
    let preFillCount = Math.ceil((refValues[0] - refFieldPseudoMin) / threshold);
    let prevSlot = refValues[0] - preFillCount * threshold;
    while (prevSlot < refValues[0]) {
      refValuesNew.push(getInsertValue(prevSlot - threshold, prevSlot, threshold));
      prevSlot += threshold;
    }
  }
  refValuesNew.push(refValues[0]);
  let prevValue = refValues[0];
  for (let i = 1; i < len; i++) {
    const curValue = refValues[i];
    while (curValue - prevValue > threshold) {
      refValuesNew.push(getInsertValue(prevValue, curValue, threshold));
      prevValue += threshold;
    }
    refValuesNew.push(curValue);
    prevValue = curValue;
  }
  if (refFieldPseudoMax != null && refFieldPseudoMax > prevValue) {
    while (prevValue + threshold < refFieldPseudoMax) {
      refValuesNew.push(getInsertValue(prevValue, refFieldPseudoMax, threshold));
      prevValue += threshold;
    }
  }
  const filledLen = refValuesNew.length;
  if (filledLen === len) {
    return frameValues;
  }
  const filledFieldValues = [];
  for (let fieldValues of frameValues) {
    let filledValues;
    if (fieldValues !== refValues) {
      filledValues = Array(filledLen);
      for (let i = 0, j = 0; i < filledLen; i++) {
        filledValues[i] = refValues[j] === refValuesNew[i] ? fieldValues[j++] : null;
      }
    } else {
      filledValues = refValuesNew;
    }
    filledFieldValues.push(filledValues);
  }
  return filledFieldValues;
}

function nullToUndefThreshold(refValues, fieldValues, maxThreshold) {
  let prevRef;
  let nullIdx;
  for (let i = 0; i < fieldValues.length; i++) {
    let fieldVal = fieldValues[i];
    if (fieldVal == null) {
      if (nullIdx == null && prevRef != null) {
        nullIdx = i;
      }
    } else {
      if (nullIdx != null) {
        if (refValues[i] - prevRef < maxThreshold) {
          while (nullIdx < i) {
            fieldValues[nullIdx++] = void 0;
          }
        }
        nullIdx = null;
      }
      prevRef = refValues[i];
    }
  }
  return fieldValues;
}

function isVisibleBarField(f) {
  var _a, _b, _c;
  return f.type === data.FieldType.number && ((_a = f.config.custom) == null ? void 0 : _a.drawStyle) === schema.GraphDrawStyle.Bars && !((_c = (_b = f.config.custom) == null ? void 0 : _b.hideFrom) == null ? void 0 : _c.viz);
}
function getRefField(frame, refFieldName) {
  return frame.fields.find((field) => {
    return refFieldName != null ? field.name === refFieldName : field.type === data.FieldType.time;
  });
}
function applySpanNullsThresholds(frame, refFieldName) {
  var _a;
  const refField = getRefField(frame, refFieldName);
  let refValues = refField == null ? void 0 : refField.values;
  for (let i = 0; i < frame.fields.length; i++) {
    let field = frame.fields[i];
    if (field === refField || isVisibleBarField(field)) {
      continue;
    }
    let spanNulls = (_a = field.config.custom) == null ? void 0 : _a.spanNulls;
    if (typeof spanNulls === "number") {
      if (spanNulls !== -1 && refValues) {
        field.values = nullToUndefThreshold(refValues, field.values, spanNulls);
      }
    }
  }
  return frame;
}
function preparePlotFrame(frames, dimFields, timeRange) {
  let xField;
  loop: for (let frame of frames) {
    for (let field of frame.fields) {
      if (dimFields.x(field, frame, frames)) {
        xField = field;
        break loop;
      }
    }
  }
  frames = frames.map((frame) => {
    var _a;
    if (!((_a = xField == null ? void 0 : xField.state) == null ? void 0 : _a.nullThresholdApplied)) {
      return applyNullInsertThreshold({
        frame,
        refFieldName: xField.name,
        refFieldPseudoMin: timeRange == null ? void 0 : timeRange.from.valueOf(),
        refFieldPseudoMax: timeRange == null ? void 0 : timeRange.to.valueOf()
      });
    } else {
      return frame;
    }
  });
  let numBarSeries = 0;
  frames.forEach((frame) => {
    frame.fields.forEach((f) => {
      if (isVisibleBarField(f)) {
        f.config.custom = {
          ...f.config.custom,
          spanNulls: -1
        };
        numBarSeries++;
      }
    });
  });
  let minXDelta = Infinity;
  if (numBarSeries > 1) {
    frames.forEach((frame) => {
      if (!frame.fields.some(isVisibleBarField)) {
        return;
      }
      const xVals = xField.values;
      for (let i = 0; i < xVals.length; i++) {
        if (i > 0) {
          minXDelta = Math.min(minXDelta, xVals[i] - xVals[i - 1]);
        }
      }
    });
  }
  let alignedFrame = data.outerJoinDataFrames({
    frames,
    joinBy: dimFields.x,
    keep: dimFields.y,
    keepOriginIndices: true
  });
  if (alignedFrame) {
    alignedFrame = applySpanNullsThresholds(alignedFrame, xField.name);
    if (minXDelta !== Infinity) {
      alignedFrame.fields.forEach((f, fi) => {
        let vals = f.values;
        if (fi === 0) {
          let lastVal = vals[vals.length - 1];
          vals.push(lastVal + minXDelta, lastVal + 2 * minXDelta);
        } else if (isVisibleBarField(f)) {
          vals.push(null, null);
        } else {
          vals.push(void 0, void 0);
        }
      });
      alignedFrame.length += 2;
    }
    return alignedFrame;
  }
  return null;
}
function buildScaleKey(config, fieldType) {
  var _a, _b, _c, _d, _e, _f, _g;
  const defaultPart = "na";
  const scaleRange = `${config.min !== void 0 ? config.min : defaultPart}-${config.max !== void 0 ? config.max : defaultPart}`;
  const scaleSoftRange = `${((_a = config.custom) == null ? void 0 : _a.axisSoftMin) !== void 0 ? config.custom.axisSoftMin : defaultPart}-${((_b = config.custom) == null ? void 0 : _b.axisSoftMax) !== void 0 ? config.custom.axisSoftMax : defaultPart}`;
  const scalePlacement = `${((_c = config.custom) == null ? void 0 : _c.axisPlacement) !== void 0 ? (_d = config.custom) == null ? void 0 : _d.axisPlacement : schema.AxisPlacement.Auto}`;
  const scaleUnit = (_e = config.unit) != null ? _e : FIXED_UNIT;
  const scaleDistribution = ((_f = config.custom) == null ? void 0 : _f.scaleDistribution) ? getScaleDistributionPart(config.custom.scaleDistribution) : schema.ScaleDistribution.Linear;
  const scaleLabel = Boolean((_g = config.custom) == null ? void 0 : _g.axisLabel) ? config.custom.axisLabel : defaultPart;
  return `${scaleUnit}/${scaleRange}/${scaleSoftRange}/${scalePlacement}/${scaleDistribution}/${scaleLabel}/${fieldType}`;
}
function getScaleDistributionPart(config) {
  if (config.type === schema.ScaleDistribution.Log) {
    return `${config.type}${config.log}`;
  }
  return config.type;
}

function sameProps(prevProps, nextProps, propsToDiff = []) {
  for (const propName of propsToDiff) {
    if (typeof propName === "function") {
      if (!propName(prevProps, nextProps)) {
        return false;
      }
    } else if (nextProps[propName] !== prevProps[propName]) {
      return false;
    }
  }
  return true;
}
class GraphNG extends React.Component {
  constructor(props) {
    super(props);
    this.panelContext = {};
    this.subscription = new rxjs.Subscription();
    this.getTimeRange = () => this.props.timeRange;
    let state = this.prepState(props);
    state.alignedData = state.config.prepData([state.alignedFrame]);
    this.state = state;
    this.plotInstance = React__namespace.createRef();
  }
  prepState(props, withConfig = true) {
    var _a;
    let state = null;
    const { frames, fields, preparePlotFrame: preparePlotFrame$1 } = props;
    const preparePlotFrameFn = preparePlotFrame$1 || preparePlotFrame;
    const alignedFrame = preparePlotFrameFn(
      frames,
      fields || {
        x: data.fieldMatchers.get(data.FieldMatcherID.firstTimeField).get({}),
        y: data.fieldMatchers.get(data.FieldMatcherID.byTypes).get(/* @__PURE__ */ new Set([data.FieldType.number, data.FieldType.enum]))
      },
      props.timeRange
    );
    pluginLog("GraphNG", false, "data aligned", alignedFrame);
    if (alignedFrame) {
      let config = (_a = this.state) == null ? void 0 : _a.config;
      if (withConfig) {
        config = props.prepConfig(alignedFrame, this.props.frames, this.getTimeRange);
        pluginLog("GraphNG", false, "config prepared", config);
      }
      state = {
        alignedFrame,
        config
      };
      pluginLog("GraphNG", false, "data prepared", state.alignedData);
    }
    return state;
  }
  handleCursorUpdate(evt) {
    var _a, _b;
    const time = (_b = (_a = evt.payload) == null ? void 0 : _a.point) == null ? void 0 : _b.time;
    const u = this.plotInstance.current;
    if (u && time) {
      const left = u.valToPos(time, "x");
      let top;
      if (left) {
        top = findMidPointYPosition(u, u.posToIdx(left));
      }
      if (!top || !left) {
        return;
      }
      u.setCursor({
        left,
        top
      });
    }
  }
  componentDidMount() {
    this.panelContext = this.context;
    const { eventBus } = this.panelContext;
    this.subscription.add(
      eventBus.getStream(data.DataHoverEvent).pipe(operators.throttleTime(50)).subscribe({
        next: (evt) => {
          if (eventBus === evt.origin) {
            return;
          }
          this.handleCursorUpdate(evt);
        }
      })
    );
    this.subscription.add(
      eventBus.getStream(data.LegacyGraphHoverEvent).pipe(operators.throttleTime(50)).subscribe({
        next: (evt) => this.handleCursorUpdate(evt)
      })
    );
    this.subscription.add(
      eventBus.getStream(data.DataHoverClearEvent).pipe(operators.throttleTime(50)).subscribe({
        next: () => {
          var _a;
          const u = (_a = this.plotInstance) == null ? void 0 : _a.current;
          if (u && !u.cursor._lock) {
            u.setCursor({
              left: -10,
              top: -10
            });
          }
        }
      })
    );
  }
  componentDidUpdate(prevProps) {
    const { frames, structureRev, timeZone, propsToDiff } = this.props;
    const propsChanged = !sameProps(prevProps, this.props, propsToDiff);
    if (frames !== prevProps.frames || propsChanged || timeZone !== prevProps.timeZone) {
      let newState = this.prepState(this.props, false);
      if (newState) {
        const shouldReconfig = this.state.config === void 0 || timeZone !== prevProps.timeZone || structureRev !== prevProps.structureRev || !structureRev || propsChanged;
        if (shouldReconfig) {
          newState.config = this.props.prepConfig(newState.alignedFrame, this.props.frames, this.getTimeRange);
          pluginLog("GraphNG", false, "config recreated", newState.config);
        }
        newState.alignedData = newState.config.prepData([newState.alignedFrame]);
        this.setState(newState);
      }
    }
  }
  componentWillUnmount() {
    this.subscription.unsubscribe();
  }
  render() {
    const { width, height, children, renderLegend } = this.props;
    const { config, alignedFrame, alignedData } = this.state;
    if (!config) {
      return null;
    }
    return /* @__PURE__ */ jsxRuntime.jsx(VizLayout, { width, height, legend: renderLegend(config), children: (vizWidth, vizHeight) => /* @__PURE__ */ jsxRuntime.jsx(
      UPlotChart,
      {
        config,
        data: alignedData,
        width: vizWidth,
        height: vizHeight,
        plotRef: (u) => this.plotInstance.current = u,
        children: children ? children(config, alignedFrame) : null
      }
    ) });
  }
}
GraphNG.contextType = PanelContextRoot;

const IEC_UNITS = /* @__PURE__ */ new Set([
  "bytes",
  "bits",
  "kbytes",
  "mbytes",
  "gbytes",
  "tbytes",
  "pbytes",
  "binBps",
  "binbps",
  "KiBs",
  "Kibits",
  "MiBs",
  "Mibits",
  "GiBs",
  "Gibits",
  "TiBs",
  "Tibits",
  "PiBs",
  "Pibits"
]);
const BIN_INCRS = Array(53);
for (let i = 0; i < BIN_INCRS.length; i++) {
  BIN_INCRS[i] = 2 ** i;
}
const defaultFormatter = (v, decimals = 1) => v == null ? "-" : v.toFixed(decimals);
const defaultConfig = {
  drawStyle: schema.GraphDrawStyle.Line,
  showPoints: schema.VisibilityMode.Auto,
  axisPlacement: schema.AxisPlacement.Auto
};
const preparePlotConfigBuilder = ({
  frame,
  theme,
  timeZones,
  getTimeRange,
  sync,
  allFrames,
  renderers,
  tweakScale = (opts) => opts,
  tweakAxis = (opts) => opts
}) => {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v;
  const eventsScope = "__global_";
  const builder = new UPlotConfigBuilder(timeZones[0]);
  let alignedFrame;
  builder.setPrepData((frames) => {
    alignedFrame = frames[0];
    return preparePlotData2(frames[0], builder.getStackingGroups());
  });
  const xField = frame.fields[0];
  if (!xField) {
    return builder;
  }
  const xScaleKey = "x";
  let yScaleKey = "";
  const xFieldAxisPlacement = ((_a = xField.config.custom) == null ? void 0 : _a.axisPlacement) !== schema.AxisPlacement.Hidden ? schema.AxisPlacement.Bottom : schema.AxisPlacement.Hidden;
  const xFieldAxisShow = ((_b = xField.config.custom) == null ? void 0 : _b.axisPlacement) !== schema.AxisPlacement.Hidden;
  if (xField.type === data.FieldType.time) {
    builder.addScale({
      scaleKey: xScaleKey,
      orientation: schema.ScaleOrientation.Horizontal,
      direction: schema.ScaleDirection.Right,
      isTime: true,
      range: () => {
        const r = getTimeRange();
        return [r.from.valueOf(), r.to.valueOf()];
      }
    });
    const filterTicks = timeZones.length > 1 ? (u, splits) => {
      return splits.map((v, i) => i < 2 ? null : v);
    } : void 0;
    for (let i = 0; i < timeZones.length; i++) {
      const timeZone = timeZones[i];
      builder.addAxis({
        scaleKey: xScaleKey,
        isTime: true,
        placement: xFieldAxisPlacement,
        show: xFieldAxisShow,
        label: (_c = xField.config.custom) == null ? void 0 : _c.axisLabel,
        timeZone,
        theme,
        grid: { show: i === 0 && ((_d = xField.config.custom) == null ? void 0 : _d.axisGridShow) },
        filter: filterTicks
      });
    }
    if (timeZones.length > 1) {
      builder.addHook("drawAxes", (u) => {
        u.ctx.save();
        u.ctx.fillStyle = theme.colors.text.primary;
        u.ctx.textAlign = "left";
        u.ctx.textBaseline = "bottom";
        let i = 0;
        u.axes.forEach((a) => {
          if (a.side === 2) {
            let cssBaseline = a._pos + a._size;
            u.ctx.fillText(timeZones[i], u.bbox.left, cssBaseline * uPlot__default.default.pxRatio);
            i++;
          }
        });
        u.ctx.restore();
      });
    }
  } else {
    builder.addScale({
      scaleKey: xScaleKey,
      orientation: schema.ScaleOrientation.Horizontal,
      direction: schema.ScaleDirection.Right,
      range: (u, dataMin, dataMax) => {
        var _a2, _b2;
        return [(_a2 = xField.config.min) != null ? _a2 : dataMin, (_b2 = xField.config.max) != null ? _b2 : dataMax];
      }
    });
    builder.addAxis({
      scaleKey: xScaleKey,
      placement: xFieldAxisPlacement,
      show: xFieldAxisShow,
      label: (_e = xField.config.custom) == null ? void 0 : _e.axisLabel,
      theme,
      grid: { show: (_f = xField.config.custom) == null ? void 0 : _f.axisGridShow },
      formatValue: (v, decimals) => data.formattedValueToString(xField.display(v, decimals))
    });
  }
  let customRenderedFields = (_g = renderers == null ? void 0 : renderers.flatMap((r) => Object.values(r.fieldMap).filter((name) => r.indicesOnly.indexOf(name) === -1))) != null ? _g : [];
  let indexByName;
  for (let i = 1; i < frame.fields.length; i++) {
    const field = frame.fields[i];
    const config = {
      ...field.config,
      custom: {
        ...defaultConfig,
        ...field.config.custom
      }
    };
    const customConfig = config.custom;
    if (field === xField || field.type !== data.FieldType.number && field.type !== data.FieldType.enum) {
      continue;
    }
    let fmt = (_h = field.display) != null ? _h : defaultFormatter;
    if (((_j = (_i = field.config.custom) == null ? void 0 : _i.stacking) == null ? void 0 : _j.mode) === schema.StackingMode.Percent) {
      fmt = data.getDisplayProcessor({
        field: {
          ...field,
          config: {
            ...field.config,
            unit: "percentunit"
          }
        },
        theme
      });
    }
    const scaleKey = buildScaleKey(config, field.type);
    const colorMode = data.getFieldColorModeForField(field);
    const scaleColor = data.getFieldSeriesColor(field, theme);
    const seriesColor = scaleColor.color;
    builder.addScale(
      tweakScale(
        {
          scaleKey,
          orientation: schema.ScaleOrientation.Vertical,
          direction: schema.ScaleDirection.Up,
          distribution: (_k = customConfig.scaleDistribution) == null ? void 0 : _k.type,
          log: (_l = customConfig.scaleDistribution) == null ? void 0 : _l.log,
          linearThreshold: (_m = customConfig.scaleDistribution) == null ? void 0 : _m.linearThreshold,
          min: field.config.min,
          max: field.config.max,
          softMin: customConfig.axisSoftMin,
          softMax: customConfig.axisSoftMax,
          centeredZero: customConfig.axisCenteredZero,
          range: ((_n = customConfig.stacking) == null ? void 0 : _n.mode) === schema.StackingMode.Percent ? (u, dataMin, dataMax) => {
            dataMin = dataMin < 0 ? -1 : 0;
            dataMax = dataMax > 0 ? 1 : 0;
            return [dataMin, dataMax];
          } : field.type === data.FieldType.enum ? (u, dataMin, dataMax) => {
            let len = field.config.type.enum.text.length;
            return [-1, len];
          } : void 0,
          decimals: field.config.decimals
        },
        field
      )
    );
    if (!yScaleKey) {
      yScaleKey = scaleKey;
    }
    if (customConfig.axisPlacement !== schema.AxisPlacement.Hidden) {
      let axisColor;
      if (customConfig.axisColorMode === schema.AxisColorMode.Series) {
        if (colorMode.isByValue && ((_o = field.config.custom) == null ? void 0 : _o.gradientMode) === schema.GraphGradientMode.Scheme && colorMode.id === data.FieldColorModeId.Thresholds) {
          axisColor = getScaleGradientFn(1, theme, colorMode, field.config.thresholds);
        } else {
          axisColor = seriesColor;
        }
      }
      const axisDisplayOptions = {
        border: {
          show: customConfig.axisBorderShow || false,
          width: 1 / devicePixelRatio,
          stroke: axisColor || theme.colors.text.primary
        },
        ticks: {
          show: customConfig.axisBorderShow || false,
          stroke: axisColor || theme.colors.text.primary
        },
        color: axisColor || theme.colors.text.primary
      };
      let incrs;
      let values;
      let splits;
      if (IEC_UNITS.has(config.unit)) {
        incrs = BIN_INCRS;
      } else if (field.type === data.FieldType.enum) {
        let text = field.config.type.enum.text;
        splits = text.map((v, i2) => i2);
        values = text;
      }
      builder.addAxis(
        tweakAxis(
          {
            scaleKey,
            label: customConfig.axisLabel,
            size: customConfig.axisWidth,
            placement: (_p = customConfig.axisPlacement) != null ? _p : schema.AxisPlacement.Auto,
            formatValue: (v, decimals) => data.formattedValueToString(fmt(v, decimals)),
            theme,
            grid: { show: customConfig.axisGridShow },
            decimals: field.config.decimals,
            distr: (_q = customConfig.scaleDistribution) == null ? void 0 : _q.type,
            splits,
            values,
            incrs,
            ...axisDisplayOptions
          },
          field
        )
      );
    }
    const showPoints = customConfig.drawStyle === schema.GraphDrawStyle.Points ? schema.VisibilityMode.Always : customConfig.showPoints;
    let pointsFilter = () => null;
    if (customConfig.spanNulls !== true) {
      pointsFilter = (u, seriesIdx, show, gaps) => {
        let filtered = [];
        let series = u.series[seriesIdx];
        if (!show && gaps && gaps.length) {
          const [firstIdx, lastIdx] = series.idxs;
          const xData = u.data[0];
          const yData = u.data[seriesIdx];
          const firstPos = Math.round(u.valToPos(xData[firstIdx], "x", true));
          const lastPos = Math.round(u.valToPos(xData[lastIdx], "x", true));
          if (gaps[0][0] === firstPos) {
            filtered.push(firstIdx);
          }
          for (let i2 = 0; i2 < gaps.length; i2++) {
            let thisGap = gaps[i2];
            let nextGap = gaps[i2 + 1];
            if (nextGap && thisGap[1] === nextGap[0]) {
              let approxIdx = u.posToIdx(thisGap[1], true);
              if (yData[approxIdx] == null) {
                for (let j = 1; j < 100; j++) {
                  if (yData[approxIdx + j] != null) {
                    approxIdx += j;
                    break;
                  }
                  if (yData[approxIdx - j] != null) {
                    approxIdx -= j;
                    break;
                  }
                }
              }
              filtered.push(approxIdx);
            }
          }
          if (gaps[gaps.length - 1][1] === lastPos) {
            filtered.push(lastIdx);
          }
        }
        return filtered.length ? filtered : null;
      };
    }
    let { fillOpacity } = customConfig;
    let pathBuilder = null;
    let pointsBuilder = null;
    if ((_r = field.state) == null ? void 0 : _r.origin) {
      if (!indexByName) {
        indexByName = getNamesToFieldIndex(frame, allFrames);
      }
      const originFrame = allFrames[field.state.origin.frameIndex];
      const originField = originFrame == null ? void 0 : originFrame.fields[field.state.origin.fieldIndex];
      const dispName = data.getFieldDisplayName(originField != null ? originField : field, originFrame, allFrames);
      if (customRenderedFields.indexOf(dispName) >= 0) {
        pathBuilder = () => null;
        pointsBuilder = () => void 0;
      } else if (customConfig.transform === schema.GraphTransform.Constant) {
        const defaultBuilder = uPlot__default.default.paths.linear();
        pathBuilder = (u, seriesIdx) => {
          const _data = u._data;
          const r = getTimeRange();
          let xData = [r.from.valueOf(), r.to.valueOf()];
          let firstY = _data[seriesIdx].find((v) => v != null);
          let yData = [firstY, firstY];
          let fauxData = _data.slice();
          fauxData[0] = xData;
          fauxData[seriesIdx] = yData;
          return defaultBuilder(
            {
              ...u,
              _data: fauxData
            },
            seriesIdx,
            0,
            1
          );
        };
      }
      if (customConfig.fillBelowTo) {
        const fillBelowToField = frame.fields.find(
          (f) => {
            var _a2;
            return customConfig.fillBelowTo === f.name || customConfig.fillBelowTo === ((_a2 = f.config) == null ? void 0 : _a2.displayNameFromDS) || customConfig.fillBelowTo === data.getFieldDisplayName(f, frame, allFrames);
          }
        );
        const fillBelowDispName = fillBelowToField ? data.getFieldDisplayName(fillBelowToField, frame, allFrames) : customConfig.fillBelowTo;
        const t = indexByName.get(dispName);
        const b = indexByName.get(fillBelowDispName);
        if (lodash.isNumber(b) && lodash.isNumber(t)) {
          builder.addBand({
            series: [t, b],
            fill: void 0
            // using null will have the band use fill options from `t`
          });
          if (!fillOpacity) {
            fillOpacity = 35;
          }
        } else {
          fillOpacity = 0;
        }
      }
    }
    let dynamicSeriesColor = void 0;
    if (colorMode.id === data.FieldColorModeId.Thresholds) {
      dynamicSeriesColor = (seriesIdx) => data.getFieldSeriesColor(alignedFrame.fields[seriesIdx], theme).color;
    }
    builder.addSeries({
      pathBuilder,
      pointsBuilder,
      scaleKey,
      showPoints,
      pointsFilter,
      colorMode,
      fillOpacity,
      theme,
      dynamicSeriesColor,
      drawStyle: customConfig.drawStyle,
      lineColor: (_s = customConfig.lineColor) != null ? _s : seriesColor,
      lineWidth: customConfig.lineWidth,
      lineInterpolation: customConfig.lineInterpolation,
      lineStyle: customConfig.lineStyle,
      barAlignment: customConfig.barAlignment,
      barWidthFactor: customConfig.barWidthFactor,
      barMaxWidth: customConfig.barMaxWidth,
      pointSize: customConfig.pointSize,
      spanNulls: customConfig.spanNulls || false,
      show: !((_t = customConfig.hideFrom) == null ? void 0 : _t.viz),
      gradientMode: customConfig.gradientMode,
      thresholds: config.thresholds,
      hardMin: field.config.min,
      hardMax: field.config.max,
      softMin: customConfig.axisSoftMin,
      softMax: customConfig.axisSoftMax,
      // The following properties are not used in the uPlot config, but are utilized as transport for legend config
      dataFrameFieldIndex: (_u = field.state) == null ? void 0 : _u.origin
    });
    if (customConfig.thresholdsStyle && config.thresholds) {
      const thresholdDisplay = (_v = customConfig.thresholdsStyle.mode) != null ? _v : schema.GraphThresholdsStyleMode.Off;
      if (thresholdDisplay !== schema.GraphThresholdsStyleMode.Off) {
        builder.addThresholds({
          config: customConfig.thresholdsStyle,
          thresholds: config.thresholds,
          scaleKey,
          theme,
          hardMin: field.config.min,
          hardMax: field.config.max,
          softMin: customConfig.axisSoftMin,
          softMax: customConfig.axisSoftMax
        });
      }
    }
  }
  let stackingGroups = getStackingGroups(frame);
  builder.setStackingGroups(stackingGroups);
  renderers == null ? void 0 : renderers.forEach((r) => {
    if (!indexByName) {
      indexByName = getNamesToFieldIndex(frame, allFrames);
    }
    let fieldIndices = {};
    for (let key in r.fieldMap) {
      let dispName = r.fieldMap[key];
      fieldIndices[key] = indexByName.get(dispName);
    }
    r.init(builder, fieldIndices);
  });
  builder.scaleKeys = [xScaleKey, yScaleKey];
  const hoverProximityPx = 15;
  let cursor = {
    // this scans left and right from cursor position to find nearest data index with value != null
    // TODO: do we want to only scan past undefined values, but halt at explicit null values?
    dataIdx: (self, seriesIdx, hoveredIdx, cursorXVal) => {
      let seriesData = self.data[seriesIdx];
      if (seriesData[hoveredIdx] == null) {
        let nonNullLft = null, nonNullRgt = null, i;
        i = hoveredIdx;
        while (nonNullLft == null && i-- > 0) {
          if (seriesData[i] != null) {
            nonNullLft = i;
          }
        }
        i = hoveredIdx;
        while (nonNullRgt == null && i++ < seriesData.length) {
          if (seriesData[i] != null) {
            nonNullRgt = i;
          }
        }
        let xVals = self.data[0];
        let curPos = self.valToPos(cursorXVal, "x");
        let rgtPos = nonNullRgt == null ? Infinity : self.valToPos(xVals[nonNullRgt], "x");
        let lftPos = nonNullLft == null ? -Infinity : self.valToPos(xVals[nonNullLft], "x");
        let lftDelta = curPos - lftPos;
        let rgtDelta = rgtPos - curPos;
        if (lftDelta <= rgtDelta) {
          if (lftDelta <= hoverProximityPx) {
            hoveredIdx = nonNullLft;
          }
        } else {
          if (rgtDelta <= hoverProximityPx) {
            hoveredIdx = nonNullRgt;
          }
        }
      }
      return hoveredIdx;
    }
  };
  if (sync && sync() !== data.DashboardCursorSync.Off) {
    cursor.sync = {
      key: eventsScope,
      scales: [xScaleKey, null]
    };
  }
  builder.setCursor(cursor);
  return builder;
};
function getNamesToFieldIndex(frame, allFrames) {
  const originNames = /* @__PURE__ */ new Map();
  frame.fields.forEach((field, i) => {
    var _a, _b;
    const origin = (_a = field.state) == null ? void 0 : _a.origin;
    if (origin) {
      const origField = (_b = allFrames[origin.frameIndex]) == null ? void 0 : _b.fields[origin.fieldIndex];
      if (origField) {
        originNames.set(data.getFieldDisplayName(origField, allFrames[origin.frameIndex], allFrames), i);
      }
    }
  });
  return originNames;
}

const propsToDiff = ["legend", "options", "theme"];
class UnthemedTimeSeries extends React.Component {
  constructor() {
    super(...arguments);
    this.prepConfig = (alignedFrame, allFrames, getTimeRange) => {
      const { sync } = this.context;
      const { theme, timeZone, renderers, tweakAxis, tweakScale } = this.props;
      return preparePlotConfigBuilder({
        frame: alignedFrame,
        theme,
        timeZones: Array.isArray(timeZone) ? timeZone : [timeZone],
        getTimeRange,
        sync,
        allFrames,
        renderers,
        tweakScale,
        tweakAxis
      });
    };
    this.renderLegend = (config) => {
      const { legend, frames } = this.props;
      if (!config || legend && !legend.showLegend || !hasVisibleLegendSeries(config, frames)) {
        return null;
      }
      return /* @__PURE__ */ jsxRuntime.jsx(PlotLegend, { data: frames, config, ...legend });
    };
  }
  render() {
    return /* @__PURE__ */ jsxRuntime.jsx(
      GraphNG,
      {
        ...this.props,
        prepConfig: this.prepConfig,
        propsToDiff,
        renderLegend: this.renderLegend
      }
    );
  }
}
UnthemedTimeSeries.contextType = PanelContextRoot;
const TimeSeries = withTheme2(UnthemedTimeSeries);
TimeSeries.displayName = "TimeSeries";

React.createContext({});

const COLUMN = {
  DEFAULT_WIDTH: 150,
  EXPANDER_WIDTH: 50,
  // This will need to eventually change to 36
  MIN_WIDTH: 50
};
const TABLE = {
  CELL_PADDING: 8,
  MAX_CELL_HEIGHT: 48,
  PAGINATION_LIMIT: 750,
  SCROLL_BAR_WIDTH: 8,
  SCROLL_BAR_MARGIN: 2
};

function getCellHeightCalculator(ctx, lineHeight, defaultRowHeight, padding = 0) {
  const { count } = uwrap.varPreLine(ctx);
  return (text, cellWidth) => {
    const effectiveCellWidth = Math.max(cellWidth, 20);
    const TOTAL_PADDING = padding * 2;
    const numLines = count(text, effectiveCellWidth);
    const totalHeight = numLines * lineHeight + TOTAL_PADDING;
    return Math.max(totalHeight, defaultRowHeight);
  };
}
function getDefaultRowHeight(theme, cellHeight) {
  const bodyFontSize = theme.typography.fontSize;
  const lineHeight = theme.typography.body.lineHeight;
  switch (cellHeight) {
    case schema.TableCellHeight.Sm:
      return 36;
    case schema.TableCellHeight.Md:
      return 42;
    case schema.TableCellHeight.Lg:
      return TABLE.MAX_CELL_HEIGHT;
  }
  return TABLE.CELL_PADDING * 2 + bodyFontSize * lineHeight;
}
function getRowHeight(row, calc, avgCharWidth, defaultRowHeight, fieldsData) {
  let maxLines = 1;
  let maxLinesCol = "";
  for (const key in row) {
    if (fieldsData.columnTypes[key] === data.FieldType.string && fieldsData.textWraps[key] && fieldsData.fieldDisplayType[key] !== schema.TableCellDisplayMode.Image) {
      const cellText = row[key];
      if (cellText != null) {
        const charsPerLine = fieldsData.columnWidths[key] / avgCharWidth;
        const approxLines = cellText.length / charsPerLine;
        if (approxLines > maxLines) {
          maxLines = approxLines;
          maxLinesCol = key;
        }
      }
    }
  }
  return maxLinesCol === "" ? defaultRowHeight : calc(row[maxLinesCol], fieldsData.columnWidths[maxLinesCol]);
}
function isTextCell(key, columnTypes) {
  return columnTypes[key] === data.FieldType.string;
}
function shouldTextOverflow(key, row, columnTypes, headerCellRefs, ctx, lineHeight, defaultRowHeight, padding, textWrap, field, cellType) {
  var _a, _b, _c;
  const cellInspect = (_c = (_b = (_a = field.config) == null ? void 0 : _a.custom) == null ? void 0 : _b.inspect) != null ? _c : false;
  if (textWrap || cellInspect || cellType === schema.TableCellDisplayMode.Image || !isTextCell(key, columnTypes)) {
    return false;
  }
  return true;
}
function getTextAlign(field) {
  if (!field) {
    return "flex-start";
  }
  if (field.config.custom) {
    const custom = field.config.custom;
    switch (custom.align) {
      case "right":
        return "flex-end";
      case "left":
        return "flex-start";
      case "center":
        return "center";
    }
  }
  if (field.type === data.FieldType.number) {
    return "flex-end";
  }
  return "flex-start";
}
const defaultCellOptions = { type: schema.TableCellDisplayMode.Auto };
function getCellOptions(field) {
  var _a, _b, _c;
  if ((_a = field.config.custom) == null ? void 0 : _a.displayMode) {
    return migrateTableDisplayModeToCellOptions((_b = field.config.custom) == null ? void 0 : _b.displayMode);
  }
  if (!((_c = field.config.custom) == null ? void 0 : _c.cellOptions)) {
    return defaultCellOptions;
  }
  return field.config.custom.cellOptions;
}
function getAlignmentFactor(field, displayValue, rowIndex) {
  var _a;
  let alignmentFactor = (_a = field.state) == null ? void 0 : _a.alignmentFactors;
  if (alignmentFactor) {
    if (data.formattedValueToString(alignmentFactor).length < data.formattedValueToString(displayValue).length) {
      alignmentFactor = { ...displayValue };
      field.state.alignmentFactors = alignmentFactor;
    }
    return alignmentFactor;
  } else {
    alignmentFactor = { ...displayValue };
    const maxIndex = Math.min(field.values.length, rowIndex + 1e3);
    for (let i = rowIndex + 1; i < maxIndex; i++) {
      const nextDisplayValue = field.display(field.values[i]);
      if (data.formattedValueToString(alignmentFactor).length > data.formattedValueToString(nextDisplayValue).length) {
        alignmentFactor.text = displayValue.text;
      }
    }
    if (field.state) {
      field.state.alignmentFactors = alignmentFactor;
    } else {
      field.state = { alignmentFactors: alignmentFactor };
    }
    return alignmentFactor;
  }
}
function getFooterItemNG(rows, field, options) {
  if (options === void 0) {
    return "";
  }
  if (field.type !== data.FieldType.number) {
    return "";
  }
  if (!options.reducer || !options.reducer.length) {
    return "";
  }
  if (options.fields && options.fields.length > 0) {
    if (!options.fields.includes(field.name)) {
      return "";
    }
  }
  const calc = options.reducer[0];
  const value = data.reduceField({
    field: {
      ...field,
      values: rows.map((row) => row[getDisplayName(field)])
    },
    reducers: options.reducer
  })[calc];
  const formattedValue = data.formattedValueToString(field.display(value));
  return formattedValue;
}
const getFooterStyles = (justifyContent) => ({
  footerCell: css.css({
    display: "flex",
    justifyContent: justifyContent || "space-between"
  })
});
const CELL_COLOR_DARKENING_MULTIPLIER = 10;
const CELL_GRADIENT_DARKENING_MULTIPLIER = 15;
const CELL_GRADIENT_HUE_ROTATION_DEGREES = 5;
function getCellColors(theme, cellOptions, displayValue) {
  var _a;
  const autoCellBackgroundHoverColor = convertRGBAToHex(theme.colors.background.primary, theme.colors.action.hover);
  const darkeningFactor = theme.isDark ? 1 : -0.7;
  let textColor = void 0;
  let bgColor = void 0;
  let bgHoverColor = autoCellBackgroundHoverColor;
  if (cellOptions.type === schema.TableCellDisplayMode.ColorText) {
    textColor = displayValue.color;
  } else if (cellOptions.type === schema.TableCellDisplayMode.ColorBackground) {
    const mode = (_a = cellOptions.mode) != null ? _a : schema.TableCellBackgroundDisplayMode.Gradient;
    if (mode === schema.TableCellBackgroundDisplayMode.Basic) {
      textColor = getTextColorForAlphaBackground(displayValue.color, theme.isDark);
      bgColor = tinycolor__default.default(displayValue.color).toRgbString();
      bgHoverColor = tinycolor__default.default(displayValue.color).darken(CELL_COLOR_DARKENING_MULTIPLIER * darkeningFactor).toRgbString();
    } else if (mode === schema.TableCellBackgroundDisplayMode.Gradient) {
      const hoverColor = tinycolor__default.default(displayValue.color).darken(CELL_GRADIENT_DARKENING_MULTIPLIER * darkeningFactor).toRgbString();
      const bgColor2 = tinycolor__default.default(displayValue.color).darken(CELL_COLOR_DARKENING_MULTIPLIER * darkeningFactor).spin(CELL_GRADIENT_HUE_ROTATION_DEGREES);
      textColor = getTextColorForAlphaBackground(displayValue.color, theme.isDark);
      bgColor = `linear-gradient(120deg, ${bgColor2.toRgbString()}, ${displayValue.color})`;
      bgHoverColor = `linear-gradient(120deg, ${bgColor2.toRgbString()}, ${hoverColor})`;
    }
  }
  return { textColor, bgColor, bgHoverColor };
}
const extractPixelValue = (spacing) => {
  return typeof spacing === "number" ? spacing : parseFloat(spacing) || 0;
};
const convertRGBAToHex = (backgroundColor, rgbaColor) => {
  const bg = tinycolor__default.default(backgroundColor);
  const rgba = tinycolor__default.default(rgbaColor);
  return tinycolor__default.default.mix(bg, rgba, rgba.getAlpha() * 100).toHexString();
};
const getCellLinks = (field, rowIdx) => {
  let links;
  if (field.getLinks) {
    links = field.getLinks({
      valueRowIndex: rowIdx
    });
  }
  if (!links) {
    return;
  }
  for (let i = 0; i < (links == null ? void 0 : links.length); i++) {
    if (links[i].onClick) {
      const origOnClick = links[i].onClick;
      links[i].onClick = (event) => {
        if (!(event.ctrlKey || event.metaKey || event.shiftKey)) {
          event.preventDefault();
          origOnClick(event, {
            field,
            rowIndex: rowIdx
          });
        }
      };
    }
  }
  return links;
};
const handleSort = (columnKey, direction, isMultiSort, setSortColumns, sortColumnsRef) => {
  let currentSortColumn;
  const updatedSortColumns = sortColumnsRef.current.filter((column) => {
    const isCurrentColumn = column.columnKey === columnKey;
    if (isCurrentColumn) {
      currentSortColumn = column;
    }
    return !isCurrentColumn;
  });
  if (currentSortColumn && currentSortColumn.direction === "DESC") {
    setSortColumns(updatedSortColumns);
    sortColumnsRef.current = updatedSortColumns;
  } else {
    if (isMultiSort) {
      setSortColumns([...updatedSortColumns, { columnKey, direction }]);
      sortColumnsRef.current = [...updatedSortColumns, { columnKey, direction }];
    } else {
      setSortColumns([{ columnKey, direction }]);
      sortColumnsRef.current = [{ columnKey, direction }];
    }
  }
};
const frameToRecords = (frame) => {
  const fnBody = `
    const rows = Array(frame.length);
    const values = frame.fields.map(f => f.values);
    let rowCount = 0;
    for (let i = 0; i < frame.length; i++) {
      rows[rowCount] = {
        __depth: 0,
        __index: i,
        ${frame.fields.map((field, fieldIdx) => `${JSON.stringify(getDisplayName(field))}: values[${fieldIdx}][i]`).join(",")}
      };
      rowCount += 1;
      if (rows[rowCount-1]['Nested frames']){
        const childFrame = rows[rowCount-1]['Nested frames'];
        rows[rowCount] = {__depth: 1, __index: i, data: childFrame[0]}
        rowCount += 1;
      }
    }
    return rows;
  `;
  const convert = new Function("frame", fnBody);
  return convert(frame);
};
const compare = new Intl.Collator("en", { sensitivity: "base", numeric: true }).compare;
function getComparator(sortColumnType) {
  switch (sortColumnType) {
    // Handle sorting for frame type fields (sparklines)
    case data.FieldType.frame:
      return (a, b) => {
        var _a, _b;
        return ((_a = a == null ? void 0 : a.value) != null ? _a : 0) - ((_b = b == null ? void 0 : b.value) != null ? _b : 0);
      };
    case data.FieldType.time:
    case data.FieldType.number:
    case data.FieldType.boolean:
      return (a, b) => {
        if (a === b) {
          return 0;
        }
        if (a == null) {
          return -1;
        }
        if (b == null) {
          return 1;
        }
        return Number(a) - Number(b);
      };
    case data.FieldType.string:
    case data.FieldType.enum:
    default:
      return (a, b) => compare(String(a != null ? a : ""), String(b != null ? b : ""));
  }
}
function migrateTableDisplayModeToCellOptions(displayMode) {
  switch (displayMode) {
    // In the case of the gauge we move to a different option
    case "basic":
    case "gradient-gauge":
    case "lcd-gauge":
      let gaugeMode = schema.BarGaugeDisplayMode.Basic;
      if (displayMode === "gradient-gauge") {
        gaugeMode = schema.BarGaugeDisplayMode.Gradient;
      } else if (displayMode === "lcd-gauge") {
        gaugeMode = schema.BarGaugeDisplayMode.Lcd;
      }
      return {
        type: schema.TableCellDisplayMode.Gauge,
        mode: gaugeMode
      };
    // Also true in the case of the color background
    case "color-background":
    case "color-background-solid":
      let mode = schema.TableCellBackgroundDisplayMode.Basic;
      if (displayMode === "color-background") {
        mode = schema.TableCellBackgroundDisplayMode.Gradient;
      }
      return {
        type: schema.TableCellDisplayMode.ColorBackground,
        mode
      };
    default:
      return {
        // @ts-ignore
        type: displayMode
      };
  }
}
const getIsNestedTable = (dataFrame) => dataFrame.fields.some(({ type }) => type === data.FieldType.nestedFrames);
const processNestedTableRows = (rows, processParents) => {
  const parentRows = [];
  const childRows = /* @__PURE__ */ new Map();
  rows.forEach((row) => {
    if (Number(row.__depth) === 0) {
      parentRows.push(row);
    } else {
      childRows.set(Number(row.__index), row);
    }
  });
  const processedParents = processParents(parentRows);
  const result = [];
  processedParents.forEach((row) => {
    result.push(row);
    const childRow = childRows.get(Number(row.__index));
    if (childRow) {
      result.push(childRow);
    }
  });
  return result;
};
const getDisplayName = (field) => {
  var _a, _b;
  return (_b = (_a = field.state) == null ? void 0 : _a.displayName) != null ? _b : field.name;
};

function calculateUniqueFieldValues(rows, field) {
  if (!field || rows.length === 0) {
    return {};
  }
  const set = {};
  for (let index = 0; index < rows.length; index++) {
    const row = rows[index];
    const fieldValue = row[getDisplayName(field)];
    const displayValue = field.display ? field.display(fieldValue) : fieldValue;
    const value = field.display ? data.formattedValueToString(displayValue) : displayValue;
    set[value || "(Blanks)"] = value;
  }
  return set;
}
function getFilteredOptions(options, filterValues) {
  if (!filterValues) {
    return [];
  }
  return options.filter((option) => filterValues.some((filtered) => filtered.value === option.value));
}
function valuesToOptions(unique) {
  return Object.keys(unique).map((key) => ({ value: unique[key], label: key })).sort(sortOptions);
}
function sortOptions(a, b) {
  if (a.label === void 0 && b.label === void 0) {
    return 0;
  }
  if (a.label === void 0 && b.label !== void 0) {
    return -1;
  }
  if (a.label !== void 0 && b.label === void 0) {
    return 1;
  }
  if (a.label < b.label) {
    return -1;
  }
  if (a.label > b.label) {
    return 1;
  }
  return 0;
}

const operatorSelectableValues = {
  Contains: { label: "Contains", value: "Contains", description: "Contains" },
  "=": { label: "=", value: "=", description: "Equals" },
  "!=": { label: "!=", value: "!=", description: "Not equals" },
  ">": { label: ">", value: ">", description: "Greater" },
  ">=": { label: ">=", value: ">=", description: "Greater or Equal" },
  "<": { label: "<", value: "<", description: "Less" },
  "<=": { label: "<=", value: "<=", description: "Less or Equal" },
  Expression: {
    label: "Expression",
    value: "Expression",
    description: 'Bool Expression (Char $ represents the column value in the expression, e.g. "$ >= 10 && $ <= 12")'
  }
};
const OPERATORS = Object.values(operatorSelectableValues);
const FilterPopup = ({
  name,
  rows,
  filterValue,
  setFilter,
  onClose,
  field,
  searchFilter,
  setSearchFilter,
  operator,
  setOperator
}) => {
  const theme = useTheme2();
  const uniqueValues = React.useMemo(() => calculateUniqueFieldValues(rows, field), [rows, field]);
  const options = React.useMemo(() => valuesToOptions(uniqueValues), [uniqueValues]);
  const filteredOptions = React.useMemo(() => getFilteredOptions(options, filterValue), [options, filterValue]);
  const [values, setValues] = React.useState(filteredOptions);
  const [matchCase, setMatchCase] = React.useState(false);
  const onCancel = React.useCallback((event) => onClose(), [onClose]);
  const onFilter = React.useCallback(
    (event) => {
      if (values.length !== 0) {
        const filteredSet = new Set(values.map((item) => item.value));
        setFilter((filter) => ({
          ...filter,
          [name]: { filtered: values, filteredSet, searchFilter, operator }
        }));
      } else {
        setFilter((filter) => {
          const newFilter = { ...filter };
          delete newFilter[name];
          return newFilter;
        });
      }
      onClose();
    },
    [setFilter, values, onClose]
    // eslint-disable-line react-hooks/exhaustive-deps
  );
  const onClearFilter = React.useCallback(
    (event) => {
      setFilter((filter) => {
        const newFilter = { ...filter };
        delete newFilter[name];
        return newFilter;
      });
      onClose();
    },
    [setFilter, onClose]
    // eslint-disable-line react-hooks/exhaustive-deps
  );
  const clearFilterVisible = React.useMemo(() => filterValue !== void 0, [filterValue]);
  const styles = useStyles2(getStyles$d);
  return /* @__PURE__ */ jsxRuntime.jsx(ClickOutsideWrapper, { onClick: onCancel, useCapture: true, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.filterContainer, onClick: stopPropagation, children: /* @__PURE__ */ jsxRuntime.jsxs(Stack, { direction: "column", children: [
    /* @__PURE__ */ jsxRuntime.jsxs(Stack, { alignItems: "center", children: [
      field && /* @__PURE__ */ jsxRuntime.jsx(Label$1, { className: styles.label, children: field.config.displayName || field.name }),
      /* @__PURE__ */ jsxRuntime.jsx(
        ButtonSelect,
        {
          variant: "canvas",
          options: OPERATORS,
          onChange: setOperator,
          value: operator,
          tooltip: operator.description
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.listDivider }),
    /* @__PURE__ */ jsxRuntime.jsxs(Stack, { gap: 1, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        FilterInput,
        {
          placeholder: t("grafana-ui.table.filter-popup-input-placeholder", "Filter values"),
          onChange: setSearchFilter,
          value: searchFilter
        }
      ),
      /* @__PURE__ */ jsxRuntime.jsx(
        Button,
        {
          variant: "secondary",
          style: { color: matchCase ? theme.colors.text.link : theme.colors.text.disabled },
          onClick: () => {
            setMatchCase((s) => !s);
          },
          icon: "text-fields"
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntime.jsx(
      FilterList,
      {
        onChange: setValues,
        values,
        options,
        caseSensitive: matchCase,
        searchFilter,
        operator
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsxs(Stack, { gap: 3, children: [
      /* @__PURE__ */ jsxRuntime.jsxs(Stack, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(Button, { size: "sm", onClick: onFilter, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-apply", children: "Ok" }) }),
        /* @__PURE__ */ jsxRuntime.jsx(Button, { size: "sm", variant: "secondary", onClick: onCancel, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-cancel", children: "Cancel" }) })
      ] }),
      clearFilterVisible && /* @__PURE__ */ jsxRuntime.jsx(Stack, { children: /* @__PURE__ */ jsxRuntime.jsx(Button, { fill: "text", size: "sm", onClick: onClearFilter, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-clear", children: "Clear filter" }) }) })
    ] })
  ] }) }) });
};
const getStyles$d = (theme) => ({
  filterContainer: css.css({
    label: "filterContainer",
    width: "100%",
    minWidth: "250px",
    height: "100%",
    backgroundColor: theme.colors.background.primary,
    border: `1px solid ${theme.colors.border.weak}`,
    padding: theme.spacing(2),
    boxShadow: theme.shadows.z3,
    borderRadius: theme.shape.radius.default
  }),
  listDivider: css.css({
    label: "listDivider",
    width: "100%",
    borderTop: `1px solid ${theme.colors.border.medium}`
  }),
  label: css.css({
    marginBottom: 0
  })
});
const stopPropagation = (event) => {
  event.stopPropagation();
};

const ITEM_HEIGHT = 28;
const MIN_HEIGHT = ITEM_HEIGHT * 5;
const REGEX_OPERATOR = operatorSelectableValues["Contains"];
const XPR_OPERATOR = operatorSelectableValues["Expression"];
const comparableValue = (value) => {
  value = value.trim().replace(/\\/g, "");
  if (/^(\d{4}-\d{2}-\d{2}|\d{4}\/\d{2}\/\d{2})/.test(value)) {
    const date = new Date(value);
    if (!isNaN(date.getTime())) {
      const fmt = data.getValueFormat("dateTimeAsIso");
      return data.formattedValueToString(fmt(date.getTime()));
    }
  }
  const num = parseFloat(value);
  if (!isNaN(num)) {
    return num;
  }
  const lvalue = value.toLowerCase();
  if (lvalue === "true" || lvalue === "false") {
    return lvalue === "true";
  }
  return value;
};
const FilterList = ({ options, values, caseSensitive, onChange, searchFilter, operator }) => {
  const regex = React.useMemo(() => new RegExp(searchFilter, caseSensitive ? void 0 : "i"), [searchFilter, caseSensitive]);
  const items = React.useMemo(
    () => options.filter((option) => {
      if (!searchFilter || operator.value === REGEX_OPERATOR.value) {
        if (option.label === void 0) {
          return false;
        }
        return regex.test(option.label);
      } else if (operator.value === XPR_OPERATOR.value) {
        if (option.value === void 0) {
          return false;
        }
        try {
          const xpr = searchFilter.replace(/\\/g, "");
          const fnc = new Function("$", `'use strict'; return ${xpr};`);
          const val = comparableValue(option.value);
          return fnc(val);
        } catch (_) {
        }
        return false;
      } else {
        if (option.value === void 0) {
          return false;
        }
        const value1 = comparableValue(option.value);
        const value2 = comparableValue(searchFilter);
        switch (operator.value) {
          case "=":
            return value1 === value2;
          case "!=":
            return value1 !== value2;
          case ">":
            return value1 > value2;
          case ">=":
            return value1 >= value2;
          case "<":
            return value1 < value2;
          case "<=":
            return value1 <= value2;
        }
        return false;
      }
    }),
    [options, regex, operator, searchFilter]
  );
  const selectedItems = React.useMemo(() => items.filter((item) => values.includes(item)), [items, values]);
  const selectCheckValue = React.useMemo(() => items.length === selectedItems.length, [items, selectedItems]);
  const selectCheckIndeterminate = React.useMemo(
    () => selectedItems.length > 0 && items.length > selectedItems.length,
    [items, selectedItems]
  );
  const selectCheckLabel = React.useMemo(
    () => selectedItems.length ? `${selectedItems.length} selected` : `Select all`,
    [selectedItems]
  );
  const selectCheckDescription = React.useMemo(
    () => items.length !== selectedItems.length ? "Add all displayed values to the filter" : "Remove all displayed values from the filter",
    [items, selectedItems]
  );
  const styles = useStyles2(getStyles$c);
  const theme = useTheme2();
  const gutter = theme.spacing.gridSize;
  const height = React.useMemo(() => Math.min(items.length * ITEM_HEIGHT, MIN_HEIGHT) + gutter, [gutter, items.length]);
  const onCheckedChanged = React.useCallback(
    (option) => (event) => {
      const newValues = event.currentTarget.checked ? values.concat(option) : values.filter((c) => c.value !== option.value);
      onChange(newValues);
    },
    [onChange, values]
  );
  const onSelectChanged = React.useCallback(() => {
    if (items.length === selectedItems.length) {
      const newValues = values.filter((item) => !items.includes(item));
      onChange(newValues);
    } else {
      const newValues = [.../* @__PURE__ */ new Set([...values, ...items])];
      onChange(newValues);
    }
  }, [onChange, values, items, selectedItems]);
  return /* @__PURE__ */ jsxRuntime.jsx(Stack, { direction: "column", children: items.length > 0 ? /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      reactWindow.FixedSizeList,
      {
        height,
        itemCount: items.length,
        itemSize: ITEM_HEIGHT,
        itemData: { items, values: selectedItems, onCheckedChanged, className: styles.filterListRow },
        width: "100%",
        className: styles.filterList,
        children: ItemRenderer
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.filterListRow, children: /* @__PURE__ */ jsxRuntime.jsx(
      Checkbox,
      {
        value: selectCheckValue,
        indeterminate: selectCheckIndeterminate,
        label: selectCheckLabel,
        description: selectCheckDescription,
        onChange: onSelectChanged
      }
    ) })
  ] }) : /* @__PURE__ */ jsxRuntime.jsx(Label$1, { className: styles.noValuesLabel, children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.no-values-label", children: "No values" }) }) });
};
function ItemRenderer({ index, style, data: { onCheckedChanged, items, values, className } }) {
  const option = items[index];
  const { value, label } = option;
  const isChecked = values.find((s) => s.value === value) !== void 0;
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className, style, title: label, children: /* @__PURE__ */ jsxRuntime.jsx(Checkbox, { value: isChecked, label, onChange: onCheckedChanged(option) }) });
}
const getStyles$c = (theme) => ({
  filterList: css.css({
    label: "filterList",
    backgroundColor: theme.components.input.background,
    border: `1px solid ${theme.colors.border.medium}`,
    borderRadius: theme.shape.radius.default
  }),
  filterListRow: css.css({
    label: "filterListRow",
    cursor: "pointer",
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    padding: theme.spacing(0.5),
    ":hover": {
      backgroundColor: theme.colors.action.hover
    }
  }),
  selectDivider: css.css({
    label: "selectDivider",
    width: "100%",
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(0.5, 2)
  }),
  noValuesLabel: css.css({
    paddingTop: theme.spacing(1)
  })
});

const Filter = ({ name, rows, filter, setFilter, field, crossFilterOrder, crossFilterRows }) => {
  var _a, _b, _c;
  const filterValue = (_a = filter[name]) == null ? void 0 : _a.filtered;
  const filterIndex = crossFilterOrder.indexOf(name);
  let filteredRows;
  if (filterIndex > 0) {
    const previousFilterName = crossFilterOrder[filterIndex - 1];
    filteredRows = crossFilterRows[previousFilterName];
  } else if (filterIndex === -1 && crossFilterOrder.length > 0) {
    const previousFilterName = crossFilterOrder[crossFilterOrder.length - 1];
    filteredRows = crossFilterRows[previousFilterName];
  } else {
    filteredRows = rows;
  }
  const ref = React.useRef(null);
  const [isPopoverVisible, setPopoverVisible] = React.useState(false);
  const styles = useStyles2(getStyles$b);
  const filterEnabled = React.useMemo(() => Boolean(filterValue), [filterValue]);
  const onShowPopover = React.useCallback(() => setPopoverVisible(true), [setPopoverVisible]);
  const onClosePopover = React.useCallback(() => setPopoverVisible(false), [setPopoverVisible]);
  const [searchFilter, setSearchFilter] = React.useState(((_b = filter[name]) == null ? void 0 : _b.searchFilter) || "");
  const [operator, setOperator] = React.useState(((_c = filter[name]) == null ? void 0 : _c.operator) || REGEX_OPERATOR);
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "button",
    {
      className: css.cx(styles.headerFilter, filterEnabled ? styles.filterIconEnabled : styles.filterIconDisabled),
      ref,
      type: "button",
      onClick: onShowPopover,
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "filter" }),
        isPopoverVisible && ref.current && /* @__PURE__ */ jsxRuntime.jsx(
          Popover,
          {
            content: /* @__PURE__ */ jsxRuntime.jsx(
              FilterPopup,
              {
                name,
                rows: filteredRows,
                filterValue,
                setFilter,
                field,
                onClose: onClosePopover,
                searchFilter,
                setSearchFilter,
                operator,
                setOperator
              }
            ),
            placement: "bottom-start",
            referenceElement: ref.current,
            show: true
          }
        )
      ]
    }
  );
};
const getStyles$b = (theme) => ({
  headerFilter: css.css({
    background: "transparent",
    border: "none",
    label: "headerFilter",
    padding: 0
  }),
  filterIconEnabled: css.css({
    label: "filterIconEnabled",
    color: theme.colors.primary.text
  }),
  filterIconDisabled: css.css({
    label: "filterIconDisabled",
    color: theme.colors.text.disabled
  })
});

const HeaderCell = ({
  column,
  rows,
  field,
  onSort,
  direction,
  justifyContent,
  filter,
  setFilter,
  onColumnResize,
  headerCellRefs,
  crossFilterOrder,
  crossFilterRows,
  showTypeIcons
}) => {
  var _a, _b, _c, _d, _e, _f, _g;
  const styles = useStyles2(getStyles$a, justifyContent);
  const headerRef = React.useRef(null);
  const filterable = (_c = (_b = (_a = field.config) == null ? void 0 : _a.custom) == null ? void 0 : _b.filterable) != null ? _c : false;
  const displayName = getDisplayName(field);
  let isColumnFilterable = filterable;
  if (((_d = field.config.custom) == null ? void 0 : _d.filterable) !== filterable) {
    isColumnFilterable = ((_e = field.config.custom) == null ? void 0 : _e.filterable) || false;
  }
  if (!isColumnFilterable && filter[displayName]) {
    setFilter((filter2) => {
      const newFilter = { ...filter2 };
      delete newFilter[displayName];
      return newFilter;
    });
  }
  const handleSort = (event) => {
    const isMultiSort = event.shiftKey;
    onSort(column.key, direction === "ASC" ? "DESC" : "ASC", isMultiSort);
  };
  React.useLayoutEffect(() => {
    if (headerRef.current) {
      headerCellRefs.current[column.key] = headerRef.current;
    }
  }, [headerRef, column.key]);
  React.useEffect(() => {
    var _a2;
    const headerCellParent = (_a2 = headerRef.current) == null ? void 0 : _a2.parentElement;
    if (headerCellParent) {
      const lastElement = headerCellParent.lastElementChild;
      if (lastElement) {
        const handleMouseUp = () => {
          let newWidth = headerCellParent.clientWidth;
          onColumnResize == null ? void 0 : onColumnResize(column.key, newWidth);
        };
        lastElement.addEventListener("click", handleMouseUp);
        return () => {
          lastElement.removeEventListener("click", handleMouseUp);
        };
      }
    }
    return;
  }, [column]);
  return /* @__PURE__ */ jsxRuntime.jsxs(
    "div",
    {
      ref: headerRef,
      className: styles.headerCell,
      onKeyDown: (event) => {
        if (event.key === " ") {
          event.stopPropagation();
        }
      },
      children: [
        /* @__PURE__ */ jsxRuntime.jsxs("button", { className: styles.headerCellLabel, onClick: handleSort, children: [
          showTypeIcons && /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: getFieldTypeIcon(field), title: field == null ? void 0 : field.type, size: "sm" }),
          /* @__PURE__ */ jsxRuntime.jsx("div", { children: (_g = (_f = field.state) == null ? void 0 : _f.displayName) != null ? _g : column.name }),
          direction && (direction === "ASC" ? /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "arrow-up", size: "lg" }) : /* @__PURE__ */ jsxRuntime.jsx(Icon, { name: "arrow-down", size: "lg" }))
        ] }),
        isColumnFilterable && /* @__PURE__ */ jsxRuntime.jsx(
          Filter,
          {
            name: column.key,
            rows,
            filter,
            setFilter,
            field,
            crossFilterOrder: crossFilterOrder.current,
            crossFilterRows: crossFilterRows.current
          }
        )
      ]
    }
  );
};
const getStyles$a = (theme, justifyContent) => ({
  headerCell: css.css({
    display: "flex",
    gap: theme.spacing(0.5),
    justifyContent
  }),
  headerCellLabel: css.css({
    border: "none",
    padding: 0,
    background: "inherit",
    cursor: "pointer",
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    fontWeight: theme.typography.fontWeightMedium,
    display: "flex",
    alignItems: "center",
    color: theme.colors.text.secondary,
    gap: theme.spacing(1),
    "&:hover": {
      textDecoration: "underline",
      color: theme.colors.text.link
    }
  })
});

function RowExpander({ height, onCellExpand, isExpanded }) {
  const styles = useStyles2(getStyles$9, height);
  function handleKeyDown(e) {
    if (e.key === " " || e.key === "Enter") {
      e.preventDefault();
      onCellExpand();
    }
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.expanderCell, onClick: onCellExpand, onKeyDown: handleKeyDown, children: /* @__PURE__ */ jsxRuntime.jsx(
    Icon,
    {
      "aria-label": isExpanded ? "Collapse row" : "Expand row",
      name: isExpanded ? "angle-down" : "angle-right",
      size: "lg"
    }
  ) });
}
const getStyles$9 = (theme, rowHeight) => ({
  expanderCell: css.css({
    display: "flex",
    flexDirection: "column",
    justifyContent: "center",
    height: `${rowHeight}px`,
    cursor: "pointer"
  })
});

const FILTER_FOR_OPERATOR = "=";
const FILTER_OUT_OPERATOR = "!=";

const ActionsCell = ({ actions }) => {
  const styles = useStyles2(getStyles$8);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.buttonsGap, children: actions && actions.map((action, i) => /* @__PURE__ */ jsxRuntime.jsx(ActionButton, { action, variant: "secondary" }, i)) });
};
const getStyles$8 = (theme) => ({
  buttonsGap: css.css({
    display: "flex",
    gap: 6
  })
});

function AutoCell({ value, field, justifyContent, rowIdx, cellOptions }) {
  var _a;
  const styles = useStyles2(getStyles$7, justifyContent);
  const displayValue = field.display(value);
  const formattedValue = data.formattedValueToString(displayValue);
  const hasLinks = Boolean((_a = getCellLinks(field, rowIdx)) == null ? void 0 : _a.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.cell, children: hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(DataLinksContextMenu, { links: () => getCellLinks(field, rowIdx) || [], children: (api) => {
    if (api.openMenu) {
      return /* @__PURE__ */ jsxRuntime.jsx(
        "button",
        {
          className: css.cx(clearButtonStyle, getLinkStyle(styles, cellOptions, api.targetClassName)),
          onClick: api.openMenu,
          children: formattedValue
        }
      );
    } else {
      return /* @__PURE__ */ jsxRuntime.jsx("div", { className: getLinkStyle(styles, cellOptions, api.targetClassName), children: formattedValue });
    }
  } }) : formattedValue });
}
const getLinkStyle = (styles, cellOptions, targetClassName) => {
  if (cellOptions.type === schema.TableCellDisplayMode.Auto) {
    return css.cx(styles.linkCell, targetClassName);
  }
  return css.cx(styles.cellLinkForColoredCell, targetClassName);
};
const getStyles$7 = (theme, justifyContent) => ({
  cell: css.css({
    display: "flex",
    justifyContent,
    a: {
      color: "inherit"
    }
  }),
  cellLinkForColoredCell: css.css({
    cursor: "pointer",
    overflow: "hidden",
    textOverflow: "ellipsis",
    userSelect: "text",
    whiteSpace: "nowrap",
    fontWeight: theme.typography.fontWeightMedium,
    textDecoration: "underline"
  }),
  linkCell: css.css({
    cursor: "pointer",
    overflow: "hidden",
    textOverflow: "ellipsis",
    userSelect: "text",
    whiteSpace: "nowrap",
    color: theme.colors.text.link,
    fontWeight: theme.typography.fontWeightMedium,
    paddingRight: theme.spacing(1.5),
    a: {
      color: theme.colors.text.link
    },
    "&:hover": {
      textDecoration: "underline",
      color: theme.colors.text.link
    }
  })
});

const defaultScale = {
  mode: data.ThresholdsMode.Absolute,
  steps: [
    {
      color: "blue",
      value: -Infinity
    },
    {
      color: "green",
      value: 20
    }
  ]
};
const BarGaugeCell = ({ value, field, theme, height, width, rowIdx }) => {
  var _a, _b;
  const displayValue = field.display(value);
  const cellOptions = getCellOptions(field);
  const heightOffset = extractPixelValue(theme.spacing(1));
  let config = data.getFieldConfigWithMinMax(field, false);
  if (!config.thresholds) {
    config = {
      ...config,
      thresholds: defaultScale
    };
  }
  let barGaugeMode = schema.BarGaugeDisplayMode.Gradient;
  let valueDisplayMode = void 0;
  if (cellOptions.type === schema.TableCellDisplayMode.Gauge) {
    barGaugeMode = (_a = cellOptions.mode) != null ? _a : schema.BarGaugeDisplayMode.Gradient;
    valueDisplayMode = cellOptions.valueDisplayMode !== void 0 ? cellOptions.valueDisplayMode : schema.BarGaugeValueMode.Text;
  }
  const hasLinks = Boolean((_b = getCellLinks(field, rowIdx)) == null ? void 0 : _b.length);
  const alignmentFactors = getAlignmentFactor(field, displayValue, rowIdx);
  const renderComponent = (menuProps) => {
    const { openMenu } = menuProps;
    return /* @__PURE__ */ jsxRuntime.jsx(
      BarGauge,
      {
        width,
        height: height - heightOffset,
        field: config,
        display: field.display,
        text: { valueSize: 14 },
        value: displayValue,
        orientation: data.VizOrientation.Horizontal,
        theme,
        alignmentFactors,
        onClick: openMenu,
        itemSpacing: 1,
        lcdCellWidth: 8,
        displayMode: barGaugeMode,
        valueDisplayMode
      }
    );
  };
  return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(
    DataLinksContextMenu,
    {
      links: () => getCellLinks(field, rowIdx) || [],
      style: { display: "flex", width: "100%" },
      children: (api) => renderComponent(api)
    }
  ) : renderComponent({}) });
};

const DataLinksCell = ({ field, rowIdx }) => {
  const styles = useStyles2(getStyles$6);
  const links = getCellLinks(field, rowIdx);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { children: links && links.map((link, idx) => {
    return (
      // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
      /* @__PURE__ */ jsxRuntime.jsx("span", { className: styles.linkCell, onClick: link.onClick, children: /* @__PURE__ */ jsxRuntime.jsx("a", { href: link.href, target: link.target, children: link.title }) }, idx)
    );
  }) });
};
const getStyles$6 = (theme) => ({
  linkCell: css.css({
    cursor: "pointer",
    overflow: "hidden",
    textOverflow: "ellipsis",
    userSelect: "text",
    whiteSpace: "nowrap",
    color: theme.colors.text.link,
    fontWeight: theme.typography.fontWeightMedium,
    paddingRight: theme.spacing(1.5),
    a: {
      color: theme.colors.text.link
    },
    "&:hover": {
      textDecoration: "underline",
      color: theme.colors.text.link
    }
  })
});

function GeoCell({ value, justifyContent, height }) {
  const styles = useStyles2(getStyles$5);
  let disp = "";
  if (value instanceof geom.Geometry) {
    disp = new WKT__default.default().writeGeometry(value, {
      featureProjection: "EPSG:3857",
      dataProjection: "EPSG:4326"
    });
  } else if (value != null) {
    disp = `${value}`;
  }
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.cell, style: { justifyContent, height }, children: /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.cellText, style: { fontFamily: "monospace" }, children: disp }) });
}
const getStyles$5 = () => ({
  cell: css.css({
    height: "100%",
    display: "flex",
    alignItems: "center",
    padding: "0 8px"
  }),
  cellText: css.css({
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis"
  })
});

const DATALINKS_HEIGHT_OFFSET = 10;
const ImageCell = ({ cellOptions, field, height, justifyContent, value, rowIdx }) => {
  var _a;
  const calculatedHeight = height - DATALINKS_HEIGHT_OFFSET;
  const styles = useStyles2(getStyles$4, calculatedHeight, justifyContent);
  const hasLinks = Boolean((_a = getCellLinks(field, rowIdx)) == null ? void 0 : _a.length);
  const { text } = field.display(value);
  const { alt, title } = cellOptions.type === schema.TableCellDisplayMode.Image ? cellOptions : { alt: void 0, title: void 0 };
  const img = /* @__PURE__ */ jsxRuntime.jsx("img", { alt, src: text, className: styles.image, title });
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.imageContainer, children: hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(DataLinksContextMenu, { links: () => getCellLinks(field, rowIdx) || [], children: (api) => {
    if (api.openMenu) {
      return /* @__PURE__ */ jsxRuntime.jsx(
        "div",
        {
          onClick: api.openMenu,
          role: "button",
          tabIndex: 0,
          onKeyDown: (e) => {
            if (e.key === "Enter" && api.openMenu) {
              api.openMenu(e);
            }
          },
          children: img
        }
      );
    } else {
      return img;
    }
  } }) : img });
};
const getStyles$4 = (theme, height, justifyContent) => ({
  image: css.css({
    height,
    width: "auto"
  }),
  imageContainer: css.css({
    display: "flex",
    justifyContent
  })
});

const JSONCell = ({ value, justifyContent, field, rowIdx }) => {
  var _a;
  const styles = useStyles2(getStyles$3, justifyContent);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  let displayValue = value;
  if (typeof value === "string") {
    try {
      const parsed = JSON.parse(value);
      displayValue = JSON.stringify(parsed, null, " ");
    } catch (e) {
      displayValue = value;
    }
  } else {
    try {
      displayValue = JSON.stringify(value, null, " ");
    } catch (error) {
      displayValue = String(value);
    }
  }
  const hasLinks = Boolean((_a = getCellLinks(field, rowIdx)) == null ? void 0 : _a.length);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.jsonText, children: hasLinks ? /* @__PURE__ */ jsxRuntime.jsx(DataLinksContextMenu, { links: () => getCellLinks(field, rowIdx) || [], children: (api) => {
    if (api.openMenu) {
      return /* @__PURE__ */ jsxRuntime.jsx(Button, { className: css.cx(clearButtonStyle), onClick: api.openMenu, children: displayValue });
    } else {
      return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: displayValue });
    }
  } }) : displayValue });
};
const getStyles$3 = (theme, justifyContent) => ({
  jsonText: css.css({
    display: "flex",
    cursor: "pointer",
    fontFamily: "monospace",
    justifyContent
  })
});

const defaultSparklineCellConfig = {
  type: schema.TableCellDisplayMode.Sparkline,
  drawStyle: schema.GraphDrawStyle.Line,
  lineInterpolation: schema.LineInterpolation.Smooth,
  lineWidth: 1,
  fillOpacity: 17,
  gradientMode: schema.GraphGradientMode.Hue,
  pointSize: 2,
  barAlignment: schema.BarAlignment.Center,
  showPoints: schema.VisibilityMode.Never,
  hideValue: false
};
const SparklineCell = (props) => {
  var _a, _b, _c, _d;
  const { field, value, theme, timeRange, rowIdx, justifyContent, width } = props;
  const styles = useStyles2(getStyles$2, justifyContent);
  const sparkline = getSparkline(value);
  if (!sparkline) {
    return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: field.config.noValue || "no data" });
  }
  if (sparkline.x && !sparkline.x.config.interval && sparkline.x.values.length > 1) {
    sparkline.x.config.interval = sparkline.x.values[1] - sparkline.x.values[0];
  }
  sparkline.y.values = sparkline.y.values.map((v) => {
    if (!Number.isFinite(v)) {
      return null;
    } else {
      return v;
    }
  });
  const range = data.getMinMaxAndDelta(sparkline.y);
  sparkline.y.config.min = range.min;
  sparkline.y.config.max = range.max;
  sparkline.y.state = { range };
  sparkline.timeRange = timeRange;
  const cellOptions = getTableSparklineCellOptions(field);
  const config = {
    color: field.config.color,
    custom: {
      ...defaultSparklineCellConfig,
      ...cellOptions
    }
  };
  const hideValue = (_b = (_a = field.config.custom) == null ? void 0 : _a.cellOptions) == null ? void 0 : _b.hideValue;
  let valueWidth = 0;
  let valueElement = null;
  if (!hideValue) {
    const newValue = data.isDataFrameWithValue(value) ? value.value : null;
    const displayValue = field.display(newValue);
    const alignmentFactor = getAlignmentFactor(field, displayValue, rowIdx);
    valueWidth = measureText(`${(_c = alignmentFactor.prefix) != null ? _c : ""}${alignmentFactor.text}${(_d = alignmentFactor.suffix) != null ? _d : ""}`, 16).width + theme.spacing.gridSize;
    valueElement = /* @__PURE__ */ jsxRuntime.jsx(
      FormattedValueDisplay,
      {
        style: {
          width: `${valueWidth - theme.spacing.gridSize}px`,
          textAlign: "right",
          marginRight: theme.spacing(1)
        },
        className: styles.valueContainer,
        value: displayValue
      }
    );
  }
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.cellContainer, children: [
    valueElement,
    /* @__PURE__ */ jsxRuntime.jsx(Sparkline, { width: width - valueWidth, height: 25, sparkline, config, theme })
  ] });
};
function getSparkline(value) {
  if (Array.isArray(value)) {
    return {
      y: {
        name: "test",
        type: data.FieldType.number,
        values: value,
        config: {}
      }
    };
  }
  if (data.isDataFrame(value)) {
    const timeField = value.fields.find((x) => x.type === data.FieldType.time);
    const numberField = value.fields.find((x) => x.type === data.FieldType.number);
    if (timeField && numberField) {
      return { x: timeField, y: numberField };
    }
  }
  return;
}
function getTableSparklineCellOptions(field) {
  let options = getCellOptions(field);
  if (options.type === schema.TableCellDisplayMode.Auto) {
    options = { ...options, type: schema.TableCellDisplayMode.Sparkline };
  }
  if (options.type === schema.TableCellDisplayMode.Sparkline) {
    return options;
  }
  throw new Error(`Expected options type ${schema.TableCellDisplayMode.Sparkline} but got ${options.type}`);
}
const getStyles$2 = (theme, justifyContent) => ({
  cellContainer: css.css({
    display: "flex",
    width: "100%",
    alignItems: "center",
    justifyContent
  }),
  valueContainer: css.css({
    div: { width: "inherit" }
  })
});

function TableCellNG(props) {
  var _a, _b, _c, _d, _e;
  const {
    field,
    frame,
    value,
    theme,
    timeRange,
    height,
    rowIdx,
    justifyContent,
    shouldTextOverflow,
    setIsInspecting,
    setContextMenuProps,
    getActions,
    rowBg,
    onCellFilterAdded,
    replaceVariables
  } = props;
  const cellInspect = (_c = (_b = (_a = field.config) == null ? void 0 : _a.custom) == null ? void 0 : _b.inspect) != null ? _c : false;
  const displayName = getDisplayName(field);
  const { config: fieldConfig } = field;
  const defaultCellOptions = { type: schema.TableCellDisplayMode.Auto };
  const cellOptions = (_e = (_d = fieldConfig.custom) == null ? void 0 : _d.cellOptions) != null ? _e : defaultCellOptions;
  const { type: cellType } = cellOptions;
  const showFilters = field.config.filterable && onCellFilterAdded;
  const isRightAligned = getTextAlign(field) === "flex-end";
  const displayValue = field.display(value);
  let colors = { bgColor: "", textColor: "", bgHoverColor: "" };
  if (rowBg) {
    colors = rowBg(rowIdx);
  } else {
    colors = React.useMemo(() => getCellColors(theme, cellOptions, displayValue), [theme, cellOptions, displayValue]);
  }
  const styles = useStyles2(getStyles$1, isRightAligned, colors);
  const divWidthRef = React.useRef(null);
  const [divWidth, setDivWidth] = React.useState(0);
  const [isHovered, setIsHovered] = React.useState(false);
  const actions = getActions ? getActions(frame, field, rowIdx, replaceVariables) : [];
  React.useLayoutEffect(() => {
    if (divWidthRef.current && divWidthRef.current.clientWidth !== 0) {
      setDivWidth(divWidthRef.current.clientWidth);
    }
  }, [divWidthRef.current]);
  const commonProps = {
    value,
    field,
    rowIdx,
    justifyContent
  };
  let cell = null;
  switch (cellType) {
    case schema.TableCellDisplayMode.Sparkline:
      cell = /* @__PURE__ */ jsxRuntime.jsx(SparklineCell, { ...commonProps, theme, timeRange, width: divWidth });
      break;
    case schema.TableCellDisplayMode.Gauge:
    case schema.TableCellDisplayMode.BasicGauge:
    case schema.TableCellDisplayMode.GradientGauge:
    case schema.TableCellDisplayMode.LcdGauge:
      cell = /* @__PURE__ */ jsxRuntime.jsx(BarGaugeCell, { ...commonProps, theme, timeRange, height, width: divWidth });
      break;
    case schema.TableCellDisplayMode.Image:
      cell = /* @__PURE__ */ jsxRuntime.jsx(ImageCell, { ...commonProps, cellOptions, height });
      break;
    case schema.TableCellDisplayMode.JSONView:
      cell = /* @__PURE__ */ jsxRuntime.jsx(JSONCell, { ...commonProps });
      break;
    case schema.TableCellDisplayMode.DataLinks:
      cell = /* @__PURE__ */ jsxRuntime.jsx(DataLinksCell, { field, rowIdx });
      break;
    case schema.TableCellDisplayMode.Actions:
      cell = /* @__PURE__ */ jsxRuntime.jsx(ActionsCell, { actions });
      break;
    case schema.TableCellDisplayMode.Custom:
      const CustomCellComponent = cellOptions.cellComponent;
      cell = /* @__PURE__ */ jsxRuntime.jsx(CustomCellComponent, { field, value, rowIndex: rowIdx, frame });
      break;
    case schema.TableCellDisplayMode.Auto:
    default:
      if (field.type === data.FieldType.geo) {
        cell = /* @__PURE__ */ jsxRuntime.jsx(GeoCell, { ...commonProps, height });
      } else if (field.type === data.FieldType.frame) {
        const firstValue = field.values[0];
        if (data.isDataFrame(firstValue) && data.isTimeSeriesFrame(firstValue)) {
          cell = /* @__PURE__ */ jsxRuntime.jsx(SparklineCell, { ...commonProps, theme, timeRange, width: divWidth });
        } else {
          cell = /* @__PURE__ */ jsxRuntime.jsx(JSONCell, { ...commonProps });
        }
      } else if (field.type === data.FieldType.other) {
        cell = /* @__PURE__ */ jsxRuntime.jsx(JSONCell, { ...commonProps });
      } else {
        cell = /* @__PURE__ */ jsxRuntime.jsx(AutoCell, { ...commonProps, cellOptions });
      }
      break;
  }
  const handleMouseEnter = () => {
    setIsHovered(true);
    if (shouldTextOverflow()) {
      const div = divWidthRef.current;
      const tableCellDiv = div == null ? void 0 : div.parentElement;
      tableCellDiv == null ? void 0 : tableCellDiv.style.setProperty("z-index", String(theme.zIndex.tooltip));
      tableCellDiv == null ? void 0 : tableCellDiv.style.setProperty("white-space", "pre-line");
      tableCellDiv == null ? void 0 : tableCellDiv.style.setProperty("min-height", `100%`);
      tableCellDiv == null ? void 0 : tableCellDiv.style.setProperty("height", `fit-content`);
      tableCellDiv == null ? void 0 : tableCellDiv.style.setProperty("background", colors.bgHoverColor || "none");
      tableCellDiv == null ? void 0 : tableCellDiv.style.setProperty("min-width", "min-content");
    }
  };
  const handleMouseLeave = () => {
    setIsHovered(false);
    if (shouldTextOverflow()) {
      const div = divWidthRef.current;
      const tableCellDiv = div == null ? void 0 : div.parentElement;
      tableCellDiv == null ? void 0 : tableCellDiv.style.removeProperty("z-index");
      tableCellDiv == null ? void 0 : tableCellDiv.style.removeProperty("white-space");
      tableCellDiv == null ? void 0 : tableCellDiv.style.removeProperty("min-height");
      tableCellDiv == null ? void 0 : tableCellDiv.style.removeProperty("height");
      tableCellDiv == null ? void 0 : tableCellDiv.style.removeProperty("background");
      tableCellDiv == null ? void 0 : tableCellDiv.style.removeProperty("min-width");
    }
  };
  const onFilterFor = React.useCallback(() => {
    if (onCellFilterAdded) {
      onCellFilterAdded({
        key: displayName,
        operator: FILTER_FOR_OPERATOR,
        value: String(value != null ? value : "")
      });
    }
  }, [displayName, onCellFilterAdded, value]);
  const onFilterOut = React.useCallback(() => {
    if (onCellFilterAdded) {
      onCellFilterAdded({
        key: displayName,
        operator: FILTER_OUT_OPERATOR,
        value: String(value != null ? value : "")
      });
    }
  }, [displayName, onCellFilterAdded, value]);
  return /* @__PURE__ */ jsxRuntime.jsxs("div", { ref: divWidthRef, onMouseEnter: handleMouseEnter, onMouseLeave: handleMouseLeave, className: styles.cell, children: [
    cell,
    isHovered && (cellInspect || showFilters) && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.cellActions, children: [
      cellInspect && /* @__PURE__ */ jsxRuntime.jsx(
        IconButton,
        {
          name: "eye",
          tooltip: t("grafana-ui.table.cell-inspect-tooltip", "Inspect value"),
          onClick: () => {
            let inspectValue = value;
            let mode = TableCellInspectorMode.text;
            if (field.type === data.FieldType.geo && value instanceof geom.Geometry) {
              inspectValue = new format.WKT().writeGeometry(value, {
                featureProjection: "EPSG:3857",
                dataProjection: "EPSG:4326"
              });
              mode = TableCellInspectorMode.code;
            } else if (cellType === schema.TableCellDisplayMode.JSONView) {
              mode = TableCellInspectorMode.code;
            }
            setContextMenuProps({
              value: String(inspectValue != null ? inspectValue : ""),
              mode
            });
            setIsInspecting(true);
          }
        }
      ),
      showFilters && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          IconButton,
          {
            name: "search-plus",
            onClick: onFilterFor,
            tooltip: t("grafana-ui.table.cell-filter-on", "Filter for value")
          }
        ),
        /* @__PURE__ */ jsxRuntime.jsx(
          IconButton,
          {
            name: "search-minus",
            onClick: onFilterOut,
            tooltip: t("grafana-ui.table.cell-filter-out", "Filter out value")
          }
        )
      ] })
    ] })
  ] });
}
const getStyles$1 = (theme, isRightAligned, color) => ({
  cell: css.css({
    height: "100%",
    alignContent: "center",
    paddingInline: "8px",
    // TODO: follow-up on this: change styles on hover on table row level
    background: color.bgColor || "none",
    color: color.textColor,
    "&:hover": { background: color.bgHoverColor }
  }),
  cellActions: css.css({
    display: "flex",
    position: "absolute",
    top: "1px",
    left: isRightAligned ? 0 : void 0,
    right: isRightAligned ? void 0 : 0,
    margin: "auto",
    height: "100%",
    background: theme.colors.background.secondary,
    color: theme.colors.text.primary,
    padding: "4px 0px 4px 4px"
  })
});

function TableNG(props) {
  var _a, _b;
  const {
    cellHeight,
    enablePagination,
    enableVirtualization = true,
    fieldConfig,
    footerOptions,
    height,
    initialSortBy,
    noHeader,
    onCellFilterAdded,
    onColumnResize,
    onSortByChange,
    width,
    data: data$1,
    enableSharedCrosshair,
    showTypeIcons,
    replaceVariables
  } = props;
  const initialSortColumns = React.useMemo(() => {
    const initialSort = initialSortBy == null ? void 0 : initialSortBy.map(({ displayName, desc }) => {
      const matchingField = data$1.fields.find(({ state }) => (state == null ? void 0 : state.displayName) === displayName);
      const columnKey = (matchingField == null ? void 0 : matchingField.name) || displayName;
      return {
        columnKey,
        direction: desc ? "DESC" : "ASC"
      };
    });
    return initialSort != null ? initialSort : [];
  }, []);
  const [revId, setRevId] = React.useState(0);
  const [contextMenuProps, setContextMenuProps] = React.useState(null);
  const [isInspecting, setIsInspecting] = React.useState(false);
  const [isContextMenuOpen, setIsContextMenuOpen] = React.useState(false);
  const [filter, setFilter] = React.useState({});
  const [page, setPage] = React.useState(0);
  const [, setResizeTrigger] = React.useState(0);
  const [, setReadyForRowHeightCalc] = React.useState(false);
  const [sortColumns, setSortColumns] = React.useState(initialSortColumns);
  const [expandedRows, setExpandedRows] = React.useState([]);
  const [isNestedTable, setIsNestedTable] = React.useState(false);
  const scrollPositionRef = React.useRef({ x: 0, y: 0 });
  const [hasScroll, setHasScroll] = React.useState(false);
  const crossFilterOrder = React.useRef([]);
  const crossFilterRows = React.useRef({});
  const headerCellRefs = React.useRef({});
  const sortColumnsRef = React.useRef(initialSortColumns);
  const prevProps = React.useRef(props);
  const calcsRef = React.useRef([]);
  const [paginationWrapperRef, { height: paginationHeight }] = reactUse.useMeasure();
  const theme = useTheme2();
  const panelContext = usePanelContext();
  const isFooterVisible = Boolean((footerOptions == null ? void 0 : footerOptions.show) && ((_a = footerOptions.reducer) == null ? void 0 : _a.length));
  const isCountRowsSet = Boolean(
    (footerOptions == null ? void 0 : footerOptions.countRows) && footerOptions.reducer && footerOptions.reducer.length && footerOptions.reducer[0] === data.ReducerID.count
  );
  const tableRef = React.useRef(null);
  React.useEffect(() => {
    var _a2, _b2;
    if (prevProps.current.data.fields.length !== props.data.fields.length || ((_a2 = prevProps.current.fieldConfig) == null ? void 0 : _a2.overrides) !== (fieldConfig == null ? void 0 : fieldConfig.overrides) || ((_b2 = prevProps.current.fieldConfig) == null ? void 0 : _b2.defaults) !== (fieldConfig == null ? void 0 : fieldConfig.defaults)) {
      setRevId(revId + 1);
    }
    prevProps.current = props;
  }, [props, revId, fieldConfig == null ? void 0 : fieldConfig.overrides, fieldConfig == null ? void 0 : fieldConfig.defaults]);
  React.useLayoutEffect(() => {
    if (!isContextMenuOpen) {
      return;
    }
    function onClick(event) {
      setIsContextMenuOpen(false);
    }
    addEventListener("click", onClick);
    return () => {
      removeEventListener("click", onClick);
    };
  }, [isContextMenuOpen]);
  React.useEffect(() => {
    const hasNestedFrames = getIsNestedTable(props.data);
    setIsNestedTable(hasNestedFrames);
  }, [props.data]);
  React.useEffect(() => {
    const el = tableRef.current;
    if (el) {
      const gridElement = el == null ? void 0 : el.element;
      if (gridElement) {
        setHasScroll(
          gridElement.scrollHeight > gridElement.clientHeight || gridElement.scrollWidth > gridElement.clientWidth
        );
      }
    }
  }, []);
  const columnWidth = React.useMemo(() => {
    var _a2, _b2;
    setRevId(revId + 1);
    return ((_b2 = (_a2 = fieldConfig == null ? void 0 : fieldConfig.defaults) == null ? void 0 : _a2.custom) == null ? void 0 : _b2.width) || "auto";
  }, [fieldConfig]);
  const defaultRowHeight = getDefaultRowHeight(theme, cellHeight);
  const defaultLineHeight = theme.typography.body.lineHeight * theme.typography.fontSize;
  const panelPaddingHeight = theme.components.panel.padding * theme.spacing.gridSize * 2;
  const rows = React.useMemo(() => frameToRecords(props.data), [frameToRecords, props.data]);
  const columnTypes = React.useMemo(
    () => props.data.fields.reduce((acc, field) => ({ ...acc, [getDisplayName(field)]: field.type }), {}),
    [props.data.fields]
  );
  const textWraps = React.useMemo(
    () => props.data.fields.reduce(
      (acc, field) => {
        var _a2, _b2, _c, _d;
        return {
          ...acc,
          [getDisplayName(field)]: (_d = (_c = (_b2 = (_a2 = field.config) == null ? void 0 : _a2.custom) == null ? void 0 : _b2.cellOptions) == null ? void 0 : _c.wrapText) != null ? _d : false
        };
      },
      {}
    ),
    [props.data.fields]
  );
  const textWrap = React.useMemo(() => Object.values(textWraps).some(Boolean), [textWraps]);
  const styles = useStyles2(getStyles);
  const getColumnWidths = React.useCallback(() => {
    const widths = {};
    props.data.fields.forEach((field) => {
      var _a2, _b2;
      const displayName = getDisplayName(field);
      const configWidth = (_b2 = (_a2 = field.config) == null ? void 0 : _a2.custom) == null ? void 0 : _b2.width;
      const totalWidth = typeof configWidth === "number" ? configWidth : COLUMN.DEFAULT_WIDTH;
      const contentWidth = totalWidth - 2 * TABLE.CELL_PADDING - 1;
      widths[displayName] = contentWidth;
    });
    Object.keys(headerCellRefs.current).forEach((key) => {
      const headerCell = headerCellRefs.current[key];
      if (headerCell.offsetWidth > 0) {
        widths[key] = headerCell.offsetWidth;
      }
    });
    return widths;
  }, [props.data.fields]);
  const headersLength = React.useMemo(() => {
    return props.data.fields.length;
  }, [props.data.fields]);
  const fieldDisplayType = React.useMemo(() => {
    return props.data.fields.reduce((acc, field) => {
      var _a2, _b2, _c;
      if ((_c = (_b2 = (_a2 = field.config) == null ? void 0 : _a2.custom) == null ? void 0 : _b2.cellOptions) == null ? void 0 : _c.type) {
        acc[getDisplayName(field)] = field.config.custom.cellOptions.type;
      }
      return acc;
    }, {});
  }, [props.data.fields]);
  const fieldsData = React.useMemo(
    () => ({
      headersLength,
      textWraps,
      columnTypes,
      fieldDisplayType,
      columnWidths: getColumnWidths()
    }),
    [textWraps, columnTypes, getColumnWidths, headersLength, fieldDisplayType]
  );
  const filteredRows = React.useMemo(() => {
    const filterValues = Object.entries(filter);
    if (filterValues.length === 0) {
      crossFilterOrder.current = [];
      return rows;
    }
    const getDisplayedValue = (row, key) => {
      const field = props.data.fields.find((field2) => getDisplayName(field2) === key);
      if (!field || !field.display) {
        return "";
      }
      const displayedValue = data.formattedValueToString(field.display(row[key]));
      return displayedValue;
    };
    const filterKeys = new Set(filterValues.map(([key]) => key));
    filterKeys.forEach((key) => {
      if (!crossFilterOrder.current.includes(key)) {
        crossFilterOrder.current.push(key);
      }
    });
    crossFilterOrder.current = crossFilterOrder.current.filter((key) => filterKeys.has(key));
    crossFilterRows.current = {};
    if (isNestedTable) {
      return processNestedTableRows(
        rows,
        (parents) => parents.filter((row) => {
          for (const [key, value] of filterValues) {
            const displayedValue = getDisplayedValue(row, key);
            if (!value.filteredSet.has(displayedValue)) {
              return false;
            }
            if (!crossFilterRows.current[key]) {
              crossFilterRows.current[key] = [row];
            } else {
              crossFilterRows.current[key].push(row);
            }
          }
          return true;
        })
      );
    }
    return rows.filter((row) => {
      for (const [key, value] of filterValues) {
        const displayedValue = getDisplayedValue(row, key);
        if (!value.filteredSet.has(displayedValue)) {
          return false;
        }
        if (!crossFilterRows.current[key]) {
          crossFilterRows.current[key] = [row];
        } else {
          crossFilterRows.current[key].push(row);
        }
      }
      return true;
    });
  }, [rows, filter, isNestedTable, props.data.fields]);
  const sortedRows = React.useMemo(() => {
    if (sortColumns.length === 0) {
      return filteredRows;
    }
    const compareRows = (a, b) => {
      let result = 0;
      for (let i = 0; i < sortColumns.length; i++) {
        const { columnKey, direction } = sortColumns[i];
        const compare = getComparator(columnTypes[columnKey]);
        const sortDir = direction === "ASC" ? 1 : -1;
        result = sortDir * compare(a[columnKey], b[columnKey]);
        if (result !== 0) {
          break;
        }
      }
      return result;
    };
    if (isNestedTable) {
      return processNestedTableRows(filteredRows, (parents) => [...parents].sort(compareRows));
    }
    return filteredRows.slice().sort((a, b) => compareRows(a, b));
  }, [filteredRows, sortColumns, columnTypes, isNestedTable]);
  const numRows = sortedRows.length;
  let headerCellHeight = TABLE.MAX_CELL_HEIGHT;
  if (noHeader) {
    headerCellHeight = 0;
  } else if (!noHeader && Object.keys(headerCellRefs.current).length > 0) {
    headerCellHeight = headerCellRefs.current[Object.keys(headerCellRefs.current)[0]].getBoundingClientRect().height;
  }
  let rowsPerPage = Math.floor(
    (height - headerCellHeight - TABLE.SCROLL_BAR_WIDTH - paginationHeight - panelPaddingHeight) / defaultRowHeight
  );
  if (isFooterVisible) {
    rowsPerPage -= 1;
  }
  if (rowsPerPage < 1) {
    rowsPerPage = 1;
  }
  const numberOfPages = Math.ceil(numRows / rowsPerPage);
  if (page > numberOfPages) {
    setPage(numberOfPages - 1);
  }
  const itemsRangeStart = page * rowsPerPage + 1;
  let displayedEnd = itemsRangeStart + rowsPerPage - 1;
  if (displayedEnd > numRows) {
    displayedEnd = numRows;
  }
  const smallPagination = width < TABLE.PAGINATION_LIMIT;
  const paginatedRows = React.useMemo(() => {
    const pageOffset = page * rowsPerPage;
    return sortedRows.slice(pageOffset, pageOffset + rowsPerPage);
  }, [rows, sortedRows, page, rowsPerPage]);
  React.useMemo(() => {
    calcsRef.current = props.data.fields.map((field, index) => {
      var _a2, _b2, _c;
      if ((_a2 = field.state) == null ? void 0 : _a2.calcs) {
        (_b2 = field.state) == null ? true : delete _b2.calcs;
      }
      if (isCountRowsSet) {
        return index === 0 ? `${sortedRows.length}` : "";
      }
      if (index === 0) {
        const footerCalcReducer = (_c = footerOptions == null ? void 0 : footerOptions.reducer) == null ? void 0 : _c[0];
        return footerCalcReducer ? data.fieldReducers.get(footerCalcReducer).name : "";
      }
      return getFooterItemNG(sortedRows, field, footerOptions);
    });
  }, [sortedRows, props.data.fields, footerOptions, isCountRowsSet]);
  const onCellExpand = (rowIdx) => {
    if (!expandedRows.includes(rowIdx)) {
      setExpandedRows([...expandedRows, rowIdx]);
    } else {
      setExpandedRows(expandedRows.filter((id) => id !== rowIdx));
    }
    setResizeTrigger((prev) => prev + 1);
  };
  const { ctx, avgCharWidth } = React.useMemo(() => {
    const font = `${theme.typography.fontSize}px ${theme.typography.fontFamily}`;
    const canvas = document.createElement("canvas");
    const ctx2 = canvas.getContext("2d");
    const letterSpacing = 0.15;
    ctx2.letterSpacing = `${letterSpacing}px`;
    ctx2.font = font;
    let txt = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s";
    const txtWidth = ctx2.measureText(txt).width;
    const avgCharWidth2 = txtWidth / txt.length + letterSpacing;
    return {
      ctx: ctx2,
      font,
      avgCharWidth: avgCharWidth2
    };
  }, [theme.typography.fontSize, theme.typography.fontFamily]);
  const columns = React.useMemo(
    () => mapFrameToDataGrid({
      frame: props.data,
      calcsRef,
      options: {
        columnTypes,
        textWraps,
        columnWidth,
        crossFilterOrder,
        crossFilterRows,
        defaultLineHeight,
        defaultRowHeight,
        expandedRows,
        filter,
        headerCellRefs,
        isCountRowsSet,
        onCellFilterAdded,
        ctx,
        onSortByChange,
        rows,
        setContextMenuProps,
        setFilter,
        setIsInspecting,
        setSortColumns,
        sortColumnsRef,
        styles,
        theme,
        showTypeIcons,
        replaceVariables,
        ...props
      },
      handlers: {
        onCellExpand,
        onColumnResize
      },
      // Adjust table width to account for the scroll bar width
      availableWidth: width - (hasScroll ? TABLE.SCROLL_BAR_WIDTH + TABLE.SCROLL_BAR_MARGIN : 0)
    }),
    [props.data, calcsRef, filter, expandedRows, expandedRows.length, footerOptions, width, hasScroll, sortedRows]
    // eslint-disable-line react-hooks/exhaustive-deps
  );
  React.useLayoutEffect(() => {
    setReadyForRowHeightCalc(Object.keys(headerCellRefs.current).length > 0);
  }, [columns]);
  const renderMenuItems = () => {
    return /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: /* @__PURE__ */ jsxRuntime.jsx(
      MenuItem,
      {
        label: t("grafana-ui.table.inspect-menu-label", "Inspect value"),
        onClick: () => {
          setIsInspecting(true);
        },
        className: styles.menuItem
      }
    ) });
  };
  const cellHeightCalc = React.useMemo(() => {
    return getCellHeightCalculator(ctx, defaultLineHeight, defaultRowHeight, TABLE.CELL_PADDING);
  }, [ctx, defaultLineHeight, defaultRowHeight]);
  const calculateRowHeight = React.useCallback(
    (row) => {
      var _a2, _b2, _c, _d, _e;
      if (Number(row.__depth) === 1 && !expandedRows.includes(Number(row.__index))) {
        return 0;
      } else if (Number(row.__depth) === 1 && expandedRows.includes(Number(row.__index))) {
        const headerCount = ((_c = (_b2 = (_a2 = row == null ? void 0 : row.data) == null ? void 0 : _a2.meta) == null ? void 0 : _b2.custom) == null ? void 0 : _c.noHeader) ? 0 : 1;
        const rowCount = (_e = (_d = row.data) == null ? void 0 : _d.length) != null ? _e : 0;
        return Math.max(defaultRowHeight, defaultRowHeight * (rowCount + headerCount));
      }
      return getRowHeight(row, cellHeightCalc, avgCharWidth, defaultRowHeight, fieldsData);
    },
    [expandedRows, avgCharWidth, defaultRowHeight, fieldsData, cellHeightCalc]
  );
  const handleScroll = (event) => {
    const target = event.currentTarget;
    scrollPositionRef.current = {
      x: target.scrollLeft,
      y: target.scrollTop
    };
  };
  React.useEffect(() => {
    if (initialSortColumns.length > 0) {
      setSortColumns(initialSortColumns);
    }
  }, [initialSortColumns]);
  React.useEffect(() => {
    var _a2;
    if ((_a2 = tableRef.current) == null ? void 0 : _a2.element) {
      tableRef.current.element.scrollLeft = scrollPositionRef.current.x;
      tableRef.current.element.scrollTop = scrollPositionRef.current.y;
    }
  }, [revId]);
  return /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx(
      DataGrid__default.default,
      {
        ref: tableRef,
        className: styles.dataGrid,
        enableVirtualization,
        rows: enablePagination ? paginatedRows : sortedRows,
        columns,
        headerRowHeight: noHeader ? 0 : void 0,
        defaultColumnOptions: {
          sortable: true,
          resizable: true
        },
        rowHeight: textWrap || isNestedTable ? calculateRowHeight : defaultRowHeight,
        style: { width, height: height - (enablePagination ? paginationHeight : 0) },
        renderers: {
          renderRow: (key, props2) => myRowRenderer(key, props2, expandedRows, panelContext, data$1, enableSharedCrosshair != null ? enableSharedCrosshair : false)
        },
        onScroll: handleScroll,
        onCellContextMenu: ({ row, column }, event) => {
          event.preventGridDefault();
          event.preventDefault();
          const cellValue = row[column.key];
          setContextMenuProps({
            // rowIdx: rows.indexOf(row),
            value: String(cellValue != null ? cellValue : ""),
            top: event.clientY,
            left: event.clientX
          });
          setIsContextMenuOpen(true);
        },
        sortColumns,
        bottomSummaryRows: isFooterVisible ? [{}] : void 0,
        onColumnResize: () => {
          if (textWrap) {
            setResizeTrigger((prev) => prev + 1);
          }
        }
      },
      `DataGrid${revId}`
    ),
    enablePagination && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: styles.paginationContainer, ref: paginationWrapperRef, children: [
      /* @__PURE__ */ jsxRuntime.jsx(
        Pagination,
        {
          className: "table-ng-pagination",
          currentPage: page + 1,
          numberOfPages,
          showSmallVersion: smallPagination,
          onNavigate: (toPage) => {
            setPage(toPage - 1);
          }
        }
      ),
      !smallPagination && /* @__PURE__ */ jsxRuntime.jsx("div", { className: styles.paginationSummary, children: /* @__PURE__ */ jsxRuntime.jsxs(Trans, { i18nKey: "grafana-ui.table.pagination-summary", children: [
        { itemsRangeStart },
        " - ",
        { displayedEnd },
        " of ",
        { numRows },
        " rows"
      ] }) })
    ] }),
    isContextMenuOpen && /* @__PURE__ */ jsxRuntime.jsx(
      ContextMenu,
      {
        x: (contextMenuProps == null ? void 0 : contextMenuProps.left) || 0,
        y: (contextMenuProps == null ? void 0 : contextMenuProps.top) || 0,
        renderMenuItems,
        focusOnOpen: false
      }
    ),
    isInspecting && /* @__PURE__ */ jsxRuntime.jsx(
      TableCellInspector,
      {
        mode: (_b = contextMenuProps == null ? void 0 : contextMenuProps.mode) != null ? _b : TableCellInspectorMode.text,
        value: contextMenuProps == null ? void 0 : contextMenuProps.value,
        onDismiss: () => {
          setIsInspecting(false);
          setContextMenuProps(null);
        }
      }
    )
  ] });
}
function mapFrameToDataGrid({
  frame,
  calcsRef,
  options,
  handlers,
  availableWidth
}) {
  const {
    columnTypes,
    textWraps,
    crossFilterOrder,
    crossFilterRows,
    defaultLineHeight,
    defaultRowHeight,
    expandedRows,
    filter,
    headerCellRefs,
    isCountRowsSet,
    onCellFilterAdded,
    ctx,
    onSortByChange,
    rows,
    setContextMenuProps,
    setFilter,
    setIsInspecting,
    setSortColumns,
    sortColumnsRef,
    styles,
    theme,
    timeRange,
    getActions,
    showTypeIcons,
    replaceVariables
  } = options;
  const { onCellExpand, onColumnResize } = handlers;
  const columns = [];
  const hasNestedFrames = getIsNestedTable(frame);
  if (hasNestedFrames) {
    const expanderField = {
      name: "",
      type: data.FieldType.other,
      config: {},
      values: []
    };
    columns.push({
      key: "expanded",
      name: "",
      field: expanderField,
      cellClass: styles.cell,
      colSpan(args) {
        return args.type === "ROW" && Number(args.row.__depth) === 1 ? frame.fields.length : 1;
      },
      renderCell: ({ row }) => {
        var _a, _b, _c;
        if (Number(row.__depth) === 0) {
          const rowIdx = Number(row.__index);
          return /* @__PURE__ */ jsxRuntime.jsx(
            RowExpander,
            {
              height: defaultRowHeight,
              onCellExpand: () => onCellExpand(rowIdx),
              isExpanded: expandedRows.includes(rowIdx)
            }
          );
        }
        let expandedColumns = [];
        let expandedRecords = [];
        if (row.data) {
          expandedColumns = mapFrameToDataGrid({
            frame: row.data,
            calcsRef,
            options: { ...options },
            handlers: { onCellExpand, onColumnResize },
            availableWidth
          });
          expandedRecords = frameToRecords(row.data);
        }
        return /* @__PURE__ */ jsxRuntime.jsx(
          DataGrid__default.default,
          {
            rows: expandedRecords,
            columns: expandedColumns,
            rowHeight: defaultRowHeight,
            className: styles.dataGrid,
            style: { height: "100%", overflow: "visible", marginLeft: COLUMN.EXPANDER_WIDTH - 1 },
            headerRowHeight: ((_c = (_b = (_a = row.data) == null ? void 0 : _a.meta) == null ? void 0 : _b.custom) == null ? void 0 : _c.noHeader) ? 0 : void 0
          }
        );
      },
      width: COLUMN.EXPANDER_WIDTH,
      minWidth: COLUMN.EXPANDER_WIDTH
    });
    availableWidth -= COLUMN.EXPANDER_WIDTH;
  }
  let rowBg = void 0;
  for (const field of frame.fields) {
    const fieldOptions = field.config.custom;
    const cellOptionsExist = fieldOptions !== void 0 && fieldOptions.cellOptions !== void 0;
    if (cellOptionsExist && fieldOptions.cellOptions.type === schema.TableCellDisplayMode.ColorBackground && fieldOptions.cellOptions.applyToRow) {
      rowBg = (rowIndex) => {
        const display = field.display(field.values[rowIndex]);
        const colors = getCellColors(theme, fieldOptions.cellOptions, display);
        return colors;
      };
    }
  }
  let fieldCountWithoutWidth = 0;
  frame.fields.map((field, fieldIndex) => {
    var _a;
    if (field.type === data.FieldType.nestedFrames || ((_a = field.config.custom) == null ? void 0 : _a.hidden)) {
      return;
    }
    const fieldTableOptions = field.config.custom || {};
    const key = getDisplayName(field);
    const justifyColumnContent = getTextAlign(field);
    const footerStyles = getFooterStyles(justifyColumnContent);
    if (fieldTableOptions.width) {
      availableWidth -= fieldTableOptions.width;
    } else {
      fieldCountWithoutWidth++;
    }
    columns.push({
      key,
      name: field.name,
      field,
      cellClass: textWraps[getDisplayName(field)] ? styles.cellWrapped : styles.cell,
      renderCell: (props) => {
        var _a2, _b, _c, _d;
        const { row } = props;
        const cellType = (_d = (_c = (_b = (_a2 = field.config) == null ? void 0 : _a2.custom) == null ? void 0 : _b.cellOptions) == null ? void 0 : _c.type) != null ? _d : schema.TableCellDisplayMode.Auto;
        const value = row[key];
        return /* @__PURE__ */ jsxRuntime.jsx(
          TableCellNG,
          {
            frame,
            value,
            field,
            theme,
            timeRange: timeRange != null ? timeRange : data.getDefaultTimeRange(),
            height: defaultRowHeight,
            justifyContent: justifyColumnContent,
            rowIdx: row.__index,
            shouldTextOverflow: () => shouldTextOverflow(
              key,
              row,
              columnTypes,
              headerCellRefs,
              ctx,
              defaultLineHeight,
              defaultRowHeight,
              TABLE.CELL_PADDING,
              textWraps[getDisplayName(field)],
              field,
              cellType
            ),
            setIsInspecting,
            setContextMenuProps,
            getActions,
            rowBg,
            onCellFilterAdded,
            replaceVariables
          },
          key
        );
      },
      renderSummaryCell: () => {
        if (isCountRowsSet && fieldIndex === 0) {
          return /* @__PURE__ */ jsxRuntime.jsxs("div", { style: { display: "flex", justifyContent: "space-between" }, children: [
            /* @__PURE__ */ jsxRuntime.jsx("span", { children: /* @__PURE__ */ jsxRuntime.jsx(Trans, { i18nKey: "grafana-ui.table.count", children: "Count" }) }),
            /* @__PURE__ */ jsxRuntime.jsx("span", { children: calcsRef.current[fieldIndex] })
          ] });
        }
        return /* @__PURE__ */ jsxRuntime.jsx("div", { className: footerStyles.footerCell, children: calcsRef.current[fieldIndex] });
      },
      renderHeaderCell: ({ column, sortDirection }) => /* @__PURE__ */ jsxRuntime.jsx(
        HeaderCell,
        {
          column,
          rows,
          field,
          onSort: (columnKey, direction, isMultiSort) => {
            handleSort(columnKey, direction, isMultiSort, setSortColumns, sortColumnsRef);
            if (onSortByChange) {
              const sortByFields = sortColumnsRef.current.map(({ columnKey: columnKey2, direction: direction2 }) => ({
                displayName: columnKey2,
                desc: direction2 === "DESC"
              }));
              onSortByChange(sortByFields);
            }
          },
          direction: sortDirection,
          justifyContent: justifyColumnContent,
          filter,
          setFilter,
          onColumnResize,
          headerCellRefs,
          crossFilterOrder,
          crossFilterRows,
          showTypeIcons
        }
      ),
      width: fieldTableOptions.width,
      minWidth: fieldTableOptions.minWidth || COLUMN.DEFAULT_WIDTH
    });
  });
  let sharedWidth = availableWidth / fieldCountWithoutWidth;
  for (let i = fieldCountWithoutWidth; i > 0; i--) {
    for (const column of columns) {
      if (!column.width && column.minWidth > sharedWidth) {
        column.width = column.minWidth;
        availableWidth -= column.width;
        fieldCountWithoutWidth -= 1;
        sharedWidth = availableWidth / fieldCountWithoutWidth;
      }
    }
  }
  for (const column of columns) {
    if (!column.width) {
      column.width = sharedWidth;
    }
    column.minWidth = COLUMN.MIN_WIDTH;
  }
  return columns;
}
function myRowRenderer(key, props, expandedRows, panelContext, data, enableSharedCrosshair) {
  const { row } = props;
  const rowIdx = Number(row.__index);
  const isExpanded = expandedRows.includes(rowIdx);
  if (Number(row.__depth) === 1 && !isExpanded) {
    return null;
  }
  if (row.data) {
    return /* @__PURE__ */ jsxRuntime.jsx(DataGrid.Row, { ...props, "aria-expanded": isExpanded }, key);
  }
  return /* @__PURE__ */ jsxRuntime.jsx(
    DataGrid.Row,
    {
      ...props,
      onMouseEnter: () => onRowHover(rowIdx, panelContext, data, enableSharedCrosshair),
      onMouseLeave: () => onRowLeave(panelContext, enableSharedCrosshair)
    },
    key
  );
}
function onRowHover(idx, panelContext, frame, enableSharedCrosshair) {
  if (!enableSharedCrosshair) {
    return;
  }
  const timeField = frame.fields.find((f) => f.type === data.FieldType.time);
  if (!timeField) {
    return;
  }
  panelContext.eventBus.publish(
    new data.DataHoverEvent({
      point: {
        time: timeField.values[idx]
      }
    })
  );
}
function onRowLeave(panelContext, enableSharedCrosshair) {
  if (!enableSharedCrosshair) {
    return;
  }
  panelContext.eventBus.publish(new data.DataHoverClearEvent());
}
const getStyles = (theme) => ({
  dataGrid: css.css({
    "--rdg-background-color": theme.colors.background.primary,
    "--rdg-header-background-color": theme.colors.background.primary,
    "--rdg-border-color": "transparent",
    "--rdg-color": theme.colors.text.primary,
    "&:hover": {
      "--rdg-row-hover-background-color": theme.colors.emphasize(theme.colors.action.hover, 0.6)
    },
    // If we rely solely on borderInlineEnd which is added from data grid, we
    // get a small gap where the gridCell borders meet the column header borders.
    // To avoid this, we can unset borderInlineEnd and set borderRight instead.
    ".rdg-cell": {
      borderInlineEnd: "unset",
      borderRight: `1px solid ${theme.colors.border.medium}`,
      "&:last-child": {
        borderRight: "none"
      }
    },
    ".rdg-summary-row": {
      backgroundColor: theme.colors.background.primary,
      "--rdg-summary-border-color": theme.colors.border.medium,
      ".rdg-cell": {
        // Prevent collisions with custom cell components
        zIndex: 2,
        borderRight: "none"
      }
    },
    // Due to stylistic choices, we do not want borders on the column headers
    // other than the bottom border.
    "div[role=columnheader]": {
      borderBottom: `1px solid ${theme.colors.border.medium}`,
      borderInlineEnd: "unset",
      ".r1y6ywlx7-0-0-beta-46": {
        "&:hover": {
          borderRight: `3px solid ${theme.colors.text.link}`
        }
      }
    },
    "::-webkit-scrollbar": {
      width: TABLE.SCROLL_BAR_WIDTH,
      height: TABLE.SCROLL_BAR_WIDTH
    },
    "::-webkit-scrollbar-thumb": {
      backgroundColor: "rgba(204, 204, 220, 0.16)",
      borderRadius: "4px"
    },
    "::-webkit-scrollbar-track": {
      background: "transparent"
    },
    "::-webkit-scrollbar-corner": {
      backgroundColor: "transparent"
    }
  }),
  menuItem: css.css({
    maxWidth: "200px"
  }),
  cell: css.css({
    "--rdg-border-color": theme.colors.border.medium,
    borderLeft: "none",
    whiteSpace: "nowrap",
    wordWrap: "break-word",
    overflow: "hidden",
    textOverflow: "ellipsis",
    // Reset default cell styles for custom cell component styling
    paddingInline: "0"
  }),
  cellWrapped: css.css({
    "--rdg-border-color": theme.colors.border.medium,
    borderLeft: "none",
    whiteSpace: "pre-line",
    wordWrap: "break-word",
    overflow: "hidden",
    textOverflow: "ellipsis",
    // Reset default cell styles for custom cell component styling
    paddingInline: "0"
  }),
  paginationContainer: css.css({
    alignItems: "center",
    display: "flex",
    justifyContent: "center",
    marginTop: "8px",
    width: "100%"
  }),
  paginationSummary: css.css({
    color: theme.colors.text.secondary,
    fontSize: theme.typography.bodySmall.fontSize,
    display: "flex",
    justifyContent: "flex-end",
    padding: theme.spacing(0, 1, 0, 2)
  })
});

exports.TableNG = TableNG;
exports.attachSkeleton = attachSkeleton;
exports.skeletonAnimation = skeletonAnimation;
exports.useTheme2 = useTheme2;
//# sourceMappingURL=unstable-Dqojcxnv.js.map
