export interface QueryHistoryPreference {
    /**
     * one of: '' | 'query' | 'starred';
     */
    homeTab?: string;
}
export interface CookiePreferences {
    analytics?: Record<string, unknown>;
    functional?: Record<string, unknown>;
    performance?: Record<string, unknown>;
}
export interface NavbarPreference {
    bookmarkUrls: Array<string>;
}
export declare const defaultNavbarPreference: Partial<NavbarPreference>;
/**
 * Spec defines user, team or org Grafana preferences
 * swagger:model Preferences
 */
export interface Preferences {
    /**
     * Cookie preferences
     */
    cookiePreferences?: CookiePreferences;
    /**
     * UID for the home dashboard
     */
    homeDashboardUID?: string;
    /**
     * Selected language (beta)
     */
    language?: string;
    /**
     * Selected locale (beta)
     */
    locale?: string;
    /**
     * Navigation preferences
     */
    navbar?: NavbarPreference;
    /**
     * Explore query history preferences
     */
    queryHistory?: QueryHistoryPreference;
    /**
     * light, dark, empty is default
     */
    theme?: string;
    /**
     * The timezone selection
     * TODO: this should use the timezone defined in common
     */
    timezone?: string;
    /**
     * day of the week (sunday, monday, etc)
     */
    weekStart?: string;
}
