import { jsx, jsxs } from 'react/jsx-runtime';
import { useCallback } from 'react';
import { t } from '../../utils/i18n.mjs';
import { IconButton } from '../IconButton/IconButton.mjs';
import { Stack } from '../Layout/Stack/Stack.mjs';
import { FILTER_FOR_OPERATOR, FILTER_OUT_OPERATOR } from './types.mjs';
import { getTextAlign } from './utils.mjs';

function CellActions({
  field,
  cell,
  previewMode,
  showFilters,
  onCellFilterAdded,
  setInspectCell
}) {
  var _a;
  const isRightAligned = getTextAlign(field) === "flex-end";
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const commonButtonProps = {
    size: "sm",
    tooltipPlacement: "top"
  };
  const onFilterFor = useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_FOR_OPERATOR, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  const onFilterOut = useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_OUT_OPERATOR, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  return /* @__PURE__ */ jsx("div", { className: `cellActions${isRightAligned ? " cellActionsLeft" : ""}`, children: /* @__PURE__ */ jsxs(Stack, { gap: 0.5, children: [
    inspectEnabled && /* @__PURE__ */ jsx(
      IconButton,
      {
        name: "eye",
        tooltip: t("grafana-ui.table.cell-inspect", "Inspect value"),
        onClick: () => {
          if (setInspectCell) {
            setInspectCell({ value: cell.value, mode: previewMode });
          }
        },
        ...commonButtonProps
      }
    ),
    showFilters && /* @__PURE__ */ jsx(
      IconButton,
      {
        name: "search-plus",
        onClick: onFilterFor,
        tooltip: t("grafana-ui.table.cell-filter-on", "Filter for value"),
        ...commonButtonProps
      }
    ),
    showFilters && /* @__PURE__ */ jsx(
      IconButton,
      {
        name: "search-minus",
        onClick: onFilterOut,
        tooltip: t("grafana-ui.table.cell-filter-out", "Filter out value"),
        ...commonButtonProps
      }
    )
  ] }) });
}

export { CellActions };
//# sourceMappingURL=CellActions.mjs.map
