import { jsx } from 'react/jsx-runtime';
import '@grafana/data';
import { useTheme2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { t } from '../../utils/i18n.mjs';
import { IconButton } from '../IconButton/IconButton.mjs';
import { getSelectStyles } from './getSelectStyles.mjs';

const MultiValueContainer = ({ innerProps, children }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ jsx("div", { ...innerProps, className: styles.multiValueContainer, children });
};
const MultiValueRemove = ({ children, innerProps }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ jsx(
    IconButton,
    {
      ...innerProps,
      name: "times",
      size: "sm",
      className: styles.multiValueRemove,
      tooltip: t("grafana-ui.select.multi-value-remove", "Remove")
    }
  );
};

export { MultiValueContainer, MultiValueRemove };
//# sourceMappingURL=MultiValue.mjs.map
