import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo } from 'react';
import '@grafana/data';
import '@grafana/e2e-selectors';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.mjs';
import { t, Trans } from '../../../utils/i18n.mjs';
import '../../FilterInput/FilterInput.mjs';
import '../../Icon/Icon.mjs';
import 'lodash';
import '../../Button/Button.mjs';
import '../../Button/ButtonGroup.mjs';
import '@tanstack/react-virtual';
import 'downshift';
import '../../Input/AutoSizeInput.mjs';
import '../../Input/Input.mjs';
import '../../Portal/Portal.mjs';
import '../../Forms/Checkbox.mjs';
import '../../ScrollContainer/ScrollContainer.mjs';
import '../../Layout/Box/Box.mjs';
import '../../Layout/Stack/Stack.mjs';
import '../../Text/Text.mjs';
import '../../Combobox/filter.mjs';
import '@floating-ui/react';
import '../../../utils/dom.mjs';
import '../../../utils/colors.mjs';
import 'slate';
import '../../../utils/logger.mjs';
import '../../Forms/Field.mjs';
import '../../Tabs/Tab.mjs';
import '../../Tabs/TabsBar.mjs';
import 'react-select';
import 'react-select/async';
import 'react-select/async-creatable';
import 'react-select/creatable';
import 'react-inlinesvg';
import '../../../utils/keyframes.mjs';
import '../../Select/IndicatorsContainer.mjs';
import '../../Select/InputControl.mjs';
import '../../IconButton/IconButton.mjs';
import '../../Select/getSelectStyles.mjs';
import '../../Select/SelectMenu.mjs';
import 'react-transition-group';
import '../../Select/ValueContainer.mjs';
import './TimePickerTitle.mjs';
import '../../Tooltip/Tooltip.mjs';
import './TimePickerCalendar.mjs';
import './TimeRangeOption.mjs';

const EmptyRecentList = memo(() => {
  const styles = useStyles2(getEmptyListStyles);
  const emptyRecentListText = t(
    "time-picker.content.empty-recent-list-info",
    "It looks like you haven't used this time picker before. As soon as you enter some time intervals, recently used intervals will appear here."
  );
  return /* @__PURE__ */ jsxs("div", { className: styles.container, children: [
    /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx("span", { children: emptyRecentListText }) }),
    /* @__PURE__ */ jsx(Trans, { i18nKey: "time-picker.content.empty-recent-list-docs", children: /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx(
        "a",
        {
          className: styles.link,
          href: "https://grafana.com/docs/grafana/latest/dashboards/time-range-controls",
          target: "_new",
          children: "Read the documentation"
        }
      ),
      /* @__PURE__ */ jsx("span", { children: " to find out more about how to enter custom time ranges." })
    ] }) })
  ] });
});
EmptyRecentList.displayName = "EmptyRecentList";
const getEmptyListStyles = (theme) => ({
  container: css({
    padding: "12px",
    margin: "12px",
    "a, span": {
      fontSize: "13px"
    }
  }),
  link: css({
    color: theme.colors.text.link
  })
});
//# sourceMappingURL=TimePickerContent.mjs.map
