import * as ui from '@grafana/schema';
export declare const pluginVersion = "12.0.2";
export interface Options extends ui.OptionsWithLegend, ui.OptionsWithTooltip, ui.OptionsWithTimezones {
    /**
     * Controls the column width
     */
    colWidth?: number;
    /**
     * Enables pagination when > 0
     */
    perPage?: number;
    /**
     * Set the height of the rows
     */
    rowHeight: number;
    /**
     * Show values on the columns
     */
    showValue: ui.VisibilityMode;
}
export declare const defaultOptions: Partial<Options>;
export interface FieldConfig extends ui.AxisConfig, ui.HideableFieldConfig {
    fillOpacity?: number;
    lineWidth?: number;
}
export declare const defaultFieldConfig: Partial<FieldConfig>;
