import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useTheme2, useStyles2 } from '../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.mjs';
import { EXPANDER_WIDTH } from '../utils.mjs';
import { Table } from './Table.mjs';

function ExpandedRow({ tableStyles, nestedData, rowIndex, width, cellHeight }) {
  const frames = nestedData.values;
  const subTables = [];
  const theme = useTheme2();
  const styles = useStyles2(getStyles);
  let top = tableStyles.rowHeight + theme.spacing.gridSize;
  frames[rowIndex].forEach((nf, nfIndex) => {
    var _a, _b;
    const noHeader = !!((_b = (_a = nf.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.noHeader);
    const height = tableStyles.rowHeight * (nf.length + (noHeader ? 0 : 1));
    const subTable = {
      height,
      paddingLeft: EXPANDER_WIDTH,
      position: "absolute",
      top,
      backgroundColor: theme.colors.background.primary,
      color: theme.colors.text.primary
    };
    top += height + theme.spacing.gridSize;
    subTables.push(
      /* @__PURE__ */ jsx("div", { style: subTable, children: /* @__PURE__ */ jsx(
        Table,
        {
          data: nf,
          width: width - EXPANDER_WIDTH,
          height: tableStyles.rowHeight * (nf.length + 1),
          noHeader,
          cellHeight
        }
      ) }, `subTable_${rowIndex}_${nfIndex}`)
    );
  });
  return /* @__PURE__ */ jsx("div", { className: styles.subTables, children: subTables });
}
const getStyles = (theme) => {
  return {
    subTables: css({
      "&:before": {
        content: '""',
        position: "absolute",
        width: "1px",
        top: theme.spacing(5),
        left: theme.spacing(1),
        bottom: theme.spacing(2),
        background: theme.colors.border.medium
      }
    })
  };
};
function getExpandedRowHeight(nestedData, rowIndex, tableStyles) {
  const frames = nestedData.values;
  const height = frames[rowIndex].reduce((acc, frame) => {
    var _a, _b;
    if (frame.length) {
      const noHeader = !!((_b = (_a = frame.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.noHeader);
      return acc + tableStyles.rowHeight * (frame.length + (noHeader ? 0 : 1)) + 8;
    }
    return acc;
  }, tableStyles.rowHeight);
  return height != null ? height : tableStyles.rowHeight;
}

export { ExpandedRow, getExpandedRowHeight };
//# sourceMappingURL=ExpandedRow.mjs.map
