import { createContext, useContext, useMemo } from 'react';
import { useObservable } from 'react-use';
import { Observable } from 'rxjs';

const ScopesContext = createContext(void 0);
function useScopes() {
  var _a;
  const context = useContext(ScopesContext);
  useObservable((_a = context == null ? void 0 : context.stateObservable) != null ? _a : new Observable(), context == null ? void 0 : context.state);
  return useMemo(() => {
    return context ? {
      state: context.state,
      stateObservable: context.stateObservable,
      changeScopes: context.changeScopes,
      setReadOnly: context.setReadOnly,
      setEnabled: context.setEnabled
    } : void 0;
  }, [context, context == null ? void 0 : context.state]);
}

export { ScopesContext, useScopes };
//# sourceMappingURL=ScopesContext.mjs.map
