import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useState, useCallback } from 'react';
import { useStyles2, useTheme2 } from '../../themes/ThemeContext.mjs';
import { Trans } from '../../utils/i18n.mjs';
import { Button } from '../Button/Button.mjs';
import '../Button/ButtonGroup.mjs';
import { Input } from '../Input/Input.mjs';
import { TagItem } from './TagItem.mjs';

const TagsInput = ({
  placeholder = "New tag (enter key to add)",
  tags = [],
  onChange,
  width,
  className,
  disabled,
  addOnBlur,
  invalid,
  id,
  autoColors = true
}) => {
  const [newTagName, setNewTagName] = useState("");
  const styles = useStyles2(getStyles);
  const theme = useTheme2();
  const onNameChange = useCallback((event) => {
    setNewTagName(event.target.value);
  }, []);
  const onRemove = (tagToRemove) => {
    onChange(tags.filter((x) => x !== tagToRemove));
  };
  const onAdd = (event) => {
    event == null ? void 0 : event.preventDefault();
    if (!tags.includes(newTagName)) {
      onChange(tags.concat(newTagName));
    }
    setNewTagName("");
  };
  const onBlur = () => {
    if (addOnBlur && newTagName) {
      onAdd();
    }
  };
  const onKeyboardAdd = (event) => {
    if (event.key === "Enter" && newTagName !== "") {
      onAdd(event);
    }
  };
  return /* @__PURE__ */ jsxs("div", { className: cx(styles.wrapper, className, width ? css({ width: theme.spacing(width) }) : ""), children: [
    /* @__PURE__ */ jsx(
      Input,
      {
        id,
        disabled,
        placeholder,
        onChange: onNameChange,
        value: newTagName,
        onKeyDown: onKeyboardAdd,
        onBlur,
        invalid,
        suffix: /* @__PURE__ */ jsx(
          Button,
          {
            fill: "text",
            className: styles.addButtonStyle,
            onClick: onAdd,
            size: "md",
            disabled: newTagName.length <= 0,
            children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.tags-input.add", children: "Add" })
          }
        )
      }
    ),
    (tags == null ? void 0 : tags.length) > 0 && /* @__PURE__ */ jsx("ul", { className: styles.tags, children: tags.map((tag) => /* @__PURE__ */ jsx(TagItem, { name: tag, onRemove, disabled, autoColors }, tag)) })
  ] });
};
const getStyles = (theme) => ({
  wrapper: css({
    minHeight: theme.spacing(4),
    display: "flex",
    flexDirection: "column",
    gap: theme.spacing(1),
    flexWrap: "wrap"
  }),
  tags: css({
    display: "flex",
    justifyContent: "flex-start",
    flexWrap: "wrap",
    gap: theme.spacing(0.5)
  }),
  addButtonStyle: css({
    margin: `0 -${theme.spacing(1)}`
  })
});

export { TagsInput };
//# sourceMappingURL=TagsInput.mjs.map
