import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useState } from 'react';
import { IconButton } from '../IconButton/IconButton.mjs';
import { Tab } from '../Tabs/Tab.mjs';
import { TabsBar } from '../Tabs/TabsBar.mjs';
import { TabContent } from '../Tabs/TabContent.mjs';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { Box } from '../Layout/Box/Box.mjs';
import { ScrollContainer } from '../ScrollContainer/ScrollContainer.mjs';

function TabbedContainer({ tabs, defaultTab, closeIconTooltip, onClose, testId }) {
  var _a;
  const [activeTab, setActiveTab] = useState(tabs.some((tab) => tab.value === defaultTab) ? defaultTab : tabs[0].value);
  const styles = useStyles2(getStyles);
  const onSelectTab = (item) => {
    setActiveTab(item.value);
  };
  return /* @__PURE__ */ jsxs("div", { className: styles.container, "data-testid": testId, children: [
    /* @__PURE__ */ jsxs(TabsBar, { className: styles.tabs, children: [
      tabs.map((t) => /* @__PURE__ */ jsx(
        Tab,
        {
          label: t.label,
          active: t.value === activeTab,
          onChangeTab: () => onSelectTab(t),
          icon: t.icon
        },
        t.value
      )),
      /* @__PURE__ */ jsx(Box, { grow: 1, display: "flex", justifyContent: "flex-end", paddingRight: 1, children: /* @__PURE__ */ jsx(IconButton, { size: "lg", onClick: onClose, name: "times", tooltip: closeIconTooltip != null ? closeIconTooltip : "Close" }) })
    ] }),
    /* @__PURE__ */ jsx(ScrollContainer, { children: /* @__PURE__ */ jsx(TabContent, { className: styles.tabContent, children: (_a = tabs.find((t) => t.value === activeTab)) == null ? void 0 : _a.content }) })
  ] });
}
const getStyles = (theme) => ({
  container: css({
    height: "100%",
    display: "flex",
    flexDirection: "column",
    flex: "1 1 0",
    minHeight: 0
  }),
  tabContent: css({
    padding: theme.spacing(2),
    backgroundColor: theme.colors.background.primary,
    flex: 1
  }),
  tabs: css({
    paddingTop: theme.spacing(0.5),
    borderColor: theme.colors.border.weak,
    ul: {
      marginLeft: theme.spacing(2)
    }
  })
});

export { TabbedContainer };
//# sourceMappingURL=TabbedContainer.mjs.map
