import { jsx } from 'react/jsx-runtime';
import { memo } from 'react';
import { getFieldDisplayName, getFieldSeriesColor } from '@grafana/data';
import { AxisPlacement } from '@grafana/schema';
import { useTheme2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { VizLayout } from '../VizLayout/VizLayout.mjs';
import { VizLegend } from '../VizLegend/VizLegend.mjs';
import { getDisplayValuesForCalcs } from './utils.mjs';

function hasVisibleLegendSeries(config, data) {
  return config.getSeries().some((s) => {
    var _a, _b, _c;
    const fieldIndex = s.props.dataFrameFieldIndex;
    if (!fieldIndex) {
      return false;
    }
    const field = (_a = data[fieldIndex.frameIndex]) == null ? void 0 : _a.fields[fieldIndex.fieldIndex];
    if (!field || ((_c = (_b = field.config.custom) == null ? void 0 : _b.hideFrom) == null ? void 0 : _c.legend)) {
      return false;
    }
    return true;
  });
}
const PlotLegend = memo(
  ({ data, config, placement, calcs, displayMode, ...vizLayoutLegendProps }) => {
    const theme = useTheme2();
    const legendItems = config.getSeries().map((s) => {
      var _a, _b, _c, _d;
      const seriesConfig = s.props;
      const fieldIndex = seriesConfig.dataFrameFieldIndex;
      const axisPlacement = config.getAxisPlacement(s.props.scaleKey);
      if (!fieldIndex) {
        return void 0;
      }
      const field = (_a = data[fieldIndex.frameIndex]) == null ? void 0 : _a.fields[fieldIndex.fieldIndex];
      if (!field || ((_c = (_b = field.config.custom) == null ? void 0 : _b.hideFrom) == null ? void 0 : _c.legend)) {
        return void 0;
      }
      const label = getFieldDisplayName(field, data[fieldIndex.frameIndex], data);
      const scaleColor = getFieldSeriesColor(field, theme);
      const seriesColor = scaleColor.color;
      return {
        disabled: !((_d = seriesConfig.show) != null ? _d : true),
        fieldIndex,
        color: seriesColor,
        label,
        yAxis: axisPlacement === AxisPlacement.Left || axisPlacement === AxisPlacement.Bottom ? 1 : 2,
        getDisplayValues: () => getDisplayValuesForCalcs(calcs, field, theme),
        getItemKey: () => `${label}-${fieldIndex.frameIndex}-${fieldIndex.fieldIndex}`,
        lineStyle: seriesConfig.lineStyle
      };
    }).filter((i) => i !== void 0);
    return /* @__PURE__ */ jsx(VizLayout.Legend, { placement, ...vizLayoutLegendProps, children: /* @__PURE__ */ jsx(
      VizLegend,
      {
        placement,
        items: legendItems,
        displayMode,
        sortBy: vizLayoutLegendProps.sortBy,
        sortDesc: vizLayoutLegendProps.sortDesc,
        isSortable: true
      }
    ) });
  }
);
PlotLegend.displayName = "PlotLegend";

export { PlotLegend, hasVisibleLegendSeries };
//# sourceMappingURL=PlotLegend.mjs.map
