import { jsx } from 'react/jsx-runtime';
import '../../../utils/dom.mjs';
import 'react';
import '../../../utils/colors.mjs';
import 'slate';
import { getCellLinks } from '../../../utils/table.mjs';
import 'lodash';
import '../../../utils/logger.mjs';

const DataLinksCell = (props) => {
  const { field, row, cellProps, tableStyles } = props;
  const links = getCellLinks(field, row);
  return /* @__PURE__ */ jsx("div", { ...cellProps, className: tableStyles.cellContainerText, children: links && links.map((link, idx) => {
    return (
      // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
      /* @__PURE__ */ jsx("span", { className: tableStyles.cellLink, onClick: link.onClick, children: /* @__PURE__ */ jsx("a", { href: link.href, target: link.target, children: link.title }) }, idx)
    );
  }) });
};

export { DataLinksCell };
//# sourceMappingURL=DataLinksCell.mjs.map
