import { jsxs, jsx } from 'react/jsx-runtime';
import { selectors } from '@grafana/e2e-selectors';
import { Label, Input, BrowserLabel } from '@grafana/ui';

function LabelSelector({
  nonMetricLabels,
  labelSearchTerm,
  onChangeLabelSearch,
  onClickLabel,
  styles
}) {
  return /* @__PURE__ */ jsxs("div", { className: styles.section, children: [
    /* @__PURE__ */ jsx(Label, { description: "Once label values are selected, only possible label combinations are shown.", children: "2. Select labels to search in" }),
    /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(
      Input,
      {
        onChange: onChangeLabelSearch,
        "aria-label": "Filter expression for label",
        value: labelSearchTerm,
        "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.labelNamesFilter
      }
    ) }),
    /* @__PURE__ */ jsx("div", { className: styles.list, style: { height: 120 }, children: nonMetricLabels.map((label) => /* @__PURE__ */ jsx(
      BrowserLabel,
      {
        name: label.name,
        loading: label.loading,
        active: label.selected,
        hidden: label.hidden,
        facets: label.facets,
        onClick: onClickLabel,
        searchTerm: labelSearchTerm
      },
      label.name
    )) })
  ] });
}

export { LabelSelector };
//# sourceMappingURL=LabelSelector.mjs.map
