import { jsxs, jsx } from 'react/jsx-runtime';
import { FixedSizeList } from 'react-window';
import { selectors } from '@grafana/e2e-selectors';
import { Label, Input, BrowserLabel } from '@grafana/ui';
import { LIST_ITEM_SIZE } from './types.mjs';

function ValueSelector({
  selectedLabels,
  valueSearchTerm,
  onChangeValueSearch,
  onClickValue,
  onClickLabel,
  styles
}) {
  return /* @__PURE__ */ jsxs("div", { className: styles.section, children: [
    /* @__PURE__ */ jsx(Label, { description: "Use the search field to find values across selected labels.", children: "3. Select (multiple) values for your labels" }),
    /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(
      Input,
      {
        onChange: onChangeValueSearch,
        "aria-label": "Filter expression for label values",
        value: valueSearchTerm,
        "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.labelValuesFilter
      }
    ) }),
    /* @__PURE__ */ jsx("div", { className: styles.valueListArea, children: selectedLabels.map((label) => {
      var _a, _b, _c;
      return /* @__PURE__ */ jsxs("div", { role: "list", "aria-label": `Values for ${label.name}`, className: styles.valueListWrapper, children: [
        /* @__PURE__ */ jsx("div", { className: styles.valueTitle, children: /* @__PURE__ */ jsx(
          BrowserLabel,
          {
            name: label.name,
            loading: label.loading,
            active: label.selected,
            hidden: label.hidden,
            facets: label.facets || ((_a = label.values) == null ? void 0 : _a.length),
            onClick: onClickLabel
          }
        ) }),
        /* @__PURE__ */ jsx(
          FixedSizeList,
          {
            height: Math.min(200, LIST_ITEM_SIZE * (((_b = label.values) == null ? void 0 : _b.length) || 0)),
            itemCount: ((_c = label.values) == null ? void 0 : _c.length) || 0,
            itemSize: 28,
            itemKey: (i) => label.values[i].name,
            width: 200,
            className: styles.valueList,
            children: ({ index, style }) => {
              var _a2;
              const value = (_a2 = label.values) == null ? void 0 : _a2[index];
              if (!value) {
                return null;
              }
              return /* @__PURE__ */ jsx("div", { style, children: /* @__PURE__ */ jsx(
                BrowserLabel,
                {
                  name: label.name,
                  value: value == null ? void 0 : value.name,
                  active: value == null ? void 0 : value.selected,
                  onClick: onClickValue,
                  searchTerm: valueSearchTerm
                }
              ) });
            }
          }
        )
      ] }, label.name);
    }) })
  ] });
}

export { ValueSelector };
//# sourceMappingURL=ValueSelector.mjs.map
