import { jsx, Fragment } from 'react/jsx-runtime';
import { ToolbarButton } from '../ToolbarButton/ToolbarButton.js';
import '../ToolbarButton/ToolbarButtonRow.js';
import { Tooltip } from '../Tooltip/Tooltip.js';
import 'react';

function TimeSyncButton(props) {
  const { onClick, isSynced } = props;
  const syncTimesTooltip = () => {
    const tooltip = isSynced ? "Unsync all views" : "Sync all views to this time range";
    return /* @__PURE__ */ jsx(Fragment, { children: tooltip });
  };
  return /* @__PURE__ */ jsx(Tooltip, { content: syncTimesTooltip, placement: "bottom", children: /* @__PURE__ */ jsx(
    ToolbarButton,
    {
      icon: "link",
      variant: isSynced ? "active" : "canvas",
      "aria-label": isSynced ? "Un sync times" : "Sync times",
      onClick
    }
  ) });
}

export { TimeSyncButton };
//# sourceMappingURL=TimeSyncButton.js.map
