import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';

const InlineSegmentGroup = ({ children, className, grow, ...htmlProps }) => {
  const styles = useStyles2(getStyles, grow);
  return /* @__PURE__ */ jsx("div", { className: cx(styles.container, className), ...htmlProps, children });
};
InlineSegmentGroup.displayName = "InlineSegmentGroup";
const getStyles = (theme, grow) => {
  return {
    container: css({
      display: "flex",
      flexDirection: "row",
      alignItems: "flex-start",
      textAlign: "left",
      position: "relative",
      flex: `${grow ? 1 : 0} 0 auto`,
      marginBottom: theme.spacing(0.5)
    })
  };
};

export { InlineSegmentGroup };
//# sourceMappingURL=InlineSegmentGroup.js.map
