---
aliases:
  - ../../../alerting-rules/manage-contact-points/configure-oncall/ # /docs/grafana/<GRAFANA_VERSION>/alerting/alerting-rules/manage-contact-points/configure-oncall/
  - ../../../alerting-rules/manage-contact-points/integrations/configure-oncall/ # /docs/grafana/<GRAFANA_VERSION>/alerting/alerting-rules/manage-contact-points/integrations/configure-oncall/
canonical: https://grafana.com/docs/grafana/latest/alerting/configure-notifications/manage-contact-points/integrations/configure-oncall/
description: Configure the Alerting - Grafana OnCall integration to connect alerts generated by Grafana Alerting with Grafana OnCall
keywords:
  - grafana
  - alerting
  - oncall
  - integration
aliases:
  - ../configure-oncall/ # /docs/grafana/<GRAFANA_VERSION>/alerting/alerting-rules/manage-contact-points/configure-oncall/
labels:
  products:
    - cloud
    - enterprise
    - oss
menuTitle: Grafana OnCall
title: Configure Grafana OnCall for Alerting
weight: 0
---

# Configure Grafana OnCall for Alerting

Use the Grafana Alerting - Grafana OnCall integration to effortlessly connect alerts generated by Grafana Alerting with Grafana OnCall, where you can then route them according to defined escalation chains and schedules.

{{< admonition type="note" >}}
You can also configure the integration from Grafana OnCall. For more information, refer to [Grafana OnCall documentation](http://grafana.com/docs/oncall/latest/integrations/grafana-alerting/).
{{< /admonition >}}

## Before you begin

Grafana OnCall is available in Grafana Cloud by default.

If you are using Grafana OSS, [install and enable the Grafana OnCall plugin](http://grafana.com/docs/oncall/latest/set-up/open-source/#install-grafana-oncall-oss). Also, ensure your version of Grafana is up-to-date and supports the new features.

## Procedure

To set up the Grafana OnCall integration using the Grafana Alerting application, complete the following steps.

1. Navigate to **Alerts & IRM** -> **Alerting** -> **Contact points**.
1. Click **+ Add contact point**.
1. Enter a contact point name.
1. From the **Integration** list, select **Grafana OnCall**.

   {{< admonition type="note" >}}
   The Grafana OnCall integration is only available for Grafana Alertmanager.
   {{< /admonition >}}

1. Choose whether to add a new OnCall integration or add an existing one.
   - If you add a new one, enter an Integration name.
   - If you add an existing one, choose from the list of available integrations.
1. Click **Save contact point**.
1. On the contact points list view page, you should see a link to Grafana OnCall.

   If the integration is not being used anywhere in the notification policies tree, it has **Unused** as its status in the **Health** column. It won’t receive any notifications, because there are no notifications using that integration.

1. To see the integration details and test the integration, click the link to Grafana OnCall on the contact points list view page.
1. Click **Send demo alert** > **Send alert**.
1. Go to Grafana OnCall **Alert Groups**. You should see the demo alert.

## Next steps

The OnCall contact point is ready to receive alert notifications.

To add the contact point to your alert rule, complete the following next steps:

1. In Grafana, navigate to **Alerting** > **Alert rules**.
1. Edit or create a new alert rule.
1. Scroll down to the **Configure labels and notifications** section.
1. Under **Notifications**, click **Select contact point**.
1. From the drop-down menu, select the contact point you created.
1. Click **Save rule and exit**.
