import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo, useState } from 'react';
import { FlexItem } from '@grafana/experimental';
import { useStyles2, Button, Select } from '@grafana/ui';
import { OperationInfoButton } from './OperationInfoButton.js';

const OperationHeader = memo(
  ({ operation, def, index, onChange, onRemove, queryModeller, dragHandleProps }) => {
    var _a;
    const styles = useStyles2(getStyles);
    const [state, setState] = useState({});
    const onToggleSwitcher = () => {
      if (state.isOpen) {
        setState({ ...state, isOpen: false });
      } else {
        const alternatives = queryModeller.getAlternativeOperations(def.alternativesKey).map((alt) => ({ label: alt.name, value: alt }));
        setState({ isOpen: true, alternatives });
      }
    };
    return /* @__PURE__ */ jsxs("div", { className: styles.header, children: [
      !state.isOpen && /* @__PURE__ */ jsxs(Fragment, { children: [
        /* @__PURE__ */ jsx("div", { ...dragHandleProps, children: (_a = def.name) != null ? _a : def.id }),
        /* @__PURE__ */ jsx(FlexItem, { grow: 1 }),
        /* @__PURE__ */ jsxs("div", { className: `${styles.operationHeaderButtons} operation-header-show-on-hover`, children: [
          /* @__PURE__ */ jsx(
            Button,
            {
              icon: "angle-down",
              size: "sm",
              onClick: onToggleSwitcher,
              fill: "text",
              variant: "secondary",
              title: "Click to view alternative operations"
            }
          ),
          /* @__PURE__ */ jsx(OperationInfoButton, { def, operation }),
          /* @__PURE__ */ jsx(
            Button,
            {
              icon: "times",
              size: "sm",
              onClick: () => onRemove(index),
              fill: "text",
              variant: "secondary",
              title: "Remove operation"
            }
          )
        ] })
      ] }),
      state.isOpen && /* @__PURE__ */ jsx("div", { className: styles.selectWrapper, children: /* @__PURE__ */ jsx(
        Select,
        {
          autoFocus: true,
          openMenuOnFocus: true,
          placeholder: "Replace with",
          options: state.alternatives,
          isOpen: true,
          onCloseMenu: onToggleSwitcher,
          onChange: (value) => {
            if (value.value) {
              const newDef = queryModeller.getOperationDef(value.value.id);
              const newParams = [...newDef.defaultParams];
              for (let i = 0; i < Math.min(operation.params.length, newParams.length); i++) {
                if (newDef.params[i].type === def.params[i].type) {
                  newParams[i] = operation.params[i];
                }
              }
              const changedOp = { ...operation, params: newParams, id: value.value.id };
              onChange(index, def.changeTypeHandler ? def.changeTypeHandler(changedOp, newDef) : changedOp);
            }
          }
        }
      ) })
    ] });
  }
);
OperationHeader.displayName = "OperationHeader";
const getStyles = (theme) => {
  return {
    header: css({
      borderBottom: `1px solid ${theme.colors.border.medium}`,
      padding: theme.spacing(0.5, 0.5, 0.5, 1),
      display: "flex",
      alignItems: "center"
    }),
    operationHeaderButtons: css({
      opacity: 1
    }),
    selectWrapper: css({
      paddingRight: theme.spacing(2)
    })
  };
};

export { OperationHeader };
//# sourceMappingURL=OperationHeader.js.map
