import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { useState } from 'react';
import { useTheme2, Button } from '@grafana/ui';
import { getStyles, queryAssistanttestIds } from './PromQail.js';
import { QuerySuggestionItem } from './QuerySuggestionItem.js';
import { SuggestionType } from './types.js';

function QuerySuggestionContainer(props) {
  const { suggestionType, querySuggestions, closeDrawer, nextInteraction, queryExplain, onChange, prompt } = props;
  const [hasNextInteraction, updateHasNextInteraction] = useState(false);
  const theme = useTheme2();
  const styles = getStyles(theme);
  let text, secondaryText, refineText;
  if (suggestionType === SuggestionType.Historical) {
    text = `Here are ${querySuggestions.length} query suggestions:`;
    refineText = "I want to write a prompt";
  } else if (suggestionType === SuggestionType.AI) {
    text = text = "Here is your query suggestion:";
    secondaryText = "This query is based off of natural language descriptions of the most commonly used PromQL queries.";
    refineText = "Refine prompt";
  }
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    suggestionType === SuggestionType.Historical ? /* @__PURE__ */ jsx("div", { className: styles.bottomMargin, children: text }) : /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx("div", { className: styles.textPadding, children: text }),
      /* @__PURE__ */ jsx("div", { className: cx(styles.secondaryText, styles.bottomMargin), children: secondaryText })
    ] }),
    /* @__PURE__ */ jsx("div", { className: styles.infoContainerWrapper, children: /* @__PURE__ */ jsx("div", { className: styles.infoContainer, children: querySuggestions.map((qs, idx) => {
      return /* @__PURE__ */ jsx(
        QuerySuggestionItem,
        {
          historical: suggestionType === SuggestionType.Historical,
          querySuggestion: qs,
          order: idx + 1,
          queryExplain,
          onChange,
          closeDrawer,
          last: idx === querySuggestions.length - 1,
          allSuggestions: querySuggestions.reduce((acc, qs2) => {
            return acc + "$$" + qs2.query;
          }, ""),
          prompt: prompt != null ? prompt : ""
        },
        idx
      );
    }) }) }),
    !hasNextInteraction && /* @__PURE__ */ jsxs("div", { className: styles.nextInteractionHeight, children: [
      /* @__PURE__ */ jsx("div", { className: cx(styles.afterButtons, styles.textPadding), children: /* @__PURE__ */ jsx(
        Button,
        {
          onClick: () => {
            updateHasNextInteraction(true);
            nextInteraction();
          },
          "data-testid": queryAssistanttestIds.refinePrompt,
          fill: "outline",
          variant: "secondary",
          size: "md",
          children: refineText
        }
      ) }),
      /* @__PURE__ */ jsx("div", { className: cx(styles.textPadding, styles.floatRight), children: /* @__PURE__ */ jsx(Button, { fill: "outline", variant: "secondary", size: "md", onClick: closeDrawer, children: "Cancel" }) })
    ] })
  ] });
}

export { QuerySuggestionContainer };
//# sourceMappingURL=QuerySuggestionContainer.js.map
