import { jsx } from 'react/jsx-runtime';
import { PureComponent, createRef } from 'react';
import { JsonExplorer } from './json_explorer/json_explorer.js';

class JSONFormatter extends PureComponent {
  constructor() {
    super(...arguments);
    this.wrapperRef = createRef();
    this.renderJson = () => {
      const { json, config, open, onDidRender } = this.props;
      const wrapperEl = this.wrapperRef.current;
      const formatter = new JsonExplorer(json, open, config);
      const hasChildren = wrapperEl.hasChildNodes();
      if (hasChildren) {
        wrapperEl.replaceChild(formatter.render(), wrapperEl.lastChild);
      } else {
        wrapperEl.appendChild(formatter.render());
      }
      if (onDidRender) {
        onDidRender(formatter.json);
      }
    };
  }
  componentDidMount() {
    this.renderJson();
  }
  componentDidUpdate() {
    this.renderJson();
  }
  render() {
    const { className } = this.props;
    return /* @__PURE__ */ jsx("div", { className, ref: this.wrapperRef });
  }
}
JSONFormatter.defaultProps = {
  open: 3,
  config: {
    animateOpen: true
  }
};

export { JSONFormatter };
//# sourceMappingURL=JSONFormatter.js.map
